// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   IsoWood Include File version 0.3                            %
// %                                                               %
// %   iw_textures.inc - pigments/color_maps for wood objects      %
// %                                                               %
// %   for POV-Ray version 3.5                                     %
// %                                                               %
// %   written August 2000 - August 2003                           %
// %   by Christoph Hormann <chris_hormann@gmx.de>                 %
// %   newest version can be found at                              %
// %   http://www.tu-bs.de/~y0013390/iso_wood.html                 %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   Feel free to use this file for your povray work, you are    %
// %   also allowed to modify and redistribute it as long as you   %
// %   leave these comments intact and highlight any changes you   %
// %   make.                                                       %
// %                                                               %
// %   I encourage you to contact me if you have ideas for         %
// %   improvements                                                %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   declarations in this file:                                  %
// %                                                               %
// %   Norm_W   standard normal (compatible with IsoWood 0.1)      %
// %   Fin_W    standard finish (compatible with IsoWood 0.1)      %
// %   Fin_W_01 alternative finish                                 %
// %   Fin_W_02 alternative finish                                 %
// %                                                               %
// %                                                               %
// %   P_IW_01 - P_IW_14:                                          %
// %            simple pigments (01-09 from IsoWood 0.1)           %
// %                                                               %
// %   CM_IW_01 - CM_IW_26                                         %
// %            mixed color_maps (01-02 from IsoWood 0.1)          %
// %                                                               %
// %   CM_IW_Maple_01 - CM_IW_Douglas_06                           %
// %            special color_maps for different types of wood     %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


//------------------------------------------------------------------

#include "teak.map"
#include "orngwood.map"
#include "whiteash.map"
#include "colors.inc"
#include "woods.inc"

#ifndef (Norm_W)
  #declare Norm_W =
    normal {
      bumps 0.0
    }
#end

#ifndef (Fin_W)
  #declare Fin_W =
    finish {
      ambient 0.08
      diffuse 0.95
      brilliance 1.2
      specular 0.2
      roughness 0.2
    }
#end

#declare Fin_W_01 =
   finish {
     ambient 0.08
     diffuse 0.95
     brilliance 1.6
     specular 0.3
     roughness 0.1
   }

#declare Fin_W_02 =
   finish {
     ambient 0.1
     diffuse 0.95
     brilliance 1.4
     specular 0.4
     roughness 0.02
   }

//------------------------------------------------------------------


#declare P_IW_01 =
   pigment {
     wood
     turbulence <0.05, 0.05, 0.4 >
     scale      <0.02, 0.02, 0.12>
   }

#declare P_IW_02 =
   pigment {
     wood
     turbulence <0.07, 0.07, 0.2 >
     scale      <0.03, 0.03, 0.07>
     translate  0.5*y
   }

#declare P_IW_03 =
  pigment {
    wood
    turbulence 0.2
    octaves 3
    scale <1/32, 5/100, 3/8>
  }


#declare P_IW_04 =
    pigment {
        wood
        octaves 4
        turbulence 0.08
        lambda 0.60
        scale  <0.06, 0.06, 0.9>
        rotate -1.000*x
    }

#declare P_IW_05 =
   pigment {
     wood
     omega 0.6
     turbulence <0.05, 0.05, 0.4>
     scale      <0.04, 0.04, 0.6>
   }

#declare P_IW_06 =
   pigment {
     wood
     turbulence <0.06, 0.06, 0.6>
     scale      <0.04, 0.04, 0.6>
   }


#declare P_IW_07 =
   pigment {
     wood
     octaves 4
     lambda 2.6
     turbulence <0.06, 0.06, 0.6>
     scale      <0.02, 0.02, 0.4>
   }

#declare P_IW_08 =
   pigment {
     wood
     octaves 4
     lambda 2.2
     turbulence <0.06, 0.06, 0.6>
     scale      <0.02, 0.02, 0.4>
   }

#declare P_IW_09 =
   pigment {
     wood
     octaves 3
     lambda 2.2
     omega 0.4
     turbulence <0.030, 0.030, 0.6>
     scale      <0.015, 0.015, 0.1>
   }

#declare P_IW_10 =
   pigment {
     wood
     octaves 6
     lambda 2.5
     turbulence <0.06, 0.06, 0.75>
     scale      <0.02, 0.02, 0.3>
   }

#declare P_IW_11 =
   pigment {
     wood
     octaves 6
     lambda 2.5
     turbulence <0.05, 0.05, 0.9>
     scale      <0.03, 0.03, 0.2>
   }

#declare P_IW_12 =
   pigment {
     wood
     octaves 5
     lambda 2.4
     omega 0.4
     turbulence <0.05, 0.05, 0.7>
     scale      <0.05, 0.05, 0.5>
   }

#declare P_IW_13 =
   pigment {
     wood
     lambda 2.2
     turbulence <0.05, 0.05, 0.4 >
     scale      <0.04, 0.04, 0.12>
   }

#declare P_IW_14 =
   pigment {
     wood
     octaves 4
     turbulence <0.07, 0.07, 0.4>
     lambda 0.80
     scale  <0.06, 0.06, 0.9>
   }

//------------------------------------------------------------------

#declare P_IW_A01 =
   pigment {
     gradient z
     //sine_wave
     triangle_wave

     pigment_map {
       [0.2 P_IW_01 color_map { [0 rgb 0.0][1 rgb 1.0] } ]
       [0.8 P_IW_01 color_map { [0 rgb 0.1][1 rgb 0.3] } ]
     }

   }

#declare P_IW_A02 =
   pigment {
     leopard

     turbulence 0.7
     lambda 2.2
     omega 0.52
     octaves 5

     pigment_map {
       [0.7 P_IW_07 color_map { [0 rgb 0.0][1 rgb 1.0] } ]
       [0.9 color rgb < 0.23, 0.2, 0.12 > ]
     }
   }

//------------------------------------------------------------------


#macro ColorCorrect(Color,Gamma, ColDiff)
    rgb <pow(Color.red+ColDiff.red,Gamma),pow(Color.green+ColDiff.green,Gamma),pow(Color.blue+ColDiff.blue,Gamma)>
#end

#ifndef (GammaFact)
  #declare GammaFact=1;
#end

#ifndef (ColorDiff)
  #declare ColorDiff=<0,0,0>;
#end

//------------------------------------------------------------------

#declare CM_IW_01 =
     color_map {
        [0.0 ColorCorrect(< 0.953, 0.878, 0.761 >, GammaFact, ColorDiff) ]
        [0.2 ColorCorrect(< 0.980, 0.851, 0.647 >, GammaFact, ColorDiff) ]
        [0.4 ColorCorrect(< 0.871, 0.776, 0.627 >, GammaFact, ColorDiff) ]
        [0.6 ColorCorrect(< 0.792, 0.698, 0.533 >, GammaFact, ColorDiff) ]
        [0.8 ColorCorrect(< 0.757, 0.580, 0.373 >, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(< 0.667, 0.459, 0.263 >, GammaFact, ColorDiff) ]
     }

#declare CM_IW_02 =
     color_map {
        [0.0 ColorCorrect(< 0.949, 0.792, 0.514 >, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(< 0.855, 0.651, 0.376 >, GammaFact, ColorDiff) ]
        [0.6 ColorCorrect(< 0.831, 0.596, 0.275 >, GammaFact, ColorDiff) ]
        [0.9 ColorCorrect(< 0.620, 0.447, 0.204 >, GammaFact, ColorDiff) ]
     }

//------------------------------------------------------------------


#declare CM_IW_03 = color_map {
     [ 0.0000 ColorCorrect(<0.6980, 0.5059, 0.2353>, GammaFact, ColorDiff) ]
     [ 0.0500 ColorCorrect(<0.6667, 0.4745, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.6980, 0.5059, 0.2392>, GammaFact, ColorDiff) ]
     [ 0.1500 ColorCorrect(<0.7725, 0.5882, 0.3255>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8157, 0.6471, 0.3961>, GammaFact, ColorDiff) ]
     [ 0.2500 ColorCorrect(<0.8078, 0.6471, 0.4039>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7961, 0.6392, 0.4000>, GammaFact, ColorDiff) ]
     [ 0.3500 ColorCorrect(<0.7843, 0.6275, 0.3843>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7843, 0.6275, 0.3843>, GammaFact, ColorDiff) ]
     [ 0.4500 ColorCorrect(<0.7843, 0.6314, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8000, 0.6510, 0.4196>, GammaFact, ColorDiff) ]
     [ 0.5500 ColorCorrect(<0.8039, 0.6588, 0.4275>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8118, 0.6667, 0.4471>, GammaFact, ColorDiff) ]
     [ 0.6500 ColorCorrect(<0.8157, 0.6706, 0.4549>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8078, 0.6706, 0.4549>, GammaFact, ColorDiff) ]
     [ 0.7500 ColorCorrect(<0.8078, 0.6667, 0.4471>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8039, 0.6706, 0.4431>, GammaFact, ColorDiff) ]
     [ 0.8500 ColorCorrect(<0.8000, 0.6745, 0.4510>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.7961, 0.6745, 0.4588>, GammaFact, ColorDiff) ]
     [ 0.9500 ColorCorrect(<0.8039, 0.6784, 0.4667>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8078, 0.6824, 0.4706>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_04 = color_map {
     [ 0.0000 ColorCorrect(<0.2980, 0.2196, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3373, 0.2471, 0.1608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.4706, 0.3451, 0.2157>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.5529, 0.3922, 0.2314>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6078, 0.4118, 0.2314>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.5451, 0.3843, 0.2471>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_05 = color_map {
     [ 0.0000 ColorCorrect(<0.2471, 0.1686, 0.1294>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.2627, 0.1647, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.3137, 0.2275, 0.1804>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.3725, 0.2392, 0.1647>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.4275, 0.2941, 0.2039>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.4431, 0.3059, 0.1882>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_06 = color_map {
     [ 0.0000 ColorCorrect(<0.3412, 0.2039, 0.1765>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3647, 0.2275, 0.1686>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.4039, 0.2627, 0.1608>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.5569, 0.4157, 0.2784>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6392, 0.4941, 0.3451>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6039, 0.4706, 0.3216>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_07 = color_map {
     [ 0.0000 ColorCorrect(<0.3451, 0.2314, 0.1725>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3843, 0.1922, 0.1255>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.4627, 0.2392, 0.1647>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.4941, 0.2863, 0.2157>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.5961, 0.3882, 0.3098>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6706, 0.4471, 0.3529>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_08 = color_map {
     [ 0.0000 ColorCorrect(<0.4902, 0.2431, 0.0863>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5373, 0.2863, 0.1098>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6510, 0.3569, 0.1216>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7569, 0.4039, 0.0627>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8039, 0.4627, 0.1098>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8118, 0.4784, 0.1451>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_09 = color_map {
     [ 0.0000 ColorCorrect(<0.2235, 0.0824, 0.0902>, GammaFact, ColorDiff) ]
     [ 0.1250 ColorCorrect(<0.2667, 0.0980, 0.0706>, GammaFact, ColorDiff) ]
     [ 0.2500 ColorCorrect(<0.4314, 0.2157, 0.1255>, GammaFact, ColorDiff) ]
     [ 0.3750 ColorCorrect(<0.5294, 0.2824, 0.1451>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.6118, 0.2902, 0.1137>, GammaFact, ColorDiff) ]
     [ 0.6250 ColorCorrect(<0.5451, 0.2471, 0.0784>, GammaFact, ColorDiff) ]
     [ 0.7500 ColorCorrect(<0.5804, 0.2824, 0.0863>, GammaFact, ColorDiff) ]
     [ 0.8750 ColorCorrect(<0.6314, 0.3216, 0.1098>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6235, 0.3176, 0.1294>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_10 = color_map {
     [ 0.0000 ColorCorrect(<0.5843, 0.2510, 0.2196>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5569, 0.2353, 0.2000>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.5843, 0.2510, 0.2000>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6667, 0.2902, 0.2235>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7059, 0.3098, 0.2275>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7216, 0.3176, 0.2353>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_11 = color_map {
     [ 0.0000 ColorCorrect(<0.5255, 0.2118, 0.1843>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.4667, 0.1686, 0.1686>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.5216, 0.1922, 0.1725>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6549, 0.2627, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6667, 0.2667, 0.2196>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6588, 0.2706, 0.2235>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_12 = color_map {
     [ 0.0000 ColorCorrect(<0.7176, 0.4353, 0.1373>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7176, 0.4510, 0.1412>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7373, 0.4667, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7569, 0.4784, 0.1725>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8039, 0.5333, 0.2510>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7843, 0.5294, 0.2706>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_13 = color_map {
     [ 0.0000 ColorCorrect(<0.7294, 0.4000, 0.1137>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7255, 0.4039, 0.0980>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7490, 0.4549, 0.1098>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7490, 0.4745, 0.1020>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8118, 0.5725, 0.1961>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8941, 0.6902, 0.3216>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9255, 0.7373, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9608, 0.7922, 0.4941>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9725, 0.8000, 0.5216>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9882, 0.8314, 0.5647>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9765, 0.8314, 0.5647>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_14 = color_map {
     [ 0.0000 ColorCorrect(<0.8667, 0.7137, 0.4118>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8745, 0.7216, 0.4235>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9255, 0.7725, 0.4863>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9529, 0.7961, 0.5255>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9529, 0.8039, 0.5294>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9490, 0.8039, 0.5294>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_15 = color_map {
     [ 0.0000 ColorCorrect(<0.8667, 0.7922, 0.7373>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8902, 0.8157, 0.7608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9490, 0.8745, 0.8196>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9686, 0.8980, 0.8235>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9765, 0.9059, 0.8275>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9882, 0.9176, 0.8392>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_16 = color_map {
     [ 0.0000 ColorCorrect(<0.6196, 0.3961, 0.0275>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5961, 0.3765, 0.0118>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6588, 0.4510, 0.0392>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6980, 0.4941, 0.0667>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7020, 0.5020, 0.0745>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6980, 0.5059, 0.0745>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_17 = color_map {
     [ 0.0000 ColorCorrect(<0.8549, 0.5020, 0.0039>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8824, 0.5137, 0.0000>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8980, 0.5725, 0.0000>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9255, 0.6902, 0.0471>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9333, 0.7294, 0.0941>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9255, 0.7216, 0.1412>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_18 = color_map {
     [ 0.0000 ColorCorrect(<0.7882, 0.3020, 0.0157>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.8078, 0.3725, 0.0078>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8510, 0.4784, 0.0157>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8863, 0.5686, 0.0275>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8980, 0.6235, 0.0353>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8980, 0.6706, 0.0235>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8980, 0.6824, 0.0196>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8980, 0.6902, 0.0196>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9020, 0.6902, 0.0196>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9020, 0.6863, 0.0118>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9059, 0.6784, 0.0000>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_19 = color_map {
     [ 0.0000 ColorCorrect(<0.6941, 0.4078, 0.1882>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7059, 0.4275, 0.2000>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7216, 0.4431, 0.2235>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7294, 0.4706, 0.2510>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7333, 0.5098, 0.2941>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7569, 0.5529, 0.3451>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_20 = color_map {
     [ 0.0000 ColorCorrect(<0.5804, 0.4471, 0.3098>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5804, 0.4510, 0.3137>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.5882, 0.4588, 0.3294>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6235, 0.5020, 0.3765>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6471, 0.5294, 0.4039>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6510, 0.5373, 0.4196>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_21 = color_map {
     [ 0.0000 ColorCorrect(<0.3451, 0.2745, 0.2353>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3569, 0.2824, 0.2471>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.3647, 0.2941, 0.2392>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.4078, 0.3412, 0.2588>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.4431, 0.3765, 0.2941>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.4314, 0.3569, 0.2980>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_22 = color_map {
     [ 0.0000 ColorCorrect(<0.6235, 0.5294, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6667, 0.5725, 0.4275>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6588, 0.5647, 0.4235>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6941, 0.6039, 0.4745>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7412, 0.6549, 0.5294>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6941, 0.6118, 0.4863>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_23 = color_map {
     [ 0.0000 ColorCorrect(<0.7490, 0.2980, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7451, 0.2941, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7216, 0.2824, 0.1333>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8980, 0.4353, 0.2431>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9255, 0.5020, 0.2824>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9647, 0.5216, 0.2667>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_24 = color_map {
     [ 0.0000 ColorCorrect(<0.5333, 0.1961, 0.1333>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5490, 0.2118, 0.1373>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6000, 0.2275, 0.1373>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6471, 0.2392, 0.1294>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6941, 0.2627, 0.1451>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7098, 0.2588, 0.1373>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_25 = color_map {
     [ 0.0000 ColorCorrect(<0.3922, 0.1529, 0.1059>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3922, 0.1490, 0.1098>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.4314, 0.1922, 0.1373>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.5059, 0.2392, 0.1686>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6039, 0.2510, 0.1569>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6588, 0.2588, 0.1529>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_26 = color_map {
     [ 0.0000 ColorCorrect(<0.2157, 0.1059, 0.0980>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.2706, 0.1176, 0.1020>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.3804, 0.1490, 0.1137>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.4314, 0.1686, 0.1176>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.4902, 0.1882, 0.1255>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.5373, 0.1922, 0.1255>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Maple_01 =
     color_map {
        [0.0 ColorCorrect(<0.9922, 0.8941, 0.7647>, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(<0.9647, 0.8431, 0.6588>, GammaFact, ColorDiff) ]
        [0.6 ColorCorrect(<0.9255, 0.7725, 0.5569>, GammaFact, ColorDiff) ]
        [0.9 ColorCorrect(<0.8627, 0.7059, 0.5020>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Maple_02 = color_map {
     [ 0.0000 ColorCorrect(<0.8314, 0.6745, 0.4745>, GammaFact, ColorDiff) ]
     [ 0.0500 ColorCorrect(<0.8549, 0.6980, 0.4941>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.8667, 0.7059, 0.5020>, GammaFact, ColorDiff) ]
     [ 0.1500 ColorCorrect(<0.8667, 0.6980, 0.4980>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8745, 0.7255, 0.5176>, GammaFact, ColorDiff) ]
     [ 0.2500 ColorCorrect(<0.9098, 0.7608, 0.5529>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.9176, 0.7569, 0.5451>, GammaFact, ColorDiff) ]
     [ 0.3500 ColorCorrect(<0.9255, 0.7725, 0.5569>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9451, 0.7961, 0.5725>, GammaFact, ColorDiff) ]
     [ 0.4500 ColorCorrect(<0.9412, 0.8078, 0.5961>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.9451, 0.8000, 0.5922>, GammaFact, ColorDiff) ]
     [ 0.5500 ColorCorrect(<0.9451, 0.8078, 0.6078>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9529, 0.8235, 0.6275>, GammaFact, ColorDiff) ]
     [ 0.6500 ColorCorrect(<0.9647, 0.8431, 0.6549>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9765, 0.8510, 0.6627>, GammaFact, ColorDiff) ]
     [ 0.7500 ColorCorrect(<0.9686, 0.8471, 0.6667>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9765, 0.8627, 0.6902>, GammaFact, ColorDiff) ]
     [ 0.8500 ColorCorrect(<0.9725, 0.8627, 0.6784>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9725, 0.8627, 0.6980>, GammaFact, ColorDiff) ]
     [ 0.9500 ColorCorrect(<0.9765, 0.8706, 0.7059>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9882, 0.8863, 0.7490>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Maple_03 = color_map {
     [ 0.0000 ColorCorrect(<0.8431, 0.5961, 0.3020>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.8627, 0.6275, 0.3451>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8980, 0.6784, 0.4196>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8980, 0.6784, 0.4314>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8980, 0.6824, 0.4275>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8941, 0.6902, 0.4314>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9059, 0.7059, 0.4471>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8941, 0.7059, 0.4627>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9059, 0.7294, 0.4941>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8980, 0.7059, 0.4706>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9098, 0.7294, 0.4980>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Maple_04 =
     color_map {
        [0.00 ColorCorrect(<0.9961, 0.8941, 0.8039>, GammaFact, ColorDiff) ]
        [0.25 ColorCorrect(<0.9529, 0.8196, 0.6706>, GammaFact, ColorDiff) ]
        [0.50 ColorCorrect(<0.8902, 0.7333, 0.5451>, GammaFact, ColorDiff) ]
        [0.70 ColorCorrect(<0.8353, 0.6431, 0.4353>, GammaFact, ColorDiff) ]
        [0.95 ColorCorrect(<0.6588, 0.4275, 0.1961>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Maple_05 = color_map {
     [ 0.0000 ColorCorrect(<0.8784, 0.6353, 0.4392>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.8824, 0.6549, 0.4706>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.9098, 0.7333, 0.5412>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.9098, 0.7373, 0.5608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9176, 0.7490, 0.5804>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8980, 0.7333, 0.5686>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9216, 0.7608, 0.5961>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8980, 0.7451, 0.5765>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9176, 0.7569, 0.6157>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9020, 0.7490, 0.6078>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9176, 0.7725, 0.6235>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Maple_05a =
     color_map {
        [0.0 ColorCorrect(<0.8510, 0.5294, 0.3294>, GammaFact, ColorDiff) ]
        [0.0 ColorCorrect(<0.7137, 0.4275, 0.2588>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.5216, 0.3137, 0.1882>, GammaFact, ColorDiff) ]
     }


#declare CM_IW_Maple_06 =
     color_map {
        [0.0 ColorCorrect(<0.8824, 0.7843, 0.6667>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.8863, 0.7882, 0.6706>, GammaFact, ColorDiff) ]
     }

//------------------------------------------------------------------


#declare CM_IW_Apple_01 =
     color_map {
        [0.0 ColorCorrect(<0.8157, 0.6392, 0.4353>, GammaFact, ColorDiff) ]
        [0.5 ColorCorrect(<0.7843, 0.5569, 0.3333>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.6745, 0.4196, 0.2392>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Apple_02 =
     color_map {
        [0.0 ColorCorrect(<0.8471, 0.7020, 0.4745>, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(<0.8235, 0.6196, 0.3529>, GammaFact, ColorDiff) ]
        [0.7 ColorCorrect(<0.8000, 0.5686, 0.3294>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.7020, 0.4275, 0.2235>, GammaFact, ColorDiff) ]
     }

//------------------------------------------------------------------


#declare CM_IW_Sycamore_01 = color_map {
     [ 0.0000 ColorCorrect(<0.7020, 0.6235, 0.5294>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7059, 0.6431, 0.5529>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7216, 0.6510, 0.5569>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7333, 0.6627, 0.5686>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7529, 0.6863, 0.5843>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7608, 0.6902, 0.5961>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7843, 0.7137, 0.6196>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8118, 0.7451, 0.6353>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8118, 0.7490, 0.6431>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8157, 0.7608, 0.6510>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8353, 0.7725, 0.6706>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Sycamore_02 = color_map {
     [ 0.0000 ColorCorrect(<0.7059, 0.5490, 0.3255>, GammaFact, ColorDiff) ]
     [ 0.0500 ColorCorrect(<0.7216, 0.5451, 0.3137>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7647, 0.5843, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.1500 ColorCorrect(<0.7529, 0.5922, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7765, 0.6157, 0.3725>, GammaFact, ColorDiff) ]
     [ 0.2500 ColorCorrect(<0.8000, 0.6196, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8157, 0.6471, 0.4000>, GammaFact, ColorDiff) ]
     [ 0.3500 ColorCorrect(<0.8275, 0.6627, 0.4157>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8471, 0.6745, 0.4314>, GammaFact, ColorDiff) ]
     [ 0.4500 ColorCorrect(<0.8627, 0.6863, 0.4196>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8863, 0.7255, 0.5647>, GammaFact, ColorDiff) ]
     [ 0.5500 ColorCorrect(<0.8824, 0.7412, 0.5216>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8863, 0.7333, 0.5020>, GammaFact, ColorDiff) ]
     [ 0.6500 ColorCorrect(<0.8824, 0.7373, 0.5333>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9098, 0.7765, 0.6118>, GammaFact, ColorDiff) ]
     [ 0.7500 ColorCorrect(<0.9059, 0.7765, 0.6157>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9216, 0.8039, 0.6510>, GammaFact, ColorDiff) ]
     [ 0.8500 ColorCorrect(<0.9294, 0.8000, 0.6471>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9176, 0.8118, 0.6824>, GammaFact, ColorDiff) ]
     [ 0.9500 ColorCorrect(<0.9333, 0.8275, 0.6980>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9686, 0.8471, 0.7098>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Sycamore_03 =
     color_map {
        [0.0 ColorCorrect(<1.0000, 0.9020, 0.7725>, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(<0.9922, 0.8431, 0.6706>, GammaFact, ColorDiff) ]
        [0.7 ColorCorrect(<0.9216, 0.7373, 0.5216>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.7529, 0.5490, 0.3255>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Sycamore_04 = color_map {
     [ 0.0000 ColorCorrect(<0.8863, 0.7569, 0.5804>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.9020, 0.7608, 0.5725>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.9059, 0.7765, 0.5922>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.9137, 0.7882, 0.6235>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9333, 0.8000, 0.6549>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.9451, 0.8235, 0.6784>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9412, 0.8314, 0.6745>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9608, 0.8431, 0.7020>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9765, 0.8784, 0.7647>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9804, 0.9098, 0.8078>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9922, 0.9490, 0.8745>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Sycamore_04a = color_map {
     [ 0.0000 ColorCorrect(<0.3529, 0.1804, 0.0667>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.3765, 0.2078, 0.0510>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3765, 0.2078, 0.0510>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.4039, 0.2275, 0.0667>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.5373, 0.3686, 0.1294>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.5843, 0.4118, 0.1647>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6235, 0.4471, 0.1686>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.6353, 0.4588, 0.2000>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6706, 0.4824, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.6863, 0.4824, 0.2118>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.6863, 0.4824, 0.2118>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Birch_01 =
     color_map {
        [0.0 ColorCorrect(<0.8784, 0.7216, 0.6039>, GammaFact, ColorDiff) ]
        [0.5 ColorCorrect(<0.8471, 0.6039, 0.4118>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.7804, 0.5176, 0.3294>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Birch_01a =
     color_map {
        [0.0 ColorCorrect(<0.4353, 0.1922, 0.0627>, GammaFact, ColorDiff) ]
        [0.5 ColorCorrect(<0.4784, 0.2588, 0.1647>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.3686, 0.1569, 0.0353>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Birch_02 = color_map {
     [ 0.0000 ColorCorrect(<0.7608, 0.5176, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7098, 0.4667, 0.2431>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7451, 0.5216, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8118, 0.6118, 0.3765>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8549, 0.6863, 0.4392>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8510, 0.7020, 0.4510>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8627, 0.7137, 0.4588>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8627, 0.7137, 0.4588>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8627, 0.7255, 0.4745>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8627, 0.7373, 0.4980>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8627, 0.7451, 0.5098>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Birch_03 = color_map {
     [ 0.0000 ColorCorrect(<0.8392, 0.6549, 0.4706>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8510, 0.6745, 0.4824>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8196, 0.6314, 0.4353>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8275, 0.6431, 0.4588>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8314, 0.6588, 0.4824>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8314, 0.6588, 0.4863>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Birch_04 = color_map {
     [ 0.0000 ColorCorrect(<0.8588, 0.6235, 0.4510>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8549, 0.6275, 0.4627>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8980, 0.6745, 0.5176>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9176, 0.7020, 0.5451>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9333, 0.7294, 0.5843>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9412, 0.7373, 0.5922>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Beech_01 = color_map {
     [ 0.0000 ColorCorrect(<0.8275, 0.6196, 0.3608>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.9098, 0.7020, 0.4706>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9059, 0.7176, 0.4941>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9569, 0.7922, 0.5725>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9529, 0.7922, 0.5882>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9647, 0.8039, 0.6078>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_02 = color_map {
     [ 0.0000 ColorCorrect(<0.8549, 0.5961, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8627, 0.6275, 0.3412>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8667, 0.6431, 0.3765>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9020, 0.6627, 0.3961>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9176, 0.6941, 0.4353>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9451, 0.7529, 0.5176>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_03 = color_map {
     [ 0.0000 ColorCorrect(<0.6784, 0.4039, 0.1373>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7725, 0.5176, 0.2275>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8196, 0.5686, 0.2667>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8510, 0.6118, 0.3216>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8275, 0.5725, 0.2745>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8471, 0.5961, 0.3176>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8588, 0.6118, 0.3333>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8941, 0.6667, 0.4000>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8941, 0.6863, 0.4314>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9529, 0.7686, 0.5490>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9412, 0.7647, 0.5529>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_04 = color_map {
     [ 0.0000 ColorCorrect(<0.8706, 0.6196, 0.4118>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8431, 0.6000, 0.3961>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8431, 0.6039, 0.4078>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8902, 0.6863, 0.4902>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8902, 0.7020, 0.4824>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9255, 0.7373, 0.5412>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_05 =
     color_map {
        [0.0 ColorCorrect(<0.9216, 0.7843, 0.5961>, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(<0.9098, 0.7176, 0.5294>, GammaFact, ColorDiff) ]
        [0.7 ColorCorrect(<0.8549, 0.6353, 0.4549>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.8118, 0.5255, 0.3569>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Beech_06 = color_map {
     [ 0.0000 ColorCorrect(<0.7765, 0.5804, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7686, 0.5765, 0.3451>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7882, 0.6039, 0.3647>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8196, 0.6627, 0.4000>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8353, 0.6706, 0.4118>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8431, 0.6706, 0.4157>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_07 =
     color_map {
        [0.0 ColorCorrect(<0.9137, 0.8118, 0.5882>, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(<0.8627, 0.7098, 0.4706>, GammaFact, ColorDiff) ]
        [0.7 ColorCorrect(<0.8000, 0.6431, 0.4431>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.7294, 0.5333, 0.3255>, GammaFact, ColorDiff) ]
     }


#declare CM_IW_Beech_08 = color_map {
     [ 0.0000 ColorCorrect(<0.7843, 0.5529, 0.2784>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.8039, 0.5608, 0.2706>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8196, 0.5765, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8471, 0.6118, 0.3176>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8549, 0.6196, 0.3255>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8667, 0.6392, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9020, 0.6745, 0.3843>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9020, 0.6824, 0.3882>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9529, 0.7255, 0.4706>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9451, 0.7294, 0.4784>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9725, 0.7569, 0.5059>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_09 = color_map {
     [ 0.0000 ColorCorrect(<0.9255, 0.7686, 0.5725>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.9294, 0.7843, 0.6000>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9412, 0.8157, 0.6039>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9529, 0.8431, 0.6706>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9961, 0.8745, 0.7412>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9765, 0.8510, 0.6980>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Beech_10 = color_map {
     [ 0.0000 ColorCorrect(<0.8706, 0.5490, 0.3608>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8588, 0.5373, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8627, 0.5255, 0.3412>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8784, 0.5882, 0.4000>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8784, 0.6078, 0.4314>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8941, 0.6157, 0.4471>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Oak_01 = color_map {
     [ 0.0000 ColorCorrect(<0.7725, 0.6196, 0.3882>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7294, 0.5765, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7490, 0.5961, 0.3725>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7490, 0.5961, 0.3686>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7569, 0.6039, 0.3725>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8471, 0.6980, 0.4549>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8667, 0.7176, 0.4745>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8118, 0.6627, 0.4196>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7569, 0.6078, 0.3647>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8000, 0.6510, 0.4078>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8078, 0.6588, 0.4157>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Oak_02 = color_map {
     [ 0.0000 ColorCorrect(<0.7216, 0.4941, 0.2353>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7020, 0.4784, 0.2157>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7725, 0.5490, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8549, 0.6353, 0.3725>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9098, 0.6941, 0.4275>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8902, 0.6784, 0.4118>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Oak_03 = color_map {
     [ 0.0000 ColorCorrect(<0.4941, 0.3059, 0.0863>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5804, 0.3843, 0.1608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6784, 0.4431, 0.1961>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7412, 0.4745, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7176, 0.4667, 0.1882>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7490, 0.5098, 0.2235>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Oak_04 = color_map {
     [ 0.0000 ColorCorrect(<0.7647, 0.6078, 0.3804>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7608, 0.6039, 0.3608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8510, 0.7020, 0.4549>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8784, 0.7294, 0.4824>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8706, 0.7137, 0.4706>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8941, 0.7373, 0.4941>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Oak_05 = color_map {
     [ 0.0000 ColorCorrect(<0.6118, 0.4549, 0.3373>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.6118, 0.4549, 0.3333>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6078, 0.4510, 0.3176>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.6157, 0.4588, 0.3059>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6314, 0.4863, 0.3137>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7255, 0.5686, 0.3961>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7451, 0.5922, 0.4078>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.7608, 0.6039, 0.4078>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8039, 0.6392, 0.4392>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8078, 0.6392, 0.4353>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8196, 0.6471, 0.4314>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Oak_06 = color_map {
     [ 0.0000 ColorCorrect(<0.6275, 0.3216, 0.1294>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.6235, 0.3176, 0.1255>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6392, 0.3333, 0.1451>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.6471, 0.3412, 0.1529>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6941, 0.3922, 0.1882>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7569, 0.4588, 0.2353>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7922, 0.4941, 0.2667>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9020, 0.6078, 0.3608>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8824, 0.5961, 0.3373>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8784, 0.5922, 0.3255>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8706, 0.5843, 0.3137>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Alder_01 = color_map {
     [ 0.0000 ColorCorrect(<0.7412, 0.4902, 0.2784>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7451, 0.4902, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7255, 0.4706, 0.2824>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7255, 0.4706, 0.2980>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7843, 0.5255, 0.3216>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7725, 0.5804, 0.3843>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7725, 0.6078, 0.4078>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.7765, 0.5961, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8196, 0.6235, 0.4275>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.7725, 0.5725, 0.3765>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7529, 0.5608, 0.3569>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Alder_02 = color_map {
     [ 0.0000 ColorCorrect(<0.5765, 0.3137, 0.1608>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.6627, 0.4039, 0.2549>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7216, 0.4784, 0.3059>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7922, 0.5725, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7765, 0.5608, 0.3255>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7686, 0.5608, 0.3529>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8118, 0.6078, 0.4078>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8078, 0.6078, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7961, 0.5961, 0.3843>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8392, 0.6627, 0.4314>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8118, 0.6314, 0.4000>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Ash_01 = color_map {
     [ 0.0000 ColorCorrect(<0.8353, 0.6039, 0.2627>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8784, 0.6392, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8824, 0.6745, 0.3529>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9608, 0.7686, 0.4980>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9882, 0.8471, 0.6235>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9647, 0.8353, 0.6157>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Ash_02 = color_map {
     [ 0.0000 ColorCorrect(<0.7373, 0.5020, 0.1961>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8392, 0.6078, 0.3216>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9412, 0.7373, 0.4627>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9490, 0.7608, 0.4941>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9922, 0.7961, 0.5098>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9843, 0.8039, 0.5137>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Ash_03 = color_map {
     [ 0.0000 ColorCorrect(<0.8549, 0.6000, 0.2784>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8157, 0.5647, 0.2510>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9098, 0.6902, 0.4353>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8863, 0.7020, 0.4275>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9765, 0.8275, 0.5608>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9529, 0.8235, 0.6000>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Ash_03a = color_map {
     [ 0.0000 ColorCorrect(<0.1765, 0.0667, 0.0353>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.2902, 0.1333, 0.0745>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.4784, 0.2824, 0.1451>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.5451, 0.3098, 0.1569>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.5961, 0.3490, 0.1333>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7137, 0.4588, 0.2000>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Ash_04 = color_map {
     [ 0.0000 ColorCorrect(<0.7412, 0.6549, 0.4392>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7412, 0.6549, 0.4392>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8000, 0.7137, 0.5059>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8196, 0.7294, 0.5412>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8196, 0.7294, 0.5569>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8118, 0.7216, 0.5569>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Ash_05 = color_map {
     [ 0.0000 ColorCorrect(<0.7098, 0.5882, 0.4078>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7647, 0.6431, 0.4627>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7922, 0.6745, 0.4824>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8667, 0.8000, 0.6314>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8706, 0.8078, 0.6118>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8431, 0.7804, 0.5765>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Cherry_01 = color_map {
     [ 0.0000 ColorCorrect(<0.8078, 0.5098, 0.2275>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.8471, 0.5804, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8980, 0.6314, 0.3451>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.9333, 0.6706, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9373, 0.6902, 0.4235>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.9059, 0.6667, 0.4196>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9176, 0.6824, 0.4471>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9569, 0.7216, 0.4863>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9333, 0.7176, 0.5059>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9725, 0.7647, 0.5765>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9294, 0.7373, 0.5569>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Cherry_02 = color_map {
     [ 0.0000 ColorCorrect(<0.5176, 0.2667, 0.0706>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8157, 0.5686, 0.2667>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8745, 0.6157, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8431, 0.5961, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8941, 0.6510, 0.3490>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8941, 0.6471, 0.3412>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Cherry_03 = color_map {
     [ 0.0000 ColorCorrect(<0.8549, 0.5451, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7294, 0.4157, 0.1647>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8392, 0.5569, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8431, 0.6000, 0.3176>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8588, 0.5961, 0.3216>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8431, 0.5882, 0.3020>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Cherry_04 = color_map {
     [ 0.0000 ColorCorrect(<0.8157, 0.5020, 0.2627>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.7765, 0.4392, 0.2000>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8078, 0.4706, 0.2353>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.8314, 0.5216, 0.2784>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8157, 0.5059, 0.2588>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.8627, 0.5529, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8941, 0.5961, 0.3294>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8902, 0.6039, 0.3333>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9098, 0.6627, 0.3882>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9294, 0.6863, 0.4275>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9490, 0.7020, 0.4588>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Cherry_05 = color_map {
     [ 0.0000 ColorCorrect(<0.7176, 0.3608, 0.2275>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6510, 0.2941, 0.1882>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6392, 0.2824, 0.1686>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6980, 0.3490, 0.1961>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7373, 0.3922, 0.2157>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7529, 0.4039, 0.2392>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Pine_01 = color_map {
     [ 0.0000 ColorCorrect(<0.8784, 0.6588, 0.4941>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8510, 0.6275, 0.4745>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8824, 0.7098, 0.5922>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9294, 0.8000, 0.6941>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9765, 0.8667, 0.7608>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9569, 0.8078, 0.6824>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Pine_02 = color_map {
     [ 0.0000 ColorCorrect(<0.6549, 0.4039, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7647, 0.5647, 0.4314>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9608, 0.8235, 0.6941>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9647, 0.8667, 0.7647>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9725, 0.8667, 0.7608>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9882, 0.8980, 0.7804>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Pine_03 = color_map {
     [ 0.0000 ColorCorrect(<0.8706, 0.6510, 0.3333>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8784, 0.6549, 0.3490>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9216, 0.6980, 0.4000>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9686, 0.7686, 0.4667>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9490, 0.7725, 0.4706>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9373, 0.7843, 0.4824>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Elm_01 = color_map {
     [ 0.0000 ColorCorrect(<0.6824, 0.4196, 0.2824>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7647, 0.4941, 0.3608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8118, 0.5569, 0.4039>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8078, 0.5608, 0.3961>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8627, 0.6314, 0.4588>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8667, 0.6431, 0.4667>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Elm_02 = color_map {
     [ 0.0000 ColorCorrect(<0.5059, 0.2078, 0.1451>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5529, 0.2549, 0.1608>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6314, 0.3412, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.6941, 0.4078, 0.2431>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7804, 0.4863, 0.2941>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9765, 0.6627, 0.4627>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Elm_03 = color_map {
     [ 0.0000 ColorCorrect(<0.7569, 0.4706, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.3333 ColorCorrect(<0.8235, 0.5569, 0.3647>, GammaFact, ColorDiff) ]
     [ 0.6667 ColorCorrect(<0.9373, 0.6980, 0.4863>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9804, 0.7725, 0.5490>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Robinia_01 = color_map {
     [ 0.0000 ColorCorrect(<0.5804, 0.3333, 0.1569>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.5843, 0.3333, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6000, 0.3529, 0.1569>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.6706, 0.4196, 0.2118>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7294, 0.4745, 0.2549>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7059, 0.4549, 0.2118>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7137, 0.4627, 0.2235>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.7608, 0.5137, 0.2549>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8431, 0.5922, 0.3333>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8431, 0.5961, 0.3294>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8392, 0.5922, 0.3176>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Robinia_02 = color_map {
     [ 0.0000 ColorCorrect(<0.2235, 0.0196, 0.0000>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.2667, 0.0588, 0.0000>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.4667, 0.2431, 0.1098>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.5529, 0.3255, 0.1725>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.6157, 0.3765, 0.2118>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7529, 0.5098, 0.3294>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Robinia_03 = color_map {
     [ 0.0000 ColorCorrect(<0.5294, 0.2706, 0.1333>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6078, 0.3529, 0.1882>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7020, 0.4549, 0.2627>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7608, 0.5176, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7569, 0.5137, 0.2784>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7647, 0.5255, 0.2784>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Robinia_04 = color_map {
     [ 0.0000 ColorCorrect(<0.6510, 0.3843, 0.0980>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.6706, 0.4078, 0.1098>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6980, 0.4314, 0.1137>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7725, 0.5059, 0.1725>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8667, 0.6039, 0.2549>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.9020, 0.6353, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9216, 0.6588, 0.3059>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.9098, 0.6510, 0.2824>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9020, 0.6471, 0.2627>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.9333, 0.6745, 0.2863>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9373, 0.6824, 0.2941>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Robinia_05 = color_map {
     [ 0.0000 ColorCorrect(<0.5961, 0.3333, 0.1294>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6118, 0.3569, 0.1451>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6980, 0.4431, 0.2157>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7725, 0.5216, 0.2824>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8196, 0.5686, 0.3255>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8431, 0.5922, 0.3451>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Larch_01 = color_map {
     [ 0.0000 ColorCorrect(<0.6863, 0.3373, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6941, 0.3451, 0.2039>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7294, 0.3843, 0.2314>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8039, 0.4588, 0.3020>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8510, 0.4980, 0.3373>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8431, 0.4745, 0.3255>, GammaFact, ColorDiff) ]
   }


#declare CM_IW_Larch_02 = color_map {
     [ 0.0000 ColorCorrect(<0.7961, 0.3882, 0.1412>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8745, 0.4667, 0.2196>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.9294, 0.5098, 0.2471>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9569, 0.5255, 0.2471>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9804, 0.5569, 0.2706>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9922, 0.5882, 0.3020>, GammaFact, ColorDiff) ]
   }


//------------------------------------------------------------------


#declare CM_IW_Chestnut_01 = color_map {
     [ 0.0000 ColorCorrect(<0.5176, 0.3294, 0.1490>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5255, 0.3373, 0.1569>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.6902, 0.5020, 0.3216>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7804, 0.5922, 0.4039>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7882, 0.6000, 0.4118>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8078, 0.6196, 0.4235>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Chestnut_02 = color_map {
     [ 0.0000 ColorCorrect(<0.6275, 0.3647, 0.2745>, GammaFact, ColorDiff) ]
     [ 0.3333 ColorCorrect(<0.6431, 0.3804, 0.2627>, GammaFact, ColorDiff) ]
     [ 0.6667 ColorCorrect(<0.7294, 0.4745, 0.3333>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7098, 0.4549, 0.3020>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Chestnut_03 =
     color_map {
        [0.0 ColorCorrect(<0.8039, 0.5137, 0.3373>, GammaFact, ColorDiff) ]
        [0.3 ColorCorrect(<0.7451, 0.4392, 0.2902>, GammaFact, ColorDiff) ]
        [0.7 ColorCorrect(<0.7020, 0.4157, 0.2745>, GammaFact, ColorDiff) ]
        [1.0 ColorCorrect(<0.4431, 0.2078, 0.1647>, GammaFact, ColorDiff) ]
     }

#declare CM_IW_Chestnut_04 = color_map {
     [ 0.0000 ColorCorrect(<0.4275, 0.2000, 0.1922>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.4353, 0.2000, 0.1882>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.3922, 0.1412, 0.0980>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.6627, 0.3922, 0.3059>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7490, 0.4627, 0.3647>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7176, 0.4235, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7412, 0.4353, 0.2941>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.7412, 0.4314, 0.2824>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7569, 0.4471, 0.2902>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.7490, 0.4392, 0.2941>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.7373, 0.4314, 0.2902>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Spruce_01 = color_map {
     [ 0.0000 ColorCorrect(<0.4745, 0.2667, 0.1686>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6510, 0.4353, 0.3373>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7451, 0.5333, 0.4314>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7373, 0.5255, 0.4235>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.7882, 0.5843, 0.4824>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8039, 0.6039, 0.4980>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Spruce_02 = color_map {
     [ 0.0000 ColorCorrect(<0.7020, 0.4549, 0.2627>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7294, 0.5137, 0.3373>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8824, 0.6902, 0.5294>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.9529, 0.7608, 0.6000>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9176, 0.7255, 0.5647>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9098, 0.7176, 0.5569>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Spruce_03 = color_map {
     [ 0.0000 ColorCorrect(<0.8039, 0.5725, 0.4157>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8118, 0.5804, 0.4235>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8431, 0.6118, 0.4549>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8431, 0.6118, 0.4549>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8431, 0.6118, 0.4549>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8549, 0.6196, 0.4706>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------


#declare CM_IW_Douglas_01 = color_map {
     [ 0.0000 ColorCorrect(<0.7216, 0.4235, 0.3294>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7216, 0.4235, 0.3294>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7020, 0.4039, 0.3020>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7765, 0.4784, 0.3686>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8392, 0.5451, 0.4235>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8196, 0.5216, 0.3843>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Douglas_02 = color_map {
     [ 0.0000 ColorCorrect(<0.8941, 0.5961, 0.3412>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8706, 0.6078, 0.3529>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8392, 0.6275, 0.3922>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8941, 0.7176, 0.4980>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.9725, 0.8039, 0.5843>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9686, 0.8039, 0.5725>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Douglas_03 = color_map {
     [ 0.0000 ColorCorrect(<0.6039, 0.3373, 0.1882>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.6471, 0.3804, 0.2275>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7569, 0.5098, 0.3412>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8157, 0.5765, 0.4039>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8275, 0.6000, 0.4314>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8157, 0.5961, 0.4471>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Douglas_04 = color_map {
     [ 0.0000 ColorCorrect(<0.6431, 0.3176, 0.0824>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.6196, 0.2824, 0.0588>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.7137, 0.3725, 0.1529>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.7529, 0.4157, 0.1922>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8157, 0.4941, 0.2588>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7686, 0.4745, 0.2196>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8471, 0.5647, 0.2980>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8627, 0.5843, 0.3137>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8902, 0.6314, 0.3529>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8627, 0.6118, 0.3294>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8392, 0.5922, 0.3098>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Douglas_05 = color_map {
     [ 0.0000 ColorCorrect(<0.4431, 0.1647, 0.0157>, GammaFact, ColorDiff) ]
     [ 0.1000 ColorCorrect(<0.4353, 0.1490, 0.0157>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.5569, 0.2824, 0.0980>, GammaFact, ColorDiff) ]
     [ 0.3000 ColorCorrect(<0.6863, 0.4275, 0.2196>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.7137, 0.4627, 0.2353>, GammaFact, ColorDiff) ]
     [ 0.5000 ColorCorrect(<0.7765, 0.5216, 0.3059>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.7882, 0.5255, 0.3216>, GammaFact, ColorDiff) ]
     [ 0.7000 ColorCorrect(<0.8078, 0.5412, 0.3373>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8157, 0.5569, 0.3255>, GammaFact, ColorDiff) ]
     [ 0.9000 ColorCorrect(<0.8431, 0.5922, 0.3451>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.8588, 0.6118, 0.3529>, GammaFact, ColorDiff) ]
   }

#declare CM_IW_Douglas_06 = color_map {
     [ 0.0000 ColorCorrect(<0.8353, 0.5608, 0.2863>, GammaFact, ColorDiff) ]
     [ 0.2000 ColorCorrect(<0.8118, 0.5569, 0.2784>, GammaFact, ColorDiff) ]
     [ 0.4000 ColorCorrect(<0.8235, 0.5922, 0.3059>, GammaFact, ColorDiff) ]
     [ 0.6000 ColorCorrect(<0.8353, 0.6196, 0.3294>, GammaFact, ColorDiff) ]
     [ 0.8000 ColorCorrect(<0.8627, 0.6510, 0.3686>, GammaFact, ColorDiff) ]
     [ 1.0000 ColorCorrect(<0.9176, 0.7098, 0.4314>, GammaFact, ColorDiff) ]
   }

//------------------------------------------------------------------

#declare CM_IW_Weathered_Green_01 = color_map {
    [ 0.0 ColorCorrect(<0.18948, 0.17607, 0.03114>, GammaFact, ColorDiff) ]
    [ 0.1 ColorCorrect(<0.12544, 0.12267, 0.01615>, GammaFact, ColorDiff) ]
    [ 0.2 ColorCorrect(<0.09286, 0.08211, 0.00325>, GammaFact, ColorDiff) ]
    [ 0.3 ColorCorrect(<0.1693,  0.15528, 0.02309>, GammaFact, ColorDiff) ]
    [ 0.4 ColorCorrect(<0.30142, 0.26716, 0.07004>, GammaFact, ColorDiff) ]
    [ 0.5 ColorCorrect(<0.24804, 0.24804, 0.03692>, GammaFact, ColorDiff) ]
    [ 0.6 ColorCorrect(<0.27256, 0.2659,  0.07611>, GammaFact, ColorDiff) ]
    [ 0.7 ColorCorrect(<0.27175, 0.26424, 0.07253>, GammaFact, ColorDiff) ]
    [ 0.8 ColorCorrect(<0.24753, 0.24417, 0.04519>, GammaFact, ColorDiff) ]
    [ 0.9 ColorCorrect(<0.28322, 0.27968, 0.08154>, GammaFact, ColorDiff) ]
    [ 1.0 ColorCorrect(<0.30142, 0.29287, 0.08421>, GammaFact, ColorDiff) ]
}

#declare CM_IW_Weathered_Green_02 = color_map {
    [ 0.0 ColorCorrect(<0.05353, 0.01478, 0.00038>, GammaFact, ColorDiff) ]
    [ 0.1 ColorCorrect(<0.05294, 0.04343, 0.00183>, GammaFact, ColorDiff) ]
    [ 0.2 ColorCorrect(<0.12015, 0.09493, 0.01113>, GammaFact, ColorDiff) ]
    [ 0.3 ColorCorrect(<0.12857, 0.10416, 0.01846>, GammaFact, ColorDiff) ]
    [ 0.4 ColorCorrect(<0.21263, 0.21745, 0.05897>, GammaFact, ColorDiff) ]
    [ 0.5 ColorCorrect(<0.27867, 0.24068, 0.06118>, GammaFact, ColorDiff) ]
    [ 0.6 ColorCorrect(<0.2079,  0.21263, 0.04898>, GammaFact, ColorDiff) ]
    [ 0.7 ColorCorrect(<0.23529, 0.21394, 0.0362 >, GammaFact, ColorDiff) ]
    [ 0.8 ColorCorrect(<0.30142, 0.29287, 0.08421>, GammaFact, ColorDiff) ]
    [ 0.9 ColorCorrect(<0.29258, 0.25935, 0.07066>, GammaFact, ColorDiff) ]
    [ 1.0 ColorCorrect(<0.44444, 0.36,    0.11111>, GammaFact, ColorDiff) ]
}

#declare CM_IW_Weathered_Green_03 = color_map {
    [ 0.0 ColorCorrect(<0.24804, 0.24804, 0.03692>, GammaFact, ColorDiff) ]
    [ 0.1 ColorCorrect(<0.21243, 0.17514, 0.01783>, GammaFact, ColorDiff) ]
    [ 0.2 ColorCorrect(<0.14017, 0.14448, 0.00815>, GammaFact, ColorDiff) ]
    [ 0.3 ColorCorrect(<0.21662, 0.22394, 0.03908>, GammaFact, ColorDiff) ]
    [ 0.4 ColorCorrect(<0.24485, 0.23564, 0.03286>, GammaFact, ColorDiff) ]
    [ 0.5 ColorCorrect(<0.20732, 0.1486,  0.00434>, GammaFact, ColorDiff) ]
    [ 0.6 ColorCorrect(<0.25061, 0.25463, 0.06372>, GammaFact, ColorDiff) ]
    [ 0.7 ColorCorrect(<0.34942, 0.28624, 0.08272>, GammaFact, ColorDiff) ]
    [ 0.8 ColorCorrect(<0.4325,  0.35531, 0.11209>, GammaFact, ColorDiff) ]
    [ 0.9 ColorCorrect(<0.48173, 0.37961, 0.11499>, GammaFact, ColorDiff) ]
    [ 1.0 ColorCorrect(<0.53204, 0.41869, 0.13301>, GammaFact, ColorDiff) ]
}

#declare CM_IW_Weathered_Green_04 = color_map {
    [ 0.0 ColorCorrect(<0.24804, 0.24804, 0.03692>, GammaFact, ColorDiff) ]
    [ 0.1 ColorCorrect(<0.28167, 0.23129, 0.04191>, GammaFact, ColorDiff) ]
    [ 0.2 ColorCorrect(<0.2927,  0.27001, 0.05964>, GammaFact, ColorDiff) ]
    [ 0.3 ColorCorrect(<0.34473, 0.3059,  0.08487>, GammaFact, ColorDiff) ]
    [ 0.4 ColorCorrect(<0.35605, 0.31461, 0.10106>, GammaFact, ColorDiff) ]
    [ 0.5 ColorCorrect(<0.35605, 0.31572, 0.10051>, GammaFact, ColorDiff) ]
    [ 0.6 ColorCorrect(<0.37312, 0.31989, 0.10385>, GammaFact, ColorDiff) ]
    [ 0.7 ColorCorrect(<0.40145, 0.33994, 0.09771>, GammaFact, ColorDiff) ]
    [ 0.8 ColorCorrect(<0.44836, 0.36762, 0.09216>, GammaFact, ColorDiff) ]
    [ 0.9 ColorCorrect(<0.35959, 0.29073, 0.06887>, GammaFact, ColorDiff) ]
    [ 1.0 ColorCorrect(<0.34602, 0.29287, 0.03692>, GammaFact, ColorDiff) ]
}

#declare CM_IW_Weathered_Wood_01 = color_map {
    [ 0.0 ColorCorrect(<0.41869, 0.18271, 0.00961>, GammaFact, ColorDiff) ]
    [ 0.1 ColorCorrect(<0.36287, 0.15436, 0.00702>, GammaFact, ColorDiff) ]
    [ 0.2 ColorCorrect(<0.34088, 0.14098, 0.00464>, GammaFact, ColorDiff) ]
    [ 0.3 ColorCorrect(<0.34088, 0.1446,  0.00993>, GammaFact, ColorDiff) ]
    [ 0.4 ColorCorrect(<0.33884, 0.18757, 0.0179 >, GammaFact, ColorDiff) ]
    [ 0.5 ColorCorrect(<0.22145, 0.1447,  0.00301>, GammaFact, ColorDiff) ]
    [ 0.6 ColorCorrect(<0.23708, 0.16588, 0.01608>, GammaFact, ColorDiff) ]
    [ 0.7 ColorCorrect(<0.16807, 0.09959, 0.00391>, GammaFact, ColorDiff) ]
    [ 0.8 ColorCorrect(<0.27791, 0.15515, 0.02337>, GammaFact, ColorDiff) ]
    [ 0.9 ColorCorrect(<0.21952, 0.13978, 0.01122>, GammaFact, ColorDiff) ]
    [ 1.0 ColorCorrect(<0.24029, 0.09842, 0.01121>, GammaFact, ColorDiff) ]
}

#declare CM_IW_Weathered_Wood_02 = color_map {
    [ 0.0 ColorCorrect(<0.36947, 0.15688, 0.00555>, GammaFact, ColorDiff) ]
    [ 0.1 ColorCorrect(<0.2969,  0.12055, 0.00125>, GammaFact, ColorDiff) ]
    [ 0.2 ColorCorrect(<0.36947, 0.15688, 0.00555>, GammaFact, ColorDiff) ]
    [ 0.3 ColorCorrect(<0.32823, 0.1383,  0.01059>, GammaFact, ColorDiff) ]
    [ 0.4 ColorCorrect(<0.31448, 0.12457, 0.00125>, GammaFact, ColorDiff) ]
    [ 0.5 ColorCorrect(<0.32604, 0.1543,  0.00855>, GammaFact, ColorDiff) ]
    [ 0.6 ColorCorrect(<0.35531, 0.21778, 0.01384>, GammaFact, ColorDiff) ]
    [ 0.7 ColorCorrect(<0.36002, 0.1972,  0.01831>, GammaFact, ColorDiff) ]
    [ 0.8 ColorCorrect(<0.31448, 0.13589, 0.01778>, GammaFact, ColorDiff) ]
    [ 0.9 ColorCorrect(<0.39045, 0.18782, 0.02497>, GammaFact, ColorDiff) ]
    [ 1.0 ColorCorrect(<0.36,    0.19637, 0.04   >, GammaFact, ColorDiff) ]
}

//------------------------------------------------------------------

#declare Tex_IW_Weathered_Wood_01=
  texture {
    pigment_pattern {
      bozo
      color_map { [0 rgb 0][1 rgb 1] }
      warp {
        turbulence 0.6
        lambda 2.6
        omega 0.55
      }
      scale <0.2, 0.2, 0.45>*0.5
    }
    texture_map {
      [0.3
        pigment {
          bozo
          color_map { CM_IW_Weathered_Green_01 }
          warp {
            turbulence 0.6
            omega 0.55
          }
          scale 0.01
        }
        finish {
          Fin_W
        }
        normal {
          Norm_W
        }
      ]
      [0.43
        pigment {
          bozo
          color_map { CM_IW_Weathered_Green_02 }
          warp {
            turbulence 0.6
          }
          scale 0.02
        }
        finish {
          Fin_W
        }
        normal {
          Norm_W
        }
      ]
      [0.49
        pigment {
          wood
          color_map { [0 rgb 0][1 rgb 1] }
          scale 0.55
          warp {
            turbulence <0.4, 0.4, 0.6>
            octaves 5
            lambda 2.6
            omega 0.61
          }
          scale      <0.08, 0.08, 0.5>
          color_map { CM_IW_Weathered_Wood_01 }
        }
        finish {
          Fin_W
        }
      ]
    }
  }

#declare Pig_IW_Weathered_Wood_01=
  pigment {
    pigment_pattern {
      pigment_pattern {
        bozo
        color_map { [0 rgb 0][1 rgb 1] }
        warp {
          turbulence 0.6
          lambda 2.6
          omega 0.55
        }
        scale <0.2, 0.2, 0.45>*0.5
      }
      pigment_map {
        [0.43
          bozo
          color_map { [0 rgb 0.1][1 rgb 0.4] }
          warp {
            turbulence 0.6
            omega 0.55
          }
          scale      <0.6, 0.6, 1>
          scale 0.02
        ]
        [0.49
            wood
            color_map { [0 rgb 0][1 rgb 1] }
            scale 0.55
            warp {
              turbulence <0.4, 0.4, 0.6>
              octaves 5
              lambda 2.6
              omega 0.61
            }
            scale      <0.08, 0.08, 0.5>
        ]
      }
    }
    color_map { [0 rgb 0][1 rgb 1] }
  }

//------------------------------------------------------------------

