#debug "including dissolution\n"

#macro manipulator (uparm,loarm,jog,pitch,roll)  

// light assembly

#declare lights = 
merge {
        merge {
                cylinder {0*x, 0.15*x, 0.02}
                sphere {0, 0.02 scale <1,1,1>}
                torus {0.016, 0.004 scale <1,3,1> rotate 90*z translate 0.15*x}
        }
        sphere {0, 0.016 scale <0.4,1,1> translate 0.15*x}
}                                         
// base
merge { 
        difference {
                union {
                        cylinder {<0,-0.07,0>, <0,-0.28,0>, 0.3}
                        sphere {0, 0.3 scale <1,0.03,1> translate <0,-0.07,0>}  
                }
                box {0, 1 translate <0.15,-0.5,-0.5>}
                torus {0.3,0.05 scale <1,1.2,1> translate <0,-0.18,0>}
                box {< -0.2,-0.15,-0.1>, <1,0,0.1>}
                box {0, 1 rotate <0,45,0> translate <0.1,-0.5,-0.3>}  
                box {<0,0,0>, <1,1,-1> rotate <0,-45,0> translate <0.1,-0.5,0.3>}
                sphere {0, 0.5 scale 0.05 translate <0.165,-0.24,-0.12>}
                sphere {0, 0.5 scale 0.05 translate <0.165,-0.24,0.12>} 
        }  
        cylinder {<0,-0.1,-0.1>, <0,-0.1,0.1>, 0.03}
        union {
                cylinder {<0.15,-0.2,0.05>, <0.22,-0.2,0.05>, 0.02}
                cylinder {<0.26,-1,0.05>, <0.26,-0.24,0.05>, 0.02}
                intersection {
                        torus {0.04,0.02 rotate 90*x translate <0.22,-0.24,0.05>}
                        box {<0.22,-0.24,-1>, <1,1,1>}
                }      
        }                          
       union {
                cylinder {< 0.15,-0.2,-0.05>, <0.22,-0.2,-0.05>, 0.02}
                cylinder {< 0.26,-1,-0.05>, <0.26,-0.24,-0.05>, 0.02}
                intersection {
                        torus {0.04, 0.02 rotate 90*x translate <0.22,-0.24,-0.05>}
                        box {<0.22,-0.24,-1 >, <1,1,1>}
                }      
        } 

 
// base joint
  
        merge {
                difference {
                        intersection { 
                                box {0, 1 rotate <45,0,0>}
                                sphere {0, 0.5 scale < 0.07,0.6,0.6> translate <0.05,0,0>}
                                box { <0,-0.5,0.15>, <1,5,1>}  
                        } 
                        cylinder {<-1,0,0.26>, <1,0,0.26 >, 0.015 scale <1,1/0.7,1>} 
                        cylinder {<-1, 0.095,0.23>, <1,0.095,0.23>, 0.015 scale <1,1/0.7, 1>}
                        cylinder {<-1,-0.095,0.23>, <1,-0.095,0.23>, 0.015 scale <1,1/0.7,1>}
                }
                 
                difference {                    
                        intersection { 
                                box {0, 1 rotate < 225, 0, 0 > } 
                                sphere {0, 0.5 scale <0.07,0.6,0.6> translate <0.05,0,0>}
                                box {<0,-0.5,-0.15>, <1,5,-1>}   
                        }      
                        cylinder {<-1,0,-0.26>, <1,0,-0.26>, 0.015 scale < 1,1/0.7,1> } 
                        cylinder {<-1,0.095,-0.23>, <1,0.095,-0.23 >, 0.015 scale <1,1/0.7,1> }
                        cylinder {<-1,-0.095,-0.23>, <1,-0.095,-0.23 >, 0.015 scale <1,1/0.7,1> }
                }
                 
                difference {
                        intersection { 
                                sphere {0, 1 scale <0.2,0.15,0.1> translate <0,0,0.15>}
                                box {0, 1 translate <0,-0.5,0.15>}    
                        }
                        cylinder {<0.12,0,0.2>, <0.12,0,1>, 0.032 scale <1,1/0.7,1>}
                }
                
                difference {                           
                        intersection { 
                                sphere {0, 1 scale < 0.2,0.15,0.1> translate <0,0,-0.15>}
                                box {0, 1 translate <0,-0.5,-1.15 >}    
                        }
                        cylinder {<0.12,0,-1>, <0.12,0,-0.2 >, 0.032 scale <1,1/0.7,1> }
                }
                 
                scale <1,0.7,1> 
                translate < -0.12,0,0>
                rotate <0,0,90>
        }  
// upper arm 
        merge {  
                cylinder {<0,0,-0.15>, <0,0,0.15>, 0.025}
            
                merge {
                        superellipsoid {<0.25,0.25> scale <0.1,0.03,0.015>}
                        cylinder {0.015*z, 0.06*z, 0.035 translate <0.075,0,0>}    
                        translate <0.075,0,-0.04 >
                        rotate <0,0,(180-uparm+loarm)>
                }   
                   
                merge {
                        superellipsoid {<0.25,0.25> scale <0.28,0.06,0.035> translate <0.24,0,0.115>}
                        superellipsoid {<0.25,0.25> scale <0.28,0.06,0.035> translate <0.24,0,-0.115>}
                        cylinder {<0.52,0,-0.15>, <0.52,0,0.15>, 0.05}
                        difference {
                                merge { 
                                        sphere {0, 1 scale <0.05,0.05,0.01> translate <0.52,0,-0.15>}
                                        sphere {0, 1 scale <0.05,0.05,0.01> translate <0.52,0,0.15>} 
                                }
                                cylinder {-1*z, 1*z, 0.01 translate 0.03*x rotate 0*z translate 0.52*x}
                                cylinder {-1*z, 1*z, 0.01 translate 0.03*x rotate 72*z translate 0.52*x}
                                cylinder {-1*z, 1*z, 0.01 translate 0.03*x rotate 144*z translate 0.52*x}
                                cylinder {-1*z, 1*z, 0.01 translate 0.03*x rotate 216*z translate 0.52*x}
                                cylinder {-1*z, 1*z, 0.01 translate 0.03*x rotate 288*z translate 0.52*x}
                        }           
                }  
// lower arm 
                merge {
                        merge { 
                                difference {
                                        superellipsoid { < 0.25, 0.25 > scale < 0.2, 0.07, 0.075 > }
                                        box { < -1, -1, -0.04 >, < -0.05, 0.03, 0.04 > }
                                }     
                                difference { 
                                        merge {
                                                  box { < 0.18, -0.068, -0.08 >, < 0.35, 0.068, 0.08 > }
                                                  cylinder { < 0.18, 0, -0.08/0.5 >, < 0.35, 0, -0.08/0.5 >, 0.068 scale < 1, 1, 0.5 > } 
                                                  cylinder { < 0.18, 0, 0.08/0.5 >, < 0.35, 0, 0.08/0.5 >, 0.068 scale < 1, 1, 0.5 > }
                                                  cylinder { -0.08*z, 0.08*z, 0.068 scale < 2, 1, 1 > translate 0.35*x }
                                                  sphere { 0, 0.068 scale < 2, 1, 0.5 > translate < 0.35, 0, -0.08 > }
                                                  sphere { 0, 0.068 scale < 2, 1, 0.5 > translate < 0.35, 0, 0.08 > }
                          
                                        }
                                        cylinder { 0.18*x, 1*x, 0.03 scale < 1, 0.5, 1 > translate 0.068*y } 
                                }             
                        }                
                        superellipsoid { < 0.2, 0.2 > scale < 0.025, 0.07, 0.12 > translate 0.18*x}                            
                        merge {
                                cylinder { 0*x, 0.52*x, 0.035
                                        scale < 1, 1, 0.5 >
                                        rotate < 0, 0, (180+uparm-loarm) >
                                        translate < -0.15, 0, 0.0 >
                                }
                                cylinder { -0.05*z, 0.05*z, 0.035 translate < -0.15, 0, 0 > }
                        } 
                        merge {
                                cylinder { 0.23*x, 0.55*x, 0.035}
                                sphere { < 0.23, 0, 0 > 0.035}
                                sphere { < 0.55, 0, 0 > 0.035}
                        } 
                        object {lights scale < 1, 2.2, 2.2 > translate < 0.28, -0.1, 0 >}                 
                        object {lights scale < 0.8, 1.5, 1.5 > translate < 0.28, -0.09, -0.065 >}    
                        object {lights scale < 0.8, 1.5, 1.5 > translate < 0.28, -0.09, 0.065 >} 
                        object {lights scale < 0.6, 1, 1 > translate < 0.27, -0.08, -0.11 >}      
                        object {lights scale < 0.6, 1, 1 > translate < 0.27, -0.08, 0.11 >}    
// grip
                #declare grip =    
                merge { 
                        torus {0.03, 0.01 rotate <0,0,90> translate <0.03,0,0>}   
                        merge { 
                                sphere {0, 0.06 scale <0.3,1,1> translate <0.05,0,0>}  
                                cylinder {0.05*x, 0.15*x, 0.06}
                                      sphere { 0, 0.06 scale < 0.3, 1, 1 > translate < 0.15, 0, 0 > }
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 30*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 60*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 90*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 120*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 150*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 180*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 210*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 240*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 270*x }
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 300*x } 
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 330*x }
                                      sphere { 0, 0.04 scale < 1, 0.2, 0.15 > translate < 0.1, 0.06, 0 > rotate 0*x }                          
                        } 
                        #declare finger =
                        merge { 
                                superellipsoid { < 0.2, 0.2 > scale < 0.05, 0.025, 0.02 > rotate -80*y translate < 0.18,0,0.05 >}       
                                merge {
                                        intersection {
                                                sphere { 0, 1 scale < 0.15, 0.02, 0.03 > }
                                                box { < 0, -1, 0 >, < 1, 1, 1 > }  
                                        }
                                        sphere {0, 1 scale < 0.009, 0.009, 0.005 > translate 0.12*x}
                                        sphere {0, 1 scale < 0.012, 0.012, 0.005 > translate 0.09*x}
                                        sphere {0, 1 scale < 0.015, 0.015, 0.005 > translate 0.05*x}   
                                        rotate -55*y
                                        translate < 0.2, 0, 0.07 >
                                }   
                        } 
                        #declare sw = rand (e);   
                        #if (sw <= 0.5) // choose to use hand  
                                object {finger scale 1.3 translate <-0.035,0,0> rotate 90*x}   
                                object {finger scale 1.3 translate <-0.035,0,0> rotate 210*x}
                                object {finger scale 1.3 translate <-0.035,0,0> rotate -30*x}  
                                sphere {0, 0.055 scale < 1.5, 1, 1 > translate 0.17*x}   
                        #end 
                        #if (sw > 0.5) // choose to use transparent "probe" 
                                difference { 
                                        sphere {0,0.03 scale <20,1,1> translate 0*x}
                                        union { 
                                                sphere {0,0.027 scale <20,1,1> translate 0*x}
                                                cylinder {-1*x,1*x,0.01}
                                                box {-1,<0,1,1>}
                                        }
                                } 
                                union { 
                                        cylinder {0.15*x, 0.2*x, 0.04}
                                        sphere {0, 0.04 scale < 0.2, 1, 1 > translate 0.2*x} 
                                }   
                        #end
                                
                }      
                object {grip scale 1.2 rotate <jog,0,0> rotate <0,pitch,0> rotate <0,0,roll> translate <0.55,0,0 >}                 
                rotate <0,0,(-uparm+loarm)>
                translate <0.52,0,0>    
        }
        rotate <0,0,uparm>
        } 
        translate <0,0.28,0>
}        
#end
  
#macro irisphere (a,b,c,d,e,f)
merge { 
        #declare j = array [7] {1,4,8,8,8,4,1} 
        //holes in body
        #declare holes =
        union {  
                #declare i = 1;
                #while (i < 8) 
                #declare k = 0;
                #while (k < (j[i-1]))
                        cylinder {0*y, 15*y, 1.95 rotate 180/6*(i-1)*x rotate (360/j[i-1]*(k)+22.5*i)*y}
                        #declare k = k+1;
                #end
                #declare i = i+1;
        #end  
        }             
        #declare nut = 
        difference {
                merge {
                        cylinder {0*x,1*x,0.5}
                        sphere {0,0.5 scale <0.2,1,1> translate 1*x}
                        sphere {0,0.7 scale <0.1,1,1> translate 0.5*x}
                }
                box {<-1,-0.2,-0.2>,<2,0.2,0.2>} 
                box {<-1,-0.2,-0.2>,<2,0.2,0.2> rotate 45*x}                     
        }
        //main sphere body shape with holes
        difference {
                sphere {0, 10}
                holes  
        } 
        //robot hands placement
        #declare hands = 
        merge {  
                #declare l = 1;
                #while (l < 8) 
                #declare m = 0;
                         #while (m < (j[l-1]))  
                                merge {
                                        #if (iris = 1) // choose to show hands (1) or close hole with "iris" (0)
                                        object {  
                                                manipulator ((110+30*(2*rand (a)-1)),(50+20*(2*rand (b)-1)),(30*(2*rand(c)-1)),(30*(2*rand (d)-1)),(20+30*(2*rand (e)-1))) 
                                                scale 6
                                                rotate rand (f)*360*y
                                                translate y*9.9
                                        } 
                                        #end 
                                        torus {1.95, 0.1 translate 9.9*y} 
                                        #declare i = 0;
                                        #while (i < 9)
                                                object {nut rotate z*90 scale <0.5,0.5,0.5> translate <2.45,9.5,0> rotate y*i*45}
                                                #declare i = i+1;
                                        #end  
                                        #if (iris = 0) // choose to show hands (1) or close hole with "iris" (0)
                                        #declare i = 0;
                                                #while (i < 24)
                                                       sphere_sweep {          
                                                                 b_spline
                                                                6,   
                                                                <1.95,0,-0.3>,0.1
                                                                <1.9,0,0.1>,0.1
                                                                <1.3,0.5,0.2>,0.1       
                                                                <0.8,0.55,0.2>,0.05    
                                                                <0.3,0.6,0.0>,0.03 
                                                                <0.2,0.5,-0.1>,0.01 
                                                                tolerance 0.001
                                                                translate <0,9.7,0>       
                                                                rotate 15*y*i         
                                                                        
                                                        }
                                                        #declare i = i+1;
                                                #end
                                        #end 
                                        rotate 180/6*(l-1)*x  
                                        rotate (360/j[l-1]*(m)+22.5*l)*y
                                }
                                #declare m = m+1;
                        #end
                        #declare l = l+1;
                #end  
        }           
        hands 
        // little spikes on sphere surface
        difference {
                merge {
                        #declare i = 0;
                        #while (i < 300)  //1000
                                merge { 
                                        #declare h = rand(a);
                                        cylinder {10*y,(12-2*h)*y,0.03} 
                                        sphere {0,0.03 translate (12-2*h)*y} 
                                        sphere {0,0.07 scale <1,5,1> translate 10*y}
                                        rotate <rand(b),rand(c),rand(e)>*360  
                                }                  
                        #declare i = i+1;
                        #end            
                }                                             
                holes  
        }           
}
#end           

//*****OBJECTS

#declare a = seed (1276543);   
#declare b = seed (12763); 
#declare c = seed (6543); 
#declare d = seed (127654);
#declare e = seed (12345);   
#declare f = seed (123);      
#declare g = seed (423);     
     
#declare iris = 1; // thingies with arms  
#declare bot = object {irisphere (a,b,c,d,e,f) scale 0.03 rotate <-0,20,18> translate <1.1,0.6,-2>}    
       
object {bot}