
#macro crystal(MinW,MaxW,MaxI,MinH,MaxH,MaxO,MinA,MaxA,RSeed)
   #local Rnd = seed(RSeed);
   #local ROff = rand(Rnd)*60;
   intersection {
      plane { -y,0 }
      #local ctr = 0;
      #while (ctr < 3)
         #local P = vrotate(<rand(Rnd)*MaxI,0,0>,<0,rand(Rnd)*360,0>);
         #local W = MinW + (MaxW - MinW) * rand(Rnd);
         plane { x,W rotate (ctr*60+ROff)*y translate P }
         plane { -x,W rotate (ctr*60+ROff)*y translate P }
         #local P = vrotate(<rand(Rnd)*MaxO,MinH+(MaxH-MinH)*rand(Rnd),0>,<0,rand(Rnd)*360,0>);
         #local A = MinA + (MaxA - MinA) * rand(Rnd);
         plane { y,0 rotate <A,ctr*60+ROff,0> translate P }
         plane { y,0 rotate <-A,ctr*60+ROff,0> translate P }
         #local ctr = ctr + 1;
      #end
   }
#end

#macro cluster (MinC,MaxC,MaxR,CData,RSeed)
   #local Rnd = seed(RSeed);
   #local MaxR = MaxR * ((MaxR/90) / cos(3*pi/2+pi/2*(MaxR/90)));
   #local NumC = MinC + (MaxC - MinC) * rand(Rnd);
   merge {
      #local ctr = 0;
      #while (ctr < NumC)
         #local H = CData[3] + (CData[4] - CData[3])*rand(Rnd);
         object {
            crystal(
               CData[0],
               CData[1],
               CData[2],
               H,
               H + CData[5] * rand(Rnd),
               CData[6],
               CData[7],
               CData[8],
               rand(Rnd)*65535
            )
            rotate <90*cos(3*pi/2+(MaxR*rand(Rnd)/90)*pi/2),360*rand(Rnd),0>
         }
         #local ctr = ctr + 1;
      #end
      bounded_by { sphere { 0,sqrt(pow((CData[1]+CData[2])*(2*sqrt(3)/3),2)+pow(CData[4]+CData[5],2)) } }
   }
#end

object {cluster (15,20,60,array[9]{0.1,0.2,0.04,1,2,1,0.15,45,65},55410) scale 0.36 rotate <0,180,0> translate <-1.6,0.15,-1.8> /*hollow double_illuminate*/}
            
