#version 3.7;
#include "functions.inc"
#include "shapes3.inc"
global_settings {
    assumed_gamma 1.0
    max_trace_level 3
}
background {rgbt<0.0509, 0.0509, 0.0509, 0>}
#declare Material_003_finish = finish {
    specular 0.5
    roughness 0.01
    diffuse  0.8
    conserve_energy
}

#declare Material_001_finish = finish {
    specular 0.5
    roughness 0.01
    diffuse  0.8
    conserve_energy
}

#declare Material_002_finish = finish {
    specular 0.5
    roughness 0.01
    diffuse  0.8
    conserve_energy
}

#declare Material_finish = finish {
    diffuse  0.6
    ambient <0.022, 0.022, 0.022>
}

#declare Texture = pigment{
    granite
    color_map {
        [0 color rgbf<0.42,0.2,0.2,0>]
        [0.5 color rgbf<0.5,0.5,0.02,0>]
        [0.6 color rgbf<0.6,0.2,0.2,0>]
        [0.6 color rgbf<0.3,0.2,0.2,0>]
    } 
    frequency 2 
}
#declare Texture_001 = normal {
    granite
    148.2
    frequency 2 
    scale <0.1,0.1,0.1> 
}
#declare Material_003_tex =
texture {pigment {color rgb <0.8,0.8,0.8>} finish{Material_003_finish}}
#declare Material_001_tex =
texture {pigment {color rgb <0.8,0.8,0.8>} finish{Material_001_finish}}
#declare Material_002_tex =
texture {pigment {color rgb <0.8,0.8,0.8>} finish{Material_002_finish}}
#declare Material_tex =
texture {pigment {Texture} normal {Texture_001} finish{Material_finish}}
#include "b608CageB_dec.inc"
object {b608CageB_ob 
    texture{Material_003_tex}
}
#include "b608CageA_dec.inc"
object {b608CageA_ob 
    texture{Material_001_tex}
}
#include "b608Balls_dec.inc"
object {b608Balls_ob 
    texture{Material_002_tex}
}
#include "b608Race_dec.inc"
object {b608Race_ob 
    texture{Material_tex}
}
light_source {
    <11.8,5.9,16.2>
    color rgb<1, 1, 1>
    parallel
    point_at  <0, 0, -1>
}
#declare Camera_Location = <16.418427, 13.147211, 41.699253>;
#declare Camera_Look_At = <0, 0, -1>;
#declare Camera_Angle = 49.134343;
#include "transforms.inc"
#declare Cam_V = Camera_Look_At - Camera_Location;
#declare Cam_Ho = sqrt(pow(Cam_V.x,2)+pow(Cam_V.z ,2));
#declare Cam_Y = Camera_Look_At.y - Camera_Location.y;
camera {
    angle  Camera_Angle
    right <-1.6077777759896383, 0, 0>
    location  <0,Camera_Look_At.y,-Cam_Ho>
    matrix<1,0,0, 0,1,0, 0,Cam_Y/Cam_Ho,1, 0,0,0>
    Reorient_Trans(z,<Cam_V.x,0,Cam_V.z>)
    translate<Camera_Look_At.x+2,1.25,Camera_Look_At.z+2>
}
