/* radiosity_pretrace.inc 1.0a
 * Persistence of Vision Ray Tracer include file
 *
 * Sets up radiosity pretrace parameters using some of the recommendations in
 * the Radiosity Voodoo thread in povray.text.tutorials.
 *
 * Copyright © 2014 Richard Callwood III.  Some rights reserved.
 * This file is licensed under the terms of the GPL 3.0.
 * See http://www.gnu.org/licenses/gpl-3.0.html for more information.
 *
 * Vers  Date         Notes
 * ----  ----         -----
 * 1.0   16-Jan-2014  Created.
 * 1.0a  17-Jan-2014  A correction is made to the user manual.
 */
#ifndef (Radiosity_Pretrace_Inc_Temp)
#declare Radiosity_Pretrace_Inc_Temp = version;
#version 3.5;
#debug "#include \"radiosity-pretrace.inc\" //version 1.0a\n"
#declare RADIOSITY_PRETRACE_VERSION = 1.0;

#ifndef (Radiosity_Pretrace_debug) #declare Radiosity_Pretrace_debug = no; #end

#macro Radiosity_Pretrace (Max, Min)
  #local radiosity_Min =
    (Min < 1? Min: Min / max (image_width, image_height));
  #local radiosity_Max =
    radiosity_Min * pow (2, floor (ln (Max / radiosity_Min) / ln(2)));
  pretrace_start radiosity_Max
  pretrace_end radiosity_Min
  #if (Radiosity_Pretrace_debug)
    #debug "Radiosity_Pretrace ("
    #debug str (Max, 0, -1)
    #debug ", "
    #debug str (Min, 0, -1)
    #debug "):\n  pretrace_start "
    #debug str (radiosity_Max, 0, -1)
    #debug "\n  pretrace_end "
    #debug str (radiosity_Min, 0, -1)
    #debug "\n"
  #end
#end

#version Radiosity_Pretrace_Inc_Temp;
#end
