/*

	sphere-invert.pov
	
	Performs spherical inversion (a conformal transformation) on a geodesic sphere. The operation redistributes the geometry
	to increase the density at the top or bottom. You can also flatten the geometry onto a plane.

*/

#version 3.7;

global_settings{assumed_gamma 1.0}

#default{finish{ambient 0}}

camera{
	location <0, 5, -10>
	look_at 0
	angle 15
}

light_source{<-.5, 1, -.2>*1e7, <1.85, 1.7, 1.5>}
light_source{<.5, -1, -.3>*1e7, <.1, .15, .2>}

background{rgb <.075, .15, .2>}

#include "Geodesic.inc"

#macro Geodesic_Triangle(P1, P2, P3)
	
	#local Offs = 1.5; // use 1.000001 or -1.000001 to flatten geometry
	
	// perform spherical inversion
	#local P1b = (P1-y*Offs)/(pow(P1.x, 2)+pow(P1.y-Offs, 2)+pow(P1.z, 2));
	#local P2b = (P2-y*Offs)/(pow(P2.x, 2)+pow(P2.y-Offs, 2)+pow(P2.z, 2));
	#local P3b = (P3-y*Offs)/(pow(P3.x, 2)+pow(P3.y-Offs, 2)+pow(P3.z, 2));
	
	//triangle{P1_, P2_, P3_}
	#local Thk = 0.01;
	cylinder{P1b, P2b, Thk}
	cylinder{P2b, P3b, Thk}
	cylinder{P3b, P1b, Thk}
	
#end

union{
	Geodesic_Sphere(2, 3)
	
	// center the object manually
	translate y*1.1
	
	rotate y*15
	pigment{rgb 1}
}