/*

	lengths.pov
	
	If you want to know the edge lengths for a real-world geodesic structure, this is one way to find out!

*/

#version 3.7;

global_settings{assumed_gamma 1.0}

#default{finish{ambient 0}}

camera{
	location <0, 5, -10>
	look_at y/3
	angle 12
}

light_source{<-.5, 1, -.2>*1e7, <1.85, 1.7, 1.5>}
light_source{<.5, -1, -.3>*1e7, <.1, .15, .2>}

background{rgb <.075, .15, .2>}

#include "Geodesic.inc"
#include "transforms.inc"

// Rune's superior alignment macro
#macro Z_Align( Normal_vector, Z_vector )
	#local ObjectZ = vnormalize( Z_vector );
	#local ObjectY = VPerp_Adjust( Normal_vector, Z_vector );
	#local ObjectX = vcross( ObjectY, ObjectZ );
	transform{ Shear_Trans( ObjectX, ObjectY, ObjectZ ) }
#end

// a macro to make things easier on ourselves
#macro Cylinder_Measure(P1, P2, Thk, TextSize)
	
	#local Ctr = (P1+P2)/2;
	#local Len = vlength(P2-P1);
	
	#local TextObject =
		text{
			ttf "lucon.ttf"
			str(Len*100, 0, 2)
			.05, 0
		}
	
	union{
		object{
			TextObject
			Center_Trans(TextObject, x+y+z)
			scale TextSize
			#if(P1.y>=P2.y)
				rotate z*180
			#end
			rotate <90, 270, 0>
		}
		box{
			<-TextSize/2, 0, -Len*.4>, <TextSize/2, 0, Len*.4>
			pigment{rgb x+y transmit 0}
			finish{ambient .25 emission .25}
		}
		
		Z_Align(Ctr, P2-P1)
		
		translate Ctr*1.02
		pigment{rgb z}
		finish{ambient 1 emission 1 diffuse 0}
	}
	
	cylinder{P1, P2, Thk}
#end

#macro Geodesic_Triangle(P1, P2, P3)
	
	// find the middle of this triangle
	#local MidPt = (P1+P2+P3)/3;
	
	// create objects for only those triangles residing above y=0
	#if(MidPt.y>0)
		triangle{P1, P2, P3}
		#local Thk = 0.01;
		#local TxtSize = 0.055;
		Cylinder_Measure(P1, P2, Thk, TxtSize)
		Cylinder_Measure(P2, P3, Thk, TxtSize)
		Cylinder_Measure(P3, P1, Thk, TxtSize)
	#end
#end

union{
	Geodesic_Sphere(2, 3) // for type 2, odd frequencies work well when clipping above y=0
	pigment{rgb 1}
	rotate y*15
}