/*

	clipping.pov
	
	Shows how to remove the bottom hemisphere of a geodesic sphere to make a dome.

*/

#version 3.7;

global_settings{assumed_gamma 1.0}

#default{finish{ambient 0}}

camera{
	location <0, 5, -10>
	look_at y/3
	angle 15
}

light_source{<-.5, 1, -.2>*1e7, <1.85, 1.7, 1.5>}
light_source{<.5, -1, -.3>*1e7, <.1, .15, .2>}

background{rgb <.075, .15, .2>}

#include "Geodesic.inc"

#macro Geodesic_Triangle(P1, P2, P3)
	
	// find the middle of this triangle
	#local MidPt = (P1+P2+P3)/3;
	
	// create objects for only those triangles residing above y=0
	#if(MidPt.y>0)
		triangle{P1, P2, P3}
		#local Thk = 0.02;
		cylinder{P1, P2, Thk}
		cylinder{P2, P3, Thk}
		cylinder{P3, P1, Thk}
	#end
#end

union{
	Geodesic_Sphere(2, 3) // for type 2, odd frequencies work well when clipping above y=0
	pigment{rgb 1}
}