/*

	basic.pov
	
	Basic usage of Geodesic.inc. Shows how to make your own triangle object.

*/

#version 3.7;

global_settings{assumed_gamma 1.0}

#default{finish{ambient 0}}

camera{
	location <0, 5, -10>
	look_at 0
	angle 15
}

light_source{<-.5, 1, -.2>*1e7, <1.85, 1.7, 1.5>}
light_source{<.5, -1, -.3>*1e7, <.1, .15, .2>}

background{rgb <.075, .15, .2>}

#include "Geodesic.inc"

#macro Geodesic_Triangle(P1, P2, P3)
	triangle{P1, P2, P3}
	#local Thk = 0.03;
	cylinder{P1, P2, Thk}
	cylinder{P2, P3, Thk}
	cylinder{P3, P1, Thk}
#end

union{
	Geodesic_Sphere(2, 1)
	pigment{rgb 1}
}