/*

	PolyGrad-usageB.pov
	
	Demonstrates a use for the Geodesic_PolyGrad function.

*/

#version 3.7;

global_settings{assumed_gamma 1.0}

#default{finish{ambient 0}}

camera{
	location <0, 5, -10>
	look_at 0
	angle 15
}

light_source{<-.5, 1, -.2>*1e7, <1.85, 1.7, 1.5>}
light_source{<.5, -1, -.3>*1e7, <.1, .15, .2>}

background{rgb <.075, .15, .2>}

#include "Geodesic.inc"

// a linear interpolation macro
#macro Lerp(A, B, C) A*(1-C) + B*C #end

#macro Geodesic_Triangle(P1, P2, P3)
	#local Rad1 = .0025;
	#local Rad2 = .02;
	#local R1 = Lerp(Rad2, Rad1, Geodesic_PolyGrad(P1.x, P1.y, P1.z));
	#local R2 = Lerp(Rad2, Rad1, Geodesic_PolyGrad(P2.x, P2.y, P2.z));
	#local R3 = Lerp(Rad2, Rad1, Geodesic_PolyGrad(P3.x, P3.y, P3.z));
	
	cone{P1, R1, P2, R2}
	cone{P2, R2, P3, R3}
	cone{P3, R3, P1, R1}
#end

union{
	Geodesic_Sphere(2, 12)
	pigment{rgb 1}
}