/*

	PolyGrad-usageA.pov
	
	Demonstrates some uses for the Geodesic_PolyGrad function.

*/

#version 3.7;

global_settings{assumed_gamma 1.0}

#default{finish{ambient 0}}

camera{
	location <0, 5, -10>
	look_at 0
	angle 15
}

light_source{<-.5, 1, -.2>*1e7, <1.85, 1.7, 1.5>}
light_source{<.5, -1, -.3>*1e7, <.1, .15, .2>}

background{rgb <.075, .15, .2>}

#include "Geodesic.inc"

// a new macro to make life easier
#macro Cylinder(P1, P2, Thk, Threshold)
	// create cylinders only when both points' gradient values are below the threshold value
	#if(Geodesic_PolyGrad(P1.x, P1.y, P1.z) < Threshold & Geodesic_PolyGrad(P2.x, P2.y, P2.z) < Threshold)
		cylinder{P1, P2, Thk}
	#end
#end

#macro Geodesic_Triangle(P1, P2, P3)
	#local Thk = 0.015;
	#local Thresh = 0.5;
	Cylinder(P1, P2, Thk, Thresh)
	Cylinder(P2, P3, Thk, Thresh)
	Cylinder(P3, P1, Thk, Thresh)
#end

union{
	Geodesic_Sphere(2, 8)
	
	sphere{
		0, 1
		pigment{function{Geodesic_PolyGrad(x, y, z)}} // using 'Geodesic_PolyGrad' as a pigment
	}
	
	pigment{rgb 1}
}