#macro lineto(from, to, dim, tex, trasla, ruota)
    #local Dir=to-from;
    union {
    	cylinder {<0,0,0>,<0,vlength(Dir),0> dim}
    	sphere {0, dim}
    	sphere {<0,vlength(Dir),0>, dim}
	    texture{tex}
	    
	    Point_At_Trans(vnormalize(Dir))
	    translate from
	    translate trasla
	    rotate ruota
	}
#end


#macro linetoMeshCam(from, to, dim, tex, trasla, ruota)
    #local Dir=to-from;
	#declare MeshCamPos = to;
	#declare ActDirection = vnormalize(Dir);
	#declare MeshCamScale=dim;

    CreateMesh4Cam(from,to,dim)
    
    object { MeshCamObject
       Point_At_Trans(ActDirection)
       translate from
       pigment { color Yellow }
    }
    camera{
       mesh_camera{ 1 3
         mesh{
            MeshCamObject
            Point_At_Trans(ActDirection)
            translate from
         }
         smooth 
      }
      location <0,0,.0001> // slightly above the surface
      direction <0,0,1> 
      
   }

#end

// MJF: two macros which extend the corresponding macros from transforms.inc
//      for the use with vectors instead of objects
#macro Shear_Trans_Vec(P,A, B, C)
    #local qx = A.x * P.x + B.x * P.y + C.x * P.z;
    #local qy = A.y * P.x + B.y * P.y + C.y * P.z;
    #local qz = A.z * P.x + B.z * P.y + C.z * P.z;
    <qx,qy,qz>
#end

#macro Point_At_Trans_Vec(Point,YAxis)
   #local Y = vnormalize(YAxis);
   #local X = VPerp_To_Vector(Y);
   #local Z = vcross(X, Y);
   Shear_Trans_Vec(Point,X, Y, Z)
#end

// Moves turtle
#macro turtle_move(regola, tex, trasla, ruota)
	#local n_rules=strlen(regola);
	#local n_currule=0;
	#local NoQM=0;   // Number of Question Marks found
	#declare ActDir = y;
	#while(n_currule<n_rules)
		#local n_currule=n_currule+1;
		#switch (asc(substr(regola,n_currule,1)))
			#case (asc("s"))	// stem
				#declare old_t_coord=t_coord;
				#declare t_coord=t_coord + ActDir*t_lpath;
				#if ( substr(regola,n_currule+1,1)="?" )
				   #local NoQM = NoQM+1;
				   #if (NoQM=1)
				      linetoMeshCam(old_t_coord,t_coord,l_dim, tex, trasla, ruota)
				   #else
				      lineto(old_t_coord,t_coord,l_dim, tex, trasla, ruota)
				   #end
				#else
				   lineto(old_t_coord,t_coord,l_dim, tex, trasla, ruota)
				#end
			    #declare ActDirection=vnormalize(t_coord-old_t_coord);
		        #break
			#case (asc("A"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[0],ActDirection);
			    #break
			#case (asc("B"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[1],ActDirection);
			    #break
			#case (asc("C"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[2],ActDirection);
			    #break
			#case (asc("D"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[3],ActDirection);
			    #break
			#case (asc("E"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[4],ActDirection);
			    #break
			#case (asc("F"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[5],ActDirection);
			    #break
			#case (asc("G"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[6],ActDirection);
			    #break
			#case (asc("H"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[7],ActDirection);
			    #break
			#case (asc("I"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[8],ActDirection);
			    #break
			#case (asc("J"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[9],ActDirection);
			    #break
			#case (asc("K"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[10],ActDirection);
			    #break
			#case (asc("L"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[11],ActDirection);
			    #break
			#case (asc("M"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[12],ActDirection);
			    #break
			#case (asc("N"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[13],ActDirection);
			    #break
			#case (asc("O"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[14],ActDirection);
			    #break
			#case (asc("P"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[15],ActDirection);
			    #break
			#case (asc("Q"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[16],ActDirection);
			    #break
			#case (asc("R"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[17],ActDirection);
			    #break
			#case (asc("S"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[18],ActDirection);
			    #break
			#case (asc("T"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[19],ActDirection);
			    #break
			#case (asc("U"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[20],ActDirection);
			    #break
			#case (asc("v"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[21],ActDirection);
			    #break
			#case (asc("w"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[22],ActDirection);
			    #break
			#case (asc("X"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[23],ActDirection);
			    #break
			#case (asc("Y"))	
				#declare ActDir=Point_At_Trans_Vec(Directions[24],ActDirection);
			    #break
			#case (asc("*"))	// Increase step size by 10%
				#declare t_lpath=min(t_lpath*1.1,t_lpath_max);
			    #break
			#case (asc("/"))	// Decrease step size by 10%
				#declare t_lpath=max(t_lpath/1.1,t_lpath_min);
			    #break
			#case (asc(","))	// Increase step size randomly
				#declare t_lpath=t_lpath_min+rand(Zufall2)*(t_lpath_max-t_lpath_min);
			    #break
			#case (asc("["))	// Stack push - only n_max_stacks levels
				#declare a_coord_stack_old[n_curr_stack]=old_t_coord;
				#declare a_coord_stack[n_curr_stack]=t_coord;
				#declare a_angle_stack[n_curr_stack]=ActDir;
				#declare n_curr_stack=n_curr_stack+1;
				#declare l_dim=l_dim*9/10;  // make branch a little bit thinner
			    #break
			#case (asc("]"))	// Stack pop - only n_max_stacks levels
				#declare n_curr_stack=n_curr_stack-1;
				#declare old_t_coord = a_coord_stack_old[n_curr_stack];
				#declare t_coord=a_coord_stack[n_curr_stack];
				#declare ActDir=a_angle_stack[n_curr_stack];
				#declare l_dim=l_dim*10/9; // restore old radius
				
			    #break
		#end
	#end
#end
// ----------------------------------------

// String rewriting system ----------------

// for now 'carattere' is just a char, not a string
#macro str_replace(stringa,carattere,con)
	#local n=0;
	#local n_tmp=strlen(stringa);
	#declare str_replaced="";
	#while(n<n_tmp)
		#local n=n+1;
		#if(asc(substr(stringa,n,1))=asc(carattere))
			#declare str_replaced=concat(str_replaced,con);
		#else
			#declare str_replaced=concat(str_replaced,substr(stringa,n,1));
		#end
	#end
#end

// for now 'carattere' is just a char, not a string
#macro str_pos(stringa,carattere)
	#local n=0;
	#local n_tmp=strlen(stringa);
	#declare str_position=0;
	#while(n<n_tmp)
		#local n=n+1;
		#if(asc(substr(stringa,n,1))=asc(carattere))
		    #declare str_position=n;
		    #local n=n_tmp;
		#end
	#end
#end


#macro fill_array_rules(rules)
	// Generate temporary array
	#declare n_rules=0;
	#local n_tmp=strlen(rules);
	#local n=0;
	#local k_tmp="";
	#local v_tmp="";
	#local p_tmp=""; // MJF: added temporary string for the probability
	#local is_k=1;
	#local is_v=0;
	#local is_p=0;   // MJF: added probability indicator
	#local a_tmp_k=array[n_max_rules];
	#local a_tmp_v=array[n_max_rules];
	#local a_tmp_p=array[n_max_rules];    // MJF: added an array to store probabilities
	
	/***********************************************************
	MJF:
	To extend Paolo's original parser to handle probabilities it is necessary to introduce
	the idea of having more then one rule per "production". With Paolo's original a production
	is the same as a rule. n_max_rules is still the maximum of possible rules, the maximum
	number of possible "productions" is less (or equal) to n_max_rules.
	
	The production identifier is simply a number. It is assumed that all rules for the same
	production are given in direct succession without being interrupted by a rule from an
	other production.
	
	All given probabilities must sum up to one and be positive of course.
	
	For example a production can be composed by the following three rules:
	
	   b=s?:0.8;
	   b=[As?]s?:0.1;
	   b=[As?][Bs?]s?:0.1;
	   
	Here the = denotes the seperation between left- and right hand side auf a rule.
	The colon seperates the right hand side of the rule from the probability and
	the semicolon ends the rule.
	The left hand side is to be replaced by the right hand side with the given probabily.
	For the first example above that means "b" ist to be replaced by "s?" with a
	probability of 0.8.
	
	(One will ask at this moment what this probalistic L-System does after one iteration since
	it produces no new "b" at the right side. The answer is the question mark. I need an
	so called open L-System. In an open L-System one has two main steps during one iteration.
	First one has to apply all productions to the previous string. The productions must have
	a so called "open parameter": hte question mark. The second step is to handle all the open
	parameters and replace them with proper letters of the original L-System.
	
	Here we will construct a something link a plant. The alphabet of the current L-System
	consists of the following letters:
	
	   s : draw a stem segment
	   [ : start a new branch
	   ] : end a branch
	   b : bud, possible start of a new branch or simply prolonging one
	   A..Q : change direction of the turtle (in this test of concept I will use a discret
	          set of 17 possible changes of direction)
	   p : prune branch
	   ? : open parameter, replaced by "Rsb" with R in {A,..,Q} (the mesh cam has found enough
	       light in a certain direction) or "p" (only darkness found, growth into an other stem
	       or an other object, prune stem)	        
	
	***********************************************************/
	
	// Count rules to dimensionate array
	#while(n<n_tmp)
		#local n=n+1;
		#switch (asc(substr(rules,n,1)))
			#case(asc(r_init))	// Init a rule
				#local is_k=0;
				#local is_v=1;
				#local is_p=0;
			#break
			#case(asc(r_prob))
			    #local is_k=0;
			    #local is_v=0;
			    #local is_p=1;
			#break;
			#case(asc(r_end))	// End a rule: store the data
				#declare n_rules=n_rules+1;
				#local is_k=1;
				#local is_v=0;
				#local is_p=0;
				#local a_tmp_p[n_rules-1]=p_tmp;
				#local a_tmp_k[n_rules-1]=k_tmp;
				#local a_tmp_v[n_rules-1]=v_tmp;
				#local k_tmp="";
				#local v_tmp="";
				#local p_tmp="";
			#break
			#case(asc(" "))		// Avoid garbage
			#break
			#else				// Concat data
				#if(is_k=1)
					#local k_tmp=concat(k_tmp,substr(rules,n,1));
				#end
				#if(is_v=1)
					#local v_tmp=concat(v_tmp,substr(rules,n,1));
				#end
				#if(is_p=1)   // MJF: store the probability
					#local p_tmp=concat(p_tmp,substr(rules,n,1));
				#end
		#end           
	#end

	// Declares rules array
	#declare a_rules_k=array[n_rules];  // left sides
	#declare a_rules_v=array[n_rules];  // right sides
	#declare a_rules_p=array[n_rules];  // probabilities
	#declare a_rules_r=array[n_rules];  // production counter
	// Fills array
	
	#local p_count_tmp=0;
	#local p_tmp_k="";
	#local i=0;
	#while(i<n_rules)
	    #if ( a_tmp_k[i] != p_tmp_k )
	        #local p_count_tmp = p_count_tmp+1;
	        #local p_tmp_k = a_tmp_k[i];
	    #end
		#declare a_rules_k[i]=a_tmp_k[i];
		#declare a_rules_v[i]=a_tmp_v[i];
		#declare a_rules_p[i]=a_tmp_p[i];
		#declare a_rules_r[i]=p_count_tmp;
		#local i=i+1;
	#end
#end

// Rewriting system (a bit invented..)
#macro parse_string(axiom, a_rules_k, a_rules_v, n_step)
	#local axiom_applicato=axiom;
	// Sobstitution of rules to axiom
	#local i_s=0;
	#while(i_s<n_step)
		#local i=0;
		#local init_axiom=axiom_applicato;
		#while(i<n_rules)
		    str_pos(init_axiom,a_rules_k[i])
		    #if(str_position>0)
			    str_replace(axiom_applicato,a_rules_k[i],a_rules_v[i])
			    #local axiom_applicato=str_replaced;
			#end
			#local i=i+1;
		#end
		#local i_s=i_s+1;
	#end
	// Updates final rules
	#declare t_rules=axiom_applicato;
#end

/*************************************************************
MJF: I need a parser which only takes one step, the iteration
     will be done by an "animation"
     Since we can have more than one rule per production and
     will choose the right side by random
     we must work a little bit more.
*************************************************************/
#macro parse_string_once(ActString, LeftSides, RightSides, Probabilities, ProductionID)
    #local i=0;
    #local N_Prods=ProductionID[n_rules-1];
    #local ProductionCompleted=false;
    #local TempString=ActString;
    #local ActProd=0;
    #while (i < n_rules)
       #local ActProd=ProductionID[i];
       #local ActLSide=LeftSides[i];
       #local n_tmp_rules=0; // number of rules of the actual production
       #local j=0;
       #while (i+j < n_rules)
          #if (ActProd = ProductionID[i+n_tmp_rules])
             #local n_tmp_rules = n_tmp_rules + 1;
          #end
          #local j=j+1;
       #end
       #local Probs=array[n_tmp_rules+1]
       #local Probs[0] = 0;
       #local j=1;
       #while (j<n_tmp_rules)
          #local Probs[j] = val(Probabilities[i+j-1]);
          #local Probs[j]=Probs[j]+Probs[j-1];
          #local j=j+1;
       #end   
       #local Probs[n_tmp_rules] = 1; // ensure it is 1
       
       str_pos(TempString,ActLSide)
       #while ( 0<str_position )
           // find right side by random
           #local j=0;
           #local ActProb=rand(Zufall)*0.999; // paranoid? 
           #while ( Probs[j]<ActProb )
              #local j=j+1;
           #end
           #local ActRSide = RightSides[j-1];
           #local LeftString = substr(TempString,1,str_position-1);
           #if (str_position+strlen(ActLSide) <= strlen(TempString) )
               #local RightString=substr(TempString,
                                         str_position+strlen(ActLSide),
                                         strlen(TempString) - (str_position+strlen(ActLSide))+1);
           #else
               #local RightString="";
           #end
           #local TempString = concat(LeftString,ActRSide,RightString);

           str_pos(TempString,ActLSide)
       #end
       
       #local i=i+n_tmp_rules;
    #end

    #declare NewString = TempString;
    
    #declare n_iterations = n_iterations +1;
    
#end



// ----------------------------------------

// Tools ----------------------------------

// Init the turtle
#macro init_turtle(axiom, rules, directions, n_step, tex, trasla, ruota)
	#declare t_dir=directions;
	// By now...
	#declare t_lpath=t_lpath/n_step;
	fill_array_rules(rules)
	parse_string(axiom, a_rules_k, a_rules_v, n_step)
	turtle_move(t_rules, tex, trasla, ruota)
#end
// ----------------------------------------

