#version 3.7;                                                                                                   #version 3.7;

#include "colors.inc"
#include "rad_def.inc"
#include "transforms.inc"
#include "functions.inc"
#include "rand.inc"
#include "glass.inc"

global_settings {
   assumed_gamma 1
   radiosity { Rad_Settings(Radiosity_OutdoorLQ,on,on) }
   charset ascii
}


#include "LSystem01.inc"
#include "MeshCam.inc"

// Default texture for stems: As Black as possible, no reflections
// A nearby stem should push a growing one off
#declare StemTexture1 = texture {
   pigment { color Black }
   finish { ambient 0 diffuse 0 }
}
// Alternate stem texture to make them visible
#declare StemTexture2 = texture {
   pigment { color Yellow*5 }
}

#declare MaxMeshCamFrames=1900; // in fact the mesh cam is invoked only by half of this frames
#declare ActDirection=y;       // initialise with "up", if the axiom starts with an other letter
                               // choose the proper direction from "MeshCam.inc" 

// Defaults -------------------------------
// MJF: Most from Paolo, I comment some out which I didn't nedd and added some others
#declare t_coord=<0,0,0>; 	   // Current coordinates
#declare old_t_coord=<0,-1,0>; // MJF: needed to calculate the old direction
//#declare t_angle=0;			// Current angle
#declare t_lpath=0.05;      	// Path length
#declare t_lpath_min=0.01;   // MJF: Paolo left a random change in the actual stem length as "to do"
#declare t_lpath_max=0.1;   //      I introduced a minimum and a maximum stem length and an own reandom generator for
                            //      the turtle to solve this isssue
//#declare t_dir=6;			// Rotation=360/directions
//#declare t_level=0;			// current level
#declare l_dim=0.1;		    // Line diameter
#declare r_init="=";		// Rule init
#declare r_end=";";			// Rule end
#declare r_prob=":";        // MJF: added delimiter for probabilities
#declare n_rules=0;			// Num rules
#declare n_max_rules=100;	// Max num rules
#declare n_max_stacks=200;	// Max stacks number
#declare a_coord_stack=array[n_max_stacks];		// Coordinates Stack
#declare a_coord_stack_old=array[n_max_stacks];		// MJF: Old Coordinates Stack (see above)
#declare a_angle_stack=array[n_max_stacks];		// Angles stack
#declare n_curr_stack=0;
//#declare t_rules="";		// Final rule
#declare n_max_iterations=100;
#declare n_iterations=0;
#declare Zufall2=seed(1710); // an own random generator for the turtle, otherwise the stem lengths cannot be reproduced
// ----------------------------------------



#declare BoxMat1 = material {
   texture {
      pigment { color Blue }
   }
}
#declare BoxMat2 = material {
   texture { 
      pigment { color rgbft <0.1, 0.15, 0.5, 0.9, 0.3> }
      finish {
         ambient 0
         diffuse 0.1
      }
   }
}


/**********************************************************
During a session POV can handle strings (much) longer than 256 characters,
but the #write- and the #read directives yields errors used with
longer strings. So I (most likely re-)invented this little  trick.

The EndFrame is the frame where the current iteration over
the open parameter (the ?) ends.

The random generator has to be given to the next frame, otherwise
one would have always the same decisions.
**********************************************************/
#macro WriteFile()
   #fopen OutFile "ActualString.inc" write
      #write (OutFile,"#declare NewString=\"\";\n")
      #declare Count=0;
      #declare StringParts=int(strlen(NewString)/64)+1;
      #while (Count<StringParts)
         #write (OutFile,"#declare NewStringPart=\"",substr(NewString,Count*64+1,min(64,strlen(NewString)-Count*64 )),"\";\n")
         #write (OutFile,"#declare NewString=concat(NewString,NewStringPart);\n")
      
         #declare Count=Count+1;
      #end
      #write (OutFile,"#declare EndFrame=",EndFrame,";\n")
      #write (OutFile,"#declare Zufall=",int(rand(Zufall)*10000),";\n")
      #fclose OutFile
#end


#declare MinimumBrightness=0.1;
#macro find_brigthest_spot()  // find brightest spot and replace first question mark
   #declare EvalPig=pigment { image_map { png concat( "main",str(frame_number-1,-4,0),".png" ) } scale <-1,1,1>}
   #declare TestColors = array[17]
   #local i=0;
   #while (i<17)
      #declare j=0;
      #declare TestColors[i]=eval_pigment(EvalPig,EvalPoints[i]).gray;
      #while (j < 32)
         #declare TestColors[i] = TestColors[i]
             +eval_pigment(EvalPig,EvalPoints[i]+<Rand_Normal(0,0.025,Zufall),Rand_Normal(0,0.025,Zufall),0>).gray;
         #declare j=j+1;
      #end
      #declare TestColors[i] = (TestColors[i]/33);
      #local i=i+1;
   #end
   #local BrightestPoint=17;
   #local ActColor=Black;
   #local i=0;
   #while (i<17)
      #if (ActColor.x < TestColors[i].x)
         #local ActColor = TestColors[i];
         #local BrightestPoint = i;
      #end
      #local i=i+1;
   #end
   
   #if (ActColor.x < MinimumBrightness)
      #local BrightestPoint=17;
   #end
   
   #if(BrightestPoint=17)
      #local MiddleString="p"; // prune, not enough light
   #else
      #local MiddleString=concat(DirLetters[BrightestPoint],"sb");
   #end
   str_pos(NewString,"?")
   #local LeftString = substr(NewString,1,str_position-1);
   #if (str_position+1 <= strlen(NewString) )
      #local RightString=substr(NewString,
                                str_position+1,
                                strlen(NewString) - (str_position+1)+1);
   #else
      #local RightString="";
   #end
   #declare NewString = concat(LeftString,MiddleString,RightString);

#debug concat("Actual Replacement: ",MiddleString,"\n")

#end

#macro Count_QuestionMarks(String)
   #declare NoQM_=0;
   #local i=1;
   #while (i<= strlen(String) )
      #if (substr(String,i,1)="?")
         #declare NoQM_=NoQM_+1;
      #end
      #local i=i+1;
   #end
#end

// The actual grammar, not very elaborated
// see further comments in "lsystem01.inc"
fill_array_rules("b=s?:0.5625;b=*s?:0.1;b=/s?:0.1;b=,s?:0.2;b=[Ms?]s?:0.0125;b=[Is?]s?:0.0125;b=[Os?]s?:0.0125;")
//fill_array_rules("b=s?:0.8;b=[Ms?]s?:0.1;b=[Ms?][Is?]s?:0.1;")

// log grammar segmentation
#local i=0;
#while(i<n_rules)
	#debug concat(a_rules_k[i],"\n")
	#debug concat(a_rules_v[i],"\n")
	#debug concat(a_rules_p[i],"\n")
	#debug concat(str(a_rules_r[i],2,0),"\n")
	#local i=i+1;
#end

// initial frame	
#if (frame_number=0)

   #declare Zufall=seed(9244);
   
   // this is the axiom of the L-system, the initial tree (or better scrub)
   parse_string_once("Ysssss[Psssb]sss[vsssb]ssss[SsssSsssb]ssss[Dssssb]ssb", a_rules_k, a_rules_v, a_rules_p, a_rules_r)
   #debug concat(NewString,"\n")
   #declare EndFrame=2;                                                   
   
   WriteFile()

   #declare BoxMat = material { BoxMat2 }
   turtle_move(NewString,StemTexture1,0,0)
   #undef MeshCamPos
#end

/*************************************************
  now the main iteration. An odd frame_number uses the mesh cam. An even frame_number
  evaluates its result and displays the actual scrub. The latter step is not really
  necessary but I wanted to see what happens.
  
*************************************************/
#if ( (0<frame_number) & (frame_number<= MaxMeshCamFrames) )
   #include "ActualString.inc"
   #debug concat(NewString," ",str(EndFrame,5,0),"\n")
   #declare Zufall=seed(Zufall);


   #if ( mod(frame_number,2)=1 ) // frame_number odd
      #declare BoxMat = material { BoxMat1 }
      turtle_move(NewString,StemTexture1,0,0)
   #else // frame_number even
      find_brigthest_spot()  // find brightes spot and replace first question mark
      
      #if ( frame_number = EndFrame)
         /* EndFrame should be even and no more question marks present.
            In this case we have to apply the rules until a new question mark appears.
            
            (With the special grammar above the while-loop is not necessary,
             but may be some one will use another grammar some day 
         */
         str_pos(NewString,"?")
         #while ( (str_position = 0 ) & (n_iterations <= n_max_iterations) )
            parse_string_once(NewString, a_rules_k, a_rules_v, a_rules_p, a_rules_r)
            str_pos(NewString,"?")
         #end
         Count_QuestionMarks(NewString)
         #declare EndFrame = EndFrame +2*NoQM_;
      #end



      // write new string to file
      WriteFile()
      #declare BoxMat = material { BoxMat2 }
      turtle_move(NewString,StemTexture2,0,0)
      #undef MeshCamPos // abuse of MeshCamPos, use the "nornal" camera
      
  #end
   

#end

#if (MaxMeshCamFrames<=frame_number)
   #include "ActualString.inc"
   #debug concat(NewString," ",str(EndFrame,5,0),"\n")
   #declare Zufall=seed(Zufall);
      #declare BoxMat = material { BoxMat2 }
      turtle_move(NewString,StemTexture2,0,0)
      #undef MeshCamPos // abuse of MeshCamPos again, use the "nornal" camera

#end

// the absolute must-have:
plane {
   y,0
   pigment { checker Gray15, Gray10 }
   finish { ambient 0 diffuse 0.6 }
}

#declare LightColor=White*2;
light_source { <0,20,10>, LightColor }
light_source { // to accentuate the sky a little bit
   <0,20,10>, LightColor
   spotlight point_at <0,10,5>*100 radius 10 falloff 60 tightness 10
}

// the obstacle
#declare Box=difference {
   box { <-2,0,-(t_lpath_max+l_dim)*1.01>,<2,6,(t_lpath_max+l_dim)*1.01> }  // stems should not penetrate the walls
   cylinder {<0,3,-1>,<0,3,1>,0.5} 
   cylinder {<0,1.5,-1>,<0,1.5,1>,0.5} 
   cylinder {<0,4.5,-1>,<0,4.5,1>,0.5} 
}

union {
object { Box   
   translate <0,0,3>
   material { BoxMat }
}
object { Box   
   translate <0,0,-3>
   material { BoxMat }
}
object { Box
   rotate y*90   
   translate <-3,0,0>
   material { BoxMat }
}
object { Box
   rotate y*90   
   translate <3,0,0>
   material { BoxMat }
}

box { <-4,6,-4>,<4,7,4> material { BoxMat } }
box { <-4,-6,-4>,<4,-0.0001,4> material { BoxMat } }  // seems a stem can penetrate the ground for some reasons, prune it then

  scale 2
}



// "normal" camera
#ifndef(MeshCamPos)
      #if ( frame_number <= MaxMeshCamFrames )
         #declare CamLoc=vaxis_rotate(<5,3.5,-5>*2.5,y,360*(frame_number-92)/100) ;
      #else
         #declare CamLoc=vaxis_rotate(<5,3.5,-5>*2.5*(1+(frame_number-MaxMeshCamFrames)/100*2),y,360*(frame_number-92)/100) ;
      #end
   camera {
      location CamLoc
      look_at <0,1,0>
   }
#end

// simple sky
sphere {
   0,1
   pigment { color CornflowerBlue }
      finish { ambient 0 diffuse 0.6  
      emission 1
   }
  scale 1000
  hollow
}



