#include "functions.inc"
#include "colors.inc"



/***********************************************************
Map with the contour lines. The map is drawn with the Gimp as a transparent
layer over an original map with topographic contour lines (a little bit clumsy,
I admit). The colors are chosen to meet the height lines. Black is 95 m absolute altitude,
White is 300 m, and for example 200 m is <153,153,153>, the linear interpolation
of Black and White for this altitude. To get the same colors in POV as with the Gimp
you have to specify "gamma 1".

To yield an approximation of the original topology with 1 meter per unit you
have to scale the resulting height_field a little bit: <6000,205,3000>.
**********************************************************/
#declare EvalPig=pigment { image_map { png "Ahrweiler_linien_grau3.png" gamma 1 transmit 10,1} }


#declare FixedTex=
texture{
  pigment{ EvalPig }
  finish{emission 1 diffuse 0 ambient 0}
}


#if ( frame_number = 1)
   #declare OldTex=texture {
      pigment { image_map { png "Ahrweiler_linien_grau3.png" gamma 1 } }
      finish{emission 1 diffuse 0 ambient 0}
   }
#else
   #declare OldTex = texture {
      pigment { image_map { png concat("TerraformTest_Iteration",str(frame_number-1,-3,0),".png") } }
      finish{emission 1 diffuse 0 ambient 0}
   }
#end


/***********************************************************
The averaging texture. The edges are influenced by their
opposites of course, but I judge this a minor issue. Just
make the contour map a little bit bigger then the desired area.
***********************************************************/
#declare Pixel=1/image_width;
#declare BlurTex = texture {
   average
   texture_map {
      #declare CountX=-7;
      #while ( CountX<8)
         #declare CountY = -7;
         #while(CountY<8)
            [ 1 OldTex translate <CountX*Pixel,CountY*Pixel,0> ]
            #declare CountY=CountY+1;
         #end
         #declare CountX=CountX+1;
      #end

   
   }
}


// modified version from screen.inc
#macro Screen_Plane (TextureBottom, TextureTop, Scaling, BLCorner, TRCorner)
union{
   box {
      <-0.000001,-0.000001,0.01>, <+1.000001,+1.000001,0.05>
      texture {TextureBottom}
      no_shadow     // shouldn't cast shadows in the scene
      no_reflection // shouldn't be reflected in scene elements
      hollow on     // for media/fog
      translate <-0.5,-0.5,0>
   }
   box {
      <-0.000001,-0.000001,0>, <+1.000001,+1.000001,-0.02>
      texture {TextureTop}
      no_shadow     // shouldn't cast shadows in the scene
      no_reflection // shouldn't be reflected in scene elements
      hollow on     // for media/fog
      translate <-0.5,-0.5,0>
   }
 
}


#end


// at the end one has to leave out the contour lines since some
// of them are to close together to average the points between.
// Alternatively one could use a smaller field in the averaging
// texture.
#if (frame_number<361)
  object{Screen_Plane(BlurTex,FixedTex,1,<0,0,0>,<1,1,0>)}
#else
  object{Screen_Plane(BlurTex,BlurTex,1,<0,0,0>,<1,1,0>)}
#end

camera {
   orthographic
   location <0,0,-1>
   right x*1
   up y*1
   look_at 0

}

background { color Green }