/* 
   ----------------               Pipetrees.pov                 ------------------------
   ----------------                August 2012                  ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

// The scene is based on macros of Gilles Tran and and started as a reminiscence to his image 'Family' (http://www.oyonale.com/image.php?code=261&mode=info&section=2003&lang=en).
// It uses a modified version of Maketree.pov; don't miss www.oyonale.com for the original macros and artwork of Gilles Tran! 
// Scene requires about 10 GB RAM with higher quality radiosity settings (RAD = 2) at high resolutions (e.g. 5760*3240 pixels)!

#version 3.7;

#declare file_done = 1;  // 0 to generate pipe files in a first pass, set to 1 afterwords to reduce parsing time

#declare RAD       = 2;  // radiosity quality settings 0=out; 1=acceptable; 2=good
                
global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        max_trace_level 5
        noise_generator 2
        #if(RAD = 1)
                radiosity {
                        pretrace_start          0.08
                        pretrace_end            0.04
                        error_bound             1
                        low_error_factor        0.5
                        count                   30                                
                        recursion_limit         2
                        nearest_count           1  
                        gray_threshold          0  
                        minimum_reuse           0.015 
                        brightness              2.3*1.2      
                        adc_bailout             0.005
                        normal on
                        media off
                }
        #end 
        #if(RAD = 2)
                radiosity {
                        pretrace_start          0.08
                        pretrace_end            0.01
                        error_bound             0.2
                        low_error_factor        0.5
                        count                   100                                
                        recursion_limit         2
                        nearest_count           2  
                        gray_threshold          0  
                        minimum_reuse           0.015 
                        brightness              2.3*1.2      
                        adc_bailout             0.005
                        normal on
                        media off
                }
        #end
}        

#declare diff = 1;

#if (RAD > 0)
        #default {finish {ambient 0 diffuse diff*0.7}}
#end

#macro G(Color,g)
        rgb <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end 

#macro H(Color)
        <pow(Color.x,2.2),pow(Color.y,2.2),pow(Color.z,2.2)>
#end 

#macro J(Color,g)
        <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end

#declare Gamma = 2.2/a_g;

#include "stdinc.inc"

#declare cam_loc = <15+2,-15,-38>;
#declare lookat = <5-6,-8.5+2,0>;
#declare cam_ang = 80;

#declare cam_mirror = 1;                                                 // 1 for normal / -1 for mirrored image
#declare cam_z = 0.5*image_width/image_height/tan(radians(cam_ang*0.5)); // amount of camera zoom
#declare cam_a = cam_mirror*image_width/image_height;                    // camera aspect ratio
#declare cam_s = y;                                                      // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                            // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d));                       // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r));                      // camera up vector
#declare cam_dir = cam_d*cam_z;                                          // direction vector scaled
#declare cam_right = cam_r*cam_a;                                        // right vector scaled

camera {
        location cam_loc
        direction 1.5*z 
        right x*image_width/image_height 
        look_at lookat
        angle cam_ang
}

//-----------------------------------------
// Sun & Sky
//-----------------------------------------  

light_source {
        <50,1000,0> 
        color rgb <1,0.920,0.722>*8
        area_light <20,0,0> <0,0,20> 4,4 adaptive 0 jitter circular orient
} 

sky_sphere {
        pigment {
                gradient y 
                color_map {
                        [0.0000 color G(<212,221,239>/255,Gamma)*4]
                        [0.1029 color G(<219,229,244>/255,Gamma)*4]
                        [0.1512 color G(<233,241,250>/255,Gamma)*4]
                        [0.1949 color G(<223,239,252>/255,Gamma)*4]
                        [0.2444 color G(<201,227,252>/255,Gamma)*4]
                        [0.2921 color G(<180,213,250>/255,Gamma)*4]
                        [0.3732 color G(<144,180,239>/255,Gamma)*4]
                        [0.4255 color G(<137,172,235>/255,Gamma)*4]
                        [0.7067 color G(< 97,126,198>/255,Gamma)*4]
                        [0.7740 color G(< 92,119,190>/255,Gamma)*4]
                        [0.8275 color G(< 88,114,185>/255,Gamma)*4]
                        [0.8850 color G(< 85,111,180>/255,Gamma)*4]                        
                        [0.9425 color G(< 82,107,175>/255,Gamma)*4]                        
                        [1.0000 color G(< 79,103,170>/255,Gamma)*4]
                }
        }
}

//-----------------------------------------
// Atmosphere
//-----------------------------------------

box {
        <-200,-61,-40>,<50,50,50>
        material {
                texture {pigment {color rgbf 1}}
                interior {
                        media {
                                confidence 0.0001
                                variance 1
                                scattering {3, rgb 0.0042*<0.5,0.75,1>*0.45}
                                
                        }
                }
        }
        hollow
}


//-----------------------------------------
// Textures
//-----------------------------------------      

#declare diff2 = 0.5;

#declare txtSkin =
texture {
        pigment {color rgb <1,0.75,0.15>}
        finish {diffuse 0.7*diff2 ambient 0 brilliance 2} 
} 
texture {
        pigment {rgb 0.8 transmit 1}
        finish {diffuse 0 ambient 0 phong 1 phong_size 20 metallic 0.5}
        normal {facets coords 1 scale 0.1}
}
texture {
        pigment {rgbt 1}
        finish {
                diffuse 0.6*diff2 ambient 0 
                reflection {0,1 falloff 5} 
                phong 1 phong_size 500
        }
}

//---------------------------------------------------------------------------

#declare Scarring =
texture {
        pigment {
                bozo 
                color_map {
                        [0      rgb H(<0.175,0.175,0.175>) transmit 0.75]
                        [1      rgb H(<0.175,0.175,0.175>) transmit 1]
                }
                scale 2
        }
}
texture {
        pigment {
                bozo 
                pigment_map {
                        [0      bozo 
                                color_map {
                                        [0      rgb H(<0.125,0.125,0.125>) transmit 0.75]
                                        [1      rgb H(<0.125,0.125,0.125>) transmit 1]
                                }scale 0.125
                        ]
                        [0.5    rgb H(<0.175,0.175,0.175>) transmit 1]
                }
                scale 2
        }
        translate 25
}

#declare Rusting2 =
texture {
        pigment {
                bozo 
                color_map {
                        [0      rgb H(<1,0.5-0.02,0.4-0.02>) transmit 0.875]
                        [1      rgb H(<1,0.5,0.4>) transmit 1]
                }
                scale 2
        }
}
texture {
        pigment {
                bozo 
                pigment_map {
                        [0      bozo 
                                color_map {
                                        [0      rgb H(<1,0.5-0.02,0.4-0.02>) transmit 0.875]
                                        [1      rgb H(<1,0.5,0.4>) transmit 1]
                                }
                                scale 0.125
                        ]
                        [0.5    rgb H(<0.175,0.175,0.175>) transmit 1]
                }
                scale 2
        }
        translate 25
}

#declare Chipping =
texture {
        pigment {
                bozo 
                pigment_map {
                        [0.4    bozo 
                                color_map {
                                        [0.2    rgb 1 transmit 0.25]
                                        [0.3    rgb 1 transmit 1]
                                } 
                                turbulence 1/2 
                                scale 0.125/2
                        ]
                        [0.5    rgb H(<0.175,0.175,0.175>) transmit 1]
                }
                scale 8
        }
}

#declare Test =
function {
        pow(f_noise3d(x,y,z),0.3)
        *f_noise3d(x*5,y*5,z*5)
        *pow(f_noise3d(x*20,y*20,z*20),0.3)
}
 
#declare Test2 =
function {
        pow(f_noise3d(x,y,z),2)
        *f_noise3d(x*5,y*5,z*5)
        *pow(f_noise3d(x*20,y*20,z*20),0.3)
}

#declare rusted_metal1 =
texture {
        pigment { 
                function {Test(x,y,z)} 
                triangle_wave
                pigment_map {
                        [0.7    bozo 
                                color_map {
                                        [0.4 rgb 1]
                                        [0.5 rgb H(<0.6,0.65,0.8>)]
                                        [0.6 rgb H(<0.65,0.65,0.65>)]
                                } 
                                turbulence 1 
                                scale 1/2
                        ]
                        [0.8    bozo 
                                color_map {
                                        [0 rgb H(<0.6,0.4-0.02,0.3-0.02>)]
                                        [1 rgb H(<0.6,0.5-0.02,0.4-0.02>*1.5)]
                                } 
                                scale 1/3
                        ]
                }
                scale 1.5
        }
        normal {
                function {Test2(x,y,z)} 
                bump_size 1/3*1.3 
                scale 1/4
        } 
        finish {
                ambient 0 diffuse diff2 phong 1.5 metallic phong_size 10 
                reflection {0.2,0.5 falloff 5}
        }
}
texture {Scarring scale 1/16}
texture {Chipping scale 1/16}
texture {Scarring scale 1/16 scale 4*y}
texture {Scarring scale 1/32}
texture {Rusting2 scale 1/5 scale 2*z}

#declare rusted_metal = 
texture {rusted_metal1 scale 0.85}

#declare txtPipe1 =
texture {
        pigment {color rgb 0} 
        finish {ambient 0}
}

//-----------------------------------------
// Pipes
//-----------------------------------------

#declare nDeco = 7;
#declare Deco = array[nDeco]
#include "pipedeco.inc"

#declare box_hole = <0,0,0>;    // no hole = decorations everywhere
#declare dPipe = 0;             // 3D pipes (dPipe=1 = 2D pipes on the x-y plane)

#include "madpipe.inc"

//-----------------------wall--------------------------------------------------------------------------------------------

#declare container1 = <-65,-35,40>;
#declare container2 = <40,40,60>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt4 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 2000;
        #declare rPipe = 0.5;
        #declare lPipe = 8;  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_4.inc")}
#end
object {#include "WPipe_4.inc" texture{rusted_metal} translate cont_schwerpunkt4}
object {#include "WPipe_4.inc" texture{rusted_metal} translate cont_schwerpunkt4+<-105,0,0>}
object {#include "WPipe_4.inc" texture{rusted_metal} translate cont_schwerpunkt4+<-45,35,5>}   

#declare container1 = <-20,-35,40>;
#declare container2 = <20,40,50>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt4a = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 1400;
        #declare rPipe = 0.15;
        #declare lPipe = 3;  
        #declare Pipe_4a = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_4a.inc")}
#end
object {#include "WPipe_4a.inc" texture{rusted_metal} translate cont_schwerpunkt4a}
object {#include "WPipe_4a.inc" texture{rusted_metal} translate cont_schwerpunkt4a+<-105,0,0>}

//-----------------------ground--------------------------------------------------------------------------------------------

#declare container1 = <-30,-35,-50>;
#declare container2 = <30,-25,60>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt5 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 1500;
        #declare rPipe = 0.25;
        #declare lPipe = 5;  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_5.inc")}
#end

#declare ground_ =
union {
        object {#include "WPipe_5.inc" texture{rusted_metal} translate cont_schwerpunkt5}
        object {#include "WPipe_5.inc" texture{rusted_metal} translate cont_schwerpunkt5+<-60,0,0>}
}
object {ground_}

//-----------------------left--------------------------------------------------------------------------------------------

#declare container1 = <-25,-30,10>;
#declare container2 = <-20,40,50>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt6 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 1000;
        #declare rPipe = 0.15;
        #declare lPipe = 2.5;  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_6.inc")}
#end
object {#include "WPipe_6.inc" texture{rusted_metal} translate cont_schwerpunkt6}
object {#include "WPipe_6.inc" texture{rusted_metal} translate cont_schwerpunkt6+<-60,0,0>}

#declare container1=<-25,0,-50>;
#declare container2=<-20,40,10>;  
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt7 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_7.inc")}
#end
object {#include "WPipe_7.inc" texture{rusted_metal} translate cont_schwerpunkt7}
object {#include "WPipe_7.inc" texture{rusted_metal} translate cont_schwerpunkt7+<-60,0,0>}

#declare container1 = <-25,-30,10>;
#declare container2 = <-20,40,40>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt6 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 900;
        #declare rPipe = 0.3;
        #declare lPipe = 2.5;  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_6a.inc")}
#end
object {#include "WPipe_6a.inc" texture{rusted_metal} translate cont_schwerpunkt6}
object {#include "WPipe_6a.inc" texture{rusted_metal} translate cont_schwerpunkt6+<-60,0,0>}

#declare container1=<-25,0,-50>;
#declare container2=<-20,40,10>;  
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt7 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_7a.inc")}
#end
object {#include "WPipe_7a.inc" texture{rusted_metal} translate cont_schwerpunkt7}
object {#include "WPipe_7a.inc" texture{rusted_metal} translate cont_schwerpunkt7+<-60,0,0>}

//-----------------------right--------------------------------------------------------------------------------------------

#declare container1=<25,-30,10>;
#declare container2=<20,40,50>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt8 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 1000;
        #declare rPipe = 0.15;
        #declare lPipe = 2.5;    
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_8.inc")}
#end
object {#include "WPipe_8.inc" texture{rusted_metal} translate cont_schwerpunkt8}

#declare container1=<25,0,-50>;
#declare container2=<20,40,10>;  
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt9 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_9.inc")}
#end
object {#include "WPipe_9.inc" texture{rusted_metal} translate cont_schwerpunkt9}

#declare container1=<25,-30,10>;
#declare container2=<20,40,40>; 
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt8 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)
        #declare nPipe = 900;
        #declare rPipe = 0.3;
        #declare lPipe = 2.5;  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_8a.inc")}
#end
object {#include "WPipe_8a.inc" texture{rusted_metal} translate cont_schwerpunkt8}

#declare container1=<25,0,-50>;
#declare container2=<20,40,10>;  
#declare container = <abs(container1.x-container2.x),abs(container1.y-container2.y),abs(container1.z-container2.z)>/2;
#declare cont_schwerpunkt9 = <container1.x+container2.x,container1.y+container2.y,container1.z+container2.z>/2;
#if (file_done = 0)  
        #declare Pipe_4 = object {MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,27643,true,"wpipe_9a.inc")}
#end
object {#include "WPipe_9a.inc" texture{rusted_metal} translate cont_schwerpunkt9}

//-----------------------------------------
// Environment
//-----------------------------------------

union {
        box {<-200,-60, 75>,< 100, 81, 66>}  //wand
        box {<-200,-60,-55>,< 100, 81,-50>}  //rueckwand
        box {<-201,-60, 75>,<-200, 81,-55>}  //links
        box {< 100,-60, 75>,< 101, 81,-55>}  //rechts
        box {<-201,-61, 75>,< 101,-60,-55>}  //unten
        box {<-201, 51,-10>,< 101, 82,-55>}  //oben hinten
        box {<-201, 71, 40>,< 101, 82, 66>}  //oben hinten
        box {<-201, 71, 75>,<-100, 82,-55>}  //oben links Lichtblock
        texture {txtPipe1}
}

//-----------------------------------------
// Trees
//-----------------------------------------
  
#include "Pipetree2.inc"

//-----------------------------------------
// Groundcover
//-----------------------------------------

#declare cam_angle = cam_ang+4;
#declare cam_up = y;
#declare r1 = seed(0);
#declare r2 = seed(0); 
#declare r3 = seed(0);
#declare n = 0;
#debug "grass\n"
#while (n < 5000)
        #declare rnd_y = vaxis_rotate (lookat-cam_loc,vcross (lookat-cam_loc,cam_up),(rand(r1)-0.5)*cam_angle);
        #declare rnd_xy = vaxis_rotate (rnd_y,cam_up,(rand(r1)-0.5)*cam_angle*image_width/image_height);
        #declare Norm = <0,0,0>;
        #declare Inter2 = trace (ground_,cam_loc,rnd_xy,Norm);
        #if (vlength (Norm) != 0)
                #declare ab = (1.5+rand(r3))/2;
                #declare ac = 360*rand(r1);
                #declare ad = 30*rand(r1);
                #declare ae = 360*rand(r1); 
                #declare ai = int(rand(r2)*3);
                object {
                        Wheel double_illuminate hollow                                 
                        translate y*8
                        scale 0.1*ab
                        texture {txtTree}
                        rotate y*ac
                        rotate <ad,ae,0>
                        translate Inter2
                }
        #else
                #declare n = n-1;
        #end        
        #if(mod(n,50)=0)
                #debug concat(str(n,0,0)," grass placed.\n")
        #end
        #declare n = n+1;
#end

//-----------------------------------------
// Cow
//-----------------------------------------

#include "Mesh_Cow2.inc"

  
  