
#include "groundfragment2.inc"

// spline for the ceiling (left half)
#declare TunnelCeilSpline =
   spline {
      linear_spline
           0,<0,3.529411765,0>,
           4,<-0.24619207,3.520814802,0>,
          13,<-0.793921885,3.438958483,0>,
          22,<-1.32210386,3.272428577,0>,
        31.5,<-1.844063787,3.009348128,0>,
          38,<-2.172868453,2.781256927,0>,
          44,<-2.451677923,2.538901882,0>,
          48,<-2.622805739,2.361702238,0>,
          55,<-2.891067549,2.024469272,0>,
          62,<-3.11623274,1.657057909,0>
}

//  spline for the walls (left half)
#declare TunnelWallSpline = 
   spline {
      linear_spline
          69,<-2.987416633,1.146883544,0>,
        74.5,<-3.083584654,0.855281054,0>,
          80,<-3.151361925,0.55580394,0>,
          87,<-3.195607008,0.167618168,0>,
          92,<-3.198050761,-0.111675097,0>,
          97,<-3.17614909,-0.389970455,0>,
       101.5,<-3.135762831,-0.637958828,0>,
         106,<-3.076044691,-0.882014205,0>,
         109,<-3.076044691,-0.882014205,0>,
         110,<-3.076044691,-0.882014205,0>
}


#declare RandTunnel = seed(317);


// creates a segment of the ceiling
#macro SimpleCeil(Zufall)
union {
   #declare lokalZufall = seed(Zufall);
   #declare AngleCount = 0;
   #while(AngleCount<62)
      object {
 IW_Plank_ChamferedT (
    int(rand(lokalZufall)*1000), //Seed,
    0.23, // xSize,
    0.05, // ySize,
    1.42, // zSize,
    -2+4*rand(lokalZufall), // Rotate,
    -10+20*rand(lokalZufall), // Translate,
    0.0001, // Round,
    0.0001, // Round2,
    0.005+rand(lokalZufall)/100,//0.01, // Strength,
    0.01, // Strength2,
    pigment { P_IW_03 color_map { CM_IW_Cherry_03 } scale 0.7 }, // pigm,
    pigment { color White } // text
  )
  rotate <-0.5+rand(lokalZufall),0,-0.5+rand(lokalZufall)>
         rotate <0,0,AngleCount + 106/30>
         translate TunnelCeilSpline(AngleCount)
      }
      #declare AngleCount=AngleCount + 106/30;
   #end
}
#end


// creates a segment of the wall
#macro SimpleWall(Zufall)
union {

   #declare AngleCount = 69;
   #declare lokalZufall = seed(Zufall);
   #while(AngleCount<106)
         object { //WallBeam
 IW_Plank_ChamferedT (
    int(rand(lokalZufall)*1000), //Seed,
    0.23, // xSize,
    0.25, // ySize,
    1.42, // zSize,
    -2+4*rand(lokalZufall), // Rotate,
    -10+20*rand(lokalZufall), // Translate,
    0.0001, // Round,
    0.0001, // Round2,
    0.005+rand(lokalZufall)/100,//0.01, // Strength,
    0.01, // Strength2,
    pigment { P_IW_03 color_map { CM_IW_Cherry_03 } scale 0.7 }, // pigm,
    pigment { color White } // text
  )
         rotate <0,0,AngleCount + 106/30>
         translate TunnelWallSpline(AngleCount)
      }
      #declare AngleCount=AngleCount + 106/30;
   #end
}
#end


// creates a segment of the tunnel
#macro WallSeg(Zufall)

union {

   union {
      object { SimpleCeil(Zufall) scale <1.0,1.1,1> translate <0,-0.5,0> }
      object { SimpleCeil(Zufall) scale <-1.0,1.1,1> translate <0,-0.5,0> }
      object { SimpleWall(Zufall) scale <1.1,1.3,1> translate <0.2,-0.6,0> }
      object { SimpleWall(Zufall) scale <-1.1,1.3,1> translate <-0.2,-0.6,0> }

      scale <1.05,1.05,1.06 >
         
   }
}
#end

// creates a segment of the tunnel without the left wall
// leaving an opening for the ide tunnels
#macro WallSegSideTunnel(Zufall)
union {

   union {
      object { SimpleCeil(Zufall) scale <1.0,1.1,1> translate <0,-0.5,0> }
      object { SimpleCeil(Zufall) scale <-1.0,1.1,1> translate <0,-0.5,0> }
      object { SimpleWall(Zufall) scale <-1.1,1.3,1> translate <-0.2,-0.6,0> }

      scale 1.05
         
   }
}
#end

// texture for the back wall by Sean Day (as I remember I have taken it from his marvelous Natural History Museum)
#declare greyGranite = texture 
{
        pigment 
        { 
                granite         
                turbulence 0.125
                lambda 3.5
                omega 0.6
                color_map
                {
                        [ 0 rgb <0.65, 0.65, 0.65> ]
                        [ 0.2 rgb <0.65, 0.65, 0.65> ]
                        [ 0.8 rgb <0.35, 0.35, 0.35> ]
                        [ 1.0 rgb <0.35, 0.35, 0.35> ]
                }                                     
                scale 0.15
        }
        finish { phong 0.5 phong_size 35 ambient 0 diffuse 0.3 reflection { 0.025, 0.075 fresnel on } conserve_energy }
}
texture
{
        pigment 
        {                  
                wrinkles            
                triangle_wave
                turbulence 0.235
                lambda 4
                omega 0.625
                color_map
                {
                        [ 0 rgbt <0.15, 0.05, 0.02, 0.99> ]
                        [ 0.15 rgbt <0.125, 0.04, 0.01, 0.6> ]
                        [ 0.65 rgbt <0.15, 0.08, 0.02, 0.8> ]
                        [ 1 rgbt <0.15, 0.05, 0.02, 0.99> ]
                }    
                rotate <30, 70, 12>
                scale <3.5, 2.0, 2.5>
        }       
        finish { phong 0 ambient 0 } 
} 


// simple ISO-CSG-difference for the back wall

#declare fn1 = IC_Cylinder (<0,3,0>,<0,3,1>, 6 )
#declare fn2 = IC_Box (<-1.5,3-1.5,-1>,<1.5,3+1.5,2>)
#declare fn3 = IC_Difference2 ( function { fn1(x,y,z) }, function { fn2(x,y,z) } )
#declare fn4 = function { fn3(x,y,z) -f_granite(x,y,z)*0.06}

#declare BackWall = isosurface {                                                                                     
   function { fn4(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-6.1,-3.1,-0.1>,<6.1,9.1,1.1> } }
}
#undef fn1 #undef fn2 #undef fn3 #undef fn4



// the upper floor support is constructed of 7 stones defined in the following include file.
// they are choosen by random and randomly flip in the z-direction 
// I run a short animation to find the random seed which produces the
// image I liked most. This is why I use a second random generator for the flipping.



#include "beams_functions.inc"
#declare Beams = array[7]
#declare  Beams[0] = object { SupportBeam01 }
#declare  Beams[1] = object { SupportBeam02 }
#declare  Beams[2] = object { SupportBeam03 }
#declare  Beams[3] = object { SupportBeam04 }
#declare  Beams[4] = object { SupportBeam05 }
#declare  Beams[5] = object { SupportBeam06 }
#declare  Beams[6] = object { SupportBeam07 }

#declare Zufall=seed(327);
#declare Zufall2=seed(317);
#declare Count=-10;
#declare UpperFloorSupport = union { 
   #while (Count<201)
      #declare BeamInd=int(rand(Zufall)*6.9);
      object { Beams[BeamInd]
         scale <2/3,2/3,1>
         #if ( rand(Zufall2)<0.5)
            scale <1,1,-1>
         #end
         translate <-3.2,1.4+2.4,Count*1.22>
         pigment { color White }
      }
      #declare BeamInd=int(rand(Zufall)*6.9);
      object { Beams[BeamInd]
         scale <-2/3,2/3,1>
         #if ( rand(Zufall2)<0.5)
            scale <1,1,-1>
         #end
         translate <3.2,1.4+2.4,Count*1.22>
         pigment { color White }
      }
      #declare Count=Count+1;
   #end
}

// The concrete beams at the buttom of the tunnel are constructed with another technique.
// Here I defined a number of cuts and cut them out of every beam at a random location at the upper inner side
// with differing probabilities. 


#declare GroundBeams = union {

  // lower row left
  #declare Count=-10;
  #while (Count < 201)
     #declare fn1 = function { fn_GBSeg1(x,y,z) }
     #if (rand(Zufall) < 0.5)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.25)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.1)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut04(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut01(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut02(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut03(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut05(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end
     
     object {
        isosurface {                                                                                     
           function { fn1(x, y, z) }  
           max_gradient 10 
           contained_by { box { <-0.61,-0.5,-0.51>,<0.1,0.1,0.51> } }
        }
        #if (rand(Zufall)<0.5)
           scale <1,1,-1>
        #end
        rotate <-0.5*rand(Zufall),-0.5*rand(Zufall),-0.5*rand(Zufall)>     
        translate <-2.6,0.25,Count>
        
        pigment { color White }
     }
     
     #undef fn1                                                                                   
     #declare Count=Count + 1;
  #end

  // lower row right
  #declare Count=-10;
  #while (Count < 201)
     #declare fn1 = function { fn_GBSeg1(x,y,z) }
     #if (rand(Zufall) < 0.5)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.25)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.1)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut04(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut01(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut02(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut03(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut05(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end
     
     object {
        isosurface {                                                                                     
           function { fn1(x, y, z) }  
           max_gradient 10 
           contained_by { box { <-0.61,-0.5,-0.51>,<0.1,0.1,0.51> } }
        }
        scale <-1,1,1>
        #if (rand(Zufall)<0.5)
           scale <1,1,-1>
        #end
        rotate <-0.5*rand(Zufall),-0.5*rand(Zufall),-0.5*rand(Zufall)>     
        translate <2.6,0.25,Count-0.1>
        
        pigment { color White }
     }
     
     #undef fn1                                                                                   
     #declare Count=Count + 1;
  #end

  // middle row left
  #declare Count=-10;
  #while (Count < 201)
     #declare fn1 = function { fn_GBSeg2(x,y,z) }
     #if (rand(Zufall) < 0.5)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.25)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.1)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
/*     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut04(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
*/     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut01(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut02(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut03(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut05(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end
     
     object {
        isosurface {                                                                                     
           function { fn1(x, y, z) }  
           max_gradient 10 
           contained_by { box { <-0.61,-0.5,-0.51>,<0.1,0.1,0.51> } }
        }
        #if (rand(Zufall)<0.5)
           scale <1,1,-1>
        #end
        rotate <-0.5*rand(Zufall),-0.5*rand(Zufall),-0.5*rand(Zufall)>     
        translate <-3,0.4,Count+0.2>
        
        pigment { color White }
     }
     
     #undef fn1                                                                                   
     #declare Count=Count + 1;
  #end

  // middle row right
  #declare Count=-10;
  #while (Count < 201)
     #declare fn1 = function { fn_GBSeg2(x,y,z) }
     #if (rand(Zufall) < 0.5)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.25)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.1)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
/*     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut04(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
*/     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut01(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut02(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut03(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut05(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end
     
     object {
        isosurface {                                                                                     
           function { fn1(x, y, z) }  
           max_gradient 10 
           contained_by { box { <-0.61,-0.5,-0.51>,<0.1,0.1,0.51> } }
        }
        scale <-1,1,1>
        #if (rand(Zufall)<0.5)
           scale <1,1,-1>
        #end
        rotate <-0.5*rand(Zufall),-0.5*rand(Zufall),-0.5*rand(Zufall)>     
        translate <3,0.4,Count-0.3>
        
        pigment { color White }
     }
     
     #undef fn1                                                                                   
     #declare Count=Count + 1;
  #end

  // upper row left
  #declare Count=-10;
  #while (Count < 201)
     #declare fn1 = function { fn_GBSeg3(x,y,z) }
     #if (rand(Zufall) < 0.5)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.25)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.1)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
/*     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut04(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
*/     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut01(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut02(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut03(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut05(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end
     
     object {
        isosurface {                                                                                     
           function { fn1(x, y, z) }  
           max_gradient 10 
           contained_by { box { <-0.61,-0.5,-0.51>,<0.1,0.1,0.51> } }
        }
        #if (rand(Zufall)<0.5)
           scale <1,1,-1>
        #end
        rotate <-0.5*rand(Zufall),-0.5*rand(Zufall),-0.5*rand(Zufall)>     
        translate <-3.1,0.7,Count+0.1>
        
        pigment { color White }
     }
     
     #undef fn1                                                                                   
     #declare Count=Count + 1;
  #end

  // upper row right
  #declare Count=-10;
  #while (Count < 201)
     #declare fn1 = function { fn_GBSeg3(x,y,z) }
     #if (rand(Zufall) < 0.5)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.25)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.1)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut06(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
/*     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut04(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
*/     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut01(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut02(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut03(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end                                                                                   
     #if (rand(Zufall) < 0.05)
        #declare fn2 = IC_Difference2 ( function { fn1(x,y,z) }, IC_Translate ( function { fn_GBCut05(x,y,z) },<0,0,-0.5+rand(Zufall)> ) )
        #undef fn1
        #declare fn1 = function { fn2(x,y,z) }
        #undef fn2
     #end
     
     object {
        isosurface {                                                                                     
           function { fn1(x, y, z) }  
           max_gradient 10 
           contained_by { box { <-0.61,-0.5,-0.51>,<0.1,0.1,0.51> } }
        }
        scale <-1,1,1>
        #if (rand(Zufall)<0.5)
           scale <1,1,-1>
        #end
        rotate <-0.5*rand(Zufall),-0.5*rand(Zufall),-0.5*rand(Zufall)>     
        translate <3.1,0.7,Count+0.4>
        
        pigment { color White }
     }
     
     #undef fn1                                                                                   
     #declare Count=Count + 1;
  #end


 
}   

#declare Ground = union {
   #declare Count=-20;
   #while (Count<200)
      object { groundfragment translate <0,0,Count>
//         pigment { color White }
         scale 1.3
      }
      #declare Count=Count+20;
   #end
}


#declare SideTunnel = union {
   light_group {
      light_source { <-5,2.2,10.75>, (Yellow/3+Orange/3*2) fade_power 2 }
      difference {
         box { <-100,0.5,-0.1>,<-3.2,4,1.6> }
         cylinder { <0,0,-1>,<0,0,2>,3.6 scale <1,1.5,1> translate <0,1.75,0> }
         box { <-99,0.6,0.01>,<-3,3.8,1.49> }
      
         translate <0,0,10>
      
        pigment { color White }
      }
   }
}



#declare Tunnel = union {
   object { Ground }
   object { GroundBeams }
   object { UpperFloorSupport }   

   object { BackWall translate <0,-0.5,100> texture { greyGranite scale 3 } }
   
   #declare Count=-25;
   #while (Count<0)
      object { WallSeg(rand(RandTunnel)) translate <0,2.4,10+1.5*Count> }
      #declare Count=Count+1;
   #end
   
   #declare Count=1;
   #while (Count<35)
      object { WallSeg(rand(RandTunnel)) translate <0,2.4,10+1.5*Count> }
      #declare Count=Count+1;
   #end
   
   #declare Count=36;
   #while (Count<100)
      object { WallSeg(rand(RandTunnel)) translate <0,2.4,10+1.5*Count> }
      #declare Count=Count+1;
   #end

   object { WallSegSideTunnel(rand(RandTunnel)) translate <0,2.4,10> }
   object { WallSegSideTunnel(rand(RandTunnel)) translate <0,2.4,10+52.5> }
   
   object { SideTunnel }
   object { SideTunnel translate <0,0,52.5>}

}

