/*****************************************************************************

Scene file for my entry to the TINA CheP contest May-June 2012 without the Poser content and the chair,
which is a little bit to big (100 MB). Most likely I have smoothed the chair too much in Wings.
You can find the image at http://tc-rtc.co.uk by navigating to the mentioned competition
( Stills - Other Competitions - 2012 - May - Rose Garden )

REMARK: Without the ghosts (emitting media) the lighting is a little bit different from my TINA CheP-entry.
In fact a little bit to pale. Unfortunatelly I have not the resources to fix this issue at the moment.

This files contains the tunnel, the ghost chair, the ghost camera, the ghost table and the ghost microfon.


ADDITIONALLY you need the ISO-CSG- and the IsoWood-Library by Christoph Hormann (available at his web site
http://www.imagico.de/) to render this source.

Made for Persistence of vision 3.7 RC 3

Copyright 2012 Michael Friedrichs (mi-friedrichs@t-online.de)

This work is licensed under the Creative Commons Attribution License (3.0). 
You are free:
 - to copy, distribute, display, and perform the work
 - to make derivative works
 - to make commercial use of the work
Under the following conditions:
 - Attribution. You must give the original author credit.
 - For any reuse or distribution, you must make clear to others the license terms of this work.
 - Any of these conditions can be waived if you get permission from the copyright holder.
 Your fair use and other rights are in no way affected by the above. 

******************************************************************************/

#version 3.7;



global_settings {
   assumed_gamma 1
   radiosity { media off }
   max_trace_level 256
} 

#include "colors.inc"
#include "metals.inc"

#include "iso_CSG.inc"
#include "IsoWood3.inc"
#include "iw_textures.inc"

 
#declare SW_ISO_Ground = on; // takes longest

#include "tunnel3.inc"

camera {
   location <0,1.25,-10>
   look_at <0,3,100>
   up y
   right 16/9*x
//   angle 45
}

/*
light_source {
   <0,0,-10>, White
}
*/
#declare LightRad=3;//1.48;
#declare LightFO =8;//4.95;
#declare LightInt=10;

light_source {
   <-1.1,0.2,-15>, <0.9,0.9,1>*LightInt
//   spotlight radius 25 falloff 80 tightness 20 point_at <-1.2,-0.5,0>
   spotlight radius LightRad falloff LightFO tightness 100 point_at <0.3,-0.5,-8>
}
light_source {
   <1.1,0.2,-15>, <0.9,0.9,1>*LightInt
//   spotlight radius 25 falloff 80 tightness 20 point_at <1.2,-0.5,0>
   spotlight radius LightRad falloff LightFO tightness 100 point_at <-0.3,-0.5,-8>
}

light_source {
   <-1.1,0.2,-15>, <0.9,0.9,1>*LightInt
//   spotlight radius 25 falloff 80 tightness 20 point_at <-1.2,-0.5,0>
   spotlight radius LightRad falloff LightFO tightness 100 point_at <1.5,-0.5,-8>
}
light_source {
   <1.1,0.2,-15>, <0.9,0.9,1>*LightInt
//   spotlight radius 25 falloff 80 tightness 20 point_at <1.2,-0.5,0>
   spotlight radius LightRad falloff LightFO tightness 100 point_at <-1.5,-0.5,-8>
}





light_source {
   <0,4,-15>, <0.9,0.9,1>*LightInt
//   spotlight radius 25 falloff 80 tightness 20 point_at <1.2,-0.5,0>
   spotlight radius LightRad/4 falloff LightFO*2 tightness 100 point_at <0,-0.5,0>
}


light_source {
   <0,3.8,-20>, White*0.25
}

object { Tunnel
   pigment { color White }
   finish { phong 0.5 phong_size 35 ambient 0 diffuse 0.3 reflection { 0.025, 0.075 fresnel on } conserve_energy }
}    

/*
#declare Count=-10;
#while(Count <100)
   sphere { 0,0.1
      #if(mod(Count,10)=0)
         pigment { color Green }
      #else
         pigment { color Red }
      #end
      translate <-2.3,0.7,Count>
   }
   #declare Count=Count+1;
#end
*/
//box { 0,1 pigment { color Magenta } }




// dummy second floor
//box { <-3.12,1.5+2.4,0>,<3.12,1.5+2.4,1> pigment { color Yellow } }

// dummy door
//box { <0,0,0>,<0.8,1.9,0.1> scale 0.9 translate <-1.7,1.5+2.4,0> pigment { color Pink } }

// dummy bed
//box { <0,0,0>,<2,1.6,0.1> scale 0.9 translate <0.8,3.9,0> pigment { color Pink } }

// dummy ground floor
//box { <-3.2,0.2501,-5>,<3.2,0.35,10> pigment { color Yellow transmit 0.9 } }//interior { ior 1.5 } }



#declare InnerMat = texture {
  pigment { color rgb 0.2*<0.8, 0.95, 1> }
  finish { emission 1 } }
#declare OuterMat = texture {
  pigment { color Clear }
  finish { ambient 0 diffuse 0 } }



#macro GhostInt(EM,TH,SC,COLOR)
         interior {
            media {
               emission EM
               method 3
               samples 10,20
               intervals 10
               aa_threshold 0.01
               aa_level 9
               confidence 0.999
               variance 0
               density {
                  granite
                  color_map {
                     [0  color rgb     COLOR ]
                     [TH color rgb 0.5*COLOR ]
                     [1  color rgb 0.1*COLOR ]
                  }
                  scale SC
               }
            }
         }

#end

/**********************************************************************************

Poser figures are not included here.

**********************************************************************************/

syntax error // just a reminder, comment this line out to render the scene without the poser content

//#include "../figuren/geist.inc"
//#include "../Kameramann/geist.inc"
#include "ghost_camera.inc"
#include "ghost_table.inc"
#include "chair.inc"

#declare InnerMat = texture {
  pigment { rgbt 0.2*<0.8, 0.95, 1,0.999*5> }
  finish { emission 1 } }

/*
union {
   light_group {
      object { MakeUpGhost }
      object { Brush scale 0.075 rotate <-120,-35,0> translate <-0.048,0.58,-0.0125> }
 brush not included, you can find the brush at Gilles Tran's site (www.oyonale.com)
      object { President }
      object { President_Chair }
   }
         
      scale <-1,1,1>*2.2
      rotate <0,20, 0>
      translate <-0.7,0.35,-4>
}
*/

light_group {
   union {
      object { GhostCam }
//      object { KameraGhost  scale <1,1,-1>*172 rotate -y*95 translate <-20,0,33> }
      scale 1/75
      rotate y*50
      translate <1.2,0.35,-1>
      
      no_reflection // for some reason the camera and her ghost casts annoying reflections at the ground
                    // while the other ghosts did not
   }
}

light_group {
   union {
      object { Ghost_Table }
      scale 1/10
      rotate -y*65
      translate <0,0.35,-2>
   }
}



