#declare StampHeight=-0.41;
#declare StampRotZ=-16;

#declare Zufall=seed(317);

// sample pigment function from the pov tutorials
#ifndef(fn_Pigm)
   #declare fn_Pigm=function {
      pigment {
         agate
         color_map {
            [0 color rgb 0 ]
            [1 color rgb 1 ]
         }
      }
   }
#end

#ifndef(SW_ISO_Ground) #local SW_ISO_Ground =  off; #end

// since the ground is a little bit slow, I leave a
// simple CSG-version for test renders

#if (SW_ISO_Ground=off)

   #declare Bodenfragment = difference {
      box { <-3,-1,-1>,<3,0,1> }
      cylinder { <0,0,-2>,<0,0,2>,1.04225 scale <2.5988,1,1> translate <0,0.29225,0> }
      
      scale <1,1,10>
   }

#else // SW_ISO_Ground = on

   // base ground structure, difference of a box and a distorted cylinder
   #declare fn1 = IC_Box(<-3,-1,-5>,<3,0,5>)
   #declare fn2 = IC_Translate (
                  IC_ScaleC (
                     IC_Cylinder( <0,0,-15>,<0,0,15>,1.04225),
                      <2.2,0.9,1>),
                      <0,0.29225,0>)
                  
   #declare fn3 = IC_Difference2 ( function { fn1(x,y,z) },
                                   function { fn2(x,y,z) + f_noise3d(x*2,0,z)/5 } )

   #undef fn1
   #undef fn2
   
   // adding the bulges. they appear only on the left side as in the original tunnel 

   #declare fn1 = IC_Translate ( IC_Scale ( IC_Rotate ( IC_Torus ( 1.04225,0.00025 ),<90,0,0>), <2.4,0.9,1> ), <-0.2,0.29225,-0.5> )
   #declare fn2 = IC_Box(<-3,0,-1>,<3,1,1>)
   #declare fn4 = IC_Difference2( function { fn1(x,y,z) }, function { fn2(x,y,z) } )

   //#declare fn5 = IC_Merge2 (function { fn3(x,y,z) }, function { fn4(x,y,z) } )
   #declare Blob_threshold=0.00001;
   #declare fn5 = function { (1+Blob_threshold) - pow(Blob_threshold,fn3(x,y,z)) - pow(Blob_threshold,fn4(x,y,z)) }

   #undef fn1
   #undef fn2

   #declare fn1 = IC_Translate ( function { fn4(x,y,z) },<0,0,1> )
   #declare fn2 = IC_Translate ( function { fn4(x,y,z) },<0,0,2> )
   #declare fn13 = IC_Translate ( function { fn4(x,y,z) },<0,0,3> )
   #declare fn7 = IC_Translate ( function { fn4(x,y,z) },<0,0,4> )
   #declare fn8 = IC_Translate ( function { fn4(x,y,z) },<0,0,5> )
   #declare fn9 = IC_Translate ( function { fn4(x,y,z) },<0,0,-1> )
   #declare fn10 = IC_Translate ( function { fn4(x,y,z) },<0,0,-2> )
   #declare fn11 = IC_Translate ( function { fn4(x,y,z) },<0,0,-3> )
   #declare fn12 = IC_Translate ( function { fn4(x,y,z) },<0,0,-4> )

   #declare fn6 = function { (1+Blob_threshold)             // First I tried this with a while-loop as with the stamps
     - pow(Blob_threshold,fn3(x,y,z))                       // (see below), but yielded bad results.
     - pow(Blob_threshold,fn1(x,y,z))                       // May be the power-function should not be iterated too
     - pow(Blob_threshold,fn2(x,y,z))                       // much,
     - pow(Blob_threshold,fn4(x,y,z))
     - pow(Blob_threshold,fn13(x,y,z))
     - pow(Blob_threshold,fn7(x,y,z))
     - pow(Blob_threshold,fn8(x,y,z))
     - pow(Blob_threshold,fn9(x,y,z))
     - pow(Blob_threshold,fn10(x,y,z))
     - pow(Blob_threshold,fn11(x,y,z))
     - pow(Blob_threshold,fn12(x,y,z))
   }
   
   // the original tunnel has two rows of notches in form of a kind of stamp. One to the left and one in the middle
   // a little bit to the right. First I create the shape of the stamps ...
   
   #declare fn14 = IC_Scale( IC_Sphere ( <0,0,0>,0.25 ),<1,0.3,1> )
   #declare fn15 = IC_Cylinder ( <0,0,0>,<0.4,0,0>,0.05 )
   #declare fn16 = IC_Cylinder ( <0,0,0>,<0,0,0.4>,0.05 )
   #declare fn17 = IC_Sphere ( <0.4,0,0>,0.1 )
   #declare fn18 = IC_Sphere ( <0,0,0.4>,0.1 )
   #declare fn19 = IC_Merge5 (
      function { fn14(x,y,z) },
      function { fn15(x,y,z) },
      function { fn16(x,y,z) },
      function { fn17(x,y,z) },
      function { fn18(x,y,z) }
   )
   #declare fn20 = IC_Scale ( IC_Rotate ( function { fn19(x,y,z) },<0,45,0> ), <2/3,1/2,2/3> )
   #declare fn20b = IC_Scale ( IC_Rotate ( function { fn19(x,y,z) },<0,180+45,0> ), <2/3,1/2,2/3> )

   #declare fn21 = IC_Scale (function { fn6(x,y,z) }, <-1,1,1> )

   // ... and carve them out of the ground in a while-loop

   #declare Count=-4;
   #while ( Count<5)

      #declare fn_CutL = IC_Translate ( IC_Rotate ( function { fn20(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05}<0,rand(Zufall)*20-10,StampRotZ>,),<-1.25,StampHeight,Count> )
      #declare fn_CutR = IC_Translate ( IC_Rotate (function { fn20b(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05},<0,rand(Zufall)*20-10,0>),<0.5,-0.57,Count-0.1> )

      #declare fn21b = IC_Difference2 ( function { fn21(x,y,z) },function { fn_CutL(x,y,z) } )
      #declare fn22b = IC_Difference2 ( function { fn21b(x,y,z) },function { fn_CutR(x,y,z) } )
   
      #undef fn_CutL
      #undef fn_CutR
      #undef fn21
      #undef fn21b
      #declare fn21 = function { fn22b(x,y,z) }
      #undef fn22b
   

      #declare Count=Count+2;
   #end

   // now I have the first ground segment

   #declare fn_XX=function { fn21(x,y,z) -f_granite(x,y,z)*0.06616}

   #declare groundfragment01 = isosurface {                                                                                     
      function { fn_XX(x, y, z) }  
      max_gradient 10 
      contained_by { box { <-3.1,-1.1,-5.1>,<3.1,0.1,5.1> } }
   } 


   #undef fn_XX
   #undef fn1
   #undef fn2
   #undef fn3
   #undef fn4
   #undef fn5
   #undef fn7
   #undef fn8
   #undef fn9
   #undef fn10
   #undef fn11
   #undef fn12
   #undef fn13
   #undef fn21
   
   // now a quick hack to have "smooth" transitions from one ground segment to the other.
   // I simply scale the base structure by <-1,1,-1>
   // Actually I should use the base without the bulges and create them new to have
   // them at the left. In fact I simply have forgotten to do this in my Tina-Chep-entry
   // and since I haven't noticed this flaw I will no repair it.
   // But I carved out the stamps again at the proper places.
   
   #declare fn21 = IC_Scale( function { fn6(x,y,z) },<-1,1,-1> )

   #declare Count=-4;
   #while ( Count<5)

      #declare fn_CutL = IC_Translate ( IC_Rotate ( function { fn20(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05}<0,rand(Zufall)*20-10,StampRotZ>,),<-1.25,StampHeight,Count> )
      #declare fn_CutR = IC_Translate ( IC_Rotate (function { fn20b(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05},<0,rand(Zufall)*20-10,0>),<0.5,-0.57,Count-0.1> )

      #declare fn21b = IC_Difference2 ( function { fn21(x,y,z) },function { fn_CutL(x,y,z) } )
      #declare fn22b = IC_Difference2 ( function { fn21b(x,y,z) },function { fn_CutR(x,y,z) } )
   
      #undef fn_CutL
      #undef fn_CutR
      #undef fn21
      #undef fn21b
      #declare fn21 = function { fn22b(x,y,z) }
      #undef fn22b
   

      #declare Count=Count+2;
   #end



   #declare fn_XX=function { fn21(x,y,z) -f_granite(x,y,z)*0.06616}

   #declare groundfragment02 = isosurface {                                                                                     
      function { fn_XX(x, y, z) }  
      max_gradient 10 
      contained_by { box { <-3.1,-1.1,-5.1>,<3.1,0.1,5.1> } }
   } 

   #undef fn_XX
   #undef fn6
   #undef fn14
   #undef fn15
   #undef fn16
   #undef fn17
   #undef fn18
   #undef fn19
   #undef fn20
   #undef fn21
   #undef fn20b

   // building a new segment out of two mirrored halfs
   // this one is tileable in direction z
   // it is contained in the box <-3,-1,-10>,<3,0,10>
   // the isosurface container is a little bit bigger
   #declare groundfragment = union {
      object { groundfragment02 translate <0,0,-5> }
      object { groundfragment01 translate <0,0,5> }
   }



#end // if (SW_ISO_Ground=off)



