#include "woods.inc"
#include "metals.inc"



#declare GhostMat1 = material {
   texture { OuterMat }
   GhostInt(15,0.9,0.25,<0.95,0.95,1>)
/*         interior {
            media {
               emission 50
               method 2
               intervals 10
               aa_threshold 0.01
               density {
                  granite
                  color_map {
                     [0 color rgb <0.8, 0.95, 1>*GhostColorScale]
                     [0.2 color rgb 0.5*<0.8, 0.95, 1>*GhostColorScale]
                     [1 color rgb 0.1*<0.8, 0.95, 1>*GhostColorScale]
                  }
                  scale 0.25
               }
            }
         }
*/
/*     texture {
        pigment {
           granite
           color_map {
           // Originale Grundfarbe war <0.8,0.95,1>, Transparenz habe ich da eingebaut
              [0   color rgbt <0.99, 0.99, 1,0.99>]
              [0.9 color rgbt <0.99, 0.99, 1,0.99> * 0.5 ]
              [1   color rgbt <0.99, 0.99, 1,0.99> * 0.1 ]
           }
        }
     }
*/
}

#declare CamWheelCap =
merge {
   cylinder { <0,-1.5,0>,<0,1.5,0>,2 }
   intersection {
      merge {
         torus { 4.5,1.5 }
         cylinder { <0,-1.5,0>,<0,1.5,0>,4.5 }
      }
      cylinder { <0,-1.6,10>,<0,1.6,10>,10 }
   }
   difference {
      box { <-9,-1.5,0>,<0,1.5,3> rotate <0,18,0>}
      box { <-12,-1.6,0>,<-7.5,1.6,7> }
   }
   cylinder { <-7.5,0,2.4>,<-7.5,0,5.9>,1.5 }
   
}

#declare CamWheel = merge {
   torus { 4.5,1 }
   cylinder { <0,-0.1,0>,<0,0.1,0>,3.5  }
   object { CamWheelCap }
   
   
   rotate <-90,0,0>
   translate <7.5,5.5,0>
}


#macro CamWheelBreak(Angle)
  merge {
   object { CamWheel rotate y*Angle } // Wheels can be rotated here
   cylinder { <0,11.3,0>,<0,14.8,0>,1.2 }
   torus { 1.5,0.3 translate <0,11.7,0> }
   difference {
      torus { 0.9,0.3 }
      cylinder { <0,-1,0>,<0,0,0>,1.3 }
      
      translate <0,14.8,0> 
   }
   difference {
     cylinder { <0,14.8,0>,<0,15.1,0>,0.9 }
     cylinder { <0,14.7,0>,<0,15.2,0>,0.55 }
   }
   cylinder { <0,0.1,0>,<0,19.1,0>,0.5 }
   torus { 0.5,0.4 translate <0,18.7,0>  }
   
   cylinder { <0,0,0>,<0,3,0>,0.75  }
   cylinder { <0,0,0>,<0,2,0>,1.5  }
   
   cylinder { <-1.4,11.9,0>,<-1.4,14,0>,0.8 }
   cylinder { <-1.4,13,0>,<-1.4,16.5,0>,0.3   }
   torus { 0.3,0.3 translate <-1.4,16.2,0>  }
}
#end

#declare CamLegPart = merge {
   difference {
      box { <-3,-1,-1>,<-1.2,1,6> }
      box { <-5,-1.1,-2>,<0,1.1,10> rotate -y*10.52 translate <-1.7,0,-1> }
   }
   sphere { <-1.7,0,0>,0.5 }
   box { <-1,-1,0>,<0,1,24> rotate -y*2.38 translate <-3,0,6>  }
   box { <-1,-1,0>,<0,1,24> rotate -y*2.38 translate <-4.31,0,13>  }
   
   box { <-2.01,-1.11,0>,<0.01,1.11,2> rotate -y*2.38 translate <-3.4,0,14> }
   box { <-2.01,-1.11,0>,<0.01,1.11,2> rotate -y*2.38 translate <-3.9,0,27.5> }
}


#declare CamLegPart2 = merge {
merge {
   object { CamLegPart }
   object { CamLegPart scale <-1,1,1> }
   
   difference {
      box { <-4,-1.1,6>,<4,1.1,14> }
      box { <-3,-1.2,-1>,<0,1.2,12> rotate -y*2.38 translate <-3,0,6> }
      box { <0,-1.2,-1>,<3,1.2,12> rotate y*2.38 translate <3,0,6> }
   }
   box { <-4.2,-0.25,27.5>,<4.2,0.25,29.3> }
   sphere { <-1.8,0,28.4>,1.6 scale <1,0.625,1>}
   sphere { <1.8,0,28.4>,1.6 scale <1,0.625,1>}

  scale <1,1,1.5>
}   
   cylinder { <-7,0,54.25>,<7,0,54.25>,0.8 }
   
   cylinder { <-7.2,0,54.25>,<-6.4,0,54.25>,1.1  }
   cylinder { <7.2,0,54.25>,<6.4,0,54.25>,1.1  }
   
   
}

#macro CamLeg(Angle) 
merge {
   object { CamWheelBreak(Angle) }
   box { <0,12,-1.2>,<7,14.8,1.2> }
   cylinder { <6.9,13.4,0>,<21,13.4,0>,1  }   
   cylinder { <22.5,12.4,0>,<22.5,14.4,0>,1.5  }   // Mitte des Flansches ist jetzt bei 22.5
                                                                          // Mitte der Kamera ist jetzt bei 30.5
   object { CamLegPart2 rotate <-69.16,90,0> translate <3.2,13.4,0> }
   
   translate <-30.5,0,0>   // Mitte des Flansches ist jetzt bei 22.5-30.5=-8
                           // Mitte der Kamera ist jetzt bei 30.5-30.5=0

}
#end

#declare CamLegs = merge {
    object { CamLeg(77) }
    object { CamLeg(77) rotate y*120 }
    object { CamLeg(77) rotate y*240 }
    merge {
       cylinder { <-8,12.3,0>,<-8,12.4,0>,3 }
       cylinder { <-8,12.3,0>,<-8,12.4,0>,3 rotate y*120 }
       cylinder { <-8,12.3,0>,<-8,12.4,0>,3 rotate y*240 }
       
       cylinder { <0,12.4,0>,<0,14.2,0>,6 }
       
       
    }
    
    merge {
       box { <-2,-2,-4>,<2,6,4> rotate -z*45 translate <-8,64.1,0> }
       box { <-2,-2,-4>,<2,6,4> rotate -z*45 translate <-8,64.1,0> rotate y*120 }
       box { <-2,-2,-4>,<2,6,4> rotate -z*45 translate <-8,64.1,0> rotate y*240 }
       cylinder { <0,65,0>,<0,70,0>,8 }
       cylinder { <0,66,0>,<0,74,0>,6 }

     
    }

}

#declare CamPart = merge {
   intersection {
      merge {
         cylinder { <0,0,-16>,<0,0,16>,40 }
         torus { 39,1 rotate x*90 translate <0,0,-16> }
         torus { 39,1 rotate x*90 translate <0,0,16> }
         cylinder { <0,0,-17>,<0,0,17>,39 }
         scale <12/40,1,1>
      }
      box { <-12,9,-17.1>,<12,36,17.1> translate <0,-22.75,0> }
      
      translate <0,22.75,0>
   }
   sphere { 0,1 scale <12/40,1,1> translate <11,36,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <11,36,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <11,36,0>  }
   cylinder { <-11,36,-16>,<11,36,-16>,1  }
   cylinder { <-11,36,16>,<11,36,16>,1  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,36,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,36,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <-11,36,0>  }
   box { <-11,35,-16>,<11,37,16>  }
   
   sphere { 0,1 scale <12/40,1,1> translate <11,9,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <11,9,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <11,9,0>  }
   cylinder { <-11,9,-16>,<11,9,-16>,1  }
   cylinder { <-11,9,16>,<11,9,16>,1  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,9,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,9,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <-11,9,0>  }
   box { <-11,8,-16>,<11,10,16>  }
}


#declare CamPart_small = merge {
   intersection {
      merge {
         cylinder { <0,0,-16>,<0,0,16>,40 }
         torus { 39,1 rotate x*90 translate <0,0,-16> }
         torus { 39,1 rotate x*90 translate <0,0,16> }
         cylinder { <0,0,-17>,<0,0,17>,39 }
         scale <12/40,1,1>
      }
      box { <-12,9,-17.1>,<12,36,17.1> translate <0,-22.75,0> }
      
      translate <0,22.75,0>
   }
   sphere { 0,1 scale <12/40,1,1> translate <11,36,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <11,36,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <11,36,0>  }
   cylinder { <-11,36,-16>,<11,36,-16>,1  }
   cylinder { <-11,36,16>,<11,36,16>,1  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,36,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,36,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <-11,36,0>  }
   box { <-11,35,-16>,<11,37,16>  }
   
   sphere { 0,1 scale <12/40,1,1> translate <11,9,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <11,9,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <11,9,0>  }
   cylinder { <-11,9,-16>,<11,9,-16>,1  }
   cylinder { <-11,9,16>,<11,9,16>,1  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,9,-16>  }
   sphere { 0,1 scale <12/40,1,1> translate <-11,9,16>  }
   cylinder { <0,0,-16>,<0,0,16>,1 scale <12/40,1,1> translate <-11,9,0>  }
   box { <-11,8,-16>,<11,10,16>  }
   
   translate <0,-22.5,0>
   scale 0.99
   translate <0,22.5,0>
}


#declare CamUpperPart = merge {     // upper part
   difference {
      merge {   
         box { <-3,36,-15>,<3,41,15> }
         box { <-6,36,-12>,<6,41,12> }
         cylinder { <-3,36,-12>,<-3,41,-12>,3 }
         cylinder { <3,36,-12>,<3,41,-12>,3 }
         cylinder { <-3,36,12>,<-3,41,12>,3 }
         cylinder { <3,36,12>,<3,41,12>,3 }
  
         sphere { <-3,41,-12>,3 }
         sphere { <3,41,-12>,3 }
         sphere { <-3,41,12>,3 }
         sphere { <3,41,12>,3 }
   
         cylinder { <-3,41,-12>,<3,41,-12>,3 }
         cylinder { <-3,41,12>,<3,41,12>,3 }
         cylinder { <3,41,12>,<3,41,-12>,3 }
         cylinder { <-3,41,12>,<-3,41,-12>,3 }
         box { <-3,38,-12>,<3,44,12> }
         
      }
/*      #declare Count = -11.5;
      #while ( Count < 12 )
         box { <2,40,Count>,<9,45,Count+1> }
         box { <-2,40,Count>,<-9,45,Count+1> }
         cylinder { <2,40,Count+0.5>,<2,45,Count+0.5>,0.5 }
         cylinder { <-2,40,Count+0.5>,<-2,45,Count+0.5>,0.5 }
         #declare Count = Count + 2;
      #end
*/   }
   
   difference {
      box { <-7,39,-16>,<7,40,16> }
      box { <0,0,-17>,<2,2,17> rotate z*45 translate <7,39,0> }
      box { <-2,0,-17>,<0,2,17> rotate -z*45 translate <-7,39,0> }
      box { <-8,0,-2>,<8,2,0> rotate x*45 translate <0,39,-16> }
      box { <-8,0,0>,<8,2,2> rotate -x*45 translate <0,39,16> }
   }
}


#declare CamUpperPart_small = merge {     // upper part
   difference {
      merge {   
         box { <-3,35,-15>,<3,41,15> }
         box { <-6,35,-12>,<6,41,12> }
         cylinder { <-3,36,-12>,<-3,41,-12>,3 }
         cylinder { <3,36,-12>,<3,41,-12>,3 }
         cylinder { <-3,36,12>,<-3,41,12>,3 }
         cylinder { <3,36,12>,<3,41,12>,3 }
  
         sphere { <-3,41,-12>,3 }
         sphere { <3,41,-12>,3 }
         sphere { <-3,41,12>,3 }
         sphere { <3,41,12>,3 }
   
         cylinder { <-3,41,-12>,<3,41,-12>,3 }
         cylinder { <-3,41,12>,<3,41,12>,3 }
         cylinder { <3,41,12>,<3,41,-12>,3 }
         cylinder { <-3,41,12>,<-3,41,-12>,3 }
         box { <-3,38,-12>,<3,44,12> }
         
         translate <0,-37,0>
         scale 0.99
         translate <0,37,0>
      }
      #declare Count = -11.5;
      #while ( Count < 12 )
         box { <2,40-0.03,Count-0.01>,<9,45,Count+1.01> }
         box { <-2,40-0.03,Count-0.01>,<-9,45,Count+1.01> }
         cylinder { <2,40-0.03,Count+0.5>,<2,45,Count+0.5>,0.5*1.01 }
         cylinder { <-2,40-0.03,Count+0.5>,<-2,45,Count+0.5>,0.5*1.01 }
         #declare Count = Count + 2;
      #end
   }
   
/*   difference {
      box { <-7,39,-16>,<7,40,16> }
      box { <0,0,-17>,<2,2,17> rotate z*45 translate <7,39,0> }
      box { <-2,0,-17>,<0,2,17> rotate -z*45 translate <-7,39,0> }
      box { <-8,0,-2>,<8,2,0> rotate x*45 translate <0,39,-16> }
      box { <-8,0,0>,<8,2,2> rotate -x*45 translate <0,39,16> }
   }
*/
}

#declare CamLowerPart = merge {
   difference {
      merge {
         sphere { <-5,4.5,-12>,0.5 }
         sphere { <5,4.5,-12>,0.5 }
         sphere { <-5,4.5,12>,0.5 }
         sphere { <5,4.5,12>,0.5 }
   
         cylinder { <-5,4.5,-12>,<5,4.5,-12>,0.5 }
         cylinder { <-5,4.5,12>,<5,4.5,12>,0.5 }
         cylinder { <-5,4.5,-12>,<-5,4.5,12>,0.5 }
         cylinder { <5,4.5,-12>,<5,4.5,12>,0.5 }
   
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <23,0,-23> translate <5,4.5,12> }
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <-23,0,-23> translate <5,4.5,-12> }
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <23,0,23> translate <-5,4.5,12> }
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <-23,0,23> translate <-5,4.5,-12> }

         box { <-5,4,-12>,<5,9,12> }   

         difference {
            box { <-8,0,-0.5>,<8,8,0.5> }
            box { <-5,-1,-1>,<0,12,1> rotate z*23 translate <-5,0,0> }
            box { <0,-1,-1>,<5,12,1> rotate -z*23 translate <5,0,0> }
      
            rotate -x*23
            translate <0,4.5,-12>
         }
         difference {
            box { <-8,0,-0.5>,<8,8,0.5> }
            box { <-5,-1,-1>,<0,12,1> rotate z*23 translate <-5,0,0> }
            box { <0,-1,-1>,<5,12,1> rotate -z*23 translate <5,0,0> }
      
            rotate -x*23
            scale <1,1,-1>
            translate <0,4.5,12>
         }
   
         difference {
            box { <-0.5,0,-15>,<0.5,8,15> }
            box { <-1,-1,-5>,<1,12,0> rotate -x*23 translate <0,0,-12> }
            box { <-1,-1,0>,<1,12,5> rotate x*23 translate <0,0,12> }
      
            rotate z*23
            translate <-5,4.5,0>
         }
         difference {
            box { <-0.5,0,-15>,<0.5,8,15> }
            box { <-1,-1,-5>,<1,12,0> rotate -x*23 translate <0,0,-12> }
            box { <-1,-1,0>,<1,12,5> rotate x*23 translate <0,0,12> }
      
            rotate z*23
            scale <-1,1,1>
            translate <5,4.5,0>
         }
      
      
      }
      
//      cylinder { <-3,6.5,-15>,<-3,6.5,-5>,1 } in der Geissterkamera raus
      
      
      }
//      torus { 1,0.2 rotate 90*x translate <0,2.5,-0.5>  rotate -x*23 translate <-3,4,-12> }, dito
}

#declare CamLowerPart_small = merge {
   difference {
      merge {
         sphere { <-5,4.5,-12>,0.5 }
         sphere { <5,4.5,-12>,0.5 }
         sphere { <-5,4.5,12>,0.5 }
         sphere { <5,4.5,12>,0.5 }
   
         cylinder { <-5,4.5,-12>,<5,4.5,-12>,0.5 }
         cylinder { <-5,4.5,12>,<5,4.5,12>,0.5 }
         cylinder { <-5,4.5,-12>,<-5,4.5,12>,0.5 }
         cylinder { <5,4.5,-12>,<5,4.5,12>,0.5 }
   
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <23,0,-23> translate <5,4.5,12> }
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <-23,0,-23> translate <5,4.5,-12> }
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <23,0,23> translate <-5,4.5,12> }
         cylinder { <0,0,0>,<0,8,0>,0.5 rotate <-23,0,23> translate <-5,4.5,-12> }

         box { <-5,4,-12>,<5,12,12> }   // hier alles ein wenig hher

         difference {
            box { <-8,0,-0.5>,<8,10,0.5> }
            box { <-5,-1,-1>,<0,14,1> rotate z*23 translate <-5,0,0> }
            box { <0,-1,-1>,<5,14,1> rotate -z*23 translate <5,0,0> }
      
            rotate -x*23
            translate <0,4.5,-12>
         }
         difference {
            box { <-8,0,-0.5>,<8,10,0.5> }
            box { <-5,-1,-1>,<0,14,1> rotate z*23 translate <-5,0,0> }
            box { <0,-1,-1>,<5,14,1> rotate -z*23 translate <5,0,0> }
      
            rotate -x*23
            scale <1,1,-1>
            translate <0,4.5,12>
         }
   
         difference {
            box { <-0.5,0,-15>,<0.5,10,15> }
            box { <-1,-1,-5>,<1,14,0> rotate -x*23 translate <0,0,-12> }
            box { <-1,-1,0>,<1,14,5> rotate x*23 translate <0,0,12> }
      
            rotate z*23
            translate <-5,4.5,0>
         }
         difference {
            box { <-0.5,0,-15>,<0.5,10,15> }
            box { <-1,-1,-5>,<1,14,0> rotate -x*23 translate <0,0,-12> }
            box { <-1,-1,0>,<1,14,5> rotate x*23 translate <0,0,12> }
      
            rotate z*23
            scale <-1,1,1>
            translate <5,4.5,0>
         }
      
      
      }
      
//      cylinder { <-3,6.5,-15>,<-3,6.5,-5>,1 } in der Geissterkamera raus
      
      
   }
//      torus { 1,0.2 rotate 90*x translate <0,2.5,-0.5>  rotate -x*23 translate <-3,4,-12> }, dito
   translate <0,-8,0>
   scale 0.99
   translate <0,8,0>
   

}


#declare Camera = merge {
   difference {
      merge {
      difference {
         merge {
            object { CamPart }
            object { CamPart scale <9/10,9/10,1.05> translate <0,1.6,0> }
         }
         sphere { 0,5 scale <1/4,1/2,1.2> translate <12,24,0> }
      }
   
   // hand hold
      merge {
         cone { <-1,1,-8>,0.75,<2,1,-8>,0.5 }
         cone { <-1,1,8>,0.75,<2,1,8>,0.5 }
         cone { <-1,-1,-8>,0.75,<2,-1,-8>,0.5 }
         cone { <-1,-1,8>,0.75,<2,-1,8>,0.5 }
         sphere { <2,1,-8>,0.5 }
         sphere { <2,1,8>,0.5 }
         sphere { <2,-1,-8>,0.5 }
         sphere { <2,-1,8>,0.5 }
      
         box { <-1,-1,-8.2>,<2,1,-7.8> }
         box { <-1,-1,8.2>,<2,1,7.8> }
         box { <1.8,-1,-8>,<2.2,1,8> }
      
         cylinder { <2,-1,-8>,<2,-1,8>,0.5 } 
         cylinder { <2,1,-8>,<2,1,8>,0.5 } 
      
         translate <12,24,0>
   
      }
   
   
      // lens caps
      torus { 1,0.6 rotate x*90 translate <0,12,-18>  }
      cylinder { <0,0,-0.2>,<0,0,0.2>,0.5 translate <0,12,-18> }
   
      merge {
         cone { <0,0,-1>,3,<0,0,2>,2.75 }
         cone { <2,1,1>,0.5,<4,2,1>,0.2 }
         cone { <2.2,0,1>,0.5,<4.5,0,1>,0.2 }
         sphere { <4,2,1>,0.4 }
         sphere { <4.5,0,1>,0.4 }
         scale <1,1,-1> 
         rotate z*30
         translate <0,7,0>
      
//      rotate
         translate <0,23,-18>
      
      }

      merge {
         cone { <0,0,-1>,3,<0,0,2>,2.75 }
         cone { <2,1,1>,0.5,<4,2,1>,0.2 }
         cone { <2.2,0,1>,0.5,<4.5,0,1>,0.2 }
         sphere { <4,2,1>,0.4 }
         sphere { <4.5,0,1>,0.4 }
         scale <1,1,-1> 
      
         rotate z*30
         translate <0,7,0>
      
         rotate z*72
         translate <0,23,-18>
      
      }


      merge {
         cone { <0,0,-1>,3,<0,0,2>,2.75 }
         cone { <2,1,1>,0.5,<4,2,1>,0.2 }
         cone { <2.2,0,1>,0.5,<4.5,0,1>,0.2 }
         sphere { <4,2,1>,0.4 }
         sphere { <4.5,0,1>,0.4 }
         scale <1,1,-1> 
      
         rotate z*30
         translate <0,7,0>
      
         rotate z*72*2
         translate <0,23,-18>
      
      }

      merge {
         cone { <0,0,-1>,3,<0,0,2>,2.75 }
         cone { <2,1,1>,0.5,<4,2,1>,0.2 }
         cone { <2.2,0,1>,0.5,<4.5,0,1>,0.2 }
         sphere { <4,2,1>,0.4 }
         sphere { <4.5,0,1>,0.4 }
         scale <1,1,-1> 
      
         rotate z*60
         translate <0,7,0>
      
         rotate z*72*3
         translate <0,23,-18>
      
      }

      merge {
         cone { <0,0,-1>,3,<0,0,2>,2.75 }
         cone { <2,1,1>,0.5,<4,2,1>,0.2 }
         cone { <2.2,0,1>,0.5,<4.5,0,1>,0.2 }
         sphere { <4,2,1>,0.4 }
         sphere { <4.5,0,1>,0.4 }
         scale <1,1,-1> 
      
         rotate z*50
         translate <0,7,0>
      
         rotate z*72*4
         translate <0,23,-18>
      
      }


      merge {
         difference {
            cylinder { <0,0,-1>,<0,0,1>,4 }
            torus { 4,1 rotate x*90 translate <0,0,-1> }
         }
         torus { 3,0.25 rotate x*90 translate <0,0,-1> }
         cylinder { <0,0,-1.25>,<0,0,1>,3 }
      
         translate <0,23,-18>
      }

         object { CamLowerPart }   
         object { CamUpperPart }
         
         texture { OuterMat}
      }
      merge {
         difference {
            merge {
               object { CamPart_small }
               object { CamPart_small scale <9/10,9/10,1.05> translate <0,1.6,0> }
            }
            sphere { 0,5 scale <1/4,1/2,1.2>*0.99 translate <12,24,0> }
         }
         object { CamUpperPart_small }
         object { CamLowerPart_small }

         texture { InnerMat }
      }
   }
   GhostInt(50,0.9,0.25,<0.95,0.95,1>)
   hollow
   no_shadow
}

#declare CamSupportUp = merge {
      difference {
         merge {
            cylinder { <4.3,2,0>,<5.3,2,0>,5 }
            cylinder { <-4.3,2,0>,<-5.3,2,0>,5 }
         }
         box { <-10,2,-10>,<10,11,10> }
      }
      box { <-8,2,-8>,<8,4,8> }
      cylinder { <8,3,-6>,<8,3,-2>,1 }
      cylinder { <8,3,6>,<8,3,2>,1 }
      merge {
         box { <0,-1,-6>,<8,1,-2> }
         box { <0,-1,6>,<8,1,2> }
         cylinder { <8,0,-16>,<8,0,16>,1 }
         sphere { <8,0,-16>,1}
         sphere { <8,0,16>,1}
         cylinder { <8,0,16>,<14,0,19>,1 }
         sphere { <14,0,19>, 1 }
         cylinder { <14,0,19>,<16,0,39>,1 }
         sphere { <16,0,39>,1 }
         rotate -z*60 translate <8,3,0>
      }    
}

#declare CamSupportUp_small = merge {
      difference {
         merge {
            cylinder { <4.3+0.1,2,0>,<5.3-0.1,2,0>,5*0.99 }
            cylinder { <-4.3-0.1,2,0>,<-5.3+0.1,2,0>,5*0.99 }
         }
         box { <-10,2+0.2,-10>,<10,11,10> }
      }
      box { <-8+0.1,2+0.1,-8+0.1>,<8-0.1,4-0.1,8-0.1> }
/*      cylinder { <8,3,-6>,<8,3,-2>,1 }
      cylinder { <8,3,6>,<8,3,2>,1 }
      merge {
         box { <0,-1,-6>,<8,1,-2> }
         box { <0,-1,6>,<8,1,2> }
         cylinder { <8,0,-16>,<8,0,16>,1 }
         sphere { <8,0,-16>,1}
         sphere { <8,0,16>,1}
         cylinder { <8,0,16>,<14,0,19>,1 }
         sphere { <14,0,19>, 1 }
         cylinder { <14,0,19>,<16,0,39>,1 }
         sphere { <16,0,39>,1 }
         rotate -z*60 translate <8,3,0>
      }    
*/
}

#declare CamSupportLow = merge {
   cylinder { <0,-8,0>,<0,-3,0>,8 }
   cylinder { <6.3,-3,0>,<5.3,-3,0>,5 }
   sphere { <6.3,0,0>,1 }
   cylinder { <-6.3,-3,0>,<-5.3,-3,0>,5 }
   sphere { <-6.3,0,0>,1 }
   cylinder { <-6.3,0,0>,<6.3,0,0>,1 }
}
#declare CamSupportLow_small = merge {
   cylinder { <0,-8+0.1,0>,<0,-3-0.1,0>,8*0.99 }
   cylinder { <6.3-0.1,-3,0>,<5.3+0.1,-3,0>,5*0.99 }
   sphere { <6.3,0,0>,1*0.99 }
   cylinder { <-6.3+0.1,-3,0>,<-5.3-0.1,-3,0>,5 }
   sphere { <-6.3,0,0>,1*0.99 }
   cylinder { <-6.3+0.1,0,0>,<6.3-0.1,0,0>,1*0.99 }
}

#declare CamWithSupport = union {
//   difference {
      object { CamSupportLow texture { pigment { rgbt <1,1,1,0.2> } } //texture { OuterMat } 
//      }
//      object { CamSupportLow_small texture { InnerMat } }
      GhostInt(0.001,0.9,0.25,<0.95,0.95,1>)
      hollow
      no_shadow
   }
   union {
      object { Camera }
//      difference {
         object { CamSupportUp texture { OuterMat }
//         }
//         object { CamSupportUp_small texture { InnerMat } }
         GhostInt(15,0.9,0.25,<0.95,0.95,1>)
         hollow
         no_shadow
      }
      rotate -x*10 // rotate x
   }
       
    // rotate y

   translate <0,79,0>
}

#declare GhostCam = union {
   object { CamWithSupport }
   object { CamLegs
      texture { OuterMat }
      GhostInt(25,0.9,0.25,<0.95,0.95,1>)
      no_shadow
      hollow
   }

}

