

/************************************************** SupportBeam, upper floow, Start */

#ifndef(fn_Pigm)
   #declare fn_Pigm=function { // from the pov tutorials
      pigment {
         agate
         color_map {
            [0 color rgb 0 ]
            [1 color rgb 1 ]
         }
      }
   }
#end

/******************************************************* simple Beam ******************/

#declare fn1 = IC_Box(<0,0,-0.5>,<0.4,0.15,0.5>)
#declare fn2 = IC_Scale ( IC_Cylinder(<0,0,-0.5>,<0,0,0.5>,0.4 ), <1,1/2,1> )
#declare fn_SBSeg = IC_Merge2( function { fn1(x,y,z) }, function { fn2(x,y,z) } )

#undef fn1
#undef fn2


#declare fn_XX = function { fn_SBSeg(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam01 = union {
   isosurface {                                                                                     
      function { fn_XX(x, y, z) }  
      max_gradient 10 
      contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
      scale 1.2
   } 
}
#undef fn_XX

/******************************************************* Beam with a big cut at an end ******************/

#declare SB_CutsRad=0.1; // Range should be [ 0.01, 0.1]
#declare SB_CutsScaleZ=1; // Range depends on SB_CutRads 

#declare fn1 = IC_Cylinder ( <0.4,-0.2,0>,<0.4,0.2,0>,SB_CutsRad )
#declare fn5 = IC_Scale ( function { fn1(x,y,z) },<1,1,SB_CutsScaleZ>  )
#declare fn6 = IC_Translate ( function { fn5(x,y,z) },<0,0,0.5>  )

// big cut
#declare fn_Cut2 = function { fn6(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05}

#undef fn1
#undef fn5
#undef fn6

#declare fn1 = IC_Difference2( function { fn_SBSeg(x,y,z) } , function { fn_Cut2(x,y,z) } )
#declare fn_XX = function { fn1(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam02 = isosurface {                                                                                     
   function { fn_XX(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
   scale 1.2
} 
#undef fn1
#undef fn_XX

/******************************************************* Beam with a big cylindrical notch, horizontal centered******************/
// not really good the cut is too deep

#declare fn6 = IC_Translate ( function { fn_Cut2(x,y,z) },<0,0,-0.35>  )
#declare fn1 = IC_Difference2( function { fn_SBSeg(x,y,z) } , function { fn6(x,y,z) } )
#declare fn_XX = function { fn1(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam03 = isosurface {                                                                                     
   function { fn_XX(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
   scale 1.2
}
#undef fn6
#undef fn1
#undef fn_XX

/******************************************************* Beam with a flat cylindrical notch, horizontal, not centered ******************/
// fine

#declare SB_CutsRad=0.05; // Range should be [ 0.01, 0.1]
#declare SB_CutsScaleZ=3; // Range depends on SB_CutRads 

#declare fn1 = IC_Cylinder ( <0.4,-0.2,0>,<0.4,0.2,0>,SB_CutsRad )
#declare fn5 = IC_Scale ( function { fn1(x,y,z) },<1,1,SB_CutsScaleZ>  )
#declare fn6 = IC_Translate ( function { fn5(x,y,z) },<0.05,0,-0.15>  )
#undef fn1
#undef fn5

#declare fn_Cut5 = function { fn6(x,y,z)-fn_Pigm(x*25,y*25,z*1).gray*0.05}

#declare fn1 = IC_Difference2( function { fn_SBSeg(x,y,z) } , function { fn_Cut5(x,y,z) } )
#declare fn_XX = function { fn1(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam04 = isosurface {                                                                                     
   function { fn_XX(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
   scale 1.2
} 
#undef fn1
#undef fn_XX
#undef fn6

/******************************************************* Beam with a flat cylindrical notch, vertical, not centered ******************/
// fine for the scene, but as all stones here not for a close-up

#declare SB_CutsRad=0.05; // Range should be [ 0.01, 0.1]
#declare SB_CutsScaleZ=3; // Range depends on SB_CutRads 

#declare fn1 = IC_Cylinder ( <0.4,-0.2,0>,<0.4,0.2,0>,SB_CutsRad )
#declare fn5 = IC_Scale ( function { fn1(x,y,z) },<1,1,SB_CutsScaleZ>  )
#undef fn1

#declare fn6 = IC_Rotate ( function { fn5(x,y,z)-fn_Pigm(x*25,y*25,z*1).gray*0.05}, <90,0,0> )

#declare fn_Cut6 = IC_Translate ( function { fn6(x,y,z) },<0.05,0,-0.15>  )


#declare fn1 = IC_Difference2( function { fn_SBSeg(x,y,z) } , function { fn_Cut6(x,y,z) } )
#declare fn_XX = function { fn1(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam05 = isosurface {                                                                                     
   function { fn_XX(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
   scale 1.2
}
#undef fn5
#undef fn1
#undef fn_XX
#undef fn6


/******************************************************* Beam with a triangular notch, vertical, near one end ******************/
// not my favorite

#declare SB_CutScale=<0.1,0.1,0.025>; //<0.1,0.1,0.1>
#declare SB_CutAngle=<45,35,45>;
#declare fn1 = IC_Box ( <-1,-1,-1>,<1,1,1> )
#declare fn2 = IC_Rotate ( function{ fn1(x,y,z) }, SB_CutAngle )
#declare fn3 = IC_Scale ( function { fn2(x,y,z) }, SB_CutScale )
#declare fn6 = IC_Translate ( function { fn3(x,y,z) },<0.4,0.2,-0.35>  )

// mittlere Kerbe, vielleicht ungefhr auf jedem dritten Balken
#declare fn_Cut3 = function { fn6(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05}


#undef fn1
#undef fn2
#undef fn3
#undef fn6

#declare fn1 = IC_Difference2( function { fn_SBSeg(x,y,z) } , function { fn_Cut3(x,y,z) } )
#declare fn_XX = function { fn1(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam06 = isosurface {                                                                                     
   function { fn_XX(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
   scale 1.2
}
#undef fn1
#undef fn_XX


/******************************************************* Beam with a big flat notch at the upper surface , near one end ******************/
// ok for the scene, but as all stones here not for a close-up


#declare SB_CutScale=<0.1,0.1,0.2>; //<0.1,0.1,0.1>
#declare SB_CutAngle=<5,35,5>;
#declare fn1 = IC_Box ( <-1,-1,-1>,<1,1,1> )
#declare fn2 = IC_Rotate ( function{ fn1(x,y,z) }, SB_CutAngle )
#declare fn3 = IC_Scale ( function { fn2(x,y,z) }, SB_CutScale )
#declare fn6 = IC_Translate ( function { fn3(x,y,z) },<0.42,0.21,0.25>  )

// groe flache Kerbe 
#declare fn_Cut4 = function { fn6(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05}


#undef fn1
#undef fn2
#undef fn3
#undef fn6

#declare fn1 = IC_Difference2( function { fn_SBSeg(x,y,z) } , function { fn_Cut4(x,y,z) } )
#declare fn_XX = function { fn1(x,y,z)-f_granite(x,y,z)*0.00827 }

#declare SupportBeam07 = isosurface {                                                                                     
   function { fn_XX(x, y, z) }  
   max_gradient 10 
   contained_by { box { <-0.0,-0.5,-0.51>,<0.5,0.16,0.51> } }
   scale 1.2
}
#undef fn1
#undef fn_XX


/************************************************** SupportBeam, End */

#declare fn_GBSeg1 = IC_Box(<-0.6,-0.25,-0.5>,<0,0,0.5>)
#declare fn_GBSeg2 = IC_Box(<-0.2,-0.15,-0.5>,<0,0,0.5>)
#declare fn_GBSeg3 = IC_Box(<-0.4,-0.5,-0.5>,<0,0,0.5>)  // eigentlich 0.3 hoch, so kann aber die Hhe etwas variiert werden

#declare fn1 = IC_Scale ( IC_Sphere ( <0,0,0>,0.2 ), <1,0.2,1> )
#declare fn2 = IC_Scale ( IC_Sphere ( <0,0,0.2>,0.075 ), <1,0.2,1> )
#declare fn3 = IC_Scale ( IC_Sphere ( <0,0,-0.15>,0.15 ), <1,0.2,1> )
#declare fn5 = IC_Scale ( IC_Sphere ( <0,-0.05,-0.15>,0.15 ), <0.5,1,0.8> )
#declare fn6 = IC_Translate ( IC_Rotate ( IC_Scale ( IC_Sphere ( <0,0,0>,0.1 ), <0.5,1.5,0.6> ), <30,0,0> ), <0,-0.15,-0.15> )

#declare fn7 = IC_Merge5( function { fn1(x,y,z) },
                          function { fn2(x,y,z) },
                          function { fn3(x,y,z) },
                          function { fn5(x,y,z) },
                          function { fn6(x,y,z) } )
// deep notch at the side
#declare fn_GBCut01 = 
  IC_Scale ( function { fn7(x,y,z) - fn_Pigm(x*25,y*25,z*1).gray*0.05 },<0.5,0.5,0.5> )

#undef fn1 #undef fn2 #undef fn3 #undef fn5 #undef fn6 #undef fn7

#declare SB_CutScale=<0.25,0.1,0.2>; //<0.1,0.1,0.1>
#declare SB_CutAngle=<45,45,45>;
#declare fn1 = IC_Box ( <-1,-1,-1>,<1,1,1> )
#declare fn2 = IC_Rotate ( function{ fn1(x,y,z) }, SB_CutAngle )
#declare fn3 = IC_Scale ( function { fn2(x,y,z) }, SB_CutScale )
#declare fn6 = IC_Translate ( function { fn3(x,y,z) },<0.42,0.21,0.25>  )

#declare fn4 = function { fn6(x,y,z)-fn_Pigm(x*15,y*15,z*1).gray*0.05}


// big, flat triangular notch 
#declare fn_GBCut02 = IC_Scale ( IC_Translate ( function { fn4(x,y,z) },<-0.42,-0.1,-0.25> ), <1/3,1,3>/2 )

// small, flat triangular notch 
#declare fn_GBCut03 = IC_Scale ( IC_Translate ( function { fn4(x,y,z) },<-0.41,-0.1,-0.25> ), <1/3,1/8,1/8> )

#undef fn1 #undef fn2 #undef fn3 #undef fn6

// grooves across the upper surface
#declare fn_GBCut04 = IC_Translate ( IC_Rotate( function { fn_Cut6(x,y,z) },<0,0,90>) , <0,-0.4,0.15> )

// big, deeper traingular notch 
#declare fn_GBCut05 = IC_Scale ( IC_Translate ( function { fn4(x,y,z) },<-0.42,-0.1,-0.25> ), <2/3,10,3>/4 )

// small round notch
#declare fn1 = IC_Scale ( IC_Sphere ( <0,0,0>,0.01 ),<1,1,2> )
#declare fn_GBCut06 = function { fn1(x,y,z) - fn_Pigm(x*15,y*15,z*15).gray*0.01 }
#undef fn1
                      

