#version 3.6;

#declare RAD       = 2;
                
global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        max_trace_level 20
        #if(RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 20*RAD                
                        nearest_count RAD      
                        error_bound 2/RAD      
                        recursion_limit 3      
                        gray_threshold 0.4  
                        minimum_reuse 0.015 
                        brightness 2.3      
                        adc_bailout 0.005
                        normal on
                        media on
                }
        #end
}        


#declare cam_loc = <0,0.5,-2>;
#declare lookat = <0,0.4,0>;
camera {
        location cam_loc 
        right x*image_width/image_height 
        up y 
        look_at lookat 
        angle 40
}

light_source {<50,50,10>*100,2}
 
background {color rgb 1}
plane {y,0 hollow pigment {color rgb 0.5}}

//Bounding Box....... from x,y,z=(-0.5619124,-0.01671508,-0.5945876)
//                      to x,y,z=(0.5802047,0.9038506,0.4923246)
//                 size dx,dy,dz=(1.142117,0.9205657,1.086912)
//                  center x,y,z=(0.009146154,0.4435678,-0.05113147)
//                       diagonal 1.825719
//Surface area................... 6.988972
//             Smallest face area 1.984028E-7
//              Largest face area 0.001971317
//Memory allocated for geometry.. 1 MByte
// 
//==================================================
 
#include "stdinc.inc" 

//Map definitions
#declare p_map1=pigment {image_map{png "fittonia_verschaffeltii_bark.png" interpolate 2}}
#declare p_map2=normal {bump_map{png "fittonia_verschaffeltii_bark.png" interpolate 2}}
#declare p_map3=pigment {image_map{png "FSC2_C.png" interpolate 2}}
#declare p_map4=normal {bump_map{png "FSC2_BG.png" interpolate 2}}
#declare p_map5=pigment {image_map{png "FSC2_N.png" interpolate 2}}
#declare p_map6=pigment {image_map{png "FSC2_C2.png" interpolate 2}} 

//==================================================
//Material definitions
#declare Stem_tex = 
texture{pigment{p_map1} 
        normal{p_map2 bump_size 1} 
        finish{ phong 0.1 phong_size 10 diffuse 0.6 ambient 0}}
//==================================================
#declare clear_tex =
texture{pigment {color rgbt 1} 
        finish{diffuse 0.6 ambient 0}}
#declare Default_Leaf1= 
texture{pigment {p_map3} 
        normal{p_map4 bump_size 1} 
        finish{ phong 0.1 phong_size 10 diffuse 0.6 ambient 0}}
#declare Leaf_tex1 =                                             // original reddish leaf texture 
texture{uv_mapping pigment_pattern{p_map5} 
texture_map{[0 clear_tex]
            [1 Default_Leaf1]
           }}
//==================================================
#declare Default_Leaf2= 
texture{pigment {p_map6} 
        normal{p_map4 bump_size 1} 
        finish{ phong 0.1 phong_size 10 diffuse 0.6 ambient 0}}
#declare Leaf_tex2 =                                            // additional greener leaf texture
texture{uv_mapping pigment_pattern{p_map5} 
texture_map{[0 clear_tex]
            [1 Default_Leaf2]
           }}
//==================================================
/*
#declare Default_Leaf0= 
texture{pigment{color rgb 1} 
        finish{diffuse 0.6 ambient 0}}
#declare Leaf_tex =                                           // plain white texture for the projection pattern
texture{uv_mapping pigment_pattern{p_map5} 
texture_map{[0 clear_tex]
            [1 Default_Leaf0]
           }}
//==================================================
#include "fittonia_verschaffeltii_POV_geom3.inc"

#declare Leaf_tex =
texture {
        projection {small_shrub parallel y blur 0.4,40}
        texture_map {
                [0.0 Leaf_tex1]
                [0.3 Leaf_tex1]
                [0.3 Leaf_tex2]
                [1.0 Leaf_tex2]
        }
}

#include "fittonia_verschaffeltii_POV_geom3.inc"
#declare Leaf_pig =
pigment {
        projection {small_shrub parallel y blur 0.4,40}   // projection of mesh on itself
        color_map {
                [0.0 color rgb x]
                [0.3 color rgb x]
                [0.3 color rgb y]
                [1.0 color rgb y]
        }

}
 
//==================================================
#declare vertex_cnt = 6912;
#declare Array = array[vertex_cnt]

#declare NrOfItems = dimension_size(Array,3);
#fopen ReadFile "leaf_mesh1.txt" read
#declare Cnt = 0;
#declare Tem1 = <0,0,0>;
#while (Cnt < vertex_cnt)
        #read (ReadFile, Tem1)
        #declare Array[Cnt] = Tem1;
        #declare Cnt = Cnt + 1;
#end 
#fclose ReadFile

#fopen WriteFile "leaf_mesh2.txt" write
#declare Cnt = 0;
#declare Tem2 = <0,0,0>;
#declare fn = function {pigment {Leaf_pig}}
#while (Cnt < vertex_cnt)
        #declare Tem2 = (fn(Array[Cnt].x, Array[Cnt].y, Array[Cnt].z));
        #if ((Tem2.x = 1)&(Tem2.y = 0)&(Tem2.z = 0))
                #write (WriteFile,"1 \n")
        #end
        #if ((Tem2.x = 0)&(Tem2.y = 1)&(Tem2.z = 0))
                #write (WriteFile,"2 \n")
        #end
        #declare Cnt = Cnt + 1;
        #if(mod(Cnt,1000) = 0)
                #debug concat(str(Cnt,0,0)," vertices\n")
        #end 
#end  
#fclose WriteFile
*/
#include "fittonia_verschaffeltii_geom4.inc"
 
object {small_shrub double_illuminate hollow}
