// tek.inc - by Tekno Frannansa
// Some useful scene creation macros
// This is a cut-down version of the HUGE file I actually use, which is too messy to share publically.

#version 3.7;

#include "rad_def.inc"
#include "functions.inc"


// maths
#declare SignPow = function(x,p) { x*pow(abs(x),p-1) }
#declare InvSignPow = function(x,p) { select(x,-1+pow(1-abs(x),p),1-pow(1-abs(x),p)) }

#macro VAbs(A) <abs(A.x),abs(A.y),abs((A*z).z)> #end

// given a value in [-1,1] apply a curve to correct distribution in proportion to length of circumference of a circle at that lattitude
// integral of f(x) = cos(pi*f(x)), so probability of being placed at any given value == length of circumference at that lattitude
// not sure if asin(x) is the right answer, but it looks pretty good.
#declare SphereAngleDistribute = function(x) { asin(x)/(pi/2) }

// evenly distributed random point on a sphere
#macro SphereRand(Seed) vrotate( z, <90*SphereAngleDistribute(rand(Seed)*2-1),360*rand(Seed)> ) #end

#macro RandOrient(Seed)
   // evenly distribute orientations on surface of sphere, and at random angles
   // owing to order of computation I'm basing this on <1,0,0>, though that doesn't matter since all orientations will be equally likely
   <rand(Seed)*360,SphereAngleDistribute(rand(Seed))*90,rand(Seed)*360>
#end


// global setup
#macro Radiosity(RadType)
   #declare StoredRadType = RadType;
#end

#macro Default(Brightness)
	#default { pigment { rgb 1 } finish { diffuse Brightness emission 0 ambient 0 } }
#end

#macro DefaultNoRad(Ambient)
	#default { pigment { rgb 1 } finish { diffuse .8 emission rgb Ambient ambient 0 } }
#end

#macro BG(Col) background { rgb Col } #end

#macro Global( DoRad )
	//#version unofficial megapov 1.21;  doesn't work :(, have to put into each file.
	global_settings {
		#if ( DoRad )
			#ifndef (StoredRadType) Radiosity(Radiosity_Fast) #end
      	radiosity { Rad_Settings( StoredRadType, on, on ) }
		#end
		max_trace_level 4
	}
	#if ( DoRad )
		Default(.7)
	#else
		DefaultNoRad(.2)
	#end
	
	#declare DefaultTexture = texture{}; // this is kind of buried, but it needs to be placed here, just in case default isn't retroactive
#end



// camera setup

#macro CamAxes(Zoom)
	right			x*image_width/image_height
	up				y
	direction	z*Zoom
	
	#declare StoredCamDim = <image_width/image_height,1,Zoom>;
#end


#macro CamPolar (Origin,Rotation,Distance,Zoom)
	camera {
		CamAxes(Zoom)
		
		translate -z*Distance
		rotate Rotation*z
		rotate Rotation*<1,1,0>
		translate Origin
		
		#declare StoredCamLoc = vrotate( -z*Distance, Rotation*<1,1,0> ) + Origin;
		#declare StoredCamLook = Origin;
	}
#end



// Place a sun, using polar coordinates
#macro SunLightPolar( Rot, Col )
	light_source {
		vrotate(-z,Rot)*10000, rgb Col parallel point_at 0
	}
#end



// materials
#macro Flip()
   colour_map { [0 rgb 1][1 rgb 0] }
#end

#macro Specular(Shininess)
	// remarkably good effect achieved by balancing specular power vs intensity
	specular Shininess/32 roughness 1/Shininess
#end

#declare p_HSV =
	pigment {
		gradient z
		pigment_map {
			[0 rgb 0]
			[1
				gradient y
				pigment_map {
					[0 rgb 1]
					[1
						gradient x
						colour_map {
							[0/6 rgb x]
							[1/6 rgb x+y]
							[2/6 rgb y]
							[3/6 rgb y+z]
							[4/6 rgb z]
							[5/6 rgb x+z]
							[6/6 rgb x]
						}
					]
				}
			]
		}
	};

#declare f_HSV = function { pigment { p_HSV } };

#macro HSV(V) #local F = f_HSV(V.x,V.y,V.z); <F.x,F.y,F.z> #end
// 'F' - avoids a dumb warning caused by passing function result directly.



// simple preset for building objects, set up for an object like sphere { 0, 1 }
#macro ObjectPreset()
	#ifndef (Chromacity) #local Chromacity = .1; #end
	#local S = Chromacity*<-1,-1/4,1>;
	Global(on)
	sky_sphere { pigment { function { InvSignPow(y,2)*.5+.5 } colour_map { [0 rgb .05][1 rgb .5*(1+S)] } } }
	SunLightPolar( <60,70>, rgb 1.2*(1-S) )
	CamPolar( 0, <10,-5>, 5, 2 )
#end
