// SMOOTH CSG EXAMPLE - by Tekno Frannansa
// Sculpting smooth manufactured shapes

#version 3.7;

#include "tek.inc"
#include "../smooth_csg.inc"

ObjectPreset()

// bright shapes to make reflections more interesting.
#declare rs = seed(21);
#local i=0; #while ( i < 5 )
	disc { z, -z, .7 pigment { rgb 1 } finish { diffuse 0 emission 4 } scale 1000 rotate RandOrient(rs) no_shadow no_radiosity }
#local i=i+1; #end


//uncomment this to see the hard-edged version of the shapes, which renders a bit faster
//#declare SCSG_PREVIEW = 1;


// this is the basic shape of the smooth surface
#declare fairingShape =
	mf_Merge3 (
		mf_Cylinder( -x, x*1.2, .5, .1 ),
		mf_Cylinder( -x*.7, x*.7, .7, .1 ),
		mf_CylinderLoci( vrotate(-x*.3-z*.7,-45*x), vrotate(x*.3-z*.7,-45*x), .25 ),//, .1 ),
		.1
	)

// cut holes for the rocket booster and the side vents
#declare fairingCutout =
	mf_Inverse(
		mf_Merge4(
			// trim the back
			mf_Plane( -x, -1 ),
			// vents
			mf_CylinderLoci( vrotate(-z*.7+x*.3,x*20), vrotate(-z*.7+x*.5,x*20), .03 ),
			mf_CylinderLoci( vrotate(-z*.7+x*.3,x*30), vrotate(-z*.7+x*.5,x*30), .03 ),
			mf_CylinderLoci( vrotate(-z*.7+x*.3,x*40), vrotate(-z*.7+x*.5,x*40), .03 ),
			.01
		)
	)


// combine those things
#declare fairing =
	mf_Intersection8(
		fairingShape,

		// intersect with an offset inverted version of itself, so the shape is a thin surface rather than a solid lump.
		mf_Inverse( mf_Offset( fairingShape, .03 ) ),

		// intersect with the cutouts
		fairingCutout,

		// creases on the surface, these are offset so they don't cut all the way through.
		mf_Offset(mf_Inverse(mf_Hollow(mf_Plane(x,.1))), -.01),
		mf_Offset(mf_Inverse(mf_Hollow(mf_Plane(x,-.6))), -.01),
		mf_Offset(mf_Inverse(mf_Hollow(mf_Plane(x,.8))), -.01),
		mf_Offset(mf_Inverse(mf_Hollow(mf_Plane(vrotate(z,-30*x),0))), -.01),
		mf_Offset(mf_Inverse(mf_Hollow(mf_Plane(vrotate(z,45*x),0))), -.01),

		// Use a small amount of smoothing.
		// This MUST be less than half the thickness of the surface (which is set to .03, above).
		// If an edge is too thin for a given amount of smoothing it will collapse to nothing.
		.01
	)

object {
	SmoothCSG( fairing, <-1.5,-2,-1>, <1.1,1.5,4> )
	
	texture {
		pigment {
			planar rotate z*45
			colour_map {
				[.85 rgb 1]
				[.85 rgb <0,.2,1>]
			}
		}
		finish { brilliance 2 }
	}
	texture {
		pigment { rgbt 1 }
		finish {
			reflection { 0, 1 falloff 5 } conserve_energy
			Specular(10)
		}
	}
	
	no_reflection
}


// create a rocket engine, using some randomness
#macro Engine( Pos, Rad )
	union {
		#local r=Rad; #while ( r > 0 )
			#if (rand(rs) < .5)
				#local s=r-rand(rs)*.1+.03;
				difference {
					cone { Pos-x*.1, r, Pos+x*.1 s }
					#local r=max(0,r-pow(rand(rs),3)*.3-.02);
					cone { Pos-x*.101, r, Pos+x*.101, s }
					
					// high tech metal
					texture {
						pigment { rgb rand(rs) }
						normal { facets .02 }
						finish { brilliance 2 }
					}
					texture {
						pigment { rgbt 1 }
						normal { facets .02 }
						finish {
							reflection { .01, 1 falloff 5 } conserve_energy
							Specular(100)
						}
					}
				}
			#else
				disc {
					Pos-x*.1, x, r,
					#local r=max(0,r-pow(rand(rs),3)*.3-.02);
					r
					pigment { rgb f_HSV(1.1-.7*r/Rad,.7,1)*2 }
					finish { emission 1 diffuse 0 }
				}
			#end
		#end
	}
#end
	
#local rs = seed(22);
Engine( x, .47 )


CamPolar( 0, <10,-30>, 8, 3 )
