// SMOOTH CSG EXAMPLE - by Tekno Frannansa
// Using smooth CSG as a smoothed proximity pattern.

#version 3.7;

#include "tek.inc"
#include "../smooth_csg.inc"

ObjectPreset()


// define the main object in a macro, so we can reproduce it with different amounts of smoothing.
#macro theObject(smoothing)
	mf_Merge4 (
		mf_Difference2(
			mf_Cylinder( -z*.2, 0, 1, smoothing ),
			mf_Cylinder( -z, z, .7, smoothing ),
			smoothing
		),
		mf_Box( <-1,-1.6,0>, <1,1.5,1>, smoothing ),
		mf_Box( <-.5,-1.6,-.1>, <.5,0,0>, smoothing ),
		mf_Plane( y, -1.5 ),
		smoothing
	)
#end

// the hard-edged version will be used for the base shape
#declare hard = theObject(.01)

// this smoother version is used for secondary effects
#declare soft = theObject(.05)

union {
	isosurface {
		function {
			// define the underlying shape
			hard(x,y,z)
			
			// carve cracks into it near the edges
			+.4*pow(min(1,max(0,.5+20*soft(x,y,z))),8)*pow(1-.8*f_granite(x,y,z),8)
		}
		max_gradient 5
		
		// tightly bound the CSG, we're doing such complex effects that it draws rather slowly.
		contained_by { box { <-1.05,-1.55,-.25>, <1.05,1.55,1.05> } }
	}

	// extend the ground outside the isosurface. This draws faster than if we extended the isosurface bounds.
	box { -3, <3,-1.501,3> }

	// place moss in crevices
	texture {
		pigment_pattern {
			average
			pigment_map {
				[1 function { min(1,max(0,soft(x,y,z)*20+.5)) } poly_wave 2]
				[.25 granite scale .1 Flip()]
			}
		}
		texture_map {
			[0 pigment { rgb <.5,.8,.3> }]
			[.25
				pigment { rgb <.2,.3,.1> }
				normal { granite 1 scale .1 }
			]
			[.25 pigment { rgb 1 }]
		}
	}
}


CamPolar( 0, <10,-20>, 8, 2 )


