// SMOOTH CSG EXAMPLE - by Tekno Frannansa
// Mixing smooth CSG with user defined functions

#version 3.7;

#include "tek.inc"
#include "../smooth_csg.inc"

ObjectPreset()

CamPolar( 0, <5,-30>, 8, 2 )

// user defined pattern will be based on this smoothed tetrahedron
#local f_tetra =
	mf_Intersection4(
		mf_Plane(x+y+z,0),
		mf_Plane(-x-y+z,0),
		mf_Plane(-x+y-z,0),
		mf_Plane(x-y-z,0),
		.02
	)

#local f_shape =
	mf_Intersection3(
		// basic shape is a box (rounded, of course)
		mf_Box(-1,1,.02),
		
		// make it hollow
		mf_Inverse( mf_Box(-.8,.8,.02) ),
		
		// user defined pattern carving holes in the box
		function {
			sin(f_tetra(x,y,z)*4*pi)/(4*pi) // scale it down so it has a 1:1 gradient
		},
		.02
	)

object {
	SmoothCSG(
		function { f_shape(x+sin(y*40)/40,y,z+cos(y*40)/40) },
		-1.2, 1.2
	)

	//rotate -30*y	
}

plane { y, -1 pigment { rgb .4 } }