//=============================================================================
// Persistence of Vision Ray Tracer Scene File
//-----------------------------------------------------------------------------
// File        : rwm_multipass.inc
// POV Version : 3.7
// Description : Image compositing macros for multi-pass-render post-processing
//               diectly in POV-Ray
// Date        : 10/14/2008
// Author      : Robert W. McGregor
//                  Rob@McGregorFineArt.com
//                  www.McGregorFineArt.com
//-----------------------------------------------------------------------------
// Macros: 
//    Pigment_Wrapper()
//    Finish_Wrapper() 
//=============================================================================

#ifndef(RWM_MULTIPASS_INC_TEMP)
#declare RWM_MULTIPASS_INC_TEMP = version;

//------------------------------------------------------------------------------ 
// Render pass types for multi-pass renders
//------------------------------------------------------------------------------ 

#ifndef (Current_Pass)           #declare Current_Pass = 0;           #end
#ifndef (Quick_Pass)             #declare Quick_Pass = 0;             #end
#ifndef (Beauty_Pass)            #declare Beauty_Pass = 1;            #end
#ifndef (Ambient_Occlusion_Pass) #declare Ambient_Occlusion_Pass = 2; #end
#ifndef (Depth_Pass)             #declare Depth_Pass = 3;             #end
#ifndef (Reflection_Pass)        #declare Reflection_Pass = 4;        #end
#ifndef (Subsurface_Pass)        #declare Subsurface_Pass = 5;        #end
#ifndef (Direct_Lighting_Pass)   #declare Direct_Lighting_Pass = 6;   #end

//------------------------------------------------------------------------------ 
// Predefined render pass pigments & finishes
//------------------------------------------------------------------------------ 
#declare P_Quick             = pigment { rgb 0.5 }
#declare P_Ambient_Occlusion = pigment { rgb 2 }
#declare P_Depth_Map         = pigment { rgb 0 }
#declare P_Reflection_Map    = pigment { rgb 0 }
#declare P_Direct_Lighting   = pigment { rgb 1 }

#declare F_Quick_Pass = 
   // use default diffuse
   finish { specular 0.0 reflection 0.0 emission 0.0 ambient 0.0 } 

#declare F_Ambient_Occlusion = 
   finish { specular 0.0 reflection 0.0 emission 0.0 ambient 0.0 diffuse 8.0 }

#declare F_Depth_Map = 
   finish { specular 0.0 reflection 0.0 emission 0.0 ambient 0.0 diffuse 0.0 }

#declare F_Reflection = 
   finish { specular 0.0 reflection 0.0 emission 0.0 ambient 0.0 diffuse 0.0 }

#declare F_Subsurface = 
   finish { specular 0.0 reflection 0.0 emission 0.0 ambient 0.0 diffuse 0.0 }

#declare F_Direct_Lighting = 
   // use default diffuse
   finish { specular 0.0 reflection 0.0 emission 0.0 ambient 0.0 } 

//------------------------------------------------------------------------------ 
// Macro: Pigment_Wrapper() - for multi-pass renders
//------------------------------------------------------------------------------ 
// Params: 
//    [pgmt] the source pigment that can be converted into a predefined render 
//           pass pigment (based on render type)
//------------------------------------------------------------------------------ 

#macro Pigment_Wrapper(pgmt)
   pigment {
      #switch (Current_Pass)
         #case (Quick_Pass)
            P_Quick
            #break
            
         #case (Ambient_Occlusion_Pass)
            P_Ambient_Occlusion
            #break
            
         #case (Depth_Pass)
            P_Depth_Map
            #break
         
         #case (Reflection_Pass)
            P_Reflection_Map
            #break
         
         #case (Direct_Lighting_Pass)
            P_Direct_Lighting
            #break
         
         #else 
            // original pigment     
            pgmt
      #end
   } 
#end

//------------------------------------------------------------------------------ 
// Macro: Finish_Wrapper() 
//------------------------------------------------------------------------------ 
// Params: 
//    [fin]            the source finsh that can be converted into a predefined 
//                     render pass finish (based on render type)
//
//    [bHasSubsurface] a boolean flag to allow subsurface finishes to override
//                     finish conversion on a Subsurface_Pass or Reflection_Pass
//------------------------------------------------------------------------------ 

#macro Finish_Wrapper(fin, bHasSubsurface)
   finish {
      #switch (Current_Pass)
         #case (Ambient_Occlusion_Pass)
            F_Ambient_Occlusion
            #break
            
         #case (Depth_Pass)
            F_Depth_Map
            #break
         
         #case (Direct_Lighting_Pass)
            F_Direct_Lighting
            #break
         
         #case (Reflection_Pass)
            #if (bHasSubsurface)
               F_Reflection
            #else
               // original finish   
               fin
            #end
            #break
         
         #case (Subsurface_Pass)
            #if (bHasSubsurface)
               // original finish   
               fin
            #else
               F_Subsurface
            #end
            #break
         #else 
            F_Quick_Pass
      #end
   } 
#end

#end  // #ifndef