/*

crystalGlobeC.pov, "Night Flower"

Samuel Benge, June 2010

render with a square aspect ratio:
 
 +w768 +h768

*/

#declare dispersion_on = true;
#declare focal_blur_on = true;

#include"transforms.inc"
#include"jimsonWeed_POV_geom.inc"

global_settings{
 max_trace_level 20
 assumed_gamma 2.2
}

#default{ finish{ambient 0} }

camera{ 
 right x*2 up y*2
 location <0,0,-30.001>
 look_at <0,0,0>
 angle 10
 #if(focal_blur_on)
  focal_point -z*.3
  aperture .4
  blur_samples 20
  variance 0
 #end
}

sky_sphere{
 pigment{
  pigment_pattern{planar poly_wave .2}
  pigment_map{
   [-.2 rgb 0]
   [1
    spherical
    scale 2 translate y
    poly_wave 2
    
    // if there was a light_source, the sky's pigment could be oriented to it
    Point_At_Trans(<-1,.75,0>)
    
    pigment_map{
     [-.3 rgb 0]
     [.05 rgb <.3 .1 .5>-.07]
     [.5 rgb <1,.85,.7>*1.5]
    }
   ]
  }
  
 }
}

// the plant
#declare Datura=
union{
 
 object{jimsonWeed_flower_ rotate y*130 rotate -x*42 rotate z*10}
 
 #declare three_leaves=
 union{
  object{jimsonWeed_leaf_ scale .6 translate z*.5 rotate z*10}
  object{jimsonWeed_leaf_ scale .4 translate z*.5+y*.25 rotate -y*80 rotate -z*10}
  object{jimsonWeed_leaf_ scale .4 translate z*.5+y*.25 rotate y*80 rotate z*10}
  rotate<0,180,0>
 }
 
 #declare six_leaves=
 union{
  object{three_leaves translate -z*1 rotate -x*10}
  object{three_leaves scale .9 translate -z*1 rotate y*180  rotate x*20}
 }
 
 #declare V=0;
 #declare R=seed(1003);
 #while(V<7)
  object{
   #if(rand(R)>.5)
    six_leaves
   #else
    three_leaves
   #end
   scale .875+rand(R)*.5
   rotate y*rand(R)*360
   rotate -x*20
   translate<-1+rand(R)*2,-rand(R),-1+rand(R)*2>*3
  }
  #declare V=V+1;
 #end
 
}

// the entire object
union{
 
 // the crystal globe
 sphere{0,2}
 
 // the plant
 object{Datura scale .2 }
 
 // the ground
 #declare hf=
 height_field{
  function 512,512{
   pigment{
    crackle form<-1,.5,.5>
    scale .15
    translate z*40
   }
  }
  smooth
  translate-(x+z)/2
  scale<4,.35,4>
  translate -y*1.0
 }
 intersection{
  sphere{0,1.8}
  object{hf }
  object{hf translate -y*.01 inverse}
  rotate -x*20
 }
 
 // the constellation, 'Aquila The Eagle'
 // the star positions were taken from an image
 #declare Aquila=
 array[10]{
  <88,91,10>,
  <75,118,4>,
  <29,197,5>,
  <81,181,5>,
  <209,247,5>,
  <220,257,4>,
  <157,157,5>,
  <102,71,7>,
  <213,38,5>,
  <230,24,4>
 }
 union{
  #declare V=0;
  #while(V<dimension_size(Aquila,1))
   sphere{<Aquila[V].x,Aquila[V].y,0>,Aquila[V].z }
   #declare V=V+1;
  #end
  scale<1,-1,1>/230
  translate<-.95,1.1,.5>
 }
 
 pigment{rgbt 1}
 
 finish{
  reflection{0,1 fresnel}
  conserve_energy
 }
 
 interior{
  ior 1.6
  #if(dispersion_on)
   dispersion 1.033
   dispersion_samples 7
  #end
 }
 
}
