  #include "colors.inc"    // The include files contain
  #include "stones.inc"    // pre-defined scene elements
  #include "textures.inc"    // pre-defined scene elements
  #include "shapes.inc"
  #include "glass.inc"
  #include "metals.inc"
  #include "woods.inc" 
  #include "txttree.inc"
  #include "maketree.pov" 
 //global_settings { assumed_gamma 1 }   
 
 //media_attenuation on 
 
 #declare Concrete = texture {pigment {rgb .95} normal {granite .2 scale .03}}
   
#macro halton( index, base )
#local out = 0.0;
#local fraction = 1.0 / base;
#local i = index;
#while( i > 0 )
#local remainder = mod( i, base );
#local out = out + (fraction * remainder);
#local i = int(i / base);
#local fraction = fraction / base;
#end

out
#end

#macro halton2D( n )
#local baseX = 2;
#local baseZ = 3;
< halton( n, baseX ), 0, halton( n, baseZ ) >
#end


  
  background{rgb 0}
  camera {


    location <50, 150,-300>
    //location <-1100,730,4900>
    look_at <0, 0,5000 >
    angle 50
 
  }                          
          
//-------------------------------------------------------------------
// ciel


light_source { <4000,2000,10000>, rgb <4,4,4>
    //spotlight
    //radius 15
    //falloff 180
    //tightness 10
    //area_light <5, 0, 0>, <0, 0, 5>, 5, 5
    //adaptive 1
    //jitter
 }
//sphere { 0,1.2 pigment { rgb 0 } finish { reflection 1 } }  

declare clouds = plane{<0,1,0>,0.16 hollow  // 
      
        texture{ pigment {color rgb<0.1,0.35,0.8>*0.8 transmit 0.9}
                          finish {ambient 1  diffuse 1}
                          
               } // end texture 1

        texture{ pigment{ bozo turbulence 0.75
                          octaves 6  omega 0.7 lambda 2 
                          color_map {
                          [0.0  color rgb <0.95, 0.95, 0.95> ]
                          [0.05  color rgb <1, 1, 1>*1.25 ]
                          [0.15 color rgb <0.85, 0.85, 0.85> ]
                          [0.55 color rgbt <1, 1, 1, 1>*1 ]
                          [1.0 color rgbt <1, 1, 1, 1>*1 ]
                          } // end color_map 
                         translate< 3, 0,-1>
                         scale <0.3, 0.4, 0.2>*3
                        } // end pigment
                 finish {ambient 1 diffuse 1}
               } // end texture 2

      scale 10000} 

clouds


//declare background_sky

sky_sphere {

pigment {gradient y color_map { // horizon sky
           [  0/269 color rgbt <120/255, 79/255, 51/255>]
[  1/269 color rgbt <141/255, 83/255, 46/255>]
[  2/269 color rgbt <177/255, 86/255, 41/255>]
[  3/269 color rgbt <235/255,128/255, 72/255>]
[  5/269 color rgbt <255/255,159/255, 72/255>]
[  8/269 color rgbt <255/255,203/255, 94/255>] // New
[ 10/269 color rgbt <255/255,218/255,112/255>]
[ 13/269 color rgbt <255/255,233/255,148/255>] // New
[ 15/269 color rgbt <251/255,241/255,172/255>] // New
[ 20/269 color rgbt <255/255,246/255,203/255>]
[ 30/269 color rgbt <255/255,240/255,219/255>]
[ 40/269 color rgbt <236/255,223/255,214/255>]
[ 50/269 color rgbt <205/255,204/255,212/255>]
[ 55/269 color rgbt <185/255,190/255,209/255>] // New
[ 60/269 color rgbt <166/255,176/255,201/255>]
[ 65/269 color rgbt <149/255,163/255,190/255>] // New
[ 70/269 color rgbt <129/255,149/255,182/255>]
[ 80/269 color rgbt <103/255,127/255,171/255>]
[ 90/269 color rgbt < 79/255,110/255,154/255>]
[100/269 color rgbt < 66/255, 97/255,143/255>]
[110/269 color rgbt < 52/255, 84/255,131/255>]
[120/269 color rgbt < 47/255, 75/255,122/255>]
[140/269 color rgbt < 37/255, 60/255,102/255>]
[160/269 color rgbt < 32/255, 51/255, 84/255>]
[180/269 color rgbt < 27/255, 42/255, 71/255>]
[200/269 color rgbt < 25/255, 36/255, 58/255>]
[220/269 color rgbt < 22/255, 31/255, 48/255>]
[240/269 color rgbt < 18/255, 27/255, 42/255>]
[260/269 color rgbt < 15/255, 21/255, 33/255>]
[269/269 color rgbt < 15/255, 21/255, 33/255>]
} 
}

}        


//background_sky

declare media_sky =  cylinder // transparent sphere containing media
 //{ 0,1 pigment { rgbt 1 } hollow
 { <0,0,0>,<1,0,0>,1 pigment { rgbt 1 } hollow

   interior
   { media
     { emission 1/10000
       density
       { cylindrical density_map
         { //[0 rgb <1,0.6,0>]
           //[0.3 rgb <1,0.8,0>]
           //[0.7 rgb 1]
           //[1 rgb 1]
           [  0/269 color rgbt <120/255, 79/255, 51/255>]
[  1/269 color rgbt <141/255, 83/255, 46/255>]
[  2/269 color rgbt <177/255, 86/255, 41/255>]
[  3/269 color rgbt <235/255,128/255, 72/255>]
[  5/269 color rgbt <255/255,159/255, 72/255>]
[  8/269 color rgbt <255/255,203/255, 94/255>] // New
[ 10/269 color rgbt <255/255,218/255,112/255>]
[ 13/269 color rgbt <255/255,233/255,148/255>] // New
[ 15/269 color rgbt <251/255,241/255,172/255>] // New
[ 20/269 color rgbt <255/255,246/255,203/255>]
[ 30/269 color rgbt <255/255,240/255,219/255>]
[ 40/269 color rgbt <236/255,223/255,214/255>]
[ 50/269 color rgbt <205/255,204/255,212/255>]
[ 55/269 color rgbt <185/255,190/255,209/255>] // New
[ 60/269 color rgbt <166/255,176/255,201/255>]
[ 65/269 color rgbt <149/255,163/255,190/255>] // New
[ 70/269 color rgbt <129/255,149/255,182/255>]
[ 80/269 color rgbt <103/255,127/255,171/255>]
[ 90/269 color rgbt < 79/255,110/255,154/255>]
[100/269 color rgbt < 66/255, 97/255,143/255>]
[110/269 color rgbt < 52/255, 84/255,131/255>]
[120/269 color rgbt < 47/255, 75/255,122/255>]
[140/269 color rgbt < 37/255, 60/255,102/255>]
[160/269 color rgbt < 32/255, 51/255, 84/255>]
[180/269 color rgbt < 27/255, 42/255, 71/255>]
[200/269 color rgbt < 25/255, 36/255, 58/255>]
[220/269 color rgbt < 22/255, 31/255, 48/255>]
[240/269 color rgbt < 18/255, 27/255, 42/255>]
[260/269 color rgbt < 15/255, 21/255, 33/255>]
[269/269 color rgbt < 15/255, 21/255, 33/255>]
} 
}
           
         }
       }
   scale 10000
   rotate -z*90
   translate <0,10000,0>
   
}     

//media_sky        


declare world_sphere = sphere {
    0, 1
    pigment {  gradient y
     color_map { 
                //[1 rgb 1]
           [  0/269 color rgbt <120/255, 79/255, 51/255>]
[  1/269 color rgbt <141/255, 83/255, 46/255>]
[  2/269 color rgbt <177/255, 86/255, 41/255>]
[  3/269 color rgbt <235/255,128/255, 72/255>]
[  5/269 color rgbt <255/255,159/255, 72/255>]
[  8/269 color rgbt <255/255,203/255, 94/255>] // New
[ 10/269 color rgbt <255/255,218/255,112/255>]
[ 13/269 color rgbt <255/255,233/255,148/255>] // New
[ 15/269 color rgbt <251/255,241/255,172/255>] // New
[ 20/269 color rgbt <255/255,246/255,203/255>]
[ 30/269 color rgbt <255/255,240/255,219/255>]
[ 40/269 color rgbt <236/255,223/255,214/255>]
[ 50/269 color rgbt <205/255,204/255,212/255>]
[ 55/269 color rgbt <185/255,190/255,209/255>] // New
[ 60/269 color rgbt <166/255,176/255,201/255>]
[ 65/269 color rgbt <149/255,163/255,190/255>] // New
[ 70/269 color rgbt <129/255,149/255,182/255>]
[ 80/269 color rgbt <103/255,127/255,171/255>]
[ 90/269 color rgbt < 79/255,110/255,154/255>]
[100/269 color rgbt < 66/255, 97/255,143/255>]
[110/269 color rgbt < 52/255, 84/255,131/255>]
[120/269 color rgbt < 47/255, 75/255,122/255>]
[140/269 color rgbt < 37/255, 60/255,102/255>]
[160/269 color rgbt < 32/255, 51/255, 84/255>]
[180/269 color rgbt < 27/255, 42/255, 71/255>]
[200/269 color rgbt < 25/255, 36/255, 58/255>]
[220/269 color rgbt < 22/255, 31/255, 48/255>]
[240/269 color rgbt < 18/255, 27/255, 42/255>]
[260/269 color rgbt < 15/255, 21/255, 33/255>]
[269/269 color rgbt < 15/255, 21/255, 33/255>]
}   
     } 
    hollow
    //inverse
    scale 1000000
   translate <0,0,500000>
  }

//world_sphere

 fog {
    distance 4000
    color rgbf <.7,.7,.7,.4> 
    fog_type 2
    fog_offset 10
    fog_alt 10
    turbulence 0.8
    turb_depth 0.8

  }



 
// ------------------------------------------------------------------
// A white marble floor
plane
{
  y, -2
  texture
  {      
  normal {
      bumps 1/2
      scale 1/6
    }

//    pigment
//    {
//       White
//      }
//    }
//    finish {ambient 0.2 reflection 0}
pigment {
  bozo 
  turbulence 0.92
  //crackle
  //metric 24
  //offset 0.171
  scale 5
     color_map {
        //[0.05  color Orange]
        //[0.2  color Brown]
        //[0.3  color Black]
        [0.3  color Orange]
        [0.7  color Brown]
        [0.9  color Black]
      }
}

  } 
  
  
 }   
 
 



  
#declare IndexA = 0;
#while(IndexA <= 1)
  

  prism {
    linear_sweep
    linear_spline
    0, 
    10000, 
    12,
    <0.5,0>, <0.5,0.5>, <2.25,1.25>, <2.25,3.5>, <1.6, 4>, <1.65,5.5>, 
    <3.35,5.5>, <3.4,4> , <2.75,3.5> , <2.75,1.25> , <4.5,0.5> , <4.5,0>
    
    pigment { Brown } 
    rotate -x*90
    translate 10000*z
    translate -1.4*x
    translate x*IndexA*67
  }           
  
  
    prism {
    linear_sweep
    linear_spline
    0, 
    10000, 
    12, 
    <0.5,0>, <0.5,0.5>, <2.25,1.25>, <2.25,3.25>, <1.6, 3.75>, <1.65,5.25>, 
    <3.35,5.25>, <3.4,3.75> , <2.75,3.25> , <2.75,1.25> , <4.5,0.5> , <4.5,0>
    
    pigment { Brown } 
    rotate -x*90
    translate 10000*z
    translate -32.4*x
    translate x*IndexA*67
  }
  
  
  

        #declare IndexB = 1;
        #while(IndexB <= 500)
 
                box{ <0,-2,0>,<8,0,50>

                texture {T_Wood1}
                rotate y*90     
                translate -40*x
                translate x*IndexA*70
                
                translate 20*z*IndexB


                   } 
      
       #declare IndexB = IndexB + 1;
       
       #end  

 #declare IndexA = IndexA + 1;

 #end

//potences electrification

#declare IndexC = 1;
#while(IndexC <= 50)

union {

        union {
         
                box{ <-1,0,0>,<0,3,120>
        
                        pigment {P_Chrome2}
                        rotate z*90
                        rotate x*90
                        translate 10*z
                        translate 118*y
                        translate -45*x
                
                           
                   } 
                           
        
                box{ <-1,0,0>,<0,5,120>
        
                        pigment {P_Chrome2}
                        //rotate z*90
                        rotate x*90
                        translate 10*z
                        translate 118*y
                        translate -46.25*x
                        
                   } 
                   
                box{ <-1,0,0>,<0,3,120>
                
                        pigment {P_Chrome2}
                        rotate z*90
                        rotate x*90
                        translate 15*z
                        translate 118*y
                        translate -45*x
                
                        
                   }
                                    
                 box{ <-1,0,0>,<0,1,25>
                
                        pigment {P_Chrome2}
                        //rotate z*90
                        //rotate x*200 
                        rotate -y*90
                        rotate -z*155
                        translate 11*z
                        translate 98*y
                        translate -45*x
                
                        
                    }
                    
                    
                   box{ <-1,0,0>,<0,0.5,25>
                
                        pigment {P_Chrome2}
                        //rotate z*90
                        //rotate x*200 
                        rotate y*90
                        //rotate -z*50
                        translate 13*z
                        translate 94*y
                        translate -45*x
                
                        
                    }
                      
                  
                   box{ <-1,0,0>,<0,0.5,25>
                
                        pigment {P_Chrome2}
                        //rotate z*90
                        //rotate x*200 
                        rotate y*90
                        rotate -z*5
                        translate 13*z
                        translate 94*y
                        translate -19.75*x
                
                        
                    } 
                    
                  
                  box{ <-1,0,0>,<0,0.5,24>
                
                        pigment {P_Chrome2}
                        //rotate z*90
                        //rotate x*200 
                        rotate y*90
                        rotate -z*90
                        translate 13*z
                        translate 108*y
                        translate 5*x
                
                        
                    }
                                    
                translate -15*x                  
              
              }
       
       
        box{ <-1,0,-1>,<0,2,154>

                pigment {P_Chrome2}
                //rotate z*90
                rotate y*90
                translate 10*z
                translate 107.5*y
                translate -61.25*x
        
           }
                   
union {
 
        box{ <-1,0,0>,<0,3,120>

                pigment {P_Chrome2}
                rotate z*90
                rotate x*90
                translate 10*z
                translate 118*y
                translate -45*x

        
           } 
                   

        box{ <-1,0,0>,<0,5,120>

                pigment {P_Chrome2}
                //rotate z*90
                rotate x*90
                translate 10*z
                translate 118*y
                translate -46.25*x
        
           } 
                   
        box{ <-1,0,0>,<0,3,120>

                pigment {P_Chrome2}
                rotate z*90
                rotate x*90
                translate 15*z
                translate 118*y
                translate -45*x
        
        
           } 
                   
                    
        box{ <-1,0,0>,<0,1,25>

                pigment {P_Chrome2}
                //rotate z*90
                //rotate x*200 
                rotate -y*90
                rotate -z*25
                translate 11*z
                translate 98*y
                translate -45*x

        
           } 

        box{ <-1,0,0>,<0,0.5,25>

                pigment {P_Chrome2}
                //rotate z*90
                //rotate x*200 
                rotate -y*90
                //rotate -z*25
                translate 15*z
                translate 94*y
                translate -45*x

        
           }
           
       
       box{ <-1,0,0>,<0,0.5,25>
                
                pigment {P_Chrome2}
                //rotate z*90
                //rotate x*200 
                rotate y*90
                rotate z*185
                translate 13*z
                translate 94*y
                translate -70*x
                
                        
          } 
                    
                  
       box{ <-1,0,0>,<0,0.5,24>
                
               pigment {P_Chrome2}
               //rotate z*90
               //rotate x*200 
               rotate y*90
               rotate -z*90
               translate 13*z
               translate 108*y
               translate -94.75*x
                
                        
          }                    
                    
        translate 140*x                  

       
    }

        translate 400*IndexC*z - 400*z
        
    finish {
    phong 0.9
    phong_size 60
    metallic
  }
       
}   

#declare IndexC = IndexC + 1;

#end 
          
#declare IndexE = 0;
#while(IndexE <= 50)
          
          
#declare IndexD = 0;
#while(IndexD <= 5)

superellipsoid{ <1,0.5>

  texture{ pigment{color rgb<1,0.85,0.1>}
           finish { phong 1}
         } // end of texture
  scale <2,2,0.4>
  rotate<0,90,0>
  translate 14*z
  translate 94*y
  translate -40.25*x
  translate x*IndexD 
  translate 400*IndexE*z
} 


superellipsoid{ <1,0.5>

  texture{ pigment{color rgb<1,0.85,0.1>}
           finish { phong 1}
         } // end of texture
  scale <2,2,0.4>
  rotate<0,90,0>
  translate 14*z
  translate 94*y
  translate 70.75*x
  translate x*IndexD 
  translate 400*IndexE*z
}   


#declare IndexD = IndexD + 1;

#end 

#declare IndexE = IndexE + 1;

#end 

///////////////////////////////////////////////////TREE SECTION/////////////////////////////////////////////////


                                       
                                       declare dofile=true;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree4.inc" // file name for tree
#declare fvname="gtfoliage4.inc" // file name for tree foliage
#declare ffname="gtleaf4.inc" // file name for individual leaf (mesh)
#declare txtTree=texture{txtTree_5} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=211;      // random seed
//#declare rsd=212;      // random seed
//#declare rsd=213;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=4;      // recursion level
#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
#declare nb=4;          // max number of branches per level
#declare dotop=false;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=7;        // initial branch length
#declare rb0=1;         // initial branch radius
#declare ab0=95;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=1.6;       // branch length decrease ratio (1=constant length)
#declare qrb=0.6;       // branch radius decrease ratio (1=constant radius)
#declare qab=0.6;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=0.8; // probability of branch apparition 
#declare jb=0.1;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.4;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.1;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<-75,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<0,1,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=1;       // force of push
#declare aboveground=0.5; // constrains the branches above this level 
#declare belowsky=1000;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=1;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=0;      // number of main roots;
#declare vroot=<1,-0.1,0>; // initial direction of root 
#declare yroot=<-75,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=1;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=180;       // max z angle for leaf
#declare alx0=90;      // start x angle for leaf
#declare stdalx=60;     // std x angle for leaf
#declare stdlsize=1;  // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_3} // Leaf texture
#declare lsize=0.4;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=3;          // leaf length
#declare wl=0.6;          // leaf width 
#declare fl=0.1;        // depth of leaf fold
#declare lpow=0.3;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=5;      // number of lobes (individual leaves)
#declare alobes=288;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=0;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

//=========================================
// Make the tree now !
//----------------------------------------- 

#declare Rnd_1 = seed (1153);
#declare NrX = 0;     // start
#declare EndNrX = 50;   // end


#while (NrX < EndNrX+1)

object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
        scale 1
        //translate<int(100*NrX*rand(Rnd_1)),0,int(100*NrX*rand(Rnd_1))>
         translate halton2D(NrX)*1000
         translate <300,0,0>
}

#declare NrX = NrX + 1;  //next Nr
#end // ------------ end of loop ---


//#declare num_cylinders = 100;
//#declare i = 0;
//#while( i < num_cylinders )
// object { cyl  translate halton2D( i ) * some_scale_value }
// #declare i = i + 1;
//#end




//background{color rgb <0.8,0.9,1>}
//plane{y,0 pigment{rgb<1,0.7,0.3>}}

//tests for tree texture, leaf and leaf textures
//cylinder{0,y*4,1 texture{txtTree} scale 10}
//#declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)  texture{txtLeaf}} 
//object{Leaf scale 15 rotate y*70 translate y*40 texture{txtLeaf} }  
            
            

 //centrale electrique //
 
 
 #declare Dome = superellipsoid { <0.7, 0.7>
 
 
   texture{Concrete
           finish { phong 1}
         } // end of texture
   scale 100
  
   }


#declare Confinement = box { <0,0,0> , <8,2,5> 

   texture{Concrete
           finish { phong 1}
         } // end of texture
   scale 100
  
   }




object{Dome
translate<-1800,180,5100>
}
object{Dome
translate<-1800,180,5400>
}
object{Dome
translate<-1400,180,5100>
}
object{Dome
translate<-1400,180,5400>
}
object{Confinement
translate <-2000,0, 5000>}
                          
                          
cylinder {
  <0,0,0>, <0,1,0>,0.03
 pigment {boxed color_map{[0.5 Red][0.5 White]}
    rotate x*90
    frequency 6
  }
  scale 700
  translate<-1000,0,5000>
  finish { phong 1 phong_size 60 }
}


#declare catwalk = cylinder { <0,0,0> , <0,0.008,0>, 0.04
pigment {P_Chrome2}
scale 700
} 

#declare NrX2 = 150;

#while (NrX2 < 700)

object{catwalk
finish { phong 1 }
translate<-1000,NrX2,5000>}


#declare NrX2 = NrX2 + 150;

#end


 #declare cooling_tower = sor {
  8,
  <0.52, 0>
  <0.46, 0.2>
  <0.41, 0.4>
  <0.375, 0.5>  
  <0.35, 0.6>
  <0.358, 0.7>
  <0.37, 0.8>
  <0.382, 1>
  open
  sturm
  scale <400,800,400>
 }
 
object{cooling_tower
   texture{Concrete
           finish { phong 1}
         } 
translate<-600,-200,5000>}
                         
object{cooling_tower
   texture{Concrete
           finish { phong 1}
         } 
translate<-600,-200,6000>}




// Chimney smoke

//-------------------------------------------------------
//  Scattering media - streuendes Medium
//  steam + Smoke - Dampf + Rauch !!!!
// A transparent sphere containing media
//declare smoke3 = sphere{ <0,0,0>, 1  // increased from 1 to 1.5, because of the turbulent pattern !!!
//        pigment { rgbt 1 } 
//        hollow  
 #declare Smoke1 =
sphere { <0,0,0>, 1
  hollow
  pigment {rgbf 1} transmit 1
  finish {ambient 0 diffuse 0}
 interior{ //---------------------
    media{ emission 1/500
           scattering{ 1, // Type 1 = isotropic scattering, 2 = Mie haze, 3 = Mie murky 
                          // Type 4 = Rayleigh scattering,  5 = Henyey-Greenstein scattering 
                        1*3.00/500   // color of scattering haze  
                       extinction  1  //  // 0 ~ 1 extinction 
                       // how fast the scattering media absorbs light 
                       // useful i.e. when the media absorbs too much light
                    // eccentricity i.e. -0.6 ~ +0.6 (if type>1 )
           } // end scattering   

           density{ spherical // or: boxed
                    turbulence 0.85
                    color_map {
                    [0.00 rgb 0] // density at the border of the media
                    [0.05 rgb 0]
                    [0.1 rgb 0.1]
                    [0.2 rgb 0]
                    [0.4 rgb 0]
                    [1 rgb 0] // densitiy at the center of the media
                               } // end color_map
           } // end of density

           samples 10     // 3,3 for adaptive sampling
           
           confidence 0.9  //  
     } // end of media ----------------------------------------------------------------------
  } // ------------------ end of interior
 scale 500
} //------------------ end of "Rauch" 

object{Smoke1
  translate<-1000,710,5000>
} 