// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======
// Copyright 2010 by Tor Olav Kristensen
// Email: t o r . o l a v . k [ a t ] g m a i l . c o m
// http://subcube.com
// File: NURBS_28_.inc (SDL include file for POV-Ray v3.5)
// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Size1A(Array1A)

  dimension_size(Array1A, 1)

#end // macro Size1A



#macro Size2A(Array2A)

  <
    dimension_size(Array2A, 1),
    dimension_size(Array2A, 2)
  >

#end // macro Size2A



#macro Size3A(Array3A)

  <
    dimension_size(Array3A, 1),
    dimension_size(Array3A, 2),
    dimension_size(Array3A, 3)
  >

#end // macro Size3A



#macro Size4A(Array4A)

  <
    dimension_size(Array4A, 1),
    dimension_size(Array4A, 2),
    dimension_size(Array4A, 3),
    dimension_size(Array4A, 4)
  >

#end // macro Size4A


/*
#macro Array1A(SizeU)

  array[SizeU]

#end // macro Array1A



#macro Array2A(SizeUV)

  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;

  array[SizeU][SizeV]

#end // macro Array2A



#macro Array3A(SizeUVW)

  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;

  array[SizeU][SizeV][SizeW]

#end // macro Array3A



#macro Array4A(SizeUVWT)

  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;

  array[SizeU][SizeV][SizeW][SizeT]

#end // macro Array4A
*/

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro UniformKnotVectorMinMax(Open, Order, NrOfPoints, MinS, MaxS)

  #local Nil = 1E-9;
  #local Size = Order + NrOfPoints;
  #local Knots = array[Size];
  #local dS = (MaxS + Nil - MinS)/(NrOfPoints - Order + 1);
  #local SS = (1 - Order)*dS + MinS;
  #if (Open)
    #local KnotFn = function(_i) { min(max(MinS, SS + _i*dS), MaxS + Nil) }
  #else
    #local KnotFn = function(_i) { SS + _i*dS }
  #end // if
  #local Cnt = 0;
  #while (Cnt < Size)
    #local Knots[Cnt] = KnotFn(Cnt);
    #local Cnt = Cnt + 1;
  #end // while

  Knots

#end // macro UniformKnotVectorMinMax



#macro UniformKnotVector(Open, Order, NrOfPoints)

  #local MinS = 0;
  #local MaxS = 1;

  UniformKnotVectorMinMax(Open, Order, NrOfPoints, MinS, MaxS)

#end // macro UniformKnotVector



#macro CircleKnotVectorMinMax(NrOfPointsOnCircle, MinS, MaxS)

  #local Nil = 1E-9;
  #local Size = 2*(NrOfPointsOnCircle + 1); ///
  #local Knots = array[Size];
  #local dS = (MaxS + Nil - MinS)/(NrOfPointsOnCircle - 1);
  #local Knots[0] = MinS;
  #local Cnt = 1;
  #while (Cnt < Size - 1)
    #local Knots[Cnt] = MinS + div(Cnt - 1, 2)*dS;
    #local Cnt = Cnt + 1;
  #end // while
  #local Knots[Size-1] = MaxS + Nil;

  Knots

#end // macro CircleKnotVectorMinMax



#macro CircleKnotVector(NrOfPointsOnCircle)

  #local MinS = 0;
  #local MaxS = 1;

  CircleKnotVectorMinMax(NrOfPointsOnCircle, MinS, MaxS)

#end // macro CircleKnotVector

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

// http://en.wikipedia.org/wiki/NURBS

//  Cox-deBoor recursion formula

#macro Cox_deBoor(Order, Knots, K)

  #local SA = Knots[K];
  #local SB = Knots[K+1];
  #local SC = Knots[K+Order];
  #local SD = Knots[K+Order-1];
  #local d1 = SD - SA;
  #local d2 = SC - SB;

  #if (Order > 1)
    #if (d1 = 0)
      #if (d2 = 0)
        0
      #else
        #if (SC = 0)
          -S
        #else
          (SC - S)
        #end // if
        #if (d2 != 1)
          /d2
        #end // if
        *Cox_deBoor(Order - 1, Knots, K + 1)
      #end // if
    #else
      #if (d2 = 0)
        #if (SA = 0)
          S
        #else
          (S - SA)
        #end // if
        #if (d1 != 1)
          /d1
        #end // if
        *Cox_deBoor(Order - 1, Knots, K)
      #else
        (
          #if (SA = 0)
            S
          #else
            (S - SA)
          #end // if
          #if (d1 != 1)
            /d1
          #end // if
          *Cox_deBoor(Order - 1, Knots, K)
          #if (SC = 0)
            -S
          #else
            +(SC - S)
          #end // if
          #if (d2 != 1)
            /d2
          #end // if
          *Cox_deBoor(Order - 1, Knots, K + 1)
        )
      #end // if
    #end // if
  #else
    #if (SA = 0)
      #if (SB = 0)
        select(S, 0, 1, 0) // or 0 ?
      #else
        select(S, 0, select(S - SB, 1, 0))
      #end // if
    #else
      #if (SB = 0)
        select(S - SA, 0, select(S, 1, 0))
      #else
        #if (SA = SB)
          select(S - SA, 0, 1, 0) // or 0 ?
        #else
          select(S - SA, 0, select(S - SB, 1, 0))
        #end // if
      #end // if
    #end // if
  #end // if

#end // macro Cox_deBoor


// http://en.wikipedia.org/wiki/B-spline

/*
#macro Cox_deBoor(Order, Knots, K)

  #local SA = Knots[K];
  #local SB = Knots[K+1];
  #local SC = Knots[K+Order];
  #local SD = Knots[K+Order-1];
  #local d1 = SD - SA;
  #local d2 = SC - SB;

  #if (Order > 1)
    (
      0
      #if (d1 != 0)
        +(S - SA)/d1*Cox_deBoor(Order - 1, Knots, K)
      #end // if
      #if (d2 != 0)
        +(SC - S)/d2*Cox_deBoor(Order - 1, Knots, K + 1)
      #end // if
    )
  #else
    select(S - SA, 0, select(S - SB, 1, 0)) // or select(SA - S, select(S - SB, 1, 0), 0) ?
  #end // if

#end // macro Cox_deBoor
*/


#macro BlendFunction(Order, Knots, K)

  function(S) { Cox_deBoor(Order, Knots, K) }

#end // macro BlendFunction



#macro BlendFunctions(Nr, Order, Knots)

  #local BlendFns = array[Nr];
  #local I = 0;
  #while (I < Nr)
    #local BlendFns[I] = BlendFunction(Order, Knots, I)
    #local I = I + 1;
  #end // while

  BlendFns

#end // macro BlendFunctions

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro NURBS_Function1A(OrderU, KnotsU, Values1A, Weights1A)

  #local SizeU = Size1A(Values1A);
  #local BlendU_Fns = BlendFunctions(SizeU, OrderU, KnotsU);

  #local NFn =
    function(t_) {
      0
      #local I = 0;
      #while (I < SizeU)
        #local C = Weights1A[I]*Values1A[I];
        #if (C != 0)
          +BlendU_Fns[I](t_)
          #if (C != 1)
            *C
          #end // if
        #end // if
        #local I = I + 1;
      #end // while
    }

  #local Rational = false;
  #local I = 0;
  #while (!Rational & I < SizeU)
    #local Rational = (Weights1A[I] != 1);
    #local I = I + 1;
  #end // while

  #if (Rational)
    #local DFn =
      function(t_) {
        0
        #local I = 0;
        #while (I < SizeU)
          #local C = Weights1A[I];
          #if (C != 0)
            +BlendU_Fns[I](t_)
            #if (C != 1)
              *C
            #end // if
          #end // if
          #local I = I + 1;
        #end // while
      }
  #end // if  

  #if (Rational)
    function(t_) { NFn(t_)/DFn(t_) }
  #else
    function(t_) { NFn(t_) }
  #end // if  

#end // macro NURBS_Function1A



#macro NURBS_Function2A(OrderUV, KnotsU, KnotsV, Values2A, Weights2A)

  #local OrderU = OrderUV.u;
  #local OrderV = OrderUV.v;
  #local SizeUV = Size2A(Values2A);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local BlendU_Fns = BlendFunctions(SizeU, OrderU, KnotsU);
  #local BlendV_Fns = BlendFunctions(SizeV, OrderV, KnotsV);

  #local NFn =
    function(u, v) {
      0
      #local I = 0;
      #while (I < SizeU)
        +BlendU_Fns[I](u)*
        (
          0
          #local J = 0;
          #while (J < SizeV)
            #local C = Weights2A[I][J]*Values2A[I][J];
            #if (C != 0)
              +BlendV_Fns[J](v)
              #if (C != 1)
                *C
              #end // if
            #end // if
            #local J = J + 1;
          #end // while
        )
        #local I = I + 1;
      #end // while
    }

  #local Rational = false;
  #local I = 0;
  #while (!Rational & I < SizeU)
      #local J = 0;
      #while (!Rational & J < SizeV)
        #local Rational = (Weights2A[I][J] != 1);
        #local J = J + 1;
      #end // while
    #local I = I + 1;
  #end // while

  #if (Rational)
    #local DFn =
      function(u, v) {
        0
        #local I = 0;
        #while (I < SizeU)
          +BlendU_Fns[I](u)*
          (
            0
            #local J = 0;
            #while (J < SizeV)
              #local C = Weights2A[I][J];
              #if (C != 0)
                +BlendV_Fns[J](v)
                #if (C != 1)
                  *C
                #end // if
              #end // if
              #local J = J + 1;
            #end // while
          )
          #local I = I + 1;
        #end // while
      }
  #end // if  

  #if (Rational)
    function(u, v) { NFn(u, v)/DFn(u, v) }
  #else
    function(u, v) { NFn(u, v) }
  #end // if  

#end // macro NURBS_Function2A



#macro NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Values3A, Weights3A)

  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local SizeUVW = Size3A(Values3A);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local BlendU_Fns = BlendFunctions(SizeU, OrderU, KnotsU);
  #local BlendV_Fns = BlendFunctions(SizeV, OrderV, KnotsV);
  #local BlendW_Fns = BlendFunctions(SizeW, OrderW, KnotsW);

  #local NFn =
    function {
      0
      #local I = 0;
      #while (I < SizeU)
        +BlendU_Fns[I](x)*
        (
          0
          #local J = 0;
          #while (J < SizeV)
            +BlendV_Fns[J](y)*
            (
              0
              #local K = 0;
              #while (K < SizeW)
                #local C = Weights3A[I][J][K]*Values3A[I][J][K];
                #if (C != 0)
                  +BlendW_Fns[K](z)
                  #if (C != 1)
                    *C
                  #end // if
                #end // if
                #local K = K + 1;
              #end // while
            )
            #local J = J + 1;
          #end // while
        )
        #local I = I + 1;
      #end // while
    }

  #local Rational = false;
  #local I = 0;
  #while (!Rational & I < SizeU)
    #local J = 0;
    #while (!Rational & J < SizeV)
      #local K = 0;
      #while (!Rational & K < SizeW)
        #local Rational = (Weights3A[I][J][K] != 1);
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  #if (Rational)
    #local DFn =
      function {
        0
        #local I = 0;
        #while (I < SizeU)
          +BlendU_Fns[I](x)*
          (
            0
            #local J = 0;
            #while (J < SizeV)
              +BlendV_Fns[J](y)*
              (
                0
                #local K = 0;
                #while (K < SizeW)
                  #local C = Weights3A[I][J][K];
                  #if (C != 0)
                    +BlendW_Fns[K](z)
                    #if (C != 1)
                      *C
                    #end // if
                  #end // if
                  #local K = K + 1;
                #end // while
              )
              #local J = J + 1;
            #end // while
          )
          #local I = I + 1;
        #end // while
      }
  #end // if

  #if (Rational)
    function { NFn(x, y, z)/DFn(x, y, z) }
  #else
    function { NFn(x, y, z) }
  #end // if

#end // macro NURBS_Function3A



#macro NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Values4A, Weights4A)

  #local OrderU = OrderUVWT.x;
  #local OrderV = OrderUVWT.y;
  #local OrderW = OrderUVWT.z;
  #local OrderT = OrderUVWT.t;
  #local SizeUVWT = Size4A(Values4A);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local BlendU_Fns = BlendFunctions(SizeU, OrderU, KnotsU);
  #local BlendV_Fns = BlendFunctions(SizeV, OrderV, KnotsV);
  #local BlendW_Fns = BlendFunctions(SizeW, OrderW, KnotsW);
  #local BlendT_Fns = BlendFunctions(SizeT, OrderT, KnotsT);

  #local NFn =
    function(x, y, z, t_) {
      0
      #local I = 0;
      #while (I < SizeU)
        +BlendU_Fns[I](x)*
        (
          0
          #local J = 0;
          #while (J < SizeV)
            +BlendV_Fns[J](y)*
            (
              0
              #local K = 0;
              #while (K < SizeW)
                +BlendW_Fns[K](z)*
                (
                  0
                  #local L = 0;
                  #while (L < SizeT)
                    #local C = Weights4A[I][J][K][L]*Values4A[I][J][K][L];
                    #if (C != 0)
                      +BlendT_Fns[L](t_)
                      #if (C != 1)
                        *C
                      #end // if
                    #end // if
                    #local L = L + 1;
                  #end // while
                )
                #local K = K + 1;
              #end // while
            )
            #local J = J + 1;
          #end // while
        )
        #local I = I + 1;
      #end // while
    }

  #local Rational = false;
  #local I = 0;
  #while (!Rational & I < SizeU)
    #local J = 0;
    #while (!Rational & J < SizeV)
      #local K = 0;
      #while (!Rational & K < SizeW)
        #local L = 0;
        #while (!Rational & L < SizeT)
          #local Rational = (Weights4A[I][J][K][L] != 1);
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  #if (Rational)
    #local DFn =
      function(x, y, z, t_) {
        0
        #local I = 0;
        #while (I < SizeU)
          +BlendU_Fns[I](x)*
          (
            0
            #local J = 0;
            #while (J < SizeV)
              +BlendV_Fns[J](y)*
              (
                0
                #local K = 0;
                #while (K < SizeW)
                  +BlendW_Fns[K](z)*
                  (
                    0
                    #local L = 0;
                    #while (L < SizeT)
                      #local C = Weights4A[I][J][K][L];
                      #if (C != 0)
                        +BlendT_Fns[L](t_)
                        #if (C != 1)
                          *C
                        #end // if
                      #end // if
                      #local L = L + 1;
                    #end // while
                  )
                  #local K = K + 1;
                #end // while
              )
              #local J = J + 1;
            #end // while
          )
          #local I = I + 1;
        #end // while
      }
  #end // if

  #if (Rational)
    function(x, y, z, t_) { NFn(x, y, z, t_)/DFn(x, y, z, t_) }
  #else
    function(x, y, z, t_) { NFn(x, y, z, t_) }
  #end // if

#end // macro NURBS_Function4A

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

// 1D -------


#macro SampleFunctions1A1D(xFn, MinU, MaxU, DivU)

  #local dU = (MaxU - MinU)/DivU;
  #local SizeU = DivU + 1;
  #local Points1A1D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local Points1A1D[I] = xFn(U);
    #local I = I + 1;
  #end // while

  Points1A1D

#end // SampleFunctions1A1D



#macro SampleFunctions2A1D(xFn, MinUV, MaxUV, DivUV)

  #local MinU = MinUV.u;
  #local MinV = MinUV.v;
  #local MaxU = MaxUV.u;
  #local MaxV = MaxUV.v;
  #local DivU = DivUV.u;
  #local DivV = DivUV.v;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local Points2A1D = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local Points2A1D[I][J] = xFn(U, V);
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A1D

#end // SampleFunctions2A1D



#macro SampleFunctions3A1D(xFn, MinUVW, MaxUVW, DivUVW)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local Points3A1D = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local Points3A1D[I][J][K] = xFn(U, V, W);
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A1D

#end // SampleFunctions3A1D



#macro SampleFunctions4A1D(xFn, MinUVWT, MaxUVWT, DivUVWT)

  #local MinU = MinUVWT.x;
  #local MinV = MinUVWT.y;
  #local MinW = MinUVWT.z;
  #local MinT = MinUVWT.t;
  #local MaxU = MaxUVWT.x;
  #local MaxV = MaxUVWT.y;
  #local MaxW = MaxUVWT.z;
  #local MaxT = MaxUVWT.t;
  #local DivU = DivUVWT.x;
  #local DivV = DivUVWT.y;
  #local DivW = DivUVWT.z;
  #local DivT = DivUVWT.t;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local dT = (MaxT - MinT)/DivT;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local SizeT = DivT + 1;
  #local Points4A1D = array[SizeU][SizeV][SizeW][SizeT];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local L = 0;
        #while (L < SizeT)
          #local T = MinT + L*dT;
          #local Points4A1D[I][J][K][L] = xFn(U, V, W, T);
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points4A1D

#end // SampleFunctions4A1D


// 2D -------


#macro SampleFunctions1A2D(xFn, yFn, MinU, MaxU, DivU)

  #local dU = (MaxU - MinU)/DivU;
  #local SizeU = DivU + 1;
  #local Points1A2D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local Points1A2D[I] = <xFn(U), yFn(U)>;
    #local I = I + 1;
  #end // while

  Points1A2D

#end // SampleFunctions1A2D



#macro SampleFunctions2A2D(xFn, yFn, MinUV, MaxUV, DivUV)

  #local MinU = MinUV.u;
  #local MinV = MinUV.v;
  #local MaxU = MaxUV.u;
  #local MaxV = MaxUV.v;
  #local DivU = DivUV.u;
  #local DivV = DivUV.v;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local Points2A2D = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local Points2A2D[I][J] = <xFn(U, V), yFn(U, V)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A2D

#end // SampleFunctions2A2D



#macro SampleFunctions3A2D(xFn, yFn, MinUVW, MaxUVW, DivUVW)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local Points3A2D = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local Points3A2D[I][J][K] = <xFn(U, V, W), yFn(U, V, W)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A2D

#end // SampleFunctions3A2D



#macro SampleFunctions4A2D(xFn, yFn, MinUVWT, MaxUVWT, DivUVWT)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MinT = MinUVW.t;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local MaxT = MaxUVW.t;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local DivT = DivUVW.t;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local dT = (MaxT - MinT)/DivT;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local SizeT = DivT + 1;
  #local Points4A2D = array[SizeU][SizeV][SizeW][SizeT];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local L = 0;
        #while (L < SizeT)
          #local T = MinT + L*dT;
          #local Points4A2D[I][J][K][L] = <xFn(U, V, W, T), yFn(U, V, W, T)>;
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points4A2D

#end // SampleFunctions4A2D


// 3D -------


#macro SampleFunctions1A3D(xFn, yFn, zFn, MinU, MaxU, DivU)

  #local dU = (MaxU - MinU)/DivU;
  #local SizeU = DivU + 1;
  #local Points1A3D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local Points1A3D[I] = <xFn(U), yFn(U), zFn(U)>;
    #local I = I + 1;
  #end // while

  Points1A3D

#end // SampleFunctions1A3D



#macro SampleFunctions2A3D(xFn, yFn, zFn, MinUV, MaxUV, DivUV)

  #local MinU = MinUV.u;
  #local MinV = MinUV.v;
  #local MaxU = MaxUV.u;
  #local MaxV = MaxUV.v;
  #local DivU = DivUV.u;
  #local DivV = DivUV.v;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local Points2A3D = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local Points2A3D[I][J] = <xFn(U, V), yFn(U, V), zFn(U, V)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A3D

#end // SampleFunctions2A3D



#macro SampleFunctions3A3D(xFn, yFn, zFn, MinUVW, MaxUVW, DivUVW)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local Points3A3D = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local Points3A3D[I][J][K] = <xFn(U, V, W), yFn(U, V, W), zFn(U, V, W)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D

#end // SampleFunctions3A3D



#macro SampleFunctions4A3D(xFn, yFn, zFn, MinUVWT, MaxUVWT, DivUVWT)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MinT = MinUVW.t;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local MaxT = MaxUVW.t;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local DivT = DivUVW.t;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local dT = (MaxT - MinT)/DivT;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local SizeT = DivT + 1;
  #local Points4A3D = array[SizeU][SizeV][SizeW][SizeT];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local L = 0;
        #while (L < SizeT)
          #local T = MinT + L*dT;
          #local Points4A3D[I][J][K][L] = <xFn(U, V, W, T), yFn(U, V, W, T), zFn(U, V, W, T)>;
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points4A3D

#end // SampleFunctions4A3D


// 4D -------


#macro SampleFunctions1A4D(xFn, yFn, zFn, tFn, MinU, MaxU, DivU)

  #local dU = (MaxU - MinU)/DivU;
  #local SizeU = DivU + 1;
  #local Points1A4D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local Points1A4D[I] = <xFn(U), yFn(U), zFn(U), tFn(U)>;
    #local I = I + 1;
  #end // while

  Points1A4D

#end // SampleFunctions1A4D



#macro SampleFunctions2A4D(xFn, yFn, zFn, tFn, MinUV, MaxUV, DivUV)

  #local MinU = MinUV.u;
  #local MinV = MinUV.v;
  #local MaxU = MaxUV.u;
  #local MaxV = MaxUV.v;
  #local DivU = DivUV.u;
  #local DivV = DivUV.v;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local Points2A4D = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local Points2A4D[I][J] = <xFn(U, V), yFn(U, V), zFn(U, V), tFn(U, V)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A4D

#end // SampleFunctions2A4D



#macro SampleFunctions3A4D(xFn, yFn, zFn, tFn, MinUVW, MaxUVW, DivUVW)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local Points3A4D = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local Points3A4D[I][J][K] = <xFn(U, V, W), yFn(U, V, W), zFn(U, V, W), tFn(U, V, W)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A4D

#end // SampleFunctions3A4D



#macro SampleFunctions4A4D(xFn, yFn, zFn, tFn, MinUVWT, MaxUVWT, DivUVWT)

  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MinT = MinUVW.t;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local MaxT = MaxUVW.t;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local DivT = DivUVW.t;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local dT = (MaxT - MinT)/DivT;
  #local SizeU = DivU + 1;
  #local SizeV = DivV + 1;
  #local SizeW = DivW + 1;
  #local SizeT = DivT + 1;
  #local Points4A4D = array[SizeU][SizeV][SizeW][SizeT];

  #local I = 0;
  #while (I < SizeU)
    #local U = MinU + I*dU;
    #local J = 0;
    #while (J < SizeV)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < SizeW)
        #local W = MinW + K*dW;
        #local L = 0;
        #while (L < SizeT)
          #local T = MinT + L*dT;
          #local Points4A4D[I][J][K][L] = <xFn(U, V, W, T), yFn(U, V, W, T), zFn(U, V, W, T), tFn(U, V, W, T)>;
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points4A4D

#end // SampleFunctions4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro SampleFunctions1A3D_(xFn, yFn, zFn, U_Coords1A)

  #local SizeU = Size1A(U_Coords1A);
  #local Points1A3D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = U_Coords1A[I];
    #local Points1A3D[I] = <xFn(U), yFn(U), zFn(U)>;
    #local I = I + 1;
  #end // while

  Points1A3D

#end // macro SampleFunctions1A3D_



#macro SampleFunctions2A3D_(xFn, yFn, zFn, U_Coords1A, V_Coords1A)

  #local SizeU = Size1A(U_Coords1A);
  #local SizeV = Size1A(V_Coords1A);
  #local Points2A3D = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local U = U_Coords1A[I];
    #local J = 0;
    #while (J < SizeV)
      #local V = V_Coords1A[J];
      #local Points2A3D[I][J] = <xFn(U, V), yFn(U, V), zFn(U, V)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A3D

#end // macro SampleFunctions2A3D_



#macro SampleFunctions3A3D_(xFn, yFn, zFn, U_Coords1A, V_Coords1A, W_Coords1A)

  #local SizeU = Size1A(U_Coords1A);
  #local SizeV = Size1A(V_Coords1A);
  #local SizeW = Size1A(W_Coords1A);
  #local Points3A3D = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local U = U_Coords1A[I];
    #local J = 0;
    #while (J < SizeV)
      #local V = V_Coords1A[J];
      #local K = 0;
      #while (K < SizeW)
        #local W = W_Coords1A[K];
        #local Points3A3D[I][J][K] = <xFn(U, V, W), yFn(U, V, W), zFn(U, V, W)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D

#end // macro SampleFunctions3A3D_


/*
#macro SampleFunctions4A3D_(xFn, yFn, zFn, U_Coords1A, V_Coords1A, W_Coords1A, T_Coords1A, )

  Points4A3D

#end // macro SampleFunctions4A3D_
*/

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Der1U_FunctionLimits1A(Fn, MinU, MaxU)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxU > MinU)
    #local TempFn = function(U, D) { (Fn(U + H + D) - Fn(U - H + D))/H2 }
    function(U) { TempFn(U, select(U - H - MinU, H, 0, 0) - select(U + H - MaxU, 0, 0, H)) }
  #else  
    function(U) { (Fn(U + H) - Fn(U - H))/H2 }
  #end // if

#end // Der1U_FunctionLimits1A



#macro Der1U_FunctionLimits2A(Fn, MinU, MaxU)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxU > MinU)
    #local TempFn = function(U, V, D) { (Fn(U + H + D, V) - Fn(U - H + D, V))/H2 }
    function(U, V) { TempFn(U, V, select(U - H - MinU, H, 0, 0) - select(U + H - MaxU, 0, 0, H)) }
  #else  
    function(U, V) { (Fn(U + H, V) - Fn(U - H, V))/H2 }
  #end // if

#end // Der1U_FunctionLimits2A



#macro Der1V_FunctionLimits2A(Fn, MinV, MaxV)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxV > MinV)
    #local TempFn = function(U, V, D) { (Fn(U, V + H + D) - Fn(U, V - H + D))/H2 }
    function(U, V) { TempFn(U, V, select(V - H - MinV, H, 0, 0) - select(V + H - MaxV, 0, 0, H)) }
  #else  
    function(U, V) { (Fn(U + H, V) - Fn(U - H, V))/H2 }
  #end // if

#end // Der1V_FunctionLimits2A



#macro Der1U_FunctionLimits3A(Fn, MinU, MaxU)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxU > MinU)
    #local TempFn = function(U, V, W, D) { (Fn(U + H + D, V, W) - Fn(U - H + D, V, W))/H2 }
    function(U, V, W) { TempFn(U, V, W, select(U - H - MinU, H, 0, 0) - select(U + H - MaxU, 0, 0, H)) }
  #else  
    function(U, V, W) { (Fn(U + H, V, W) - Fn(U - H, V, W))/H2 }
  #end // if

#end // Der1U_FunctionLimits3A



#macro Der1V_FunctionLimits3A(Fn, MinV, MaxV)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxV > MinV)
    #local TempFn = function(U, V, W, D) { (Fn(U, V + H + D, W) - Fn(U, V - H + D, W))/H2 }
    function(U, V, W) { TempFn(U, V, W, select(V - H - MinV, H, 0, 0) - select(V + H - MaxV, 0, 0, H)) }
  #else  
    function(U, V, W) { (Fn(U, V + H, W) - Fn(U, V - H, W))/H2 }
  #end // if

#end // Der1V_FunctionLimits3A



#macro Der1W_FunctionLimits3A(Fn, MinW, MaxW)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxW > MinW)
    #local TempFn = function(U, V, W, D) { (Fn(U, V, W + H + D) - Fn(U, V, W - H + D))/H2 }
    function(U, V, W) { TempFn(U, V, W, select(W - H - MinW, H, 0, 0) - select(W + H - MaxW, 0, 0, H)) }
  #else  
    function(U, V, W) { (Fn(U, V, W + H) - Fn(U, V, W - H))/H2 }
  #end // if

#end // Der1W_FunctionLimits3A



#macro Der1U_FunctionLimits4A(Fn, MinU, MaxU)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxU > MinU)
    #local TempFn = function(U, V, W, T, D) { (Fn(U + H + D, V, W, T) - Fn(U - H + D, V, W, T))/H2 }
    function(U, V, W, T) { TempFn(U, V, W, T, select(U - H - MinU, H, 0, 0) - select(U + H - MaxU, 0, 0, H)) }
  #else  
    function(U, V, W, T) { (Fn(U + H, V, W, T) - Fn(U - H, V, W, T))/H2 }
  #end // if

#end // Der1U_FunctionLimits4A



#macro Der1V_FunctionLimits4A(Fn, MinV, MaxV)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxV > MinV)
    #local TempFn = function(U, V, W, T, D) { (Fn(U, V + H + D, W, T) - Fn(U, V - H + D, W, T))/H2 }
    function(U, V, W, T) { TempFn(U, V, W, T, select(V - H - MinV, H, 0, 0) - select(V + H - MaxV, 0, 0, H)) }
  #else  
    function(U, V, W, T) { (Fn(U, V + H, W, T) - Fn(U, V - H, W, T))/H2 }
  #end // if

#end // Der1V_FunctionLimits4A



#macro Der1W_FunctionLimits4A(Fn, MinW, MaxW)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxW > MinW)
    #local TempFn = function(U, V, W, T, D) { (Fn(U, V, W + H + D, T) - Fn(U, V, W - H + D, T))/H2 }
    function(U, V, W, T) { TempFn(U, V, W, T, select(W - H - MinW, H, 0, 0) - select(W + H - MaxW, 0, 0, H)) }
  #else  
    function(U, V, W, T) { (Fn(U, V, W + H, T) - Fn(U, V, W - H, T))/H2 }
  #end // if

#end // Der1W_FunctionLimits4A



#macro Der1T_FunctionLimits4A(Fn, MinT, MaxT)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxT > MinT)
    #local TempFn = function(U, V, W, T, D) { (Fn(U, V, W, T + H + D) - Fn(U, V, W, T - H + D))/H2 }
    function(U, V, W, T) { TempFn(U, V, W, T, select(T - H - MinT, H, 0, 0) - select(T + H - MaxT, 0, 0, H)) }
  #else  
    function(U, V, W, T) { (Fn(U, V, W, T + H) - Fn(U, V, W, T - H))/H2 }
  #end // if

#end // Der1T_FunctionLimits4A



#macro Der2U_FunctionLimits1A(Fn, MinU, MaxU)

  #local H = 1E-4;
  #local H2 = H*2;

  #if (MaxU > MinU)
    #local TempFn = function(U, D) { (Fn(U + H + D) - 2*Fn(U + D) + Fn(U - H + D))/HH }
    function(U) { TempFn(U, select(U - H - MinU, H, 0, 0) - select(U + H - MaxU, 0, 0, H)) }
  #else  
    function(U) { (Fn(U + H) - 2*Fn(U) + Fn(U - H))/HH }
  #end // if

#end // Der2U_FunctionLimits1A

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

/*
#local H = 1E-4;
#local H2 = H*2;
#local H12 = H*12;
#local HH12 = 12*pow(H, 2);
#local HHH2 = 2*pow(H, 3);
#local HHHH = pow(H, 4);


(- Fn(U + H2, V) + 8*Fn(U + H, V) - 8*Fn(U - H, V) + Fn(U - H2, V))/H12
(- Fn(U + H2, V) + 16*Fn(U + H, V) - 30*Fn(U, V) + 16*Fn(U - H, V) - Fn(U - H2, V))/HH12
(Fn(U + H2, V) - 2*Fn(U + H, V) + 2*Fn(U - H, V) - Fn(U - H2, V))/HHH2
(Fn(U + H2, V) - 4*Fn(U + H, V) + 6*Fn(U, V) - 4*Fn(U - H, V) + Fn(U - H2, V))/HHHH


(- Fn(U, V + H2) + 8*Fn(U, V + H) - 8*Fn(U, V - H) + Fn(U, V - H2))/H12
(- Fn(U, V + H2) + 16*Fn(U, V + H) - 30*Fn(U, V) + 16*Fn(U, V - H) - Fn(U, V - H2))/HH12
(Fn(U, V + H2) - 2*Fn(U, V + H) + 2*Fn(U, V - H) - Fn(U, V - H2))/HHH2
(Fn(U, V + H2) - 4*Fn(U, V + H) + 6*Fn(U, V) - 4*Fn(U, V - H) + Fn(U, V - H2))/HHHH
*/



#macro Der1U_Function1A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U) { (Fn(U + H) - Fn(U - H))/H2 }

#end // Der1U_Function1A


/*
#macro Der1U_Function1A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;
  #local H12 = H*12;

  function(U) { (- Fn(U + H2) + 8*Fn(U + H) - 8*Fn(U - H) + Fn(U - H2))/H12 } ///

#end // Der1U_Function1A
*/


#macro Der1U_Function2A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V) { (Fn(U + H, V) - Fn(U - H, V))/H2 }

#end // Der1U_Function2A



#macro Der1V_Function2A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V) { (Fn(U, V + H) - Fn(U, V - H))/H2 }

#end // Der1V_Function2A



#macro Der1U_Function3A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W) { (Fn(U + H, V, W) - Fn(U - H, V, W))/H2 }

#end // Der1U_Function3A



#macro Der1V_Function3A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W) { (Fn(U, V + H, W) - Fn(U, V - H, W))/H2 }

#end // Der1V_Function3A



#macro Der1W_Function3A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W) { (Fn(U, V, W + H) - Fn(U, V, W - H))/H2 }

#end // Der1W_Function3A



#macro Der1U_Function4A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W, T) { (Fn(U + H, V, W, T) - Fn(U - H, V, W, T))/H2 }

#end // Der1U_Function4A



#macro Der1V_Function4A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W, T) { (Fn(U, V + H, W, T) - Fn(U, V - H, W, T))/H2 }

#end // Der1V_Function4A



#macro Der1W_Function4A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W, T) { (Fn(U, V, W + H, T) - Fn(U, V, W - H, T))/H2 }

#end // Der1W_Function4A



#macro Der1T_Function4A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;

  function(U, V, W, T) { (Fn(U, V, W, T + H) - Fn(U, V, W, T - H))/H2 }

#end // Der1T_Function4A



#macro Der2U_Function1A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U) { (Fn(U + H) - 2*Fn(U) + Fn(U - H))/HH }

#end // Der2U_Function1A


/*
#macro Der2U_Function1A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;
  #local HH12 = pow(H, 2)*12;

  function(U) { (- Fn(U + H2) + 16*Fn(U + H) - 30*Fn(U) + 16*Fn(U - H) - Fn(U - H2))/HH12 }

#end // Der2U_Function1A
*/


#macro Der2U_Function2A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V) { (Fn(U + H, V) - 2*Fn(U, V) + Fn(U - H, V))/HH }

#end // Der2U_Function2A



#macro Der2V_Function2A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V) { (Fn(U, V + H) - 2*Fn(U, V) + Fn(U, V - H))/HH }

#end // Der2V_Function2A



#macro Der2U_Function3A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W) { (Fn(U + H, V, W) - 2*Fn(U, V, W) + Fn(U - H, V, W))/HH }

#end // Der2U_Function3A



#macro Der2V_Function3A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W) { (Fn(U, V + H, W) - 2*Fn(U, V, W) + Fn(U, V - H, W))/HH }

#end // Der2V_Function3A



#macro Der2W_Function3A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W) { (Fn(U, V, W + H) - 2*Fn(U, V, W) + Fn(U, V, W - H))/HH }

#end // Der2W_Function3A



#macro Der2U_Function4A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W, T) { (Fn(U + H, V, W, T) - 2*Fn(U, V, W, T) + Fn(U - H, V, W, T))/HH }

#end // Der2U_Function4A
                             
                             

#macro Der2V_Function4A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W, T) { (Fn(U, V + H, W, T) - 2*Fn(U, V, W, T) + Fn(U, V - H, W, T))/HH }

#end // Der2V_Function4A



#macro Der2W_Function4A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W, T) { (Fn(U, V, W + H, T) - 2*Fn(U, V, W, T) + Fn(U, V, W - H, T))/HH }

#end // Der2W_Function4A



#macro Der2T_Function4A(Fn)

  #local H = 1E-4;
  #local HH = pow(H, 2);

  function(U, V, W, T) { (Fn(U, V, W, T + H) - 2*Fn(U, V, W, T) + Fn(U, V, W, T - H))/HH }

#end // Der2T_Function4A





#macro Der3U_Function1A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;
  #local HHH2 = pow(H, 3)*2;

  function(U) { (Fn(U + H2) - 2*Fn(U + H) + 2*Fn(U - H) - Fn(U - H2))/HHH2 }

#end // Der3U_Function1A



#macro Der4U_Function1A(Fn)

  #local H = 1E-4;
  #local H2 = H*2;
  #local HHHH = pow(H, 4);

  function(U) { (Fn(U + H2) - 4*Fn(U + H) + 6*Fn(U) - 4*Fn(U - H) + Fn(U - H2))/HHHH }

#end // Der4U_Function1A

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

/*
#macro TangentFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local d1FnX_1A = Der1U_Function1A(FnX_1A);
  #local d1FnY_1A = Der1U_Function1A(FnY_1A);
  #local d1FnZ_1A = Der1U_Function1A(FnZ_1A);

  function(U) { d1FnX_1A(U)/f_r(d1FnX_1A(U), d1FnY_1A(U), d1FnZ_1A(U)) }

#end // macro TangentFunctionX_1A



#macro TangentFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local d1FnX_1A = Der1U_Function1A(FnX_1A);
  #local d1FnY_1A = Der1U_Function1A(FnY_1A);
  #local d1FnZ_1A = Der1U_Function1A(FnZ_1A);

  function(U) { d1FnY_1A(U)/f_r(d1FnX_1A(U), d1FnY_1A(U), d1FnZ_1A(U)) }

#end // macro TangentFunctionY_1A



#macro TangentFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local d1FnX_1A = Der1U_Function1A(FnX_1A);
  #local d1FnY_1A = Der1U_Function1A(FnY_1A);
  #local d1FnZ_1A = Der1U_Function1A(FnZ_1A);

  function(U) { d1FnZ_1A(U)/f_r(d1FnX_1A(U), d1FnY_1A(U), d1FnZ_1A(U)) }

#end // macro TangentFunctionZ_1A



#macro BinormalFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local d1FnX_1A = Der1U_Function1A(FnX_1A);
  #local d1FnY_1A = Der1U_Function1A(FnY_1A);
  #local d1FnZ_1A = Der1U_Function1A(FnZ_1A);
  #local d2FnX_1A = Der2U_Function1A(FnX_1A);
  #local d2FnY_1A = Der2U_Function1A(FnY_1A);
  #local d2FnZ_1A = Der2U_Function1A(FnZ_1A);
  #local CrossFnX_1A = function(U) { d1FnY_1A(U)*d2FnZ_1A(U) - d1FnZ_1A(U)*d2FnY_1A(U) }
  #local CrossFnY_1A = function(U) { d1FnZ_1A(U)*d2FnX_1A(U) - d1FnX_1A(U)*d2FnZ_1A(U) }
  #local CrossFnZ_1A = function(U) { d1FnX_1A(U)*d2FnY_1A(U) - d1FnY_1A(U)*d2FnX_1A(U) }

  function(U) { CrossFnX_1A(U)/f_r(CrossFnX_1A(U), CrossFnY_1A(U), CrossFnZ_1A(U)) }

#end // macro BinormalFunctionX_1A



#macro BinormalFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local d1FnX_1A = Der1U_Function1A(FnX_1A);
  #local d1FnY_1A = Der1U_Function1A(FnY_1A);
  #local d1FnZ_1A = Der1U_Function1A(FnZ_1A);
  #local d2FnX_1A = Der2U_Function1A(FnX_1A);
  #local d2FnY_1A = Der2U_Function1A(FnY_1A);
  #local d2FnZ_1A = Der2U_Function1A(FnZ_1A);
  #local CrossFnX_1A = function(U) { d1FnY_1A(U)*d2FnZ_1A(U) - d1FnZ_1A(U)*d2FnY_1A(U) }
  #local CrossFnY_1A = function(U) { d1FnZ_1A(U)*d2FnX_1A(U) - d1FnX_1A(U)*d2FnZ_1A(U) }
  #local CrossFnZ_1A = function(U) { d1FnX_1A(U)*d2FnY_1A(U) - d1FnY_1A(U)*d2FnX_1A(U) }

  function(U) { CrossFnY_1A(U)/f_r(CrossFnX_1A(U), CrossFnY_1A(U), CrossFnZ_1A(U)) }

#end // macro BinormalFunctionY_1A



#macro BinormalFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local d1FnX_1A = Der1U_Function1A(FnX_1A);
  #local d1FnY_1A = Der1U_Function1A(FnY_1A);
  #local d1FnZ_1A = Der1U_Function1A(FnZ_1A);
  #local d2FnX_1A = Der2U_Function1A(FnX_1A);
  #local d2FnY_1A = Der2U_Function1A(FnY_1A);
  #local d2FnZ_1A = Der2U_Function1A(FnZ_1A);
  #local CrossFnX_1A = function(U) { d1FnY_1A(U)*d2FnZ_1A(U) - d1FnZ_1A(U)*d2FnY_1A(U) }
  #local CrossFnY_1A = function(U) { d1FnZ_1A(U)*d2FnX_1A(U) - d1FnX_1A(U)*d2FnZ_1A(U) }
  #local CrossFnZ_1A = function(U) { d1FnX_1A(U)*d2FnY_1A(U) - d1FnY_1A(U)*d2FnX_1A(U) }

  function(U) { CrossFnZ_1A(U)/f_r(CrossFnX_1A(U), CrossFnY_1A(U), CrossFnZ_1A(U)) }

#end // macro BinormalFunctionZ_1A



#macro NormalFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local BinormalFnY_1A = BinormalFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local BinormalFnZ_1A = BinormalFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local TangentFnY_1A = TangentFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local TangentFnZ_1A = TangentFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A);

  function(U) { BinormalFnY_1A(U)*TangentFnZ_1A(U) - BinormalFnZ_1A(U)*TangentFnY_1A(U) }

#end // macro NormalFunctionX_1A



#macro NormalFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local BinormalFnX_1A = BinormalFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local BinormalFnZ_1A = BinormalFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local TangentFnX_1A = TangentFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local TangentFnZ_1A = TangentFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A);

  function(U) { BinormalFnZ_1A(U)*TangentFnX_1A(U) - BinormalFnX_1A(U)*TangentFnZ_1A(U) }

#end // macro NormalFunctionY_1A



#macro NormalFunctionZ_1A(FnX_1A, FnY_1A, FnZ_1A)

  #local BinormalFnX_1A = BinormalFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local BinormalFnY_1A = BinormalFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local TangentFnX_1A = TangentFunctionX_1A(FnX_1A, FnY_1A, FnZ_1A);
  #local TangentFnY_1A = TangentFunctionY_1A(FnX_1A, FnY_1A, FnZ_1A);

  function(U) { BinormalFnX_1A(U)*TangentFnY_1A(U) - BinormalFnY_1A(U)*TangentFnX_1A(U) }

#end // macro NormalFunctionZ_1A
*/

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro TangentFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local d1FnX_1A = Der1U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d1FnY_1A = Der1U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d1FnZ_1A = Der1U_FunctionLimits1A(FnZ_1A, MinU, MaxU)

  function(U) { d1FnX_1A(U)/f_r(d1FnX_1A(U), d1FnY_1A(U), d1FnZ_1A(U)) }

#end // macro TangentFunctionLimitsX_1A



#macro TangentFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local d1FnX_1A = Der1U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d1FnY_1A = Der1U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d1FnZ_1A = Der1U_FunctionLimits1A(FnZ_1A, MinU, MaxU)

  function(U) { d1FnY_1A(U)/f_r(d1FnX_1A(U), d1FnY_1A(U), d1FnZ_1A(U)) }

#end // macro TangentFunctionLimitsY_1A



#macro TangentFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local d1FnX_1A = Der1U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d1FnY_1A = Der1U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d1FnZ_1A = Der1U_FunctionLimits1A(FnZ_1A, MinU, MaxU)

  function(U) { d1FnZ_1A(U)/f_r(d1FnX_1A(U), d1FnY_1A(U), d1FnZ_1A(U)) }

#end // macro TangentFunctionLimitsZ_1A



#macro BinormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local d1FnX_1A = Der1U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d1FnY_1A = Der1U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d1FnZ_1A = Der1U_FunctionLimits1A(FnZ_1A, MinU, MaxU)
  #local d2FnX_1A = Der2U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d2FnY_1A = Der2U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d2FnZ_1A = Der2U_FunctionLimits1A(FnZ_1A, MinU, MaxU)
  #local CrossFnX_1A = function(U) { d1FnY_1A(U)*d2FnZ_1A(U) - d1FnZ_1A(U)*d2FnY_1A(U) }
  #local CrossFnY_1A = function(U) { d1FnZ_1A(U)*d2FnX_1A(U) - d1FnX_1A(U)*d2FnZ_1A(U) }
  #local CrossFnZ_1A = function(U) { d1FnX_1A(U)*d2FnY_1A(U) - d1FnY_1A(U)*d2FnX_1A(U) }

  function(U) { CrossFnX_1A(U)/f_r(CrossFnX_1A(U), CrossFnY_1A(U), CrossFnZ_1A(U)) }

#end // macro BinormalFunctionLimitsX_1A



#macro BinormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local d1FnX_1A = Der1U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d1FnY_1A = Der1U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d1FnZ_1A = Der1U_FunctionLimits1A(FnZ_1A, MinU, MaxU)
  #local d2FnX_1A = Der2U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d2FnY_1A = Der2U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d2FnZ_1A = Der2U_FunctionLimits1A(FnZ_1A, MinU, MaxU)
  #local CrossFnX_1A = function(U) { d1FnY_1A(U)*d2FnZ_1A(U) - d1FnZ_1A(U)*d2FnY_1A(U) }
  #local CrossFnY_1A = function(U) { d1FnZ_1A(U)*d2FnX_1A(U) - d1FnX_1A(U)*d2FnZ_1A(U) }
  #local CrossFnZ_1A = function(U) { d1FnX_1A(U)*d2FnY_1A(U) - d1FnY_1A(U)*d2FnX_1A(U) }

  function(U) { CrossFnY_1A(U)/f_r(CrossFnX_1A(U), CrossFnY_1A(U), CrossFnZ_1A(U)) }

#end // macro BinormalFunctionLimitsY_1A



#macro BinormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local d1FnX_1A = Der1U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d1FnY_1A = Der1U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d1FnZ_1A = Der1U_FunctionLimits1A(FnZ_1A, MinU, MaxU)
  #local d2FnX_1A = Der2U_FunctionLimits1A(FnX_1A, MinU, MaxU)
  #local d2FnY_1A = Der2U_FunctionLimits1A(FnY_1A, MinU, MaxU)
  #local d2FnZ_1A = Der2U_FunctionLimits1A(FnZ_1A, MinU, MaxU)
  #local CrossFnX_1A = function(U) { d1FnY_1A(U)*d2FnZ_1A(U) - d1FnZ_1A(U)*d2FnY_1A(U) }
  #local CrossFnY_1A = function(U) { d1FnZ_1A(U)*d2FnX_1A(U) - d1FnX_1A(U)*d2FnZ_1A(U) }
  #local CrossFnZ_1A = function(U) { d1FnX_1A(U)*d2FnY_1A(U) - d1FnY_1A(U)*d2FnX_1A(U) }

  function(U) { CrossFnZ_1A(U)/f_r(CrossFnX_1A(U), CrossFnY_1A(U), CrossFnZ_1A(U)) }

#end // macro BinormalFunctionLimitsZ_1A



#macro NormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local BinormalFnY_1A = BinormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local BinormalFnZ_1A = BinormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local TangentFnY_1A = TangentFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local TangentFnZ_1A = TangentFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  function(U) { BinormalFnY_1A(U)*TangentFnZ_1A(U) - BinormalFnZ_1A(U)*TangentFnY_1A(U) }

#end // macro NormalFunctionLimitsX_1A



#macro NormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local BinormalFnX_1A = BinormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local BinormalFnZ_1A = BinormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local TangentFnX_1A = TangentFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local TangentFnZ_1A = TangentFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  function(U) { BinormalFnZ_1A(U)*TangentFnX_1A(U) - BinormalFnX_1A(U)*TangentFnZ_1A(U) }

#end // macro NormalFunctionLimitsY_1A



#macro NormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  #local BinormalFnX_1A = BinormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local BinormalFnY_1A = BinormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local TangentFnX_1A = TangentFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)
  #local TangentFnY_1A = TangentFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinU, MaxU)

  function(U) { BinormalFnX_1A(U)*TangentFnY_1A(U) - BinormalFnY_1A(U)*TangentFnX_1A(U) }

#end // macro NormalFunctionLimitsZ_1A


// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro FrenetFramePoints3A3D(FnX_1A, FnY_1A, FnZ_1A, SizeUVW, MinT, MaxT, LengthN, LengthB)

  #local N_FnX_1A = NormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local N_FnY_1A = NormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local N_FnZ_1A = NormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local B_FnX_1A = BinormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local B_FnY_1A = BinormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local B_FnZ_1A = BinormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A3D = array[SizeU][SizeV][SizeW];
//  #local dT = (MaxT - MinT)/(SizeU - 1);
  #local dT = (MaxT - MinT)/SizeU;
  #local dN = LengthN/(SizeV - 1);
  #local dB = LengthB/(SizeW - 1);
  #local HLN = LengthN/2;
  #local HLB = LengthB/2;
  
  #local I = 0;
  #while (I < SizeU)
    #local T = I*dT;
    #local p0 = <  FnX_1A(T),   FnY_1A(T),   FnZ_1A(T)>;
    #local vN = <N_FnX_1A(T), N_FnY_1A(T), N_FnZ_1A(T)>;
    #local vB = <B_FnX_1A(T), B_FnY_1A(T), B_FnZ_1A(T)>;
    #local J = 0;
    #while (J < SizeV)
      #local vNN = (J*dN - HLN)*vN;
      #local K = 0;
      #while (K < SizeW)
        #local vBB = (K*dB - HLB)*vB;
        #local Points3A3D[I][J][K] = p0 + vNN + vBB;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D

#end // macro FrenetFramePoints3A3D



#macro FrenetFrameRotPoints3A3D(FnX_1A, FnY_1A, FnZ_1A, SizeUVW, MinT, MaxT, RotFn_1A, LengthN, LengthB)

  #local N_FnX_1A = NormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local N_FnY_1A = NormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local N_FnZ_1A = NormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local B_FnX_1A = BinormalFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local B_FnY_1A = BinormalFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local B_FnZ_1A = BinormalFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local T_FnX_1A = TangentFunctionLimitsX_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local T_FnY_1A = TangentFunctionLimitsY_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  #local T_FnZ_1A = TangentFunctionLimitsZ_1A(FnX_1A, FnY_1A, FnZ_1A, MinT, MaxT)
  
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A3D = array[SizeU][SizeV][SizeW];
//  #local dT = (MaxT - MinT)/(SizeU - 1);
  #local dT = (MaxT - MinT)/SizeU;
  #local dN = LengthN/(SizeV - 1);
  #local dB = LengthB/(SizeW - 1);
  #local HLN = LengthN/2;
  #local HLB = LengthB/2;
  
  #local I = 0;
  #while (I < SizeU)
    #local T = I*dT;
    #local p0 = <  FnX_1A(T),   FnY_1A(T),   FnZ_1A(T)>;
    #local vN = <N_FnX_1A(T), N_FnY_1A(T), N_FnZ_1A(T)>;
    #local vB = <B_FnX_1A(T), B_FnY_1A(T), B_FnZ_1A(T)>;
    #local vT = <T_FnX_1A(T), T_FnY_1A(T), T_FnZ_1A(T)>;
    #local J = 0;
    #while (J < SizeV)
      #local vNN = (J*dN - HLN)*vN;
      #local K = 0;
      #while (K < SizeW)
        #local vBB = (K*dB - HLB)*vB;
        #local Points3A3D[I][J][K] = p0 + vaxis_rotate(vNN + vBB, vT, RotFn_1A(T));
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D

#end // macro FrenetFrameRotPoints3A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro SampleFunctionsNormals2A3D(xFn, yFn, zFn, U_Coords1A, V_Coords1A)

  #local MinU = 0;
  #local MaxU = 1;
  #local MinV = 0;
  #local MaxV = 1;
  #local dUxFn = Der1U_FunctionLimits2A(xFn, MinU, MaxU)
  #local dUyFn = Der1U_FunctionLimits2A(yFn, MinU, MaxU)
  #local dUzFn = Der1U_FunctionLimits2A(zFn, MinU, MaxU)
  #local dVxFn = Der1V_FunctionLimits2A(xFn, MinV, MaxV)
  #local dVyFn = Der1V_FunctionLimits2A(yFn, MinV, MaxV)
  #local dVzFn = Der1V_FunctionLimits2A(zFn, MinV, MaxV)
  #local xxFn = function(U, V) { dVyFn(U, V)*dUzFn(U, V) - dVzFn(U, V)*dUyFn(U, V) }
  #local yyFn = function(U, V) { dVzFn(U, V)*dUxFn(U, V) - dVxFn(U, V)*dUzFn(U, V) }
  #local zzFn = function(U, V) { dVxFn(U, V)*dUyFn(U, V) - dVyFn(U, V)*dUxFn(U, V) }

  #local SizeU = Size1A(U_Coords1A);
  #local SizeV = Size1A(V_Coords1A);
  #local Normals2A3D = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local U = U_Coords1A[I];
    #local J = 0;
    #while (J < SizeV)
      #local V = V_Coords1A[J];
      #local Normals2A3D[I][J] = vnormalize(<xxFn(U, V), yyFn(U, V), zzFn(U, V)>);
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Normals2A3D

#end // macro SampleFunctionsNormals2A3D


// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro UnWrapPoints1A(Points1A, ExtraU)

  #local SizeU = Size1A(Points1A);
  #local NewSizeU = SizeU - ExtraU;
  #local NewPoints1A = array[NewSizeU];

  #local I = 0;
  #while (I < NewSizeU)
    #local NewPoints1A[I] = Points1A[I];
    #local I = I + 1;
  #end // while

  NewPoints1A

#end // macro UnWrapPoints1A



#macro UnWrapPoints2A(Points2A, ExtraUV)

  #local SizeUV = Size2A(Points2A);
  #local NewSizeUV = SizeUV - ExtraUV;
  #local NewSizeU = NewSizeUV.u;
  #local NewSizeV = NewSizeUV.v;
  #local NewPoints2A = array[NewSizeU][NewSizeV];

  #local J = 0;
  #while (J < NewSizeV)
    #local I = 0;
    #while (I < NewSizeU)
      #local NewPoints2A[I][J] = Points2A[I][J];
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while  

  NewPoints2A

#end // macro UnWrapPoints2A



#macro UnWrapPoints3A(Points3A, ExtraUVW)

  #local SizeUVW = Size3A(Points3A);
  #local NewSizeUVW = SizeUVW - ExtraUVW;
  #local NewSizeU = NewSizeUVW.x;
  #local NewSizeV = NewSizeUVW.y;
  #local NewSizeW = NewSizeUVW.z;
  #local NewPoints3A = array[NewSizeU][NewSizeV][NewSizeW];

  #local K = 0;
  #while (K < NewSizeW)
    #local J = 0;
    #while (J < NewSizeV)
      #local I = 0;
      #while (I < NewSizeU)
        #local NewPoints3A[I][J][K] = Points3A[I][J][K];
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while  
    #local K = K + 1;
  #end // while  

  NewPoints3A

#end // macro UnWrapPoints3A



#macro UnWrapPoints4A(Points4A, ExtraUVWT)

  #local SizeUVWT = Size4A(Points4A);
  #local NewSizeUVWT = SizeUVWT - ExtraUVWT;
  #local NewSizeU = NewSizeUVWT.x;
  #local NewSizeV = NewSizeUVWT.y;
  #local NewSizeW = NewSizeUVWT.z;
  #local NewSizeT = NewSizeUVWT.t;
  #local NewPoints4A = array[NewSizeU][NewSizeV][NewSizeW][NewSizeT];

  #local L = 0;
  #while (L < NewSizeT)
    #local K = 0;
    #while (K < NewSizeW)
      #local J = 0;
      #while (J < NewSizeV)
        #local I = 0;
        #while (I < NewSizeU)
          #local NewPoints4A[I][J][K][L] = Points4A[I][J][K][L];
          #local I = I + 1;
        #end // while
        #local J = J + 1;
      #end // while  
      #local K = K + 1;
    #end // while  
    #local L = L + 1;
  #end // while  

  NewPoints4A

#end // macro UnWrapPoints4A


// Hvis "endene" mtes:
//  #local U_Fn = function(U) { mod(U, SizeU - 1) }
// Ellers:
//  #local U_Fn = function(U) { mod(U, SizeU) }

#macro WrapPoints1A(Points1A, ExtraU)

  #local SizeU = Size1A(Points1A);
  #local NewSizeU = SizeU + ExtraU;
  #local NewPoints1A = array[NewSizeU];
  #local U_Fn = function(U) { mod(U, SizeU) }

  #local I = 0;
  #while (I < NewSizeU)
    #local NewPoints1A[I] = Points1A[U_Fn(I)];
    #local I = I + 1;
  #end // while

  NewPoints1A

#end // macro WrapPoints1A



#macro WrapPoints2A(Points2A, ExtraUV)

  #local SizeUV = Size2A(Points2A);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local NewSizeUV = SizeUV + ExtraUV;
  #local NewSizeU = NewSizeUV.u;
  #local NewSizeV = NewSizeUV.v;
  #local NewPoints2A = array[NewSizeU][NewSizeV];
  #local U_Fn = function(U) { mod(U, SizeU) }
  #local V_Fn = function(V) { mod(V, SizeV) }

  #local J = 0;
  #while (J < NewSizeV)
    #local I = 0;
    #while (I < NewSizeU)
      #local NewPoints2A[I][J] = Points2A[U_Fn(I)][V_Fn(J)];
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while  

  NewPoints2A

#end // macro WrapPoints2A



#macro WrapPoints3A(Points3A, ExtraUVW)

  #local SizeUVW = Size3A(Points3A);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local NewSizeUVW = SizeUVW + ExtraUVW;
  #local NewSizeU = NewSizeUVW.x;
  #local NewSizeV = NewSizeUVW.y;
  #local NewSizeW = NewSizeUVW.z;
  #local NewPoints3A = array[NewSizeU][NewSizeV][NewSizeW];
  #local U_Fn = function(U) { mod(U, SizeU) }
  #local V_Fn = function(V) { mod(V, SizeV) }
  #local W_Fn = function(W) { mod(W, SizeW) }

  #local K = 0;
  #while (K < NewSizeW)
    #local J = 0;
    #while (J < NewSizeV)
      #local I = 0;
      #while (I < NewSizeU)
        #local NewPoints3A[I][J][K] = Points3A[U_Fn(I)][V_Fn(J)][W_Fn(K)];
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while  
    #local K = K + 1;
  #end // while  

  NewPoints3A

#end // macro WrapPoints3A



#macro WrapPoints4A(Points4A, ExtraUVWT)

  #local SizeUVWT = Size4A(Points4A);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local SizeT = SizeUVW.t;
  #local NewSizeUVWT = SizeUVWT + ExtraUVWT;
  #local NewSizeU = NewSizeUVWT.x;
  #local NewSizeV = NewSizeUVWT.y;
  #local NewSizeW = NewSizeUVWT.z;
  #local NewSizeT = NewSizeUVWT.t;
  #local NewPoints4A = array[NewSizeU][NewSizeV][NewSizeW][NewSizeT];
  #local U_Fn = function(U) { mod(U, SizeU) }
  #local V_Fn = function(V) { mod(V, SizeV) }
  #local W_Fn = function(W) { mod(W, SizeW) }
  #local T_Fn = function(T) { mod(T, SizeT) }

  #local L = 0;
  #while (L < NewSizeT)
    #local K = 0;
    #while (K < NewSizeW)
      #local J = 0;
      #while (J < NewSizeV)
        #local I = 0;
        #while (I < NewSizeU)
          #local NewPoints4A[I][J][K][L] = Points4A[U_Fn(I)][V_Fn(J)][W_Fn(K)][T_Fn(L)];
          #local I = I + 1;
        #end // while
        #local J = J + 1;
      #end // while  
      #local K = K + 1;
    #end // while  
    #local L = L + 1;
  #end // while  

  NewPoints4A

#end // macro WrapPoints4A

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro ExtractPoints1A1D(xFn, SizeU)

  #local MinU = 0;
  #local MaxU = 1;
  #local DivU = SizeU - 1;

  SampleFunctions1A1D(xFn, MinU, MaxU, DivU)

#end // macro ExtractPoints1A1D



#macro ExtractPoints1A2D(xFn, yFn, SizeU)

  #local MinU = 0;
  #local MaxU = 1;
  #local DivU = SizeU - 1;

  SampleFunctions1A2D(xFn, yFn, MinU, MaxU, DivU)

#end // macro ExtractPoints1A2D



#macro ExtractPoints1A3D(xFn, yFn, zFn, SizeU)

  #local MinU = 0;
  #local MaxU = 1;
  #local DivU = SizeU - 1;

  SampleFunctions1A3D(xFn, yFn, zFn, MinU, MaxU, DivU)

#end // macro ExtractPoints1A3D




#macro ExtractPoints2A1D(xFn, SizeUV)

  #local MinUV = <0, 0>;
  #local MaxUV = <1, 1>;
  #local DivUV = SizeUV - <1, 1>;

  SampleFunctions2A1D(xFn, MinUV, MaxUV, DivUV)

#end // macro ExtractPoints2A1D



#macro ExtractPoints2A2D(xFn, yFn, SizeUV)

  #local MinUV = <0, 0>;
  #local MaxUV = <1, 1>;
  #local DivUV = SizeUV - <1, 1>;

  SampleFunctions2A2D(xFn, yFN, MinUV, MaxUV, DivUV)

#end // macro ExtractPoints2A2D



#macro ExtractPoints2A3D(xFn, yFn, zFn, SizeUV)

  #local MinUV = <0, 0>;
  #local MaxUV = <1, 1>;
  #local DivUV = SizeUV - <1, 1>;

  SampleFunctions2A3D(xFn, yFn, zFn, MinUV, MaxUV, DivUV)

#end // macro ExtractPoints2A3D




#macro ExtractPoints3A1D(xFn, SizeUVW)

  #local MinUVW = <0, 0, 0>;
  #local MaxUVW = <1, 1, 1>;
  #local DivUVW = SizeUVW - <1, 1, 1>;

  SampleFunctions3A1D(xFn, MinUVW, MaxUVW, DivUVW)

#end // macro ExtractPoints3A1D



#macro ExtractPoints3A2D(xFn, yFn, SizeUVW)

  #local MinUVW = <0, 0, 0>;
  #local MaxUVW = <1, 1, 1>;
  #local DivUVW = SizeUVW - <1, 1, 1>;

  SampleFunctions3A2D(xFn, yFn, MinUVW, MaxUVW, DivUVW)

#end // macro ExtractPoints3A2D



#macro ExtractPoints3A3D(xFn, yFn, zFn, SizeUVW)

  #local MinUVW = <0, 0, 0>;
  #local MaxUVW = <1, 1, 1>;
  #local DivUVW = SizeUVW - <1, 1, 1>;

  SampleFunctions3A3D(xFn, yFn, zFn, MinUVW, MaxUVW, DivUVW)

#end // macro ExtractPoints3A3D




#macro ExtractPoints4A1D(xFn, SizeUVWT)

  #local MinUVWT = <0, 0, 0, 0>;
  #local MaxUVWT = <1, 1, 1, 1>;
  #local DivUVWT = SizeUVWT - <1, 1, 1, 1>;

  SampleFunctions4A1D(xFn, MinUVWT, MaxUVWT, DivUVWT)

#end // macro ExtractPoints4A1D



#macro ExtractPoints4A2D(xFn, yFn, SizeUVWT)

  #local MinUVWT = <0, 0, 0, 0>;
  #local MaxUVWT = <1, 1, 1, 1>;
  #local DivUVWT = SizeUVWT - <1, 1, 1, 1>;

  SampleFunctions4A2D(xFn, yFn, MinUVWT, MaxUVWT, DivUVWT)

#end // macro ExtractPoints4A2D



#macro ExtractPoints4A3D(xFn, yFn, zFn, SizeUVWT)

  #local MinUVWT = <0, 0, 0, 0>;
  #local MaxUVWT = <1, 1, 1, 1>;
  #local DivUVWT = SizeUVWT - <1, 1, 1, 1>;

  SampleFunctions4A3D(xFn, yFn, zFn, MinUVWT, MaxUVWT, DivUVWT)

#end // macro ExtractPoints4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro UniformWeights1A(SizeU, Weight)

  ExtractPoints1A1D(function(t_) { Weight }, SizeU)

#end // macro UniformWeights1A



#macro UniformWeights2A(SizeUV, Weight)

  ExtractPoints2A1D(function(u, v) { Weight }, SizeUV)

#end // macro UniformWeights2A



#macro UniformWeights3A(SizeUVW, Weight)

  ExtractPoints3A1D(function { Weight }, SizeUVW)

#end // macro UniformWeights3A



#macro UniformWeights4A(SizeUVWT, Weight)

  ExtractPoints4A1D(function(x, y, z, t_) { Weight }, SizeUVWT)

#end // macro UniformWeights4A

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro ExtractComponent1A(Vectors1A, v0)

  #local SizeU = Size1A(Vectors1A);
  #local Component1A = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Component1A[I] = vdot(Vectors1A[I], v0);
    #local I = I + 1;
  #end // while

  Component1A

#end // macro ExtractComponent1A



#macro ExtractComponent2A(Vectors2A, v0)

  #local SizeUV = Size2A(Vectors2A);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Component2A = array[SizeU][SizeV];

  #local J = 0;
  #while (J < SizeV)
    #local I = 0;
    #while (I < SizeU)
      #local Component2A[I][J] = vdot(Vectors2A[I][J], v0);
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while

  Component2A

#end // macro ExtractComponent2A



#macro ExtractComponent3A(Vectors3A, v0)

  #local SizeUVW = Size3A(Vectors3A);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Component3A = array[SizeU][SizeV][SizeW];

  #local K = 0;
  #while (K < SizeW)
    #local J = 0;
    #while (J < SizeV)
      #local I = 0;
      #while (I < SizeU)
        #local Component3A[I][J][K] = vdot(Vectors3A[I][J][K], v0);
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local K = K + 1;
  #end // while

  Component3A

#end // macro ExtractComponent3A



#macro ExtractComponent4A(Vectors4A, v0)

  #local SizeUVWT = Size4A(Vectors4A);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local Component4A = array[SizeU][SizeV][SizeW][SizeT];

  #local L = 0;
  #while (L < SizeT)
    #local K = 0;
    #while (K < SizeW)
      #local J = 0;
      #while (J < SizeV)
        #local I = 0;
        #while (I < SizeU)
          #local Component4A[I][J][K][L] = vdot(Vectors4A[I][J][K][L], v0);
          #local I = I + 1;
        #end // while
        #local J = J + 1;
      #end // while
      #local K = K + 1;
    #end // while
    #local L = L + 1;
  #end // while

  Component4A

#end // macro ExtractComponent4A

// -----   -------   -------   -------   -------   -------   -------   -------

#macro MergeComponents1A2D(Values1Ax, Values1Ay)

  #local SizeU = Size1A(Values1Ax);
  #local Vectors1A2D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A2D[I] = <Values1Ax[I], Values1Ay[I]>;
    #local I = I + 1;
  #end // while

  Vectors1A2D

#end // macro MergeComponents1A3D



#macro MergeComponents1A3D(Values1Ax, Values1Ay, Values1Az)

  #local SizeU = Size1A(Values1Ax);
  #local Vectors1A3D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A3D[I] = <Values1Ax[I], Values1Ay[I], Values1Az[I]>;
    #local I = I + 1;
  #end // while

  Vectors1A3D

#end // macro MergeComponents1A3D



#macro MergeComponents1A4D(Values1Ax, Values1Ay, Values1Az, Values1At)

  #local SizeU = Size1A(Values1Ax);
  #local Vectors1A4D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A4D[I] = <Values1Ax[I], Values1Ay[I], Values1Az[I], Values1At[I]>;
    #local I = I + 1;
  #end // while

  Vectors1A4D

#end // macro MergeComponents1A4D



#macro MergeComponents2A2D(Values2Ax, Values2Ay)

  #local SizeUV = Size2A(Values2Ax);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Vectors2A2D = array[SizeU][SizeV];

  #local J = 0;
  #while (J < SizeV)
    #local I = 0;
    #while (I < SizeU)
      #local Vectors2A2D[I][J] = <Values2Ax[I][J], Values2Ay[I][J]>;
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while

  Vectors2A2D

#end // macro MergeComponents2A2D



#macro MergeComponents2A3D(Values2Ax, Values2Ay, Values2Az)

  #local SizeUV = Size2A(Values2Ax);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Vectors2A3D = array[SizeU][SizeV];

  #local J = 0;
  #while (J < SizeV)
    #local I = 0;
    #while (I < SizeU)
      #local Vectors2A3D[I][J] = <Values2Ax[I][J], Values2Ay[I][J], Values2Az[I][J]>;
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while

  Vectors2A3D

#end // macro MergeComponents2A3D



#macro MergeComponents2A4D(Values2Ax, Values2Ay, Values2Az, Values2At)

  #local SizeUV = Size2A(Values2Ax);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Vectors2A4D = array[SizeU][SizeV];

  #local J = 0;
  #while (J < SizeV)
    #local I = 0;
    #while (I < SizeU)
      #local Vectors2A4D[I][J] = <Values2Ax[I][J], Values2Ay[I][J], Values2Az[I][J], Values2At[I][J]>;
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while

  Vectors2A4D

#end // macro MergeComponents2A4D



#macro MergeComponents3A2D(Values3Ax, Values3Ay)

  #local SizeUVW = Size3A(Values3Ax);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Vectors3A3D = array[SizeU][SizeV][SizeW];

  #local K = 0;
  #while (K < SizeW)
    #local J = 0;
    #while (J < SizeV)
      #local I = 0;
      #while (I < SizeU)
        #local Vectors3A2D[I][J][K] = <Values3Ax[I][J][K], Values3Ay[I][J][K]>;
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local K = K + 1;
  #end // while

  Vectors3A2D

#end // macro MergeComponents3A2D



#macro MergeComponents3A3D(Values3Ax, Values3Ay, Values3Az)

  #local SizeUVW = Size3A(Values3Ax);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Vectors3A3D = array[SizeU][SizeV][SizeW];

  #local K = 0;
  #while (K < SizeW)
    #local J = 0;
    #while (J < SizeV)
      #local I = 0;
      #while (I < SizeU)
        #local Vectors3A3D[I][J][K] = <Values3Ax[I][J][K], Values3Ay[I][J][K], Values3Az[I][J][K]>;
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local K = K + 1;
  #end // while

  Vectors3A3D

#end // macro MergeComponents3A3D



#macro MergeComponents3A4D(Values3Ax, Values3Ay, Values3Az, Values3At)

  #local SizeUVW = Size3A(Values3Ax);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Vectors3A4D = array[SizeU][SizeV][SizeW];

  #local K = 0;
  #while (K < SizeW)
    #local J = 0;
    #while (J < SizeV)
      #local I = 0;
      #while (I < SizeU)
        #local Vectors3A4D[I][J][K] = <Values3Ax[I][J][K], Values3Ay[I][J][K], Values3Az[I][J][K], Values3At[I][J][K]>;
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local K = K + 1;
  #end // while

  Vectors3A4D

#end // macro MergeComponents3A4D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Sphere(p0, Radius)

  #if (Radius > 0)
    sphere { p0, Radius }
  #end // if

#end // macro Sphere



#macro Cylinder(pF, pT, Radius)

  #if (vlength(pT - pF) > 1E-6 & Radius > 0)
    cylinder { pF, pT, Radius }
  #end // if

#end // macro Cylinder



#macro ShowPoints1A3D(Points1A3D, WrapU, Radius)

  #local SizeU = Size1A(Points1A3D);
  #local LastU = SizeU - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    Sphere(Points1A3D[CntU], Radius)
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    Sphere(Points1A3D[LastU], Radius)
  #end // if  

#end // macro ShowPoints1A3D



#macro ShowPoints2A3D(Points2A3D, WrapUV, Radius)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local WrapU = WrapUV.u;
  #local WrapV = WrapUV.v;
  #local LastU = SizeU - 1;
  #local LastV = SizeV - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    #local CntV = 0;
    #while (CntV < LastV)
      Sphere(Points2A3D[CntU][CntV], Radius)
      #local CntV = CntV + 1;
    #end // while
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    #local CntV = 0;
    #while (CntV < LastV)
      Sphere(Points2A3D[LastU][CntV], Radius)
      #local CntV = CntV + 1;
    #end // while
  #end // if  

  #if (!WrapV)
    #local CntU = 0;
    #while (CntU < LastU)
      Sphere(Points2A3D[CntU][LastV], Radius)
      #local CntU = CntU + 1;
    #end // while
  #end // if  

  #if (!WrapU & !WrapV)
    Sphere(Points2A3D[LastU][LastV], Radius)
  #end // if  

#end // macro ShowPoints2A3D



#macro ShowPoints3A3D(Points3A3D, WrapUVW, Radius)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local WrapU = WrapUVW.x;
  #local WrapV = WrapUVW.y;
  #local WrapW = WrapUVW.z;
  #local LastU = SizeU - 1;
  #local LastV = SizeV - 1;
  #local LastW = SizeW - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        Sphere(Points3A3D[CntU][CntV][CntW], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        Sphere(Points3A3D[LastU][CntV][CntW], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if  

  #if (!WrapV)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntW = 0;
      #while (CntW < LastW)
        Sphere(Points3A3D[CntU][LastV][CntW], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if  

  #if (!WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        Sphere(Points3A3D[CntU][CntV][LastW], Radius)
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if  

  #if (!WrapU & !WrapV)
    #local CntW = 0;
    #while (CntW < LastW)
      Sphere(Points3A3D[LastU][LastV][CntW], Radius)
      #local CntW = CntW + 1;
    #end // while
  #end // if  

  #if (!WrapU & !WrapW)
    #local CntV = 0;
    #while (CntV < LastV)
      Sphere(Points3A3D[LastU][CntV][LastW], Radius)
      #local CntV = CntV + 1;
    #end // while
  #end // if  

  #if (!WrapV & !WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      Sphere(Points3A3D[CntU][LastV][LastW], Radius)
      #local CntU = CntU + 1;
    #end // while
  #end // if  

  #if (!WrapU & !LastV & !WrapW)
    Sphere(Points3A3D[LastU][LastV][LastW], Radius)
  #end // if  

#end // macro ShowPoints3A3D



#macro ShowPoints4A3D(Points4A3D, WrapUVWT, Radius)

  #local SizeUVWT = Size4A(Points4A3D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local WrapU = WrapUVWT.x;
  #local WrapV = WrapUVWT.y;
  #local WrapW = WrapUVWT.z;
  #local WrapT = WrapUVWT.t;
  #local LastU = SizeU - 1;
  #local LastV = SizeV - 1;
  #local LastW = SizeW - 1;
  #local LastT = SizeT - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        #local CntT = 0;
        #while (CntT < LastT)
          Sphere(Points4A3D[CntU][CntV][CntW][CntT], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        #local CntT = 0;
        #while (CntT < LastT)
          Sphere(Points4A3D[LastU][CntV][CntW][CntT], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntW = 0;
      #while (CntW < LastW)
        #local CntT = 0;
        #while (CntT < LastT)
          Sphere(Points4A3D[CntU][LastV][CntW][CntT], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntW = CntW + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        #local CntT = 0;
        #while (CntT < LastT)
          Sphere(Points4A3D[CntU][CntV][LastW][CntT], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        #local CntW = 0;
        #while (CntW < LastW)
          Sphere(Points4A3D[CntU][CntV][CntW][LastT], Radius)
          #local CntW = CntW + 1;
        #end // while
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV)
    #local CntW = 0;
    #while (CntW < LastW)
      #local CntT = 0;
      #while (CntT < LastT)
        Sphere(Points4A3D[LastU][LastV][CntW][CntT], Radius)
        #local CntT = CntT + 1;
      #end // while
      #local CntW = CntW + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapW)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntT = 0;
      #while (CntT < LastT)
        Sphere(Points4A3D[LastU][CntV][LastW][CntT], Radius)
        #local CntT = CntT + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapT)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        Sphere(Points4A3D[LastU][CntV][CntW][LastT], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntT = 0;
      #while (CntT < LastT)
        Sphere(Points4A3D[CntU][LastV][LastW][CntT], Radius)
        #local CntT = CntT + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntW = 0;
      #while (CntW < LastW)
        Sphere(Points4A3D[CntU][CntV][CntW][CntT], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapW & !WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        Sphere(Points4A3D[CntU][CntV][LastW][LastT], Radius)
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV & !WrapW)
    #local CntT = 0;
    #while (CntT < LastT)
      Sphere(Points4A3D[LastU][LastV][LastW][CntT], Radius)
      #local CntT = CntT + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV & !WrapT)
    #local CntW = 0;
    #while (CntW < LastW)
      Sphere(Points4A3D[LastU][LastV][CntW][LastT], Radius)
      #local CntW = CntW + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapW & !WrapT)
    #local CntV = 0;
    #while (CntV < LastV)
      Sphere(Points4A3D[LastU][CntV][LastW][LastT], Radius)
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapW & !WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      Sphere(Points4A3D[CntU][LastV][LastW][LastT], Radius)
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV & !WrapW & !WrapT)
    Sphere(Points4A3D[LastU][LastV][LastW][LastT], Radius)
  #end // if

#end // macro ShowPoints4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro ShowLines1A3D(Points1A3D, Radius)

  #local SizeU = Size1A(Points1A3D);
  #local LastU = SizeU - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    Cylinder(Points1A3D[CntU], Points1A3D[CntU+1], Radius)
    #local CntU = CntU + 1;
  #end // while

#end // macro ShowLines1A3D



#macro ShowLines2A3D(Points2A3D, WrapUV, Radius)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local WrapU = WrapUV.u;
  #local WrapV = WrapUV.v;
  #local LastU = SizeU - 1;
  #local LastV = SizeV - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    #local CntV = 0;
    #while (CntV < LastV)
      Cylinder(Points2A3D[CntU][CntV], Points2A3D[CntU+1][CntV  ], Radius)
      Cylinder(Points2A3D[CntU][CntV], Points2A3D[CntU  ][CntV+1], Radius)
      #local CntV = CntV + 1;
    #end // while
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    #local CntV = 0;
    #while (CntV < LastV)
      Cylinder(Points2A3D[LastU][CntV], Points2A3D[LastU][CntV+1], Radius)
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV)
    #local CntU = 0;
    #while (CntU < LastU)
      Cylinder(Points2A3D[CntU][LastV], Points2A3D[CntU+1][LastV], Radius)
      #local CntU = CntU + 1;
    #end // while
  #end // if

#end // macro ShowLines2A3D



#macro ShowLines3A3D(Points3A3D, WrapUVW, Radius)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local WrapU = WrapUVW.x;
  #local WrapV = WrapUVW.y;
  #local WrapW = WrapUVW.z;
  #local LastU = SizeU - 1;
  #local LastV = SizeV - 1;
  #local LastW = SizeW - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        Cylinder(Points3A3D[CntU][CntV][CntW], Points3A3D[CntU+1][CntV  ][CntW  ], Radius)
        Cylinder(Points3A3D[CntU][CntV][CntW], Points3A3D[CntU  ][CntV+1][CntW  ], Radius)
        Cylinder(Points3A3D[CntU][CntV][CntW], Points3A3D[CntU  ][CntV  ][CntW+1], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        Cylinder(Points3A3D[LastU][CntV][CntW], Points3A3D[LastU][CntV+1][CntW  ], Radius)
        Cylinder(Points3A3D[LastU][CntV][CntW], Points3A3D[LastU][CntV  ][CntW+1], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntW = 0;
      #while (CntW < LastW)
        Cylinder(Points3A3D[CntU][LastV][CntW], Points3A3D[CntU+1][LastV][CntW  ], Radius)
        Cylinder(Points3A3D[CntU][LastV][CntW], Points3A3D[CntU  ][LastV][CntW+1], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        Cylinder(Points3A3D[CntU][CntV][LastW], Points3A3D[CntU+1][CntV  ][LastW], Radius)
        Cylinder(Points3A3D[CntU][CntV][LastW], Points3A3D[CntU  ][CntV+1][LastW], Radius)
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV)
    #local CntW = 0;
    #while (CntW < LastW)
      Cylinder(Points3A3D[LastU][LastV][CntW], Points3A3D[LastU][LastV][CntW+1], Radius)
      #local CntW = CntW + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapW)
    #local CntV = 0;
    #while (CntV < LastV)
      Cylinder(Points3A3D[LastU][CntV][LastW], Points3A3D[LastU][CntV+1][LastW], Radius)
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      Cylinder(Points3A3D[CntU][LastV][LastW], Points3A3D[CntU+1][LastV][LastW], Radius)
      #local CntU = CntU + 1;
    #end // while
  #end // if

#end // macro ShowLines3A3D



#macro ShowLines4A3D(Points4A3D, WrapUVWT, Radius)

  #local SizeUVWT = Size4A(Points4A3D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local WrapU = WrapUVWT.x;
  #local WrapV = WrapUVWT.y;
  #local WrapW = WrapUVWT.z;
  #local WrapT = WrapUVWT.t;
  #local LastU = SizeU - 1;
  #local LastV = SizeV - 1;
  #local LastW = SizeW - 1;
  #local LastT = SizeT - 1;

  #local CntU = 0;
  #while (CntU < LastU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        #local CntT = 0;
        #while (CntT < LastT)
          Cylinder(Points4A3D[CntU][CntV][CntW][CntT], Points4A3D[CntU+1][CntV  ][CntW  ][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][CntV][CntW][CntT], Points4A3D[CntU  ][CntV+1][CntW  ][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][CntV][CntW][CntT], Points4A3D[CntU  ][CntV  ][CntW+1][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][CntV][CntW][CntT], Points4A3D[CntU  ][CntV  ][CntW  ][CntT+1], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
    #local CntU = CntU + 1;
  #end // while

  #if (!WrapU)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        #local CntT = 0;
        #while (CntT < LastT)
          Cylinder(Points4A3D[LastU][CntV][CntW][CntT], Points4A3D[LastU][CntV+1][CntW  ][CntT  ], Radius)
          Cylinder(Points4A3D[LastU][CntV][CntW][CntT], Points4A3D[LastU][CntV  ][CntW+1][CntT  ], Radius)
          Cylinder(Points4A3D[LastU][CntV][CntW][CntT], Points4A3D[LastU][CntV  ][CntW  ][CntT+1], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntW = 0;
      #while (CntW < LastW)
        #local CntT = 0;
        #while (CntT < LastT)
          Cylinder(Points4A3D[CntU][LastV][CntW][CntT], Points4A3D[CntU+1][LastV][CntW  ][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][LastV][CntW][CntT], Points4A3D[CntU  ][LastV][CntW+1][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][LastV][CntW][CntT], Points4A3D[CntU  ][LastV][CntW  ][CntT+1], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntW = CntW + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        #local CntT = 0;
        #while (CntT < LastT)
          Cylinder(Points4A3D[CntU][CntV][LastW][CntT], Points4A3D[CntU+1][CntV  ][LastW][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][CntV][LastW][CntT], Points4A3D[CntU  ][CntV+1][LastW][CntT  ], Radius)
          Cylinder(Points4A3D[CntU][CntV][LastW][CntT], Points4A3D[CntU  ][CntV  ][LastW][CntT+1], Radius)
          #local CntT = CntT + 1;
        #end // while
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        #local CntW = 0;
        #while (CntW < LastW)
          Cylinder(Points4A3D[CntU][CntV][CntW][LastT], Points4A3D[CntU+1][CntV  ][CntW  ][LastT], Radius)
          Cylinder(Points4A3D[CntU][CntV][CntW][LastT], Points4A3D[CntU  ][CntV+1][CntW  ][LastT], Radius)
          Cylinder(Points4A3D[CntU][CntV][CntW][LastT], Points4A3D[CntU  ][CntV  ][CntW+1][LastT], Radius)
          #local CntW = CntW + 1;
        #end // while
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapW & !WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntV = 0;
      #while (CntV < LastV)
        Cylinder(Points4A3D[CntU][CntV][LastW][LastT], Points4A3D[CntU+1][CntV  ][LastW][LastT], Radius)
        Cylinder(Points4A3D[CntU][CntV][LastW][LastT], Points4A3D[CntU  ][CntV+1][LastW][LastT], Radius)
        #local CntV = CntV + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV)
    #local CntW = 0;
    #while (CntW < LastW)
      #local CntT = 0;
      #while (CntT < LastT)
        Cylinder(Points4A3D[LastU][LastV][CntW][CntT], Points4A3D[LastU][LastV][CntW+1][CntT  ], Radius)
        Cylinder(Points4A3D[LastU][LastV][CntW][CntT], Points4A3D[LastU][LastV][CntW  ][CntT+1], Radius)
        #local CntT = CntT + 1;
      #end // while
      #local CntW = CntW + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapW)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntT = 0;
      #while (CntT < LastT)
        Cylinder(Points4A3D[LastU][CntV][LastW][CntT], Points4A3D[LastU][CntV+1][LastW][CntT  ], Radius)
        Cylinder(Points4A3D[LastU][CntV][LastW][CntT], Points4A3D[LastU][CntV  ][LastW][CntT+1], Radius)
        #local CntT = CntT + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapT)
    #local CntV = 0;
    #while (CntV < LastV)
      #local CntW = 0;
      #while (CntW < LastW)
        Cylinder(Points4A3D[LastU][CntV][CntW][LastT], Points4A3D[LastU][CntV+1][CntW  ][LastT], Radius)
        Cylinder(Points4A3D[LastU][CntV][CntW][LastT], Points4A3D[LastU][CntV  ][CntW+1][LastT], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapW)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntT = 0;
      #while (CntT < LastT)
        Cylinder(Points4A3D[CntU][LastV][LastW][CntT], Points4A3D[CntU+1][LastV][LastW][CntT  ], Radius)
        Cylinder(Points4A3D[CntU][LastV][LastW][CntT], Points4A3D[CntU  ][LastV][LastW][CntT+1], Radius)
        #local CntT = CntT + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      #local CntW = 0;
      #while (CntW < LastW)
        Cylinder(Points4A3D[CntU][LastV][CntW][LastT], Points4A3D[CntU+1][LastV][CntW  ][LastT], Radius)
        Cylinder(Points4A3D[CntU][LastV][CntW][LastT], Points4A3D[CntU  ][LastV][CntW+1][LastT], Radius)
        #local CntW = CntW + 1;
      #end // while
      #local CntU = CntU + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV & !WrapW)
    #local CntT = 0;
    #while (CntT < LastT)
      Cylinder(Points4A3D[LastU][LastV][LastW][CntT], Points4A3D[LastU][LastV][LastW][CntT+1], Radius)
      #local CntT = CntT + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapV & !WrapT)
    #local CntW = 0;
    #while (CntW < LastW)
      Cylinder(Points4A3D[LastU][LastV][CntW][LastT], Points4A3D[LastU][LastV][CntW+1][LastT], Radius)
      #local CntW = CntW + 1;
    #end // while
  #end // if

  #if (!WrapU & !WrapW & !WrapT)
    #local CntV = 0;
    #while (CntV < LastV)
      Cylinder(Points4A3D[LastU][CntV][LastW][LastT], Points4A3D[LastU][CntV+1][LastW][LastT], Radius)
      #local CntV = CntV + 1;
    #end // while
  #end // if

  #if (!WrapV & !WrapW & !WrapT)
    #local CntU = 0;
    #while (CntU < LastU)
      Cylinder(Points4A3D[CntU][LastV][LastW][LastT], Points4A3D[CntU+1][LastV][LastW][LastT], Radius)
      #local CntU = CntU + 1;
    #end // while
  #end // if

#end // macro ShowLines4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro ShowGrid1A3D(Points1A3D, WrapU, Radius)

  ShowPoints1A3D(Points1A3D, WrapU, Radius)
  ShowLines1A3D(Points1A3D, Radius)

#end // macro ShowGrid1A3D



#macro ShowGrid2A3D(Points2A3D, WrapUV, Radius)

  ShowPoints2A3D(Points2A3D, WrapUV, Radius)
  ShowLines2A3D(Points2A3D, WrapUV, Radius)

#end // macro ShowGrid2A3D



#macro ShowGrid3A3D(Points3A3D, WrapUVW, Radius)

  ShowPoints3A3D(Points3A3D, WrapUVW, Radius)
  ShowLines3A3D(Points3A3D, WrapUVW, Radius)

#end // macro ShowGrid3A3D



#macro ShowGrid4A3D(Points4A3D, WrapUVWT, Radius)

  ShowPoints4A3D(Points4A3D, WrapUVWT, Radius)
  ShowLines4A3D(Points4A3D, WrapUVWT, Radius)

#end // macro ShowGrid4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro ShowFunctions1A3D(xFn, yFn, zFn, WrapU, MinU, MaxU, ResU, Radius)

  #if (ResU = 0)
    #local dU = 0;
  #else
    #local dU = (MaxU - MinU)/ResU;
  #end // if
  #local NrI = ResU + (WrapU ? 0 : 1); // ?

  #if (dU != 0)
    #local I = 0;
    #local pT = <xFn(MinU), yFn(MinU), zFn(MinU)>;
    Sphere(pT, Radius)
    #while (I < ResU) // ?
      #local pF = pT;
      #local NextI = I + 1;
      #local NextU = MinU + NextI*dU;
      #local pT = <xFn(NextU), yFn(NextU), zFn(NextU)>;
      Cylinder(pF, pT, Radius)
      Sphere(pT, Radius)
      #local I = NextI;
    #end // while
  #else
    Sphere(<xFn(MinU), yFn(MinU), zFn(MinU)>, Radius)
  #end // if

#end // macro ShowFunctions1A3D



#macro ShowFunctions1A3D(xFn, yFn, zFn, WrapU, MinU, MaxU, ResU, Radius)

  #if (ResU = 0)
    #local dU = 0;
  #else
    #local dU = (MaxU - MinU)/ResU;
  #end // if
//  #local NrI = ResU + (WrapU ? 0 : 1); // ?

  #local pT = <xFn(MinU), yFn(MinU), zFn(MinU)>;
  #if (dU != 0)
    #local I = 0;
    #while (I < ResU + 1)
      #local U = MinU + I*dU;
      #local pF = pT;
      #local pT = <xFn(U), yFn(U), zFn(U)>;
      Sphere(pF, Radius)
      Cylinder(pF, pT, Radius)
      #local I = I + 1;
    #end // while
    #if (!WrapU)
      Sphere(pT, Radius)
    #end // if
  #else
    Sphere(pT, Radius)
  #end // if

#end // macro ShowFunctions1A3D



#macro ShowFunctions2A3D(xFn, yFn, zFn, WrapUV, MinUV, MaxUV, DivUV, ResUV, Radius)

  #local WrapU = WrapUV.u;
  #local WrapV = WrapUV.v;
  #local MinU = MinUV.u;
  #local MinV = MinUV.v;
  #local MaxU = MaxUV.u;
  #local MaxV = MaxUV.v;
  #local DivU = DivUV.u;
  #local DivV = DivUV.v;
  #local ResU = ResUV.u;
  #local ResV = ResUV.v;
  #if (DivU = 0)
    #local dU = 0;
  #else
    #local dU = (MaxU - MinU)/DivU;
  #end // if
  #if (DivV = 0)
    #local dV = 0;
  #else
    #local dV = (MaxV - MinV)/DivV;
  #end // if
  #local NrI = DivU + (WrapU ? 0 : 1);
  #local NrJ = DivV + (WrapV ? 0 : 1);

  #if (dU != 0 & dV != 0)
    #local I = 0;
    #while (I < NrI)
      #local U = MinU + I*dU;
      ShowFunctions1A3D(
        function(VV) { xFn(U, VV) },
        function(VV) { yFn(U, VV) },
        function(VV) { zFn(U, VV) },
        WrapV,
        MinV, MaxV,
        ResV, Radius
      )
      #local I = I + 1;
    #end // while

    #local J = 0;
    #while (J < NrJ)
      #local V = MinV + J*dV;
      ShowFunctions1A3D(
        function(UU) { xFn(UU, V) },
        function(UU) { yFn(UU, V) },
        function(UU) { zFn(UU, V) },
        WrapU,
        MinU, MaxU,
        ResU, Radius
      )
      #local J = J + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV = 0)
    ShowFunctions1A3D(
      function(UU) { xFn(UU, MinV) },
      function(UU) { yFn(UU, MinV) },
      function(UU) { zFn(UU, MinV) },
      WrapU,
      MinU, MaxU,
      ResU, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0)
    ShowFunctions1A3D(
      function(VV) { xFn(MinU, VV) },
      function(VV) { yFn(MinU, VV) },
      function(VV) { zFn(MinU, VV) },
      WrapV,
      MinV, MaxV,
      ResV, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0)
    Sphere(
      <
        xFn(MinU, MinV),
        yFn(MinU, MinV),
        zFn(MinU, MinV)
      >,
      Radius
    )
  #end // if

#end // macro ShowFunctions2A3D



#macro ShowFunctions3A3D(xFn, yFn, zFn, WrapUVW, MinUVW, MaxUVW, DivUVW, ResUVW, Radius)

  #local WrapU = WrapUVW.x;
  #local WrapV = WrapUVW.y;
  #local WrapW = WrapUVW.z;
  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local ResU = ResUVW.x;
  #local ResV = ResUVW.y;
  #local ResW = ResUVW.z;
  #if (DivU = 0)
    #local dU = 0;
  #else
    #local dU = (MaxU - MinU)/DivU;
  #end // if
  #if (DivV = 0)
    #local dV = 0;
  #else
    #local dV = (MaxV - MinV)/DivV;
  #end // if
  #if (DivW = 0)
    #local dW = 0;
  #else
    #local dW = (MaxW - MinW)/DivW;
  #end // if
  #local NrI = DivU + (WrapU ? 0 : 1);
  #local NrJ = DivV + (WrapV ? 0 : 1);
  #local NrK = DivW + (WrapW ? 0 : 1);

  #if (dU != 0 & dV != 0 & dW != 0)
    #local I = 0;
    #while (I < NrI)
      #local U = MinU + I*dU;
      ShowFunctions2A3D(
        function(VV, WW) { xFn(U, VV, WW) },
        function(VV, WW) { yFn(U, VV, WW) },
        function(VV, WW) { zFn(U, VV, WW) },
        <WrapV, WrapW>,
        <MinV, MinW>, <MaxV, MaxW>, <DivV, DivW>,
        <ResV, ResW>, Radius
      )
      #local I = I + 1;
    #end // while

    #local J = 0;
    #while (J < NrJ)
      #local V = MinV + J*dV;
      ShowFunctions2A3D(
        function(UU, WW) { xFn(UU, V, WW) },
        function(UU, WW) { yFn(UU, V, WW) },
        function(UU, WW) { zFn(UU, V, WW) },
        <WrapU, WrapW>,
        <MinU, MinW>, <MaxU, MaxW>, <DivU, DivW>,
        <ResU, ResW>, Radius
      )
      #local J = J + 1;
    #end // while

    #local K = 0;
    #while (K < NrK)
      #local W = MinW + K*dW;
      ShowFunctions2A3D(
        function(UU, VV) { xFn(UU, VV, W) },
        function(UU, VV) { yFn(UU, VV, W) },
        function(UU, VV) { zFn(UU, VV, W) },
        <WrapU, WrapV>,
        <MinU, MinV>, <MaxU, MaxV>, <DivU, DivV>,
        <ResU, ResV>, Radius
      )
      #local K = K + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV != 0 & dW = 0)
    ShowFunctions2A3D(
      function(UU, VV) { xFn(UU, VV, MinW) },
      function(UU, VV) { yFn(UU, VV, MinW) },
      function(UU, VV) { zFn(UU, VV, MinW) },
      <WrapU, WrapV>,
      <MinU, MinV>, <MaxU, MaxV>, <DivU, DivV>,
      <ResU, ResV>, Radius
    )
  #end // if

  #if (dU != 0 & dV = 0 & dW != 0)
    ShowFunctions2A3D(
      function(UU, WW) { xFn(UU, MinV, WW) },
      function(UU, WW) { yFn(UU, MinV, WW) },
      function(UU, WW) { zFn(UU, MinV, WW) },
      <WrapU, WrapW>,
      <MinU, MinW>, <MaxU, MaxW>, <DivU, DivW>,
      <ResU, ResW>, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW != 0)
    ShowFunctions2A3D(
      function(VV, WW) { xFn(MinU, VV, WW) },
      function(VV, WW) { yFn(MinU, VV, WW) },
      function(VV, WW) { zFn(MinU, VV, WW) },
      <WrapV, WrapW>,
      <MinV, MinW>, <MaxV, MaxW>, <DivV, DivW>,
      <ResV, ResW>, Radius
    )
  #end // if

  #if (dU != 0 & dV = 0 & dW = 0)
    ShowFunctions1A3D(
      function(UU) { xFn(UU, MinV, MinW) },
      function(UU) { yFn(UU, MinV, MinW) },
      function(UU) { zFn(UU, MinV, MinW) },
      WrapU,
      MinU, MaxU, DivU,
      Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW = 0)
    ShowFunctions1A3D(
      function(VV) { xFn(MinU, VV, MinW) },
      function(VV) { yFn(MinU, VV, MinW) },
      function(VV) { zFn(MinU, VV, MinW) },
      WrapV,
      MinV, MaxV, DivV,
      Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW != 0)
    ShowFunctions1A3D(
      function(WW) { xFn(MinU, MinV, WW) },
      function(WW) { yFn(MinU, MinV, WW) },
      function(WW) { zFn(MinU, MinV, WW) },
      WrapW,
      MinW, MaxW, DivW,
      Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW = 0)
    Sphere(
      <
        xFn(MinU, MinV, MinW),
        yFn(MinU, MinV, MinW),
        zFn(MinU, MinV, MinW)
      >,
      Radius
    )
  #end // if

#end // macro ShowFunctions3A3D



#macro ShowFunctions4A3D(xFn, yFn, zFn, WrapUVWT, MinUVWT, MaxUVWT, DivUVWT, ResUVWT, Radius)

  #local WrapU = WrapUVWT.x;
  #local WrapV = WrapUVWT.y;
  #local WrapW = WrapUVWT.z;
  #local WrapT = WrapUVWT.t;
  #local MinU = MinUVWT.x;
  #local MinV = MinUVWT.y;
  #local MinW = MinUVWT.z;
  #local MinT = MinUVWT.t;
  #local MaxU = MaxUVWT.x;
  #local MaxV = MaxUVWT.y;
  #local MaxW = MaxUVWT.z;
  #local MaxT = MaxUVWT.t;
  #local DivU = DivUVWT.x;
  #local DivV = DivUVWT.y;
  #local DivW = DivUVWT.z;
  #local DivT = DivUVWT.t;
  #local ResU = ResUVWT.x;
  #local ResV = ResUVWT.y;
  #local ResW = ResUVWT.z;
  #local ResT = ResUVWT.t;
  #if (DivU = 0)
    #local dU = 0;
  #else
    #local dU = (MaxU - MinU)/DivU;
  #end // if
  #if (DivV = 0)
    #local dV = 0;
  #else
    #local dV = (MaxV - MinV)/DivV;
  #end // if
  #if (DivW = 0)
    #local dW = 0;
  #else
    #local dW = (MaxW - MinW)/DivW;
  #end // if
  #if (DivT = 0)
    #local dT = 0;
  #else
    #local dT = (MaxT - MinT)/DivT;
  #end // if
//  #local NrI = DivU + (WrapU ? 0 : 1);
//  #local NrJ = DivV + (WrapV ? 0 : 1);
//  #local NrK = DivW + (WrapW ? 0 : 1);
//  #local NrL = DivT + (WrapT ? 0 : 1);

  #if (dU != 0 & dV != 0 & dW != 0 & dT != 0)
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      ShowFunctions3A3D(
        function(VV, WW, TT) { xFn(U, VV, WW, TT) },
        function(VV, WW, TT) { yFn(U, VV, WW, TT) },
        function(VV, WW, TT) { zFn(U, VV, WW, TT) },
        <WrapV, WrapW, WrapT>,
        <MinV, MinW, MinT>, <MaxV, MaxW, MaxT>, <DivV, DivW, DivT>,
        <ResV, ResW, ResT>, Radius
      )
      #local I = I + 1;
    #end // while

    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      ShowFunctions3A3D(
        function(UU, WW, TT) { xFn(UU, V, WW, TT) },
        function(UU, WW, TT) { yFn(UU, V, WW, TT) },
        function(UU, WW, TT) { zFn(UU, V, WW, TT) },
        <WrapU, WrapW, WrapT>,
        <MinU, MinW, MinT>, <MaxU, MaxW, MaxT>, <DivU, DivW, DivT>,
        <ResU, ResW, ResT>, Radius
      )
      #local J = J + 1;
    #end // while

    #local K = 0;
    #while (K < DivW + 1)
      #local W = MinW + K*dW;
      ShowFunctions3A3D(
        function(UU, VV, TT) { xFn(UU, VV, W, TT) },
        function(UU, VV, TT) { yFn(UU, VV, W, TT) },
        function(UU, VV, TT) { zFn(UU, VV, W, TT) },
        <WrapU, WrapV, WrapT>,
        <MinU, MinV, MinT>, <MaxU, MaxV, MaxT>, <DivU, DivV, DivT>,
        <ResU, ResV, ResT>, Radius
      )
      #local K = K + 1;
    #end // while

    #local L = 0;
    #while (L < DivT + 1)
      #local T = MinT + L*dT;
      ShowFunctions3A3D(
        function(UU, VV, WW) { xFn(UU, VV, WW, T) },
        function(UU, VV, WW) { yFn(UU, VV, WW, T) },
        function(UU, VV, WW) { zFn(UU, VV, WW, T) },
        <WrapU, WrapV, WrapW>,
        <MinU, MinV, MinW>, <MaxU, MaxV, MaxW>, <DivU, DivV, DivW>,
        <ResU, ResV, ResW>, Radius
      )
      #local L = L + 1;
    #end // while
  #end // if

  #if (dU = 0 & dV != 0 & dW != 0 & dT != 0)
    ShowFunctions3A3D(
      function(VV, WW, TT) { xFn(MinU, VV, WW, TT) },
      function(VV, WW, TT) { yFn(MinU, VV, WW, TT) },
      function(VV, WW, TT) { zFn(MinU, VV, WW, TT) },
      <WrapV, WrapW, WrapT>,
      <MinV, MinW, MinT>, <MaxV, MaxW, MaxT>, <DivV, DivW, DivT>,
      <ResV, ResW, ResT>, Radius
    )
  #end // if

  #if (dU != 0 & dV = 0 & dW != 0 & dT != 0)
    ShowFunctions3A3D(
      function(UU, WW, TT) { xFn(UU, MinV, WW, TT) },
      function(UU, WW, TT) { yFn(UU, MinV, WW, TT) },
      function(UU, WW, TT) { zFn(UU, MinV, WW, TT) },
      <WrapU, WrapW, WrapT>,
      <MinU, MinW, MinT>, <MaxU, MaxW, MaxT>, <DivU, DivW, DivT>,
      <ResU, ResW, ResT>, Radius
    )
  #end // if

  #if (dU != 0 & dV != 0 & dW = 0 & dT != 0)
    ShowFunctions3A3D(
      function(UU, VV, TT) { xFn(UU, VV, MinW, TT) },
      function(UU, VV, TT) { yFn(UU, VV, MinW, TT) },
      function(UU, VV, TT) { zFn(UU, VV, MinW, TT) },
      <WrapU, WrapV, WrapT>,
      <MinU, MinV, MinT>, <MaxU, MaxV, MaxT>, <DivU, DivV, DivT>,
      <ResU, ResV, ResT>, Radius
    )
  #end // if

  #if (dU != 0 & dV != 0 & dW != 0 & dT = 0)
    ShowFunctions3A3D(
      function(UU, VV, WW) { xFn(UU, VV, WW, MinT) },
      function(UU, VV, WW) { yFn(UU, VV, WW, MinT) },
      function(UU, VV, WW) { zFn(UU, VV, WW, MinT) },
      <WrapU, WrapV, WrapW>,
      <MinU, MinV, MinW>, <MaxU, MaxV, MaxW>, <DivU, DivV, DivW>,
      <ResU, ResV, ResW>, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW != 0 & dT != 0)
    ShowFunctions2A3D(
      function(WW, TT) { xFn(MinU, MinV, WW, TT) },
      function(WW, TT) { yFn(MinU, MinV, WW, TT) },
      function(WW, TT) { zFn(MinU, MinV, WW, TT) },
      <WrapW, WrapT>,
      <MinW, MinT>, <MaxW, MaxT>, <DivW, DivT>,
      <ResW, ResT>, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW = 0 & dT != 0)
    ShowFunctions2A3D(
      function(VV, TT) { xFn(MinU, VV, MinW, TT) },
      function(VV, TT) { yFn(MinU, VV, MinW, TT) },
      function(VV, TT) { zFn(MinU, VV, MinW, TT) },
      <WrapV, WrapT>,
      <MinV, MinT>, <MaxV, MaxT>, <DivV, DivT>,
      <ResV, ResT>, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW != 0 & dT = 0)
    ShowFunctions2A3D(
      function(VV, WW) { xFn(MinU, VV, WW, MinT) },
      function(VV, WW) { yFn(MinU, VV, WW, MinT) },
      function(VV, WW) { zFn(MinU, VV, WW, MinT) },
      <WrapV, WrapW>,
      <MinV, MinW>, <MaxV, MaxW>, <DivV, DivW>,
      <ResV, ResW>, Radius
    )
  #end // if

  #if (dU != 0 & dV = 0 & dW = 0 & dT != 0)
    ShowFunctions2A3D(
      function(UU, TT) { xFn(UU, MinV, MinW, TT) },
      function(UU, TT) { yFn(UU, MinV, MinW, TT) },
      function(UU, TT) { zFn(UU, MinV, MinW, TT) },
      <WrapU, WrapT>,
      <MinU, MinT>, <MaxU, MaxT>, <DivU, DivT>,
      <ResU, ResT>, Radius
    )
  #end // if

  #if (dU != 0 & dV = 0 & dW != 0 & dT = 0)
    ShowFunctions2A3D(
      function(UU, WW) { xFn(UU, MinV, WW, MinT) },
      function(UU, WW) { yFn(UU, MinV, WW, MinT) },
      function(UU, WW) { zFn(UU, MinV, WW, MinT) },
      <WrapU, WrapW>,
      <MinU, MinW>, <MaxU, MaxW>, <DivU, DivW>,
      <ResU, ResW>, Radius
    )
  #end // if

  #if (dU != 0 & dV != 0 & dW = 0 & dT = 0)
    ShowFunctions2A3D(
      function(UU, VV) { xFn(UU, VV, MinW, MinT) },
      function(UU, VV) { yFn(UU, VV, MinW, MinT) },
      function(UU, VV) { zFn(UU, VV, MinW, MinT) },
      <WrapU, WrapV>,
      <MinU, MinV>, <MaxU, MaxV>, <DivU, DivV>,
      <ResU, ResV>, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW = 0 & dT != 0)
    ShowFunctions1A3D(
      function(TT) { xFn(MinU, MinV, MinW, TT) },
      function(TT) { yFn(MinU, MinV, MinW, TT) },
      function(TT) { zFn(MinU, MinV, MinW, TT) },
      WrapT,
      MinT, MaxT,
      ResT, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW != 0 & dT = 0)
    ShowFunctions1A3D(
      function(WW) { xFn(MinU, MinV, WW, MinT) },
      function(WW) { yFn(MinU, MinV, WW, MinT) },
      function(WW) { zFn(MinU, MinV, WW, MinT) },
      WrapW,
      MinW, MaxW,
      ResW, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW = 0 & dT = 0)
    ShowFunctions1A3D(
      function(VV) { xFn(MinU, VV, MinW, MinT) },
      function(VV) { yFn(MinU, VV, MinW, MinT) },
      function(VV) { zFn(MinU, VV, MinW, MinT) },
      WrapV,
      MinV, MaxV,
      ResV, Radius
    )
  #end // if

  #if (dU != 0 & dV = 0 & dW = 0 & dT = 0)
    ShowFunctions1A3D(
      function(UU) { xFn(UU, MinV, MinW, MinT) },
      function(UU) { yFn(UU, MinV, MinW, MinT) },
      function(UU) { zFn(UU, MinV, MinW, MinT) },
      WrapU,
      MinU, MaxU,
      ResU, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW = 0 & dT = 0)
    Sphere(
      <
        xFn(MinU, MinV, MinW, MinT),
        yFn(MinU, MinV, MinW, MinT),
        zFn(MinU, MinV, MinW, MinT)
      >,
      Radius
    )
  #end // if

#end // macro ShowFunctions4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro ShowFunctions3A3D(xFn, yFn, zFn, WrapUVW, MinUVW, MaxUVW, DivUVW, ResUVW, Radius)

  #local WrapU = WrapUVW.x;
  #local WrapV = WrapUVW.y;
  #local WrapW = WrapUVW.z;
  #local MinU = MinUVW.x;
  #local MinV = MinUVW.y;
  #local MinW = MinUVW.z;
  #local MaxU = MaxUVW.x;
  #local MaxV = MaxUVW.y;
  #local MaxW = MaxUVW.z;
  #local DivU = DivUVW.x;
  #local DivV = DivUVW.y;
  #local DivW = DivUVW.z;
  #local ResU = ResUVW.x;
  #local ResV = ResUVW.y;
  #local ResW = ResUVW.z;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local NrI = DivU + (WrapU ? 0 : 1);
  #local NrJ = DivV + (WrapV ? 0 : 1);
  #local NrK = DivW + (WrapW ? 0 : 1);

  #if (dU != 0 & dV != 0 & dW != 0)
    #local J = 0;
    #while (J < NrJ)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < NrK)
        #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(UU) { xFn(UU, V, W) },
          function(UU) { yFn(UU, V, W) },
          function(UU) { zFn(UU, V, W) },
          WrapU, MinU, MaxU,
          ResU, Radius
        )
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while

    #local I = 0;
    #while (I < NrI)
      #local U = MinU + I*dU;
      #local K = 0;
      #while (K < NrK)
        #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(VV) { xFn(U, VV, W) },
          function(VV) { yFn(U, VV, W) },
          function(VV) { zFn(U, VV, W) },
          WrapV, MinV, MaxV,
          ResV, Radius
        )
        #local K = K + 1;
      #end // while
      #local I = I + 1;
    #end // while

    #local I = 0;
    #while (I < NrI)
      #local U = MinU + I*dU;
      #local J = 0;
      #while (J < NrJ)
        #local V = MinV + J*dV;
        ShowFunctions1A3D(
          function(WW) { xFn(U, V, WW) },
          function(WW) { yFn(U, V, WW) },
          function(WW) { zFn(U, V, WW) },
          WrapW, MinW, MaxW,
          ResW, Radius
        )
        #local J = J + 1;
      #end // while
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV != 0 & dW = 0)
    #local J = 0;
    #while (J < NrJ)
      #local V = MinV + J*dV;
      ShowFunctions1A3D(
        function(UU) { xFn(UU, V, MinW) },
        function(UU) { yFn(UU, V, MinW) },
        function(UU) { zFn(UU, V, MinW) },
        WrapU, MinU, MaxU,
        ResU, Radius
      )
      #local J = J + 1;
    #end // while

    #local I = 0;
    #while (I < NrI)
      #local U = MinU + I*dU;
      ShowFunctions1A3D(
        function(VV) { xFn(U, VV, MinW) },
        function(VV) { yFn(U, VV, MinW) },
        function(VV) { zFn(U, VV, MinW) },
        WrapV, MinV, MaxV,
        ResV, Radius
      )
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV = 0 & dW != 0)
    #local K = 0;
    #while (K < NrK)
      #local W = MinW + K*dW;
      ShowFunctions1A3D(
        function(UU) { xFn(UU, MinV, W) },
        function(UU) { yFn(UU, MinV, W) },
        function(UU) { zFn(UU, MinV, W) },
        WrapU, MinU, MaxU,
        ResU, Radius
      )
      #local K = K + 1;
    #end // while

    #local I = 0;
    #while (I < NrI)
      #local U = MinU + I*dU;
      ShowFunctions1A3D(
        function(WW) { xFn(U, MinV, WW) },
        function(WW) { yFn(U, MinV, WW) },
        function(WW) { zFn(U, MinV, WW) },
        WrapW, MinW, MaxW,
        ResW, Radius
      )
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU = 0 & dV != 0 & dW != 0)
    #local K = 0;
    #while (K < NrK)
      #local W = MinW + K*dW;
      ShowFunctions1A3D(
        function(VV) { xFn(MinU, VV, W) },
        function(VV) { yFn(MinU, VV, W) },
        function(VV) { zFn(MinU, VV, W) },
        WrapV, MinV, MaxV,
        ResV, Radius
      )
      #local K = K + 1;
    #end // while

    #local J = 0;
    #while (J < NrJ)
      #local V = MinV + J*dV;
      ShowFunctions1A3D(
        function(WW) { xFn(MinU, V, WW) },
        function(WW) { yFn(MinU, V, WW) },
        function(WW) { zFn(MinU, V, WW) },
        WrapW, MinW, MaxW,
        ResW, Radius
      )
      #local J = J + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV = 0 & dW = 0)
    ShowFunctions1A3D(
      function(UU) { xFn(UU, MinV, MinW) },
      function(UU) { yFn(UU, MinV, MinW) },
      function(UU) { zFn(UU, MinV, MinW) },
      WrapU, MinU, MaxU,
      ResU, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW = 0)
    ShowFunctions1A3D(
      function(VV) { xFn(MinU, VV, MinW) },
      function(VV) { yFn(MinU, VV, MinW) },
      function(VV) { zFn(MinU, VV, MinW) },
      WrapV, MinV, MaxV,
      ResV, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW != 0)
    ShowFunctions1A3D(
      function(WW) { xFn(MinU, MinV, WW) },
      function(WW) { yFn(MinU, MinV, WW) },
      function(WW) { zFn(MinU, MinV, WW) },
      WrapW, MinW, MaxW,
      ResW, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW = 0)
    Sphere(
      <
        xFn(MinU, MinV, MinW),
        yFn(MinU, MinV, MinW),
        zFn(MinU, MinV, MinW)
      >,
      Radius
    )
  #end // if

#end // macro ShowFunctions3A3D



#macro ShowFunctions4A3D(xFn, yFn, zFn, WrapUVWT, MinUVWT, MaxUVWT, DivUVWT, ResUVWT, Radius)

  #local WrapU = WrapUVWT.x;
  #local WrapV = WrapUVWT.y;
  #local WrapW = WrapUVWT.z;
  #local WrapT = WrapUVWT.t;
  #local MinU = MinUVWT.x;
  #local MinV = MinUVWT.y;
  #local MinW = MinUVWT.z;
  #local MinT = MinUVWT.t;
  #local MaxU = MaxUVWT.x;
  #local MaxV = MaxUVWT.y;
  #local MaxW = MaxUVWT.z;
  #local MaxT = MaxUVWT.t;
  #local DivU = DivUVWT.x;
  #local DivV = DivUVWT.y;
  #local DivW = DivUVWT.z;
  #local DivT = DivUVWT.t;
  #local ResU = ResUVWT.x;
  #local ResV = ResUVWT.y;
  #local ResW = ResUVWT.z;
  #local ResT = ResUVWT.t;
  #local dU = (MaxU - MinU)/DivU;
  #local dV = (MaxV - MinV)/DivV;
  #local dW = (MaxW - MinW)/DivW;
  #local dT = (MaxT - MinT)/DivT;
//  #local NrI = DivU + (WrapU ? 0 : 1);
//  #local NrJ = DivV + (WrapV ? 0 : 1);
//  #local NrK = DivW + (WrapW ? 0 : 1);
//  #local NrL = DivT + (WrapT ? 0 : 1);

  #if (dU != 0 & dV != 0 & dW != 0 & dT != 0)
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < DivW + 1)
        #local W = MinW + K*dW;
        #local L = 0;
        #while (L < DivT + 1)
          #local T = MinT + L*dT;
          ShowFunctions1A3D(
            function(UU) { xFn(UU, V, W, T) },
            function(UU) { yFn(UU, V, W, T) },
            function(UU) { zFn(UU, V, W, T) },
            WrapU,
            MinU, MaxU,
            ResU, Radius
          )
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local K = 0;
      #while (K < DivW + 1)
        #local W = MinW + K*dW;
        #local L = 0;
        #while (L < DivT + 1)
          #local T = MinT + L*dT;
          ShowFunctions1A3D(
            function(VV) { xFn(U, VV, W, T) },
            function(VV) { yFn(U, VV, W, T) },
            function(VV) { zFn(U, VV, W, T) },
            WrapV,
            MinV, MaxV,
            ResV, Radius
          )
          #local L = L + 1;
        #end // while
        #local K = K + 1;
      #end // while
      #local I = I + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local J = 0;
      #while (J < DivV + 1)
        #local V = MinV + J*dV;
        #local L = 0;
        #while (L < DivT + 1)
          #local T = MinT + L*dT;
          ShowFunctions1A3D(
            function(WW) { xFn(U, V, WW, T) },
            function(WW) { yFn(U, V, WW, T) },
            function(WW) { zFn(U, V, WW, T) },
            WrapW,
            MinW, MaxW,
            ResW, Radius
          )
          #local L = L + 1;
        #end // while
        #local J = J + 1;
      #end // while
      #local I = I + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local J = 0;
      #while (J < DivV + 1)
        #local V = MinV + J*dV;
        #local K = 0;
        #while (K < DivW + 1)
          #local W = MinW + K*dW;
          ShowFunctions1A3D(
            function(TT) { xFn(U, V, W, TT) },
            function(TT) { yFn(U, V, W, TT) },
            function(TT) { zFn(U, V, W, TT) },
            WrapT,
            MinT, MaxT,
            ResT, Radius
          )
          #local K = K + 1;
        #end // while
        #local J = J + 1;
      #end // while
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU = 0 & dV != 0 & dW != 0 & dT != 0)
    #local K = 0;
    #while (K < DivW + 1)
      #local W = MinW + K*dW;
      #local L = 0;
      #while (L < DivT + 1)
        #local T = MinT + L*dT;
        ShowFunctions1A3D(
          function(VV) { xFn(MinU, VV, W, T) },
          function(VV) { yFn(MinU, VV, W, T) },
          function(VV) { zFn(MinU, VV, W, T) },
          WrapV,
          MinV, MaxV,
          ResV, Radius
        )
        #local L = L + 1;
      #end // while
      #local K = K + 1;
    #end // while
  
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      #local L = 0;
      #while (L < DivT + 1)
        #local T = MinT + L*dT;
        ShowFunctions1A3D(
          function(WW) { xFn(MinU, V, WW, T) },
          function(WW) { yFn(MinU, V, WW, T) },
          function(WW) { zFn(MinU, V, WW, T) },
          WrapW,
          MinW, MaxW,
          ResW, Radius
        )
        #local L = L + 1;
      #end // while
      #local J = J + 1;
    #end // while
  
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < DivW + 1)
        #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(TT) { xFn(MinU, V, W, TT) },
          function(TT) { yFn(MinU, V, W, TT) },
          function(TT) { zFn(MinU, V, W, TT) },
          MinT, MaxT, ResT,
          Radius
        )
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // if

  #if (dU != 0 & dV = 0 & dW != 0 & dT != 0)
    #local K = 0;
    #while (K < DivW + 1)
      #local W = MinW + K*dW;
      #local L = 0;
      #while (L < DivT + 1)
        #local T = MinT + L*dT;
        ShowFunctions1A3D(
          function(UU) { xFn(UU, MinV, W, T) },
          function(UU) { yFn(UU, MinV, W, T) },
          function(UU) { zFn(UU, MinV, W, T) },
          WrapU,
          MinU, MaxU,
          ResU, Radius
        )
        #local L = L + 1;
      #end // while
      #local K = K + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local L = 0;
      #while (L < DivT + 1)
        #local T = MinT + L*dT;
        ShowFunctions1A3D(
          function(WW) { xFn(U, MinV, WW, T) },
          function(WW) { yFn(U, MinV, WW, T) },
          function(WW) { zFn(U, MinV, WW, T) },
          WrapW,
          MinW, MaxW,
          ResW, Radius
        )
        #local L = L + 1;
      #end // while
      #local I = I + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local K = 0;
      #while (K < DivW + 1)
        #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(TT) { xFn(U, MinV, W, TT) },
          function(TT) { yFn(U, MinV, W, TT) },
          function(TT) { zFn(U, MinV, W, TT) },
          WrapT,
          MinT, MaxT,
          ResT, Radius
        )
        #local K = K + 1;
      #end // while
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV != 0 & dW = 0 & dT != 0)
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      #local L = 0;
      #while (L < DivT + 1)
        #local T = MinT + L*dT;
        ShowFunctions1A3D(
          function(UU) { xFn(UU, V, MinW, T) },
          function(UU) { yFn(UU, V, MinW, T) },
          function(UU) { zFn(UU, V, MinW, T) },
          WrapU,
          MinU, MaxU,
          ResU, Radius
        )
        #local L = L + 1;
      #end // while
      #local J = J + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local L = 0;
      #while (L < DivT + 1)
        #local T = MinT + L*dT;
        ShowFunctions1A3D(
          function(VV) { xFn(U, VV, MinW, T) },
          function(VV) { yFn(U, VV, MinW, T) },
          function(VV) { zFn(U, VV, MinW, T) },
          WrapV,
          MinV, MaxV,
          ResV, Radius
        )
        #local L = L + 1;
      #end // while
      #local I = I + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local J = 0;
      #while (J < DivV + 1)
        #local V = MinV + J*dV;
        ShowFunctions1A3D(
          function(TT) { xFn(U, V, MinW, TT) },
          function(TT) { yFn(U, V, MinW, TT) },
          function(TT) { zFn(U, V, MinW, TT) },
          WrapT,
          MinT, MaxT,
          ResT, Radius
        )
        #local J = J + 1;
      #end // while
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV != 0 & dW != 0 & dT = 0)
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      #local K = 0;
      #while (K < DivW + 1)
        #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(UU) { xFn(UU, V, W, MinT) },
          function(UU) { yFn(UU, V, W, MinT) },
          function(UU) { zFn(UU, V, W, MinT) },
          WrapU,
          MinU, MaxU,
          ResU, Radius
        )
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local K = 0;
      #while (K < DivW + 1)
        #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(VV) { xFn(U, VV, W, MinT) },
          function(VV) { yFn(U, VV, W, MinT) },
          function(VV) { zFn(U, VV, W, MinT) },
          WrapV,
          MinV, MaxV,
          ResV, Radius
        )
        #local K = K + 1;
      #end // while
      #local I = I + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      #local J = 0;
      #while (J < DivV + 1)
        #local V = MinV + J*dV;
        ShowFunctions1A3D(
          function(WW) { xFn(U, V, WW, MinT) },
          function(WW) { yFn(U, V, WW, MinT) },
          function(WW) { zFn(U, V, WW, MinT) },
          WrapW,
          MinW, MaxW,
          ResW, Radius
        )
        #local J = J + 1;
      #end // while
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU = 0 & dV = 0 & dW != 0 & dT != 0)
    #local L = 0;
    #while (L < DivT + 1)
      #local T = MinT + L*dT;
      ShowFunctions1A3D(
        function(WW) { xFn(MinU, MinV, WW, T) },
        function(WW) { yFn(MinU, MinV, WW, T) },
        function(WW) { zFn(MinU, MinV, WW, T) },
        WrapW,
        MinW, MaxW,
        ResW, Radius
      )
      #local L = L + 1;
    #end // while
  
    #local K = 0;
    #while (K < DivW + 1)
      #local W = MinW + K*dW;
      ShowFunctions1A3D(
        function(TT) { xFn(MinU, MinV, W, TT) },
        function(TT) { yFn(MinU, MinV, W, TT) },
        function(TT) { zFn(MinU, MinV, W, TT) },
        WrapT,
        MinT, MaxT,
        ResT, Radius
      )
      #local K = K + 1;
    #end // while
  #end // if

  #if (dU = 0 & dV != 0 & dW = 0 & dT != 0)
    #local L = 0;
    #while (L < DivT + 1)
      #local T = MinT + L*dT;
      ShowFunctions1A3D(
        function(VV) { xFn(MinU, VV, MinW, T) },
        function(VV) { yFn(MinU, VV, MinW, T) },
        function(VV) { zFn(MinU, VV, MinW, T) },
        WrapV,
        MinV, MaxV,
        ResV, Radius
      )
      #local L = L + 1;
    #end // while
  
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      ShowFunctions1A3D(
        function(TT) { xFn(MinU, V, MinW, TT) },
        function(TT) { yFn(MinU, V, MinW, TT) },
        function(TT) { zFn(MinU, V, MinW, TT) },
        WrapT,
        MinT, MaxT,
        ResT, Radius
      )
      #local J = J + 1;
    #end // while
  #end // if

  #if (dU = 0 & dV != 0 & dW != 0 & dT = 0)
    #local K = 0;
    #while (K < DivW + 1)
      #local W = MinW + K*dW;
        ShowFunctions1A3D(
          function(VV) { xFn(MinU, VV, W, MinT) },
          function(VV) { yFn(MinU, VV, W, MinT) },
          function(VV) { zFn(MinU, VV, W, MinT) },
          WrapV,
          MinV, MaxV,
          ResV, Radius
        )
      #local K = K + 1;
    #end // while
  
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      ShowFunctions1A3D(
        function(WW) { xFn(MinU, V, WW, MinT) },
        function(WW) { yFn(MinU, V, WW, MinT) },
        function(WW) { zFn(MinU, V, WW, MinT) },
        WrapW,
        MinW, MaxW,
        ResW, Radius
      )
      #local J = J + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV = 0 & dW = 0 & dT != 0)
    #local L = 0;
    #while (L < DivT + 1)
      #local T = MinT + L*dT;
      ShowFunctions1A3D(
        function(UU) { xFn(UU, MinV, MinW, T) },
        function(UU) { yFn(UU, MinV, MinW, T) },
        function(UU) { zFn(UU, MinV, MinW, T) },
        WrapU,
        MinU, MaxU,
        ResU, Radius
      )
      #local L = L + 1;
    #end // while

    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      ShowFunctions1A3D(
        function(TT) { xFn(U, MinV, MinW, TT) },
        function(TT) { yFn(U, MinV, MinW, TT) },
        function(TT) { zFn(U, MinV, MinW, TT) },
        WrapT,
        MinT, MaxT,
        ResT, Radius
      )
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV = 0 & dW != 0 & dT = 0)
    #local K = 0;
    #while (K < DivW + 1)
      #local W = MinW + K*dW;
      ShowFunctions1A3D(
        function(UU) { xFn(UU, MinV, W, MinT) },
        function(UU) { yFn(UU, MinV, W, MinT) },
        function(UU) { zFn(UU, MinV, W, MinT) },
        WrapU,
        MinU, MaxU,
        ResU, Radius
      )
      #local K = K + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      ShowFunctions1A3D(
        function(WW) { xFn(U, MinV, WW, MinT) },
        function(WW) { yFn(U, MinV, WW, MinT) },
        function(WW) { zFn(U, MinV, WW, MinT) },
        WrapW,
        MinW, MaxW,
        ResW, Radius
      )
      #local I = I + 1;
    #end // while
  #end // if


  #if (dU != 0 & dV != 0 & dW = 0 & dT = 0)
    #local J = 0;
    #while (J < DivV + 1)
      #local V = MinV + J*dV;
      ShowFunctions1A3D(
        function(UU) { xFn(UU, V, MinW, MinT) },
        function(UU) { yFn(UU, V, MinW, MinT) },
        function(UU) { zFn(UU, V, MinW, MinT) },
        WrapU,
        MinU, MaxU,
        ResU, Radius
      )
      #local J = J + 1;
    #end // while
  
    #local I = 0;
    #while (I < DivU + 1)
      #local U = MinU + I*dU;
      ShowFunctions1A3D(
        function(VV) { xFn(U, VV, MinW, MinT) },
        function(VV) { yFn(U, VV, MinW, MinT) },
        function(VV) { zFn(U, VV, MinW, MinT) },
        WrapV,
        MinV, MaxV,
        ResV, Radius
      )
      #local I = I + 1;
    #end // while
  #end // if

  #if (dU != 0 & dV = 0 & dW = 0 & dT = 0)
    ShowFunctions1A3D(
      function(UU) { xFn(UU, MinV, MinW, MinT) },
      function(UU) { yFn(UU, MinV, MinW, MinT) },
      function(UU) { zFn(UU, MinV, MinW, MinT) },
      WrapU,
      MinU, MaxU,
      ResU, Radius
    )
  #end // if

  #if (dU = 0 & dV != 0 & dW = 0 & dT = 0)
    ShowFunctions1A3D(
      function(VV) { xFn(MinU, VV, MinW, MinT) },
      function(VV) { yFn(MinU, VV, MinW, MinT) },
      function(VV) { zFn(MinU, VV, MinW, MinT) },
      WrapV,
      MinV, MaxV,
      ResV, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW != 0 & dT = 0)
    ShowFunctions1A3D(
      function(WW) { xFn(MinU, MinV, WW, MinT) },
      function(WW) { yFn(MinU, MinV, WW, MinT) },
      function(WW) { zFn(MinU, MinV, WW, MinT) },
      WrapW,
      MinW, MaxW,
      ResW, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW = 0 & dT != 0)
    ShowFunctions1A3D(
      function(TT) { xFn(MinU, MinV, MinW, TT) },
      function(TT) { yFn(MinU, MinV, MinW, TT) },
      function(TT) { zFn(MinU, MinV, MinW, TT) },
      WrapT,
      MinT, MaxT,
      ResT, Radius
    )
  #end // if

  #if (dU = 0 & dV = 0 & dW = 0 & dT = 0)
    Sphere(
      <
        xFn(MinU, MinV, MinW, MinT),
        yFn(MinU, MinV, MinW, MinT),
        zFn(MinU, MinV, MinW, MinT)
      >,
      Radius
    )
  #end // if

#end // macro ShowFunctions4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Show_URBS_1A3D(Points1A3D, Weights1A, OpenU, OrderU, WrapU, DivU, Radius)

  #local SizeU = Size1A(Points1A3D);
  #local MinU = 0;
  #local MaxU = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #local Points1Ax = ExtractComponent1A(Points1A3D, x);
  #local Points1Ay = ExtractComponent1A(Points1A3D, y);
  #local Points1Az = ExtractComponent1A(Points1A3D, z);

  ShowFunctions1A3D(
    NURBS_Function1A(OrderU, KnotsU, Points1Ax, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Points1Ay, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Points1Az, Weights1A),
    WrapU,
    MinU, MaxU, DivU,
    Radius
  )

#end // macro Show_URBS_1A3D



#macro Show_UBS_1A3D(Points1A3D, OpenU, OrderU, WrapU, DivU, Radius)

  #local Weights1A = UniformWeights1A(Size1A(Points1A3D), 1);

  Show_URBS_1A3D(Points1A3D, Weights1A, OpenU, OrderU, WrapU, DivU, Radius)

#end // macro Show_UBS_1A3D



#macro Show_URBS_2A3D(Points2A3D, Weights2A, OpenUV, OrderUV, WrapUV, DivUV, ResUV, Radius)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local OpenU = OpenUV.u;
  #local OpenV = OpenUV.v;
  #local OrderU = OrderUV.u;
  #local OrderV = OrderUV.v;
  #local WrapU = WrapUV.u;
  #local WrapV = WrapUV.v;
  #local MinUV = <0, 0>;
  #local MaxUV = <1, 1>;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV);
  #local Points2Ax = ExtractComponent2A(Points2A3D, x);
  #local Points2Ay = ExtractComponent2A(Points2A3D, y);
  #local Points2Az = ExtractComponent2A(Points2A3D, z);

  ShowFunctions2A3D(
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ax, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ay, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Az, Weights2A),
    WrapUV,
    MinUV, MaxUV, DivUV,
    ResUV, Radius
  )

#end // macro Show_URBS_2A3D



#macro Show_UBS_2A3D(Points2A3D, OpenUV, OrderUV, WrapUV, DivUV, ResUV, Radius)

  #local Weights2A = UniformWeights2A(Size2A(Points2A3D), 1);

  Show_URBS_2A3D(Points2A3D, Weights2A, OpenUV, OrderUV, WrapUV, DivUV, ResUV, Radius)

#end // macro Show_UBS_2A3D



#macro Show_URBS_3A3D(Points3A3D, Weights3A, OpenUVW, OrderUVW, WrapUVW, DivUVW, ResUVW, Radius)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local OpenU = OpenUVW.x;
  #local OpenV = OpenUVW.y;
  #local OpenW = OpenUVW.z;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local WrapU = WrapUVW.x;
  #local WrapV = WrapUVW.y;
  #local WrapW = WrapUVW.z;
  #local MinUVW = <0, 0, 0>;
  #local MaxUVW = <1, 1, 1>;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW);
  #local Points3Ax = ExtractComponent3A(Points3A3D, x);
  #local Points3Ay = ExtractComponent3A(Points3A3D, y);
  #local Points3Az = ExtractComponent3A(Points3A3D, z);

  ShowFunctions3A3D(
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ax, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ay, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Az, Weights3A),
    WrapUVW,
    MinUVW, MaxUVW, DivUVW,
    ResUVW, Radius
//    <MinU, MinV, MinW*0+0.5>, <MaxU, MaxV, MaxW*0+0.5>, DivUVW,
  )

#end // macro Show_URBS_3A3D



#macro Show_UBS_3A3D(Points3A3D, OpenUVW, OrderUVW, WrapUVW, DivUVW, ResUVW, Radius)

  #local Weights3A = UniformWeights3A(Size3A(Points3A3D), 1);

  Show_URBS_3A3D(Points3A3D, Weights3A, OpenUVW, OrderUVW, WrapUVW, DivUVW, ResUVW, Radius)

#end // macro Show_UBS_3A3D



#macro Show_URBS_4A3D(Points4A3D, Weights4A, OpenUVWT, OrderUVWT, WrapUVWT, DivUVWT, ResUVWT, Radius)

  #local SizeUVWT = Size4A(Points4A3D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local OpenU = OpenUVWT.x;
  #local OpenV = OpenUVWT.y;
  #local OpenW = OpenUVWT.z;
  #local OpenT = OpenUVWT.t;
  #local OrderU = OrderUVWT.x;
  #local OrderV = OrderUVWT.y;
  #local OrderW = OrderUVWT.z;
  #local OrderT = OrderUVWT.t;
  #local MinUVWT = <0, 0, 0, 0>;
  #local MaxUVWT = <1, 1, 1, 1>;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW);
  #local KnotsT = UniformKnotVector(OpenT, OrderT, SizeT);
  #local Points4Ax = ExtractComponent4A(Points4A3D, x);
  #local Points4Ay = ExtractComponent4A(Points4A3D, y);
  #local Points4Az = ExtractComponent4A(Points4A3D, z);

  ShowFunctions4A3D(
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ax, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ay, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Az, Weights4A),
    WrapUVWT,
    MinUVWT, MaxUVWT, DivUVWT,
    ResUVWT, Radius
  )

#end // macro Show_URBS_4A3D



#macro Show_UBS_4A3D(Points4A3D, OpenUVWT, OrderUVWT, WrapUVWT, DivUVWT, ResUVWT, Radius)

  #local Weights4A = UniformWeights4A(Size4A(Points4A3D), 1);

  Show_URBS_4A3D(Points4A3D, Weights4A, OpenUVWT, OrderUVWT, WrapUVWT, DivUVWT, ResUVWT, Radius)

#end // macro Show_UBS_4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

// 1D -------

#macro Sample_URBS_1A1D(Points1A1D, Weights1A, OpenU, OrderU, DivU)

  #local SizeU = Size1A(Points1A1D);
  #local MinU = 0;
  #local MaxU = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local Points1Ax = Points1A1D;

  SampleFunctions1A1D(
    NURBS_Function1A(OrderU, KnotsU, Points1Ax, Weights1A),
    MinU, MaxU, DivU
  )

#end // macro Sample_URBS_1A1D



#macro Sample_UBS_1A1D(Points1A1D, OpenU, OrderU, DivU)

  #local Weights1A = UniformWeights1A(Size1A(Points1A1D), 1);
  
  Sample_URBS_1A1D(Points1A1D, Weights1A, OpenU, OrderU, DivU)

#end // macro Sample_UBS_1A1D



#macro Sample_URBS_2A1D(Points2A1D, Weights2A, OpenUV, OrderUV, DivUV)

  #local SizeUV = Size2A(Points2A1D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local OpenU = OpenUV.u;
  #local OpenV = OpenUV.v;
  #local OrderU = OrderUV.u;
  #local OrderV = OrderUV.v;
  #local MinU = 0;
  #local MinV = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local Points2Ax = Points2A1D;

  SampleFunctions2A1D(
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ax, Weights2A),
    <MinU, MinV>, <MaxU, MaxV>, DivUV
  )

#end // macro Sample_URBS_2A1D



#macro Sample_UBS_2A1D(Points2A1D, OpenUV, OrderUV, DivUV)

  #local Weigths2A = UniformWeights2A(Size2A(Points2A1D), 1);

  Sample_URBS_2A1D(Points2A1D, Weigths2A, OpenUV, OrderUV, DivUV)

#end // macro Sample_UBS_2A1D



#macro Sample_URBS_3A1D(Points3A1D, Weights3A, OpenUVW, OrderUVW, DivUVW)

  #local SizeUVW = Size4A(Points3A1D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local OpenU = OpenUVW.x;
  #local OpenV = OpenUVW.y;
  #local OpenW = OpenUVW.z;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local Points3Ax = Points3A1D;

  SampleFunctions3A1D(
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ax, Weights3A),
    <MinU, MinV, MinW>, <MaxU, MaxV, MaxW>, DivUVW
  )

#end // macro Sample_URBS_3A1D



#macro Sample_UBS_3A1D(Points3A1D, OpenUVW, OrderUVW, DivUVW)

  #local Weights3A = UniformWeights3A(Size3A(Points3A1D), 1);

  Sample_URBS_3A1D(Points3A1D, Weights3A, OpenUVW, OrderUVW, DivUVW)
  
#end // macro Sample_UBS_3A1D



#macro Sample_URBS_4A1D(Points4A1D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)

  #local SizeUVWT = Size4A(Points4A1D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local OpenU = OpenUVWT.x;
  #local OpenV = OpenUVWT.y;
  #local OpenW = OpenUVWT.z;
  #local OpenT = OpenUVWT.t;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local OrderT = OrderUVW.t;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MinT = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local MaxT = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenU, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenU, OrderW, SizeW, MinW, MaxW);
  #local KnotsT = UniformKnotVector(OpenU, OrderT, SizeT, MinT, MaxT);
  #local Points4Ax = Points4A1D;

  SampleFunctions4A1D(
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ax, Weights4A),
    <MinU, MinV, MinW, MinT>, <MaxU, MaxV, MaxW, MaxT>, DivUVWT
  )

#end // macro Sample_URBS_4A1D



#macro Sample_UBS_4A1D(Points4A1D, OpenUVWT, OrderUVWT, DivUVWT)

  #local Weights4A = UniformWeights4A(Size4A(Points4A1D), 1);

  Sample_URBS_4A1D(Points4A1D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)
  
#end // macro Sample_UBS_4A1D


// 2D -------

#macro Sample_URBS_1A2D(Points1A2D, Weights1A, OpenU, OrderU, DivU)

  #local SizeU = Size1A(Points1A2D);
  #local MinU = 0;
  #local MaxU = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local Points1Ax = ExtractComponent1A(Points1A2D, u);
  #local Points1Ay = ExtractComponent1A(Points1A2D, v);

  SampleFunctions1A2D(
    NURBS_Function1A(OrderU, KnotsU, Points1Ax, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Points1Ay, Weights1A),
    MinU, MaxU, DivU
  )

#end // macro Sample_URBS_1A2D



#macro Sample_UBS_1A2D(Points1A2D, OpenU, OrderU, DivU)

  #local Weights1A = UniformWeights1A(Size1A(Points1A2D), 1);
  
  Sample_URBS_1A2D(Points1A2D, Weights1A, OpenU, OrderU, DivU)

#end // macro Sample_UBS_1A2D



#macro Sample_URBS_2A2D(Points2A2D, Weights2A, OpenUV, OrderUV, DivUV)

  #local SizeUV = Size2A(Points2A2D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local OpenU = OpenUV.u;
  #local OpenV = OpenUV.v;
  #local OrderU = OrderUV.u;
  #local OrderV = OrderUV.v;
  #local MinU = 0;
  #local MinV = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local Points2Ax = ExtractComponent2A(Points2A2D, u);
  #local Points2Ay = ExtractComponent2A(Points2A2D, v);

  SampleFunctions2A2D(
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ax, Weights2A),
    NURBS_Function2A(OrderUV, KnotsV, KnotsV, Points2Ay, Weights2A),
    <MinU, MinV>, <MaxU, MaxV>, DivUV
  )

#end // macro Sample_URBS_2A2D



#macro Sample_UBS_2A2D(Points2A2D, OpenUV, OrderUV, DivUV)

  #local Weigths2A = UniformWeights2A(Size2A(Points2A2D), 1);

  Sample_URBS_2A2D(Points2A2D, Weigths2A, OpenUV, OrderUV, DivUV)

#end // macro Sample_UBS_2A2D



#macro Sample_URBS_3A2D(Points3A2D, Weights3A, OpenUVW, OrderUVW, DivUVW)

  #local SizeUVW = Size4A(Points3A2D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local OpenU = OpenUVW.x;
  #local OpenV = OpenUVW.y;
  #local OpenW = OpenUVW.z;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local Points3Ax = ExtractComponent3A(Points3A2D, u);
  #local Points3Ay = ExtractComponent3A(Points3A2D, v);

  SampleFunctions3A2D(
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ax, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ay, Weights3A),
    <MinU, MinV, MinW>, <MaxU, MaxV, MaxW>, DivUVW
  )

#end // macro Sample_URBS_3A2D



#macro Sample_UBS_3A2D(Points3A2D, OpenUVW, OrderUVW, DivUVW)

  #local Weights3A = UniformWeights3A(Size3A(Points3A2D), 1);

  Sample_URBS_3A2D(Points3A2D, Weights3A, OpenUVW, OrderUVW, DivUVW)
  
#end // macro Sample_UBS_3A2D



#macro Sample_URBS_4A2D(Points4A2D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)

  #local SizeUVWT = Size4A(Points4A2D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local OpenU = OpenUVWT.x;
  #local OpenV = OpenUVWT.y;
  #local OpenW = OpenUVWT.z;
  #local OpenT = OpenUVWT.t;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local OrderT = OrderUVW.t;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MinT = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local MaxT = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local KnotsT = UniformKnotVector(OpenT, OrderT, SizeT, MinT, MaxT);
  #local Points4Ax = ExtractComponent4A(Points4A2D, u);
  #local Points4Ay = ExtractComponent4A(Points4A2D, v);

  SampleFunctions4A2D(
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ax, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ay, Weights4A),
    <MinU, MinV, MinW, MinT>, <MaxU, MaxV, MaxW, MaxT>, DivUVWT
  )

#end // macro Sample_URBS_4A2D



#macro Sample_UBS_4A2D(Points4A2D, OpenUVWT, OrderUVWT, DivUVWT)

  #local Weights4A = UniformWeights4A(Size4A(Points4A2D), 1);

  Sample_URBS_4A2D(Points4A2D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)
  
#end // macro Sample_UBS_4A2D


// 3D -------

#macro Sample_URBS_1A3D(Points1A3D, Weights1A, OpenU, OrderU, DivU)

  #local SizeU = Size1A(Points1A3D);
  #local MinU = 0;
  #local MaxU = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local Pointsx = ExtractComponent1A(Points1A3D, x);
  #local Pointsy = ExtractComponent1A(Points1A3D, y);
  #local Pointsz = ExtractComponent1A(Points1A3D, z);

  SampleFunctions1A3D(
    NURBS_Function1A(OrderU, KnotsU, Pointsx, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Pointsy, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Pointsz, Weights1A),
    MinU, MaxU, DivU
  )

#end // macro Sample_URBS_1A3D



#macro Sample_UBS_1A3D(Points1A3D, OpenU, OrderU, DivU)

  #local Weights1A = UniformWeights1A(Size1A(Points1A3D), 1);

  Sample_URBS_1A3D(Points1A3D, Weights1A, OpenU, OrderU, DivU)

#end // macro Sample_UBS_1A3D



#macro Sample_URBS_2A3D(Points2A3D, Weights2A, OpenUV, OrderUV, DivUV)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local OpenU = OpenUV.u;
  #local OpenV = OpenUV.v;
  #local OrderU = OrderUV.u;
  #local OrderV = OrderUV.v;
  #local MinU = 0;
  #local MinV = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local Points2Ax = ExtractComponent2A(Points2A3D, x);
  #local Points2Ay = ExtractComponent2A(Points2A3D, y);
  #local Points2Az = ExtractComponent2A(Points2A3D, z);

  SampleFunctions2A3D(
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ax, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ay, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Az, Weights2A),
    <MinU, MinV>, <MaxU, MaxV>, DivUV
  )

#end // macro Sample_URBS_2A3D



#macro Sample_UBS_2A3D(Points2A3D, OpenUV, OrderUV, DivUV)

  #local Weights2A = UniformWeights2A(Size2A(Points2A3D), 1);

  Sample_URBS_2A3D(Points2A3D, Weights2A, OpenUV, OrderUV, DivUV)

#end // macro Sample_UBS_2A3D



#macro Sample_URBS_3A3D(Points3A3D, Weights3A, OpenUVW, OrderUVW, DivUVW)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local OpenU = OpenUVW.x;
  #local OpenV = OpenUVW.y;
  #local OpenW = OpenUVW.z;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local Points3Ax = ExtractComponent3A(Points3A3D, x);
  #local Points3Ay = ExtractComponent3A(Points3A3D, y);
  #local Points3Az = ExtractComponent3A(Points3A3D, z);

  SampleFunctions3A3D(
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ax, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ay, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Az, Weights3A),
    <MinU, MinV, MinW>, <MaxU, MaxV, MaxW>, DivUVW
  )

#end // macro Sample_URBS_3A3D



#macro Sample_UBS_3A3D(Points3A3D, OpenUVW, OrderUVW, DivUVW)

  #local Weights3A = UniformWeights3A(Size3A(Points3A3D), 1);

  Sample_URBS_3A3D(Points3A3D, Weights3A, OpenUVW, OrderUVW, DivUVW)
  
#end // macro Sample_UBS_3A3D



#macro Sample_URBS_4A3D(Points4A3D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)

  #local SizeUVWT = Size4A(Points4A3D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local OpenU = OpenUVWT.x;
  #local OpenV = OpenUVWT.y;
  #local OpenW = OpenUVWT.z;
  #local OpenT = OpenUVWT.t;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local OrderT = OrderUVW.t;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MinT = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local MaxT = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local KnotsT = UniformKnotVector(OpenT, OrderT, SizeT, MinT, MaxT);
  #local Points4Ax = ExtractComponent4A(Points4A3D, x);
  #local Points4Ay = ExtractComponent4A(Points4A3D, y);
  #local Points4Az = ExtractComponent4A(Points4A3D, z);

  SampleFunctions4A3D(
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ax, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ay, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Az, Weights4A),
    <MinU, MinV, MinW, MinT>, <MaxU, MaxV, MaxW, MaxT>, DivUVWT
  )

#end // macro Sample_URBS_4A3D



#macro Sample_UBS_4A3D(Points4A3D, OpenUVWT, OrderUVWT, DivUVWT)

  #local Weights4A = UniformWeights4A(Size4A(Points4A3D), 1);

  Sample_URBS_4A3D(Points4A3D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)
  
#end // macro Sample_UBS_4A3D


// 4D -------

#macro Sample_URBS_1A4D(Points1A4D, Weights1A, OpenU, OrderU, DivU)

  #local SizeU = Size1A(Points1A4D);
  #local MinU = 0;
  #local MaxU = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local Points1Ax = ExtractComponent1A(Points1A4D, x);
  #local Points1Ay = ExtractComponent1A(Points1A4D, y);
  #local Points1Az = ExtractComponent1A(Points1A4D, z);
  #local Points1At = ExtractComponent1A(Points1A4D, t);

  SampleFunctions1A4D(
    NURBS_Function1A(OrderU, KnotsU, Points1Ax, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Points1Ay, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Points1Az, Weights1A),
    NURBS_Function1A(OrderU, KnotsU, Points1At, Weights1A),
    MinU, MaxU, DivU
  )

#end // macro Sample_URBS_1A4D



#macro Sample_UBS_1A4D(Points1A4D, OpenU, OrderU, DivU)

  #local Weights1A = UniformWeights1A(Size1A(Points1A4D), 1);

  Sample_URBS_1A4D(Points1A4D, Weights1A, OpenU, OrderU, DivU)

#end // macro Sample_UBS_1A4D



#macro Sample_URBS_2A4D(Points2A4D, Weights2A, OpenUV, OrderUV, DivUV)

  #local SizeUV = Size2A(Points2A4D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local OpenU = OpenUV.u;
  #local OpenV = OpenUV.v;
  #local OrderU = OrderUV.u;
  #local OrderV = OrderUV.v;
  #local MinU = 0;
  #local MinV = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local Points2Ax = ExtractComponent2A(Points2A4D, x);
  #local Points2Ay = ExtractComponent2A(Points2A4D, y);
  #local Points2Az = ExtractComponent2A(Points2A4D, z);
  #local Points2At = ExtractComponent2A(Points2A4D, t);

  SampleFunctions2A4D(
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ax, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Ay, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2Az, Weights2A),
    NURBS_Function2A(OrderUV, KnotsU, KnotsV, Points2At, Weights2A),
    <MinU, MinV>, <MaxU, MaxV>, DivUV
  )

#end // macro Sample_URBS_2A4D



#macro Sample_UBS_2A4D(Points2A4D, OpenUV, OrderUV, DivUV)

  #local Weights2A = UniformWeights2A(Size2A(Points2A4D), 1);

  Sample_URBS_2A4D(Points2A4D, Weights2A, OpenUV, OrderUV, DivUV)

#end // macro Sample_UBS_2A4D



#macro Sample_URBS_3A4D(Points3A4D, Weights3A, OpenUVW, OrderUVW, DivUVW)

  #local SizeUVW = Size3A(Points3A4D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local OpenU = OpenUVW.x;
  #local OpenV = OpenUVW.y;
  #local OpenW = OpenUVW.z;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local Points3Ax = ExtractComponent3A(Points3A4D, x);
  #local Points3Ay = ExtractComponent3A(Points3A4D, y);
  #local Points3Az = ExtractComponent3A(Points3A4D, z);
  #local Points3At = ExtractComponent3A(Points3A4D, t);

  SampleFunctions3A4D(
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ax, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Ay, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3Az, Weights3A),
    NURBS_Function3A(OrderUVW, KnotsU, KnotsV, KnotsW, Points3At, Weights3A),
    <MinU, MinV, MinW>, <MaxU, MaxV, MaxW>, DivUVW
  )

#end // macro Sample_URBS_3A4D



#macro Sample_UBS_3A4D(Points3A4D, OpenUVW, OrderUVW, DivUVW)

  #local Weights3A = UniformWeights3A(Size3A(Points3A4D), 1);

  Sample_URBS_3A4D(Points3A4D, Weights3A, OpenUVW, OrderUVW, DivUVW)
  
#end // macro Sample_UBS_3A4D



#macro Sample_URBS_4A4D(Points4A4D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)

  #local SizeUVWT = Size4A(Points4A4D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local OpenU = OpenUVWT.x;
  #local OpenV = OpenUVWT.y;
  #local OpenW = OpenUVWT.z;
  #local OpenT = OpenUVWT.t;
  #local OrderU = OrderUVW.x;
  #local OrderV = OrderUVW.y;
  #local OrderW = OrderUVW.z;
  #local OrderT = OrderUVW.t;
  #local MinU = 0;
  #local MinV = 0;
  #local MinW = 0;
  #local MinT = 0;
  #local MaxU = 1;
  #local MaxV = 1;
  #local MaxW = 1;
  #local MaxT = 1;
  #local KnotsU = UniformKnotVector(OpenU, OrderU, SizeU, MinU, MaxU);
  #local KnotsV = UniformKnotVector(OpenV, OrderV, SizeV, MinV, MaxV);
  #local KnotsW = UniformKnotVector(OpenW, OrderW, SizeW, MinW, MaxW);
  #local KnotsT = UniformKnotVector(OpenT, OrderT, SizeT, MinT, MaxT);
  #local Points4Ax = ExtractComponent4A(Points4A4D, x);
  #local Points4Ay = ExtractComponent4A(Points4A4D, y);
  #local Points4Az = ExtractComponent4A(Points4A4D, z);
  #local Points4At = ExtractComponent4A(Points4A4D, t);

  SampleFunctions4A4D(
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ax, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Ay, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4Az, Weights4A),
    NURBS_Function4A(OrderUVWT, KnotsU, KnotsV, KnotsW, KnotsT, Points4At, Weights4A),
    <MinU, MinV, MinW, MinT>, <MaxU, MaxV, MaxW, MaxT>, DivUVWT
  )

#end // macro Sample_URBS_4A4D



#macro Sample_UBS_4A4D(Points4A4D, OpenUVWT, OrderUVWT, DivUVWT)

  #local Weights4A = UniformWeights4A(Size4A(Points4A4D), 1);

  Sample_URBS_4A4D(Points4A4D, Weights4A, OpenUVWT, OrderUVWT, DivUVWT)
  
#end // macro Sample_UBS_4A4D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro DisplacePoints1A3D(Points1A3D, Amount3D, Seed)

  #local SizeU = Size1A(Points1A3D);
  #local NewPoints1A3D = array[SizeU];

  #local J = 0;
  #while (J < SizeV)
    #local I = 0;
    #while (I < SizeU)
      #local NewPoints1A3D[I] =
        Points1A3D[I] +
        (<1, 1, 1>/2 - <rand(Seed), rand(Seed), rand(Seed)>)*Amount3D;
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while

  NewPoints1A3D

#end // macro DisplacePoints1A3D



#macro DisplacePoints2A3D(Points2A3D, Amount3D, Seed)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local NewPoints2A3D = array[SizeU][SizeV];

  #local J = 0;
  #while (J < SizeV)
    #local I = 0;
    #while (I < SizeU)
      #local NewPoints2A3D[I][J] =
        Points2A3D[I][J] +
        (<1, 1, 1>/2 - <rand(Seed), rand(Seed), rand(Seed)>)*Amount3D;
      #local I = I + 1;
    #end // while
    #local J = J + 1;
  #end // while

  NewPoints2A3D

#end // macro DisplacePoints2A3D



#macro DisplacePoints3A3D(Points3A3D, Amount3D, Seed)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local NewPoints3A3D = array[SizeU][SizeV][SizeW];

  #local K = 0;
  #while (K < SizeW)
    #local J = 0;
    #while (J < SizeV)
      #local I = 0;
      #while (I < SizeU)
        #local NewPoints3A3D[I][J][K] =
          Points3A3D[I][J][K] +
          (<1, 1, 1>/2 - <rand(Seed), rand(Seed), rand(Seed)>)*Amount3D;
        #local I = I + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local K = K + 1;
  #end // while

  NewPoints3A3D

#end // macro DisplacePoints3A3D



#macro DisplacePoints4A3D(Points4A3D, Amount3D, Seed)

  #local SizeUVWT = Size4A(Points4A3D);
  #local SizeU = SizeUVWT.x;
  #local SizeV = SizeUVWT.y;
  #local SizeW = SizeUVWT.z;
  #local SizeT = SizeUVWT.t;
  #local NewPoints4A3D = array[SizeU][SizeV][SizeW][SizeT];

  #local L = 0;
  #while (L < SizeT)
    #local K = 0;
    #while (K < SizeW)
      #local J = 0;
      #while (J < SizeV)
        #local I = 0;
        #while (I < SizeU)
          #local NewPoints4A3D[I][J][K][L] =
            Points4A3D[I][J][K][L] +
            (<1, 1, 1>/2 - <rand(Seed), rand(Seed), rand(Seed)>)*Amount3D;
          #local I = I + 1;
        #end // while
        #local J = J + 1;
      #end // while
      #local K = K + 1;
    #end // while
    #local L = L + 1;
  #end // while

  NewPoints4A3D

#end // macro DisplacePoints4A3D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro SubArray1A(Array1A, Start, End)

  #local Size = Size1A(Array1A);
  #local NewSize = End - Start + 1;
  #local NewArray1A = array[NewSize];

  #local Cnt = 0;
  #while (Cnt < NewSize)
    #local NewArray1A[Cnt] = Array1A[Start + Cnt];
    #local Cnt = Cnt + 1;
  #end // while

  NewArray1A

#end // macro SubArray1A

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Remap_1A1D_1A1D(Points1A1D, xFn)

  #local SizeU = Size1A(Points1A1D);
  #local Points1A1D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A1D[I];
    #local Points1A1D_[I] = xFn(U);
    #local I = I + 1;
  #end // while

  Points1A1D_

#end // macro Remap_1A1D_1A1D



#macro Remap_2A1D_2A1D(Points2A1D, xFn)

  #local SizeUV = Size2A(Points2A1D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A1D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local U = Points2A1D[I][J];
      #local Points2A1D_[I][J] = xFn(U);
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A1D_

#end // macro Remap_2A1D_2A1D



#macro Remap_3A1D_3A1D(Points3A1D, xFn)

  #local SizeUVW = Size3A(Points3A1D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A1D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A1D[I][J][K];
        #local Points3A1D_[I][J][K] = xFn(U);
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A1D_

#end // macro Remap_3A1D_3A1D



#macro Remap_1A1D_1A2D(Points1A1D, xFn, yFn)

  #local SizeU = Size1A(Points1A1D);
  #local Points1A2D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A1D[I];
    #local Points1A2D_[I] = <xFn(U), yFn(U)>;
    #local I = I + 1;
  #end // while

  Points1A2D_

#end // macro Remap_1A1D_1A2D



#macro Remap_2A1D_2A2D(Points2A1D, xFn, yFn)

  #local SizeUV = Size2A(Points2A1D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A2D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local U = Points3A1D[I][J];
      #local Points3A2D_[I][J] = <xFn(U), yFn(U)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A2D_

#end // macro Remap_2A1D_2A2D



#macro Remap_3A1D_3A2D(Points3A1D, xFn, yFn)

  #local SizeUVW = Size3A(Points3A1D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A2D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A1D[I][J][K];
        #local Points3A2D_[I][J][K] = <xFn(U), yFn(U)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A2D_

#end // macro Remap_3A1D_3A2D



#macro Remap_1A2D_1A2D(Points1A2D, xFn, yFn)

  #local SizeU = Size1A(Points1A2D);
  #local Points1A2D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A2D[I].u;
    #local V = Points1A2D[I].v;
    #local Points1A2D_[I] = <xFn(U, V), yFn(U, V)>;
    #local I = I + 1;
  #end // while

  Points1A2D_

#end // macro Remap_1A2D_1A2D



#macro Remap_2A2D_2A2D(Points2A2D, xFn, yFn)

  #local SizeUV = Size2A(Points2A2D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A2D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local U = Points2A2D[I][J].u;
      #local V = Points2A2D[I][J].v;
      #local Points2A2D_[I][J] = <xFn(U, V), yFn(U, V)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A2D_

#end // macro Remap_2A2D_2A2D



#macro Remap_3A2D_3A2D(Points3A2D, xFn, yFn)

  #local SizeUVW = Size3A(Points3A2D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A2D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A2D[I][J][K].u;
        #local V = Points3A2D[I][J][K].v;
        #local Points3A2D_[I][J][K] = <xFn(U, V), yFn(U, V)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A2D_

#end // macro Remap_3A2D_3A2D



#macro Remap_1A3D_1A2D(Points1A3D, xFn, yFn)

  #local SizeU = Size1A(Points1A3D);
  #local Points1A2D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A3D[I].x;
    #local V = Points1A3D[I].y;
    #local W = Points1A3D[I].z;
    #local Points1A2D_[I] = <xFn(U, V, W), yFn(U, V, W)>;
    #local I = I + 1;
  #end // while

  Points1A2D_

#end // macro Remap_1A3D_1A2D



#macro Remap_2A3D_2A2D(Points2A3D, xFn, yFn)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A2D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
        #local U = Points2A3D[I][J].x;
        #local V = Points2A3D[I][J].y;
        #local W = Points2A3D[I][J].z;
        #local Points2A2D_[I][J] = <xFn(U, V, W), yFn(U, V, W)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A2D_

#end // macro Remap_2A3D_2A2D



#macro Remap_3A3D_3A2D(Points3A3D, xFn, yFn)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A2D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A3D[I][J][K].x;
        #local V = Points3A3D[I][J][K].y;
        #local W = Points3A3D[I][J][K].z;
        #local Points3A2D_[I][J][K] = <xFn(U, V, W), yFn(U, V, W)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A2D_

#end // macro Remap_3A3D_3A2D



#macro Remap_1A1D_1A3D(Points1A1D, xFn, yFn, zFn)

  #local SizeU = Size1A(Points1A1D);
  #local Points1A3D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A1D[I];
    #local Points1A3D_[I] = <xFn(U), yFn(U), zFn(U)>;
    #local I = I + 1;
  #end // while

  Points1A3D_

#end // macro Remap_1A1D_1A3D



#macro Remap_2A1D_2A3D(Points2A1D, xFn, yFn, zFn)

  #local SizeUV = Size2A(Points2A1D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A3D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local U = Points2A1D[I][J];
      #local Points2A3D_[I][J] = <xFn(U), yFn(U), zFn(U)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A3D_

#end // macro Remap_2A1D_2A3D



#macro Remap_3A1D_3A3D(Points3A1D, xFn, yFn, zFn)

  #local SizeUVW = Size3A(Points3A1D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A3D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A1D[I][J][K];
        #local Points3A3D_[I][J][K] = <xFn(U), yFn(U), zFn(U)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D_

#end // macro Remap_3A1D_3A3D



#macro Remap_1A2D_1A3D(Points1A2D, xFn, yFn, zFn)

  #local SizeU = Size1A(Points1A2D);
  #local Points1A3D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A2D[I].u;
    #local V = Points1A2D[I].v;
    #local Points1A3D_[I] = <xFn(U, V), yFn(U, V), zFn(U, V)>;
    #local I = I + 1;
  #end // while

  Points1A3D_

#end // macro Remap_1A2D_1A3D



#macro Remap_2A2D_2A3D(Points2A2D, xFn, yFn, zFn)

  #local SizeUV = Size2A(Points2A2D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A3D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local U = Points2A2D[I][J].u;
      #local V = Points2A2D[I][J].v;
      #local Points2A3D_[I][J] = <xFn(U, V), yFn(U, V), zFn(U, V)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A3D_

#end // macro Remap_2A2D_2A3D



#macro Remap_3A2D_3A3D(Points3A2D, xFn, yFn, zFn)

  #local SizeUVW = Size3A(Points3A2D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A3D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A2D[I][J][K].u;
        #local V = Points3A2D[I][J][K].v;
        #local Points3A3D_[I][J][K] = <xFn(U, V), yFn(U, V), zFn(U, V)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D_

#end // macro Remap_3A2D_3A3D



#macro Remap_1A3D_1A3D(Points1A3D, xFn, yFn, zFn)

  #local SizeU = Size1A(Points1A3D);
  #local Points1A3D_ = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local U = Points1A3D[I].x;
    #local V = Points1A3D[I].y;
    #local W = Points1A3D[I].z;
    #local Points1A3D_[I] = <xFn(U, V, W), yFn(U, V, W), zFn(U, V, W)>;
    #local I = I + 1;
  #end // while

  Points1A3D_

#end // macro Remap_1A3D_1A3D


#macro Remap_2A3D_2A3D(Points2A3D, xFn, yFn, zFn)

  #local SizeUV = Size2A(Points2A3D);
  #local SizeU = SizeUV.u;
  #local SizeV = SizeUV.v;
  #local Points2A3D_ = array[SizeU][SizeV];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local U = Points3A3D[I][J].x;
      #local V = Points3A3D[I][J].y;
      #local W = Points3A3D[I][J].z;
      #local Points3A3D_[I][J] = <xFn(U, V, W), yFn(U, V, W), zFn(U, V, W)>;
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points2A3D_

#end // macro Remap_2A3D_2A3D



#macro Remap_3A3D_3A3D(Points3A3D, xFn, yFn, zFn)

  #local SizeUVW = Size3A(Points3A3D);
  #local SizeU = SizeUVW.x;
  #local SizeV = SizeUVW.y;
  #local SizeW = SizeUVW.z;
  #local Points3A3D_ = array[SizeU][SizeV][SizeW];

  #local I = 0;
  #while (I < SizeU)
    #local J = 0;
    #while (J < SizeV)
      #local K = 0;
      #while (K < SizeW)
        #local U = Points3A3D[I][J][K].x;
        #local V = Points3A3D[I][J][K].y;
        #local W = Points3A3D[I][J][K].z;
        #local Points3A3D_[I][J][K] = <xFn(U, V, W), yFn(U, V, W), zFn(U, V, W)>;
        #local K = K + 1;
      #end // while
      #local J = J + 1;
    #end // while
    #local I = I + 1;
  #end // while

  Points3A3D_

#end // macro Remap_3A3D_3A3D



// Needs testing. TOK 01.05.06
#macro Interpolating_NURBS_Functions(ValueSets1A, Order, Open)

  #local NrOfSets = Size1A(ValueSets1A);
  #local NrOfValues = Size1A(ValueSets1A[0]);
  #local Values1A = array[NrOfSets];
  #local NURBS_Functions1A = array[NrOfValues];

  #local Knots = UniformKnotVector(Open, Order, NrOfSets, 0, 1);
  #local Weights1A = UniformWeights1A(NrOfSets, 1);

  #local Cnt = 0;
  #while (Cnt < NrOfValues)
    #local OneValueSet1A = ValueSets1A[Cnt];
    #local I = 0;
    #while (I < NrOfSets)
      #local Values1A[I] = OneValueSet1A[I];
      #local I = I + 1;
    #end // while
    #local NURBS_Functions1A[Cnt] = NURBS_Function1A(Order, Knots, Values1A, Weights1A)
    #local Cnt = Cnt + 1;
  #end // while

  NURBS_Functions1A

#end // macro Interpolating_NURBS_Functions



#macro EvaluateFunctions1A1D(Fns1Ax, S)

  #local SizeU = Size1A(Fns1Ax);
  #local Vectors1A1D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A1D[I] = Fns1Ax[I](S);
    #local I = I + 1;
  #end // while

  Vectors1A1D

#end // macro EvaluateFunctions1A1D



#macro EvaluateFunctions1A2D(Fns1Ax, Fns1Ay, S)

  #local SizeU = Size1A(Fns1Ax);
  #local Vectors1A2D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A2D[I] = <Fns1Ax[I](S), Fns1Ay[I](S)>;
    #local I = I + 1;
  #end // while

  Vectors1A2D

#end // macro EvaluateFunctions1A2D



#macro EvaluateFunctions1A3D(Fns1Ax, Fns1Ay, Fns1Az, S)

  #local SizeU = Size1A(Fns1Ax);
  #local Vectors1A3D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A3D[I] = <Fns1Ax[I](S), Fns1Ay[I](S), Fns1Az[I](S)>;
    #local I = I + 1;
  #end // while

  Vectors1A3D

#end // macro EvaluateFunctions1A3D



#macro EvaluateFunctions1A4D(Fns1Ax, Fns1Ay, Fns1Az, Fns1At, S)

  #local SizeU = Size1A(Fns1Ax);
  #local Vectors1A4D = array[SizeU];

  #local I = 0;
  #while (I < SizeU)
    #local Vectors1A4D[I] = <Fns1Ax[I](S), Fns1Ay[I](S), Fns1Az[I](S), Fns1At[I](S)>;
    #local I = I + 1;
  #end // while

  Vectors1A4D

#end // macro EvaluateFunctions1A4D

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Declare_SizeU(Size_U)

  #declare SizeU = Size_U;

#end // macro Declare_SizeU



#macro Declare_MinU(Min_U)

  #declare MinU = Min_U;

#end // macro Declare_MinU



#macro Declare_MaxU(Max_U)

  #declare MaxU = Max_U;

#end // macro Declare_MaxU



#macro Declare_OpenU(Open_U)

  #declare OpenU = Open_U;

#end // macro Declare_OpenU



#macro Declare_OrderU(Order_U)

  #declare OrderU = Order_U;

#end // macro Declare_OrderU



#macro Declare_WrapU(Wrap_U)

  #declare WrapU = Wrap_U;

#end // macro Declare_rapU



#macro Declare_DivU(Div_U)

  #declare DivU = Div_U;

#end // macro Declare_DivU



#macro Declare_ResU(Res_U)

  #declare ResU = Res_U;

#end // macro Declare_ResU



#macro Declare_KnotsU()

  #declare KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);

#end // macro Declare_KnotsU



#macro Declare_KnotsMinMaxU()

  #declare KnotsU = UniformKnotVectorMinMax(OpenU, OrderU, SizeU, MinU, MaxU);

#end // macro Declare_KnotsMinMaxU

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Declare_SizeUV(Size_UV)

  #declare SizeUV = Size_UV;
  #declare SizeU = Size_UV.u;
  #declare SizeV = Size_UV.v;

#end // macro Declare_SizeUV



#macro Declare_MinUV(Min_UV)

  #declare MinUV = Min_UV;
  #declare MinU = Min_UV.u;
  #declare MinV = Min_UV.v;

#end // macro Declare_MinUV



#macro Declare_MaxUV(Max_UV)

  #declare MaxUV = Max_UV;
  #declare MaxU = Max_UV.u;
  #declare MaxV = Max_UV.v;

#end // macro Declare_MaxUV



#macro Declare_OpenUV(Open_UV)

  #declare OpenUV = Open_UV;
  #declare OpenU = Open_UV.u;
  #declare OpenV = Open_UV.v;

#end // macro Declare_OpenUV



#macro Declare_OrderUV(Order_UV)

  #declare OrderUV = Order_UV;
  #declare OrderU = Order_UV.u;
  #declare OrderV = Order_UV.v;

#end // macro Declare_OrderUV



#macro Declare_WrapUV(Wrap_UV)

  #declare WrapUV = Wrap_UV;
  #declare WrapU = Wrap_UV.u;
  #declare WrapV = Wrap_UV.v;

#end // macro Declare_WrapUV



#macro Declare_DivUV(Div_UV)

  #declare DivUV = Div_UV;
  #declare DivU = Div_UV.u;
  #declare DivV = Div_UV.v;

#end // macro Declare_DivUV



#macro Declare_ResUV(Res_UV)

  #declare ResUV = Res_UV;
  #declare ResU = Res_UV.u;
  #declare ResV = Res_UV.v;

#end // macro Declare_ResUV



#macro Declare_KnotsUV()

  #declare KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #declare KnotsV = UniformKnotVector(OpenV, OrderV, SizeV);

#end // macro Declare_KnotsUV



#macro Declare_KnotsMinMaxUV()

  #declare KnotsU = UniformKnotVectorMinMax(OpenU, OrderU, SizeU, MinU, MaxU);
  #declare KnotsV = UniformKnotVectorMinMax(OpenV, OrderV, SizeV, MinV, MaxV);

#end // macro Declare_KnotsMinMaxUV

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Declare_SizeUVW(Size_UVW)

  #declare SizeUVW = Size_UVW;
  #declare SizeU = Size_UVW.x;
  #declare SizeV = Size_UVW.y;
  #declare SizeW = Size_UVW.z;

#end // macro Declare_SizeUVW



#macro Declare_MinUVW(Min_UVW)

  #declare MinUVW = Min_UVW;
  #declare MinU = Min_UVW.x;
  #declare MinV = Min_UVW.y;
  #declare MinW = Min_UVW.z;

#end // macro Declare_MinUVW



#macro Declare_MaxUVW(Max_UVW)

  #declare MaxUVW = Max_UVW;
  #declare MaxU = Max_UVW.x;
  #declare MaxV = Max_UVW.y;
  #declare MaxW = Max_UVW.z;

#end // macro Declare_MaxUVW



#macro Declare_OpenUVW(Open_UVW)

  #declare OpenUVW = Open_UVW;
  #declare OpenU = Open_UVW.x;
  #declare OpenV = Open_UVW.y;
  #declare OpenW = Open_UVW.z;

#end // macro Declare_OpenUVW



#macro Declare_OrderUVW(Order_UVW)

  #declare OrderUVW = Order_UVW;
  #declare OrderU = Order_UVW.x;
  #declare OrderV = Order_UVW.y;
  #declare OrderW = Order_UVW.z;

#end // macro Declare_OrderUVW



#macro Declare_WrapUVW(Wrap_UVW)

  #declare WrapUVW = Wrap_UVW;
  #declare WrapU = Wrap_UVW.x;
  #declare WrapV = Wrap_UVW.y;
  #declare WrapW = Wrap_UVW.z;

#end // macro Declare_WrapUVW



#macro Declare_DivUVW(Div_UVW)

  #declare DivUVW = Div_UVW;
  #declare DivU = Div_UVW.x;
  #declare DivV = Div_UVW.y;
  #declare DivW = Div_UVW.z;

#end // macro Declare_DivUVW



#macro Declare_ResUVW(Res_UVW)

  #declare ResUVW = Res_UVW;
  #declare ResU = Res_UVW.x;
  #declare ResV = Res_UVW.y;
  #declare ResW = Res_UVW.z;

#end // macro Declare_ResUVW



#macro Declare_KnotsUVW()

  #declare KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #declare KnotsV = UniformKnotVector(OpenV, OrderV, SizeV);
  #declare KnotsW = UniformKnotVector(OpenW, OrderW, SizeW);

#end // macro Declare_KnotsUVW



#macro Declare_KnotsMinMaxUVW()

  #declare KnotsU = UniformKnotVectorMinMax(OpenU, OrderU, SizeU, MinU, MaxU);
  #declare KnotsV = UniformKnotVectorMinMax(OpenV, OrderV, SizeV, MinV, MaxV);
  #declare KnotsW = UniformKnotVectorMinMax(OpenW, OrderW, SizeW, MinW, MaxW);

#end // macro Declare_KnotsMinMaxUVW

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======

#macro Declare_SizeUVWT(Size_UVWT)

  #declare SizeUVWT = Size_UVWT;
  #declare SizeU = Size_UVWT.x;
  #declare SizeV = Size_UVWT.y;
  #declare SizeW = Size_UVWT.z;
  #declare SizeT = Size_UVWT.t;

#end // macro Declare_SizeUVWT



#macro Declare_MinUVWT(Min_UVWT)

  #declare MinUVWT = Min_UVWT;
  #declare MinU = Min_UVWT.x;
  #declare MinV = Min_UVWT.y;
  #declare MinW = Min_UVWT.z;
  #declare MinT = Min_UVWT.t;

#end // macro Declare_MinUVWT



#macro Declare_MaxUVWT(Max_UVWT)

  #declare MaxUVWT = Max_UVWT;
  #declare MaxU = Max_UVWT.x;
  #declare MaxV = Max_UVWT.y;
  #declare MaxW = Max_UVWT.z;
  #declare MaxT = Max_UVWT.t;

#end // macro Declare_MaxUVWT



#macro Declare_OpenUVWT(Open_UVWT)

  #declare OpenUVWT = Open_UVWT;
  #declare OpenU = Open_UVWT.x;
  #declare OpenV = Open_UVWT.y;
  #declare OpenW = Open_UVWT.z;
  #declare OpenT = Open_UVWT.t;

#end // macro Declare_OpenUVWT


#macro Declare_OrderUVWT(Order_UVWT)

  #declare OrderUVWT = Order_UVWT;
  #declare OrderU = Order_UVWT.x;
  #declare OrderV = Order_UVWT.y;
  #declare OrderW = Order_UVWT.z;
  #declare OrderT = Order_UVWT.t;

#end // macro Declare_OrderUVWT



#macro Declare_WrapUVWT(Wrap_UVWT)

  #declare WrapUVWT = Wrap_UVWT;
  #declare WrapU = Wrap_UVWT.x;
  #declare WrapV = Wrap_UVWT.y;
  #declare WrapW = Wrap_UVWT.z;
  #declare WrapT = Wrap_UVWT.t;

#end // macro Declare_WrapUVWT



#macro Declare_DivUVWT(Div_UVWT)

  #declare DivUVWT = Div_UVWT;
  #declare DivU = Div_UVWT.x;
  #declare DivV = Div_UVWT.y;
  #declare DivW = Div_UVWT.z;
  #declare DivT = Div_UVWT.t;

#end // macro Declare_DivUVWT



#macro Declare_ResUVWT(Res_UVWT)

  #declare ResUVWT = Res_UVWT;
  #declare ResU = Res_UVWT.x;
  #declare ResV = Res_UVWT.y;
  #declare ResW = Res_UVWT.z;
  #declare ResT = Res_UVWT.t;

#end // macro Declare_ResUVWT



#macro Declare_KnotsUVWT()

  #declare KnotsU = UniformKnotVector(OpenU, OrderU, SizeU);
  #declare KnotsV = UniformKnotVector(OpenV, OrderV, SizeV);
  #declare KnotsW = UniformKnotVector(OpenW, OrderW, SizeW);
  #declare KnotsT = UniformKnotVector(OpenT, OrderT, SizeT);

#end // macro Declare_KnotsUVWT



#macro Declare_KnotsMinMaxUVWT()

  #declare KnotsU = UniformKnotVectorMinMax(OpenU, OrderU, SizeU, MinU, MaxU);
  #declare KnotsV = UniformKnotVectorMinMax(OpenV, OrderV, SizeV, MinV, MaxV);
  #declare KnotsW = UniformKnotVectorMinMax(OpenW, OrderW, SizeW, MinW, MaxW);
  #declare KnotsT = UniformKnotVectorMinMax(OpenT, OrderT, SizeT, MinT, MaxT);

#end // macro Declare_KnotsMinMaxUVWT

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A ======= B =======
