// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 
// Copyright 2010 by Tor Olav Kristensen
// Email: t o r . o l a v . k [ a t ] g m a i l . c o m
// http://subcube.com
// File: NURBS-test.inc (SDL include file for POV-Ray v3.5)
// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 

#version 3.5;

#include "colors.inc"

#include "NURBS_28_.inc"

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 

// Number of control points in the U and V "directions"
#declare NrU = 5;
#declare NrV = 5;

/*
// These control points and their weights will make the surface a flat square.
// U increases towards the right and V increases upwards (The x and y components of the
// control points in the array are chosen so that the x components will increase along
// with the U values and the y components will increase along with the V values.)

#declare CtrlPoints =
  array[NrU][NrV] {
    { <0, 0, 0>, <1, 0, 0>, <2, 0, 0>, <3, 0, 0>, <4, 0, 0> },
    { <0, 1, 0>, <1, 1, 0>, <2, 1, 0>, <3, 1, 0>, <4, 1, 0> },
    { <0, 2, 0>, <1, 2, 0>, <2, 2, 0>, <3, 2, 0>, <4, 2, 0> },
    { <0, 3, 0>, <1, 3, 0>, <2, 3, 0>, <3, 3, 0>, <4, 3, 0> },
    { <0, 4, 0>, <1, 4, 0>, <2, 4, 0>, <3, 4, 0>, <4, 4, 0> }
  }

#declare Weights =
  array[NrU][NrV] {
    { 1, 1, 1, 1, 1 },
    { 1, 1, 1, 1, 1 },
    { 1, 1, 1, 1, 1 },
    { 1, 1, 1, 1, 1 },
    { 1, 1, 1, 1, 1 }
  }
*/

// This is more interesting. Some points have been displaced along the z-axis.
// Each of them are "pulling" a region of the surface towards them.

#declare CtrlPoints =
  array[NrU][NrV] {
    { < 0,  0,  0>, < 0,  1, -2>, < 0,  2,  3>, < 0,  3, -2>, < 0,  4,  0> },
    { < 1,  0,  0>, < 1,  1,  0>, < 1,  2,  0>, < 1,  3,  0>, < 1,  4,  0> },
    { < 2,  0,  0>, < 2,  1, -2>, < 2,  2,  0>, < 2,  3,  4>, < 2,  4,  0> },
    { < 3,  0,  0>, < 3,  1,  0>, < 3,  2,  0>, < 3,  3,  0>, < 3,  4,  0> },
    { < 4,  0, -3>, < 4,  1,  0>, < 4,  2,  0>, < 4,  3,  0>, < 4,  4,  4> }
  }


// These weights can be thought of as a measure for how strong the pull or "tension" from
// their corresponding points will be.

#declare Weights =
  array[NrU][NrV] {
    {  1,  1,  1,  1,  1 },
    {  1,  1,  1,  1,  1 },
    {  1, 10,  1,  1,  1 },
    {  1,  1,  1,  1,  1 },
    {  1,  1,  1,  1,  1 }
  }

#declare Wrap = <false, false>; // If the surface wraps around itself
#declare Radius = 0.01;

/*
// Uncomment this if you want to see the grid of control points

union {
  ShowGrid2A3D(CtrlPoints, Wrap, 2*Radius)
  pigment { color 2*Orange }
}
*/

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 

// Order must be greater than or equal to 2 and less than or equal to the lesser of NrU
// and NrV. I.e. the number of control points above will allow you to try order values
// from 2 to 5.
// For lower order values, each point will "control" a smaller region of the surface.
// Higher order values will make each of them "control" a larger region of it.

#declare Open = <true, true>; // Choose the knot vectors to be open.
#declare Order = <4, 4>;
#declare Div = <50, 50>;
#declare Res = 5*Div;

// Now show the surface
// - and let its colour vary along with its "depth" in the z-direction.

// URBS: Uniform Rational B-Splines
// 2A3D: 2 dimensional array of points in 3-dimensional space
union {
  Show_URBS_2A3D(
    CtrlPoints,
    Weights,
    Open,
    Order,
    Wrap,
    Div,
    Res,
    Radius
  )
  texture {
    pigment {
      gradient -z
      color_map {
        [ 0.4 color Blue ]
        [ 1.0 color Green*2 ]
      }
    }
    scale <1, 1, 7> // "Depth" difference between points (in z-direction)
    translate -3*z // "Depth" of the farthest point (in z-direction)
  }
}

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 

// Add a light source
light_source { <2, 1, -5>*10 color White shadowless }

// And a plain camera
camera {
  location <-2.0, 1.1, -4.0>*1.1
  look_at <3.0, 2.2, 0.0>
}

/*
// Also try this camera
camera {
  orthographic
  location <2, 2, -4.5>
  look_at <2, 2, 0>
}
// Then set all weights to 1 and try this camera again
*/

// Add a tuch of blue to the backdrop
background { color Blue/8 }

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 

