// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A

// isosurface_KL_JF_TOK.inc - POV-Ray SDL include file for approxmations of isosurfaces
// Made by Kevin Loney, Jaap Frank & Tor Olav Kristensen, 2003 - 2006

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A

#macro MakeTriangle(pA, pB, pC, Save)

  #if (Save)
    #write (StreamId, "  triangle { ",pA,", ",pB,", ",pC,"}\n")
  #else
    triangle { pA, pB, pC }
  #end // if

#end // macro MakeTriangle


#macro MakeSmoothTriangle(pA, pB, pC, vA, vB, vC, Save)

  #if (Save)
    #write (StreamId, "  smooth_triangle { ",pA,", ",vA,", ", pB,", ",vB,", ",pC,", ",vC,"}\n")
  #else
    smooth_triangle { pA, vA, pB, vB, pC, vC }
  #end // if

#end // macro MakeSmoothTriangle


#macro MakeCell(VV, SS, Save, TriCnt)

  #local p0 = VV[0];
  #local p1 = VV[1];
  #local p2 = VV[2];
  #local p3 = VV[3];
  #local p4 = VV[4];
  #local p5 = VV[5];
  #local p6 = VV[6];
  #local p7 = VV[7];
  #local s0 = SS[0];
  #local s1 = SS[1];
  #local s2 = SS[2];
  #local s3 = SS[3];
  #local s4 = SS[4];
  #local s5 = SS[5];
  #local s6 = SS[6];
  #local s7 = SS[7];

  #local D_Fn = function(_A, _B) { select(_B - _A, _A/(_B - _A), 0, _A/(_B - _A)) } ///
  #local p01 = p0 - D_Fn(s0, s1)*(p1 - p0);
  #local p02 = p0 - D_Fn(s0, s2)*(p2 - p0);
  #local p03 = p0 - D_Fn(s0, s3)*(p3 - p0);
  #local p04 = p0 - D_Fn(s0, s4)*(p4 - p0);
  #local p06 = p0 - D_Fn(s0, s6)*(p6 - p0);
  #local p07 = p0 - D_Fn(s0, s7)*(p7 - p0);
  #local p12 = p1 - D_Fn(s1, s2)*(p2 - p1);
  #local p14 = p1 - D_Fn(s1, s4)*(p4 - p1);
  #local p15 = p1 - D_Fn(s1, s5)*(p5 - p1);
  #local p16 = p1 - D_Fn(s1, s6)*(p6 - p1);
  #local p23 = p2 - D_Fn(s2, s3)*(p3 - p2);
  #local p26 = p2 - D_Fn(s2, s6)*(p6 - p2);
  #local p27 = p2 - D_Fn(s2, s7)*(p7 - p2);
  #local p37 = p3 - D_Fn(s3, s7)*(p7 - p3);
  #local p45 = p4 - D_Fn(s4, s5)*(p5 - p4);
  #local p46 = p4 - D_Fn(s4, s6)*(p6 - p4);
  #local p47 = p4 - D_Fn(s4, s7)*(p7 - p4);
  #local p56 = p6 - D_Fn(s6, s5)*(p5 - p6);
  #local p67 = p6 - D_Fn(s6, s7)*(p7 - p6);

  #local M_Fn = function(_C) { select(7 - _C, 15 - _C, _C) }
/*
  #local SelFn =
    function(_C0, _C1, _C2, _C3) {
      select(_C0, 1, 0) +
      select(_C1, 2, 0) +
      select(_C2, 4, 0) +
      select(_C3, 8, 0)
    }
  #local SwFn = function(_C0, _C1, _C2, _C3) { M_Fn(SelFn(_C0, _C1, _C2, _C3)) }
*/
  #local SwFn =
    function(_C0, _C1, _C2, _C3) {
      M_Fn(
        select(_C0, 1, 0) +
        select(_C1, 2, 0) +
        select(_C2, 4, 0) +
        select(_C3, 8, 0)
      )
    }

  #local Cnt = 0;

  #switch (SwFn(s0, s1, s2, s6))
    #case (0)
    #break

    #case (1)
      MakeTriangle(p01, p02, p06, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeTriangle(p12, p16, p01, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeTriangle(p02, p16, p06, Save)
      MakeTriangle(p02, p16, p12, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeTriangle(p26, p02, p12, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeTriangle(p01, p26, p06, Save)
      MakeTriangle(p01, p26, p12, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeTriangle(p01, p26, p02, Save)
      MakeTriangle(p01, p26, p16, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeTriangle(p06, p16, p26, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s1, s4, s6))
    #case (0)
    #break

    #case (1)
      MakeTriangle(p01, p04, p06, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeTriangle(p14, p16, p01, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeTriangle(p04, p16, p06, Save)
      MakeTriangle(p04, p16, p14, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeTriangle(p46, p04, p14, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeTriangle(p01, p46, p06, Save)
      MakeTriangle(p01, p46, p14, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeTriangle(p01, p46, p04, Save)
      MakeTriangle(p01, p46, p16, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeTriangle(p06, p16, p46, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s2, s3, s7))
    #case (0)
    #break

    #case (1)
      MakeTriangle(p02, p03, p07, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeTriangle(p23, p27, p02, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeTriangle(p03, p27, p07, Save)
      MakeTriangle(p03, p27, p23, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeTriangle(p37, p03, p23, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeTriangle(p02, p37, p07, Save)
      MakeTriangle(p02, p37, p23, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeTriangle(p02, p37, p03, Save)
      MakeTriangle(p02, p37, p27, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeTriangle(p07, p27, p37, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s2, s6, s7))
    #case (0)
    #break

    #case (1)
      MakeTriangle(p02, p06, p07, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeTriangle(p26, p27, p02, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeTriangle(p06, p27, p07, Save)
      MakeTriangle(p06, p27, p26, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeTriangle(p67, p06, p26, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeTriangle(p02, p67, p07, Save)
      MakeTriangle(p02, p67, p26, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeTriangle(p02, p67, p06, Save)
      MakeTriangle(p02, p67, p27, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeTriangle(p07, p27, p67, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s4, s6, s7))
    #case (0)
    #break

    #case (1)
      MakeTriangle(p04, p06, p07, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeTriangle(p46, p47, p04, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeTriangle(p06, p47, p07, Save)
      MakeTriangle(p06, p47, p46, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeTriangle(p67, p06, p46, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeTriangle(p04, p67, p07, Save)
      MakeTriangle(p04, p67, p46, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeTriangle(p04, p67, p06, Save)
      MakeTriangle(p04, p67, p47, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeTriangle(p07, p47, p67, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s1, s4, s5, s6))
    #case (0)
    #break

    #case (1)
      MakeTriangle(p14, p15, p16, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeTriangle(p45, p46, p14, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeTriangle(p15, p46, p16, Save)
      MakeTriangle(p15, p46, p45, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeTriangle(p56, p15, p45, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeTriangle(p14, p56, p16, Save)
      MakeTriangle(p14, p56, p45, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeTriangle(p14, p56, p15, Save)
      MakeTriangle(p14, p56, p46, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeTriangle(p16, p46, p56, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #declare TriCnt = TriCnt + Cnt;

#end // macro MakeCell


#macro MakeSmoothCell(VV, SS, Save, TriCnt)

  #local p0 = VV[0];
  #local p1 = VV[1];
  #local p2 = VV[2];
  #local p3 = VV[3];
  #local p4 = VV[4];
  #local p5 = VV[5];
  #local p6 = VV[6];
  #local p7 = VV[7];
  #local s0 = SS[0];
  #local s1 = SS[1];
  #local s2 = SS[2];
  #local s3 = SS[3];
  #local s4 = SS[4];
  #local s5 = SS[5];
  #local s6 = SS[6];
  #local s7 = SS[7];

  #local D_Fn = function(_A, _B) { select(_B - _A, _A/(_B - _A), 0, _A/(_B - _A)) } ///
  #local p01 = p0 - D_Fn(s0, s1)*(p1 - p0);
  #local p02 = p0 - D_Fn(s0, s2)*(p2 - p0);
  #local p03 = p0 - D_Fn(s0, s3)*(p3 - p0);
  #local p04 = p0 - D_Fn(s0, s4)*(p4 - p0);
  #local p06 = p0 - D_Fn(s0, s6)*(p6 - p0);
  #local p07 = p0 - D_Fn(s0, s7)*(p7 - p0);
  #local p12 = p1 - D_Fn(s1, s2)*(p2 - p1);
  #local p14 = p1 - D_Fn(s1, s4)*(p4 - p1);
  #local p15 = p1 - D_Fn(s1, s5)*(p5 - p1);
  #local p16 = p1 - D_Fn(s1, s6)*(p6 - p1);
  #local p23 = p2 - D_Fn(s2, s3)*(p3 - p2);
  #local p26 = p2 - D_Fn(s2, s6)*(p6 - p2);
  #local p27 = p2 - D_Fn(s2, s7)*(p7 - p2);
  #local p37 = p3 - D_Fn(s3, s7)*(p7 - p3);
  #local p45 = p4 - D_Fn(s4, s5)*(p5 - p4);
  #local p46 = p4 - D_Fn(s4, s6)*(p6 - p4);
  #local p47 = p4 - D_Fn(s4, s7)*(p7 - p4);
  #local p56 = p6 - D_Fn(s6, s5)*(p5 - p6);
  #local p67 = p6 - D_Fn(s6, s7)*(p7 - p6);
  #local vN01 = <GX_Fn(p01.x, p01.y, p01.z), GY_Fn(p01.x, p01.y, p01.z), GZ_Fn(p01.x, p01.y, p01.z)>;
  #local vN02 = <GX_Fn(p02.x, p02.y, p02.z), GY_Fn(p02.x, p02.y, p02.z), GZ_Fn(p02.x, p02.y, p02.z)>;
  #local vN03 = <GX_Fn(p03.x, p03.y, p03.z), GY_Fn(p03.x, p03.y, p03.z), GZ_Fn(p03.x, p03.y, p03.z)>;
  #local vN04 = <GX_Fn(p04.x, p04.y, p04.z), GY_Fn(p04.x, p04.y, p04.z), GZ_Fn(p04.x, p04.y, p04.z)>;
  #local vN06 = <GX_Fn(p06.x, p06.y, p06.z), GY_Fn(p06.x, p06.y, p06.z), GZ_Fn(p06.x, p06.y, p06.z)>;
  #local vN07 = <GX_Fn(p07.x, p07.y, p07.z), GY_Fn(p07.x, p07.y, p07.z), GZ_Fn(p07.x, p07.y, p07.z)>;
  #local vN12 = <GX_Fn(p12.x, p12.y, p12.z), GY_Fn(p12.x, p12.y, p12.z), GZ_Fn(p12.x, p12.y, p12.z)>;
  #local vN14 = <GX_Fn(p14.x, p14.y, p14.z), GY_Fn(p14.x, p14.y, p14.z), GZ_Fn(p14.x, p14.y, p14.z)>;
  #local vN15 = <GX_Fn(p15.x, p15.y, p15.z), GY_Fn(p15.x, p15.y, p15.z), GZ_Fn(p15.x, p15.y, p15.z)>;
  #local vN16 = <GX_Fn(p16.x, p16.y, p16.z), GY_Fn(p16.x, p16.y, p16.z), GZ_Fn(p16.x, p16.y, p16.z)>;
  #local vN23 = <GX_Fn(p23.x, p23.y, p23.z), GY_Fn(p23.x, p23.y, p23.z), GZ_Fn(p23.x, p23.y, p23.z)>;
  #local vN26 = <GX_Fn(p26.x, p26.y, p26.z), GY_Fn(p26.x, p26.y, p26.z), GZ_Fn(p26.x, p26.y, p26.z)>;
  #local vN27 = <GX_Fn(p27.x, p27.y, p27.z), GY_Fn(p27.x, p27.y, p27.z), GZ_Fn(p27.x, p27.y, p27.z)>;
  #local vN37 = <GX_Fn(p37.x, p37.y, p37.z), GY_Fn(p37.x, p37.y, p37.z), GZ_Fn(p37.x, p37.y, p37.z)>;
  #local vN45 = <GX_Fn(p45.x, p45.y, p45.z), GY_Fn(p45.x, p45.y, p45.z), GZ_Fn(p45.x, p45.y, p45.z)>;
  #local vN46 = <GX_Fn(p46.x, p46.y, p46.z), GY_Fn(p46.x, p46.y, p46.z), GZ_Fn(p46.x, p46.y, p46.z)>;
  #local vN47 = <GX_Fn(p47.x, p47.y, p47.z), GY_Fn(p47.x, p47.y, p47.z), GZ_Fn(p47.x, p47.y, p47.z)>;
  #local vN56 = <GX_Fn(p56.x, p56.y, p56.z), GY_Fn(p56.x, p56.y, p56.z), GZ_Fn(p56.x, p56.y, p56.z)>;
  #local vN67 = <GX_Fn(p67.x, p67.y, p67.z), GY_Fn(p67.x, p67.y, p67.z), GZ_Fn(p67.x, p67.y, p67.z)>;

  #local M_Fn = function(_C) { select(7 - _C, 15 - _C, _C) }
  #local SelFn =
    function(_C0, _C1, _C2, _C3) {
      select(_C0, 1, 0) +
      select(_C1, 2, 0) +
      select(_C2, 4, 0) +
      select(_C3, 8, 0)
    }
  #local SwFn = function(_C0, _C1, _C2, _C3) { M_Fn(SelFn(_C0, _C1, _C2, _C3)) }

  #local Cnt = 0;

  #switch (SwFn(s0, s1, s2, s6))
    #case (0)
    #break

    #case (1)
      MakeSmoothTriangle(p01, p02, p06, vN01, vN02, vN06, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeSmoothTriangle(p12, p16, p01, vN12, vN16, vN01, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeSmoothTriangle(p02, p16, p06, vN02, vN16, vN06, Save)
      MakeSmoothTriangle(p02, p16, p12, vN02, vN16, vN12, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeSmoothTriangle(p26, p02, p12, vN26, vN02, vN12, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeSmoothTriangle(p01, p26, p06, vN01, vN26, vN06, Save)
      MakeSmoothTriangle(p01, p26, p12, vN01, vN26, vN12, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeSmoothTriangle(p01, p26, p02, vN01, vN26, vN02, Save)
      MakeSmoothTriangle(p01, p26, p16, vN01, vN26, vN16, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeSmoothTriangle(p06, p16, p26, vN06, vN16, vN26, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s1, s4, s6))
    #case (0)
    #break

    #case (1)
      MakeSmoothTriangle(p01, p04, p06, vN01, vN04, vN06, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeSmoothTriangle(p14, p16, p01, vN14, vN16, vN01, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeSmoothTriangle(p04, p16, p06, vN04, vN16, vN06, Save)
      MakeSmoothTriangle(p04, p16, p14, vN04, vN16, vN14, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeSmoothTriangle(p46, p04, p14, vN46, vN04, vN14, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeSmoothTriangle(p01, p46, p06, vN01, vN46, vN06, Save)
      MakeSmoothTriangle(p01, p46, p14, vN01, vN46, vN14, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeSmoothTriangle(p01, p46, p04, vN01, vN46, vN04, Save)
      MakeSmoothTriangle(p01, p46, p16, vN01, vN46, vN16, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeSmoothTriangle(p06, p16, p46, vN06, vN16, vN46, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s2, s3, s7))
    #case (0)
    #break

    #case (1)
      MakeSmoothTriangle(p02, p03, p07, vN02, vN03, vN07, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeSmoothTriangle(p23, p27, p02, vN23, vN27, vN02, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeSmoothTriangle(p03, p27, p07, vN03, vN27, vN07, Save)
      MakeSmoothTriangle(p03, p27, p23, vN03, vN27, vN23, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeSmoothTriangle(p37, p03, p23, vN37, vN03, vN23, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeSmoothTriangle(p02, p37, p07, vN02, vN37, vN07, Save)
      MakeSmoothTriangle(p02, p37, p23, vN02, vN37, vN23, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeSmoothTriangle(p02, p37, p03, vN02, vN37, vN03, Save)
      MakeSmoothTriangle(p02, p37, p27, vN02, vN37, vN27, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeSmoothTriangle(p07, p27, p37, vN07, vN27, vN37, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s2, s6, s7))
    #case (0)
    #break

    #case (1)
      MakeSmoothTriangle(p02, p06, p07, vN02, vN06, vN07, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeSmoothTriangle(p26, p27, p02, vN26, vN27, vN02, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeSmoothTriangle(p06, p27, p07, vN06, vN27, vN07, Save)
      MakeSmoothTriangle(p06, p27, p26, vN06, vN27, vN26, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeSmoothTriangle(p67, p06, p26, vN67, vN06, vN26, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeSmoothTriangle(p02, p67, p07, vN02, vN67, vN07, Save)
      MakeSmoothTriangle(p02, p67, p26, vN02, vN67, vN26, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeSmoothTriangle(p02, p67, p06, vN02, vN67, vN06, Save)
      MakeSmoothTriangle(p02, p67, p27, vN02, vN67, vN27, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeSmoothTriangle(p07, p27, p67, vN07, vN27, vN67, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s0, s4, s6, s7))
    #case (0)
    #break

    #case (1)
      MakeSmoothTriangle(p04, p06, p07, vN04, vN06, vN07, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeSmoothTriangle(p46, p47, p04, vN46, vN47, vN04, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeSmoothTriangle(p06, p47, p07, vN06, vN47, vN07, Save)
      MakeSmoothTriangle(p06, p47, p46, vN06, vN47, vN46, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeSmoothTriangle(p67, p06, p46, vN67, vN06, vN46, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeSmoothTriangle(p04, p67, p07, vN04, vN67, vN07, Save)
      MakeSmoothTriangle(p04, p67, p46, vN04, vN67, vN46, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeSmoothTriangle(p04, p67, p06, vN04, vN67, vN06, Save)
      MakeSmoothTriangle(p04, p67, p47, vN04, vN67, vN47, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeSmoothTriangle(p07, p47, p67, vN07, vN47, vN67, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #switch (SwFn(s1, s4, s5, s6))
    #case (0)
    #break

    #case (1)
      MakeSmoothTriangle(p14, p15, p16, vN14, vN15, vN16, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (2)
      MakeSmoothTriangle(p45, p46, p14, vN45, vN46, vN14, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (3)
      MakeSmoothTriangle(p15, p46, p16, vN15, vN46, vN16, Save)
      MakeSmoothTriangle(p15, p46, p45, vN15, vN46, vN45, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (4)
      MakeSmoothTriangle(p56, p15, p45, vN56, vN15, vN45, Save)
      #local Cnt = Cnt + 1;
    #break

    #case (5)
      MakeSmoothTriangle(p14, p56, p16, vN14, vN56, vN16, Save)
      MakeSmoothTriangle(p14, p56, p45, vN14, vN56, vN45, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (6)
      MakeSmoothTriangle(p14, p56, p15, vN14, vN56, vN15, Save)
      MakeSmoothTriangle(p14, p56, p46, vN14, vN56, vN46, Save)
      #local Cnt = Cnt + 2;
    #break

    #case (7)
      MakeSmoothTriangle(p16, p46, p56, vN16, vN46, vN56, Save)
      #local Cnt = Cnt + 1;
    #break
  #end // switch

  #declare TriCnt = TriCnt + Cnt;

#end // macro MakeSmoothCell


#macro CheckCell(SS)

  #local Nil = 1E-5*0;
  #local LT = false;
  #local GT = false;

  #local Cnt = 0;
  #while (8 > Cnt & !LT)
    #local LT = (SS[Cnt] < -Nil);
    #local Cnt = Cnt + 1;
  #end // while

  #if (LT)
    #local Cnt = 0;
    #while (8 > Cnt & !GT)
      #local GT = (SS[Cnt] > Nil);
      #local Cnt = Cnt + 1;
    #end // while
  #end // if

  (LT & GT)

#end // macro CheckCell


/*
#macro CheckCell(SS)

  #local LT = false;
  #local GT = false;

  #local N = 0;
  #local Cnt = 0;
  #while (8 > Cnt)
    #local N = N + (SS[Cnt] < 0 ? 1 : 0);
    #local Cnt = Cnt + 1;
  #end // while

  (mod(N, 8) != 0)

#end // macro CheckCell
*/


#macro CalcPlaneYZ(Segs, pMin, pMax, NX)

  #local MinX = pMin.x;
  #local MinY = pMin.y;
  #local MinZ = pMin.z;
  #local MaxX = pMax.x;
  #local MaxY = pMax.y;
  #local MaxZ = pMax.z;
  #local SegsX = Segs.x;
  #local SegsY = Segs.y;
  #local SegsZ = Segs.z;
  #local StepX = (MaxX - MinX)/SegsX;
  #local StepY = (MaxY - MinY)/SegsY;
  #local StepZ = (MaxZ - MinZ)/SegsZ;
  #local X = MinX + NX*StepX;
  #local SubstFn = function(y, z) { T_Fn(X, MinY + y*StepY, MinZ + z*StepZ) }
  #local PlaneYZ = array[SegsY+1][SegsZ+1];

  #local NY = 0;
  #while (NY <= SegsY)
    #local NZ = 0;
    #while (NZ <= SegsZ)
      #local PlaneYZ[NY][NZ] = SubstFn(NY, NZ);
      #local NZ = NZ + 1;
    #end // while
    #local NY = NY + 1;
  #end // while

  PlaneYZ

#end // macro CalcPlaneYZ


#macro MakeMesh(Level, Segs, pMin, pMax, Smooth, Save, TriCnt)

  #local PlaneYZ = array[2];
  #local MinX = pMin.x;
  #local MinY = pMin.y;
  #local MinZ = pMin.z;
  #local SegsX = Segs.x;
  #local SegsY = Segs.y;
  #local SegsZ = Segs.z;
  #local vStep = (pMax - pMin)/Segs;
  #local StepX = vStep.x;
  #local StepY = vStep.y;
  #local StepZ = vStep.z;
  #local v100 = vStep*<1, 0, 0>;
  #local v101 = vStep*<1, 0, 1>;
  #local v001 = vStep*<0, 0, 1>;
  #local v010 = vStep*<0, 1, 0>;
  #local v110 = vStep*<1, 1, 0>;
  #local v111 = vStep*<1, 1, 1>;
  #local v011 = vStep*<0, 1, 1>;

  #local Cnt = 0;

  #local PlaneYZ[0] = CalcPlaneYZ(Segs, pMin, pMax, 0);
  #local NX = 0;
  #while (NX < SegsX)
    #local NX0 = mod(NX  , 2);
    #local NX1 = mod(NX+1, 2);
    #local PlaneYZ[NX1] = CalcPlaneYZ(Segs, pMin, pMax, NX+1);
    #local NY = 0;
    #while (NY < SegsY)
      #local NZ = 0;
      #while (NZ < SegsZ)
        #local SS =
          array[8] {
            PlaneYZ[NX0][NY  ][NZ  ],
            PlaneYZ[NX1][NY  ][NZ  ],
            PlaneYZ[NX1][NY  ][NZ+1],
            PlaneYZ[NX0][NY  ][NZ+1],
            PlaneYZ[NX0][NY+1][NZ  ],
            PlaneYZ[NX1][NY+1][NZ  ],
            PlaneYZ[NX1][NY+1][NZ+1],
            PlaneYZ[NX0][NY+1][NZ+1]
          }
        #if (CheckCell(SS))
          #local p0 = pMin + vStep*<NX, NY, NZ>;
          #if (0 < Level)
            MakeMesh(Level-1, Segs, p0, p0 + vStep, Smooth, Save, TriCnt)
          #else
            #local VV =
              array[8] {
                p0,
                p0 + v100,
                p0 + v101,
                p0 + v001,
                p0 + v010,
                p0 + v110,
                p0 + v111,
                p0 + v011
              }
            #if (Smooth)
              MakeSmoothCell(VV, SS, Save, Cnt)
            #else
              MakeCell(VV, SS, Save, Cnt)
            #end // if
          #end // if
        #end // if
        #local NZ = NZ + 1;
      #end // while
      #local NY = NY + 1;
    #end // while
    #local NX = NX + 1;
  #end // while

  #declare TriCnt = Cnt;

#end // macro MakeMesh


#macro Meshify(Depth, Segs, pMin, pMax, Smooth, FileOption, FileName, MeshName, TriCnt)

  #switch (2 - FileOption)
    #case (0)
      #if (0 < strlen(MeshName))
        #fopen StreamId "isosurface.tmp" write
        #write (StreamId, "#declare ", MeshName, " =\n")
        #fclose StreamId
        #include "isosurface.tmp"
      #end // if
      mesh { MakeMesh(Depth, Segs, pMin, pMax, Smooth, false, TriCnt) }
    #break

    #case (1)
      #if (0 < strlen(FileName))
        #fopen StreamId FileName write
        #if (0 < strlen(MeshName))
          #write (StreamId, "#declare ", MeshName, " =\n")
        #end // if
        #write (StreamId, "mesh {\n")
        MakeMesh(Depth, Segs, pMin, pMax, Smooth, true, TriCnt)
        #write (StreamId, "}\n")
        #write (StreamId, "\n#declare TriCnt = ", TriCnt, ";\n")
        #fclose StreamId
      #end // if

    #case (2)
      #if (0 < strlen(FileName))
        #if (file_exists(FileName))
          #include FileName
        #end // if
      #end // if
    #break
  #else
    #declare TriCnt = 0;
  #end // switch

  #debug concat("\nTriangle Count: ", str(TriCnt, 0, 0), "\n")

#end // macro Meshify

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A
// Set varibles to default values if they are undefined

// Value Being Solved for

#ifndef (isoThreshold)
  #declare isoThreshold = 0;
#end // ifndef


#ifndef (isoSmooth)
  #declare isoSmooth = no;
#end // ifndef


#ifndef (isoNormalAccuracy)
  #declare isoNormalAccuracy = 1E-5;
#else
  #if (0 = isoNormalAccuracy)
    #declare isoNormalAccuracy = 1E-5;
  #end // if
#end // ifndef


// Function Extents

#ifndef (isoMin)
  #declare isoMin = -<1, 1, 1>;
#end // ifndef

#ifndef (isoMax)
  #declare isoMax = <1, 1, 1>;
#end // ifndef


// Accuracy

#ifndef (isoSegs)
  #declare isoSegs = <1, 1, 1>*6;
#else
  #declare isoSegs = <max(isoSegs.x, 2), max(isoSegs.y, 2), max(isoSegs.z, 2)>;
#end // ifndef


// Recursion depth for subdivision of cells

#ifndef (Depth)
  #declare Depth = 2;
#end // ifndef


// File to save in

#ifndef (isoFileOption)
  #declare isoFileOption = 0; // 0 = Load, 1 = Save, 2 = Ignore
#end // ifndef

#ifndef (isoFile)
  #declare isoFile = "";
#end // ifndef

#ifndef (isoName)
  #declare isoName = "";
#end // ifndef


// Function in Question

#ifndef (Fn)
  #declare Fn = function { x*x + y*y + z*z - 1 } // A sphere
#end // ifndef


// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A

// Counter for total number of triangles in the mesh.

#declare triCount = 0;


// Not used

#declare saveIsoInFile = (0 < strlen(isoFile) & 1 = isoFileOption);


#declare T_Fn = function { Fn(x, y, z) - isoThreshold }
#declare _H = isoNormalAccuracy;
#declare GX_Fn = function { (T_Fn(x + _H, y, z) - T_Fn(x - _H, y, z))/_H/2 }
#declare GY_Fn = function { (T_Fn(x, y + _H, z) - T_Fn(x, y - _H, z))/_H/2 }
#declare GZ_Fn = function { (T_Fn(x, y, z + _H) - T_Fn(x, y, z - _H))/_H/2 }

Meshify(
  Depth, isoSegs,
  isoMin, isoMax,
  isoSmooth,
  isoFileOption, isoFile, isoName,
  triCount
)

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= A
