/*
	Original file:	Isosurface.inc by Kevin Loney
									adapted by Jaap Frank
	File: 					Isosurf_KL_JF.inc	 
	
	(July 2003 points 1 to 4, februari 2004 point 5)
	
	Changes:
	1.	Changed if_statements to (.. ? .. : ..). Gain of about 10%.
	2.	Changed calls to 'math.inc' for triangle normals into functions.
			Total gain 22%.
	3.	Changed calls to interpolation macro into direct code.
			Total gain 27%.
	4.	The major change is in the calculation of the vertex 
			function values of the grid	cells.	In the original file 
			all vertices are calculated for every grid cell, but that
			means that the values for inside grid cells are calculated 
			eight times for the same X,Y,Z-point.
			I've changed this in two YZplane arrays and transfer the 
			data from the right YZplane to the left YZplane if 'X' is 
			increased with 'xstep'. Although the overhead is greater,
			there is a slight improvement in speed, but I think that 
			it will be considerable if the isofunctions become complicated.
			Total gain 37.5%.
	NEW !!
	5.	Introduced adaptive subdivision. If the Depth-value is greater
			then 0 and a cell contains a piece of the surface, the cell is 
			subdivided in 8 smaller cells. This is recursed Depth-times.
			Now you can start with a rather crude grid and let the recursion 
			do the fine tuning.
			The following statistic are made with a iso-sphere + crackle:
			
  isoSegs                    Depth (isoSegs*2^Depth) 	  ParseTime (450MHz)
  ------------------------------------------------------------------------
  <6,6,6>  (Start values)    0  (No subdivision)             4 sec
  <12,12,12>  (Effective)    1  (First subdivision)         21 sec
  <24,24,24>      ,,         2  (Second subdivision)        97 sec
  <48,48,48>      ,,         3     etc                     401 sec
  <96,96,96>      ,,         4     etc                    1228 sec
  <192,192,192>   ,,         5     etc                    5161 sec
	------------------------------------------------------------------------
  <24,24,24> with the original file of Kevin Loney:        223 sec

			Total gain about 55% at least, but will be greater with bigger 
			Depth values. As you can see, the parse time becomes about 
			5 downto 3 times larger with every Depth step. The last step it 
			gave the fine structure of the surface and then a mean four out 
			of eight subcells contains a piece of the surface.
			This system is usable for smooth surfaces, else there are small
			errors in the surface.
*/

//Value Being Solved for
#ifndef(isoThreshold) 				#declare isoThreshold = 0;						#end
#ifndef(isoSmooth)						#declare isoSmooth = no;							#end
#ifndef(isoNormalAccuracy)		#declare isoNormalAccuracy = .00001;	#end

//Function Extents
#ifndef(isoMin)						#declare isoMin = -<1, 1, 1>;					#end
#ifndef(isoMax)						#declare isoMax = <1, 1, 1>;					#end

//Accuracy
#ifndef(isoSegs)					#declare isoSegs = <6, 6, 6>;				#end
#ifndef(Depth)						#declare Depth	=	2;								#end	//	Recursion depth of subdivision of cells

//File to save in
#ifndef(isoFileOption)		#declare isoFileOption = 0;					#end		//0 = Load, 1 = Save, 2 = Ignore
#ifndef(isoFile)					#declare isoFile = "";							#end
#ifndef(isoName)					#declare isoName = "";							#end

//Function in Question

#ifndef(Fn)							#declare Fn = function(x,y,z) {x*x+y*y+z*z-1}	#end

//Compute function extents along each axis
#declare xmin = isoMin.x; #declare xmax = isoMax.x;
#declare ymin = isoMin.y; #declare ymax = isoMax.y;
#declare zmin = isoMin.z; #declare zmax = isoMax.z;

//Number of segments to break the mesh into along each axis
#declare xsegs = isoSegs.x;
#declare ysegs = isoSegs.y;
#declare zsegs = isoSegs.z;

//Size of each step
#declare xstep = (xmax - xmin) / xsegs;
#declare ystep = (ymax - ymin) / ysegs;
#declare zstep = (zmax - zmin) / zsegs;

#local vertex = array[8]							//Vertex coordinates of each corners of the current grid cell
#local value  = array[8]							//The function values at each grid cell vertex coordinate
#declare triCount = 0;								//Total number of triangles in the mesh

#if(strlen(isoFile) & isoFileOption = 1)
	#declare saveIsoInFile = yes;
#else
	#declare saveIsoInFile = no;
#end
#declare Accuracy = abs(isoNormalAccuracy);

//---------------------------------------------------------------------------------------------
//		Gradient functions for normals of smooth_triangle
//---------------------------------------------------------------------------------------------
#declare GradX = function(XX,YY,ZZ){(Fn(XX+Accuracy,YY,ZZ)-Fn(XX-Accuracy,YY,ZZ))/(2*Accuracy)}
#declare GradY = function(XX,YY,ZZ){(Fn(XX,YY+Accuracy,ZZ)-Fn(XX,YY-Accuracy,ZZ))/(2*Accuracy)}
#declare GradZ = function(XX,YY,ZZ){(Fn(XX,YY,ZZ+Accuracy)-Fn(XX,YY,ZZ-Accuracy))/(2*Accuracy)}

//---------------------------------------------------------------------------------------------
//		Creation of the triangles
//---------------------------------------------------------------------------------------------
#macro makeTri(a, b, c)
	#if(saveIsoInFile)
		#if(isoSmooth)
			#local AX = a.x;	#local BX = b.x;	#local CX = c.x;
			#local AY = a.y;	#local BY = b.y;	#local CY = c.y;
			#local AZ = a.z;	#local BZ = b.z;	#local CZ = c.z;
			#write(isoStream,
				"smooth_triangle{",a, ",<",GradX(AX,AY,AZ),",",GradY(AX,AY,AZ),",",GradZ(AX,AY,AZ),">, ",
													 b, ",<",GradX(BX,BY,BZ),",",GradY(BX,BY,BZ),",",GradZ(BX,BY,BZ),">, ",
													 c, ",<",GradX(CX,CY,CZ),",",GradY(CX,CY,CZ),",",GradZ(CX,CY,CZ),">}\n")
		#else
			#write(isoStream, "triangle{",a,",",b,",",c,"}\n")
		#end
	#else
		#if(isoSmooth)
			#local AX = a.x;	#local BX = b.x;	#local CX = c.x;
			#local AY = a.y;	#local BY = b.y;	#local CY = c.y;
			#local AZ = a.z;	#local BZ = b.z;	#local CZ = c.z;
			smooth_triangle {a, <GradX(AX,AY,AZ),GradY(AX,AY,AZ),GradZ(AX,AY,AZ)>,
											 b, <GradX(BX,BY,BZ),GradY(BX,BY,BZ),GradZ(BX,BY,BZ)>,
											 c, <GradX(CX,CY,CZ),GradY(CX,CY,CZ),GradZ(CX,CY,CZ)> }
		#else
			triangle {a, b, c}
		#end
	#end
#end

//---------------------------------------------------------------------------------------------
//		Calculate triangle vertices by interpolation and call makeTri()
//---------------------------------------------------------------------------------------------
#macro polygonizeTetra(v0, v1, v2, v3, vertex, value)

	#local triIdx = 0;
	#local tri = array[3]
	
	#local triIdx = (value[v0]<0 ?triIdx+1 :triIdx);
	#local triIdx = (value[v1]<0 ?triIdx+2 :triIdx);
	#local triIdx = (value[v2]<0 ?triIdx+4 :triIdx);
	#local triIdx = (value[v3]<0 ?triIdx+8 :triIdx);
	
	#switch(triIdx)
		#case(1)
		#case(14)
			#local tri[0] = (vertex[v1]-vertex[v0])*((isoThreshold-value[v0])/(value[v1]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v2]-vertex[v0])*((isoThreshold-value[v0])/(value[v2]-value[v0]))+vertex[v0];
			#local tri[2] = (vertex[v3]-vertex[v0])*((isoThreshold-value[v0])/(value[v3]-value[v0]))+vertex[v0];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(2)
		#case(13)
			#local tri[0] = (vertex[v0]-vertex[v1])*((isoThreshold-value[v1])/(value[v0]-value[v1]))+vertex[v1];
			#local tri[1] = (vertex[v3]-vertex[v1])*((isoThreshold-value[v1])/(value[v3]-value[v1]))+vertex[v1];
			#local tri[2] = (vertex[v2]-vertex[v1])*((isoThreshold-value[v1])/(value[v2]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(3)
		#case(12)
			#local tri[0] = (vertex[v3]-vertex[v0])*((isoThreshold-value[v0])/(value[v3]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v2]-vertex[v0])*((isoThreshold-value[v0])/(value[v2]-value[v0]))+vertex[v0];
			#local tri[2] = (vertex[v3]-vertex[v1])*((isoThreshold-value[v1])/(value[v3]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#local tri[0] = tri[2];
			#local tri[2] = tri[1];
			#local tri[1] = (vertex[v2]-vertex[v1])*((isoThreshold-value[v1])/(value[v2]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(4)
		#case(11)
			#local tri[0] = (vertex[v0]-vertex[v2])*((isoThreshold-value[v2])/(value[v0]-value[v2]))+vertex[v2];
			#local tri[1] = (vertex[v1]-vertex[v2])*((isoThreshold-value[v2])/(value[v1]-value[v2]))+vertex[v2];
			#local tri[2] = (vertex[v3]-vertex[v2])*((isoThreshold-value[v2])/(value[v3]-value[v2]))+vertex[v2];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(5)
		#case(10)
			#local tri[0] = (vertex[v1]-vertex[v0])*((isoThreshold-value[v0])/(value[v1]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v3]-vertex[v2])*((isoThreshold-value[v2])/(value[v3]-value[v2]))+vertex[v2];
			#local tri[2] = (vertex[v3]-vertex[v0])*((isoThreshold-value[v0])/(value[v3]-value[v0]))+vertex[v0];
			makeTri(tri[0], tri[1], tri[2])
			#local tri[2] = tri[1];
			#local tri[1] = (vertex[v2]-vertex[v1])*((isoThreshold-value[v1])/(value[v2]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(6)
		#case(9)
			#local tri[0] = (vertex[v1]-vertex[v0])*((isoThreshold-value[v0])/(value[v1]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v3]-vertex[v1])*((isoThreshold-value[v1])/(value[v3]-value[v1]))+vertex[v1];
			#local tri[2] = (vertex[v3]-vertex[v2])*((isoThreshold-value[v2])/(value[v3]-value[v2]))+vertex[v2];
			makeTri(tri[0], tri[1], tri[2])
			#local tri[1] = (vertex[v2]-vertex[v0])*((isoThreshold-value[v0])/(value[v2]-value[v0]))+vertex[v0];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(7)
		#case(8)
			#local tri[0] = (vertex[v2]-vertex[v3])*((isoThreshold-value[v3])/(value[v2]-value[v3]))+vertex[v3];
			#local tri[1] = (vertex[v0]-vertex[v3])*((isoThreshold-value[v3])/(value[v0]-value[v3]))+vertex[v3];
			#local tri[2] = (vertex[v1]-vertex[v3])*((isoThreshold-value[v3])/(value[v1]-value[v3]))+vertex[v3];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
	#end

#end


//---------------------------------------------------------------------------------------------
//		Subdivide cell and call makeCell()
//---------------------------------------------------------------------------------------------
#macro SubDivideCell(Depth,vertex,value,dX,dY,dZ)

	#local LX = vertex.x;		#local LY = vertex.y;		#local LZ = vertex.z;
	#local hX = dX/2;				#local hY = dY/2;				#local hZ = dZ/2;
	//	Create array of SubArrays
	#local Vert = array[8];
	#local Val  = array[8];
	#local SubVert = array[8];	//	SubCell
	//	Prefill Sub_vertices
	#local SubVert[0] = <LX   , LY   , LZ   >;
	#local SubVert[1] = <LX+hX, LY   , LZ   >;
	#local SubVert[2] = <LX+hX, LY   , LZ+hZ>;
	#local SubVert[3] = <LX   , LY   , LZ+hZ>;
	#local SubVert[4] = <LX   , LY+hY, LZ   >;
	#local SubVert[5] = <LX+hX, LY+hY, LZ   >;
	#local SubVert[6] = <LX+hX, LY+hY, LZ+hZ>;
	#local SubVert[7] = <LX   , LY+hY, LZ+hZ>;
	#local SubVal  = array[8];	//	SubCell
	#local I = 0;
	#while (I<8)
		#local Vert[I] = SubVert;	//	Filled with values.
		#local Val [I] = SubVal;	//	All not assigned.
		#local I = I+1;
	#end
	//	Transfer old values.	SubCube numbering is different because of loops!!
	#local Val[0][0] = value[0];	//0,0,0, SubCube 0
	#local Val[2][1] = value[1];	//1,0,0, SubCube 2
	#local Val[3][2] = value[2];	//1,0,1, SubCube 3
	#local Val[1][3] = value[3];	//0,0,1, SubCube 1
	#local Val[4][4] = value[4];	//0,1,0, SubCube 4
	#local Val[6][5] = value[5];	//1,1,0, SubCube 6
	#local Val[7][6] = value[6];	//1,1,1, SubCube 7
	#local Val[5][7] = value[7];	//0,1,1, SubCube 5

	//	Fill arrays, call makeCell and transfer values
	#local I=0;		//	Y-direction
	#while (I<2)
		#local J=0;		//	X-direction
		#while (J<2)
			#local K=0;		//	Z-direction
			#while (K<2)
				#local Index = 4*I+2*J+K;		//Calculate SubCube_Number
				#local U = Vert[Index];
				#local T = Val[Index];
				#local M=0;									//	8 vertices and values
				#while (M<8)
					#local U[M] = U[M] + <J*hX,I*hY,K*hZ>;				//	Shift vertices depending on I, J and K
					#ifndef(T[M]) 
						#local T[M] = Fn(U[M].x, U[M].y, U[M].z);		//	Calculate new values if not assigned
					#end
					#local M = M+1;
				#end

				makeCell(Depth, U, T, hX, hY, hZ)
				
				//Transfer values
				#if (K=0)	//Z_planes	SubCube behind
					#local Val[Index+1][0] = T[3];
					#local Val[Index+1][1] = T[2];
					#local Val[Index+1][4] = T[7];
					#local Val[Index+1][5] = T[6];
				#end
				#if (J=0)	//X_planes	SubCube beside
					#local Val[Index+2][0] = T[1];
					#local Val[Index+2][3] = T[2];
					#local Val[Index+2][4] = T[5];
					#local Val[Index+2][7] = T[6];
				#end
				#if (I=0)	//Y_planes	SubCube above
					#local Val[Index+4][0] = T[4];
					#local Val[Index+4][1] = T[5];
					#local Val[Index+4][2] = T[6];
					#local Val[Index+4][3] = T[7];
				#end
				#local K = K+1;
			#end
			#local J = J+1;
		#end
		#local I = I+1;
	#end
	
#end

//---------------------------------------------------------------------------------------------
//		Decision to polygonizeCell or subdivideCell
//---------------------------------------------------------------------------------------------
#macro makeCell(Depth,vertex,value,dX,dY,dZ)

	#local lessThan = 0; 
	#local greaterThan = 0;
	#local i = 0;
	#while (i < 8)
		#local lessThan = (value[i]<0 ?lessThan+1 :lessThan);
		#local greaterThan = (value[i]>0 ?greaterThan+1 :greaterThan);
		#local i=i+1;
	#end
	#if(lessThan & greaterThan)
		#if (Depth)
			SubDivideCell(Depth-1,vertex[0],value,dX,dY,dZ)
		#else
			polygonizeTetra(0, 2, 3, 7,vertex,value)
			polygonizeTetra(0, 2, 6, 7,vertex,value)
			polygonizeTetra(0, 4, 6, 7,vertex,value)
			polygonizeTetra(0, 6, 1, 2,vertex,value)
			polygonizeTetra(0, 6, 1, 4,vertex,value)
			polygonizeTetra(5, 6, 1, 4,vertex,value)
		#end
	#end

#end

//---------------------------------------------------------------------------------------------
//		Loop for crude starting grid
//---------------------------------------------------------------------------------------------
#if(isoFileOption != 0)

	#if(saveIsoInFile)
		#fopen isoStream isoFile write
		#if(strlen(isoName))
			#write(isoStream, "#declare ", isoName, " = ")
		#end
		#write(isoStream, "mesh{\n")
	#end

	//Prepare YZ-plane
	#declare YZplaneLeft = array[ysegs+1][zsegs+1]			//Remember calculated points in YZ plane of left ...
	#declare YZplaneRight = array[ysegs+1][zsegs+1]			//	... and of right side of cubes
	#declare NXmax = xsegs;
	#declare NYmax = ysegs;
	#declare NZmax = zsegs;
	
	#debug "\n Start: Filling of Right YZ_plane_1 ...\n"
	#declare XX = xmin;
	#declare YY = ymin;
	#declare IY = 0;
	#while(IY <= NYmax)
		#declare ZZ = zmin;
		#declare IZ = 0;
		#while(IZ <= NZmax)
			#declare YZplaneRight[IY][IZ] = Fn(XX, YY, ZZ);
			#declare ZZ = ZZ + zstep;
			#declare IZ = IZ + 1;
		#end
		#declare YY = YY + ystep;
		#declare IY = IY + 1;
	#end	//Fill right side of cubes
	
	#if(isoFileOption = 2)
		mesh {
	#end
		#declare X = xmin;
		#declare NX = 0;
		#while(NX < NXmax)
		
			//Transfer Right YZ-plane to the left and fill right YZ-plane with new values
			#debug concat("Transfering to Left YZ_plane_",str(NX,0,0)," and Filling of Right YZ_plane_",str(NX+1,0,0)," ...\n")
			#declare XX = X + xstep;
			#declare YY = ymin;
			#declare IY = 0;
			#while(IY <= NYmax)
				#declare ZZ = zmin;
				#declare IZ = 0;
				#while(IZ <= NZmax)
					#declare YZplaneLeft[IY][IZ] = YZplaneRight[IY][IZ];
					#declare YZplaneRight[IY][IZ] = Fn(XX, YY, ZZ);
					#declare ZZ = ZZ + zstep;
					#declare IZ = IZ + 1;
				#end
				#declare YY = YY + ystep;
				#declare IY = IY + 1;
			#end
			
			#declare Y = ymin;
			#declare NY = 0;
			#while(NY < NYmax)
				#declare Z = zmin;
				#declare NZ = 0;
				#while(NZ < NZmax)
					#local vertex[0] = <X, Y, Z>;
					#local vertex[1] = <X+xstep, Y, Z>;
					#local vertex[2] = <X+xstep, Y, Z+zstep>;
					#local vertex[3] = <X, Y, Z+zstep>;
					#local vertex[4] = <X, Y+ystep, Z>;
					#local vertex[5] = <X+xstep, Y+ystep, Z>;
					#local vertex[6] = <X+xstep, Y+ystep, Z+zstep>;
					#local vertex[7] = <X, Y+ystep, Z+zstep>;
				
					#local value[0] = YZplaneLeft[NY][NZ];
					#local value[1] = YZplaneRight[NY][NZ];
					#local value[2] = YZplaneRight[NY][NZ+1];
					#local value[3] = YZplaneLeft[NY][NZ+1];
					#local value[4] = YZplaneLeft[NY+1][NZ];
					#local value[5] = YZplaneRight[NY+1][NZ];
					#local value[6] = YZplaneRight[NY+1][NZ+1];
					#local value[7] = YZplaneLeft[NY+1][NZ+1];
	
					makeCell(Depth,vertex,value,xstep,ystep,zstep)
	
					#declare Z = Z + zstep;
					#declare NZ = NZ + 1;
				#end	//#while(NZ < NZmax)
				#declare Y = Y + ystep;
				#declare NY = NY + 1;
			#end	//#while(NY < NYmax)
			#declare X = X + xstep;
			#declare NX = NX + 1;
		#end	//#while(NX < NXmax)
	#if(isoFileOption = 2)
		}
	#end
#end

//---------------------------------------------------------------------------------------------
//		Last things to do
//---------------------------------------------------------------------------------------------
#if(saveIsoInFile)
	#write(isoStream, "}\n")
	#write(isoStream, "#declare triCount = ", triCount, ";")
	#fclose isoStream
#end

#if(isoFileOption != 2)
	#if(strlen(isoFile))
		#if(file_exists(isoFile))
			#include isoFile
		#end
	#end
#end

#debug concat("Triangle Count: ", str(triCount, 0, 0), "\n")