/*
 *  DF3 Proximity Pattern
 *
 *    Version 0.9
 */


// -- Include Files -----------------------------------------------------------

#include "arrays.inc"


#declare Proximity_Interpolation = 2;
#declare Proximity_MeshMode = false;

#macro Proximity_SetInterpolation( n )
	#declare Proximity_Interpolation = n;
#end

#macro Proximity_SetMeshMode( b )
	#declare Proximity_Interpolation = b;
#end


#macro inside_m( obj, pos )
	#local current = pos;
	#local dir = <1,1,1>;
	#local done = 0;
	#local num = 0;
	#while ( done != 1 )
		#local norm = <0,0,0>;
		#local inter = trace( obj, current, dir, norm );
		#if ( vlength( norm ) != 0 )
			#local num = num + 1;
			#local current = inter + dir*0.001;
		#else
			#local done = 1;
		#end
	#end
	(mod( num, 2 ) = 1)
#end


#macro halton( index, base )
	#local out = 0.0;
	#local fraction = 1.0 / base;
	#local i = index;
	#while( i > 0 )
		#local remainder = mod( i, base );
		#local out = out + (fraction * remainder);
		#local i = int(i / base);
		#local fraction = fraction / base;
	#end

	out
#end


#macro halton3D( n )
	#local baseX = 2;
	#local baseY = 3;
	#local baseZ = 5;

	< halton( n, baseX ), halton( n, baseY ), halton( n, baseZ ) >
#end

#macro Proximity_GenerateMap( obj, map_size, num_samples, fraction, filename )
    // Step 1. Setup the sampling array (halton seq)
    #local halton_array = array[num_samples];
    #local i = 0;
    #local j = 0;
    #while( i < num_samples )
        #local randomPoint = halton3D( j ) - 0.5;
        #if( vlength( randomPoint ) < 0.5 )
            #declare halton_array[ i ] = randomPoint;
            #local i = i + 1;
        #end
        #local j = j + 1;
    #end

    // Step 2. Create the prox array
    #local prox_array = array[map_size.x][map_size.y][map_size.z];

    // Step 3. Determine the extents of the object
    #local minX = min_extent(obj).x;
    #local maxX = max_extent(obj).x;
    #local minY = min_extent(obj).y;
    #local maxY = max_extent(obj).y;
    #local minZ = min_extent(obj).z;
    #local maxZ = max_extent(obj).z;

    #local sliceXSize = maxX - minX;
    #local sliceYSize = maxY - minY;
    #local sliceZSize = maxZ - minZ;

    #local numXSamples = map_size.x;
    #local numYSamples = map_size.y;
    #local numZSamples = map_size.z;

    #local stepXSize = sliceXSize / (numXSamples);
    #local stepYSize = sliceYSize / (numYSamples);
    #local stepZSize = sliceZSize / (numZSamples);

    // Step 4. Calculate the proximity data
    #local i = 0;
    #while( i < numXSamples )
        #local j = 0;
        #while( j < numYSamples )
            #local k = 0;
            #while( k < numZSamples )
                #local xpos = minX + (stepXSize / 2) + (i * stepXSize);
                #local ypos = minY + (stepYSize / 2) + (j * stepYSize);
                #local zpos = minZ + (stepZSize / 2) + (k * stepZSize);
                #local numInside = 0;
                #local n = 0;
                #while( n < num_samples )
                	#if( Proximity_MeshMode = true )
	                    #if( inside_m ( obj, <xpos, ypos, zpos> + halton_array [ n ] * stepXSize * fraction ) )
	                        #local numInside = numInside + 1;
	                    #end
                    #else
	                    #if( inside ( obj, <xpos, ypos, zpos> + halton_array [ n ] * stepXSize * fraction ) )
	                        #local numInside = numInside + 1;
	                    #end
			#end
                    #if( n > 10 & numInside = 0 )  // TODO - make this bailout tunable
                        #local n = num_samples;
                    #end
                    #local n = n + 1;
                #end
                #local prox_array[i][j][k] = numInside / num_samples;
                #local k = k + 1;
            #end
            #local j = j + 1;
        #end
        #local i = i + 1;
    #end

    // Write the DF3 file
    ARRAYS_WriteDF3( prox_array, filename, 8 )
#end

#macro Proximity_LoadMap( obj, filename )
    #declare temp = pigment {
        density_file df3 filename interpolate Proximity_Interpolation
        scale max_extent(obj) - min_extent(obj) translate min_extent(obj)
    }

    temp
#end

