#include "Colors.inc"
#include "math.inc"
/*
#declare cam_pos=<1, 2, 3>*.75;
camera {
//orthographic
// location <60, 80, 100>*fctr
// look_at <0,0,0>
 location cam_pos*1
 look_at <.5,.5,.5>*0

// rotate x*90
 
}

//plane{y, 0 pigment {color Red}}

light_source {
 cam_pos 
 color White
// area_light <5, 0, 0>, <0, 0, 5>, 5, 5
// adaptive 0
// jitter
// point_at <0,0,0>
 shadowless
}

*/

#macro rtrn_seg(new_obj,v3)

        #local rtrn_obj=difference{
        object{new_obj}

        #local x_inc=0;
        #while (x_inc<=1)
                #local y_inc=0;
                #while (y_inc<=1)
                        #local z_inc=0;
                        #while (z_inc<=1)
                                #local rtrn=VEq(<x_inc,y_inc,z_inc>,v3);
//                        #debug concat("<",str(x_inc,0,0),",",str(y_inc,0,0),",",str(z_inc,0,0),">\n")
                                #if(rtrn)
                                #else
                                        box_diff[x_inc][y_inc][z_inc]
                                #end
                                      
                                #local z_inc=z_inc+1;
                        #end
                        #local y_inc=y_inc+1;
                #end
                #local x_inc=x_inc+1;
        #end


        }


        rtrn_obj



#end

#macro rounded_box(u1,u2,rad)
        #local tol=0.0001;
/*       
        #if(rad.x=0)
                #local sw_rad=<0,sw_rad.y,sw_rad.z>;                        
        #end
        #if(rad.y=0)
                #local sw_rad=<sw_rad.x,0,sw_rad.z>;                        
        #end
        #if(rad.z=0)
                #local sw_rad=<sw_rad.x,sw_rad.y,0>;                        
        #end
*/
        #local v1=<min(u1.x,u2.x)+rad.x,min(u1.y,u2.y)+rad.y,min(u1.z,u2.z)+rad.z>;
        #local v2=<max(u1.x,u2.x)-rad.x,max(u1.y,u2.y)-rad.y,max(u1.z,u2.z)-rad.z>;
        #local base=merge{
                box{v1-(x*rad.x+(y+z)*tol),v2+(x*rad.x+(y+z)*tol)}
                box{v1-(y*rad.y+(x+z)*tol),v2+(y*rad.y+(x+z)*tol)}
                box{v1-(z*rad.z+(x+y)*tol),v2+(z*rad.z+(x+y)*tol)}
        }

        #local x_dim =abs(v1.x-v2.x);
        #local y_dim =abs(v1.y-v2.y);
        #local z_dim =abs(v1.z-v2.z);
        #local max_size=max(x_dim,y_dim,z_dim)+1;
///*
        #declare box_diff=array[2][2][2]{
                {// x < 0
                        {// y < 0
                                box{// z < 0
                                        <0,0,0>,<-1,-1,-1>*max_size
                                },
                                        box{// z > 0
                                        <0,0,0>,<-1,-1,+1>*max_size
                                }
                        },
                        {// y > 0
                                box{// z < 0
                                        <0,0,0>,<-1,+1,-1>*max_size
                               },
                                box{// z > 0
                                       <0,0,0>,<-1,+1,+1>*max_size
                               }
                       }
               },
               {// x > 0
                        {// y < 0
                                box{// z < 0
                                        <0,0,0>,<+1,-1,-1>*max_size
                                },
                                box{// z > 0
                                        <0,0,0>,<+1,-1,+1>*max_size
                                }
                        },
                        {// y > 0
                                box{// z < 0
                                        <0,0,0>,<+1,+1,-1>*max_size
                                },
                                box{// z > 0
                                        <0,0,0>,<+1,+1,+1>*max_size
                                }
                        }
                }
        }
//*/
        #if(rad.x*rad.y*rad.z)
                #local sphr_obj=sphere{0,1 scale rad};
        #else   
                #local sphr_obj=intersection{
                        #if(rad.x)
                                cylinder{-<max_size,0,0>,<max_size,0,0>,1 scale <1,rad.y,rad.z>}
                        #else
                                box{-<max_size,1,1>,<max_size,1,1> scale <1,rad.y,rad.z>}        
                        #end

                        #if(rad.y)
                                cylinder{-<0,max_size,0>,<0,max_size,0>,1 scale <rad.x,1,rad.z>}
                        #else
                                box{-<1,max_size,1>,<1,max_size,1> scale <rad.x,1,rad.z>}        
                        #end
                
                        #if(rad.z)
                                cylinder{-<0,0,max_size>,<0,0,max_size>,1 scale <rad.x,rad.y,1>}
                        #else
                                box{-<1,1,max_size>,<1,1,max_size> scale <rad.x,rad.y,1>}        
                        #end
                       
                }
        #end
        #local corners=merge{
         
                object{rtrn_seg(sphr_obj,<0,0,0>)  translate v1+x*0*x_dim+y*0*y_dim+z*0*z_dim}
                object{rtrn_seg(sphr_obj,<0,0,1>)  translate v1+x*0*x_dim+y*0*y_dim+z*1*z_dim}
                object{rtrn_seg(sphr_obj,<0,1,0>)  translate v1+x*0*x_dim+y*1*y_dim+z*0*z_dim}
                object{rtrn_seg(sphr_obj,<0,1,1>)  translate v1+x*0*x_dim+y*1*y_dim+z*1*z_dim}
                object{rtrn_seg(sphr_obj,<1,0,0>)  translate v1+x*1*x_dim+y*0*y_dim+z*0*z_dim}
                object{rtrn_seg(sphr_obj,<1,0,1>)  translate v1+x*1*x_dim+y*0*y_dim+z*1*z_dim}
                object{rtrn_seg(sphr_obj,<1,1,0>)  translate v1+x*1*x_dim+y*1*y_dim+z*0*z_dim}
                object{rtrn_seg(sphr_obj,<1,1,1>)  translate v1+x*1*x_dim+y*1*y_dim+z*1*z_dim}
        }

        #if(rad.x)
                #local cyl_x_obj=cylinder{0,<x_dim,0,0>,1 scale<1,rad.y,rad.z>};
        #else
                #local cyl_x_obj=box{-<0,1,1>,<x_dim,1,1> scale<1,rad.y,rad.z>};
        #end

        #if(rad.y)
                #local cyl_y_obj=cylinder{0,<0,y_dim,0>,1 scale<rad.x,1,rad.z>};
        #else
                #local cyl_y_obj=box{-<1,0,1>,<1,y_dim,1> scale<rad.x,1,rad.z>};
        #end

        #if(rad.z)
                #local cyl_z_obj=cylinder{0,<0,0,z_dim>,1 scale<rad.x,rad.y,1>};
        #else
                #local cyl_z_obj=box{-<1,1,0>,<1,1,z_dim> scale<rad.x,rad.y,1>};
        #end






        #local x_edges=merge{
                object{rtrn_seg(cyl_x_obj,<1,0,0>)  translate v1+y*0*y_dim+z*0*z_dim}
                object{rtrn_seg(cyl_x_obj,<1,0,1>)  translate v1+y*0*y_dim+z*1*z_dim}
                object{rtrn_seg(cyl_x_obj,<1,1,0>)  translate v1+y*1*y_dim+z*0*z_dim}
                object{rtrn_seg(cyl_x_obj,<1,1,1>)  translate v1+y*1*y_dim+z*1*z_dim}

        }

        #local y_edges=merge{
                object{rtrn_seg(cyl_y_obj,<0,1,0>)  translate x*0*x_dim+v1+z*0*z_dim}
                object{rtrn_seg(cyl_y_obj,<0,1,1>)  translate x*0*x_dim+v1+z*1*z_dim}
                object{rtrn_seg(cyl_y_obj,<1,1,0>)  translate x*1*x_dim+v1+z*0*z_dim}
                object{rtrn_seg(cyl_y_obj,<1,1,1>)  translate x*1*x_dim+v1+z*1*z_dim}

        }

        #local z_edges=merge{
                object{rtrn_seg(cyl_z_obj,<0,0,1>)  translate x*0*x_dim+y*0*y_dim+v1}
                object{rtrn_seg(cyl_z_obj,<0,1,1>)  translate x*0*x_dim+y*1*y_dim+v1}
                object{rtrn_seg(cyl_z_obj,<1,0,1>)  translate x*1*x_dim+y*0*y_dim+v1}
                object{rtrn_seg(cyl_z_obj,<1,1,1>)  translate x*1*x_dim+y*1*y_dim+v1}

        }

        #declare full=merge{
///*
                object{base}
                object{corners}
                object{x_edges}
                object{y_edges}
                object{z_edges}

//box{v1-x*rad.x,v2+x*rad.x}

        }


        object{full}

#end


#macro receded_rounded_box(u1,u2,rad,recessed_x,recessed_y,recessed_z)
        #local v1=<min(u1.x,u2.x),min(u1.y,u2.y),min(u1.z,u2.z)>;
        #local v2=<max(u1.x,u2.x),max(u1.y,u2.y),max(u1.z,u2.z)>;


        #local tol=0.0001;

        #declare base=merge{
 
                difference{
                        rounded_box(v1,v2,rad)
                                rounded_box(v1-3*x*rad.x+(y*rad.y+z*rad.z),
                                        v2+3*x*rad.x-(y*rad.y+z*rad.z),rad)
                                rounded_box(v1-3*y*rad.y+(x*rad.x+z*rad.z),
                                        v2+3*y*rad.y-(x*rad.x+z*rad.z),rad)
                                rounded_box(v1-3*z*rad.z+(x*rad.x+y*rad.y),
                                        v2+3*z*rad.z-(x*rad.x+y*rad.y),rad)

                }
//                box{v1-(x*rad.x+y*rad.y+z*rad.z)*tol, v2+(x*rad.x+y*rad.y+z*rad.z)*tol}
                box{
                        v1-((x*rad.x+(y*rad.y+z*rad.z)*tol)*(1-recessed_x.u)+recessed_x.u*(x*rad.x+y*rad.y+z*rad.z)*tol),
                        v2+((x*rad.x+(y*rad.y+z*rad.z)*tol)*(1-recessed_x.v)+recessed_x.v*(x*rad.x+y*rad.y+z*rad.z)*tol)
                }
                box{
                        v1-((y*rad.y+(x*rad.x+z*rad.z)*tol)*(1-recessed_y.u)+recessed_y.u*(x*rad.x+y*rad.y+z*rad.z)*tol),
                        v2+((y*rad.y+(x*rad.x+z*rad.z)*tol)*(1-recessed_y.v)+recessed_y.v*(x*rad.x+y*rad.y+z*rad.z)*tol)
                }
                box{
                        v1-((z*rad.z+(x*rad.x+y*rad.y)*tol)*(1-recessed_z.u)+recessed_z.u*(x*rad.x+y*rad.y+z*rad.z)*tol),
                        v2+((z*rad.z+(x*rad.x+y*rad.y)*tol)*(1-recessed_z.v)+recessed_z.v*(x*rad.x+y*rad.y+z*rad.z)*tol)
                }


        }

        object{base}
                    
#end  
