///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//   AN ATTEMPTED AT MAKING A COILED WHIP BY: Mike C. A.K.A. "Mike the Elder"   //
//                                                                               //
//   This file is free of all copyright and may be used for whatever by anyone   //
//   with nothing better to do with his or her valuable time.                    //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////



//  Note: the whip is centered around the origin and has
//  a radius of just under 1 at scale=1 .


#include "shapes.inc" 
#include "shapes2.inc"


global_settings {max_trace_level 5}

camera {location <-15,12, -25> direction <0, 0,  20> right x*1.33 look_at <-.2,0,0>}

light_source{<-20,80,-40> rgb 1} 
sky_sphere {pigment { gradient y 
color_map {[ 0.0  rgb <.9,.9,1>] [ 0.5  rgb <.5,.5,1>]  [ 1.0  rgb <.9,.9,1>] }} rotate x*-15}

#declare QStone = texture{pigment{granite 
   color_map {[0 rgb<.99,.98,.86>] [.2 rgb<.83,.82,.70>][1 rgb<.73,.72,.60>]} } 
   normal{granite scale .2}
   finish{ambient .3 diffuse .7 phong .2 phong_size 20} }

#declare WhipTex =texture{ pigment{color rgb<.7,.5,.3> }
        finish{ambient .2 diffuse .8 reflection .05 phong .1 phong_size 30 }
        normal{quilted scale .1}}

#declare HndlTex =texture{ pigment{color rgb<.4,.25,.2> }
        finish{ambient .2 diffuse .8 reflection .05 phong .2 phong_size 30 }
        normal{quilted scale .3}}


superellipsoid{<.1,.1> scale <1.2,1,1.2> translate <0,-1,0> texture{QStone}}

/////////////////   C O I L E D   W H I P   ///////////////  

#declare NCR=3.5;
#declare CoiledWhip=union
{ 
////////////////////// MAIN COIL SECTION //////////////////
  
  #declare CEP=0; #while (CEP<NCR)
  object{Icosahedron texture{WhipTex} 
     scale .04-.02*CEP/NCR rotate<90,90,0> 
     rotate <CEP*360*12,0,0> 
     translate <0,.04-.02*CEP/NCR,.8-CEP*.16+.05*sin(.7+CEP*pi*3.2)> 
     rotate <0,NCR*360*CEP/NCR,0>}
  #declare CEP=CEP+.005; #end 
  
////////////////////// HANDLE SECTION /////////////////////
#declare HEP=0; #while(HEP<1)
  sphere{<0,0,0>,1 texture{HndlTex}
     scale .07-.02*sin(HEP*pi) rotate<90,90,0> 
     translate <-.7+.45*HEP,.07,.82> 
     }
  #declare HEP=HEP+.08; #end 
    
///////////// BRIDGE from MAIN to HAANDLE /////////////////  
  #declare CEP=0; #while (CEP>-.042)
  object{Icosahedron texture{WhipTex} 
     scale .04-.02*CEP/NCR rotate<90,90,0> 
     rotate <CEP*360*12,0,0> 
     translate <0,.04-.03*CEP/.042,.8-CEP*.16+.05*sin(.7+CEP*pi*3.2)> 
     rotate <0,NCR*360*CEP/NCR,0>}
  #declare CEP=CEP-.005; #end   
}


object{CoiledWhip}



