// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?

// +FN +UA

#version 3.6;

#include "colors.inc" 
#include "ring.inc"

#declare radiosity_on = true;



#if (radiosity_on)
// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples          
   
  }   
  assumed_gamma 1.0
}
#else
global_settings {
  assumed_gamma 1.0
}  
#end

// ----------------------------------------

camera {
  location  <12, 5, 13>
  direction 1.5*z
  right     x*image_width/image_height
  angle 58
  look_at   <53/12, 23/12,  0.0>
}  

plane {z, 0.0 rotate 45*y translate <130,0,140> texture { pigment { color rgb 1 } finish {ambient 0.001 diffuse 0.001} }  no_reflection}
plane {y, 0.0 rotate 20*x translate <0,4000,0> texture { pigment { color rgb 1 } finish {ambient 0.001 diffuse 0.1} }  no_reflection}

#declare Start    = 0.0;
#declare End      = 3.2;
#declare My_Clock = 3.2;//Start+(End-Start)*clock;


light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 3000, -3000>
} 

//sphere { 0, 5000 texture { pigment { color rgb 1 } finish {ambient 1 } } hollow }
 

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <5,3,6.5>
}
/*
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <40, 0, 0> <0, 0, 40> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <4, 80, -4>   // <x y z> position of light
}     
*/ 

#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }     
  }
} 

#default {
 texture {
  pigment { color rgb 0.3  }
  normal {           // (---surface bumpiness---)
    marble 0.5       // some pattern (and intensity)
    turbulence 0.5   // some turbulence
    scale <1,2,1>    // transformations
  }
  finish {           // (---surface finish---)
    ambient 0.01
    specular 0.3     // shiny
    roughness 1/100
    metallic
  }
 } 
}

#declare ring_tex = texture {
  pigment { color rgb 0.3  }
  normal {           // (---surface bumpiness---)
    marble 0.5       // some pattern (and intensity)
    turbulence 0.5   // some turbulence
    scale <1,2,1>    // transformations
  }  
  #if (radiosity_on)
  finish {           // (---surface finish---)
    ambient 0.0
    diffuse 0.3
    //specular 0.2     // shiny
    roughness 1/100
    metallic
  }
  #else
  finish {           // (---surface finish---)
    ambient 0.01
    specular 0.2     // shiny  
    roughness 1/100
    metallic    
  }  
  #end
} 

#declare inner_ring = texture {
  pigment { color rgb <0.3,0.3,1>  }
  finish {           // (---surface finish---)
    ambient 0.8
    
  }
} 

#declare outer_ring = texture {
  pigment { color rgb <1,0.9,0.2>  }
  finish {           // (---surface finish---)
    ambient 0.8
    
  }
}

#declare window = texture {
  pigment { color rgbt <0,0,0,1>  }
  finish {           // (---surface finish---)
    ambient 0.0 
    diffuse 0
    reflection 0.9    
  }
}


// ----------------------------------------
/*
plane {
  y, -5
  pigment { color rgb <0.7,0.5,0.3> }
} */

#macro hght (h)
  #if (My_Clock<(1+h))
     #declare Z = 10*(0.5+cos((My_Clock-h)*pi)/2);  
  #else
    #if (My_Clock<(2+0.5-h))
      #declare Z=0;
    #else
      #declare Z = 10*(0.5+cos((My_Clock-1-0.5+h)*pi)/2);
    #end  
  #end
#end


hght(0.1)
object {ring scale <0.5,1.2,0.5> translate <5,0+Z,6.5> }  
hght(0.15)
object {ring scale <0.5,1.2,0.5> translate <5,1.5+Z,6.5> } 
hght(0.2)
object {ring scale <0.5,1.2,0.5> translate <5,3+Z,6.5> } 
hght(0.25)
object {ring scale <0.5,1.2,0.5> translate <5,4.5+Z,6.5> } 
hght(0.3)
object {ring scale <0.5,1.2,0.5> translate <5,6+Z,6.5> } 




/*
light_source {
  0*x                 // light's position (translated below)
  color rgb <0.3,0.3,1>       // light's color
  area_light
  <0.2, 0, 0> <0, 0, 0.2> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 0, 0>   // <x y z> position of light
} 

light_source {
  0*x                 // light's position (translated below)
  color rgb <0.3,0.3,1>       // light's color
  area_light
  <0.2, 0, 0> <0, 0, 0.2> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 2, 0>   // <x y z> position of light
} 
 
light_source {
  0*x                 // light's position (translated below)
  color rgb <0.3,0.3,1>       // light's color
  area_light
  <0.2, 0, 0> <0, 0, 0.2> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 4, 0>   // <x y z> position of light
} 

light_source {
  0*x                 // light's position (translated below)
  color rgb <0.3,0.3,1>       // light's color
  area_light
  <0.2, 0, 0> <0, 0, 0.2> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 6, 0>   // <x y z> position of light
} 

light_source {
  0*x                 // light's position (translated below)
  color rgb <0.3,0.3,1>       // light's color
  area_light
  <0.2, 0, 0> <0, 0, 0.2> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 8, 0>   // <x y z> position of light
} 
  
*/
  
/*
cylinder { <0, -15, 0>, <0, 15, 0>, 150 texture {pigment {color rgbt 1}} hollow on
// describes inside of a shape (similar to texture, but for inside, not surface)
  interior {

  media {
  // (---general values---)
  intervals 10           // number of intervals used for sampling [10]
  samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  confidence 0.9         // statistic parameter higher->better quality [0.9]
  variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
  ratio 0.9              // distribution between lit and unlit areas [0.9]
  // (---media types---)
  //absorption rgb<0,1,0>  // absorbing media, block light of specified color
  //emission rgb<0,1,0>  // emitting media, emit light of specified color
  scattering {           // scattering media
    4,                   // scattering type 1=isotropic; 2=Mie haze; 3=Mie murky
                         // 4=Rayleigh; 5=Henyey-Greenstein
    rgb<0.001,0.001,0.001>           // color
    //eccentricity 0.25  // eccentricity for type 5 [0.0]
    //extinction 0.25     // for balancing amount of absorption [1.0]
  }
  // (---method---)
  //method 1             // old Povray 3.1 method
  //method 2             // new method with even distribution
  method 3               // adaptive sampling
  //aa_threshold 0.1     // accuracy threshold for method 3 [0.1]
  //aa_level 4           // maximum recursion depth for method 3 [4]
  //jitter 0.5           // randomness for method 2&3
  // (---density---)
  
  //density { cylindrical }


  // translate etc.
}

}

}  */

// axis
/*
cylinder { <0, 0, 0>, <13, 0, 0>, 1/12 pigment { color rgb <0,0,1> } } 
cylinder { <0, 0, 0>, <0, 8, 0>, 1/12 pigment { color rgb <1,0,0> } }
cylinder { <0, 0, 0>, <0, 0, 12>, 1/12 pigment { color rgb <0,1,0> } }  
*/
box { <43/12, 24.5/12, -4/12>, <63/12, 78.5/12, -4.05/12> texture {window} }
box { <112/12, 24.5/12, -4/12>, <65/12, 78.5/12, -4.05/12> texture {window} } 
box { <134/12, 24.5/12, -4/12>, <114/12, 78.5/12, -4.05/12> texture {window} }  

//box { <0, 6/12, 74/12>, <0.05, 25/12, 103/12> }  

//sphere { <5,0.5,6.5>, 0.5 }  

//box { <0,0,48/12>, <44/12,0.001,12> }
//box { <36/12,0,3>, <86/12,0.001,12> }
//box { <0,0,53.5/12>, <2.5/12,43/12, 59/12> }