// Persistence of Vision Ray Tracer Scene Description File
// File: ring.pov
// Vers: 3.6
// Desc: Stargate Transporter Rings
// Date: 6/21/2005
// Auth: Michael Sobers
//

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <1.0, 1, -10>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.1,  1.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

#default {
 texture {
  pigment { color rgb 0.3  }
  normal {           // (---surface bumpiness---)
    marble 0.5       // some pattern (and intensity)
    turbulence 0.5   // some turbulence
    scale <1,2,1>    // transformations
  }
  finish {           // (---surface finish---)
    ambient 0.01
    specular 0.2     // shiny
    roughness 1/100
    metallic
  }
 } 
}

// ----------------------------------------

plane {
  y, -1.2
  pigment { color rgb <0.7,0.5,0.3> }
} 

#include "ring.inc"

#declare Ringtop =    
pigment {
    wood
    color_map {
     [0 color rgbt <0,0,0>]
     [0.45 color rgbt <0,0,0>]
     [0.5 color rgb <1,1,1>]     
    }  
}
   
   
   
   
object { ring }     
object { ring translate 1*y}  
object { ring translate 2*y}
object { ring translate 3*y}  
object { ring translate -1*y}
