// Persistence of Vision Ray Tracer Scene Description File
// File: ring.inc
// Vers: 3.6
// Desc: Stargate Transporter Rings Include File
// Date: 6/21/2005
// Auth: Michael Sobers
//

#version 3.6; 

#ifndef (ring_tex) 

  #declare Radiosity=off;  
  
#end

#ifndef (ring_tex)

#declare ring_tex = texture {
  pigment { color rgb 0.2  }
  normal {           // (---surface bumpiness---)
    marble 0.2       // some pattern (and intensity)
    turbulence 0.5   // some turbulence
    scale <1,2,1>    // transformations
  }
  #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.2
      }
  #else
      finish {
        ambient 0.02
        diffuse 0.6
        specular 0.3
      }
  #end  
}  

#end // #ifndef

#declare R1 = 3;
#declare R2 = 3.5;
#declare h = 3/12;
#declare w=R2-R1; 

#declare plug1 = union {
  sphere { <R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>, 0.1*h } 
  sphere { <-R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>, 0.1*h }
  sphere { <R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>, 0.1*h } 
  sphere { <-R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>, 0.1*h }
  cylinder { <R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>, <-R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>, 0.1*h} 
  cylinder { <R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>, <R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>, 0.1*h}
  cylinder { <-R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>, <-R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>, 0.1*h}
  cylinder { <R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>, <-R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>, 0.1*h}
  prism {                                
    linear_sweep  // or conic_sweep for tapering to a point
    linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
    -0.0000001,         // height 1
    h,         // height 2
    5,           // number of points
    // (--- the <u,v> points ---)
    < (R1)*sin(3*pi/180), (R1)*cos(3*pi/180)>, < -(R1)*sin(3*pi/180), (R1)*cos(3*pi/180)>, 
    < -R2*sin(3*pi/180), R2*cos(3*pi/180)>,< R2*sin(3*pi/180), R2*cos(3*pi/180)>,< (R1)*sin(3*pi/180), (R1)*cos(3*pi/180)>
   }
  box { <R1*sin(3*pi/180)+0.1*h,0.9*h,R2*cos(3*pi/180)-0.1*h>, <-R1*sin(3*pi/180)-0.1*h,0.1*h,R2*cos(3*pi/180)+0.1*h> }
  cylinder { <R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>,<R1*sin(3*pi/180),0.1*h,R1*cos(3*pi/180)>, 0.1*h } 
  cylinder { <-R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)>,<-R1*sin(3*pi/180),0.1*h,R1*cos(3*pi/180)>, 0.1*h }
  cylinder { <R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>,<R2*sin(3*pi/180),0.1*h,R2*cos(3*pi/180)>, 0.1*h } 
  cylinder { <-R2*sin(3*pi/180),0.9*h,R2*cos(3*pi/180)>,<-R2*sin(3*pi/180),0.1*h,R2*cos(3*pi/180)>, 0.1*h }
  box { <0.05*h,0.9*h,R1>, <-0.05*h/2,0.1*h,R2> rotate 3.22*y}   
  box { <0.05*h,0.9*h,R1>, <-0.05*h/2,0.1*h,R2> rotate -3.22*y} 
  box { <R1*sin(3*pi/180),0.9*h,R1*cos(3*pi/180)-0.1*h>,<-R1*sin(3*pi/180),0.1*h,R1*cos(3*pi/180)> } 
}

#declare edge = union {
  torus { 1.02*R2, h/12 clipped_by { plane { -x, 0.0 rotate -2*y} } clipped_by { plane { x, 0.0 rotate 2*y} }}
  sphere { 0, h/12 translate 1.02*R2*z rotate 2*y }   
  sphere { 0, h/12 translate 1.02*R2*z rotate -2*y } 
  translate 0.35*h*y 
}  

#declare ring = union {
  difference {
    cylinder { <0,0.2*h,0>, <0,0.5*h,0>, 1.02*R2 }
    cylinder { <0,-.000001,0>, <0,0.500001,0>, 0.96*R1}
    }
  difference {
    cylinder { <0,0.2*h,0>, <0,0.5*h,0>, 1.02*R2+0.05*h }
    cylinder { <0,-.000001,0>, <0,0.500001*h,0>, 0.96*R1-0.05*h}
    torus { (1.02*R2+0.05*h), h/72 scale <1,6,1> translate 0.35*h*y }
  }  
  torus { 1.02*R2, 0.05*h translate 0.5*h*y} 
  torus { 1.02*R2, 0.05*h translate 0.2*h*y} 
  torus { 0.96*R1, 0.05*h translate 0.5*h*y} 
  torus { 0.96*R1, 0.05*h translate 0.2*h*y}  
  torus { 1.01*R1, 0.05*h translate 0.7*h*y} 
  torus { 0.99*R2, 0.05*h translate 0.7*h*y}   
  difference {
    cylinder { <0,0,0>, <0,0.7*h,0>, 0.99*R2+0.05*h }
    cylinder { <0,-.000001,0>, <0,0.700001*h,0>, 1.01*R1-0.05*h}
  }  
  difference {
    cylinder { <0,0,0>, <0,0.7*h,0>, 0.99*R2 }
    cylinder { <0,-.000001,0>, <0,0.700001*h,0>, 1.01*R1}  
  }       
#declare i = 1;
#while (i < 37)
  object {plug1 translate -0.07*h*y rotate i*10*y }   
  object {plug1 translate -0.1*R1*z scale <1.3,0.8,1.1> rotate i*10*y } 
  object {plug1 rotate 180*z scale <1.1,0.8,1.25> translate 0.5*h*y translate -0.277*R1*z scale <1.3,0.8,1> rotate i*10*y }   
  object {plug1 translate -0.185*R1*z scale <1.1,0.7,1.2> rotate i*10*y }  
  #if (mod(i,9)=0)
    object {plug1 translate 0.12*R1*z scale <0.5,0.7,0.9> translate 0.35*h*y rotate i*10*y } 
    object {plug1 scale <0.35,0.7,0.9> translate <0,0.45*h,0.1*R1>  rotate i*10*y } 
    object {plug1 translate 0.12*R1*z scale <0.5,0.7,0.9> translate -0.35*h*y rotate 180*z rotate i*10*y } 
    object {plug1 scale <0.35,0.7,0.9> translate <0,-.25*h,0.1*R1> rotate 180*z rotate i*10*y }    
  #end
  object {edge rotate i*10*y}
  superellipsoid { <0.5, 0.5> scale <0.9,1,1>
   scale 0.07 
   matrix <1,0.5,0,
           0,1,0,
           0,0,1,
           0,0,0> 
   rotate 32*z 
   translate 1.003*R2*z
   translate 0.16*h*y
   rotate i*10*y
   } 
#declare i = i + 1;
#end 
 texture { ring_tex }
}



   