// Persistence of Vision Ray Tracer Scene Description File
// File: glyphs.pov
// Vers: 3.6
// Desc: Stargate SG-1 Gate
// Date: 2/17/2006
// Auth: Michael Sobers

// +FN +UA
// +am2 +a0.2

#version 3.6;

#include "colors.inc" 

#declare radiosity_on = 0;
#declare frills = 1; 
#declare glyphs = 1;
#declare show_water = 1;
#declare arealight = 0;


#if (radiosity_on)
// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples       
  }   
  assumed_gamma 1.0  
  max_trace_level 10  
}
#else
global_settings {
  assumed_gamma 1.0
  max_trace_level 10
}  
#end

// ----------------------------------------

#declare Start    = 0;
#declare End      = 4;
#declare My_Clock = 0;//Start+(End-Start)*clock;  

camera {
  //location  <15, 5, 15>  +  .25*My_Clock*<-25,+5, -10>
  //look_at   <10, 5,  0>  +  .25*My_Clock*<-17,+5, 0>   
  //location  <4.0, 13.0, 4.50>
  //look_at   <0.8, 11.5,  0>  
  //location <3.5,6,20>
  //look_at <3.5,6,0>  
  location <-0,10,10>
  look_at <-0,10,0>  
  direction 1.5*z
  right     x*image_width/image_height
  angle 58          
  //aperture 0.001
  //blur_samples 200
  
}  

#if (arealight)

light_source {
  0*x                 // light's position (translated below)
  color rgb <1.5, 1.5, 1.3>       // light's color
  area_light
  <30, 0, 0> <0, 0, 30> // lights spread out across this distance (x * z)
  8, 8                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-100, 180, 30>
  //translate <-10, 80, 30>   // <x y z> position of light
} 

#else
//#if (!radiosity_on)
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 0.9>  // light's color
  translate <-100, 180, 30>
}  
//#end

#end

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 0.9>  // light's color
  translate <-100, 180, 30>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <0.1, 0.1, 0.08>  // light's color
  translate <40, 40, 40>
}

// ----------------------------------------


#declare base =
texture {
    pigment {
        granite
        color_map { 
            [0.3 color rgbt <0.30, 0.30, 0.37, 0.0> ]
            [0.80 color rgbt <0.20, 0.20, 0.26, 0.0> ]
            [1.00 color rgbt <0.35, 0.35, 0.40, 0.0> ]
        }
        frequency 6
        rotate <0, 10, 0>
        turbulence <0.05, 0.05, 0.05>
        octaves 6
        omega 0.7
        lambda 2
    }
  #if (radiosity_on)
  finish{
    ambient 0.0
    diffuse 0.3
    roughness 1/1
  }    
  #else
  finish{    ambient 0.05 
    diffuse 0.6
    specular 0.3     // shiny  
    roughness 1/80
  }
  #end
  scale 2    
} 

#declare overlay = 
texture {
    pigment {
        wrinkles
        turbulence 0.5
        color_map { 
            [0.0 color rgbt <0.1, 0.1, 0.12, 1> ] 
            [0.2 color rgbt <0.1, 0.1, 0.12, 0.6> ]
            [0.45 color rgbt <0.05, 0.05, 0.08, 0.2> ]
            [0.65 color rgbt <0.1, 0.1, 0.15, 0.2> ]  
            [0.80 color rgbt <0.15, 0.15, 0.2, 0.6> ]
            [1.00 color rgbt <0.15, 0.15, 0.2, 1> ]
        }
        frequency 1
    }
    scale 1.8*<.3,.4,.2> 
  #if (radiosity_on)
  finish{
    ambient 0.0
    diffuse 0.3
    roughness 1/1
  }    
  #else
  finish{    ambient 0.05 
    diffuse 0.6
    specular 0.3     // shiny  
    roughness 1/80
  }
  #end    
}  

#declare overlay2 = 
texture {
    pigment {
        wrinkles
        turbulence 0.5
        color_map { 
            [0.0 color rgbt <0.1, 0.1, 0.12, 1> ] 
            [0.2 color rgbt <0.1, 0.1, 0.12, 0.6> ]
            [0.45 color rgbt <0.05, 0.05, 0.06, 0.2> ]
            [0.65 color rgbt <0.1, 0.1, 0.12, 0.2> ]  
            [0.80 color rgbt <0.15, 0.15, 0.2, 0.6> ]
            [1.00 color rgbt <0.15, 0.15, 0.2, 1> ]
        }
        frequency 1
    }
    scale 0.7*<.3,.4,.2> 
  #if (radiosity_on)
  finish{
    ambient 0.0
    diffuse 0.3
    roughness 1/1
  }    
  #else
  finish{    ambient 0.05 
    diffuse 0.6
    specular 0.3     // shiny  
    roughness 1/80
  }
  #end    
}

#declare line =
texture {
pigment
 {wood
  turbulence 0.03 
  color_map
   {[0.0, 0.01 color Black transmit 0.6 color Black transmit 0.7]
    [0.01 color Clear]
   }
 }
  #if (radiosity_on)
  finish{
    ambient 0.0
    diffuse 0.3
    roughness 1/1
  }    
  #else
  finish{    ambient 0.05 
    diffuse 0.6
    specular 0.4     // shiny  
    roughness 1/80
  }
  #end 
}

#declare faint_line =
texture {
pigment
 {wood
  turbulence 0.03 
  color_map
   {[0.0, 0.01 color Black transmit 0.7 color Black transmit 0.8]
    [0.01 color Clear]
   }
 }
  #if (radiosity_on)
  finish{
    ambient 0.0
    diffuse 0.4
    roughness 1/1
  }    
  #else
  finish{    ambient 0.05 
    diffuse 0.6
    specular 0.3     // shiny  
    roughness 1/80
  }
  #end 
}  

#declare tex_line =                     
texture{base  normal {granite 0.08 scale 0.1}}   
texture{overlay normal {granite 0.08 scale 0.1}}
texture{line scale 0.5*<1, 2, 1.4> rotate <15, 65, -30>}
texture{line scale 0.7*<1, 2, 1.4> rotate <10, 65, 70>} 
texture{line scale 0.6*<1, 2, 1.4> rotate <10, 45, 30>}   

#declare tex_chevron =                     
texture{base  normal {granite 0.08 scale 0.1}}   
texture{overlay normal {granite 0.08 scale 0.1}}
texture{line scale 0.5*<1, 2, 1.4> rotate <15, 65, 30>}
texture{line scale 0.7*<1, 2, 1.4> rotate <10, 65, -70>} 
texture{line scale 0.6*<1, 2, 1.4> rotate <10, -45, 30>}

#declare tex_main =                     
texture{base  normal {granite 0.08 scale 0.1}}   
texture{overlay2 scale 0.8 normal {granite 0.08 scale 0.1}}    

#declare tex_bumps =                     
texture{base  normal {granite 0.08 scale 0.1}}   
texture{overlay scale 0.6 translate -0.5*z normal {granite 0.08 scale 0.1}} 

#declare tex_frills =                     
texture{base  normal {granite 0.08 scale 0.1}}   
texture{overlay scale 0.6 translate -0.5*z normal {granite 0.08 scale 0.1}}
texture{faint_line scale 0.5*<1, 2, 1.4> rotate <15, 65, -30>}
texture{faint_line scale 0.7*<1, 2, 1.4> rotate <10, 65, 70>} 
texture{faint_line scale 0.6*<1, 2, 1.4> rotate <10, 45, 30>}

#if (radiosity_on) 
  plane { y, 100.0 rotate 40*x pigment { color rgb <1,1,0.8>} no_shadow finish {ambient 1 diffuse 1}} 
#end   
          
          
#declare r1 = 11;
#declare r2 = r1*1.25; 
#declare wide = r2-r1; 


#declare inner_ring = // rotate a 2-D outline of points around the Y axis to create a 3-D shape
lathe {
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  5, // number of points
  <r1+0.22*wide, 0>, <r1+0.22*wide, 3/12>, <r1, 1/12>, <r1, 0>, <r1+0.22*wide, 0> // the list of <u,v> points
  rotate 90*x 
  texture { tex_line }
}


#declare main_ring = union {
  difference { 
   cylinder { <0, 0, 0>, <0, 0, 2/12>, r1+0.58*wide } 
   cylinder { <0, 0, -1>, <0, 0, 1>, r1+0.22*wide }
   texture { tex_main }
  }
  # if (glyphs) 
  #declare i = 0;
  #while (i<39)
    difference {
      box { <-0.5/12, -(r1+0.22*wide), 0>, <0.5/12, -(r1+0.58*wide), 2.5/12> rotate z*i*360/39}  
      cylinder { <-0.17/12, -(r1+0.22*wide), 2.5/12>, <-0.17/12, -(r1+0.58*wide), 2.5/12>, 0.1/12 rotate z*i*360/39} 
      cylinder { <0.17/12, -(r1+0.22*wide), 2.5/12>, <0.17/12, -(r1+0.58*wide), 2.5/12>, 0.1/12 rotate z*i*360/39}
      texture { tex_line }
    }  
    #declare filename = concat("glyph", str(i+1,-2,0), ".png");
    height_field {
      png               // the file type to read (tga/pot/pgm/ppm/png/sys)
      filename     // the file name to read
      smooth         // smooth surface normal
      rotate 90*x  
      translate <-0.5,-0.5,-0.5>
      rotate 180*z
      scale 0.36*wide*<4/3,1,0.05>
//      translate 11*y
      translate (r1+0.04*wide)*y
      translate 0.18*z
      rotate z*i*360/39
      texture { tex_main }
    }
           
    #declare i = i + 1;
  #end
  #end // # if
}  


#declare braid = 
  difference { 
   cylinder { <0, 0, 0>, <0, 0, 3/12>, r1+0.670*wide } 
   cylinder { <0, 0, -1>, <0, 0, 1>, r1+0.58*wide } 
   difference { 
     cylinder { <0, 0, 2.8/12>, <0,  0, 0.5>, r1+0.68*wide } 
     cylinder { <0, 0, -1>, <0, 0, 1>, r1+0.585*wide }
   }
   texture { tex_line }  
}
  
#declare braid_bumps = union {
  #declare i = 0;
  #while (i<176)
     superellipsoid { <0.1, 1> scale 0.1*<2.2,1,0.4> translate <0,(r1+0.625*wide),0.22> rotate z*i*360/(176)  }
     #declare i = i + 1;
  #end 
  texture { tex_bumps }
}

#declare ring3 = 
  difference { 
   cylinder { <0, 0, 0>, <0, 0, 3/12>, r1+0.741*wide } 
   cylinder { <0, 0, -1>, <0, 0, 1>, r1+0.670*wide } 
  texture { tex_line } 
}  

      
#declare frills = union {
  difference { 
   cylinder { <0, 0, 0>, <0, 0, 2.86/12>, r1+0.92*wide } 
   cylinder { <0, 0, -1>, <0, 0, 1>, r1+0.74*wide }
   texture { tex_line }
  }     
  # if (frills)
  #declare i = 0;
   #while (i<360) 
     # if (frills = 1)  
      height_field {
        png               // the file type to read (tga/pot/pgm/ppm/png/sys)
        "frill4.png"     // the file name to read
        smooth         // smooth surface normal 
        water_level 0.0
        hierarchy off
        rotate 90*x  
        translate <-0.5,0,-0.5>
        rotate 180*z
        scale 0.08*wide*<1,2.15,0.05>
        translate (r1+0.745*wide)*y
        translate z*2.9/12
        rotate z*i
      }     
     # else
      height_field {
        sys               // the file type to read (tga/pot/pgm/ppm/png/sys)
        "frill5.bmp"     // the file name to read
        smooth         // smooth surface normal 
        water_level 0.0
        hierarchy off
        rotate 90*x  
        translate <-0.5,0,-0.5>
        rotate 180*z
        scale 0.08*wide*<1.04,2.15,0.04>
        translate (r1+0.745*wide)*y
        translate z*2.9/12
        rotate z*i
      } 
     #end // if nofrills = 2 
     #declare i = i + 1;
   #end // while
  #end  // if !nofrills 
  texture { tex_frills }   
}   

#declare ring4 = 
  difference { 
   cylinder { <0, 0, 0>, <0, 0, 3/12>, r2 } 
   cylinder { <0, 0, -1>, <0, 0, 1>, r1+0.92*wide } 
   texture { tex_line }
}    

#declare b = (r1+0.22*wide)*(2*pi/39);
#declare locked = 1;

#declare chevron = difference {

// extrude a closed 2-D shape along an axis
prism {                                
  linear_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
   -0.2,         // height 1
   0,         // height 2
  5,           // number of points
  // (--- the <u,v> points ---)
  <-5*b/8, (0.77*wide)>, <5*b/8, (0.77*wide)>, <b/6, (0.26*wide)>, <-b/6, (0.26*wide)>, <-5*b/8, (0.77*wide)> 
  translate r1*z  
  rotate -90*x   
}  
prism {                                
  conic_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
   -0.8,         // height 1
   -1,         // height 2
  5,           // number of points
  // (--- the <u,v> points ---)
  <-5*b/16, (0.25*wide)>, <5*b/16, (0.25*wide)>, <b/8, (-0.22*wide)>, <-b/8, (-0.22*wide)>, <-5*b/16, (0.25*wide)> 
  rotate 180*y
  translate (r1+0.56*wide)*z
  scale <1,2,1>
  translate 1.75*y
  rotate -90*x  
  //texture { pigment { color  rgb <1,0,0> }}  
} 

  box {<-b,r1+0.745*wide,0.02>, <b,r1+0.72*wide,0.21>}  
  box {<-b,r1+0.695*wide,0.02>, <b,r1+0.67*wide,0.21>}
  box {<-b,r1+0.645*wide,0.02>, <b,r1+0.62*wide,0.21>}
  box {<-b,r1+0.595*wide,0.02>, <b,r1+0.57*wide,0.21>}
  box {<-b,r1+0.545*wide,0.02>, <b,r1+0.52*wide,0.21>}
  box {<-b,r1+0.495*wide,0.02>, <b,r1+0.47*wide,0.21>}
  
  plane { -z, 0 translate -1.05*z rotate 13*y rotate 6*x }
  plane { -z, 0 translate -1.05*z rotate -13*y rotate 6*x }
  plane { -z, 0 translate -2.142*z rotate 10.9*x }
  cylinder { 0, <0,r2,0> 0.01 translate -2.142*z rotate 10.9*x }  
  			      
  translate (3/12)*z 
  translate locked*0.20*wide*y
  texture { tex_chevron }
}

#declare chevron_light = difference {

        // extrude a closed 2-D shape along an axis
        prism {                                
          linear_sweep  // or conic_sweep for tapering to a point
          linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
           -0.19,         // height 1
           0,         // height 2
          5,           // number of points
          // (--- the <u,v> points ---)
          <-4.9*b/8, (0.77*wide)>, <4.9*b/8, (0.77*wide)>, <.99*b/6, (0.26*wide)>, <-.9*b/6, (0.26*wide)>, <-4.9*b/8, (0.77*wide)> 
          translate r1*z  
          rotate -90*x   
        }  
        prism {                                
          conic_sweep  // or conic_sweep for tapering to a point
          linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
           -0.8,         // height 1
           -1,         // height 2
          5,           // number of points
          // (--- the <u,v> points ---)
          <-5*b/16, (0.25*wide)>, <5*b/16, (0.25*wide)>, <b/8, (-0.22*wide)>, <-b/8, (-0.22*wide)>, <-5*b/16, (0.25*wide)> 
          rotate 180*y
          translate (r1+0.56*wide)*z
          scale <1,2,1>
          translate 1.79*y
          rotate -90*x            
        } 
        
        plane { -z, 0 translate -1.05*z rotate 13*y rotate 6*x }
        plane { -z, 0 translate -1.05*z rotate -13*y rotate 6*x }
        plane { -z, 0 translate -2.142*z rotate 10.9*x }
        cylinder { 0, <0,r2,0> 0.02 translate -2.142*z rotate 10.9*x } 
        
        translate (2.99999/12)*z
                               
        texture { 
          pigment { color  rgb 0.5*<0.4,0.1,0.05> }
          finish { ambient 0.01 diffuse 0.4 specular 0.5 roughness 1/1000}
        } 
        translate locked*0.20*wide*y

}

#declare water1 = disc {
  <0, 0, 0>  // center position
  z,         // normal vector
  r1       // outer radius 
  texture { 
    pigment { 
      wood
      turbulence 0.03 
      color_map {
        [0.0 color rgb <0.9,0.9,0.7>]
        [0.3 color rgb <0.1,0.1,0.3>]
        [0.5 color rgb <0.05,0.05,0.1>]
      }
      scale <2.5*r1,2.5*r1,1>    
    }
    normal {           // (---surface bumpiness---)
      bumps 1       // some pattern (and intensity)
      turbulence 0.5   // some turbulence
      scale 0.5    // transformations
    }
    finish {           // (---surface finish---)
      ambient 0.1
      diffuse 0.5
      specular 0.8     // shiny
      roughness 1/100
      //metallic
    }
    translate 0.5*My_Clock*z    
  }
} 

#declare water = disc {
  <0, 0, 0>  // center position
  z,         // normal vector
  r1       // outer radius 
  texture { 
    pigment { 
      wood
      turbulence 0.00 
      color_map {
        [0.0 color rgb 1]
        [0.004 color rgb <0.05,0.05,0.3>]
        [1 color rgb <0.005,0.006,0.007>]
      }
      scale <2.2*r1,2.2*r1,1>    
    }
    normal {           // (---surface bumpiness---)
      bumps 1       // some pattern (and intensity)
      turbulence 0.5   // some turbulence
      scale 0.6    // transformations
    }
    finish {           // (---surface finish---)
      ambient 0.5
      diffuse 0.5
      specular 0.8     // shiny
      roughness 1/100
      //metallic
    }
    translate 0.5*My_Clock*z    
  }
  no_shadow
} 

#declare glow = disc {
  <0, 0, 0>  // center position
  z,         // normal vector
  r1       // outer radius 
  texture { 
    pigment { 
        wood
        //turbulence 0.02 
        color_map {
          //[0 color rgb <0.1,0.1,1> transmit 1] 
          [0.1 color rgb <.5,.5,1> transmit 0.95]
          [0.5 color rgb <0.1,0.1,1> transmit 0.95] 
          [0.85 color rgb <0.1,0.1,1> transmit 0.97]
          [1 color rgb 0 transmit 1]             
        } 
        scale 2*r1
    } 
    finish {           // (---surface finish---)
      ambient 1
      diffuse 0
    }    
  }
  scale 1.25 
  no_shadow
}

/*   
// create a point "spotlight" (cylindrical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,0.7>       // light's color
  spotlight               // this kind of light source
  //cylinder                // this variation
  translate <0, 0, 20> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 180*atan(r1/20)/pi               // hotspot (inner, in degrees)
  tightness 30            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 1.2*180*atan(r1/20)/pi               // intensity falloff radius (outer, in degrees)
}  */

#if (show_water)
// create a point "spotlight" (cylindrical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <0.6,0.6,0.7>       // light's color
  spotlight               // this kind of light source
  //cylinder                // this variation
  translate <0, 0, 20> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 180*atan(r1/20)/pi               // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 1.05*180*atan(r1/20)/pi               // intensity falloff radius (outer, in degrees)
}  
#end
   
/* */
object { main_ring rotate -My_Clock*(360/39)*z } 
//object { main_ring rotate -My_Clock*(360/39)*z texture { pigment {color rgb 1 } } finish { ambient 1 } }
object { inner_ring }
object { frills } 
object { braid } 
object { braid_bumps }
object { ring3 } 
object { ring4 } 

#declare i = 0;
 #while (i<9) 
    object { chevron_light rotate -i*360*z/9}     
    object { chevron rotate -i*360*z/9}  
    #declare i = i + 1;
 #end   

#if (show_water) 
  object { water }  
  object { glow translate 0.5*z}
#end   

//box { <-3,-3,-3>, <3,1,3> texture {tex}  }
//sphere { 0, 3 translate 3*z rotate 90*y texture {tex} }

/*
plane { z, -600 

  pigment{
    image_map {
      jpeg "field.jpg"
      map_type 0 
    }
    translate <0.5,0.5,0>
    rotate -180*y    
    scale <600,450,1>  
  } 
  finish { ambient 0.6 diffuse 0.0 } 
  //rotate 2.15*x rotate 21*z rotate -27*y 
} */

box { <-8, -0.1, -10>, <8, 0.1, 10> rotate 10*x translate <0,-8,10> texture {tex_frills scale 10}}
cylinder { <-8, 0, 0>, <8, 0, 0>, 0.2 scale <1,1,3> translate -9.5*z rotate 10*x translate <0,-8,10> texture {tex_frills scale 10}}