#include "stdinc.inc" // need metals colors and math
#include "echo2.inc"

//#declare _radiosity = 0;
//#include "radiosity.inc"
 
#include "spheroid_dome.inc"
//sphere
#declare Vmin=0;
#declare Vmax=pi;
#declare Umin=0;
#declare Umax=pi*2;
//spheroid(1, 0.0, -0.5, 0.0,10,18,Fx,Fy,Fz,0)
//WriteMesh("spheroid_geometry.inc")




#macro tex( col )
  pigment { rgbft col }
  //normal { bumps .1 scale .002 }
  finish {
    ambient .01 diffuse .4 brilliance 1.2
    //specular .97
    roughness .02
    metallic .1
    //reflection { .2,.9 metallic .1 fresnel on exponent 1 }
    conserve_energy
  }
#end
#declare S1 = seed (2341);
#declare S2 = seed (5521);
#declare S3 = seed (134515);
#declare S1 = seed (987);
#declare S2 = seed (7879);
#declare S3 = seed (9979);
#macro Triangles(rswitch,C)
  #local i = 0;
  #while (i<NumFaces)
    #if(!VEq(V_vec_Arr[Face_Arr[i].x], V_vec_Arr[Face_Arr[i].y]) &
        !VEq(V_vec_Arr[Face_Arr[i].x], V_vec_Arr[Face_Arr[i].z]) &
        !VEq(V_vec_Arr[Face_Arr[i].z], V_vec_Arr[Face_Arr[i].y]) )
       triangle {V_vec_Arr[Face_Arr[i].x], V_vec_Arr[Face_Arr[i].y], V_vec_Arr[Face_Arr[i].z]
         texture { 
                  #if (rswitch) tex(<rand(S3),rand(S2),rand(S1),.9,.1>)
                  #else tex(C)
                  #end
                  //tex(<rand(S3),.2,rand(S1),.9,.1>)
                  //tex(<.6,.4,.9,.9,.1>)
                  
                           //T_Chrome_1C
          }
     }
     #else echo("Bad Triangle ")
     #end
  #local i = i+1;
  #end
#end



#macro VertexSpheres(Radius)
   #local i=0;
   #while (i<NumVertices)
     sphere{V_vec_Arr[i], Radius}
     #local i=i+1; 
   #end
#end
        
#macro By_Edges(Radius)

  #local i=0;   
  #while (i<NumEdges)
    #local uv = Edge_Arr[i];
    #if (!VEq(V_vec_Arr[Edge_Arr[i].x],V_vec_Arr[Edge_Arr[i].y]))
      cylinder { V_vec_Arr[Edge_Arr[i].x],V_vec_Arr[Edge_Arr[i].y],Radius }
    #else echo("Bad Cylinder ")
    #end
    #local i = i+1;
  #end        
#end

#declare T_IM_Earth = 
texture {
  pigment {
   image_map {
     //png "earth1026"
     jpeg "mars"
     map_type 1
     interpolate 2
     transmit all 0 filter all .2
   }
 }
finish { ambient 0.3 specular 0.1 diffuse 0.7 }
}
#declare P_IM_Earth = pigment {
  image_map {
    png "earth1026"
    map_type 1
    interpolate 2
    //transmit all .1 filter all .9
  }
}
#macro _light(T)
light_source {
  T
  color rgb <.9,.9,1>*4
  fade_distance 2
  fade_power 2
}
#end
#macro aobj_sm(T,C)
union {
  By_Edges(0.02)
  VertexSpheres(0.0225)
  //texture { T_Chrome_1C }
  texture { T_Gold_1C }
  rotate <0,42,0> 
  translate T
}
union {
  Triangles(1,<C.x,C.y,C.z,.9,.1>)
  rotate <0,42,0> 
  translate T
}
#end
#macro aobj(R,T,C,stainedglass)
union {
  By_Edges(0.04)
  VertexSpheres(0.045)
  //texture { T_Chrome_1C }
  texture { T_Gold_1C }
  rotate R 
  translate T
}
union {
  Triangles(stainedglass,<C.x,C.y,C.z,.9,.1>)
  rotate R 
  translate T
}
#end
#macro bobj_sm(T,C)
union {
  By_Edges(0.02)
  VertexSpheres(0.0225)
  //texture { T_Chrome_1C }
  texture { T_Gold_1C }
  rotate <0,-42,0> 
  translate T
}
union {
  Triangles(1,<C.x,C.y,C.z,.9,.1>)
  rotate <0,-42,0> 
  translate T
}
#end

#macro four()
    #local p = <0,0,2.4>;
    #local p = rotation(deg2rad(-42),y,p);
    #local r = pi*2/-3;
    #local p = rotation(pi/-3,y,p);
    #local _v = <0,1.6/-2-0.25,0>;
    
    
   spheroid(1.6/2, 0.0, -0.3, 0.0, 2,3,Fx,Fy,Fz,0) 
   #declare SurfMin=min_extent(Spheroid_Surface);
   #declare SurfMax=max_extent(Spheroid_Surface);     
   #debug concat("\n SurfMin: <",vstr(3,SurfMin,", ",0,-1),">\n")
   #debug concat(" SurfMax: <",vstr(3,SurfMax,", ",0,-1),">\n")
    #local _v = <0,SurfMin.y/2-0.01,0>;

    aobj_sm(p+_v,<0,0,.8>)
    _light(p+_v)
    
    #local p = rotation(r,y,p);
    aobj_sm(p+_v,<0,0,.8>)
    _light(p+_v)
    
    #local p = rotation(r,y,p);
    aobj_sm(p+_v,<0,0,.8>)
    _light(p+_v)
    
    
    #local p = p+<4,0,12>;
        bobj_sm(p+_v,<0,.8,0>)
    _light(p+_v)
        
#end
//four()
camera {
location < 0.0,3.0,-20.0 >
look_at < 0.0,-0.7,0.0 >
angle 24
}
     /*
light_source {
  <0,0,0>
  color rgb <.8,.8,1>*3
  fade_distance 2
  fade_power 2
}  
light_source {
<0.0,15.0,-15.0>
color Red
fade_distance 80
fade_power 2
}
light_source {
<40,0.5,-40>
color Green
fade_distance 80
fade_power 2
}
light_source {
<-20,5,-50>
color Blue
fade_distance 80
fade_power 2
}*/

light_source {
<-20,5,-50>
color White
fade_distance 80
fade_power 2
}
#declare fl_chrome1c =
plane { y, -2.4 texture { T_Chrome_1C }
}
object { fl_chrome1c }
#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.6,0.7,1.0>]
          [0.7 rgb <0.0,0.1,0.8>]
        }
    }
}
sky_sphere { sky_blue }


                                         
//stacks
#declare Vmin=0;
#declare Vmax=pi;
//slices
#declare Umin=0;
#declare Umax=pi*2;
spheroid(.8, 0.0, -0.5, 0.0,2,3,Fx,Fy,Fz,0)
aobj(<0,30,0>,<-3,-1.15,-1.5>,<0.9393,0.15928,0.41414>,1) 
aobj(<0,-30,0>,<3,-1.15,-1.5>,<0.9393,0.15928,0.41414>,1) 
_light(<-3,-1.15,-1.5>)
_light(<3,-1.15,-1.5>)
 

//spheroid(1, 0.3, 0.0, 0.0, 20, 10,F_BDx,F_BDy,F_BDz,1)
// radius xyz-flats, stacks,slices,xyz-funcs, full slice(U) loop (0=reduced pnts at tips, 1=straight longitude lines)
//aobj(<0,0,0>,<0,0,0>,<0.9393,0.15928,0.41414>,0)
// rotate, translate, color, randomcolorfaces

/*************** USING "full slice(U) loop"  **************
Will inevitably try to create degenerate triangles and cylinders.
Errors handled and no triangle is created, allowing render to proceed.
Where Behemian requires it, sphere func allows it.
********************************/


#macro a_obj(R,T,C,randomcolorfaces,edges)
#if (edges)
union {
  By_Edges(edges)
  VertexSpheres(edges+0.003)
  //texture { T_Chrome_1C }
  texture { T_Gold_1C }
  rotate R 
  translate T
}
#end
union {
  Triangles(randomcolorfaces,<C.x,C.y,C.z,.9,.1>)
  rotate R 
  translate T
}
#end 


// "Bohemian Dome"
#declare Vmin=0;
#declare Vmax=pi*2;
#declare Umin=0;
#declare Umax=pi*2;
spheroid(1, 0.3, 0.0, 0.0, 20, 10,F_BDx,F_BDy,F_BDz,1)
// for Links()
#declare Iter_V=20;
#declare Iter_U=10;
#macro bohemian_obj(R,T,C,randomcolorfaces,edgerad)
#if (edgerad)
  union {
    //By_Edges(edges)
    // Links() has triangle option but Links() and Quads() can only be used
    // if object was created with full loop option (straight/parallel longitudes)
    Links(edgerad,0)
    VertexSpheres(edgerad+0.003)
    //texture { T_Chrome_1C }
    texture { T_Gold_1C }
    rotate R 
    translate T
  }
#end
  union {
    // Draw faces
    //Triangles(randomcolorfaces,<C.x,C.y,C.z,.9,.1>)
    Quads(randomcolorfaces,<C.x,C.y,C.z,.9,.1>)
    rotate R 
    translate T
  }
#end
bohemian_obj(<0,0,0>,<0,0,0>,<0.9393,0.15928,0.41414>,0,0.05)
//WriteMesh("bohemian_geometry.inc")



#macro SpheroidSurface()
mesh2 {
      #local i = 0;
      vertex_vectors {
         NumVertices
         #while (i<NumVertices)
            V_vec_Arr[i]
            #local i = i+1; 
         #end
      }
      #local i = 0;
      normal_vectors {
         NumVertices
         #while (i<NumVertices)
            N_vec_Arr[i]
            #local i = i+1;
         #end
      }
      #local i = 0;
      uv_vectors {
         NumVertices
         #while (i<NumVertices)
            UV_vec_Arr[i]
            #local i = i+1;
         #end
      }
      #local i = 0;
      face_indices {
         NumFaces
         #local i = 0;
         #while (i<NumFaces)
            Face_Arr[i]
            #local i = i+1;
         #end
      }
}
#end
#declare Spheroid_Surface=
mesh2 {
      #local i = 0;
      vertex_vectors {
         NumVertices
         #while (i<NumVertices)
            V_vec_Arr[i]
            #local i = i+1; 
         #end
      }
      #local i = 0;
      normal_vectors {
         NumVertices
         #while (i<NumVertices)
            N_vec_Arr[i]
            #local i = i+1;
         #end
      }
      #local i = 0;
      uv_vectors {
         NumVertices
         #while (i<NumVertices)
            UV_vec_Arr[i]
            #local i = i+1;
         #end
      }
      #local i = 0;
      face_indices {
         NumFaces
         #local i = 0;
         #while (i<NumFaces)
            Face_Arr[i]
            #local i = i+1;
         #end
      }
}
/*
object {
   #declare SurfMin=min_extent(Spheroid_Surface);
   #declare SurfMax=max_extent(Spheroid_Surface);     
   #debug concat("\n SurfMin: <",vstr(3,SurfMin,", ",0,-1),">\n")
   #debug concat(" SurfMax: <",vstr(3,SurfMax,", ",0,-1),">\n")
   Spheroid_Surface
    //texture { pigment { rgb <.6,.5,.5> } }
    //texture { pigment { P_IM_Earth } }  
    texture { T_IM_Earth }
    //texture { uv_mapping pigment { P_IM_Earth } }
    rotate <0,0,0> 
}          */
//Astroidal Ellipse    or rhombihexacron
#declare Vmin=0;
#declare Vmax=pi*2;
#declare Umin=0;
#declare Umax=pi*2;
spheroid(1.6, 0.3, 0.0, 0.3, 20,10,F_AEx,F_AEy,F_AEz,1)
// for Links() and Quads()
#declare Iter_V=20;
#declare Iter_U=10;

#macro hexicron_obj(R,T,C,randomcolorfaces,edges)
#if (edges)
  union {
    //By_Edges(edges)
    Links(edges,0)
    VertexSpheres(edges+0.003)
    texture { T_Chrome_3C }
    //texture { T_Gold_1C }
    rotate R 
    translate T
  }
#end
  union {
    Quads(randomcolorfaces,<C.x,C.y,C.z,0,0>)
    rotate R 
    translate T
  }
#end
hexicron_obj(<0,0,0>,<0,0,0>,<0,0.8,0.76>,1,0.03)
_light(<0,0,0>)