#include "triangulation.inc"
#declare Vmin=0;
#declare Vmax=pi;
#declare Umin=0;
#declare Umax=pi*2;
#declare Fx = function(u,v) { sin(u) * sin(v) }
#declare Fy = function(u,v) { cos(v) }
#declare Fz = function(u,v) { cos(u) * sin(v) }
//spheroid(.8, 0.0, -0.5, 0.0,2,3,Fx,Fy,Fz,0)

//Astroidal Ellipse    or rhombihexacron
#declare Vmin=0;
#declare Vmax=pi*2;
#declare Umin=0;
#declare Umax=pi*2;
#declare F_AEx = function(u,v) {pow(cos(u)*cos(v),3)}
#declare F_AEy = function(u,v) {pow(sin(v),3)}
#declare F_AEz = function(u,v) {pow(sin(u)*cos(v),3)}

// "Bohemian Dome"
#declare Vmin=0;
#declare Vmax=pi*2;
#declare Umin=0;
#declare Umax=pi*2;
#declare F_BDx = function(u,v) {3*cos(v)+1*sin(u)}
#declare F_BDy = function(u,v) {2*sin(v)}
#declare F_BDz = function(u,v) {1*cos(u)} 
//spheroid(1, 0.3, 0.0, 0.0, 20, 10,F_BDx,F_BDy,F_BDz,1)


#declare RangeMM=function(Val,Rmin,Rmax,Min,Max){
   (((Val-Rmin)/(Rmax-Rmin))*(Max-Min)+Min)
}
#macro spheroid(Radius, xflat, yflat, zflat, stacks, slices,f1,f2,f3,Switch)

   #declare NumVertices = numverts(stacks, slices,Switch);

   #declare V_vec_Arr=array[NumVertices] 
   #declare N_vec_Arr=array[NumVertices] 
   #declare UV_vec_Arr=array[NumVertices]
   #declare NumEdges = 0;
   #declare Edge_Arr=array[NumVertices*3]
   #declare NumFaces = 0;
   #declare Face_Arr=array[NumVertices*2]


  #local i = 0;
  #local j = 0;

  #local k = 0;
  #local drho = (Vmax-Vmin) / stacks;
  #local dtheta = (Umax-Umin) / slices;
  #local s1 = 1; #local s2 = 1; #local e1 = 1; #local e2 = 1;
  
  #while (i <= stacks)
    #local V=RangeMM(i,0,stacks,Vmin,Vmax);
    #local rho = i * drho;
    #local s = sin(rho);
    #local c = cos(rho);
    #local j = 0;
    #local n = 1;
    #if (floor(slices * s) > 1) #local n = floor(slices * s);
    #end
    #if (Switch) #local n = slices; #end 
    
    #local dtheta = (Umax-Umin) / n;
    #local s1 = s2;
    #local s2 = k + 1;
    #if (Switch = 0) #local n = n-1; #end
    #while (j <= n)
      #if (Switch) #local U=RangeMM(j,0,n,Umin,Umax);
      #else #local U=RangeMM(j,0,n+1,Umin,Umax);
       #end
      //#declare UV_vec_Arr[k]=<(j/n)*Umax,(i/stacks)*Vmax>;
      //#declare UV_vec_Arr[k]=<(j/n)*1024,(i/stacks)*512>;
      //#declare UV_vec_Arr[k]=<(j/n),(i/stacks)>;
      //#declare UV_vec_Arr[k]=<0,1>;
      
      #declare UV_vec_Arr[k]=<U,V>;
      #local theta = j * dtheta;
      #local _x = sin(theta) * s;
      #local _y = c;
      #local _z = cos(theta) * s;
      #declare N_vec_Arr[k] = <_x,_y,_z>;
      
      #local _x = f1(U,V);
      #local _y = f2(U,V);
      #local _z = f3(U,V);
      
      #local _x = _x * Radius * (1.0 - xflat);
      #local _y = _y * Radius * (1.0 - yflat);
      #local _z = _z * Radius * (1.0 - zflat);
      #declare V_vec_Arr[k] = <_x,_y,_z>;
      #local j=j+1;
      #local k=k+1;
    #end
    #local e1 = e2; 
    #local e2 = k;
    #if (i) stripedges(s1-1, e1-1, s2-1, e2-1) #end
    #if (i) stripfaces(s1-1, e1-1, s2-1, e2-1) #end
    #local i=i+1;
  #end
  
  echo("\nNum Verts *******")
  echof(NumVertices)
  echo("\nStripping Faces *******")
  echof(NumFaces)
  echo("\nStripping Edges *******")
  echof(NumEdges)
  echo("\nChecking Normals")
  //Norms()
  
#end
#macro stripfaces(s1, e1, s2, e2)
//(range1 range2)
  #local n1 = (e1-s1) + 1;
  #local n2 = (e2-s2) + 1;


  #local j = s2;
  #local i = s1;
     
   #if (n1 <= n2)  
     #local i = s1;
     #local j = s2;
     #local k = i;
     #local aratio = n1 / n2; 
     #local h = 0;

     #while (h < n1+n2-1)
       
       #if (h)
         #declare Face_Arr[NumFaces] = <last.x,last.y,switc>;
         #declare NumFaces = NumFaces+1;
       #end
       #local last = <i,j>;
       #if (floor(k+aratio) = i)
         #if (j < e2) #local j=j+1; #local switc = j; #local k = k+aratio;  #end
       #else 
         #if (i < e1) #local i = i+1; #local switc = i; #end
       #end
       
       #local h = h+1;
     #end // while

     #if (n1 > 1)
      #declare Face_Arr[NumFaces] = <s1,e1,e2>;
      #declare NumFaces = NumFaces+1;
      #declare Face_Arr[NumFaces] = <s1,e2,s2>;
      #declare NumFaces = NumFaces+1;
    #else
      #declare Face_Arr[NumFaces] = <s1,e2,s2>;
      #declare NumFaces = NumFaces+1;
     #end


   #else

     #local i = s2;
     #local j = s1;
     #local k = i;
     #local aratio = n2 / n1; 
     #local h = 0;
     
     #while (h < n1+n2-1)
       
       #if (h)
         #declare Face_Arr[NumFaces] = <last.x,last.y,switc>;
         #declare NumFaces = NumFaces+1;
       #end
       #local last = <j,i>;
       #if (floor(k+aratio) = i)
         #if (j < e1) #local j=j+1; #local switc = j; #local k = k+aratio;  #end
       #else 
         #if (i < e2) #local i = i+1; #local switc = i; #end
       #end
       
       #local h = h+1;
     #end // while

     #if (n2 > 1)
      #declare Face_Arr[NumFaces] = <s2,e1,e2>;
      #declare NumFaces = NumFaces+1;
      #declare Face_Arr[NumFaces] = <s2,s1,e1>;
      #declare NumFaces = NumFaces+1;
     #else
      #declare Face_Arr[NumFaces] = <s2,s1,e1>;
      #declare NumFaces = NumFaces+1;      
     #end

     
   #end
#end
#macro stripedges(s1, e1, s2, e2)
//(range1 range2)
  #local n1 = (e1-s1) + 1;
  #local n2 = (e2-s2) + 1;

  #local j = s2;
  #local i = s1;

   #while (j < e2)
   
     #declare Edge_Arr[NumEdges] = <j,j+1>;
     #declare NumEdges = NumEdges+1;
     #local j = j+1;
   #end
   #if (e2 != s2)
     #declare Edge_Arr[NumEdges] = <e2,s2>;
     #declare NumEdges = NumEdges+1;
   #end
     
   #if (n1 <= n2)  
     #local i = s1;
     #local j = s2;
     #local k = i;
     #local aratio = n1 / n2; 
     #local h = 0;

     #while (h < n1+n2-1)
    
       #if (NumEdges < NumVertices*3)
         #declare Edge_Arr[NumEdges] = <i,j>;
         #declare NumEdges = NumEdges+1;
       #end
     
       #if (floor(k+aratio) = i)
         #if (j < e2) #local j=j+1; #local k = k+aratio;  #end
       #else 
         #if (i < e1) #local i=i+1; #end
       #end
    
       #local h = h+1;
     #end // while

     #if (n1 > 1)
      #declare Edge_Arr[NumEdges] = <s1,e2>;
      #declare NumEdges = NumEdges+1;
     #end


   #else

     #local i = s2;
     #local j = s1;
     #local k = i;
     #local aratio = n2 / n1; 
     #local h = 0;
     
     #while (h < n1+n2-1)
    
       #if (NumEdges < NumVertices*3)
         #declare Edge_Arr[NumEdges] = <i,j>;
         #declare NumEdges = NumEdges+1;
       #end
     
       #if (floor(k+aratio) = i)
         #if (j < e1) #local j=j+1; #local k = k+aratio;  #end
       #else 
         #if (i < e2) #local i=i+1; #end
       #end
    
       #local h = h+1;
     #end // while

     #if (n2 > 1)
      #declare Edge_Arr[NumEdges] = <s2,e1>;
      #declare NumEdges = NumEdges+1;
     #end

     
   #end
#end
#macro numverts(stacks, slices,Switch)
//
  #local i = 0;
  #local j = 0;

  #local k = 0;
  #local drho = Vmax / stacks;
  #local dtheta = Umax / slices;
  #while (i <= stacks)
    #local rho = i * drho;
    #local s = sin(rho);
    #local j = 0;
    #local n = 1;
    #if (floor(slices * s) > 1) #local n = floor(slices * s);
    #end 
    #if (Switch) #local n = slices; #end
    #if (Switch = 0) #local n = n-1; #end
    #while (j <= n)
      #local j=j+1;
      #local k=k+1;
   #end
    #local i=i+1;
  #end
  (k)
#end


#macro WriteMesh(WriteReadMesh)
   #debug concat("\n\n Writing : '",WriteReadMesh,"'\n   vertex_vectors\n")
   #fopen MeshFile WriteReadMesh write
   #write(MeshFile, "#debug concat(\"\\n uv mapping area: <",str(Umin,0,-1),", ",str(Vmin,0,-1),">, <",str(Umax,0,-1),", ",str(Vmax,0,-1),">\\n\")\n\n")
   #write(
      MeshFile,
      "#declare Surface = mesh2 {\n",
      "  vertex_vectors {\n",
      "    ", NumVertices,"\n    "
   )
   #local i=0;
   #while (i<NumVertices)
      #write(MeshFile, V_vec_Arr[i])
      #local i=i+1;
      #if(mod(i,5)=0)
         #write(MeshFile,"\n    ")
      #end 
   #end 
   #write(MeshFile,"\n  }\n")
   #write(
      MeshFile,
      "  normal_vectors {\n",
      "    ", NumVertices,"\n    "
   )
   #debug concat("   normal_vectors\n")   
   #local i=0;
   #while (i<NumVertices)
      #write(MeshFile N_vec_Arr[i])
      #local i=i+1; 
      #if(mod(i,5)=0)
         #write(MeshFile,"\n    ")
      #end 
   #end
   #write(MeshFile,"\n  }\n")
   #write(
      MeshFile, 
      "  uv_vectors {\n",
      "    ", NumVertices,"\n    "
   )
   #debug concat("   uv_vectors\n")   
   #local i=0;
   #while (i<NumVertices)
      #write(MeshFile UV_vec_Arr[i])
      #local i=i+1; 
      #if(mod(i,5)=0)
         #write(MeshFile,"\n    ")
      #end 
   #end
   #write(MeshFile,"\n  }\n")
   #write(
      MeshFile,
      "  face_indices {\n"
      "    ",NumFaces,"\n    "
   )
   #debug concat("   face_indices\n")
      #local H=0;
      #local i = 0;
       #while (i<NumFaces)
           #write(MeshFile,Face_Arr[i])
           #local H=H+1;
           #if(mod(H,5)=0) #write(MeshFile,"\n    ") #end
           #local i=i+1;
      #end
   #write(MeshFile, "\n  }\n}")
   #fclose MeshFile
   #debug concat(" Done writing\n")   
#end
#macro Norms()
  // set norms based on ALL adjacent faces - lots of verts means lots of time
  #local i = 0;
  #while (i<NumVertices)
    #local nrm = <0,0,0>;
    #local j = 0;
    #while (j<NumFaces)
      #if ((i = Face_Arr[j].x)|(i = Face_Arr[j].y)|(i = Face_Arr[j].z))
        #local norm = normal_vector(V_vec_Arr[Face_Arr[j].x],V_vec_Arr[Face_Arr[j].y],V_vec_Arr[Face_Arr[j].z]);
        #local nrm = vnormalize(nrm+vnormalize(norm));  #end
      #local j=j+1;
    #end // Faces
    #local N_vec_Arr[i] = nrm;
    #local i=i+1;
    #if (mod((i/NumVertices)*100,20) = 0)
      #debug concat("\n Checking Normals  >  ",str((i/NumVertices)*100,2,1),"%")
    #end
  #end // Verts
#end


#macro spheroid1(Radius, xflat, yflat, zflat, stacks, slices,f1,f2,f3,Switch)

   #declare NumVertices = numverts1(stacks, slices,Switch);

   #declare V_vec_Arr=array[NumVertices] 
   #declare N_vec_Arr=array[NumVertices] 
   #declare UV_vec_Arr=array[NumVertices]
   #declare NumEdges = 0;
   #declare Edge_Arr=array[NumVertices*3]
   #declare NumFaces = 0;
   #declare Face_Arr=array[NumVertices*2]


  #local i = 0;
  #local j = 0;

  #local k = 0;
  #local drho = Vmax / stacks;
  #local dtheta = Umax / slices;
  #local s1 = 1; #local s2 = 1; #local e1 = 1; #local e2 = 1;
  
  #while (i <= stacks)
    #local V=RangeMM(i,0,stacks,Vmin,Vmax);
    #local rho = i * drho;
    #local s = sin(rho);
    #local c = cos(rho);
    #local j = 0;
    #local n = 1;
    #if (floor(slices * s) > 1) #local n = floor(slices * s);
    #end
    #if (Switch) #local n = slices; #end 
    
    #local dtheta = Umax / n;
    #local s1 = s2;
    #local s2 = k + 1;
    #if ((Switch = 0) & (n>1)) #local n = n-1; #end
    #while (j <= n)
      #if (Switch) #local U=RangeMM(j,0,n,Umin,Umax);
      #else #local U=RangeMM(j,0,n+1,Umin,Umax);
       #end
      //#declare UV_vec_Arr[k]=<(j/n)*Umax,(i/stacks)*Vmax>;
      //#declare UV_vec_Arr[k]=<(j/n)*1024,(i/stacks)*512>;
      //#declare UV_vec_Arr[k]=<(j/n),(i/stacks)>;
      //#declare UV_vec_Arr[k]=<0,1>;
      
      #declare UV_vec_Arr[k]=<U,V>;
      #local theta = j * dtheta;
      #local _x = sin(theta) * s;
      #local _y = c;
      #local _z = cos(theta) * s;
      #declare N_vec_Arr[k] = <_x,_y,_z>;
      
      #local _x = f1(U,V);
      #local _y = f2(U,V);
      #local _z = f3(U,V);
      
      #local _x = _x * Radius * (1.0 - xflat);
      #local _y = _y * Radius * (1.0 - yflat);
      #local _z = _z * Radius * (1.0 - zflat);
      #declare V_vec_Arr[k] = <_x,_y,_z>;
      #local j=j+1;
      #local k=k+1;
    #end
    #local e1 = e2; 
    #local e2 = k;
    #if (i) stripedges(s1-1, e1-1, s2-1, e2-1) #end
    #if (i) stripfaces(s1-1, e1-1, s2-1, e2-1) #end
    #local i=i+1;
  #end
  
  echo("\nNum Verts *******")
  echof(NumVertices)
  echo("\nStripping Faces *******")
  echof(NumFaces)
  echo("\nStripping Edges *******")
  echof(NumEdges)
  echo("\nChecking Normals")
  //Norms()
  
#end
#macro spheroid2(Radius, xflat, yflat, zflat, stacks, slices,f1,f2,f3,Switch)

   #declare NumVertices = numverts1(stacks, slices,Switch);

   #declare V_vec_Arr=array[NumVertices] 
   #declare N_vec_Arr=array[NumVertices] 
   #declare UV_vec_Arr=array[NumVertices]
   #declare NumEdges = 0;
   #declare Edge_Arr=array[NumVertices*3]
   #declare NumFaces = 0;
   #declare Face_Arr=array[NumVertices*2]


  #local i = 0;
  #local j = 0;

  #local k = 0;
  #local drho = Vmax / stacks;
  #local dtheta = Umax / slices;
  #local s1 = 1; #local s2 = 1; #local e1 = 1; #local e2 = 1;
  
  #while (i <= stacks)
    #local V=RangeMM(i,0,stacks,Vmin,Vmax);
    #local rho = i * drho;
    #local s = sin(rho);
    #local c = cos(rho);
    #local j = 0;
    #local n = 1;
    #if (floor(slices * s) > 1) #local n = floor(slices * s);
    #end
    #if (Switch) #local n = slices; #end 
    
    #local dtheta = Umax / n;
    #local s1 = s2;
    #local s2 = k + 1;
    #if ((Switch = 0) & (n>1)) #local n = n-1; #end
    #while (j <= n)
      #if ((Switch) | (n>1)) #local U=RangeMM(j,0,n,Umin,Umax);
      #else #local U=RangeMM(j,0,n+1,Umin,Umax);
       #end
      //#declare UV_vec_Arr[k]=<(j/n)*Umax,(i/stacks)*Vmax>;
      //#declare UV_vec_Arr[k]=<(j/n)*1024,(i/stacks)*512>;
      //#declare UV_vec_Arr[k]=<(j/n),(i/stacks)>;
      //#declare UV_vec_Arr[k]=<0,1>;
      
      #declare UV_vec_Arr[k]=<U,V>;
      #local theta = j * dtheta;
      #local _x = sin(theta) * s;
      #local _y = c;
      #local _z = cos(theta) * s;
      #declare N_vec_Arr[k] = <_x,_y,_z>;
      
      #local _x = f1(U,V);
      #local _y = f2(U,V);
      #local _z = f3(U,V);
      
      #local _x = _x * Radius * (1.0 - xflat);
      #local _y = _y * Radius * (1.0 - yflat);
      #local _z = _z * Radius * (1.0 - zflat);
      #declare V_vec_Arr[k] = <_x,_y,_z>;
      #local j=j+1;
      #local k=k+1;
    #end
    #local e1 = e2; 
    #local e2 = k;
    #if (i) stripedges(s1-1, e1-1, s2-1, e2-1) #end
    #if (i) stripfaces(s1-1, e1-1, s2-1, e2-1) #end
    #local i=i+1;
  #end
  
  echo("\nNum Verts *******")
  echof(NumVertices)
  echo("\nStripping Faces *******")
  echof(NumFaces)
  echo("\nStripping Edges *******")
  echof(NumEdges)
  echo("\nChecking Normals")
  //Norms()
  
#end
#macro numverts1(stacks, slices,Switch)
//
  #local i = 0;
  #local j = 0;

  #local k = 0;
  #local drho = Vmax / stacks;
  #local dtheta = Umax / slices;
  #while (i <= stacks)
    #local rho = i * drho;
    #local s = sin(rho);
    #local j = 0;
    #local n = 1;
    #if (floor(slices * s) > 1) #local n = floor(slices * s);
    #end 
    #if (Switch) #local n = slices; #end
    #if ((Switch = 0) & (n>1)) #local n = n-1; #end
    #while (j <= n)
      #local j=j+1;
      #local k=k+1;
   #end
    #local i=i+1;
  #end
  (k)
#end

#macro Links(edgerad,triangles)
 union {
   #local I=0;
   #while (I<Iter_V)
      #local J=0;
      #while (J<Iter_U)
         #local Ind=(I*Iter_U)+I+J;
         #if (!VEq(V_vec_Arr[Ind], V_vec_Arr[Ind+1])) cylinder {V_vec_Arr[Ind], V_vec_Arr[Ind+1], edgerad} #end
         #if (!VEq(V_vec_Arr[Ind+1], V_vec_Arr[Ind+2])) cylinder {V_vec_Arr[Ind+1], V_vec_Arr[Ind+Iter_U+2], edgerad} #end
         //#if (triangles) & (!VEq(V_vec_Arr[Ind], V_vec_Arr[Ind+Iter_U+2]))) cylinder {V_vec_Arr[Ind], V_vec_Arr[Ind+Iter_U+2], edgerad} #end
         //or
         #if ((triangles) & (!VEq(V_vec_Arr[Ind+1], V_vec_Arr[Ind+Iter_U]+1))) cylinder {V_vec_Arr[Ind+1], V_vec_Arr[Ind+Iter_U+1], edgerad} #end
         #local J=J+1;
      #end
      #local I=I+1;
   #end
}
#end



#macro Quads(rswitch,C)
 union {
   #local I=0;
   #while (I<Iter_V)
      #local J=0;
      #while (J<Iter_U)
         #local Ind=(I*Iter_U)+I+J;
         #local Col = <rand(S3),rand(S2),rand(S1),.9,.1>;
         #if(!VEq(V_vec_Arr[Ind], V_vec_Arr[Ind+Iter_U+1]) &
           !VEq(V_vec_Arr[Ind], V_vec_Arr[Ind+1]) &
           !VEq(V_vec_Arr[Ind+1], V_vec_Arr[Ind+Iter_U+1]) )
         triangle {V_vec_Arr[Ind], V_vec_Arr[Ind+Iter_U+1], V_vec_Arr[Ind+1]
             texture { 
                  #if (rswitch) tex(Col)
                  #else tex(C)
                  #end
             }
         } #end
         #if(!VEq(V_vec_Arr[Ind+Iter_U+1], V_vec_Arr[Ind+Iter_U+2]) &
           !VEq(V_vec_Arr[Ind+Iter_U+1], V_vec_Arr[Ind+1]) &
           !VEq(V_vec_Arr[Ind+1],V_vec_Arr[Ind+Iter_U+2]) )
         triangle {V_vec_Arr[Ind+Iter_U+1], V_vec_Arr[Ind+Iter_U+2],V_vec_Arr[Ind+1]
             texture { 
                  #if (rswitch) tex(Col)
                  #else tex(C)
                  #end
             }
         } #end
         
         #local J=J+1;
      #end
      #local I=I+1;
   #end
}
#end


/************ unecessary code
#declare Tc = array[999]
#macro colorarray()
#local i=0;
 #while (i < 999)
    #declare Tc[i]=<mod(i,3)/3, mod(i,5)/5, mod(i,7)/7>;
    #local i=i+1;
  #end
#end  
  
#macro round(f,n)
	#local c = floor(pow(10.0,n));
	#local dd = 0.5 / c;
	#local dd = dd + abs(f);
	#local dd = dd * c;

	#local dd=floor(dd);
	#local dd = dd/c;
	#if (f < 0.0) #local dd = dd * -1; #end
	(dd)
#end

*/



