#ifndef(Tea_Light_Inc)
#declare Tea_Light_Inc = version;
#version 3.61;

#ifdef(View_POV_Include_Stack)
  #debug "including tea-light.inc\n"
#end

/*
From: Trevor G Quayle
Subject: Candle flame from Tea-Light
Date: 6 Jun 2007 13:05:02
Message: <web.4666afce2c74cfc0c150d4c10@news.povray.org>
  
  
  
    

By request, source code for the candle flame from my Tea-Light image in
p.b.i

There are 3 variables in the macro:
Turb - effects how distorted the flame is
Scal - final scaling of the flame, required to maintain media density
LSiz - number of lights (0=off, 1=point, >1=area light)

The RND1 seed is also needed to be declared outside the macro so that if
there more than one flames in a scene, their turbulence is different and
they don't look identical.

Enjoy!!

*/

//START
#declare RND1=seed(2);
#macro Flam (Turb,Scal,LSiz)
  #local OS=rand(RND1)*50;
  #local Flam1 = function(x,y,z)
{pow(pow(pow(3*x,2)+pow(0.8*y-0.2,2)+pow(3*z,2),3)+pow(max(1-sqrt(pow(5*x,2)+pow(y+.5,2)+pow(5*z,2)),0),2))}
  #local Flam2 = function(x,y,z)
{floor(pow(sqrt(pow((3.5*x),2)+pow((0.4*y+0.6),2)+pow((3.5*z),2)),2))}
  #local FlamF = function(x,y,z) {min(max(Flam1(x,y,z),Flam2(x,y,z)),1)}
  #macro turb_translate (tTurb,tOcta,tLamb,tOmeg,P0,Acc)
    #local PC=P0;
    #local Dir=<0,0,0>;
    #local V0=vlength(vturbulence(tLamb, tOmeg, tOcta, P0)*tTurb);
    #local Step=V0/2;
    #macro AB(PC,Step,d,Dir,V0)
      #local P1=PC+Step*d;
      #local V1=vlength(P1+vturbulence(tLamb, tOmeg, tOcta, P1)*tTurb-P0);
      #if (V1<V0 | d.x=1)
        #local Dir=d;
        #local V0=V1;
      #end
    #end
    #while (V0>Acc)
      #local DrP=Dir;
      AB(PC,Step, x,Dir,V0)
      AB(PC,Step,-x,Dir,V0)
      AB(PC,Step, y,Dir,V0)
      AB(PC,Step,-y,Dir,V0)
      AB(PC,Step, z,Dir,V0)
      AB(PC,Step,-z,Dir,V0)
      #if (vlength(DrP+Dir)=0)
        #local Step=Step/2;
      #else
        #local Step=V0/2;
      #end
      #local PC=PC+Step*Dir;
    #end
    PC
  #end
  #local tOcta=7;
  #local tLamb=1.32;
  #local tOmeg=0.35;
  union{
      sphere{0 1.1 scale <1/2,1,1/2> translate y*(0.15+OS)
      hollow
      pigment{rgbt <1,1,1,1>}
      interior{
        media{
          emission rgb 25/Scal
          method 3
          intervals 2
          density{
            function{FlamF(x,y-OS,z)}
            color_map{
              [0.00 rgb <1,1,.5>]
              [0.20 rgb <1,.5,0>]
              [0.60 rgb <1,.1,0>]
              [0.78 rgb <0,0,0>]
              [0.86 rgb <0,0,0>]
              [0.92 rgb <0,0,1>]
              [0.98 rgb <0,0,1>]
              [1.00 rgb <0,0,0>]
            }
            warp{
              turbulence Turb
              octaves tOcta
              lambda tLamb
              omega tOmeg
            }
          }
          #local FlamF2 = function(x,y,z)
{pow(max((1-sqrt(pow(x*2.2,2)+pow(y/1.5,2)+pow(z*2.2,2))),0),3)}
          density{
            function{3*FlamF2(x,y-OS-0.15+0.5,z)}
            warp{
              turbulence Turb
              octaves tOcta
              lambda tLamb
              omega tOmeg
            }
          }
        }
      }
      translate -y*OS
    }
    sphere{0 1
      hollow
      pigment{rgbt <1,1,1,1>}
      interior{
        media{
          emission rgb <0.98824, 0.58039, 0.0451>/Scal
          method 3
          intervals 2
          density{
            function{3/exp(sqrt(pow(x*1.3,2)+pow(y,2)+pow(z*1.3,2))*4)}
          }
        }
      }
      no_shadow
      translate turb_translate(Turb,tOcta,tLamb,tOmeg,y*OS,0.001)
      translate -y*OS
    }
    cylinder{-y*10, y*40, 5
      hollow
      pigment{rgbt <1,1,1,1>}
      interior{
        media{
          absorption rgb 1/Scal
          density{

function{pow(max(1-sqrt(pow(x/2,2)+pow((y-5)/35,2)+pow(z/2,2)),0),0.5)*5}
             scale 1/4
             warp{
              turbulence 0.5
              octaves 4
              lambda 4
              omega 0.5
            }
            scale 4
          }
          density{
            bozo
            colour_map{[0.2 rgb 1.0][0.8 rgb -0.30]}
            scale <1/2,2,1/2>*3
            warp{
              turbulence 0.5
              octaves 4
              lambda 4
              omega 0.5
            }
          }

        }
      }
      translate -y*2
      scale 1/4
      no_image

    }
    #if (LSiz>0)
      light_source{0
        rgb <0.98824, 0.58039, 0.0451>
        #if (LSiz>1)
          area_light x/2 z/2
          LSiz,LSiz
          adaptive 1
          jitter
          circular
          orient
        #end
        media_attenuation on
        fade_power ln(1/(sqrt(2)-1))/ln(2)
        fade_distance 10*Scal
        translate turb_translate(Turb,tOcta,tLamb,tOmeg,y*OS,0.001)
        translate -y*OS
        projected_through{cylinder {0, y*10,1 translate y*(0.15-0.5)}}
      }
    #end
    translate -turb_translate(Turb,tOcta,tLamb,tOmeg,y*(OS-0.5),0.001)
    translate y*OS
    scale <1,1.2,1>
  }
#end
//END

#version Tea_Light_Inc;
#end
