#version 3.61;

#declare Use_Radiosity = yes;

#declare Load_Radiosity = no;

#declare Rad_Sample_File = "candle_glow_3.rad";

#if(Use_Radiosity)
  #default { finish { ambient 0 diffuse 1 } }
#end

#include "colors.inc"
#include "candle.inc"
#include "candle_holder.inc"
#include "rad_def.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 6
  #if(Use_Radiosity)
    radiosity {
      Rad_Settings(Radiosity_Fast, no, no)
      #if(Load_Radiosity & file_exists(Rad_Sample_File))
        load_file Rad_Sample_File
      #else
        save_file Rad_Sample_File
      #end
    }
  #end
}

camera {
  location <4, 5, -7>
  up y
  right x * image_width/image_height
  look_at y
}

#declare R = seed(13);  
#declare Light_Density = 6;
#declare Glow_Density = 1;

union {
  object {
    Candle(White, 2, 3, 0.25, 0.3, Light_Density, 0.5, Glow_Density, R)
    translate y
  }
  object { Candle_Holder }
  translate z * 3
  rotate y * -90
}

union {
  object {
    Candle(White, 2, 3, 0.25, 0.3, Light_Density, 0.5, Glow_Density, R)
    translate y
  }
  object { Candle_Holder }
  translate z * 3
  rotate y * -45
}

union {
  object {
    Candle(White, 2, 3, 0.25, 0.3, Light_Density, 0.5, Glow_Density, R)
    translate y * 1.5
  }
  object { Candle_Holder }
  translate z * 3
}

union {
  object {
    Candle(White, 2, 3, 0.25, 0.3, Light_Density, 0.5, Glow_Density, R)
    translate y * 1.5
  }
  object { Candle_Holder }
  translate z * 3
  rotate y * 45
}

union {
  object {
    Candle(White, 2, 3, 0.25, 0.3, Light_Density, 0.5, Glow_Density, R)
    translate y * 1.5
  }
  object { Candle_Holder }
  translate z * 3
  rotate y * 90
}

plane {
  y, 0
  pigment { rgb <0.75, 0.75, 1> }
}
