#ifndef(Candle_Inc)
#declare Candle_Inc = version;
#version 3.61;

#ifdef(View_POV_Include_Stack)
  #debug "including candle.inc\n"
#end

#include "math.inc"
#include "tea-light.inc"

#declare Candle_Flame = rgb <255, 130, 0>/255;

#macro Candle(Wax_Color, Min_Height, Max_Height, Radius, 
              Flame_Scale, Flame_Light_Density, Flame_Light_Scale, 
              Glow_Density, Rand_Stream)

  #local Ht = adj_range(rand(Rand_Stream), Min_Height, Max_Height);
  
  union {
    cylinder {
      0, y * Ht, Radius
      double_illuminate
      texture {
        pigment { Wax_Color }
        finish {
          specular 0.5
          roughness 0.001
        }
      }
    }
    object {
      Flam(0.1, Flame_Scale, 0)
      scale Flame_Scale
      translate y * (Ht + 0.2)
    }
    #if(Flame_Light_Density > 0)
      light_source {
        <0, Ht + 1, 0>, Candle_Flame * Flame_Light_Scale
        #if(Flame_Light_Density > 1)
          area_light
          x/2, y/2, Flame_Light_Density, Flame_Light_Density
          adaptive 1
          circular
          orient
          jitter
        #end
        fade_distance 2
        fade_power 2
      }
    #end
    #if(Glow_Density > 0)
      #local Glow_Sz = min(Radius, Flame_Scale) - 0.01;
    
      light_source {
        <0, Ht - 0.1, 0>, Candle_Flame
        #if(Glow_Density > 1)
          area_light
          x * Glow_Sz, z * Glow_Sz, Glow_Density, Glow_Density
          circular
          adaptive 1
        #end
        fade_distance Glow_Sz
        fade_power 2
      }
    #end
  }

#end

#version Candle_Inc;
#end
