
/**
http://www.tresd1.com.br/viewtopic.php?t=8557&start=0
converted to povray primitives...
nice little scene and great for illumination purposes...
namekuseijin from nospamgmail.com jan/2008
**/

#local HQ = 1;
#local GI = 1;
#local GIgather = 1;
#local CAD = 0;
#local CAMS = 1;

#if (GI)
#local LF = .5;
#else
#local LF = 1.1;
#end

global_settings {
    #if (GI)
    radiosity {
        brightness 1.9
        #if (!GIgather)
        load_file "illum.rca"
        always_sample no
        #else
        save_file "illum.rca"
        #end

        #if (HQ)
        count 80*5*2
        error_bound .6/2
        low_error_factor .6/2
        nearest_count 12
        recursion_limit 4
        #else
        count 80*2
        error_bound 1
        low_error_factor 1
        nearest_count 8
        recursion_limit 4
        #end
        pretrace_start .04
        pretrace_end .008
        gray_threshold .7
    }
    #else
    ambient_light 1.4
    #end
}



#local room_s = <3*2,3,7>;
#local wt = .16;
#local win_s = <2.2,2.5,wt*2+.02>;

#local room_base = difference {
    box { -1,1 scale (room_s+wt*2)/2}
    box { -1,1 scale room_s/2}
}

#local room = difference {
    object { room_base }
    // windows
    box { -1,1 scale win_s/2 translate (z-x-y)*room_s/2 +(y+x)*win_s/2 +x*.4 }
    box { -1,1 scale win_s/2 translate (z-x-y)*room_s/2 +(y+4*x)*win_s/2 +x*.2*2 }
}

#declare room = union {
    object { room }
    // extra wall
    union {
        box { -1,1 scale <wt,room_s.y,.8>/2 }
        cone { 0, .09, .26*y, .12 open pigment { rgb x } finish {ambient .02 diffuse .62 } translate -y*(room_s.y/2-.01) +x*(wt+.1) -z*.2 }
        translate (z-x)*room_s/2 -z*.8/2 +x*(win_s.x+.9)
    }
    // floor
    box { -1,1 scale (x+z)*(room_s/2+wt) + y*.03/2 translate -y*room_s.y/2 pigment { rgb 1 /*x+y*2/3*/ } finish { ambient 0 diffuse .8 } }
    // stand
    #local sst = <.4,.6,1.2*2>;
    #local ssd = <.04,.6-.01,1.2-.01>;
    #local ssb = <.3,.2,.9*2>;
    union {
        box { -1,1 scale ssb/2 }
        union {
            box { -1,1 scale sst/2 }
			object { #include "meshstandford_bunny.inc" rotate y*90 translate y*(sst.y)/2 }
            // doors
            box { -1,1 scale ssd/2 translate z*(sst.z/2-ssd.z/2) +x*sst.x/2 }
            box { -1,1 scale ssd/2 translate z*(-sst.z/2+ssd.z/2) +x*sst.x/2 }
            translate y*(sst.y+ssb.y)/2
        }
        translate (z-x-y)*room_s/2 -z*(sst.z/2+.3) +y*(ssb.y/2) +x*(sst.x/2+.02) 
    }
    // wall decoration
    union {
        #local wds = .36-x*.20;
        #local a =
        difference {
            box { -1,1 scale wds/2 }
            box { -1,1 scale (wds-.06)/2+x*.07 }
        }
        object { a }
        object { a translate -z*wds }
        object { a translate -z*wds*2 }
        object { a translate -z*wds*3 }

        pigment { rgb x+y }
        finish { ambient 0 diffuse .62 }
        //translate (z-x)*room_s/2 +x*(wds/2+.01) -z*(wds.z/2+.4)
        translate (z-x)*room_s/2 +x*(wds/2+.01) -z*(sst.z/2+.0)
    }
}


background { rgb 1 }

union {
    #if (CAD) difference { #end
    object { room translate y*room_s.y/2 }
	object { #include "meshstandford_bunny.inc" scale 1 rotate y*30 translate y*.0-x*1+z }
    #if (CAD)
    plane { -y, -room_s.y+.02 pigment { rgbt .7 } }
    }
    #end
    #if (!GI)
    light_source { y*(room_s.y-.2) .8 }
    #end
    // sun
    light_source { z*20+y*4 1.2 parallel point_at -x }

    pigment { rgb 1 }
    finish { ambient #if(!GI) .3 #else 0 #end diffuse .6 }
}


#local where0 = y/3;
#local focus0 = z+y/3;

#local where1 = <-.6,1.6,-room_s.z/2+.8>;
#local focus1 = y*1.6-x*.9;

#local where2 = <-.6,1.2,-room_s.z/2+1.2>;
#local focus2 = y*1.2-x*.98;

// cad top
#local where3 = <0,room_s.y*3,0>;
#local focus3 = 0;
// cad 3/4
#local where4 = <1,1,-1>*3*room_s.y;
#local focus4 = 0;


#local where = where2;
#local focus = focus2;

#if (CAD=1)
#declare where = where3;
#declare focus = focus3;
#end
#if (CAD=2)
#declare where = where4;
#declare focus = focus4;
#end

camera {
    #if (CAD) orthographic #end
    location where
    look_at focus
    angle 54
}

