// 1.3
// -w320 -h240 +a0.3
// -w512 -h384 +a0.3
// -w800 -h600 +a0.3
// -w1024 -h768 +a0.3
// -w1600 -h1200 +a0.3
// -w2000 -h1500 +a0.3
// -w2400 -h1800 +a0.3
// -w2800 -h2100 +a0.3
// -w3200 -h2400 +a0.3
// 1.25
// -w630 -h504 +a0.3
// -w1280 -h1024 +a0.3
#include "stdinc.inc"
#include "textures.inc"
#include "metals.inc"


#version 3.5;
#declare Radiosity=off;

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08        // start pretrace at this size
      pretrace_end   0.04        // end pretrace at this size
      count 80                   // higher -> higher quality (1..1600) [35]
      nearest_count 10           // higher -> higher quality (1..10) [5]
      error_bound 1.0            // higher -> smoother, less accurate [1.8]
      recursion_limit 7          // how much interreflections are calculated (1..5+) [3]
      low_error_factor .4        // reduce error_bound during last pretrace step
      gray_threshold 0.0         // increase for weakening colors (0..1)[0]
      minimum_reuse 0.01         // reuse old radiosity samples[0.015]
      brightness 1               // brightness of radiosity effects(0..1) [1]
      adc_bailout 0.01/2
      normal on                  // use surface normals [off]
      media on                   // take media into account [off]

    }
  #end  
}


#declare P_IM_Moon = 

  pigment {
   image_map {
     jpeg "moon"
     // map_type 1
     interpolate 2
 }
}


sphere {
 0,2000
 pigment {rgbf 1}
 inverse
} 

 fog {
   rgb <0.2,0.2,0.4>
   fog_type 1
   distance 2400
 }
                                                                  
                                                                  
 fog {
   rgb <0.6,0.5,0.7>*0.8
   fog_type 2
   fog_offset 0
   fog_alt 300
   distance 2000
}
  
plane {
    y,-10
    //rotate x*-1
    texture {
       T_Chrome_5E
       normal {
          waves 0.15
          frequency 5000
          scale 4000
       }
   }
   filter 0.9
   pigment{color <0.3,0.4,0.85>*0.6}
   finish { ambient .12 }
}
light_group {
  light_source {
    <5000,1500,5000>
    <0.8,0.75,0.7>*2
 }

 sphere {
  0,1
  #if (0)
  pigment { P_IM_Moon }
  finish {ambient 0 brilliance 2}
  scale 300 
  //material { half_moon }
  rotate <0,-85,0>
  rotate <0,0,-15>
  #else
  pigment {
   image_map {
    jpeg "Moon"
    map_type 1
    interpolate 2
   }
  }
  finish {ambient 0 brilliance 2}
  scale 900
  rotate <0,-85,0>
  //rotate z*20
  #end
  translate <-600,450,7000>
 }
 global_lights off

}
camera {
    location <0, 3, -20>
    look_at <0, 3, 0>
    rotate <0,0,0>
    angle 33
}