// 1.3
// -w320 -h240 +a0.3
// -w512 -h384 +a0.3
// -w800 -h600 +a0.3
// -w1024 -h768 +a0.3
// -w1600 -h1200 +a0.3
// -w2000 -h1500 +a0.3
// -w2400 -h1800 +a0.3
// -w2800 -h2100 +a0.3
// -w3200 -h2400 +a0.3
// 1.25
// -w630 -h504 +a0.3
// -w1280 -h1024 +a0.3
#include "stdinc.inc"
#include "textures.inc"
#include "metals.inc"
#include "glass.inc"
#include "skies.inc"
//#include "triangulation.inc"

#version 3.5;
#declare Radiosity=off;

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08        // start pretrace at this size
      pretrace_end   0.04        // end pretrace at this size
      count 80                   // higher -> higher quality (1..1600) [35]
      nearest_count 10           // higher -> higher quality (1..10) [5]
      error_bound 1.0            // higher -> smoother, less accurate [1.8]
      recursion_limit 7          // how much interreflections are calculated (1..5+) [3]
      low_error_factor .4        // reduce error_bound during last pretrace step
      gray_threshold 0.0         // increase for weakening colors (0..1)[0]
      minimum_reuse 0.01         // reuse old radiosity samples[0.015]
      brightness 1               // brightness of radiosity effects(0..1) [1]
      adc_bailout 0.01/2
      normal on                  // use surface normals [off]
      media on                   // take media into account [off]

    }
  #end  
}

//sky_sphere { S_Cloud1 }
#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgbf <0.6,0.7,1.0,.5>]
          [1 rgbf <0.4,0.5,0.8,.5>]
        }
    } 
}
//sky_sphere {sky_blue}
plane {
    y,-10 rotate x*-4
    texture {
       T_Chrome_5E
       normal {
          waves 0.15
          frequency 5000
          scale 4000
       }
   }
   filter 0.9
   pigment{color <0.3,0.4,0.85>*0.6}
   finish { ambient .12 }
}

camera {
    location <0, 3, -20>
    look_at <0, 3, 0>
    rotate <0,0,0>
    angle 33
}                      

#declare P_stars = pigment {
  image_map {
    png "stars"
    map_type 1
    interpolate 2
  }
} 
#declare sky_stars =
sky_sphere {
    pigment {P_stars} 
}    
#declare P_IM_Moon = 

  pigment {
   image_map {
     jpeg "moon"
     // map_type 1
     interpolate 2
 }
 // finish { ambient .9 }
} 

#declare filt = .5;
#declare bg_png_current =
plane { < 0.0,0.0,-1.0 >, -80000
texture {
pigment { image_map { png "stars" once } }
finish { ambient .5 diffuse 0 }
translate < -0.5 , -0.4 , 0.0 >
scale < 68000.0 , 51000.0 , 1.0 >
}
}

       
#declare P_Cloud2f =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color rgbf <0.85 , 0.85 , 0.95,filt>
                    color rgbf <0.75 , 0.75 , 0.85,filt>]
        [0.1, 0.5   color rgbf <0.75 , 0.75 , 0.85,filt>
                    color rgbf <0.258, 0.258, 0.535,filt>  ]
        [0.5, 1.001 color rgbf <0.258, 0.258, 0.535,filt>
                    color rgbf <0.258, 0.258, 0.535,filt> ]
    }
    scale <6, 1, 6>
}
#declare P_Cloud3f =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color rgbf <0.85 , 0.85 , 0.95,filt>
                    color rgbf <0.55 , 0.60 , 0.75,filt>]
        [0.1, 0.5   color rgbf <0.55 , 0.60 , 0.75,filt>
                    color rgbf <0.184, 0.184, 0.409,filt> ]
        [0.5, 1.001 color rgbf <0.184, 0.184, 0.409,filt>
                    color rgbf <0.1, 0.1, 0.3,filt>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

plane { < 0.0,0.0,-1.0 >, -80000
texture {


pigment {
        gradient y
        pigment_map {
            [0.01 rgbf <0.847, 0.749, 0.847,1> ] // horizon
            [0.25 P_Cloud2f scale 0.25  rotate z*5 ]
            [0.60 P_Cloud3f scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }        
finish { ambient 1 diffuse 0 }
translate < -0.5 , 12.55 , 0.0 >   //-0.4  9.96
scale < 68000.0 , 51000.0 , 1.0 >
}
}        
//object { bg_png_current }
#declare p_map1=pigment {image_map{jpeg "moon" interpolate 2 transmit all 0 filter all 0} }
#declare p_map2=pigment {image_map{png "moontr" interpolate 2 }}

#declare _moon = texture{ pigment{ p_map1} }

#declare half_moon =  material {
texture { pigment_pattern{ p_map2} 
texture_map { [ 0 pigment{Clear} ]
              [ 1 _moon ]
           }
     }
}

sphere { <0,0,0>, 150000.0 
  uv_mapping 
  pigment { P_IM_Moon } //p_map1 
  //material { half_moon }
  rotate <0,-78,0>
  rotate <0,0,-15>
  translate <-500000,500000,3000000>

}



light_source {
 vaxis_rotate(<-500000 + 150000.0 *2, 500000,2600000>,z,radians(-15)) 
 //same result
 //rotation(deg2rad(15),z,<-500000 + 150000.0 *2, 500000,2600000>))
color White          *2
spotlight
point_at <-500000,500000,3000000>
radius 10
falloff 45
}



light_source { <30, 50, 500> color White*1.4 }
light_source {
<4,15.0,40.0>
color Red
spotlight
point_at <4,0,50>
radius 10
falloff 45
}
light_source {
<40,-2.5,-40>
color rgb < .4,1,.4>
fade_distance 80
fade_power 2
}
light_source {
<-50,25,-50>
color Blue
fade_distance 80
fade_power 2
}






union {
mesh {
smooth_triangle {
<0.022687,-1.870373,-6.745879>,
<-0.510045,0.598895,0.617397>,
<-1.206345,-4.380622,-5.326188>,
<-0.510045,0.598895,0.617397>,
<-1.651321,-4.437392,-5.638724>,
<-0.510045,0.598895,0.617397>
}
smooth_triangle {
<-1.651321,-4.437392,-5.638724>,
<-0.510050,0.598896,0.617392>,
<-0.360836,-1.801633,-7.129402>,
<-0.510050,0.598896,0.617392>,
<0.022687,-1.870373,-6.745879>,
<-0.510050,0.598896,0.617392>
}
smooth_triangle {
<-0.882007,-4.761758,-5.546268>,
<0.644717,0.112002,0.756172>,
<-1.206345,-4.380622,-5.326188>,
<0.644717,0.112002,0.756172>,
<0.022687,-1.870373,-6.745879>,
<0.644717,0.112002,0.756172>
}
smooth_triangle {
<0.022687,-1.870373,-6.745879>,
<0.644719,0.112001,0.756171>,
<0.408478,-2.125999,-7.036946>,
<0.644719,0.112001,0.756171>,
<-0.882007,-4.761758,-5.546268>,
<0.644719,0.112001,0.756171>
}
smooth_triangle {
<0.024956,-2.057258,-7.420468>,
<0.510052,-0.598895,-0.617391>,
<-1.326979,-4.818531,-5.858806>,
<0.510052,-0.598895,-0.617391>,
<-0.882007,-4.761758,-5.546268>,
<0.510052,-0.598895,-0.617391>
}
smooth_triangle {
<-0.882007,-4.761758,-5.546268>,
<0.510049,-0.598896,-0.617393>,
<0.408478,-2.125999,-7.036946>,
<0.510049,-0.598896,-0.617393>,
<0.024956,-2.057258,-7.420468>,
<0.510049,-0.598896,-0.617393>
}
smooth_triangle {
<-0.360836,-1.801633,-7.129402>,
<-0.644716,-0.112003,-0.756172>,
<-1.651321,-4.437392,-5.638724>,
<-0.644716,-0.112003,-0.756172>,
<-1.326979,-4.818531,-5.858806>,
<-0.644716,-0.112003,-0.756172>
}
smooth_triangle {
<-1.326979,-4.818531,-5.858806>,
<-0.644717,-0.112002,-0.756171>,
<0.024956,-2.057258,-7.420468>,
<-0.644717,-0.112002,-0.756171>,
<-0.360836,-1.801633,-7.129402>,
<-0.644717,-0.112002,-0.756171>
}
smooth_triangle {
<-1.206345,-4.380622,-5.326188>,
<0.032397,-0.015103,0.999361>,
<1.903839,-3.999696,-5.421255>,
<0.032397,-0.015103,0.999361>,
<2.047052,-4.527167,-5.433869>,
<0.032397,-0.015103,0.999361>
}
smooth_triangle {
<2.047052,-4.527167,-5.433869>,
<0.032397,-0.015104,0.999361>,
<-1.218644,-4.927140,-5.334049>,
<0.032397,-0.015104,0.999361>,
<-1.206345,-4.380622,-5.326188>,
<0.032397,-0.015104,0.999361>
}
smooth_triangle {
<1.951012,-3.872037,-5.950763>,
<-0.111761,0.968279,0.223486>,
<1.903839,-3.999696,-5.421255>,
<-0.111761,0.968279,0.223486>,
<-1.206345,-4.380622,-5.326188>,
<-0.111761,0.968279,0.223486>
}
smooth_triangle {
<-1.206345,-4.380622,-5.326188>,
<-0.111761,0.968279,0.223485>,
<-1.314684,-4.272010,-5.850943>,
<-0.111761,0.968279,0.223485>,
<1.951012,-3.872037,-5.950763>,
<-0.111761,0.968279,0.223485>
}
smooth_triangle {
<-1.326979,-4.818531,-5.858806>,
<-0.032399,0.015113,-0.999361>,
<2.094224,-4.399515,-5.963383>,
<-0.032399,0.015113,-0.999361>,
<1.951012,-3.872037,-5.950763>,
<-0.032399,0.015113,-0.999361>
}
smooth_triangle {
<1.951012,-3.872037,-5.950763>,
<-0.032397,0.015106,-0.999361>,
<-1.314684,-4.272010,-5.850943>,
<-0.032397,0.015106,-0.999361>,
<-1.326979,-4.818531,-5.858806>,
<-0.032397,0.015106,-0.999361>
}
smooth_triangle {
<-1.218644,-4.927140,-5.334049>,
<0.111762,-0.968282,-0.223472>,
<2.047052,-4.527167,-5.433869>,
<0.111762,-0.968282,-0.223472>,
<2.094224,-4.399515,-5.963383>,
<0.111762,-0.968282,-0.223472>
}
smooth_triangle {
<2.094224,-4.399515,-5.963383>,
<0.111760,-0.968280,-0.223479>,
<-1.326979,-4.818531,-5.858806>,
<0.111760,-0.968280,-0.223479>,
<-1.218644,-4.927140,-5.334049>,
<0.111760,-0.968280,-0.223479>
}
smooth_triangle {
<1.903839,-3.999696,-5.421255>,
<0.386796,0.708737,0.589984>,
<0.022687,-1.870373,-6.745879>,
<0.386796,0.708737,0.589984>,
<0.354522,-1.714014,-7.151263>,
<0.386796,0.708737,0.589984>
}
smooth_triangle {
<0.354522,-1.714014,-7.151263>,
<0.386790,0.708736,0.589989>,
<2.329733,-3.949800,-5.760405>,
<0.386790,0.708736,0.589989>,
<1.903839,-3.999696,-5.421255>,
<0.386790,0.708736,0.589989>
}
smooth_triangle {
<-0.306880,-2.213618,-7.015085>,
<-0.606002,-0.041189,0.794396>,
<0.022687,-1.870373,-6.745879>,
<-0.606002,-0.041189,0.794396>,
<1.903839,-3.999696,-5.421255>,
<-0.606002,-0.041189,0.794396>
}
smooth_triangle {
<1.903839,-3.999696,-5.421255>,
<-0.606001,-0.041187,0.794397>,
<1.668331,-4.449404,-5.624227>,
<-0.606001,-0.041187,0.794397>,
<-0.306880,-2.213618,-7.015085>,
<-0.606001,-0.041187,0.794397>
}
smooth_triangle {
<2.094224,-4.399515,-5.963383>,
<-0.386795,-0.708736,-0.589986>,
<0.024956,-2.057258,-7.420468>,
<-0.386795,-0.708736,-0.589986>,
<-0.306880,-2.213618,-7.015085>,
<-0.386795,-0.708736,-0.589986>
}
smooth_triangle {
<-0.306880,-2.213618,-7.015085>,
<-0.386801,-0.708739,-0.589978>,
<1.668331,-4.449404,-5.624227>,
<-0.386801,-0.708739,-0.589978>,
<2.094224,-4.399515,-5.963383>,
<-0.386801,-0.708739,-0.589978>
}
smooth_triangle {
<2.329733,-3.949800,-5.760405>,
<0.606002,0.041189,-0.794396>,
<0.354522,-1.714014,-7.151263>,
<0.606002,0.041189,-0.794396>,
<0.024956,-2.057258,-7.420468>,
<0.606002,0.041189,-0.794396>
}
smooth_triangle {
<0.024956,-2.057258,-7.420468>,
<0.606004,0.041192,-0.794395>,
<2.094224,-4.399515,-5.963383>,
<0.606004,0.041192,-0.794395>,
<2.329733,-3.949800,-5.760405>,
<0.606004,0.041192,-0.794395>
}
smooth_triangle {
<-3.433269,-6.007338,-1.069075>,
<-0.015136,0.778781,0.627114>,
<-0.721847,-6.961844,0.181720>,
<-0.015136,0.778781,0.627114>,
<-0.925505,-7.282458,0.574959>,
<-0.015136,0.778781,0.627114>
}
smooth_triangle {
<-0.925505,-7.282458,0.574959>,
<-0.015134,0.778782,0.627112>,
<-3.772496,-6.280226,-0.738374>,
<-0.015134,0.778782,0.627112>,
<-3.433269,-6.007338,-1.069075>,
<-0.015134,0.778782,0.627112>
}
smooth_triangle {
<-0.590373,-7.337268,-0.193347>,
<0.487905,0.696507,-0.526143>,
<-0.721847,-6.961844,0.181720>,
<0.487905,0.696507,-0.526143>,
<-3.433269,-6.007338,-1.069075>,
<0.487905,0.696507,-0.526143>
}
smooth_triangle {
<-3.433269,-6.007338,-1.069075>,
<0.487905,0.696508,-0.526142>,
<-3.437364,-6.335036,-1.506680>,
<0.487905,0.696508,-0.526142>,
<-0.590373,-7.337268,-0.193347>,
<0.487905,0.696508,-0.526142>
}
smooth_triangle {
<-3.776595,-6.607918,-1.175982>,
<0.015131,-0.778786,-0.627107>,
<-0.794032,-7.657875,0.199892>,
<0.015131,-0.778786,-0.627107>,
<-0.590373,-7.337268,-0.193347>,
<0.015131,-0.778786,-0.627107>
}
smooth_triangle {
<-0.590373,-7.337268,-0.193347>,
<0.015131,-0.778785,-0.627108>,
<-3.437364,-6.335036,-1.506680>,
<0.015131,-0.778785,-0.627108>,
<-3.776595,-6.607918,-1.175982>,
<0.015131,-0.778785,-0.627108>
}
smooth_triangle {
<-3.772496,-6.280226,-0.738374>,
<-0.487904,-0.696513,0.526136>,
<-0.925505,-7.282458,0.574959>,
<-0.487904,-0.696513,0.526136>,
<-0.794032,-7.657875,0.199892>,
<-0.487904,-0.696513,0.526136>
}
smooth_triangle {
<-0.794032,-7.657875,0.199892>,
<-0.487904,-0.696513,0.526136>,
<-3.776595,-6.607918,-1.175982>,
<-0.487904,-0.696513,0.526136>,
<-3.772496,-6.280226,-0.738374>,
<-0.487904,-0.696513,0.526136>
}
smooth_triangle {
<-0.721847,-6.961844,0.181720>,
<0.716981,0.689216,0.104500>,
<-0.894334,-6.317963,-2.881459>,
<0.716981,0.689216,0.104500>,
<-0.522648,-6.677819,-3.058237>,
<0.716981,0.689216,0.104500>
}
smooth_triangle {
<-0.522648,-6.677819,-3.058237>,
<0.716986,0.689210,0.104500>,
<-0.341537,-7.353900,0.158102>,
<0.716986,0.689210,0.104500>,
<-0.721847,-6.961844,0.181720>,
<0.716986,0.689210,0.104500>
}
smooth_triangle {
<-1.355452,-6.589745,-2.992829>,
<-0.533095,0.821420,0.202681>,
<-0.894334,-6.317963,-2.881459>,
<-0.533095,0.821420,0.202681>,
<-0.721847,-6.961844,0.181720>,
<-0.533095,0.821420,0.202681>
}
smooth_triangle {
<-0.721847,-6.961844,0.181720>,
<-0.533102,0.821415,0.202682>,
<-1.174341,-7.265826,0.223510>,
<-0.533102,0.821415,0.202682>,
<-1.355452,-6.589745,-2.992829>,
<-0.533102,0.821415,0.202682>
}
smooth_triangle {
<-0.794032,-7.657875,0.199892>,
<-0.716987,-0.689210,-0.104499>,
<-0.983767,-6.949606,-3.169605>,
<-0.716987,-0.689210,-0.104499>,
<-1.355452,-6.589745,-2.992829>,
<-0.716987,-0.689210,-0.104499>
}
smooth_triangle {
<-1.355452,-6.589745,-2.992829>,
<-0.716981,-0.689216,-0.104502>,
<-1.174341,-7.265826,0.223510>,
<-0.716981,-0.689216,-0.104502>,
<-0.794032,-7.657875,0.199892>,
<-0.716981,-0.689216,-0.104502>
}
smooth_triangle {
<-0.341537,-7.353900,0.158102>,
<0.533100,-0.821416,-0.202682>,
<-0.522648,-6.677819,-3.058237>,
<0.533100,-0.821416,-0.202682>,
<-0.983767,-6.949606,-3.169605>,
<0.533100,-0.821416,-0.202682>
}
smooth_triangle {
<-0.983767,-6.949606,-3.169605>,
<0.533092,-0.821421,-0.202681>,
<-0.794032,-7.657875,0.199892>,
<0.533092,-0.821421,-0.202681>,
<-0.341537,-7.353900,0.158102>,
<0.533092,-0.821421,-0.202681>
}
smooth_triangle {
<-0.894334,-6.317963,-2.881459>,
<-0.064874,0.964450,-0.256179>,
<-3.433269,-6.007338,-1.069075>,
<-0.064874,0.964450,-0.256179>,
<-3.812165,-6.132127,-1.442924>,
<-0.064874,0.964450,-0.256179>
}
smooth_triangle {
<-3.812165,-6.132127,-1.442924>,
<-0.064870,0.964453,-0.256169>,
<-1.146285,-6.458278,-3.345930>,
<-0.064870,0.964453,-0.256169>,
<-0.894334,-6.317963,-2.881459>,
<-0.064870,0.964453,-0.256169>
}
smooth_triangle {
<-3.397695,-6.483135,-0.802130>,
<0.557270,0.437581,0.705672>,
<-3.433269,-6.007338,-1.069075>,
<0.557270,0.437581,0.705672>,
<-0.894334,-6.317963,-2.881459>,
<0.557270,0.437581,0.705672>
}
smooth_triangle {
<-0.894334,-6.317963,-2.881459>,
<0.557270,0.437580,0.705672>,
<-0.731815,-6.809286,-2.705136>,
<0.557270,0.437580,0.705672>,
<-3.397695,-6.483135,-0.802130>,
<0.557270,0.437580,0.705672>
}
smooth_triangle {
<-0.983767,-6.949606,-3.169605>,
<0.064866,-0.964453,0.256168>,
<-3.776595,-6.607918,-1.175982>,
<0.064866,-0.964453,0.256168>,
<-3.397695,-6.483135,-0.802130>,
<0.064866,-0.964453,0.256168>
}
smooth_triangle {
<-3.397695,-6.483135,-0.802130>,
<0.064876,-0.964450,0.256177>,
<-0.731815,-6.809286,-2.705136>,
<0.064876,-0.964450,0.256177>,
<-0.983767,-6.949606,-3.169605>,
<0.064876,-0.964450,0.256177>
}
smooth_triangle {
<-1.146285,-6.458278,-3.345930>,
<-0.557271,-0.437579,-0.705673>,
<-3.812165,-6.132127,-1.442924>,
<-0.557271,-0.437579,-0.705673>,
<-3.776595,-6.607918,-1.175982>,
<-0.557271,-0.437579,-0.705673>
}
smooth_triangle {
<-3.776595,-6.607918,-1.175982>,
<-0.557271,-0.437578,-0.705673>,
<-0.983767,-6.949606,-3.169605>,
<-0.557271,-0.437578,-0.705673>,
<-1.146285,-6.458278,-3.345930>,
<-0.557271,-0.437578,-0.705673>
}
smooth_triangle {
<-4.431161,-5.123812,1.768347>,
<-0.026297,0.930292,-0.365875>,
<-3.506853,-4.004862,4.547011>,
<-0.026297,0.930292,-0.365875>,
<-4.000570,-3.931131,4.769968>,
<-0.026297,0.930292,-0.365875>
}
smooth_triangle {
<-4.000570,-3.931131,4.769968>,
<-0.026301,0.930292,-0.365875>,
<-4.971092,-5.106032,1.852368>,
<-0.026301,0.930292,-0.365875>,
<-4.431161,-5.123812,1.768347>,
<-0.026301,0.930292,-0.365875>
}
smooth_triangle {
<-3.363822,-4.478923,4.778760>,
<0.929485,0.108024,-0.352689>,
<-3.506853,-4.004862,4.547011>,
<0.929485,0.108024,-0.352689>,
<-4.431161,-5.123812,1.768347>,
<0.929485,0.108024,-0.352689>
}
smooth_triangle {
<-4.431161,-5.123812,1.768347>,
<0.929484,0.108027,-0.352689>,
<-4.334344,-5.653824,1.861160>,
<0.929484,0.108027,-0.352689>,
<-3.363822,-4.478923,4.778760>,
<0.929484,0.108027,-0.352689>
}
smooth_triangle {
<-4.874275,-5.636038,1.945181>,
<0.026297,-0.930293,0.365875>,
<-3.857538,-4.405195,5.001711>,
<0.026297,-0.930293,0.365875>,
<-3.363822,-4.478923,4.778760>,
<0.026297,-0.930293,0.365875>
}
smooth_triangle {
<-3.363822,-4.478923,4.778760>,
<0.026291,-0.930292,0.365878>,
<-4.334344,-5.653824,1.861160>,
<0.026291,-0.930292,0.365878>,
<-4.874275,-5.636038,1.945181>,
<0.026291,-0.930292,0.365878>
}
smooth_triangle {
<-4.971092,-5.106032,1.852368>,
<-0.929483,-0.108029,0.352690>,
<-4.000570,-3.931131,4.769968>,
<-0.929483,-0.108029,0.352690>,
<-3.857538,-4.405195,5.001711>,
<-0.929483,-0.108029,0.352690>
}
smooth_triangle {
<-3.857538,-4.405195,5.001711>,
<-0.929484,-0.108028,0.352690>,
<-4.874275,-5.636038,1.945181>,
<-0.929484,-0.108028,0.352690>,
<-4.971092,-5.106032,1.852368>,
<-0.929484,-0.108028,0.352690>
}
smooth_triangle {
<-3.506853,-4.004862,4.547011>,
<0.755561,0.655058,-0.005208>,
<-1.719739,-6.078311,3.019142>,
<0.755561,0.655058,-0.005208>,
<-1.500457,-6.327784,3.453394>,
<0.755561,0.655058,-0.005208>
}
smooth_triangle {
<-1.500457,-6.327784,3.453394>,
<0.755561,0.655058,-0.005206>,
<-3.376926,-4.150665,5.057661>,
<0.755561,0.655058,-0.005206>,
<-3.506853,-4.004862,4.547011>,
<0.755561,0.655058,-0.005206>
}
smooth_triangle {
<-2.110997,-6.436508,2.886800>,
<-0.160875,0.491868,-0.855678>,
<-1.719739,-6.078311,3.019142>,
<-0.160875,0.491868,-0.855678>,
<-3.506853,-4.004862,4.547011>,
<-0.160875,0.491868,-0.855678>
}
smooth_triangle {
<-3.506853,-4.004862,4.547011>,
<-0.160883,0.491864,-0.855679>,
<-3.987466,-4.259389,4.491067>,
<-0.160883,0.491864,-0.855679>,
<-2.110997,-6.436508,2.886800>,
<-0.160883,0.491864,-0.855679>
}
smooth_triangle {
<-3.857538,-4.405195,5.001711>,
<-0.755562,-0.655057,0.005204>,
<-1.891712,-6.685988,3.321055>,
<-0.755562,-0.655057,0.005204>,
<-2.110997,-6.436508,2.886800>,
<-0.755562,-0.655057,0.005204>
}
smooth_triangle {
<-2.110997,-6.436508,2.886800>,
<-0.755561,-0.655057,0.005205>,
<-3.987466,-4.259389,4.491067>,
<-0.755561,-0.655057,0.005205>,
<-3.857538,-4.405195,5.001711>,
<-0.755561,-0.655057,0.005205>
}
smooth_triangle {
<-3.376926,-4.150665,5.057661>,
<0.160885,-0.491862,0.855680>,
<-1.500457,-6.327784,3.453394>,
<0.160885,-0.491862,0.855680>,
<-1.891712,-6.685988,3.321055>,
<0.160885,-0.491862,0.855680>
}
smooth_triangle {
<-1.891712,-6.685988,3.321055>,
<0.160877,-0.491866,0.855679>,
<-3.857538,-4.405195,5.001711>,
<0.160877,-0.491866,0.855679>,
<-3.376926,-4.150665,5.057661>,
<0.160877,-0.491866,0.855679>
}
smooth_triangle {
<-1.719739,-6.078311,3.019142>,
<0.489033,0.332395,-0.806449>,
<-4.431161,-5.123812,1.768347>,
<0.489033,0.332395,-0.806449>,
<-4.560045,-5.582935,1.500954>,
<0.489033,0.332395,-0.806449>
}
smooth_triangle {
<-4.560045,-5.582935,1.500954>,
<0.489032,0.332399,-0.806448>,
<-1.713054,-6.585153,2.814287>,
<0.489032,0.332399,-0.806448>,
<-1.719739,-6.078311,3.019142>,
<0.489032,0.332399,-0.806448>
}
smooth_triangle {
<-4.745391,-5.176921,2.212574>,
<0.210818,0.941836,0.261725>,
<-4.431161,-5.123812,1.768347>,
<0.210818,0.941836,0.261725>,
<-1.719739,-6.078311,3.019142>,
<0.210818,0.941836,0.261725>
}
smooth_triangle {
<-1.719739,-6.078311,3.019142>,
<0.210821,0.941838,0.261717>,
<-1.898400,-6.179139,3.525907>,
<0.210821,0.941838,0.261717>,
<-4.745391,-5.176921,2.212574>,
<0.210821,0.941838,0.261717>
}
smooth_triangle {
<-1.891712,-6.685988,3.321055>,
<-0.489033,-0.332399,0.806447>,
<-4.874275,-5.636038,1.945181>,
<-0.489033,-0.332399,0.806447>,
<-4.745391,-5.176921,2.212574>,
<-0.489033,-0.332399,0.806447>
}
smooth_triangle {
<-4.745391,-5.176921,2.212574>,
<-0.489032,-0.332393,0.806451>,
<-1.898400,-6.179139,3.525907>,
<-0.489032,-0.332393,0.806451>,
<-1.891712,-6.685988,3.321055>,
<-0.489032,-0.332393,0.806451>
}
smooth_triangle {
<-1.713054,-6.585153,2.814287>,
<-0.210822,-0.941838,-0.261715>,
<-4.560045,-5.582935,1.500954>,
<-0.210822,-0.941838,-0.261715>,
<-4.874275,-5.636038,1.945181>,
<-0.210822,-0.941838,-0.261715>
}
smooth_triangle {
<-4.874275,-5.636038,1.945181>,
<-0.210818,-0.941836,-0.261726>,
<-1.891712,-6.685988,3.321055>,
<-0.210818,-0.941836,-0.261726>,
<-1.713054,-6.585153,2.814287>,
<-0.210818,-0.941836,-0.261726>
}
smooth_triangle {
<-1.013404,-3.077887,6.205570>,
<-0.122693,0.894459,-0.429989>,
<2.096780,-2.696968,6.110496>,
<-0.122693,0.894459,-0.429989>,
<2.160942,-2.454607,6.596345>,
<-0.122693,0.894459,-0.429989>
}
smooth_triangle {
<2.160942,-2.454607,6.596345>,
<-0.122693,0.894459,-0.429988>,
<-1.104754,-2.854573,6.696172>,
<-0.122693,0.894459,-0.429988>,
<-1.013404,-3.077887,6.205570>,
<-0.122693,0.894459,-0.429988>
}
smooth_triangle {
<2.242296,-3.208871,6.235705>,
<-0.000574,-0.237745,-0.971327>,
<2.096780,-2.696968,6.110496>,
<-0.000574,-0.237745,-0.971327>,
<-1.013404,-3.077887,6.205570>,
<-0.000574,-0.237745,-0.971327>
}
smooth_triangle {
<-1.013404,-3.077887,6.205570>,
<-0.000574,-0.237744,-0.971328>,
<-1.023400,-3.608837,6.335532>,
<-0.000574,-0.237744,-0.971328>,
<2.242296,-3.208871,6.235705>,
<-0.000574,-0.237744,-0.971328>
}
smooth_triangle {
<-1.114745,-3.385523,6.826128>,
<0.122692,-0.894459,0.429988>,
<2.306459,-2.966513,6.721548>,
<0.122692,-0.894459,0.429988>,
<2.242296,-3.208871,6.235705>,
<0.122692,-0.894459,0.429988>
}
smooth_triangle {
<2.242296,-3.208871,6.235705>,
<0.122693,-0.894457,0.429991>,
<-1.023400,-3.608837,6.335532>,
<0.122693,-0.894457,0.429991>,
<-1.114745,-3.385523,6.826128>,
<0.122693,-0.894457,0.429991>
}
smooth_triangle {
<-1.104754,-2.854573,6.696172>,
<0.000576,0.237734,0.971330>,
<2.160942,-2.454607,6.596345>,
<0.000576,0.237734,0.971330>,
<2.306459,-2.966513,6.721548>,
<0.000576,0.237734,0.971330>
}
smooth_triangle {
<2.306459,-2.966513,6.721548>,
<0.000575,0.237733,0.971330>,
<-1.114745,-3.385523,6.826128>,
<0.000575,0.237733,0.971330>,
<-1.104754,-2.854573,6.696172>,
<0.000575,0.237733,0.971330>
}
smooth_triangle {
<2.096780,-2.696968,6.110496>,
<0.392634,0.296558,-0.870570>,
<0.773710,-5.151343,4.677701>,
<0.392634,0.296558,-0.870570>,
<1.182755,-5.508602,4.740484>,
<0.392634,0.296558,-0.870570>
}
smooth_triangle {
<1.182755,-5.508602,4.740484>,
<0.392640,0.296555,-0.870568>,
<2.571982,-2.931510,6.244924>,
<0.392640,0.296555,-0.870568>,
<2.096780,-2.696968,6.110496>,
<0.392640,0.296555,-0.870568>
}
smooth_triangle {
<0.442029,-5.309060,5.082686>,
<-0.719238,0.596075,-0.356918>,
<0.773710,-5.151343,4.677701>,
<-0.719238,0.596075,-0.356918>,
<2.096780,-2.696968,6.110496>,
<-0.719238,0.596075,-0.356918>
}
smooth_triangle {
<2.096780,-2.696968,6.110496>,
<-0.719243,0.596075,-0.356909>,
<1.831256,-2.731968,6.587126>,
<-0.719243,0.596075,-0.356909>,
<0.442029,-5.309060,5.082686>,
<-0.719243,0.596075,-0.356909>
}
smooth_triangle {
<2.306459,-2.966513,6.721548>,
<-0.392633,-0.296560,0.870569>,
<0.851081,-5.666323,5.145470>,
<-0.392633,-0.296560,0.870569>,
<0.442029,-5.309060,5.082686>,
<-0.392633,-0.296560,0.870569>
}
smooth_triangle {
<0.442029,-5.309060,5.082686>,
<-0.392634,-0.296560,0.870569>,
<1.831256,-2.731968,6.587126>,
<-0.392634,-0.296560,0.870569>,
<2.306459,-2.966513,6.721548>,
<-0.392634,-0.296560,0.870569>
}
smooth_triangle {
<2.571982,-2.931510,6.244924>,
<0.719245,-0.596074,0.356906>,
<1.182755,-5.508602,4.740484>,
<0.719245,-0.596074,0.356906>,
<0.851081,-5.666323,5.145470>,
<0.719245,-0.596074,0.356906>
}
smooth_triangle {
<0.851081,-5.666323,5.145470>,
<0.719244,-0.596074,0.356908>,
<2.306459,-2.966513,6.721548>,
<0.719244,-0.596074,0.356908>,
<2.571982,-2.931510,6.244924>,
<0.719244,-0.596074,0.356908>
}
smooth_triangle {
<0.773710,-5.151343,4.677701>,
<-0.504211,0.186715,-0.843154>,
<-1.013404,-3.077887,6.205570>,
<-0.504211,0.186715,-0.843154>,
<-1.409065,-3.419088,6.366619>,
<-0.504211,0.186715,-0.843154>
}
smooth_triangle {
<-1.409065,-3.419088,6.366619>,
<-0.504206,0.186723,-0.843155>,
<0.467404,-5.596214,4.762352>,
<-0.504206,0.186723,-0.843155>,
<0.773710,-5.151343,4.677701>,
<-0.504206,0.186723,-0.843155>
}
smooth_triangle {
<-0.719089,-3.044322,6.665085>,
<0.531487,0.749257,-0.395141>,
<-1.013404,-3.077887,6.205570>,
<0.531487,0.749257,-0.395141>,
<0.773710,-5.151343,4.677701>,
<0.531487,0.749257,-0.395141>
}
smooth_triangle {
<0.773710,-5.151343,4.677701>,
<0.531482,0.749258,-0.395146>,
<1.157380,-5.221448,5.060818>,
<0.531482,0.749258,-0.395146>,
<-0.719089,-3.044322,6.665085>,
<0.531482,0.749258,-0.395146>
}
smooth_triangle {
<0.851081,-5.666323,5.145470>,
<0.504208,-0.186719,0.843155>,
<-1.114745,-3.385523,6.826128>,
<0.504208,-0.186719,0.843155>,
<-0.719089,-3.044322,6.665085>,
<0.504208,-0.186719,0.843155>
}
smooth_triangle {
<-0.719089,-3.044322,6.665085>,
<0.504212,-0.186716,0.843153>,
<1.157380,-5.221448,5.060818>,
<0.504212,-0.186716,0.843153>,
<0.851081,-5.666323,5.145470>,
<0.504212,-0.186716,0.843153>
}
smooth_triangle {
<0.467404,-5.596214,4.762352>,
<-0.531480,-0.749258,0.395148>,
<-1.409065,-3.419088,6.366619>,
<-0.531480,-0.749258,0.395148>,
<-1.114745,-3.385523,6.826128>,
<-0.531480,-0.749258,0.395148>
}
smooth_triangle {
<-1.114745,-3.385523,6.826128>,
<-0.531482,-0.749257,0.395146>,
<0.851081,-5.666323,5.145470>,
<-0.531482,-0.749257,0.395146>,
<0.467404,-5.596214,4.762352>,
<-0.531482,-0.749257,0.395146>
}
smooth_triangle {
<4.204459,-1.875371,-5.273632>,
<-0.814176,-0.335125,0.474141>,
<5.938331,-2.499820,-2.737658>,
<-0.814176,-0.335125,0.474141>,
<6.077260,-3.013690,-2.862300>,
<-0.814176,-0.335125,0.474141>
}
smooth_triangle {
<6.077260,-3.013690,-2.862300>,
<-0.814176,-0.335121,0.474143>,
<4.256693,-2.358021,-5.525072>,
<-0.814176,-0.335121,0.474143>,
<4.204459,-1.875371,-5.273632>,
<-0.814176,-0.335121,0.474143>
}
smooth_triangle {
<6.393240,-2.235780,-2.886786>,
<-0.339867,0.832579,0.437382>,
<5.938331,-2.499820,-2.737658>,
<-0.339867,0.832579,0.437382>,
<4.204459,-1.875371,-5.273632>,
<-0.339867,0.832579,0.437382>
}
smooth_triangle {
<4.204459,-1.875371,-5.273632>,
<-0.339865,0.832580,0.437380>,
<4.572673,-1.580111,-5.549558>,
<-0.339865,0.832580,0.437380>,
<6.393240,-2.235780,-2.886786>,
<-0.339865,0.832580,0.437380>
}
smooth_triangle {
<4.624907,-2.062756,-5.800997>,
<0.814178,0.335113,-0.474144>,
<6.532163,-2.749649,-3.011423>,
<0.814178,0.335113,-0.474144>,
<6.393240,-2.235780,-2.886786>,
<0.814178,0.335113,-0.474144>
}
smooth_triangle {
<6.393240,-2.235780,-2.886786>,
<0.814176,0.335123,-0.474142>,
<4.572673,-1.580111,-5.549558>,
<0.814176,0.335123,-0.474142>,
<4.624907,-2.062756,-5.800997>,
<0.814176,0.335123,-0.474142>
}
smooth_triangle {
<4.256693,-2.358021,-5.525072>,
<0.339874,-0.832575,-0.437385>,
<6.077260,-3.013690,-2.862300>,
<0.339874,-0.832575,-0.437385>,
<6.532163,-2.749649,-3.011423>,
<0.339874,-0.832575,-0.437385>
}
smooth_triangle {
<6.532163,-2.749649,-3.011423>,
<0.339871,-0.832576,-0.437383>,
<4.624907,-2.062756,-5.800997>,
<0.339871,-0.832576,-0.437383>,
<4.256693,-2.358021,-5.525072>,
<0.339871,-0.832576,-0.437383>
}
smooth_triangle {
<5.938331,-2.499820,-2.737658>,
<-0.349495,0.326719,0.878127>,
<5.815929,0.419803,-3.872659>,
<-0.349495,0.326719,0.878127>,
<6.319376,0.579809,-3.731819>,
<-0.349495,0.326719,0.878127>
}
smooth_triangle {
<6.319376,0.579809,-3.731819>,
<-0.349493,0.326719,0.878128>,
<6.447903,-2.485792,-2.540069>,
<-0.349493,0.326719,0.878128>,
<5.938331,-2.499820,-2.737658>,
<-0.349493,0.326719,0.878128>
}
smooth_triangle {
<5.894070,0.301923,-4.400767>,
<-0.987903,-0.090398,-0.125996>,
<5.815929,0.419803,-3.872659>,
<-0.987903,-0.090398,-0.125996>,
<5.938331,-2.499820,-2.737658>,
<-0.987903,-0.090398,-0.125996>
}
smooth_triangle {
<5.938331,-2.499820,-2.737658>,
<-0.987902,-0.090402,-0.126004>,
<6.022597,-2.763678,-3.209017>,
<-0.987902,-0.090402,-0.126004>,
<5.894070,0.301923,-4.400767>,
<-0.987902,-0.090402,-0.126004>
}
smooth_triangle {
<6.532163,-2.749649,-3.011423>,
<0.349503,-0.326717,-0.878125>,
<6.397519,0.461936,-4.259923>,
<0.349503,-0.326717,-0.878125>,
<5.894070,0.301923,-4.400767>,
<0.349503,-0.326717,-0.878125>
}
smooth_triangle {
<5.894070,0.301923,-4.400767>,
<0.349504,-0.326717,-0.878125>,
<6.022597,-2.763678,-3.209017>,
<0.349504,-0.326717,-0.878125>,
<6.532163,-2.749649,-3.011423>,
<0.349504,-0.326717,-0.878125>
}
smooth_triangle {
<6.447903,-2.485792,-2.540069>,
<0.987902,0.090402,0.126002>,
<6.319376,0.579809,-3.731819>,
<0.987902,0.090402,0.126002>,
<6.397519,0.461936,-4.259923>,
<0.987902,0.090402,0.126002>
}
smooth_triangle {
<6.397519,0.461936,-4.259923>,
<0.987903,0.090398,0.125996>,
<6.532163,-2.749649,-3.011423>,
<0.987903,0.090398,0.125996>,
<6.447903,-2.485792,-2.540069>,
<0.987903,0.090398,0.125996>
}
smooth_triangle {
<5.815929,0.419803,-3.872659>,
<-0.849472,0.506784,0.146857>,
<4.204459,-1.875371,-5.273632>,
<-0.849472,0.506784,0.146857>,
<4.228539,-1.686497,-5.786123>,
<-0.849472,0.506784,0.146857>
}
smooth_triangle {
<4.228539,-1.686497,-5.786123>,
<-0.849473,0.506781,0.146861>,
<5.920579,0.723435,-4.315101>,
<-0.849473,0.506781,0.146861>,
<5.815929,0.419803,-3.872659>,
<-0.849473,0.506781,0.146861>
}
smooth_triangle {
<4.600827,-2.251635,-5.288507>,
<-0.290648,-0.341513,0.893808>,
<4.204459,-1.875371,-5.273632>,
<-0.290648,-0.341513,0.893808>,
<5.815929,0.419803,-3.872659>,
<-0.290648,-0.341513,0.893808>
}
smooth_triangle {
<5.815929,0.419803,-3.872659>,
<-0.290650,-0.341511,0.893808>,
<6.292867,0.158297,-3.817485>,
<-0.290650,-0.341511,0.893808>,
<4.600827,-2.251635,-5.288507>,
<-0.290650,-0.341511,0.893808>
}
smooth_triangle {
<6.397519,0.461936,-4.259923>,
<0.849474,-0.506780,-0.146861>,
<4.624907,-2.062756,-5.800997>,
<0.849474,-0.506780,-0.146861>,
<4.600827,-2.251635,-5.288507>,
<0.849474,-0.506780,-0.146861>
}
smooth_triangle {
<4.600827,-2.251635,-5.288507>,
<0.849474,-0.506779,-0.146864>,
<6.292867,0.158297,-3.817485>,
<0.849474,-0.506779,-0.146864>,
<6.397519,0.461936,-4.259923>,
<0.849474,-0.506779,-0.146864>
}
smooth_triangle {
<5.920579,0.723435,-4.315101>,
<0.290646,0.341514,-0.893808>,
<4.228539,-1.686497,-5.786123>,
<0.290646,0.341514,-0.893808>,
<4.624907,-2.062756,-5.800997>,
<0.290646,0.341514,-0.893808>
}
smooth_triangle {
<4.624907,-2.062756,-5.800997>,
<0.290651,0.341512,-0.893807>,
<6.397519,0.461936,-4.259923>,
<0.290651,0.341512,-0.893807>,
<5.920579,0.723435,-4.315101>,
<0.290651,0.341512,-0.893807>
}
smooth_triangle {
<6.862639,-1.380870,0.041006>,
<-0.849910,-0.378376,0.366722>,
<6.624324,1.054073,2.001013>,
<-0.849910,-0.378376,0.366722>,
<6.900488,0.842512,2.422763>,
<-0.849910,-0.378376,0.366722>
}
smooth_triangle {
<6.900488,0.842512,2.422763>,
<-0.849910,-0.378375,0.366721>,
<7.150717,-1.714175,0.364756>,
<-0.849910,-0.378375,0.366721>,
<6.862639,-1.380870,0.041006>,
<-0.849910,-0.378375,0.366721>
}
smooth_triangle {
<7.010598,1.371194,1.779365>,
<-0.684629,0.415212,-0.599067>,
<6.624324,1.054073,2.001013>,
<-0.684629,0.415212,-0.599067>,
<6.862639,-1.380870,0.041006>,
<-0.684629,0.415212,-0.599067>
}
smooth_triangle {
<6.862639,-1.380870,0.041006>,
<-0.684632,0.415211,-0.599065>,
<7.260827,-1.185493,-0.278642>,
<-0.684632,0.415211,-0.599065>,
<7.010598,1.371194,1.779365>,
<-0.684632,0.415211,-0.599065>
}
smooth_triangle {
<7.548903,-1.518804,0.045107>,
<0.849915,0.378371,-0.366715>,
<7.286755,1.159633,2.201114>,
<0.849915,0.378371,-0.366715>,
<7.010598,1.371194,1.779365>,
<0.849915,0.378371,-0.366715>
}
smooth_triangle {
<7.010598,1.371194,1.779365>,
<0.849913,0.378372,-0.366717>,
<7.260827,-1.185493,-0.278642>,
<0.849913,0.378372,-0.366717>,
<7.548903,-1.518804,0.045107>,
<0.849913,0.378372,-0.366717>
}
smooth_triangle {
<7.150717,-1.714175,0.364756>,
<0.684636,-0.415208,0.599062>,
<6.900488,0.842512,2.422763>,
<0.684636,-0.415208,0.599062>,
<7.286755,1.159633,2.201114>,
<0.684636,-0.415208,0.599062>
}
smooth_triangle {
<7.286755,1.159633,2.201114>,
<0.684632,-0.415211,0.599066>,
<7.548903,-1.518804,0.045107>,
<0.684632,-0.415211,0.599066>,
<7.150717,-1.714175,0.364756>,
<0.684632,-0.415211,0.599066>
}
smooth_triangle {
<6.624324,1.054073,2.001013>,
<-0.885207,0.463523,0.039438>,
<6.740230,1.538753,-1.093988>,
<-0.885207,0.463523,0.039438>,
<6.994036,2.022950,-1.088038>,
<-0.885207,0.463523,0.039438>
}
smooth_triangle {
<6.994036,2.022950,-1.088038>,
<-0.885208,0.463522,0.039437>,
<6.872334,1.514036,2.161712>,
<-0.885208,0.463522,0.039437>,
<6.624324,1.054073,2.001013>,
<-0.885208,0.463522,0.039437>
}
smooth_triangle {
<7.160454,1.208584,-1.209334>,
<-0.635409,-0.758888,-0.142638>,
<6.740230,1.538753,-1.093988>,
<-0.635409,-0.758888,-0.142638>,
<6.624324,1.054073,2.001013>,
<-0.635409,-0.758888,-0.142638>
}
smooth_triangle {
<6.624324,1.054073,2.001013>,
<-0.635409,-0.758887,-0.142638>,
<7.038752,0.699670,2.040416>,
<-0.635409,-0.758887,-0.142638>,
<7.160454,1.208584,-1.209334>,
<-0.635409,-0.758887,-0.142638>
}
smooth_triangle {
<7.286755,1.159633,2.201114>,
<0.885211,-0.463515,-0.039436>,
<7.414255,1.692781,-1.203387>,
<0.885211,-0.463515,-0.039436>,
<7.160454,1.208584,-1.209334>,
<0.885211,-0.463515,-0.039436>
}
smooth_triangle {
<7.160454,1.208584,-1.209334>,
<0.885212,-0.463512,-0.039436>,
<7.038752,0.699670,2.040416>,
<0.885212,-0.463512,-0.039436>,
<7.286755,1.159633,2.201114>,
<0.885212,-0.463512,-0.039436>
}
smooth_triangle {
<6.872334,1.514036,2.161712>,
<0.635413,0.758884,0.142638>,
<6.994036,2.022950,-1.088038>,
<0.635413,0.758884,0.142638>,
<7.414255,1.692781,-1.203387>,
<0.635413,0.758884,0.142638>
}
smooth_triangle {
<7.414255,1.692781,-1.203387>,
<0.635416,0.758882,0.142638>,
<7.286755,1.159633,2.201114>,
<0.635416,0.758882,0.142638>,
<6.872334,1.514036,2.161712>,
<0.635416,0.758882,0.142638>
}
smooth_triangle {
<6.740230,1.538753,-1.093988>,
<-0.816484,-0.238617,-0.525752>,
<6.862639,-1.380870,0.041006>,
<-0.816484,-0.238617,-0.525752>,
<7.177380,-1.602700,-0.347102>,
<-0.816484,-0.238617,-0.525752>
}
smooth_triangle {
<7.177380,-1.602700,-0.347102>,
<-0.816483,-0.238617,-0.525755>,
<7.048853,1.462901,-1.538845>,
<-0.816483,-0.238617,-0.525755>,
<6.740230,1.538753,-1.093988>,
<-0.816483,-0.238617,-0.525755>
}
smooth_triangle {
<7.234164,-1.296968,0.433216>,
<-0.731249,0.220299,0.645556>,
<6.862639,-1.380870,0.041006>,
<-0.731249,0.220299,0.645556>,
<6.740230,1.538753,-1.093988>,
<-0.731249,0.220299,0.645556>
}
smooth_triangle {
<6.740230,1.538753,-1.093988>,
<-0.731246,0.220301,0.645559>,
<7.105637,1.768633,-0.758527>,
<-0.731246,0.220301,0.645559>,
<7.234164,-1.296968,0.433216>,
<-0.731246,0.220301,0.645559>
}
smooth_triangle {
<7.414255,1.692781,-1.203387>,
<0.816488,0.238615,0.525747>,
<7.548903,-1.518804,0.045107>,
<0.816488,0.238615,0.525747>,
<7.234164,-1.296968,0.433216>,
<0.816488,0.238615,0.525747>
}
smooth_triangle {
<7.234164,-1.296968,0.433216>,
<0.816488,0.238614,0.525747>,
<7.105637,1.768633,-0.758527>,
<0.816488,0.238614,0.525747>,
<7.414255,1.692781,-1.203387>,
<0.816488,0.238614,0.525747>
}
smooth_triangle {
<7.048853,1.462901,-1.538845>,
<0.731247,-0.220301,-0.645558>,
<7.177380,-1.602700,-0.347102>,
<0.731247,-0.220301,-0.645558>,
<7.548903,-1.518804,0.045107>,
<0.731247,-0.220301,-0.645558>
}
smooth_triangle {
<7.548903,-1.518804,0.045107>,
<0.731249,-0.220300,-0.645557>,
<7.414255,1.692781,-1.203387>,
<0.731249,-0.220300,-0.645557>,
<7.048853,1.462901,-1.538845>,
<0.731249,-0.220300,-0.645557>
}
smooth_triangle {
<2.215850,-5.937044,-2.976526>,
<-0.854388,0.496747,0.152526>,
<2.388337,-6.580918,0.086653>,
<-0.854388,0.496747,0.152526>,
<2.113069,-7.053271,0.083076>,
<-0.854388,0.496747,0.152526>
}
smooth_triangle {
<2.113069,-7.053271,0.083076>,
<-0.854388,0.496746,0.152525>,
<1.931958,-6.377204,-3.133263>,
<-0.854388,0.496746,0.152525>,
<2.215850,-5.937044,-2.976526>,
<-0.854388,0.496746,0.152525>
}
smooth_triangle {
<2.902445,-6.766509,0.098896>,
<0.330515,0.927192,0.176283>,
<2.388337,-6.580918,0.086653>,
<0.330515,0.927192,0.176283>,
<2.215850,-5.937044,-2.976526>,
<0.330515,0.927192,0.176283>
}
smooth_triangle {
<2.215850,-5.937044,-2.976526>,
<0.330516,0.927191,0.176282>,
<2.721334,-6.090442,-3.117443>,
<0.330516,0.927191,0.176282>,
<2.902445,-6.766509,0.098896>,
<0.330516,0.927191,0.176282>
}
smooth_triangle {
<2.437436,-6.530598,-3.274180>,
<0.854383,-0.496755,-0.152527>,
<2.627172,-7.238860,0.095318>,
<0.854383,-0.496755,-0.152527>,
<2.902445,-6.766509,0.098896>,
<0.854383,-0.496755,-0.152527>
}
smooth_triangle {
<2.902445,-6.766509,0.098896>,
<0.854381,-0.496758,-0.152527>,
<2.721334,-6.090442,-3.117443>,
<0.854381,-0.496758,-0.152527>,
<2.437436,-6.530598,-3.274180>,
<0.854381,-0.496758,-0.152527>
}
smooth_triangle {
<1.931958,-6.377204,-3.133263>,
<-0.330515,-0.927192,-0.176282>,
<2.113069,-7.053271,0.083076>,
<-0.330515,-0.927192,-0.176282>,
<2.627172,-7.238860,0.095318>,
<-0.330515,-0.927192,-0.176282>
}
smooth_triangle {
<2.627172,-7.238860,0.095318>,
<-0.330512,-0.927192,-0.176283>,
<2.437436,-6.530598,-3.274180>,
<-0.330512,-0.927192,-0.176283>,
<1.931958,-6.377204,-3.133263>,
<-0.330512,-0.927192,-0.176283>
}
smooth_triangle {
<2.388337,-6.580918,0.086653>,
<-0.135379,0.764060,0.630782>,
<4.709299,-5.010069,-1.317974>,
<-0.135379,0.764060,0.630782>,
<5.123580,-5.190662,-1.010310>,
<-0.135379,0.764060,0.630782>
}
smooth_triangle {
<5.123580,-5.190662,-1.010310>,
<-0.135375,0.764056,0.630787>,
<2.686572,-6.840058,0.464548>,
<-0.135375,0.764056,0.630787>,
<2.388337,-6.580918,0.086653>,
<-0.135375,0.764056,0.630787>
}
smooth_triangle {
<4.765950,-5.330326,-1.757434>,
<-0.672195,0.554419,-0.490686>,
<4.709299,-5.010069,-1.317974>,
<-0.672195,0.554419,-0.490686>,
<2.388337,-6.580918,0.086653>,
<-0.672195,0.554419,-0.490686>
}
smooth_triangle {
<2.388337,-6.580918,0.086653>,
<-0.672196,0.554414,-0.490691>,
<2.328942,-6.979722,-0.282576>,
<-0.672196,0.554414,-0.490691>,
<4.765950,-5.330326,-1.757434>,
<-0.672196,0.554414,-0.490691>
}
smooth_triangle {
<2.627172,-7.238860,0.095318>,
<0.135371,-0.764055,-0.630789>,
<5.180231,-5.510926,-1.449772>,
<0.135371,-0.764055,-0.630789>,
<4.765950,-5.330326,-1.757434>,
<0.135371,-0.764055,-0.630789>
}
smooth_triangle {
<4.765950,-5.330326,-1.757434>,
<0.135377,-0.764057,-0.630785>,
<2.328942,-6.979722,-0.282576>,
<0.135377,-0.764057,-0.630785>,
<2.627172,-7.238860,0.095318>,
<0.135377,-0.764057,-0.630785>
}
smooth_triangle {
<2.686572,-6.840058,0.464548>,
<0.672196,-0.554415,0.490690>,
<5.123580,-5.190662,-1.010310>,
<0.672196,-0.554415,0.490690>,
<5.180231,-5.510926,-1.449772>,
<0.672196,-0.554415,0.490690>
}
smooth_triangle {
<5.180231,-5.510926,-1.449772>,
<0.672195,-0.554420,0.490685>,
<2.627172,-7.238860,0.095318>,
<0.672195,-0.554420,0.490685>,
<2.686572,-6.840058,0.464548>,
<0.672195,-0.554420,0.490685>
}
smooth_triangle {
<4.709299,-5.010069,-1.317974>,
<-0.185112,0.949722,-0.252510>,
<2.215850,-5.937044,-2.976526>,
<-0.185112,0.949722,-0.252510>,
<2.465785,-6.015899,-3.456334>,
<-0.185112,0.949722,-0.252510>
}
smooth_triangle {
<2.465785,-6.015899,-3.456334>,
<-0.185119,0.949723,-0.252503>,
<5.083904,-5.042570,-1.714853>,
<-0.185119,0.949723,-0.252503>,
<4.709299,-5.010069,-1.317974>,
<-0.185119,0.949723,-0.252503>
}
smooth_triangle {
<2.187507,-6.451747,-2.794372>,
<-0.602829,0.295485,0.741138>,
<2.215850,-5.937044,-2.976526>,
<-0.602829,0.295485,0.741138>,
<4.709299,-5.010069,-1.317974>,
<-0.602829,0.295485,0.741138>
}
smooth_triangle {
<4.709299,-5.010069,-1.317974>,
<-0.602830,0.295492,0.741134>,
<4.805626,-5.478418,-1.052891>,
<-0.602830,0.295492,0.741134>,
<2.187507,-6.451747,-2.794372>,
<-0.602830,0.295492,0.741134>
}
smooth_triangle {
<5.180231,-5.510926,-1.449772>,
<0.185117,-0.949723,0.252502>,
<2.437436,-6.530598,-3.274180>,
<0.185117,-0.949723,0.252502>,
<2.187507,-6.451747,-2.794372>,
<0.185117,-0.949723,0.252502>
}
smooth_triangle {
<2.187507,-6.451747,-2.794372>,
<0.185112,-0.949722,0.252512>,
<4.805626,-5.478418,-1.052891>,
<0.185112,-0.949722,0.252512>,
<5.180231,-5.510926,-1.449772>,
<0.185112,-0.949722,0.252512>
}
smooth_triangle {
<5.083904,-5.042570,-1.714853>,
<0.602831,-0.295494,-0.741133>,
<2.465785,-6.015899,-3.456334>,
<0.602831,-0.295494,-0.741133>,
<2.437436,-6.530598,-3.274180>,
<0.602831,-0.295494,-0.741133>
}
smooth_triangle {
<2.437436,-6.530598,-3.274180>,
<0.602829,-0.295486,-0.741138>,
<5.180231,-5.510926,-1.449772>,
<0.602829,-0.295486,-0.741138>,
<5.083904,-5.042570,-1.714853>,
<0.602829,-0.295486,-0.741138>
}
smooth_triangle {
<3.312645,-5.461968,2.865317>,
<-0.890114,0.453500,0.045099>,
<4.635708,-3.007593,4.298119>,
<-0.890114,0.453500,0.045099>,
<4.575739,-3.176657,4.814572>,
<-0.890114,0.453500,0.045099>
}
smooth_triangle {
<4.575739,-3.176657,4.814572>,
<-0.890115,0.453498,0.045101>,
<3.186526,-5.753749,3.310132>,
<-0.890115,0.453498,0.045101>,
<3.312645,-5.461968,2.865317>,
<-0.890115,0.453498,0.045101>
}
smooth_triangle {
<5.159245,-3.139137,4.211480>,
<-0.014248,0.509822,-0.860162>,
<4.635708,-3.007593,4.298119>,
<-0.014248,0.509822,-0.860162>,
<3.312645,-5.461968,2.865317>,
<-0.014248,0.509822,-0.860162>
}
smooth_triangle {
<3.312645,-5.461968,2.865317>,
<-0.014247,0.509821,-0.860163>,
<3.770032,-5.716229,2.707040>,
<-0.014247,0.509821,-0.860163>,
<5.159245,-3.139137,4.211480>,
<-0.014247,0.509821,-0.860163>
}
smooth_triangle {
<3.643910,-6.008013,3.151849>,
<0.890116,-0.453497,-0.045106>,
<5.099281,-3.308201,4.727933>,
<0.890116,-0.453497,-0.045106>,
<5.159245,-3.139137,4.211480>,
<0.890116,-0.453497,-0.045106>
}
smooth_triangle {
<5.159245,-3.139137,4.211480>,
<0.890115,-0.453499,-0.045100>,
<3.770032,-5.716229,2.707040>,
<0.890115,-0.453499,-0.045100>,
<3.643910,-6.008013,3.151849>,
<0.890115,-0.453499,-0.045100>
}
smooth_triangle {
<3.186526,-5.753749,3.310132>,
<0.014249,-0.509821,0.860162>,
<4.575739,-3.176657,4.814572>,
<0.014249,-0.509821,0.860162>,
<5.099281,-3.308201,4.727933>,
<0.014249,-0.509821,0.860162>
}
smooth_triangle {
<5.099281,-3.308201,4.727933>,
<0.014253,-0.509824,0.860161>,
<3.643910,-6.008013,3.151849>,
<0.014253,-0.509824,0.860161>,
<3.186526,-5.753749,3.310132>,
<0.014253,-0.509824,0.860161>
}
smooth_triangle {
<4.635708,-3.007593,4.298119>,
<-0.220841,0.906467,-0.359927>,
<5.633607,-3.891119,1.460697>,
<-0.220841,0.906467,-0.359927>,
<6.157368,-3.743062,1.512210>,
<-0.220841,0.906467,-0.359927>
}
smooth_triangle {
<6.157368,-3.743062,1.512210>,
<-0.220843,0.906466,-0.359928>,
<5.109573,-2.815359,4.491501>,
<-0.220843,0.906466,-0.359928>,
<4.635708,-3.007593,4.298119>,
<-0.220843,0.906466,-0.359928>
}
smooth_triangle {
<5.673206,-4.428138,1.555260>,
<-0.947596,-0.121875,-0.295312>,
<5.633607,-3.891119,1.460697>,
<-0.947596,-0.121875,-0.295312>,
<4.635708,-3.007593,4.298119>,
<-0.947596,-0.121875,-0.295312>
}
smooth_triangle {
<4.635708,-3.007593,4.298119>,
<-0.947595,-0.121873,-0.295313>,
<4.625411,-3.500435,4.534551>,
<-0.947595,-0.121873,-0.295313>,
<5.673206,-4.428138,1.555260>,
<-0.947595,-0.121873,-0.295313>
}
smooth_triangle {
<5.099281,-3.308201,4.727933>,
<0.220849,-0.906464,0.359928>,
<6.196968,-4.280078,1.606767>,
<0.220849,-0.906464,0.359928>,
<5.673206,-4.428138,1.555260>,
<0.220849,-0.906464,0.359928>
}
smooth_triangle {
<5.673206,-4.428138,1.555260>,
<0.220842,-0.906466,0.359927>,
<4.625411,-3.500435,4.534551>,
<0.220842,-0.906466,0.359927>,
<5.099281,-3.308201,4.727933>,
<0.220842,-0.906466,0.359927>
}
smooth_triangle {
<5.109573,-2.815359,4.491501>,
<0.947595,0.121874,0.295313>,
<6.157368,-3.743062,1.512210>,
<0.947595,0.121874,0.295313>,
<6.196968,-4.280078,1.606767>,
<0.947595,0.121874,0.295313>
}
smooth_triangle {
<6.196968,-4.280078,1.606767>,
<0.947596,0.121881,0.295310>,
<5.099281,-3.308201,4.727933>,
<0.947596,0.121881,0.295310>,
<5.109573,-2.815359,4.491501>,
<0.947596,0.121881,0.295310>
}
smooth_triangle {
<5.633607,-3.891119,1.460697>,
<-0.602363,0.198724,-0.773089>,
<3.312645,-5.461968,2.865317>,
<-0.602363,0.198724,-0.773089>,
<3.416049,-5.956966,2.657508>,
<-0.602363,0.198724,-0.773089>
}
smooth_triangle {
<3.416049,-5.956966,2.657508>,
<-0.602364,0.198725,-0.773089>,
<5.853057,-4.307577,1.182657>,
<-0.602364,0.198725,-0.773089>,
<5.633607,-3.891119,1.460697>,
<-0.602364,0.198725,-0.773089>
}
smooth_triangle {
<3.540509,-5.513012,3.359664>,
<-0.415544,0.865122,0.280869>,
<3.312645,-5.461968,2.865317>,
<-0.415544,0.865122,0.280869>,
<5.633607,-3.891119,1.460697>,
<-0.415544,0.865122,0.280869>
}
smooth_triangle {
<5.633607,-3.891119,1.460697>,
<-0.415542,0.865122,0.280871>,
<5.977517,-3.863623,1.884813>,
<-0.415542,0.865122,0.280871>,
<3.540509,-5.513012,3.359664>,
<-0.415542,0.865122,0.280871>
}
smooth_triangle {
<6.196968,-4.280078,1.606767>,
<0.602367,-0.198733,0.773084>,
<3.643910,-6.008013,3.151849>,
<0.602367,-0.198733,0.773084>,
<3.540509,-5.513012,3.359664>,
<0.602367,-0.198733,0.773084>
}
smooth_triangle {
<3.540509,-5.513012,3.359664>,
<0.602367,-0.198733,0.773084>,
<5.977517,-3.863623,1.884813>,
<0.602367,-0.198733,0.773084>,
<6.196968,-4.280078,1.606767>,
<0.602367,-0.198733,0.773084>
}
smooth_triangle {
<5.853057,-4.307577,1.182657>,
<0.415541,-0.865122,-0.280874>,
<3.416049,-5.956966,2.657508>,
<0.415541,-0.865122,-0.280874>,
<3.643910,-6.008013,3.151849>,
<0.415541,-0.865122,-0.280874>
}
smooth_triangle {
<3.643910,-6.008013,3.151849>,
<0.415543,-0.865122,-0.280871>,
<6.196968,-4.280078,1.606767>,
<0.415543,-0.865122,-0.280871>,
<5.853057,-4.307577,1.182657>,
<0.415543,-0.865122,-0.280871>
}
smooth_triangle {
<2.323307,0.253952,-6.598256>,
<0.100937,-0.569021,0.816104>,
<3.934777,2.549126,-5.197276>,
<0.100937,-0.569021,0.816104>,
<4.435949,2.403925,-5.360502>,
<0.100937,-0.569021,0.816104>
}
smooth_triangle {
<4.435949,2.403925,-5.360502>,
<0.100938,-0.569022,0.816104>,
<2.743902,-0.006007,-6.831531>,
<0.100938,-0.569022,0.816104>,
<2.323307,0.253952,-6.598256>,
<0.100938,-0.569022,0.816104>
}
smooth_triangle {
<3.827089,2.949393,-5.553772>,
<-0.812994,0.249745,0.525993>,
<3.934777,2.549126,-5.197276>,
<-0.812994,0.249745,0.525993>,
<2.323307,0.253952,-6.598256>,
<-0.812994,0.249745,0.525993>
}
smooth_triangle {
<2.323307,0.253952,-6.598256>,
<-0.812992,0.249743,0.525997>,
<2.135042,0.539461,-7.024801>,
<-0.812992,0.249743,0.525997>,
<3.827089,2.949393,-5.553772>,
<-0.812992,0.249743,0.525997>
}
smooth_triangle {
<2.555638,0.279500,-7.258081>,
<-0.100947,0.569025,-0.816100>,
<4.328256,2.804192,-5.717005>,
<-0.100947,0.569025,-0.816100>,
<3.827089,2.949393,-5.553772>,
<-0.100947,0.569025,-0.816100>
}
smooth_triangle {
<3.827089,2.949393,-5.553772>,
<-0.100943,0.569024,-0.816102>,
<2.135042,0.539461,-7.024801>,
<-0.100943,0.569024,-0.816102>,
<2.555638,0.279500,-7.258081>,
<-0.100943,0.569024,-0.816102>
}
smooth_triangle {
<2.743902,-0.006007,-6.831531>,
<0.812993,-0.249745,-0.525995>,
<4.435949,2.403925,-5.360502>,
<0.812993,-0.249745,-0.525995>,
<4.328256,2.804192,-5.717005>,
<0.812993,-0.249745,-0.525995>
}
smooth_triangle {
<4.328256,2.804192,-5.717005>,
<0.812994,-0.249746,-0.525993>,
<2.555638,0.279500,-7.258081>,
<0.812994,-0.249746,-0.525993>,
<2.743902,-0.006007,-6.831531>,
<0.812994,-0.249746,-0.525993>
}
smooth_triangle {
<3.934777,2.549126,-5.197276>,
<-0.276773,0.244401,0.929336>,
<1.013411,3.074826,-6.205563>,
<-0.276773,0.244401,0.929336>,
<1.067234,3.604726,-6.328889>,
<-0.276773,0.244401,0.929336>
}
smooth_triangle {
<1.067234,3.604726,-6.328889>,
<-0.276777,0.244391,0.929337>,
<4.134669,3.052741,-5.270181>,
<-0.276777,0.244391,0.929337>,
<3.934777,2.549126,-5.197276>,
<-0.276777,0.244391,0.929337>
}
smooth_triangle {
<1.060934,2.852562,-6.702801>,
<-0.286230,-0.884642,0.368076>,
<1.013411,3.074826,-6.205563>,
<-0.286230,-0.884642,0.368076>,
<3.934777,2.549126,-5.197276>,
<-0.286230,-0.884642,0.368076>
}
smooth_triangle {
<3.934777,2.549126,-5.197276>,
<-0.286232,-0.884640,0.368080>,
<4.128369,2.300577,-5.644093>,
<-0.286232,-0.884640,0.368080>,
<1.060934,2.852562,-6.702801>,
<-0.286232,-0.884640,0.368080>
}
smooth_triangle {
<4.328256,2.804192,-5.717005>,
<0.276776,-0.244390,-0.929338>,
<1.114753,3.382463,-6.826122>,
<0.276776,-0.244390,-0.929338>,
<1.060934,2.852562,-6.702801>,
<0.276776,-0.244390,-0.929338>
}
smooth_triangle {
<1.060934,2.852562,-6.702801>,
<0.276775,-0.244400,-0.929335>,
<4.128369,2.300577,-5.644093>,
<0.276775,-0.244400,-0.929335>,
<4.328256,2.804192,-5.717005>,
<0.276775,-0.244400,-0.929335>
}
smooth_triangle {
<4.134669,3.052741,-5.270181>,
<0.286232,0.884640,-0.368081>,
<1.067234,3.604726,-6.328889>,
<0.286232,0.884640,-0.368081>,
<1.114753,3.382463,-6.826122>,
<0.286232,0.884640,-0.368081>
}
smooth_triangle {
<1.114753,3.382463,-6.826122>,
<0.286231,0.884641,-0.368079>,
<4.328256,2.804192,-5.717005>,
<0.286231,0.884641,-0.368079>,
<4.134669,3.052741,-5.270181>,
<0.286231,0.884641,-0.368079>
}
smooth_triangle {
<1.013411,3.074826,-6.205563>,
<-0.741451,-0.417434,0.525356>,
<2.323307,0.253952,-6.598256>,
<-0.741451,-0.417434,0.525356>,
<2.071979,0.114911,-7.063441>,
<-0.741451,-0.417434,0.525356>
}
smooth_triangle {
<2.071979,0.114911,-7.063441>,
<-0.741457,-0.417433,0.525348>,
<0.696591,3.076828,-6.651120>,
<-0.741457,-0.417433,0.525348>,
<1.013411,3.074826,-6.205563>,
<-0.741457,-0.417433,0.525348>
}
smooth_triangle {
<2.806965,0.418543,-6.792891>,
<0.361798,0.038335,0.931468>,
<2.323307,0.253952,-6.598256>,
<0.361798,0.038335,0.931468>,
<1.013411,3.074826,-6.205563>,
<0.361798,0.038335,0.931468>
}
smooth_triangle {
<1.013411,3.074826,-6.205563>,
<0.361806,0.038340,0.931465>,
<1.431577,3.380460,-6.380570>,
<0.361806,0.038340,0.931465>,
<2.806965,0.418543,-6.792891>,
<0.361806,0.038340,0.931465>
}
smooth_triangle {
<1.114753,3.382463,-6.826122>,
<0.741454,0.417433,-0.525353>,
<2.555638,0.279500,-7.258081>,
<0.741454,0.417433,-0.525353>,
<2.806965,0.418543,-6.792891>,
<0.741454,0.417433,-0.525353>
}
smooth_triangle {
<2.806965,0.418543,-6.792891>,
<0.741451,0.417432,-0.525357>,
<1.431577,3.380460,-6.380570>,
<0.741451,0.417432,-0.525357>,
<1.114753,3.382463,-6.826122>,
<0.741451,0.417432,-0.525357>
}
smooth_triangle {
<0.696591,3.076828,-6.651120>,
<-0.361805,-0.038340,-0.931465>,
<2.071979,0.114911,-7.063441>,
<-0.361805,-0.038340,-0.931465>,
<2.555638,0.279500,-7.258081>,
<-0.361805,-0.038340,-0.931465>
}
smooth_triangle {
<2.555638,0.279500,-7.258081>,
<-0.361801,-0.038337,-0.931467>,
<1.114753,3.382463,-6.826122>,
<-0.361801,-0.038337,-0.931467>,
<0.696591,3.076828,-6.651120>,
<-0.361801,-0.038337,-0.931467>
}
smooth_triangle {
<3.696462,4.984076,-3.237269>,
<0.110163,-0.663159,0.740327>,
<1.699404,6.628719,-1.466885>,
<0.110163,-0.663159,0.740327>,
<2.062270,6.958678,-1.225315>,
<0.110163,-0.663159,0.740327>
}
smooth_triangle {
<2.062270,6.958678,-1.225315>,
<0.110163,-0.663160,0.740327>,
<4.159176,5.231806,-3.084214>,
<0.110163,-0.663160,0.740327>,
<3.696462,4.984076,-3.237269>,
<0.110163,-0.663160,0.740327>
}
smooth_triangle {
<1.506484,6.961786,-1.855147>,
<-0.724102,-0.658494,-0.205090>,
<1.699404,6.628719,-1.466885>,
<-0.724102,-0.658494,-0.205090>,
<3.696462,4.984076,-3.237269>,
<-0.724102,-0.658494,-0.205090>
}
smooth_triangle {
<3.696462,4.984076,-3.237269>,
<-0.724102,-0.658494,-0.205089>,
<3.603390,5.234914,-3.714046>,
<-0.724102,-0.658494,-0.205089>,
<1.506484,6.961786,-1.855147>,
<-0.724102,-0.658494,-0.205089>
}
smooth_triangle {
<4.066109,5.482637,-3.560997>,
<-0.110161,0.663161,-0.740326>,
<1.869345,7.291745,-1.613574>,
<-0.110161,0.663161,-0.740326>,
<1.506484,6.961786,-1.855147>,
<-0.110161,0.663161,-0.740326>
}
smooth_triangle {
<1.506484,6.961786,-1.855147>,
<-0.110162,0.663160,-0.740326>,
<3.603390,5.234914,-3.714046>,
<-0.110162,0.663160,-0.740326>,
<4.066109,5.482637,-3.560997>,
<-0.110162,0.663160,-0.740326>
}
smooth_triangle {
<4.159176,5.231806,-3.084214>,
<0.724101,0.658496,0.205086>,
<2.062270,6.958678,-1.225315>,
<0.724101,0.658496,0.205086>,
<1.869345,7.291745,-1.613574>,
<0.724101,0.658496,0.205086>
}
smooth_triangle {
<1.869345,7.291745,-1.613574>,
<0.724101,0.658496,0.205086>,
<4.066109,5.482637,-3.560997>,
<0.724101,0.658496,0.205086>,
<4.159176,5.231806,-3.084214>,
<0.724101,0.658496,0.205086>
}
smooth_triangle {
<1.699404,6.628719,-1.466885>,
<-0.732234,-0.511577,0.449580>,
<0.775096,5.509776,-4.245556>,
<-0.732234,-0.511577,0.449580>,
<0.419811,5.904702,-4.374825>,
<-0.732234,-0.511577,0.449580>
}
smooth_triangle {
<0.419811,5.904702,-4.374825>,
<-0.732239,-0.511570,0.449580>,
<1.390340,7.079589,-1.457225>,
<-0.732239,-0.511570,0.449580>,
<1.699404,6.628719,-1.466885>,
<-0.732239,-0.511570,0.449580>
}
smooth_triangle {
<1.207885,5.665988,-4.540837>,
<0.450696,-0.869898,0.200378>,
<0.775096,5.509776,-4.245556>,
<0.450696,-0.869898,0.200378>,
<1.699404,6.628719,-1.466885>,
<0.450696,-0.869898,0.200378>
}
smooth_triangle {
<1.699404,6.628719,-1.466885>,
<0.450689,-0.869901,0.200380>,
<2.178414,6.840875,-1.623237>,
<0.450689,-0.869901,0.200380>,
<1.207885,5.665988,-4.540837>,
<0.450689,-0.869901,0.200380>
}
smooth_triangle {
<1.869345,7.291745,-1.613574>,
<0.732238,0.511571,-0.449579>,
<0.852606,6.060908,-4.670113>,
<0.732238,0.511571,-0.449579>,
<1.207885,5.665988,-4.540837>,
<0.732238,0.511571,-0.449579>
}
smooth_triangle {
<1.207885,5.665988,-4.540837>,
<0.732233,0.511577,-0.449581>,
<2.178414,6.840875,-1.623237>,
<0.732233,0.511577,-0.449581>,
<1.869345,7.291745,-1.613574>,
<0.732233,0.511577,-0.449581>
}
smooth_triangle {
<1.390340,7.079589,-1.457225>,
<-0.450685,0.869903,-0.200382>,
<0.419811,5.904702,-4.374825>,
<-0.450685,0.869903,-0.200382>,
<0.852606,6.060908,-4.670113>,
<-0.450685,0.869903,-0.200382>
}
smooth_triangle {
<0.852606,6.060908,-4.670113>,
<-0.450692,0.869899,-0.200380>,
<1.869345,7.291745,-1.613574>,
<-0.450692,0.869899,-0.200380>,
<1.390340,7.079589,-1.457225>,
<-0.450692,0.869899,-0.200380>
}
smooth_triangle {
<0.775096,5.509776,-4.245556>,
<-0.156369,-0.985818,-0.060930>,
<3.696462,4.984076,-3.237269>,
<-0.156369,-0.985818,-0.060930>,
<3.946579,4.974444,-3.723321>,
<-0.156369,-0.985818,-0.060930>
}
smooth_triangle {
<3.946579,4.974444,-3.723321>,
<-0.156369,-0.985818,-0.060930>,
<0.879144,5.526429,-4.782022>,
<-0.156369,-0.985818,-0.060930>,
<0.775096,5.509776,-4.245556>,
<-0.156369,-0.985818,-0.060930>
}
smooth_triangle {
<3.815987,5.492276,-3.074939>,
<-0.352405,-0.208531,0.912319>,
<3.696462,4.984076,-3.237269>,
<-0.352405,-0.208531,0.912319>,
<0.775096,5.509776,-4.245556>,
<-0.352405,-0.208531,0.912319>
}
smooth_triangle {
<0.775096,5.509776,-4.245556>,
<-0.352405,-0.208532,0.912319>,
<0.748552,6.044261,-4.133640>,
<-0.352405,-0.208532,0.912319>,
<3.815987,5.492276,-3.074939>,
<-0.352405,-0.208532,0.912319>
}
smooth_triangle {
<0.852606,6.060908,-4.670113>,
<0.156372,0.985818,0.060919>,
<4.066109,5.482637,-3.560997>,
<0.156372,0.985818,0.060919>,
<3.815987,5.492276,-3.074939>,
<0.156372,0.985818,0.060919>
}
smooth_triangle {
<3.815987,5.492276,-3.074939>,
<0.156372,0.985818,0.060919>,
<0.748552,6.044261,-4.133640>,
<0.156372,0.985818,0.060919>,
<0.852606,6.060908,-4.670113>,
<0.156372,0.985818,0.060919>
}
smooth_triangle {
<0.879144,5.526429,-4.782022>,
<0.352404,0.208521,-0.912321>,
<3.946579,4.974444,-3.723321>,
<0.352404,0.208521,-0.912321>,
<4.066109,5.482637,-3.560997>,
<0.352404,0.208521,-0.912321>
}
smooth_triangle {
<4.066109,5.482637,-3.560997>,
<0.352404,0.208520,-0.912322>,
<0.852606,6.060908,-4.670113>,
<0.352404,0.208520,-0.912322>,
<0.879144,5.526429,-4.782022>,
<0.352404,0.208520,-0.912322>
}
smooth_triangle {
<5.430334,4.359627,-0.701295>,
<-0.223406,-0.961676,-0.158964>,
<5.314421,3.874954,2.393706>,
<-0.223406,-0.961676,-0.158964>,
<5.838539,3.740316,2.471630>,
<-0.223406,-0.961676,-0.158964>
}
smooth_triangle {
<5.838539,3.740316,2.471630>,
<-0.223405,-0.961676,-0.158964>,
<5.960248,4.249223,-0.778120>,
<-0.223405,-0.961676,-0.158964>,
<5.430334,4.359627,-0.701295>,
<-0.223405,-0.961676,-0.158964>
}
smooth_triangle {
<5.321743,4.397238,2.555154>,
<-0.999138,0.024393,-0.033599>,
<5.314421,3.874954,2.393706>,
<-0.999138,0.024393,-0.033599>,
<5.430334,4.359627,-0.701295>,
<-0.999138,0.024393,-0.033599>
}
smooth_triangle {
<5.430334,4.359627,-0.701295>,
<-0.999138,0.024394,-0.033599>,
<5.443452,4.906145,-0.694596>,
<-0.999138,0.024394,-0.033599>,
<5.321743,4.397238,2.555154>,
<-0.999138,0.024394,-0.033599>
}
smooth_triangle {
<5.973367,4.795742,-0.771424>,
<0.223402,0.961677,0.158964>,
<5.845863,4.262602,2.633076>,
<0.223402,0.961677,0.158964>,
<5.321743,4.397238,2.555154>,
<0.223402,0.961677,0.158964>
}
smooth_triangle {
<5.321743,4.397238,2.555154>,
<0.223403,0.961676,0.158964>,
<5.443452,4.906145,-0.694596>,
<0.223403,0.961676,0.158964>,
<5.973367,4.795742,-0.771424>,
<0.223403,0.961676,0.158964>
}
smooth_triangle {
<5.960248,4.249223,-0.778120>,
<0.999138,-0.024397,0.033599>,
<5.838539,3.740316,2.471630>,
<0.999138,-0.024397,0.033599>,
<5.845863,4.262602,2.633076>,
<0.999138,-0.024397,0.033599>
}
smooth_triangle {
<5.845863,4.262602,2.633076>,
<0.999138,-0.024396,0.033599>,
<5.973367,4.795742,-0.771424>,
<0.999138,-0.024396,0.033599>,
<5.960248,4.249223,-0.778120>,
<0.999138,-0.024396,0.033599>
}
smooth_triangle {
<5.314421,3.874954,2.393706>,
<-0.799271,-0.487430,0.351536>,
<3.433269,6.004277,1.069082>,
<-0.799271,-0.487430,0.351536>,
<3.403995,6.354382,1.487969>,
<-0.799271,-0.487430,0.351536>
}
smooth_triangle {
<3.403995,6.354382,1.487969>,
<-0.799270,-0.487429,0.351539>,
<5.379206,4.118596,2.878827>,
<-0.799270,-0.487429,0.351539>,
<5.314421,3.874954,2.393706>,
<-0.799270,-0.487429,0.351539>
}
smooth_triangle {
<3.805865,6.254744,0.757099>,
<-0.196052,-0.636986,-0.745528>,
<3.433269,6.004277,1.069082>,
<-0.196052,-0.636986,-0.745528>,
<5.314421,3.874954,2.393706>,
<-0.196052,-0.636986,-0.745528>
}
smooth_triangle {
<5.314421,3.874954,2.393706>,
<-0.196045,-0.636984,-0.745532>,
<5.781076,4.018958,2.147957>,
<-0.196045,-0.636984,-0.745532>,
<3.805865,6.254744,0.757099>,
<-0.196045,-0.636984,-0.745532>
}
smooth_triangle {
<5.845863,4.262602,2.633076>,
<0.799270,0.487427,-0.351543>,
<3.776594,6.604854,1.175990>,
<0.799270,0.487427,-0.351543>,
<3.805865,6.254744,0.757099>,
<0.799270,0.487427,-0.351543>
}
smooth_triangle {
<3.805865,6.254744,0.757099>,
<0.799270,0.487426,-0.351544>,
<5.781076,4.018958,2.147957>,
<0.799270,0.487426,-0.351544>,
<5.845863,4.262602,2.633076>,
<0.799270,0.487426,-0.351544>
}
smooth_triangle {
<5.379206,4.118596,2.878827>,
<0.196041,0.636982,0.745534>,
<3.403995,6.354382,1.487969>,
<0.196041,0.636982,0.745534>,
<3.776594,6.604854,1.175990>,
<0.196041,0.636982,0.745534>
}
smooth_triangle {
<3.776594,6.604854,1.175990>,
<0.196045,0.636983,0.745533>,
<5.845863,4.262602,2.633076>,
<0.196045,0.636983,0.745533>,
<5.379206,4.118596,2.878827>,
<0.196045,0.636983,0.745533>
}
smooth_triangle {
<3.433269,6.004277,1.069082>,
<-0.765846,-0.347667,-0.540932>,
<5.430334,4.359627,-0.701295>,
<-0.765846,-0.347667,-0.540932>,
<5.527578,4.738978,-1.082788>,
<-0.765846,-0.347667,-0.540932>
}
smooth_triangle {
<5.527578,4.738978,-1.082788>,
<-0.765846,-0.347674,-0.540928>,
<3.430658,6.465857,0.776104>,
<-0.765846,-0.347674,-0.540928>,
<3.433269,6.004277,1.069082>,
<-0.765846,-0.347674,-0.540928>
}
smooth_triangle {
<5.876122,4.416390,-0.389928>,
<-0.242661,-0.831888,0.499077>,
<5.430334,4.359627,-0.701295>,
<-0.242661,-0.831888,0.499077>,
<3.433269,6.004277,1.069082>,
<-0.242661,-0.831888,0.499077>
}
smooth_triangle {
<3.433269,6.004277,1.069082>,
<-0.242663,-0.831889,0.499075>,
<3.779202,6.143269,1.468964>,
<-0.242663,-0.831889,0.499075>,
<5.876122,4.416390,-0.389928>,
<-0.242663,-0.831889,0.499075>
}
smooth_triangle {
<3.776594,6.604854,1.175990>,
<0.765846,0.347668,0.540932>,
<5.973367,4.795742,-0.771424>,
<0.765846,0.347668,0.540932>,
<5.876122,4.416390,-0.389928>,
<0.765846,0.347668,0.540932>
}
smooth_triangle {
<5.876122,4.416390,-0.389928>,
<0.765845,0.347665,0.540935>,
<3.779202,6.143269,1.468964>,
<0.765845,0.347665,0.540935>,
<3.776594,6.604854,1.175990>,
<0.765845,0.347665,0.540935>
}
smooth_triangle {
<3.430658,6.465857,0.776104>,
<0.242657,0.831887,-0.499080>,
<5.527578,4.738978,-1.082788>,
<0.242657,0.831887,-0.499080>,
<5.973367,4.795742,-0.771424>,
<0.242657,0.831887,-0.499080>
}
smooth_triangle {
<5.973367,4.795742,-0.771424>,
<0.242658,0.831888,-0.499079>,
<3.776594,6.604854,1.175990>,
<0.242658,0.831888,-0.499079>,
<3.430658,6.465857,0.776104>,
<0.242658,0.831888,-0.499079>
}
smooth_triangle {
<5.248012,0.048705,4.632054>,
<-0.492406,-0.650446,-0.578322>,
<2.709077,0.359337,6.444431>,
<-0.492406,-0.650446,-0.578322>,
<2.818067,-0.040356,6.801172>,
<-0.492406,-0.650446,-0.578322>
}
smooth_triangle {
<2.818067,-0.040356,6.801172>,
<-0.492409,-0.650441,-0.578325>,
<5.483947,-0.366521,4.898173>,
<-0.492409,-0.650441,-0.578325>,
<5.248012,0.048705,4.632054>,
<-0.492409,-0.650441,-0.578325>
}
smooth_triangle {
<2.871001,0.795122,6.732138>,
<-0.412945,0.603667,-0.681955>,
<2.709077,0.359337,6.444431>,
<-0.412945,0.603667,-0.681955>,
<5.248012,0.048705,4.632054>,
<-0.412945,0.603667,-0.681955>
}
smooth_triangle {
<5.248012,0.048705,4.632054>,
<-0.412947,0.603664,-0.681956>,
<5.536881,0.468957,4.829139>,
<-0.412947,0.603664,-0.681956>,
<2.871001,0.795122,6.732138>,
<-0.412947,0.603664,-0.681956>
}
smooth_triangle {
<5.772814,0.053728,5.095260>,
<0.492412,0.650431,0.578333>,
<2.979984,0.395423,7.088873>,
<0.492412,0.650431,0.578333>,
<2.871001,0.795122,6.732138>,
<0.492412,0.650431,0.578333>
}
smooth_triangle {
<2.871001,0.795122,6.732138>,
<0.492410,0.650438,0.578327>,
<5.536881,0.468957,4.829139>,
<0.492410,0.650438,0.578327>,
<5.772814,0.053728,5.095260>,
<0.492410,0.650438,0.578327>
}
smooth_triangle {
<5.483947,-0.366521,4.898173>,
<0.412948,-0.603662,0.681957>,
<2.818067,-0.040356,6.801172>,
<0.412948,-0.603662,0.681957>,
<2.979984,0.395423,7.088873>,
<0.412948,-0.603662,0.681957>
}
smooth_triangle {
<2.979984,0.395423,7.088873>,
<0.412945,-0.603667,0.681955>,
<5.772814,0.053728,5.095260>,
<0.412945,-0.603667,0.681955>,
<5.483947,-0.366521,4.898173>,
<0.412945,-0.603667,0.681955>
}
smooth_triangle {
<2.709077,0.359337,6.444431>,
<-0.870126,0.162978,-0.465101>,
<3.938109,2.869586,5.024747>,
<-0.870126,0.162978,-0.465101>,
<3.807258,3.244212,5.400822>,
<-0.870126,0.162978,-0.465101>
}
smooth_triangle {
<3.807258,3.244212,5.400822>,
<-0.870130,0.162983,-0.465092>,
<2.516780,0.608453,6.891493>,
<-0.870130,0.162983,-0.465092>,
<2.709077,0.359337,6.444431>,
<-0.870130,0.162983,-0.465092>
}
smooth_triangle {
<4.462766,2.782072,5.151146>,
<0.113815,-0.530718,-0.839872>,
<3.938109,2.869586,5.024747>,
<0.113815,-0.530718,-0.839872>,
<2.709077,0.359337,6.444431>,
<0.113815,-0.530718,-0.839872>
}
smooth_triangle {
<2.709077,0.359337,6.444431>,
<0.113819,-0.530720,-0.839870>,
<3.172288,0.146313,6.641817>,
<0.113819,-0.530720,-0.839870>,
<4.462766,2.782072,5.151146>,
<0.113819,-0.530720,-0.839870>
}
smooth_triangle {
<2.979984,0.395423,7.088873>,
<0.870129,-0.162985,0.465093>,
<4.331921,3.156698,5.527223>,
<0.870129,-0.162985,0.465093>,
<4.462766,2.782072,5.151146>,
<0.870129,-0.162985,0.465093>
}
smooth_triangle {
<4.462766,2.782072,5.151146>,
<0.870126,-0.162975,0.465103>,
<3.172288,0.146313,6.641817>,
<0.870126,-0.162975,0.465103>,
<2.979984,0.395423,7.088873>,
<0.870126,-0.162975,0.465103>
}
smooth_triangle {
<2.516780,0.608453,6.891493>,
<-0.113815,0.530719,0.839871>,
<3.807258,3.244212,5.400822>,
<-0.113815,0.530719,0.839871>,
<4.331921,3.156698,5.527223>,
<-0.113815,0.530719,0.839871>
}
smooth_triangle {
<4.331921,3.156698,5.527223>,
<-0.113808,0.530716,0.839874>,
<2.979984,0.395423,7.088873>,
<-0.113808,0.530716,0.839874>,
<2.516780,0.608453,6.891493>,
<-0.113808,0.530716,0.839874>
}
smooth_triangle {
<3.938109,2.869586,5.024747>,
<-0.138015,0.073409,-0.987706>,
<5.248012,0.048705,4.632054>,
<-0.138015,0.073409,-0.987706>,
<5.766628,0.210846,4.571637>,
<-0.138015,0.073409,-0.987706>
}
smooth_triangle {
<5.766628,0.210846,4.571637>,
<-0.138015,0.073409,-0.987706>,
<4.391226,3.172770,4.983965>,
<-0.138015,0.073409,-0.987706>,
<3.938109,2.869586,5.024747>,
<-0.138015,0.073409,-0.987706>
}
smooth_triangle {
<5.254200,-0.108410,5.155675>,
<-0.907189,-0.405804,-0.111043>,
<5.248012,0.048705,4.632054>,
<-0.907189,-0.405804,-0.111043>,
<3.938109,2.869586,5.024747>,
<-0.907189,-0.405804,-0.111043>
}
smooth_triangle {
<3.938109,2.869586,5.024747>,
<-0.907189,-0.405804,-0.111050>,
<3.878798,2.853514,5.568003>,
<-0.907189,-0.405804,-0.111050>,
<5.254200,-0.108410,5.155675>,
<-0.907189,-0.405804,-0.111050>
}
smooth_triangle {
<4.331921,3.156698,5.527223>,
<0.138012,-0.073411,0.987706>,
<5.772814,0.053728,5.095260>,
<0.138012,-0.073411,0.987706>,
<5.254200,-0.108410,5.155675>,
<0.138012,-0.073411,0.987706>
}
smooth_triangle {
<5.254200,-0.108410,5.155675>,
<0.138012,-0.073411,0.987706>,
<3.878798,2.853514,5.568003>,
<0.138012,-0.073411,0.987706>,
<4.331921,3.156698,5.527223>,
<0.138012,-0.073411,0.987706>
}
smooth_triangle {
<4.391226,3.172770,4.983965>,
<0.907189,0.405804,0.111048>,
<5.766628,0.210846,4.571637>,
<0.907189,0.405804,0.111048>,
<5.772814,0.053728,5.095260>,
<0.907189,0.405804,0.111048>
}
smooth_triangle {
<5.772814,0.053728,5.095260>,
<0.907190,0.405804,0.111040>,
<4.331921,3.156698,5.527223>,
<0.907190,0.405804,0.111040>,
<4.391226,3.172770,4.983965>,
<0.907190,0.405804,0.111040>
}
smooth_triangle {
<-2.096773,2.693907,-6.110496>,
<0.846456,-0.281142,0.452185>,
<-2.335088,5.128850,-4.150482>,
<0.846456,-0.281142,0.452185>,
<-2.055900,5.494677,-4.445651>,
<0.846456,-0.281142,0.452185>
}
smooth_triangle {
<-2.055900,5.494677,-4.445651>,
<0.846456,-0.281142,0.452185>,
<-1.805671,2.937983,-6.503665>,
<0.846456,-0.281142,0.452185>,
<-2.096773,2.693907,-6.110496>,
<0.846456,-0.281142,0.452185>
}
smooth_triangle {
<-2.847782,5.276067,-4.270357>,
<-0.342202,-0.609284,0.715311>,
<-2.335088,5.128850,-4.150482>,
<-0.342202,-0.609284,0.715311>,
<-2.096773,2.693907,-6.110496>,
<-0.342202,-0.609284,0.715311>
}
smooth_triangle {
<-2.096773,2.693907,-6.110496>,
<-0.342196,-0.609284,0.715314>,
<-2.597553,2.719373,-6.328371>,
<-0.342196,-0.609284,0.715314>,
<-2.847782,5.276067,-4.270357>,
<-0.342196,-0.609284,0.715314>
}
smooth_triangle {
<-2.306451,2.963451,-6.721547>,
<-0.846459,0.281139,-0.452181>,
<-2.568597,5.641888,-4.565530>,
<-0.846459,0.281139,-0.452181>,
<-2.847782,5.276067,-4.270357>,
<-0.846459,0.281139,-0.452181>
}
smooth_triangle {
<-2.847782,5.276067,-4.270357>,
<-0.846459,0.281139,-0.452181>,
<-2.597553,2.719373,-6.328371>,
<-0.846459,0.281139,-0.452181>,
<-2.306451,2.963451,-6.721547>,
<-0.846459,0.281139,-0.452181>
}
smooth_triangle {
<-1.805671,2.937983,-6.503665>,
<0.342200,0.609284,-0.715313>,
<-2.055900,5.494677,-4.445651>,
<0.342200,0.609284,-0.715313>,
<-2.568597,5.641888,-4.565530>,
<0.342200,0.609284,-0.715313>
}
smooth_triangle {
<-2.568597,5.641888,-4.565530>,
<0.342207,0.609284,-0.715310>,
<-2.306451,2.963451,-6.721547>,
<0.342207,0.609284,-0.715310>,
<-1.805671,2.937983,-6.503665>,
<0.342207,0.609284,-0.715310>
}
smooth_triangle {
<-2.335088,5.128850,-4.150482>,
<0.114333,-0.191566,0.974798>,
<-4.635708,3.004532,-4.298112>,
<0.114333,-0.191566,0.974798>,
<-5.055512,3.335583,-4.183816>,
<0.114333,-0.191566,0.974798>
}
smooth_triangle {
<-5.055512,3.335583,-4.183816>,
<0.114336,-0.191570,0.974796>,
<-2.639861,5.566119,-4.028801>,
<0.114336,-0.191570,0.974796>,
<-2.335088,5.128850,-4.150482>,
<0.114336,-0.191570,0.974796>
}
smooth_triangle {
<-4.679472,2.974089,-4.842222>,
<0.678802,-0.734197,-0.013519>,
<-4.635708,3.004532,-4.298112>,
<0.678802,-0.734197,-0.013519>,
<-2.335088,5.128850,-4.150482>,
<0.678802,-0.734197,-0.013519>
}
smooth_triangle {
<-2.335088,5.128850,-4.150482>,
<0.678802,-0.734197,-0.013522>,
<-2.263821,5.204625,-4.687207>,
<0.678802,-0.734197,-0.013522>,
<-4.679472,2.974089,-4.842222>,
<0.678802,-0.734197,-0.013522>
}
smooth_triangle {
<-2.568597,5.641888,-4.565530>,
<-0.114340,0.191572,-0.974796>,
<-5.099277,3.305137,-4.727922>,
<-0.114340,0.191572,-0.974796>,
<-4.679472,2.974089,-4.842222>,
<-0.114340,0.191572,-0.974796>
}
smooth_triangle {
<-4.679472,2.974089,-4.842222>,
<-0.114332,0.191565,-0.974798>,
<-2.263821,5.204625,-4.687207>,
<-0.114332,0.191565,-0.974798>,
<-2.568597,5.641888,-4.565530>,
<-0.114332,0.191565,-0.974798>
}
smooth_triangle {
<-2.639861,5.566119,-4.028801>,
<-0.678802,0.734197,0.013516>,
<-5.055512,3.335583,-4.183816>,
<-0.678802,0.734197,0.013516>,
<-5.099277,3.305137,-4.727922>,
<-0.678802,0.734197,0.013516>
}
smooth_triangle {
<-5.099277,3.305137,-4.727922>,
<-0.678802,0.734197,0.013517>,
<-2.568597,5.641888,-4.565530>,
<-0.678802,0.734197,0.013517>,
<-2.639861,5.566119,-4.028801>,
<-0.678802,0.734197,0.013517>
}
smooth_triangle {
<-4.635708,3.004532,-4.298112>,
<0.183062,-0.893700,0.409620>,
<-2.096773,2.693907,-6.110496>,
<0.183062,-0.893700,0.409620>,
<-2.334822,2.449376,-6.537622>,
<0.183062,-0.893700,0.409620>
}
smooth_triangle {
<-2.334822,2.449376,-6.537622>,
<0.183059,-0.893702,0.409617>,
<-5.000702,2.775534,-4.634623>,
<0.183059,-0.893702,0.409617>,
<-4.635708,3.004532,-4.298112>,
<0.183059,-0.893702,0.409617>
}
smooth_triangle {
<-2.068402,3.207980,-6.294414>,
<0.582968,0.244982,0.774682>,
<-2.096773,2.693907,-6.110496>,
<0.582968,0.244982,0.774682>,
<-4.635708,3.004532,-4.298112>,
<0.582968,0.244982,0.774682>
}
smooth_triangle {
<-4.635708,3.004532,-4.298112>,
<0.582968,0.244985,0.774681>,
<-4.734282,3.534138,-4.391415>,
<0.582968,0.244985,0.774681>,
<-2.068402,3.207980,-6.294414>,
<0.582968,0.244985,0.774681>
}
smooth_triangle {
<-5.099277,3.305137,-4.727922>,
<-0.183059,0.893703,-0.409614>,
<-2.306451,2.963451,-6.721547>,
<-0.183059,0.893703,-0.409614>,
<-2.068402,3.207980,-6.294414>,
<-0.183059,0.893703,-0.409614>
}
smooth_triangle {
<-2.068402,3.207980,-6.294414>,
<-0.183064,0.893698,-0.409623>,
<-4.734282,3.534138,-4.391415>,
<-0.183064,0.893698,-0.409623>,
<-5.099277,3.305137,-4.727922>,
<-0.183064,0.893698,-0.409623>
}
smooth_triangle {
<-5.000702,2.775534,-4.634623>,
<-0.582967,-0.244990,-0.774680>,
<-2.334822,2.449376,-6.537622>,
<-0.582967,-0.244990,-0.774680>,
<-2.306451,2.963451,-6.721547>,
<-0.582967,-0.244990,-0.774680>
}
smooth_triangle {
<-2.306451,2.963451,-6.721547>,
<-0.582969,-0.244981,-0.774681>,
<-5.099277,3.305137,-4.727922>,
<-0.582969,-0.244981,-0.774681>,
<-5.000702,2.775534,-4.634623>,
<-0.582969,-0.244981,-0.774681>
}
smooth_triangle {
<-0.839531,6.939351,0.345492>,
<0.552496,-0.717280,0.424567>,
<-3.384248,5.850361,1.817193>,
<0.552496,-0.717280,0.424567>,
<-3.345468,6.149954,2.272872>,
<0.552496,-0.717280,0.424567>
}
smooth_triangle {
<-3.345468,6.149954,2.272872>,
<0.552499,-0.717275,0.424572>,
<-0.673519,7.293397,0.727587>,
<0.552499,-0.717275,0.424572>,
<-0.839531,6.939351,0.345492>,
<0.552499,-0.717275,0.424572>
}
smooth_triangle {
<-3.761450,6.135954,1.543234>,
<-0.071908,-0.738292,-0.670637>,
<-3.384248,5.850361,1.817193>,
<-0.071908,-0.738292,-0.670637>,
<-0.839531,6.939351,0.345492>,
<-0.071908,-0.738292,-0.670637>
}
smooth_triangle {
<-0.839531,6.939351,0.345492>,
<-0.071910,-0.738288,-0.670641>,
<-1.089501,7.279397,-0.002051>,
<-0.071910,-0.738288,-0.670641>,
<-3.761450,6.135954,1.543234>,
<-0.071910,-0.738288,-0.670641>
}
smooth_triangle {
<-0.923484,7.633442,0.380041>,
<-0.552498,0.717276,-0.424572>,
<-3.722673,6.435549,1.998912>,
<-0.552498,0.717276,-0.424572>,
<-3.761450,6.135954,1.543234>,
<-0.552498,0.717276,-0.424572>
}
smooth_triangle {
<-3.761450,6.135954,1.543234>,
<-0.552498,0.717278,-0.424569>,
<-1.089501,7.279397,-0.002051>,
<-0.552498,0.717278,-0.424569>,
<-0.923484,7.633442,0.380041>,
<-0.552498,0.717278,-0.424569>
}
smooth_triangle {
<-0.673519,7.293397,0.727587>,
<0.071908,0.738290,0.670639>,
<-3.345468,6.149954,2.272872>,
<0.071908,0.738290,0.670639>,
<-3.722673,6.435549,1.998912>,
<0.071908,0.738290,0.670639>
}
smooth_triangle {
<-3.722673,6.435549,1.998912>,
<0.071908,0.738291,0.670638>,
<-0.923484,7.633442,0.380041>,
<0.071908,0.738291,0.670638>,
<-0.673519,7.293397,0.727587>,
<0.071908,0.738291,0.670638>
}
smooth_triangle {
<-3.384248,5.850361,1.817193>,
<-0.166497,-0.984579,-0.053687>,
<-3.332980,6.012376,-1.313060>,
<-0.166497,-0.984579,-0.053687>,
<-3.865141,6.106855,-1.395373>,
<-0.166497,-0.984579,-0.053687>
}
smooth_triangle {
<-3.865141,6.106855,-1.395373>,
<-0.166500,-0.984579,-0.053686>,
<-3.918971,5.936741,1.891393>,
<-0.166500,-0.984579,-0.053686>,
<-3.384248,5.850361,1.817193>,
<-0.166500,-0.984579,-0.053686>
}
smooth_triangle {
<-3.134117,6.519281,-1.362053>,
<0.930798,-0.365515,-0.003673>,
<-3.332980,6.012376,-1.313060>,
<0.930798,-0.365515,-0.003673>,
<-3.384248,5.850361,1.817193>,
<0.930798,-0.365515,-0.003673>
}
smooth_triangle {
<-3.384248,5.850361,1.817193>,
<0.930798,-0.365516,-0.003674>,
<-3.187947,6.349167,1.924713>,
<0.930798,-0.365516,-0.003674>,
<-3.134117,6.519281,-1.362053>,
<0.930798,-0.365516,-0.003674>
}
smooth_triangle {
<-3.722673,6.435549,1.998912>,
<0.166508,0.984578,0.053687>,
<-3.666278,6.613766,-1.444366>,
<0.166508,0.984578,0.053687>,
<-3.134117,6.519281,-1.362053>,
<0.166508,0.984578,0.053687>
}
smooth_triangle {
<-3.134117,6.519281,-1.362053>,
<0.166503,0.984578,0.053686>,
<-3.187947,6.349167,1.924713>,
<0.166503,0.984578,0.053686>,
<-3.722673,6.435549,1.998912>,
<0.166503,0.984578,0.053686>
}
smooth_triangle {
<-3.918971,5.936741,1.891393>,
<-0.930800,0.365511,0.003673>,
<-3.865141,6.106855,-1.395373>,
<-0.930800,0.365511,0.003673>,
<-3.666278,6.613766,-1.444366>,
<-0.930800,0.365511,0.003673>
}
smooth_triangle {
<-3.666278,6.613766,-1.444366>,
<-0.930800,0.365510,0.003673>,
<-3.722673,6.435549,1.998912>,
<-0.930800,0.365510,0.003673>,
<-3.918971,5.936741,1.891393>,
<-0.930800,0.365510,0.003673>
}
smooth_triangle {
<-3.332980,6.012376,-1.313060>,
<0.567279,-0.670561,-0.478061>,
<-0.839531,6.939351,0.345492>,
<0.567279,-0.670561,-0.478061>,
<-0.661724,7.330658,0.007609>,
<0.567279,-0.670561,-0.478061>
}
smooth_triangle {
<-0.661724,7.330658,0.007609>,
<0.567279,-0.670567,-0.478053>,
<-3.279843,6.357329,-1.733872>,
<0.567279,-0.670567,-0.478053>,
<-3.332980,6.012376,-1.313060>,
<0.567279,-0.670567,-0.478053>
}
smooth_triangle {
<-1.101296,7.242136,0.717927>,
<-0.092528,-0.803439,0.588153>,
<-0.839531,6.939351,0.345492>,
<-0.092528,-0.803439,0.588153>,
<-3.332980,6.012376,-1.313060>,
<-0.092528,-0.803439,0.588153>
}
smooth_triangle {
<-3.332980,6.012376,-1.313060>,
<-0.092524,-0.803442,0.588150>,
<-3.719415,6.268807,-1.023554>,
<-0.092524,-0.803442,0.588150>,
<-1.101296,7.242136,0.717927>,
<-0.092524,-0.803442,0.588150>
}
smooth_triangle {
<-3.666278,6.613766,-1.444366>,
<-0.567278,0.670566,0.478055>,
<-0.923484,7.633442,0.380041>,
<-0.567278,0.670566,0.478055>,
<-1.101296,7.242136,0.717927>,
<-0.567278,0.670566,0.478055>
}
smooth_triangle {
<-1.101296,7.242136,0.717927>,
<-0.567280,0.670562,0.478059>,
<-3.719415,6.268807,-1.023554>,
<-0.567280,0.670562,0.478059>,
<-3.666278,6.613766,-1.444366>,
<-0.567280,0.670562,0.478059>
}
smooth_triangle {
<-3.279843,6.357329,-1.733872>,
<0.092528,0.803438,-0.588154>,
<-0.661724,7.330658,0.007609>,
<0.092528,0.803438,-0.588154>,
<-0.923484,7.633442,0.380041>,
<0.092528,0.803438,-0.588154>
}
smooth_triangle {
<-0.923484,7.633442,0.380041>,
<0.092530,0.803437,-0.588155>,
<-3.666278,6.613766,-1.444366>,
<0.092530,0.803437,-0.588155>,
<-3.279843,6.357329,-1.733872>,
<0.092530,0.803437,-0.588155>
}
smooth_triangle {
<0.894341,6.314902,2.881466>,
<0.500240,-0.646423,-0.576106>,
<1.206345,4.377554,5.326195>,
<0.500240,-0.646423,-0.576106>,
<1.679545,4.571223,5.519773>,
<0.500240,-0.646423,-0.576106>
}
smooth_triangle {
<1.679545,4.571223,5.519773>,
<0.500250,-0.646416,-0.576104>,
<1.351938,6.605444,2.952810>,
<0.500250,-0.646416,-0.576104>,
<0.894341,6.314902,2.881466>,
<0.500250,-0.646416,-0.576104>
}
smooth_triangle {
<0.853783,4.621791,5.665233>,
<-0.739266,-0.570517,-0.357764>,
<1.206345,4.377554,5.326195>,
<-0.739266,-0.570517,-0.357764>,
<0.894341,6.314902,2.881466>,
<-0.739266,-0.570517,-0.357764>
}
smooth_triangle {
<0.894341,6.314902,2.881466>,
<-0.739269,-0.570515,-0.357763>,
<0.526176,6.656012,3.098270>,
<-0.739269,-0.570515,-0.357763>,
<0.853783,4.621791,5.665233>,
<-0.739269,-0.570515,-0.357763>
}
smooth_triangle {
<0.983775,6.946547,3.169614>,
<-0.500251,0.646417,0.576103>,
<1.326980,4.815463,5.858816>,
<-0.500251,0.646417,0.576103>,
<0.853783,4.621791,5.665233>,
<-0.500251,0.646417,0.576103>
}
smooth_triangle {
<0.853783,4.621791,5.665233>,
<-0.500240,0.646421,0.576107>,
<0.526176,6.656012,3.098270>,
<-0.500240,0.646421,0.576107>,
<0.983775,6.946547,3.169614>,
<-0.500240,0.646421,0.576107>
}
smooth_triangle {
<1.351938,6.605444,2.952810>,
<0.739268,0.570515,0.357763>,
<1.679545,4.571223,5.519773>,
<0.739268,0.570515,0.357763>,
<1.326980,4.815463,5.858816>,
<0.739268,0.570515,0.357763>
}
smooth_triangle {
<1.326980,4.815463,5.858816>,
<0.739266,0.570518,0.357765>,
<0.983775,6.946547,3.169614>,
<0.739266,0.570518,0.357765>,
<1.351938,6.605444,2.952810>,
<0.739266,0.570518,0.357765>
}
smooth_triangle {
<1.206345,4.377554,5.326195>,
<-0.233544,-0.960436,-0.151723>,
<-1.650376,5.225919,4.353167>,
<-0.233544,-0.960436,-0.151723>,
<-1.905309,5.211541,4.836594>,
<-0.233544,-0.960436,-0.151723>
}
smooth_triangle {
<-1.905309,5.211541,4.836594>,
<-0.233543,-0.960436,-0.151727>,
<1.094247,4.320756,5.858272>,
<-0.233543,-0.960436,-0.151727>,
<1.206345,4.377554,5.326195>,
<-0.233543,-0.960436,-0.151727>
}
smooth_triangle {
<-1.560475,5.763043,4.305056>,
<0.284062,-0.132601,-0.949592>,
<-1.650376,5.225919,4.353167>,
<0.284062,-0.132601,-0.949592>,
<1.206345,4.377554,5.326195>,
<0.284062,-0.132601,-0.949592>
}
smooth_triangle {
<1.206345,4.377554,5.326195>,
<0.284061,-0.132603,-0.949592>,
<1.439081,4.872258,5.326734>,
<0.284061,-0.132603,-0.949592>,
<-1.560475,5.763043,4.305056>,
<0.284061,-0.132603,-0.949592>
}
smooth_triangle {
<1.326980,4.815463,5.858816>,
<0.233542,0.960436,0.151727>,
<-1.815414,5.748664,4.788484>,
<0.233542,0.960436,0.151727>,
<-1.560475,5.763043,4.305056>,
<0.233542,0.960436,0.151727>
}
smooth_triangle {
<-1.560475,5.763043,4.305056>,
<0.233545,0.960436,0.151721>,
<1.439081,4.872258,5.326734>,
<0.233545,0.960436,0.151721>,
<1.326980,4.815463,5.858816>,
<0.233545,0.960436,0.151721>
}
smooth_triangle {
<1.094247,4.320756,5.858272>,
<-0.284063,0.132597,0.949593>,
<-1.905309,5.211541,4.836594>,
<-0.284063,0.132597,0.949593>,
<-1.815414,5.748664,4.788484>,
<-0.284063,0.132597,0.949593>
}
smooth_triangle {
<-1.815414,5.748664,4.788484>,
<-0.284065,0.132593,0.949593>,
<1.326980,4.815463,5.858816>,
<-0.284065,0.132593,0.949593>,
<1.094247,4.320756,5.858272>,
<-0.284065,0.132593,0.949593>
}
smooth_triangle {
<-1.650376,5.225919,4.353167>,
<-0.323517,-0.401777,-0.856687>,
<0.894341,6.314902,2.881466>,
<-0.323517,-0.401777,-0.856687>,
<0.694883,6.800576,2.729013>,
<-0.323517,-0.401777,-0.856687>
}
smooth_triangle {
<0.694883,6.800576,2.729013>,
<-0.323516,-0.401778,-0.856687>,
<-1.977066,5.657140,4.274298>,
<-0.323516,-0.401778,-0.856687>,
<-1.650376,5.225919,4.353167>,
<-0.323516,-0.401778,-0.856687>
}
smooth_triangle {
<1.183231,6.460880,3.322067>,
<0.409535,-0.911678,0.033532>,
<0.894341,6.314902,2.881466>,
<0.409535,-0.911678,0.033532>,
<-1.650376,5.225919,4.353167>,
<0.409535,-0.911678,0.033532>
}
smooth_triangle {
<-1.650376,5.225919,4.353167>,
<0.409533,-0.911679,0.033523>,
<-1.488718,5.317444,4.867352>,
<0.409533,-0.911679,0.033523>,
<1.183231,6.460880,3.322067>,
<0.409533,-0.911679,0.033523>
}
smooth_triangle {
<-1.815414,5.748664,4.788484>,
<0.323514,0.401780,0.856686>,
<0.983775,6.946547,3.169614>,
<0.323514,0.401780,0.856686>,
<1.183231,6.460880,3.322067>,
<0.323514,0.401780,0.856686>
}
smooth_triangle {
<1.183231,6.460880,3.322067>,
<0.323514,0.401781,0.856686>,
<-1.488718,5.317444,4.867352>,
<0.323514,0.401781,0.856686>,
<-1.815414,5.748664,4.788484>,
<0.323514,0.401781,0.856686>
}
smooth_triangle {
<-1.977066,5.657140,4.274298>,
<-0.409531,0.911680,-0.033520>,
<0.694883,6.800576,2.729013>,
<-0.409531,0.911680,-0.033520>,
<0.983775,6.946547,3.169614>,
<-0.409531,0.911680,-0.033520>
}
smooth_triangle {
<0.983775,6.946547,3.169614>,
<-0.409533,0.911679,-0.033526>,
<-1.815414,5.748664,4.788484>,
<-0.409533,0.911679,-0.033526>,
<-1.977066,5.657140,4.274298>,
<-0.409533,0.911679,-0.033526>
}
smooth_triangle {
<-0.022687,1.867305,6.745886>,
<0.547762,-0.549371,-0.630990>,
<-2.323307,-0.257013,6.598256>,
<0.547762,-0.549371,-0.630990>,
<-2.163469,-0.574631,7.013545>,
<0.547762,-0.549371,-0.630990>
}
smooth_triangle {
<-2.163469,-0.574631,7.013545>,
<0.547765,-0.549373,-0.630985>,
<0.252182,1.655905,7.168560>,
<0.547765,-0.549373,-0.630985>,
<-0.022687,1.867305,6.745886>,
<0.547765,-0.549373,-0.630985>
}
smooth_triangle {
<-2.715475,0.035055,6.842787>,
<-0.280835,0.365806,-0.887309>,
<-2.323307,-0.257013,6.598256>,
<-0.280835,0.365806,-0.887309>,
<-0.022687,1.867305,6.745886>,
<-0.280835,0.365806,-0.887309>
}
smooth_triangle {
<-0.022687,1.867305,6.745886>,
<-0.280837,0.365809,-0.887307>,
<-0.299824,2.265591,6.997802>,
<-0.280837,0.365809,-0.887307>,
<-2.715475,0.035055,6.842787>,
<-0.280837,0.365809,-0.887307>
}
smooth_triangle {
<-0.024956,2.054188,7.420473>,
<-0.547765,0.549375,0.630984>,
<-2.555637,-0.282562,7.258081>,
<-0.547765,0.549375,0.630984>,
<-2.715475,0.035055,6.842787>,
<-0.547765,0.549375,0.630984>
}
smooth_triangle {
<-2.715475,0.035055,6.842787>,
<-0.547762,0.549370,0.630990>,
<-0.299824,2.265591,6.997802>,
<-0.547762,0.549370,0.630990>,
<-0.024956,2.054188,7.420473>,
<-0.547762,0.549370,0.630990>
}
smooth_triangle {
<0.252182,1.655905,7.168560>,
<0.280839,-0.365811,0.887306>,
<-2.163469,-0.574631,7.013545>,
<0.280839,-0.365811,0.887306>,
<-2.555637,-0.282562,7.258081>,
<0.280839,-0.365811,0.887306>
}
smooth_triangle {
<-2.555637,-0.282562,7.258081>,
<0.280836,-0.365806,0.887309>,
<-0.024956,2.054188,7.420473>,
<0.280836,-0.365806,0.887309>,
<0.252182,1.655905,7.168560>,
<0.280836,-0.365806,0.887309>
}
smooth_triangle {
<-2.323307,-0.257013,6.598256>,
<-0.276003,-0.304739,-0.911568>,
<-2.879408,2.715670,5.772858>,
<-0.276003,-0.304739,-0.911568>,
<-3.404429,2.741808,5.923085>,
<-0.276003,-0.304739,-0.911568>
}
smooth_triangle {
<-3.404429,2.741808,5.923085>,
<-0.275997,-0.304737,-0.911571>,
<-2.820524,-0.379506,6.789748>,
<-0.275997,-0.304737,-0.911571>,
<-2.323307,-0.257013,6.598256>,
<-0.275997,-0.304737,-0.911571>
}
smooth_triangle {
<-2.642325,2.961244,6.199921>,
<0.867962,0.024645,-0.496019>,
<-2.879408,2.715670,5.772858>,
<0.867962,0.024645,-0.496019>,
<-2.323307,-0.257013,6.598256>,
<0.867962,0.024645,-0.496019>
}
smooth_triangle {
<-2.323307,-0.257013,6.598256>,
<0.867961,0.024645,-0.496021>,
<-2.058420,-0.160070,7.066584>,
<0.867961,0.024645,-0.496021>,
<-2.642325,2.961244,6.199921>,
<0.867961,0.024645,-0.496021>
}
smooth_triangle {
<-2.555637,-0.282562,7.258081>,
<0.275995,0.304739,0.911571>,
<-3.167348,2.987388,6.350141>,
<0.275995,0.304739,0.911571>,
<-2.642325,2.961244,6.199921>,
<0.275995,0.304739,0.911571>
}
smooth_triangle {
<-2.642325,2.961244,6.199921>,
<0.276005,0.304738,0.911568>,
<-2.058420,-0.160070,7.066584>,
<0.276005,0.304738,0.911568>,
<-2.555637,-0.282562,7.258081>,
<0.276005,0.304738,0.911568>
}
smooth_triangle {
<-2.820524,-0.379506,6.789748>,
<-0.867960,-0.024644,0.496022>,
<-3.404429,2.741808,5.923085>,
<-0.867960,-0.024644,0.496022>,
<-3.167348,2.987388,6.350141>,
<-0.867960,-0.024644,0.496022>
}
smooth_triangle {
<-3.167348,2.987388,6.350141>,
<-0.867963,-0.024645,0.496017>,
<-2.555637,-0.282562,7.258081>,
<-0.867963,-0.024645,0.496017>,
<-2.820524,-0.379506,6.789748>,
<-0.867963,-0.024645,0.496017>
}
smooth_triangle {
<-2.879408,2.715670,5.772858>,
<0.387405,0.307822,-0.869001>,
<-0.022687,1.867305,6.745886>,
<0.387405,0.307822,-0.869001>,
<0.124278,2.339630,6.978713>,
<0.387405,0.307822,-0.869001>
}
smooth_triangle {
<0.124278,2.339630,6.978713>,
<0.387405,0.307826,-0.869000>,
<-2.875278,3.230408,5.957035>,
<0.387405,0.307826,-0.869000>,
<-2.879408,2.715670,5.772858>,
<0.387405,0.307826,-0.869000>
}
smooth_triangle {
<-0.171920,1.581866,7.187649>,
<-0.057208,-0.829628,-0.555378>,
<-0.022687,1.867305,6.745886>,
<-0.057208,-0.829628,-0.555378>,
<-2.879408,2.715670,5.772858>,
<-0.057208,-0.829628,-0.555378>
}
smooth_triangle {
<-2.879408,2.715670,5.772858>,
<-0.057205,-0.829625,-0.555383>,
<-3.171476,2.472644,6.165971>,
<-0.057205,-0.829625,-0.555383>,
<-0.171920,1.581866,7.187649>,
<-0.057205,-0.829625,-0.555383>
}
smooth_triangle {
<-3.167348,2.987388,6.350141>,
<-0.387405,-0.307819,0.869002>,
<-0.024956,2.054188,7.420473>,
<-0.387405,-0.307819,0.869002>,
<-0.171920,1.581866,7.187649>,
<-0.387405,-0.307819,0.869002>
}
smooth_triangle {
<-0.171920,1.581866,7.187649>,
<-0.387403,-0.307814,0.869005>,
<-3.171476,2.472644,6.165971>,
<-0.387403,-0.307814,0.869005>,
<-3.167348,2.987388,6.350141>,
<-0.387403,-0.307814,0.869005>
}
smooth_triangle {
<-2.875278,3.230408,5.957035>,
<0.057204,0.829624,0.555385>,
<0.124278,2.339630,6.978713>,
<0.057204,0.829624,0.555385>,
<-0.024956,2.054188,7.420473>,
<0.057204,0.829624,0.555385>
}
smooth_triangle {
<-0.024956,2.054188,7.420473>,
<0.057207,0.829626,0.555381>,
<-3.167348,2.987388,6.350141>,
<0.057207,0.829626,0.555381>,
<-2.875278,3.230408,5.957035>,
<0.057207,0.829626,0.555381>
}
smooth_triangle {
<-2.709077,-0.362398,-6.444424>,
<0.492409,0.650441,0.578325>,
<-5.248005,-0.051766,-4.632047>,
<0.492409,0.650441,0.578325>,
<-5.483940,0.363460,-4.898166>,
<0.492409,0.650441,0.578325>
}
smooth_triangle {
<-5.483940,0.363460,-4.898166>,
<0.492408,0.650445,0.578321>,
<-2.818067,0.037295,-6.801165>,
<0.492408,0.650445,0.578321>,
<-2.709077,-0.362398,-6.444424>,
<0.492408,0.650445,0.578321>
}
smooth_triangle {
<-5.536874,-0.472018,-4.829132>,
<0.412948,-0.603664,0.681956>,
<-5.248005,-0.051766,-4.632047>,
<0.412948,-0.603664,0.681956>,
<-2.709077,-0.362398,-6.444424>,
<0.412948,-0.603664,0.681956>
}
smooth_triangle {
<-2.709077,-0.362398,-6.444424>,
<0.412947,-0.603667,0.681954>,
<-2.871001,-0.798183,-6.732131>,
<0.412947,-0.603667,0.681954>,
<-5.536874,-0.472018,-4.829132>,
<0.412947,-0.603667,0.681954>
}
smooth_triangle {
<-2.979984,-0.398485,-7.088865>,
<-0.492412,-0.650435,-0.578330>,
<-5.772804,-0.056790,-5.095250>,
<-0.492412,-0.650435,-0.578330>,
<-5.536874,-0.472018,-4.829132>,
<-0.492412,-0.650435,-0.578330>
}
smooth_triangle {
<-5.536874,-0.472018,-4.829132>,
<-0.492414,-0.650431,-0.578332>,
<-2.871001,-0.798183,-6.732131>,
<-0.492414,-0.650431,-0.578332>,
<-2.979984,-0.398485,-7.088865>,
<-0.492414,-0.650431,-0.578332>
}
smooth_triangle {
<-2.818067,0.037295,-6.801165>,
<-0.412949,0.603662,-0.681957>,
<-5.483940,0.363460,-4.898166>,
<-0.412949,0.603662,-0.681957>,
<-5.772804,-0.056790,-5.095250>,
<-0.412949,0.603662,-0.681957>
}
smooth_triangle {
<-5.772804,-0.056790,-5.095250>,
<-0.412950,0.603660,-0.681958>,
<-2.979984,-0.398485,-7.088865>,
<-0.412950,0.603660,-0.681958>,
<-2.818067,0.037295,-6.801165>,
<-0.412950,0.603660,-0.681958>
}
smooth_triangle {
<-5.248005,-0.051766,-4.632047>,
<0.138015,-0.073409,0.987706>,
<-3.938102,-2.872647,-5.024740>,
<0.138015,-0.073409,0.987706>,
<-4.391219,-3.175831,-4.983958>,
<0.138015,-0.073409,0.987706>
}
smooth_triangle {
<-4.391219,-3.175831,-4.983958>,
<0.138015,-0.073409,0.987706>,
<-5.766621,-0.213907,-4.571630>,
<0.138015,-0.073409,0.987706>,
<-5.248005,-0.051766,-4.632047>,
<0.138015,-0.073409,0.987706>
}
smooth_triangle {
<-3.878791,-2.856575,-5.567996>,
<0.907189,0.405803,0.111050>,
<-3.938102,-2.872647,-5.024740>,
<0.907189,0.405803,0.111050>,
<-5.248005,-0.051766,-4.632047>,
<0.907189,0.405803,0.111050>
}
smooth_triangle {
<-5.248005,-0.051766,-4.632047>,
<0.907189,0.405805,0.111043>,
<-5.254193,0.105349,-5.155668>,
<0.907189,0.405805,0.111043>,
<-3.878791,-2.856575,-5.567996>,
<0.907189,0.405805,0.111043>
}
smooth_triangle {
<-5.772804,-0.056790,-5.095250>,
<-0.138014,0.073411,-0.987706>,
<-4.331913,-3.159759,-5.527215>,
<-0.138014,0.073411,-0.987706>,
<-3.878791,-2.856575,-5.567996>,
<-0.138014,0.073411,-0.987706>
}
smooth_triangle {
<-3.878791,-2.856575,-5.567996>,
<-0.138017,0.073408,-0.987706>,
<-5.254193,0.105349,-5.155668>,
<-0.138017,0.073408,-0.987706>,
<-5.772804,-0.056790,-5.095250>,
<-0.138017,0.073408,-0.987706>
}
smooth_triangle {
<-5.766621,-0.213907,-4.571630>,
<-0.907189,-0.405805,-0.111041>,
<-4.391219,-3.175831,-4.983958>,
<-0.907189,-0.405805,-0.111041>,
<-4.331913,-3.159759,-5.527215>,
<-0.907189,-0.405805,-0.111041>
}
smooth_triangle {
<-4.331913,-3.159759,-5.527215>,
<-0.907189,-0.405802,-0.111053>,
<-5.772804,-0.056790,-5.095250>,
<-0.907189,-0.405802,-0.111053>,
<-5.766621,-0.213907,-4.571630>,
<-0.907189,-0.405802,-0.111053>
}
smooth_triangle {
<-3.938102,-2.872647,-5.024740>,
<0.870130,-0.162983,0.465092>,
<-2.709077,-0.362398,-6.444424>,
<0.870130,-0.162983,0.465092>,
<-2.516780,-0.611514,-6.891486>,
<0.870130,-0.162983,0.465092>
}
smooth_triangle {
<-2.516780,-0.611514,-6.891486>,
<0.870128,-0.162976,0.465099>,
<-3.807251,-3.247273,-5.400815>,
<0.870128,-0.162976,0.465099>,
<-3.938102,-2.872647,-5.024740>,
<0.870128,-0.162976,0.465099>
}
smooth_triangle {
<-3.172288,-0.149374,-6.641810>,
<-0.113820,0.530719,0.839870>,
<-2.709077,-0.362398,-6.444424>,
<-0.113820,0.530719,0.839870>,
<-3.938102,-2.872647,-5.024740>,
<-0.113820,0.530719,0.839870>
}
smooth_triangle {
<-3.938102,-2.872647,-5.024740>,
<-0.113815,0.530719,0.839871>,
<-4.462759,-2.785133,-5.151139>,
<-0.113815,0.530719,0.839871>,
<-3.172288,-0.149374,-6.641810>,
<-0.113815,0.530719,0.839871>
}
smooth_triangle {
<-4.331913,-3.159759,-5.527215>,
<-0.870125,0.162974,-0.465104>,
<-2.979984,-0.398485,-7.088865>,
<-0.870125,0.162974,-0.465104>,
<-3.172288,-0.149374,-6.641810>,
<-0.870125,0.162974,-0.465104>
}
smooth_triangle {
<-3.172288,-0.149374,-6.641810>,
<-0.870130,0.162980,-0.465093>,
<-4.462759,-2.785133,-5.151139>,
<-0.870130,0.162980,-0.465093>,
<-4.331913,-3.159759,-5.527215>,
<-0.870130,0.162980,-0.465093>
}
smooth_triangle {
<-3.807251,-3.247273,-5.400815>,
<0.113807,-0.530716,-0.839874>,
<-2.516780,-0.611514,-6.891486>,
<0.113807,-0.530716,-0.839874>,
<-2.979984,-0.398485,-7.088865>,
<0.113807,-0.530716,-0.839874>
}
smooth_triangle {
<-2.979984,-0.398485,-7.088865>,
<0.113815,-0.530718,-0.839872>,
<-4.331913,-3.159759,-5.527215>,
<0.113815,-0.530718,-0.839872>,
<-3.807251,-3.247273,-5.400815>,
<0.113815,-0.530718,-0.839872>
}
smooth_triangle {
<-6.624324,-1.057141,-2.001006>,
<0.545615,0.689307,0.476613>,
<-6.312313,-2.994489,0.443723>,
<0.545615,0.689307,0.476613>,
<-6.754741,-2.838361,0.724402>,
<0.545615,0.689307,0.476613>
}
smooth_triangle {
<-6.754741,-2.838361,0.724402>,
<0.545613,0.689308,0.476614>,
<-7.082355,-0.804147,-1.842561>,
<0.545613,0.689308,0.476614>,
<-6.624324,-1.057141,-2.001006>,
<0.545613,0.689308,0.476614>
}
smooth_triangle {
<-6.501117,-3.449909,0.207410>,
<0.926316,-0.228656,-0.299423>,
<-6.312313,-2.994489,0.443723>,
<0.926316,-0.228656,-0.299423>,
<-6.624324,-1.057141,-2.001006>,
<0.926316,-0.228656,-0.299423>
}
smooth_triangle {
<-6.624324,-1.057141,-2.001006>,
<0.926315,-0.228660,-0.299426>,
<-6.828731,-1.415695,-2.359553>,
<0.926315,-0.228660,-0.299426>,
<-6.501117,-3.449909,0.207410>,
<0.926315,-0.228660,-0.299426>
}
smooth_triangle {
<-7.286755,-1.162702,-2.201106>,
<-0.545617,-0.689306,-0.476612>,
<-6.943544,-3.293785,0.488095>,
<-0.545617,-0.689306,-0.476612>,
<-6.501117,-3.449909,0.207410>,
<-0.545617,-0.689306,-0.476612>
}
smooth_triangle {
<-6.501117,-3.449909,0.207410>,
<-0.545619,-0.689305,-0.476611>,
<-6.828731,-1.415695,-2.359553>,
<-0.545619,-0.689305,-0.476611>,
<-7.286755,-1.162702,-2.201106>,
<-0.545619,-0.689305,-0.476611>
}
smooth_triangle {
<-7.082355,-0.804147,-1.842561>,
<-0.926316,0.228656,0.299424>,
<-6.754741,-2.838361,0.724402>,
<-0.926316,0.228656,0.299424>,
<-6.943544,-3.293785,0.488095>,
<-0.926316,0.228656,0.299424>
}
smooth_triangle {
<-6.943544,-3.293785,0.488095>,
<-0.926319,0.228652,0.299420>,
<-7.286755,-1.162702,-2.201106>,
<-0.926319,0.228652,0.299420>,
<-7.082355,-0.804147,-1.842561>,
<-0.926319,0.228652,0.299420>
}
smooth_triangle {
<-6.312313,-2.994489,0.443723>,
<0.923339,-0.124110,0.363375>,
<-5.314421,-3.878015,-2.393699>,
<0.923339,-0.124110,0.363375>,
<-5.405666,-4.414880,-2.345210>,
<0.923339,-0.124110,0.363375>
}
smooth_triangle {
<-5.405666,-4.414880,-2.345210>,
<0.923338,-0.124114,0.363376>,
<-6.453454,-3.487177,0.634081>,
<0.923338,-0.124114,0.363376>,
<-6.312313,-2.994489,0.443723>,
<0.923338,-0.124114,0.363376>
}
smooth_triangle {
<-5.754616,-3.728796,-2.681560>,
<0.399560,0.905720,-0.141505>,
<-5.314421,-3.878015,-2.393699>,
<0.399560,0.905720,-0.141505>,
<-6.312313,-2.994489,0.443723>,
<0.399560,0.905720,-0.141505>
}
smooth_triangle {
<-6.312313,-2.994489,0.443723>,
<0.399561,0.905719,-0.141505>,
<-6.802404,-2.801093,0.297731>,
<0.399561,0.905719,-0.141505>,
<-5.754616,-3.728796,-2.681560>,
<0.399561,0.905719,-0.141505>
}
smooth_triangle {
<-6.943544,-3.293785,0.488095>,
<-0.923339,0.124109,-0.363375>,
<-5.845862,-4.265663,-2.633068>,
<-0.923339,0.124109,-0.363375>,
<-5.754616,-3.728796,-2.681560>,
<-0.923339,0.124109,-0.363375>
}
smooth_triangle {
<-5.754616,-3.728796,-2.681560>,
<-0.923340,0.124107,-0.363375>,
<-6.802404,-2.801093,0.297731>,
<-0.923340,0.124107,-0.363375>,
<-6.943544,-3.293785,0.488095>,
<-0.923340,0.124107,-0.363375>
}
smooth_triangle {
<-6.453454,-3.487177,0.634081>,
<-0.399557,-0.905721,0.141507>,
<-5.405666,-4.414880,-2.345210>,
<-0.399557,-0.905721,0.141507>,
<-5.845862,-4.265663,-2.633068>,
<-0.399557,-0.905721,0.141507>
}
smooth_triangle {
<-5.845862,-4.265663,-2.633068>,
<-0.399554,-0.905722,0.141507>,
<-6.943544,-3.293785,0.488095>,
<-0.399554,-0.905722,0.141507>,
<-6.453454,-3.487177,0.634081>,
<-0.399554,-0.905722,0.141507>
}
smooth_triangle {
<-5.314421,-3.878015,-2.393699>,
<0.833367,0.434535,-0.341584>,
<-6.624324,-1.057141,-2.001006>,
<0.833367,0.434535,-0.341584>,
<-6.852832,-1.007364,-2.495178>,
<0.833367,0.434535,-0.341584>
}
smooth_triangle {
<-6.852832,-1.007364,-2.495178>,
<0.833369,0.434536,-0.341578>,
<-5.477430,-3.969281,-2.907506>,
<0.833369,0.434536,-0.341578>,
<-5.314421,-3.878015,-2.393699>,
<0.833369,0.434536,-0.341578>
}
smooth_triangle {
<-7.058254,-1.212478,-1.706936>,
<0.525021,0.126638,0.841615>,
<-6.624324,-1.057141,-2.001006>,
<0.525021,0.126638,0.841615>,
<-5.314421,-3.878015,-2.393699>,
<0.525021,0.126638,0.841615>
}
smooth_triangle {
<-5.314421,-3.878015,-2.393699>,
<0.525023,0.126640,0.841614>,
<-5.682852,-4.174395,-2.119264>,
<0.525023,0.126640,0.841614>,
<-7.058254,-1.212478,-1.706936>,
<0.525023,0.126640,0.841614>
}
smooth_triangle {
<-5.845862,-4.265663,-2.633068>,
<-0.833370,-0.434535,0.341576>,
<-7.286755,-1.162702,-2.201106>,
<-0.833370,-0.434535,0.341576>,
<-7.058254,-1.212478,-1.706936>,
<-0.833370,-0.434535,0.341576>
}
smooth_triangle {
<-7.058254,-1.212478,-1.706936>,
<-0.833367,-0.434536,0.341581>,
<-5.682852,-4.174395,-2.119264>,
<-0.833367,-0.434536,0.341581>,
<-5.845862,-4.265663,-2.633068>,
<-0.833367,-0.434536,0.341581>
}
smooth_triangle {
<-5.477430,-3.969281,-2.907506>,
<-0.525027,-0.126642,-0.841611>,
<-6.852832,-1.007364,-2.495178>,
<-0.525027,-0.126642,-0.841611>,
<-7.286755,-1.162702,-2.201106>,
<-0.525027,-0.126642,-0.841611>
}
smooth_triangle {
<-7.286755,-1.162702,-2.201106>,
<-0.525025,-0.126641,-0.841612>,
<-5.845862,-4.265663,-2.633068>,
<-0.525025,-0.126641,-0.841612>,
<-5.477430,-3.969281,-2.907506>,
<-0.525025,-0.126641,-0.841612>
}
smooth_triangle {
<-5.633600,3.888058,-1.460690>,
<0.995840,0.088691,0.020901>,
<-5.684868,3.726043,1.669570>,
<0.995840,0.088691,0.020901>,
<-5.734652,4.260206,1.774892>,
<0.995840,0.088691,0.020901>
}
smooth_triangle {
<-5.734652,4.260206,1.774892>,
<0.995840,0.088694,0.020900>,
<-5.680822,4.430320,-1.511881>,
<0.995840,0.088694,0.020900>,
<-5.633600,3.888058,-1.460690>,
<0.995840,0.088694,0.020900>
}
smooth_triangle {
<-6.203568,3.564644,1.731212>,
<0.291970,-0.955384,-0.044667>,
<-5.684868,3.726043,1.669570>,
<0.291970,-0.955384,-0.044667>,
<-5.633600,3.888058,-1.460690>,
<0.291970,-0.955384,-0.044667>
}
smooth_triangle {
<-5.633600,3.888058,-1.460690>,
<0.291972,-0.955383,-0.044666>,
<-6.149738,3.734758,-1.555561>,
<0.291972,-0.955383,-0.044666>,
<-6.203568,3.564644,1.731212>,
<0.291972,-0.955383,-0.044666>
}
smooth_triangle {
<-6.196958,4.277015,-1.606759>,
<-0.995839,-0.088701,-0.020902>,
<-6.253357,4.098801,1.836528>,
<-0.995839,-0.088701,-0.020902>,
<-6.203568,3.564644,1.731212>,
<-0.995839,-0.088701,-0.020902>
}
smooth_triangle {
<-6.203568,3.564644,1.731212>,
<-0.995840,-0.088692,-0.020900>,
<-6.149738,3.734758,-1.555561>,
<-0.995840,-0.088692,-0.020900>,
<-6.196958,4.277015,-1.606759>,
<-0.995840,-0.088692,-0.020900>
}
smooth_triangle {
<-5.680822,4.430320,-1.511881>,
<-0.291977,0.955382,0.044666>,
<-5.734652,4.260206,1.774892>,
<-0.291977,0.955382,0.044666>,
<-6.253357,4.098801,1.836528>,
<-0.291977,0.955382,0.044666>
}
smooth_triangle {
<-6.253357,4.098801,1.836528>,
<-0.291981,0.955381,0.044665>,
<-6.196958,4.277015,-1.606759>,
<-0.291981,0.955381,0.044665>,
<-5.680822,4.430320,-1.511881>,
<-0.291981,0.955381,0.044665>
}
smooth_triangle {
<-5.684868,3.726043,1.669570>,
<0.641444,-0.635150,0.430272>,
<-6.862632,1.377809,-0.040999>,
<0.641444,-0.635150,0.430272>,
<-7.253988,1.217187,0.305326>,
<0.641444,-0.635150,0.430272>
}
smooth_triangle {
<-7.253988,1.217187,0.305326>,
<0.641444,-0.635150,0.430273>,
<-6.017333,3.682839,2.101428>,
<0.641444,-0.635150,0.430273>,
<-5.684868,3.726043,1.669570>,
<0.641444,-0.635150,0.430273>
}
smooth_triangle {
<-7.157542,1.676359,-0.391426>,
<0.786217,0.054088,-0.615579>,
<-6.862632,1.377809,-0.040999>,
<0.786217,0.054088,-0.615579>,
<-5.684868,3.726043,1.669570>,
<0.786217,0.054088,-0.615579>
}
smooth_triangle {
<-5.684868,3.726043,1.669570>,
<0.786217,0.054088,-0.615579>,
<-5.920887,4.142011,1.404676>,
<0.786217,0.054088,-0.615579>,
<-7.157542,1.676359,-0.391426>,
<0.786217,0.054088,-0.615579>
}
smooth_triangle {
<-6.253357,4.098801,1.836528>,
<-0.641441,0.635151,-0.430276>,
<-7.548898,1.515743,-0.045099>,
<-0.641441,0.635151,-0.430276>,
<-7.157542,1.676359,-0.391426>,
<-0.641441,0.635151,-0.430276>
}
smooth_triangle {
<-7.157542,1.676359,-0.391426>,
<-0.641441,0.635151,-0.430276>,
<-5.920887,4.142011,1.404676>,
<-0.641441,0.635151,-0.430276>,
<-6.253357,4.098801,1.836528>,
<-0.641441,0.635151,-0.430276>
}
smooth_triangle {
<-6.017333,3.682839,2.101428>,
<-0.786217,-0.054089,0.615579>,
<-7.253988,1.217187,0.305326>,
<-0.786217,-0.054089,0.615579>,
<-7.548898,1.515743,-0.045099>,
<-0.786217,-0.054089,0.615579>
}
smooth_triangle {
<-7.548898,1.515743,-0.045099>,
<-0.786217,-0.054089,0.615579>,
<-6.253357,4.098801,1.836528>,
<-0.786217,-0.054089,0.615579>,
<-6.017333,3.682839,2.101428>,
<-0.786217,-0.054089,0.615579>
}
smooth_triangle {
<-6.862632,1.377809,-0.040999>,
<0.656215,-0.588435,-0.472362>,
<-5.633600,3.888058,-1.460690>,
<0.656215,-0.588435,-0.472362>,
<-5.951715,3.890221,-1.905316>,
<0.656215,-0.588435,-0.472362>
}
smooth_triangle {
<-5.951715,3.890221,-1.905316>,
<0.656220,-0.588433,-0.472358>,
<-7.242200,1.254455,-0.414645>,
<0.656220,-0.588433,-0.472358>,
<-6.862632,1.377809,-0.040999>,
<0.656220,-0.588433,-0.472358>
}
smooth_triangle {
<-5.878845,4.274857,-1.162126>,
<0.765604,-0.011068,0.643217>,
<-5.633600,3.888058,-1.460690>,
<0.765604,-0.011068,0.643217>,
<-6.862632,1.377809,-0.040999>,
<0.765604,-0.011068,0.643217>
}
smooth_triangle {
<-6.862632,1.377809,-0.040999>,
<0.765600,-0.011064,0.643222>,
<-7.169330,1.639091,0.328545>,
<0.765600,-0.011064,0.643222>,
<-5.878845,4.274857,-1.162126>,
<0.765600,-0.011064,0.643222>
}
smooth_triangle {
<-7.548898,1.515743,-0.045099>,
<-0.656223,0.588434,0.472353>,
<-6.196958,4.277015,-1.606759>,
<-0.656223,0.588434,0.472353>,
<-5.878845,4.274857,-1.162126>,
<-0.656223,0.588434,0.472353>
}
smooth_triangle {
<-5.878845,4.274857,-1.162126>,
<-0.656215,0.588434,0.472364>,
<-7.169330,1.639091,0.328545>,
<-0.656215,0.588434,0.472364>,
<-7.548898,1.515743,-0.045099>,
<-0.656215,0.588434,0.472364>
}
smooth_triangle {
<-7.242200,1.254455,-0.414645>,
<-0.765601,0.011065,-0.643221>,
<-5.951715,3.890221,-1.905316>,
<-0.765601,0.011065,-0.643221>,
<-6.196958,4.277015,-1.606759>,
<-0.765601,0.011065,-0.643221>
}
smooth_triangle {
<-6.196958,4.277015,-1.606759>,
<-0.765601,0.011066,-0.643220>,
<-7.548898,1.515743,-0.045099>,
<-0.765601,0.011066,-0.643220>,
<-7.242200,1.254455,-0.414645>,
<-0.765601,0.011066,-0.643220>
}
smooth_triangle {
<-5.372864,1.788695,4.114299>,
<0.983776,0.163595,-0.073623>,
<-4.816756,-1.183988,4.939704>,
<0.983776,0.163595,-0.073623>,
<-4.788385,-1.111090,5.480790>,
<0.983776,0.163595,-0.073623>
}
smooth_triangle {
<-4.788385,-1.111090,5.480790>,
<0.983776,0.163600,-0.073613>,
<-5.372304,2.010224,4.614120>,
<0.983776,0.163600,-0.073613>,
<-5.372864,1.788695,4.114299>,
<0.983776,0.163600,-0.073613>
}
smooth_triangle {
<-5.326797,-1.375130,4.892580>,
<0.175603,-0.232749,-0.956552>,
<-4.816756,-1.183988,4.939704>,
<0.175603,-0.232749,-0.956552>,
<-5.372864,1.788695,4.114299>,
<0.175603,-0.232749,-0.956552>
}
smooth_triangle {
<-5.372864,1.788695,4.114299>,
<0.175593,-0.232749,-0.956554>,
<-5.910716,1.746184,4.025910>,
<0.175593,-0.232749,-0.956554>,
<-5.326797,-1.375130,4.892580>,
<0.175593,-0.232749,-0.956554>
}
smooth_triangle {
<-5.910149,1.967717,4.525728>,
<-0.983777,-0.163598,0.073615>,
<-5.298430,-1.302234,5.433673>,
<-0.983777,-0.163598,0.073615>,
<-5.326797,-1.375130,4.892580>,
<-0.983777,-0.163598,0.073615>
}
smooth_triangle {
<-5.326797,-1.375130,4.892580>,
<-0.983776,-0.163597,0.073626>,
<-5.910716,1.746184,4.025910>,
<-0.983776,-0.163597,0.073626>,
<-5.910149,1.967717,4.525728>,
<-0.983776,-0.163597,0.073626>
}
smooth_triangle {
<-5.372304,2.010224,4.614120>,
<-0.175590,0.232750,0.956554>,
<-4.788385,-1.111090,5.480790>,
<-0.175590,0.232750,0.956554>,
<-5.298430,-1.302234,5.433673>,
<-0.175590,0.232750,0.956554>
}
smooth_triangle {
<-5.298430,-1.302234,5.433673>,
<-0.175599,0.232750,0.956552>,
<-5.910149,1.967717,4.525728>,
<-0.175599,0.232750,0.956552>,
<-5.372304,2.010224,4.614120>,
<-0.175599,0.232750,0.956552>
}
smooth_triangle {
<-4.816756,-1.183988,4.939704>,
<0.644162,-0.513531,-0.566870>,
<-6.550628,-0.559539,2.403730>,
<0.644162,-0.513531,-0.566870>,
<-6.879845,-0.995520,2.424583>,
<0.644162,-0.513531,-0.566870>
}
smooth_triangle {
<-6.879845,-0.995520,2.424583>,
<0.644162,-0.513531,-0.566870>,
<-5.059278,-1.651189,5.087355>,
<0.644162,-0.513531,-0.566870>,
<-4.816756,-1.183988,4.939704>,
<0.644162,-0.513531,-0.566870>
}
smooth_triangle {
<-6.876471,-0.179362,2.623243>,
<0.649224,0.711566,-0.268668>,
<-6.550628,-0.559539,2.403730>,
<0.649224,0.711566,-0.268668>,
<-4.816756,-1.183988,4.939704>,
<0.649224,0.711566,-0.268668>
}
smooth_triangle {
<-4.816756,-1.183988,4.939704>,
<0.649226,0.711563,-0.268671>,
<-5.055904,-0.835031,5.286015>,
<0.649226,0.711563,-0.268671>,
<-6.876471,-0.179362,2.623243>,
<0.649226,0.711563,-0.268671>
}
smooth_triangle {
<-5.298430,-1.302234,5.433673>,
<-0.644156,0.513540,0.566868>,
<-7.205689,-0.615340,2.644102>,
<-0.644156,0.513540,0.566868>,
<-6.876471,-0.179362,2.623243>,
<-0.644156,0.513540,0.566868>
}
smooth_triangle {
<-6.876471,-0.179362,2.623243>,
<-0.644156,0.513540,0.566868>,
<-5.055904,-0.835031,5.286015>,
<-0.644156,0.513540,0.566868>,
<-5.298430,-1.302234,5.433673>,
<-0.644156,0.513540,0.566868>
}
smooth_triangle {
<-5.059278,-1.651189,5.087355>,
<-0.649223,-0.711567,0.268668>,
<-6.879845,-0.995520,2.424583>,
<-0.649223,-0.711567,0.268668>,
<-7.205689,-0.615340,2.644102>,
<-0.649223,-0.711567,0.268668>
}
smooth_triangle {
<-7.205689,-0.615340,2.644102>,
<-0.649221,-0.711570,0.268665>,
<-5.298430,-1.302234,5.433673>,
<-0.649221,-0.711570,0.268665>,
<-5.059278,-1.651189,5.087355>,
<-0.649221,-0.711570,0.268665>
}
smooth_triangle {
<-6.550628,-0.559539,2.403730>,
<0.483799,0.343664,-0.804881>,
<-5.372864,1.788695,4.114299>,
<0.483799,0.343664,-0.804881>,
<-5.771101,2.153850,4.030838>,
<0.483799,0.343664,-0.804881>
}
smooth_triangle {
<-5.771101,2.153850,4.030838>,
<0.483808,0.343659,-0.804878>,
<-7.007749,-0.311795,2.234736>,
<0.483808,0.343659,-0.804878>,
<-6.550628,-0.559539,2.403730>,
<0.483808,0.343659,-0.804878>
}
smooth_triangle {
<-5.511919,1.602558,4.609192>,
<0.872852,-0.483866,0.063264>,
<-5.372864,1.788695,4.114299>,
<0.872852,-0.483866,0.063264>,
<-6.550628,-0.559539,2.403730>,
<0.872852,-0.483866,0.063264>
}
smooth_triangle {
<-6.550628,-0.559539,2.403730>,
<0.872854,-0.483863,0.063260>,
<-6.748567,-0.863087,2.813090>,
<0.872854,-0.483863,0.063260>,
<-5.511919,1.602558,4.609192>,
<0.872854,-0.483863,0.063260>
}
smooth_triangle {
<-7.205689,-0.615340,2.644102>,
<-0.483809,-0.343657,0.804878>,
<-5.910149,1.967717,4.525728>,
<-0.483809,-0.343657,0.804878>,
<-5.511919,1.602558,4.609192>,
<-0.483809,-0.343657,0.804878>
}
smooth_triangle {
<-5.511919,1.602558,4.609192>,
<-0.483802,-0.343664,0.804880>,
<-6.748567,-0.863087,2.813090>,
<-0.483802,-0.343664,0.804880>,
<-7.205689,-0.615340,2.644102>,
<-0.483802,-0.343664,0.804880>
}
smooth_triangle {
<-7.007749,-0.311795,2.234736>,
<-0.872855,0.483862,-0.063259>,
<-5.771101,2.153850,4.030838>,
<-0.872855,0.483862,-0.063259>,
<-5.910149,1.967717,4.525728>,
<-0.872855,0.483862,-0.063259>
}
smooth_triangle {
<-5.910149,1.967717,4.525728>,
<-0.872853,0.483866,-0.063263>,
<-7.205689,-0.615340,2.644102>,
<-0.872853,0.483866,-0.063263>,
<-7.007749,-0.311795,2.234736>,
<-0.872853,0.483866,-0.063263>
}
smooth_triangle {
<-3.938102,-2.872647,-5.024740>,
<0.094822,-0.027155,0.995124>,
<-1.206345,-4.380622,-5.326188>,
<0.094822,-0.027155,0.995124>,
<-1.398467,-4.892448,-5.321848>,
<0.094822,-0.027155,0.995124>
}
smooth_triangle {
<-1.398467,-4.892448,-5.321848>,
<0.094820,-0.027156,0.995124>,
<-4.266808,-3.309076,-5.005329>,
<0.094820,-0.027156,0.995124>,
<-3.938102,-2.872647,-5.024740>,
<0.094820,-0.027156,0.995124>
}
smooth_triangle {
<-1.134861,-4.306702,-5.863144>,
<0.490516,0.852086,0.182604>,
<-1.206345,-4.380622,-5.326188>,
<0.490516,0.852086,0.182604>,
<-3.938102,-2.872647,-5.024740>,
<0.490516,0.852086,0.182604>
}
smooth_triangle {
<-3.938102,-2.872647,-5.024740>,
<0.490516,0.852086,0.182604>,
<-4.003202,-2.723330,-5.546625>,
<0.490516,0.852086,0.182604>,
<-1.134861,-4.306702,-5.863144>,
<0.490516,0.852086,0.182604>
}
smooth_triangle {
<-4.331913,-3.159759,-5.527215>,
<-0.094820,0.027156,-0.995124>,
<-1.326979,-4.818531,-5.858806>,
<-0.094820,0.027156,-0.995124>,
<-1.134861,-4.306702,-5.863144>,
<-0.094820,0.027156,-0.995124>
}
smooth_triangle {
<-1.134861,-4.306702,-5.863144>,
<-0.094820,0.027158,-0.995124>,
<-4.003202,-2.723330,-5.546625>,
<-0.094820,0.027158,-0.995124>,
<-4.331913,-3.159759,-5.527215>,
<-0.094820,0.027158,-0.995124>
}
smooth_triangle {
<-4.266808,-3.309076,-5.005329>,
<-0.490516,-0.852086,-0.182603>,
<-1.398467,-4.892448,-5.321848>,
<-0.490516,-0.852086,-0.182603>,
<-1.326979,-4.818531,-5.858806>,
<-0.490516,-0.852086,-0.182603>
}
smooth_triangle {
<-1.326979,-4.818531,-5.858806>,
<-0.490515,-0.852087,-0.182599>,
<-4.331913,-3.159759,-5.527215>,
<-0.490515,-0.852087,-0.182599>,
<-4.266808,-3.309076,-5.005329>,
<-0.490515,-0.852087,-0.182599>
}
smooth_triangle {
<0.022687,-1.870373,-6.745879>,
<0.436094,0.669879,0.600902>,
<-2.709077,-0.362398,-6.444424>,
<0.436094,0.669879,0.600902>,
<-2.655828,-0.018684,-6.866237>,
<0.436094,0.669879,0.600902>
}
smooth_triangle {
<-2.655828,-0.018684,-6.866237>,
<0.436092,0.669876,0.600907>,
<0.212527,-1.602056,-7.182763>,
<0.436092,0.669876,0.600907>,
<0.022687,-1.870373,-6.745879>,
<0.436092,0.669876,0.600907>
}
smooth_triangle {
<-3.033240,-0.742204,-6.667059>,
<-0.130430,-0.416172,0.899883>,
<-2.709077,-0.362398,-6.444424>,
<-0.130430,-0.416172,0.899883>,
<0.022687,-1.870373,-6.745879>,
<-0.130430,-0.416172,0.899883>
}
smooth_triangle {
<0.022687,-1.870373,-6.745879>,
<-0.130430,-0.416172,0.899883>,
<-0.164885,-2.325576,-6.983585>,
<-0.130430,-0.416172,0.899883>,
<-3.033240,-0.742204,-6.667059>,
<-0.130430,-0.416172,0.899883>
}
smooth_triangle {
<0.024956,-2.057258,-7.420468>,
<-0.436090,-0.669868,-0.600917>,
<-2.979984,-0.398485,-7.088865>,
<-0.436090,-0.669868,-0.600917>,
<-3.033240,-0.742204,-6.667059>,
<-0.436090,-0.669868,-0.600917>
}
smooth_triangle {
<-3.033240,-0.742204,-6.667059>,
<-0.436091,-0.669875,-0.600910>,
<-0.164885,-2.325576,-6.983585>,
<-0.436091,-0.669875,-0.600910>,
<0.024956,-2.057258,-7.420468>,
<-0.436091,-0.669875,-0.600910>
}
smooth_triangle {
<0.212527,-1.602056,-7.182763>,
<0.130427,0.416168,-0.899885>,
<-2.655828,-0.018684,-6.866237>,
<0.130427,0.416168,-0.899885>,
<-2.979984,-0.398485,-7.088865>,
<0.130427,0.416168,-0.899885>
}
smooth_triangle {
<-2.979984,-0.398485,-7.088865>,
<0.130429,0.416172,-0.899883>,
<0.024956,-2.057258,-7.420468>,
<0.130429,0.416172,-0.899883>,
<0.212527,-1.602056,-7.182763>,
<0.130429,0.416172,-0.899883>
}
smooth_triangle {
<-1.206345,-4.380622,-5.326188>,
<-0.500243,0.646421,0.576105>,
<-0.894334,-6.317963,-2.881459>,
<-0.500243,0.646421,0.576105>,
<-1.351931,-6.608498,-2.952803>,
<-0.500243,0.646421,0.576105>
}
smooth_triangle {
<-1.351931,-6.608498,-2.952803>,
<-0.500240,0.646423,0.576106>,
<-1.679545,-4.574291,-5.519766>,
<-0.500240,0.646423,0.576106>,
<-1.206345,-4.380622,-5.326188>,
<-0.500240,0.646423,0.576106>
}
smooth_triangle {
<-0.526169,-6.659066,-3.098263>,
<0.739264,0.570521,0.357764>,
<-0.894334,-6.317963,-2.881459>,
<0.739264,0.570521,0.357764>,
<-1.206345,-4.380622,-5.326188>,
<0.739264,0.570521,0.357764>
}
smooth_triangle {
<-1.206345,-4.380622,-5.326188>,
<0.739266,0.570520,0.357762>,
<-0.853783,-4.624859,-5.665226>,
<0.739266,0.570520,0.357762>,
<-0.526169,-6.659066,-3.098263>,
<0.739266,0.570520,0.357762>
}
smooth_triangle {
<-1.326979,-4.818531,-5.858806>,
<0.500245,-0.646420,-0.576104>,
<-0.983767,-6.949606,-3.169605>,
<0.500245,-0.646420,-0.576104>,
<-0.526169,-6.659066,-3.098263>,
<0.500245,-0.646420,-0.576104>
}
smooth_triangle {
<-0.526169,-6.659066,-3.098263>,
<0.500247,-0.646419,-0.576104>,
<-0.853783,-4.624859,-5.665226>,
<0.500247,-0.646419,-0.576104>,
<-1.326979,-4.818531,-5.858806>,
<0.500247,-0.646419,-0.576104>
}
smooth_triangle {
<-1.679545,-4.574291,-5.519766>,
<-0.739268,-0.570518,-0.357760>,
<-1.351931,-6.608498,-2.952803>,
<-0.739268,-0.570518,-0.357760>,
<-0.983767,-6.949606,-3.169605>,
<-0.739268,-0.570518,-0.357760>
}
smooth_triangle {
<-0.983767,-6.949606,-3.169605>,
<-0.739265,-0.570520,-0.357763>,
<-1.326979,-4.818531,-5.858806>,
<-0.739265,-0.570520,-0.357763>,
<-1.679545,-4.574291,-5.519766>,
<-0.739265,-0.570520,-0.357763>
}
smooth_triangle {
<-0.894334,-6.317963,-2.881459>,
<-0.025123,0.430323,0.902325>,
<2.215850,-5.937044,-2.976526>,
<-0.025123,0.430323,0.902325>,
<2.359994,-6.411490,-2.746247>,
<-0.025123,0.430323,0.902325>
}
smooth_triangle {
<2.359994,-6.411490,-2.746247>,
<-0.025123,0.430327,0.902323>,
<-0.905702,-6.811449,-2.646427>,
<-0.025123,0.430327,0.902323>,
<-0.894334,-6.317963,-2.881459>,
<-0.025123,0.430327,0.902323>
}
smooth_triangle {
<2.293298,-6.056156,-3.504459>,
<-0.125236,0.963698,-0.235801>,
<2.215850,-5.937044,-2.976526>,
<-0.125236,0.963698,-0.235801>,
<-0.894334,-6.317963,-2.881459>,
<-0.125236,0.963698,-0.235801>
}
smooth_triangle {
<-0.894334,-6.317963,-2.881459>,
<-0.125234,0.963701,-0.235791>,
<-0.972398,-6.456115,-3.404639>,
<-0.125234,0.963701,-0.235791>,
<2.293298,-6.056156,-3.504459>,
<-0.125234,0.963701,-0.235791>
}
smooth_triangle {
<-0.983767,-6.949606,-3.169605>,
<0.025123,-0.430328,-0.902323>,
<2.437436,-6.530598,-3.274180>,
<0.025123,-0.430328,-0.902323>,
<2.293298,-6.056156,-3.504459>,
<0.025123,-0.430328,-0.902323>
}
smooth_triangle {
<2.293298,-6.056156,-3.504459>,
<0.025123,-0.430327,-0.902324>,
<-0.972398,-6.456115,-3.404639>,
<0.025123,-0.430327,-0.902324>,
<-0.983767,-6.949606,-3.169605>,
<0.025123,-0.430327,-0.902324>
}
smooth_triangle {
<-0.905702,-6.811449,-2.646427>,
<0.125234,-0.963700,0.235792>,
<2.359994,-6.411490,-2.746247>,
<0.125234,-0.963700,0.235792>,
<2.437436,-6.530598,-3.274180>,
<0.125234,-0.963700,0.235792>
}
smooth_triangle {
<2.437436,-6.530598,-3.274180>,
<0.125236,-0.963698,0.235800>,
<-0.983767,-6.949606,-3.169605>,
<0.125236,-0.963698,0.235800>,
<-0.905702,-6.811449,-2.646427>,
<0.125236,-0.963698,0.235800>
}
smooth_triangle {
<2.215850,-5.937044,-2.976526>,
<0.363359,0.752192,0.549707>,
<1.903839,-3.999696,-5.421255>,
<0.363359,0.752192,0.549707>,
<2.397241,-4.074981,-5.644380>,
<0.363359,0.752192,0.549707>
}
smooth_triangle {
<2.397241,-4.074981,-5.644380>,
<0.363367,0.752189,0.549706>,
<2.724855,-6.109202,-3.077417>,
<0.363367,0.752189,0.549706>,
<2.215850,-5.937044,-2.976526>,
<0.363367,0.752189,0.549706>
}
smooth_triangle {
<1.600823,-4.324223,-5.740252>,
<-0.832103,0.378064,0.405798>,
<1.903839,-3.999696,-5.421255>,
<-0.832103,0.378064,0.405798>,
<2.215850,-5.937044,-2.976526>,
<-0.832103,0.378064,0.405798>
}
smooth_triangle {
<2.215850,-5.937044,-2.976526>,
<-0.832108,0.378057,0.405795>,
<1.928437,-6.358444,-3.173289>,
<-0.832108,0.378057,0.405795>,
<1.600823,-4.324223,-5.740252>,
<-0.832108,0.378057,0.405795>
}
smooth_triangle {
<2.437436,-6.530598,-3.274180>,
<-0.363374,-0.752188,-0.549702>,
<2.094224,-4.399515,-5.963383>,
<-0.363374,-0.752188,-0.549702>,
<1.600823,-4.324223,-5.740252>,
<-0.363374,-0.752188,-0.549702>
}
smooth_triangle {
<1.600823,-4.324223,-5.740252>,
<-0.363365,-0.752189,-0.549706>,
<1.928437,-6.358444,-3.173289>,
<-0.363365,-0.752189,-0.549706>,
<2.437436,-6.530598,-3.274180>,
<-0.363365,-0.752189,-0.549706>
}
smooth_triangle {
<2.724855,-6.109202,-3.077417>,
<0.832107,-0.378058,-0.405796>,
<2.397241,-4.074981,-5.644380>,
<0.832107,-0.378058,-0.405796>,
<2.094224,-4.399515,-5.963383>,
<0.832107,-0.378058,-0.405796>
}
smooth_triangle {
<2.094224,-4.399515,-5.963383>,
<0.832101,-0.378067,-0.405800>,
<2.437436,-6.530598,-3.274180>,
<0.832101,-0.378067,-0.405800>,
<2.724855,-6.109202,-3.077417>,
<0.832101,-0.378067,-0.405800>
}
smooth_triangle {
<-0.721847,-6.961844,0.181720>,
<-0.077343,0.784911,0.614762>,
<2.388337,-6.580918,0.086653>,
<-0.077343,0.784911,0.614762>,
<2.519391,-6.900139,0.510713>,
<-0.077343,0.784911,0.614762>
}
smooth_triangle {
<2.519391,-6.900139,0.510713>,
<-0.077343,0.784910,0.614763>,
<-0.746305,-7.300112,0.610533>,
<-0.077343,0.784910,0.614763>,
<-0.721847,-6.961844,0.181720>,
<-0.077343,0.784910,0.614763>
}
smooth_triangle {
<2.496123,-6.919641,-0.328741>,
<-0.112272,0.755636,-0.645298>,
<2.388337,-6.580918,0.086653>,
<-0.112272,0.755636,-0.645298>,
<-0.721847,-6.961844,0.181720>,
<-0.112272,0.755636,-0.645298>
}
smooth_triangle {
<-0.721847,-6.961844,0.181720>,
<-0.112272,0.755636,-0.645298>,
<-0.769573,-7.319614,-0.228921>,
<-0.112272,0.755636,-0.645298>,
<2.496123,-6.919641,-0.328741>,
<-0.112272,0.755636,-0.645298>
}
smooth_triangle {
<-0.794032,-7.657875,0.199892>,
<0.077342,-0.784913,-0.614760>,
<2.627172,-7.238860,0.095318>,
<0.077342,-0.784913,-0.614760>,
<2.496123,-6.919641,-0.328741>,
<0.077342,-0.784913,-0.614760>
}
smooth_triangle {
<2.496123,-6.919641,-0.328741>,
<0.077344,-0.784917,-0.614755>,
<-0.769573,-7.319614,-0.228921>,
<0.077344,-0.784917,-0.614755>,
<-0.794032,-7.657875,0.199892>,
<0.077344,-0.784917,-0.614755>
}
smooth_triangle {
<-0.746305,-7.300112,0.610533>,
<0.112273,-0.755639,0.645294>,
<2.519391,-6.900139,0.510713>,
<0.112273,-0.755639,0.645294>,
<2.627172,-7.238860,0.095318>,
<0.112273,-0.755639,0.645294>
}
smooth_triangle {
<2.627172,-7.238860,0.095318>,
<0.112272,-0.755643,0.645290>,
<-0.794032,-7.657875,0.199892>,
<0.112272,-0.755643,0.645290>,
<-0.746305,-7.300112,0.610533>,
<0.112272,-0.755643,0.645290>
}
smooth_triangle {
<-1.719739,-6.078311,3.019142>,
<0.725808,0.686648,0.041447>,
<-0.721847,-6.961844,0.181720>,
<0.725808,0.686648,0.041447>,
<-0.366947,-7.346522,0.339731>,
<0.725808,0.686648,0.041447>
}
smooth_triangle {
<-0.366947,-7.346522,0.339731>,
<0.725804,0.686652,0.041443>,
<-1.414735,-6.418805,3.319022>,
<0.725804,0.686652,0.041443>,
<-1.719739,-6.078311,3.019142>,
<0.725804,0.686652,0.041443>
}
smooth_triangle {
<-1.148931,-7.273204,0.041881>,
<-0.448010,0.796706,-0.405643>,
<-0.721847,-6.961844,0.181720>,
<-0.448010,0.796706,-0.405643>,
<-1.719739,-6.078311,3.019142>,
<-0.448010,0.796706,-0.405643>
}
smooth_triangle {
<-1.719739,-6.078311,3.019142>,
<-0.447998,0.796713,-0.405644>,
<-2.196719,-6.345487,3.021172>,
<-0.447998,0.796713,-0.405644>,
<-1.148931,-7.273204,0.041881>,
<-0.447998,0.796713,-0.405644>
}
smooth_triangle {
<-1.891712,-6.685988,3.321055>,
<-0.725803,-0.686653,-0.041443>,
<-0.794032,-7.657875,0.199892>,
<-0.725803,-0.686653,-0.041443>,
<-1.148931,-7.273204,0.041881>,
<-0.725803,-0.686653,-0.041443>
}
smooth_triangle {
<-1.148931,-7.273204,0.041881>,
<-0.725807,-0.686649,-0.041445>,
<-2.196719,-6.345487,3.021172>,
<-0.725807,-0.686649,-0.041445>,
<-1.891712,-6.685988,3.321055>,
<-0.725807,-0.686649,-0.041445>
}
smooth_triangle {
<-1.414735,-6.418805,3.319022>,
<0.448000,-0.796712,0.405644>,
<-0.366947,-7.346522,0.339731>,
<0.448000,-0.796712,0.405644>,
<-0.794032,-7.657875,0.199892>,
<0.448000,-0.796712,0.405644>
}
smooth_triangle {
<-0.794032,-7.657875,0.199892>,
<0.448010,-0.796706,0.405644>,
<-1.891712,-6.685988,3.321055>,
<0.448010,-0.796706,0.405644>,
<-1.414735,-6.418805,3.319022>,
<0.448010,-0.796706,0.405644>
}
smooth_triangle {
<-3.433269,-6.007338,-1.069075>,
<-0.027080,0.951690,-0.305864>,
<-4.431161,-5.123812,1.768347>,
<-0.027080,0.951690,-0.305864>,
<-4.968824,-5.167667,1.679496>,
<-0.027080,0.951690,-0.305864>
}
smooth_triangle {
<-4.968824,-5.167667,1.679496>,
<-0.027082,0.951690,-0.305865>,
<-3.921036,-6.095370,-1.299795>,
<-0.027082,0.951690,-0.305865>,
<-3.433269,-6.007338,-1.069075>,
<-0.027082,0.951690,-0.305865>
}
smooth_triangle {
<-4.336612,-5.592189,2.034032>,
<0.921899,0.314468,0.226302>,
<-4.431161,-5.123812,1.768347>,
<0.921899,0.314468,0.226302>,
<-3.433269,-6.007338,-1.069075>,
<0.921899,0.314468,0.226302>
}
smooth_triangle {
<-3.433269,-6.007338,-1.069075>,
<0.921898,0.314471,0.226301>,
<-3.288824,-6.519892,-0.945259>,
<0.921898,0.314471,0.226301>,
<-4.336612,-5.592189,2.034032>,
<0.921898,0.314471,0.226301>
}
smooth_triangle {
<-3.776595,-6.607918,-1.175982>,
<0.027070,-0.951691,0.305861>,
<-4.874275,-5.636038,1.945181>,
<0.027070,-0.951691,0.305861>,
<-4.336612,-5.592189,2.034032>,
<0.027070,-0.951691,0.305861>
}
smooth_triangle {
<-4.336612,-5.592189,2.034032>,
<0.027070,-0.951691,0.305861>,
<-3.288824,-6.519892,-0.945259>,
<0.027070,-0.951691,0.305861>,
<-3.776595,-6.607918,-1.175982>,
<0.027070,-0.951691,0.305861>
}
smooth_triangle {
<-3.921036,-6.095370,-1.299795>,
<-0.921898,-0.314471,-0.226301>,
<-4.968824,-5.167667,1.679496>,
<-0.921898,-0.314471,-0.226301>,
<-4.874275,-5.636038,1.945181>,
<-0.921898,-0.314471,-0.226301>
}
smooth_triangle {
<-4.874275,-5.636038,1.945181>,
<-0.921899,-0.314467,-0.226302>,
<-3.776595,-6.607918,-1.175982>,
<-0.921899,-0.314467,-0.226302>,
<-3.921036,-6.095370,-1.299795>,
<-0.921899,-0.314467,-0.226302>
}
smooth_triangle {
<-3.506853,-4.004862,4.547011>,
<-0.062819,0.908432,-0.413285>,
<-1.013404,-3.077887,6.205570>,
<-0.062819,0.908432,-0.413285>,
<-1.277248,-2.894830,6.648047>,
<-0.062819,0.908432,-0.413285>
}
smooth_triangle {
<-1.277248,-2.894830,6.648047>,
<-0.062816,0.908431,-0.413288>,
<-3.895367,-3.868152,4.906559>,
<-0.062816,0.908431,-0.413288>,
<-3.506853,-4.004862,4.547011>,
<-0.062816,0.908431,-0.413288>
}
smooth_triangle {
<-0.850906,-3.568580,6.383657>,
<0.577133,-0.102900,-0.810141>,
<-1.013404,-3.077887,6.205570>,
<0.577133,-0.102900,-0.810141>,
<-3.506853,-4.004862,4.547011>,
<0.577133,-0.102900,-0.810141>
}
smooth_triangle {
<-3.506853,-4.004862,4.547011>,
<0.577133,-0.102897,-0.810142>,
<-3.469025,-4.541902,4.642169>,
<0.577133,-0.102897,-0.810142>,
<-0.850906,-3.568580,6.383657>,
<0.577133,-0.102897,-0.810142>
}
smooth_triangle {
<-3.857538,-4.405195,5.001711>,
<0.062816,-0.908431,0.413288>,
<-1.114745,-3.385523,6.826128>,
<0.062816,-0.908431,0.413288>,
<-0.850906,-3.568580,6.383657>,
<0.062816,-0.908431,0.413288>
}
smooth_triangle {
<-0.850906,-3.568580,6.383657>,
<0.062817,-0.908431,0.413287>,
<-3.469025,-4.541902,4.642169>,
<0.062817,-0.908431,0.413287>,
<-3.857538,-4.405195,5.001711>,
<0.062817,-0.908431,0.413287>
}
smooth_triangle {
<-3.895367,-3.868152,4.906559>,
<-0.577131,0.102886,0.810145>,
<-1.277248,-2.894830,6.648047>,
<-0.577131,0.102886,0.810145>,
<-1.114745,-3.385523,6.826128>,
<-0.577131,0.102886,0.810145>
}
smooth_triangle {
<-1.114745,-3.385523,6.826128>,
<-0.577131,0.102887,0.810144>,
<-3.857538,-4.405195,5.001711>,
<-0.577131,0.102887,0.810144>,
<-3.895367,-3.868152,4.906559>,
<-0.577131,0.102887,0.810144>
}
smooth_triangle {
<0.773710,-5.151343,4.677701>,
<0.433419,0.332691,-0.837535>,
<-1.719739,-6.078311,3.019142>,
<0.433419,0.332691,-0.837535>,
<-1.552838,-6.586000,2.903845>,
<0.433419,0.332691,-0.837535>
}
smooth_triangle {
<-1.552838,-6.586000,2.903845>,
<0.433421,0.332687,-0.837535>,
<1.065281,-5.612685,4.645333>,
<0.433421,0.332687,-0.837535>,
<0.773710,-5.151343,4.677701>,
<0.433421,0.332687,-0.837535>
}
smooth_triangle {
<-2.058616,-6.178292,3.436349>,
<-0.325770,0.944676,-0.038222>,
<-1.719739,-6.078311,3.019142>,
<-0.325770,0.944676,-0.038222>,
<0.773710,-5.151343,4.677701>,
<-0.325770,0.944676,-0.038222>
}
smooth_triangle {
<0.773710,-5.151343,4.677701>,
<-0.325771,0.944676,-0.038221>,
<0.559503,-5.204977,5.177837>,
<-0.325771,0.944676,-0.038221>,
<-2.058616,-6.178292,3.436349>,
<-0.325771,0.944676,-0.038221>
}
smooth_triangle {
<0.851081,-5.666323,5.145470>,
<-0.433422,-0.332684,0.837536>,
<-1.891712,-6.685988,3.321055>,
<-0.433422,-0.332684,0.837536>,
<-2.058616,-6.178292,3.436349>,
<-0.433422,-0.332684,0.837536>
}
smooth_triangle {
<-2.058616,-6.178292,3.436349>,
<-0.433420,-0.332689,0.837535>,
<0.559503,-5.204977,5.177837>,
<-0.433420,-0.332689,0.837535>,
<0.851081,-5.666323,5.145470>,
<-0.433420,-0.332689,0.837535>
}
smooth_triangle {
<1.065281,-5.612685,4.645333>,
<0.325777,-0.944674,0.038210>,
<-1.552838,-6.586000,2.903845>,
<0.325777,-0.944674,0.038210>,
<-1.891712,-6.685988,3.321055>,
<0.325777,-0.944674,0.038210>
}
smooth_triangle {
<-1.891712,-6.685988,3.321055>,
<0.325776,-0.944674,0.038212>,
<0.851081,-5.666323,5.145470>,
<0.325776,-0.944674,0.038212>,
<1.065281,-5.612685,4.645333>,
<0.325776,-0.944674,0.038212>
}
smooth_triangle {
<2.096780,-2.696968,6.110496>,
<-0.183053,0.893707,-0.409609>,
<4.635708,-3.007593,4.298119>,
<-0.183053,0.893707,-0.409609>,
<5.000702,-2.778602,4.634630>,
<-0.183053,0.893707,-0.409609>
}
smooth_triangle {
<5.000702,-2.778602,4.634630>,
<-0.183053,0.893707,-0.409609>,
<2.334829,-2.452444,6.537629>,
<-0.183053,0.893707,-0.409609>,
<2.096780,-2.696968,6.110496>,
<-0.183053,0.893707,-0.409609>
}
smooth_triangle {
<4.734282,-3.537192,4.391422>,
<-0.582967,-0.244988,-0.774680>,
<4.635708,-3.007593,4.298119>,
<-0.582967,-0.244988,-0.774680>,
<2.096780,-2.696968,6.110496>,
<-0.582967,-0.244988,-0.774680>
}
smooth_triangle {
<2.096780,-2.696968,6.110496>,
<-0.582968,-0.244994,-0.774678>,
<2.068409,-3.211034,6.294421>,
<-0.582968,-0.244994,-0.774678>,
<4.734282,-3.537192,4.391422>,
<-0.582968,-0.244994,-0.774678>
}
smooth_triangle {
<2.306459,-2.966513,6.721548>,
<0.183052,-0.893708,0.409608>,
<5.099281,-3.308201,4.727933>,
<0.183052,-0.893708,0.409608>,
<4.734282,-3.537192,4.391422>,
<0.183052,-0.893708,0.409608>
}
smooth_triangle {
<4.734282,-3.537192,4.391422>,
<0.183052,-0.893708,0.409608>,
<2.068409,-3.211034,6.294421>,
<0.183052,-0.893708,0.409608>,
<2.306459,-2.966513,6.721548>,
<0.183052,-0.893708,0.409608>
}
smooth_triangle {
<2.334829,-2.452444,6.537629>,
<0.582968,0.244993,0.774678>,
<5.000702,-2.778602,4.634630>,
<0.582968,0.244993,0.774678>,
<5.099281,-3.308201,4.727933>,
<0.582968,0.244993,0.774678>
}
smooth_triangle {
<5.099281,-3.308201,4.727933>,
<0.582968,0.244986,0.774681>,
<2.306459,-2.966513,6.721548>,
<0.582968,0.244986,0.774681>,
<2.334829,-2.452444,6.537629>,
<0.582968,0.244986,0.774681>
}
smooth_triangle {
<3.312645,-5.461968,2.865317>,
<-0.550435,0.212196,-0.807462>,
<0.773710,-5.151343,4.677701>,
<-0.550435,0.212196,-0.807462>,
<0.600565,-5.669602,4.659536>,
<-0.550435,0.212196,-0.807462>
}
smooth_triangle {
<0.600565,-5.669602,4.659536>,
<-0.550435,0.212184,-0.807464>,
<3.266452,-5.995760,2.756537>,
<-0.550435,0.212184,-0.807464>,
<3.312645,-5.461968,2.865317>,
<-0.550435,0.212184,-0.807464>
}
smooth_triangle {
<1.024219,-5.148060,5.163634>,
<0.085482,0.995044,-0.050791>,
<0.773710,-5.151343,4.677701>,
<0.085482,0.995044,-0.050791>,
<3.312645,-5.461968,2.865317>,
<0.085482,0.995044,-0.050791>
}
smooth_triangle {
<3.312645,-5.461968,2.865317>,
<0.085484,0.995044,-0.050789>,
<3.690106,-5.474218,3.260635>,
<0.085484,0.995044,-0.050789>,
<1.024219,-5.148060,5.163634>,
<0.085484,0.995044,-0.050789>
}
smooth_triangle {
<3.643910,-6.008013,3.151849>,
<0.550436,-0.212187,0.807463>,
<0.851081,-5.666323,5.145470>,
<0.550436,-0.212187,0.807463>,
<1.024219,-5.148060,5.163634>,
<0.550436,-0.212187,0.807463>
}
smooth_triangle {
<1.024219,-5.148060,5.163634>,
<0.550433,-0.212194,0.807463>,
<3.690106,-5.474218,3.260635>,
<0.550433,-0.212194,0.807463>,
<3.643910,-6.008013,3.151849>,
<0.550433,-0.212194,0.807463>
}
smooth_triangle {
<3.266452,-5.995760,2.756537>,
<-0.085486,-0.995044,0.050786>,
<0.600565,-5.669602,4.659536>,
<-0.085486,-0.995044,0.050786>,
<0.851081,-5.666323,5.145470>,
<-0.085486,-0.995044,0.050786>
}
smooth_triangle {
<0.851081,-5.666323,5.145470>,
<-0.085488,-0.995044,0.050784>,
<3.643910,-6.008013,3.151849>,
<-0.085488,-0.995044,0.050784>,
<3.266452,-5.995760,2.756537>,
<-0.085488,-0.995044,0.050784>
}
smooth_triangle {
<1.903839,-3.999696,-5.421255>,
<-0.025419,-0.041879,0.998799>,
<4.204459,-1.875371,-5.273632>,
<-0.025419,-0.041879,0.998799>,
<4.629254,-2.219519,-5.277251>,
<-0.025419,-0.041879,0.998799>
}
smooth_triangle {
<4.629254,-2.219519,-5.277251>,
<-0.025422,-0.041875,0.998799>,
<2.213603,-4.450055,-5.432252>,
<-0.025422,-0.041875,0.998799>,
<1.903839,-3.999696,-5.421255>,
<-0.025422,-0.041875,0.998799>
}
smooth_triangle {
<4.200112,-1.718613,-5.797379>,
<-0.669587,0.710002,0.218062>,
<4.204459,-1.875371,-5.273632>,
<-0.669587,0.710002,0.218062>,
<1.903839,-3.999696,-5.421255>,
<-0.669587,0.710002,0.218062>
}
smooth_triangle {
<1.903839,-3.999696,-5.421255>,
<-0.669585,0.710001,0.218069>,
<1.784461,-3.949149,-5.952380>,
<-0.669585,0.710001,0.218069>,
<4.200112,-1.718613,-5.797379>,
<-0.669585,0.710001,0.218069>
}
smooth_triangle {
<2.094224,-4.399515,-5.963383>,
<0.025420,0.041879,-0.998799>,
<4.624907,-2.062756,-5.800997>,
<0.025420,0.041879,-0.998799>,
<4.200112,-1.718613,-5.797379>,
<0.025420,0.041879,-0.998799>
}
smooth_triangle {
<4.200112,-1.718613,-5.797379>,
<0.025416,0.041882,-0.998799>,
<1.784461,-3.949149,-5.952380>,
<0.025416,0.041882,-0.998799>,
<2.094224,-4.399515,-5.963383>,
<0.025416,0.041882,-0.998799>
}
smooth_triangle {
<2.213603,-4.450055,-5.432252>,
<0.669585,-0.710001,-0.218069>,
<4.629254,-2.219519,-5.277251>,
<0.669585,-0.710001,-0.218069>,
<4.624907,-2.062756,-5.800997>,
<0.669585,-0.710001,-0.218069>
}
smooth_triangle {
<4.624907,-2.062756,-5.800997>,
<0.669587,-0.710002,-0.218061>,
<2.094224,-4.399515,-5.963383>,
<0.669587,-0.710002,-0.218061>,
<2.213603,-4.450055,-5.432252>,
<0.669587,-0.710002,-0.218061>
}
smooth_triangle {
<4.204459,-1.875371,-5.273632>,
<0.032815,0.548676,0.835391>,
<2.323307,0.253952,-6.598256>,
<0.032815,0.548676,0.835391>,
<2.708741,0.570919,-6.821577>,
<0.032815,0.548676,0.835391>
}
smooth_triangle {
<2.708741,0.570919,-6.821577>,
<0.032824,0.548680,0.835388>,
<4.683952,-1.664874,-5.430726>,
<0.032824,0.548680,0.835388>,
<4.204459,-1.875371,-5.273632>,
<0.032824,0.548680,0.835388>
}
smooth_triangle {
<2.170203,-0.037465,-7.034755>,
<-0.775549,-0.364536,0.515400>,
<2.323307,0.253952,-6.598256>,
<-0.775549,-0.364536,0.515400>,
<4.204459,-1.875371,-5.273632>,
<-0.775549,-0.364536,0.515400>
}
smooth_triangle {
<4.204459,-1.875371,-5.273632>,
<-0.775549,-0.364538,0.515398>,
<4.145414,-2.273258,-5.643904>,
<-0.775549,-0.364538,0.515398>,
<2.170203,-0.037465,-7.034755>,
<-0.775549,-0.364538,0.515398>
}
smooth_triangle {
<4.624907,-2.062756,-5.800997>,
<-0.032824,-0.548681,-0.835388>,
<2.555638,0.279500,-7.258081>,
<-0.032824,-0.548681,-0.835388>,
<2.170203,-0.037465,-7.034755>,
<-0.032824,-0.548681,-0.835388>
}
smooth_triangle {
<2.170203,-0.037465,-7.034755>,
<-0.032820,-0.548677,-0.835390>,
<4.145414,-2.273258,-5.643904>,
<-0.032820,-0.548677,-0.835390>,
<4.624907,-2.062756,-5.800997>,
<-0.032820,-0.548677,-0.835390>
}
smooth_triangle {
<4.683952,-1.664874,-5.430726>,
<0.775550,0.364539,-0.515397>,
<2.708741,0.570919,-6.821577>,
<0.775550,0.364539,-0.515397>,
<2.555638,0.279500,-7.258081>,
<0.775550,0.364539,-0.515397>
}
smooth_triangle {
<2.555638,0.279500,-7.258081>,
<0.775550,0.364540,-0.515396>,
<4.624907,-2.062756,-5.800997>,
<0.775550,0.364540,-0.515396>,
<4.683952,-1.664874,-5.430726>,
<0.775550,0.364540,-0.515396>
}
smooth_triangle {
<2.323307,0.253952,-6.598256>,
<-0.547764,0.549374,0.630985>,
<0.022687,-1.870373,-6.745879>,
<-0.547764,0.549374,0.630985>,
<-0.252182,-1.658973,-7.168553>,
<-0.547764,0.549374,0.630985>
}
smooth_triangle {
<-0.252182,-1.658973,-7.168553>,
<-0.547762,0.549370,0.630990>,
<2.163469,0.571570,-7.013545>,
<-0.547762,0.549370,0.630990>,
<2.323307,0.253952,-6.598256>,
<-0.547762,0.549370,0.630990>
}
smooth_triangle {
<0.299824,-2.268659,-6.997795>,
<0.280840,-0.365807,0.887307>,
<0.022687,-1.870373,-6.745879>,
<0.280840,-0.365807,0.887307>,
<2.323307,0.253952,-6.598256>,
<0.280840,-0.365807,0.887307>
}
smooth_triangle {
<2.323307,0.253952,-6.598256>,
<0.280836,-0.365804,0.887310>,
<2.715475,-0.038116,-6.842787>,
<0.280836,-0.365804,0.887310>,
<0.299824,-2.268659,-6.997795>,
<0.280836,-0.365804,0.887310>
}
smooth_triangle {
<2.555638,0.279500,-7.258081>,
<0.547764,-0.549373,-0.630986>,
<0.024956,-2.057258,-7.420468>,
<0.547764,-0.549373,-0.630986>,
<0.299824,-2.268659,-6.997795>,
<0.547764,-0.549373,-0.630986>
}
smooth_triangle {
<0.299824,-2.268659,-6.997795>,
<0.547766,-0.549375,-0.630983>,
<2.715475,-0.038116,-6.842787>,
<0.547766,-0.549375,-0.630983>,
<2.555638,0.279500,-7.258081>,
<0.547766,-0.549375,-0.630983>
}
smooth_triangle {
<2.163469,0.571570,-7.013545>,
<-0.280839,0.365807,-0.887308>,
<-0.252182,-1.658973,-7.168553>,
<-0.280839,0.365807,-0.887308>,
<0.024956,-2.057258,-7.420468>,
<-0.280839,0.365807,-0.887308>
}
smooth_triangle {
<0.024956,-2.057258,-7.420468>,
<-0.280841,0.365808,-0.887307>,
<2.555638,0.279500,-7.258081>,
<-0.280841,0.365808,-0.887307>,
<2.163469,0.571570,-7.013545>,
<-0.280841,0.365808,-0.887307>
}
smooth_triangle {
<5.938331,-2.499820,-2.737658>,
<-0.842579,-0.340401,0.417357>,
<6.862639,-1.380870,0.041006>,
<-0.842579,-0.340401,0.417357>,
<7.129605,-1.823571,0.218897>,
<-0.842579,-0.340401,0.417357>
}
smooth_triangle {
<7.129605,-1.823571,0.218897>,
<-0.842579,-0.340403,0.417357>,
<6.159083,-2.998472,-2.698703>,
<-0.842579,-0.340403,0.417357>,
<5.938331,-2.499820,-2.737658>,
<-0.842579,-0.340403,0.417357>
}
smooth_triangle {
<7.281939,-1.076097,-0.132783>,
<-0.613919,0.781593,-0.110525>,
<6.862639,-1.380870,0.041006>,
<-0.613919,0.781593,-0.110525>,
<5.938331,-2.499820,-2.737658>,
<-0.613919,0.781593,-0.110525>
}
smooth_triangle {
<5.938331,-2.499820,-2.737658>,
<-0.613915,0.781595,-0.110529>,
<6.311417,-2.250998,-3.050383>,
<-0.613915,0.781595,-0.110529>,
<7.281939,-1.076097,-0.132783>,
<-0.613915,0.781595,-0.110529>
}
smooth_triangle {
<6.532163,-2.749649,-3.011423>,
<0.842582,0.340396,-0.417356>,
<7.548903,-1.518804,0.045107>,
<0.842582,0.340396,-0.417356>,
<7.281939,-1.076097,-0.132783>,
<0.842582,0.340396,-0.417356>
}
smooth_triangle {
<7.281939,-1.076097,-0.132783>,
<0.842584,0.340393,-0.417355>,
<6.311417,-2.250998,-3.050383>,
<0.842584,0.340393,-0.417355>,
<6.532163,-2.749649,-3.011423>,
<0.842584,0.340393,-0.417355>
}
smooth_triangle {
<6.159083,-2.998472,-2.698703>,
<0.613914,-0.781596,0.110529>,
<7.129605,-1.823571,0.218897>,
<0.613914,-0.781596,0.110529>,
<7.548903,-1.518804,0.045107>,
<0.613914,-0.781596,0.110529>
}
smooth_triangle {
<7.548903,-1.518804,0.045107>,
<0.613920,-0.781592,0.110524>,
<6.532163,-2.749649,-3.011423>,
<0.613920,-0.781592,0.110524>,
<6.159083,-2.998472,-2.698703>,
<0.613920,-0.781592,0.110524>
}
smooth_triangle {
<6.740230,1.538753,-1.093988>,
<-0.876568,0.470302,0.102196>,
<5.815929,0.419803,-3.872659>,
<-0.876568,0.470302,0.102196>,
<5.998636,0.828526,-4.186448>,
<-0.876568,0.470302,0.102196>
}
smooth_triangle {
<5.998636,0.828526,-4.186448>,
<-0.876566,0.470307,0.102194>,
<6.969158,2.003427,-1.268841>,
<-0.876566,0.470307,0.102194>,
<6.740230,1.538753,-1.093988>,
<-0.876566,0.470307,0.102194>
}
smooth_triangle {
<6.214810,0.053206,-3.946138>,
<-0.552083,-0.693485,0.462907>,
<5.815929,0.419803,-3.872659>,
<-0.552083,-0.693485,0.462907>,
<6.740230,1.538753,-1.093988>,
<-0.552083,-0.693485,0.462907>
}
smooth_triangle {
<6.740230,1.538753,-1.093988>,
<-0.552076,-0.693490,0.462908>,
<7.185332,1.228107,-1.028531>,
<-0.552076,-0.693490,0.462908>,
<6.214810,0.053206,-3.946138>,
<-0.552076,-0.693490,0.462908>
}
smooth_triangle {
<7.414255,1.692781,-1.203387>,
<0.876569,-0.470300,-0.102198>,
<6.397519,0.461936,-4.259923>,
<0.876569,-0.470300,-0.102198>,
<6.214810,0.053206,-3.946138>,
<0.876569,-0.470300,-0.102198>
}
smooth_triangle {
<6.214810,0.053206,-3.946138>,
<0.876569,-0.470301,-0.102198>,
<7.185332,1.228107,-1.028531>,
<0.876569,-0.470301,-0.102198>,
<7.414255,1.692781,-1.203387>,
<0.876569,-0.470301,-0.102198>
}
smooth_triangle {
<6.969158,2.003427,-1.268841>,
<0.552076,0.693490,-0.462908>,
<5.998636,0.828526,-4.186448>,
<0.552076,0.693490,-0.462908>,
<6.397519,0.461936,-4.259923>,
<0.552076,0.693490,-0.462908>
}
smooth_triangle {
<6.397519,0.461936,-4.259923>,
<0.552078,0.693489,-0.462908>,
<7.414255,1.692781,-1.203387>,
<0.552078,0.693489,-0.462908>,
<6.969158,2.003427,-1.268841>,
<0.552078,0.693489,-0.462908>
}
smooth_triangle {
<6.624324,1.054073,2.001013>,
<-0.833370,-0.434534,0.341578>,
<5.314421,3.874954,2.393706>,
<-0.833370,-0.434534,0.341578>,
<5.477430,3.966220,2.907513>,
<-0.833370,-0.434534,0.341578>
}
smooth_triangle {
<5.477430,3.966220,2.907513>,
<-0.833367,-0.434535,0.341584>,
<6.852832,1.004296,2.495185>,
<-0.833367,-0.434535,0.341584>,
<6.624324,1.054073,2.001013>,
<-0.833367,-0.434535,0.341584>
}
smooth_triangle {
<5.682852,4.171334,2.119271>,
<-0.525023,-0.126639,-0.841613>,
<5.314421,3.874954,2.393706>,
<-0.525023,-0.126639,-0.841613>,
<6.624324,1.054073,2.001013>,
<-0.525023,-0.126639,-0.841613>
}
smooth_triangle {
<6.624324,1.054073,2.001013>,
<-0.525021,-0.126638,-0.841615>,
<7.058254,1.209410,1.706943>,
<-0.525021,-0.126638,-0.841615>,
<5.682852,4.171334,2.119271>,
<-0.525021,-0.126638,-0.841615>
}
smooth_triangle {
<7.286755,1.159633,2.201114>,
<0.833368,0.434534,-0.341583>,
<5.845863,4.262602,2.633076>,
<0.833368,0.434534,-0.341583>,
<5.682852,4.171334,2.119271>,
<0.833368,0.434534,-0.341583>
}
smooth_triangle {
<5.682852,4.171334,2.119271>,
<0.833370,0.434535,-0.341575>,
<7.058254,1.209410,1.706943>,
<0.833370,0.434535,-0.341575>,
<7.286755,1.159633,2.201114>,
<0.833370,0.434535,-0.341575>
}
smooth_triangle {
<6.852832,1.004296,2.495185>,
<0.525023,0.126640,0.841613>,
<5.477430,3.966220,2.907513>,
<0.525023,0.126640,0.841613>,
<5.845863,4.262602,2.633076>,
<0.525023,0.126640,0.841613>
}
smooth_triangle {
<5.845863,4.262602,2.633076>,
<0.525027,0.126641,0.841611>,
<7.286755,1.159633,2.201114>,
<0.525027,0.126641,0.841611>,
<6.852832,1.004296,2.495185>,
<0.525027,0.126641,0.841611>
}
smooth_triangle {
<5.430334,4.359627,-0.701295>,
<-0.801185,-0.299952,-0.517813>,
<6.740230,1.538753,-1.093988>,
<-0.801185,-0.299952,-0.517813>,
<7.004760,1.639602,-1.561700>,
<-0.801185,-0.299952,-0.517813>
}
smooth_triangle {
<7.004760,1.639602,-1.561700>,
<-0.801188,-0.299955,-0.517808>,
<5.629365,4.601519,-1.149372>,
<-0.801188,-0.299955,-0.517808>,
<5.430334,4.359627,-0.701295>,
<-0.801188,-0.299955,-0.517808>
}
smooth_triangle {
<7.149730,1.591932,-0.735672>,
<-0.583585,-0.371514,0.722085>,
<6.740230,1.538753,-1.093988>,
<-0.583585,-0.371514,0.722085>,
<5.430334,4.359627,-0.701295>,
<-0.583585,-0.371514,0.722085>
}
smooth_triangle {
<5.430334,4.359627,-0.701295>,
<-0.583588,-0.371516,0.722081>,
<5.774335,4.553849,-0.323344>,
<-0.583588,-0.371516,0.722081>,
<7.149730,1.591932,-0.735672>,
<-0.583588,-0.371516,0.722081>
}
smooth_triangle {
<5.973367,4.795742,-0.771424>,
<0.801189,0.299956,0.517805>,
<7.414255,1.692781,-1.203387>,
<0.801189,0.299956,0.517805>,
<7.149730,1.591932,-0.735672>,
<0.801189,0.299956,0.517805>
}
smooth_triangle {
<7.149730,1.591932,-0.735672>,
<0.801188,0.299956,0.517807>,
<5.774335,4.553849,-0.323344>,
<0.801188,0.299956,0.517807>,
<5.973367,4.795742,-0.771424>,
<0.801188,0.299956,0.517807>
}
smooth_triangle {
<5.629365,4.601519,-1.149372>,
<0.583585,0.371515,-0.722084>,
<7.004760,1.639602,-1.561700>,
<0.583585,0.371515,-0.722084>,
<7.414255,1.692781,-1.203387>,
<0.583585,0.371515,-0.722084>
}
smooth_triangle {
<7.414255,1.692781,-1.203387>,
<0.583584,0.371514,-0.722086>,
<5.973367,4.795742,-0.771424>,
<0.583584,0.371514,-0.722086>,
<5.629365,4.601519,-1.149372>,
<0.583584,0.371514,-0.722086>
}
smooth_triangle {
<4.709299,-5.010069,-1.317974>,
<-0.955182,0.084567,0.283681>,
<5.633607,-3.891119,1.460697>,
<-0.955182,0.084567,0.283681>,
<5.670945,-4.366503,1.728132>,
<-0.955182,0.084567,0.283681>
}
smooth_triangle {
<5.670945,-4.366503,1.728132>,
<-0.955182,0.084564,0.283682>,
<4.700423,-5.541397,-1.189475>,
<-0.955182,0.084564,0.283682>,
<4.709299,-5.010069,-1.317974>,
<-0.955182,0.084564,0.283682>
}
smooth_triangle {
<6.159629,-3.804697,1.339338>,
<-0.221636,0.927862,-0.299917>,
<5.633607,-3.891119,1.460697>,
<-0.221636,0.927862,-0.299917>,
<4.709299,-5.010069,-1.317974>,
<-0.221636,0.927862,-0.299917>
}
smooth_triangle {
<4.709299,-5.010069,-1.317974>,
<-0.221642,0.927861,-0.299914>,
<5.189107,-4.979591,-1.578269>,
<-0.221642,0.927861,-0.299914>,
<6.159629,-3.804697,1.339338>,
<-0.221642,0.927861,-0.299914>
}
smooth_triangle {
<5.180231,-5.510926,-1.449772>,
<0.955183,-0.084563,-0.283682>,
<6.196968,-4.280078,1.606767>,
<0.955183,-0.084563,-0.283682>,
<6.159629,-3.804697,1.339338>,
<0.955183,-0.084563,-0.283682>
}
smooth_triangle {
<6.159629,-3.804697,1.339338>,
<0.955182,-0.084561,-0.283683>,
<5.189107,-4.979591,-1.578269>,
<0.955182,-0.084561,-0.283683>,
<5.180231,-5.510926,-1.449772>,
<0.955182,-0.084561,-0.283683>
}
smooth_triangle {
<4.700423,-5.541397,-1.189475>,
<0.221643,-0.927861,0.299913>,
<5.670945,-4.366503,1.728132>,
<0.221643,-0.927861,0.299913>,
<6.196968,-4.280078,1.606767>,
<0.221643,-0.927861,0.299913>
}
smooth_triangle {
<6.196968,-4.280078,1.606767>,
<0.221633,-0.927862,0.299919>,
<5.180231,-5.510926,-1.449772>,
<0.221633,-0.927862,0.299919>,
<4.700423,-5.541397,-1.189475>,
<0.221633,-0.927862,0.299919>
}
smooth_triangle {
<5.633607,-3.891119,1.460697>,
<-0.656220,0.588434,0.472357>,
<6.862639,-1.380870,0.041006>,
<-0.656220,0.588434,0.472357>,
<7.242207,-1.257516,0.414652>,
<-0.656220,0.588434,0.472357>
}
smooth_triangle {
<7.242207,-1.257516,0.414652>,
<-0.656219,0.588434,0.472358>,
<5.951722,-3.893282,1.905330>,
<-0.656219,0.588434,0.472358>,
<5.633607,-3.891119,1.460697>,
<-0.656219,0.588434,0.472358>
}
smooth_triangle {
<7.169337,-1.642152,-0.328538>,
<-0.765600,0.011063,-0.643222>,
<6.862639,-1.380870,0.041006>,
<-0.765600,0.011063,-0.643222>,
<5.633607,-3.891119,1.460697>,
<-0.765600,0.011063,-0.643222>
}
smooth_triangle {
<5.633607,-3.891119,1.460697>,
<-0.765600,0.011062,-0.643222>,
<5.878852,-4.277918,1.162140>,
<-0.765600,0.011062,-0.643222>,
<7.169337,-1.642152,-0.328538>,
<-0.765600,0.011062,-0.643222>
}
smooth_triangle {
<6.196968,-4.280078,1.606767>,
<0.656216,-0.588435,-0.472362>,
<7.548903,-1.518804,0.045107>,
<0.656216,-0.588435,-0.472362>,
<7.169337,-1.642152,-0.328538>,
<0.656216,-0.588435,-0.472362>
}
smooth_triangle {
<7.169337,-1.642152,-0.328538>,
<0.656217,-0.588434,-0.472360>,
<5.878852,-4.277918,1.162140>,
<0.656217,-0.588434,-0.472360>,
<6.196968,-4.280078,1.606767>,
<0.656217,-0.588434,-0.472360>
}
smooth_triangle {
<5.951722,-3.893282,1.905330>,
<0.765602,-0.011065,0.643219>,
<7.242207,-1.257516,0.414652>,
<0.765602,-0.011065,0.643219>,
<7.548903,-1.518804,0.045107>,
<0.765602,-0.011065,0.643219>
}
smooth_triangle {
<7.548903,-1.518804,0.045107>,
<0.765603,-0.011067,0.643218>,
<6.196968,-4.280078,1.606767>,
<0.765603,-0.011067,0.643218>,
<5.951722,-3.893282,1.905330>,
<0.765603,-0.011067,0.643218>
}
smooth_triangle {
<5.938331,-2.499820,-2.737658>,
<-0.912875,0.277731,-0.299206>,
<4.709299,-5.010069,-1.317974>,
<-0.912875,0.277731,-0.299206>,
<4.740155,-5.359978,-1.736910>,
<-0.912875,0.277731,-0.299206>
}
smooth_triangle {
<4.740155,-5.359978,-1.736910>,
<-0.912875,0.277730,-0.299208>,
<6.030640,-2.724219,-3.227581>,
<-0.912875,0.277730,-0.299208>,
<5.938331,-2.499820,-2.737658>,
<-0.912875,0.277730,-0.299208>
}
smooth_triangle {
<5.149375,-5.161010,-1.030834>,
<-0.298614,0.576396,0.760656>,
<4.709299,-5.010069,-1.317974>,
<-0.298614,0.576396,0.760656>,
<5.938331,-2.499820,-2.737658>,
<-0.298614,0.576396,0.760656>
}
smooth_triangle {
<5.938331,-2.499820,-2.737658>,
<-0.298608,0.576396,0.760659>,
<6.439860,-2.525251,-2.521505>,
<-0.298608,0.576396,0.760659>,
<5.149375,-5.161010,-1.030834>,
<-0.298608,0.576396,0.760659>
}
smooth_triangle {
<6.532163,-2.749649,-3.011423>,
<0.912875,-0.277729,0.299208>,
<5.180231,-5.510926,-1.449772>,
<0.912875,-0.277729,0.299208>,
<5.149375,-5.161010,-1.030834>,
<0.912875,-0.277729,0.299208>
}
smooth_triangle {
<5.149375,-5.161010,-1.030834>,
<0.912876,-0.277735,0.299202>,
<6.439860,-2.525251,-2.521505>,
<0.912876,-0.277735,0.299202>,
<6.532163,-2.749649,-3.011423>,
<0.912876,-0.277735,0.299202>
}
smooth_triangle {
<6.030640,-2.724219,-3.227581>,
<0.298605,-0.576395,-0.760660>,
<4.740155,-5.359978,-1.736910>,
<0.298605,-0.576395,-0.760660>,
<5.180231,-5.510926,-1.449772>,
<0.298605,-0.576395,-0.760660>
}
smooth_triangle {
<5.180231,-5.510926,-1.449772>,
<0.298618,-0.576396,-0.760655>,
<6.532163,-2.749649,-3.011423>,
<0.298618,-0.576396,-0.760655>,
<6.030640,-2.724219,-3.227581>,
<0.298618,-0.576396,-0.760655>
}
smooth_triangle {
<2.388337,-6.580918,0.086653>,
<-0.866101,0.491680,0.090108>,
<3.312645,-5.461968,2.865317>,
<-0.866101,0.491680,0.090108>,
<3.117352,-5.863740,3.180492>,
<-0.866101,0.491680,0.090108>
}
smooth_triangle {
<3.117352,-5.863740,3.180492>,
<-0.866104,0.491675,0.090109>,
<2.146830,-7.038641,0.262892>,
<-0.866104,0.491675,0.090109>,
<2.388337,-6.580918,0.086653>,
<-0.866104,0.491675,0.090109>
}
smooth_triangle {
<3.839206,-5.606238,2.836680>,
<0.217450,0.878211,-0.425983>,
<3.312645,-5.461968,2.865317>,
<0.217450,0.878211,-0.425983>,
<2.388337,-6.580918,0.086653>,
<0.217450,0.878211,-0.425983>
}
smooth_triangle {
<2.388337,-6.580918,0.086653>,
<0.217452,0.878210,-0.425984>,
<2.868684,-6.781139,-0.080920>,
<0.217452,0.878210,-0.425984>,
<3.839206,-5.606238,2.836680>,
<0.217452,0.878210,-0.425984>
}
smooth_triangle {
<2.627172,-7.238860,0.095318>,
<0.866101,-0.491681,-0.090107>,
<3.643910,-6.008013,3.151849>,
<0.866101,-0.491681,-0.090107>,
<3.839206,-5.606238,2.836680>,
<0.866101,-0.491681,-0.090107>
}
smooth_triangle {
<3.839206,-5.606238,2.836680>,
<0.866100,-0.491683,-0.090105>,
<2.868684,-6.781139,-0.080920>,
<0.866100,-0.491683,-0.090105>,
<2.627172,-7.238860,0.095318>,
<0.866100,-0.491683,-0.090105>
}
smooth_triangle {
<2.146830,-7.038641,0.262892>,
<-0.217451,-0.878210,0.425984>,
<3.117352,-5.863740,3.180492>,
<-0.217451,-0.878210,0.425984>,
<3.643910,-6.008013,3.151849>,
<-0.217451,-0.878210,0.425984>
}
smooth_triangle {
<3.643910,-6.008013,3.151849>,
<-0.217451,-0.878210,0.425984>,
<2.627172,-7.238860,0.095318>,
<-0.217451,-0.878210,0.425984>,
<2.146830,-7.038641,0.262892>,
<-0.217451,-0.878210,0.425984>
}
smooth_triangle {
<2.096780,-2.696968,6.110496>,
<-0.850456,0.222463,-0.476692>,
<2.709077,0.359337,6.444431>,
<-0.850456,0.222463,-0.476692>,
<2.460101,0.437107,6.924918>,
<-0.850456,0.222463,-0.476692>
}
smooth_triangle {
<2.460101,0.437107,6.924918>,
<-0.850455,0.222464,-0.476694>,
<1.817186,-2.772015,6.574288>,
<-0.850455,0.222464,-0.476694>,
<2.096780,-2.696968,6.110496>,
<-0.850455,0.222464,-0.476694>
}
smooth_triangle {
<3.228967,0.317659,6.608392>,
<0.303638,0.043165,-0.951809>,
<2.709077,0.359337,6.444431>,
<0.303638,0.043165,-0.951809>,
<2.096780,-2.696968,6.110496>,
<0.303638,0.043165,-0.951809>
}
smooth_triangle {
<2.096780,-2.696968,6.110496>,
<0.303643,0.043163,-0.951808>,
<2.586052,-2.891463,6.257762>,
<0.303643,0.043163,-0.951808>,
<3.228967,0.317659,6.608392>,
<0.303643,0.043163,-0.951808>
}
smooth_triangle {
<2.306459,-2.966513,6.721548>,
<0.850450,-0.222462,0.476703>,
<2.979984,0.395423,7.088873>,
<0.850450,-0.222462,0.476703>,
<3.228967,0.317659,6.608392>,
<0.850450,-0.222462,0.476703>
}
smooth_triangle {
<3.228967,0.317659,6.608392>,
<0.850453,-0.222464,0.476696>,
<2.586052,-2.891463,6.257762>,
<0.850453,-0.222464,0.476696>,
<2.306459,-2.966513,6.721548>,
<0.850453,-0.222464,0.476696>
}
smooth_triangle {
<1.817186,-2.772015,6.574288>,
<-0.303633,-0.043165,0.951811>,
<2.460101,0.437107,6.924918>,
<-0.303633,-0.043165,0.951811>,
<2.979984,0.395423,7.088873>,
<-0.303633,-0.043165,0.951811>
}
smooth_triangle {
<2.979984,0.395423,7.088873>,
<-0.303633,-0.043165,0.951811>,
<2.306459,-2.966513,6.721548>,
<-0.303633,-0.043165,0.951811>,
<1.817186,-2.772015,6.574288>,
<-0.303633,-0.043165,0.951811>
}
smooth_triangle {
<5.248012,0.048705,4.632054>,
<-0.145464,0.136212,-0.979942>,
<4.635708,-3.007593,4.298119>,
<-0.145464,0.136212,-0.979942>,
<5.145182,-3.179177,4.198642>,
<-0.145464,0.136212,-0.979942>
}
smooth_triangle {
<5.145182,-3.179177,4.198642>,
<-0.145466,0.136212,-0.979942>,
<5.788104,0.029938,4.549272>,
<-0.145466,0.136212,-0.979942>,
<5.248012,0.048705,4.632054>,
<-0.145466,0.136212,-0.979942>
}
smooth_triangle {
<4.589802,-3.136617,4.827410>,
<-0.979108,0.200105,-0.036140>,
<4.635708,-3.007593,4.298119>,
<-0.979108,0.200105,-0.036140>,
<5.248012,0.048705,4.632054>,
<-0.979108,0.200105,-0.036140>
}
smooth_triangle {
<5.248012,0.048705,4.632054>,
<-0.979108,0.200105,-0.036136>,
<5.232724,0.072498,5.178040>,
<-0.979108,0.200105,-0.036136>,
<4.589802,-3.136617,4.827410>,
<-0.979108,0.200105,-0.036136>
}
smooth_triangle {
<5.772814,0.053728,5.095260>,
<0.145463,-0.136211,0.979942>,
<5.099281,-3.308201,4.727933>,
<0.145463,-0.136211,0.979942>,
<4.589802,-3.136617,4.827410>,
<0.145463,-0.136211,0.979942>
}
smooth_triangle {
<4.589802,-3.136617,4.827410>,
<0.145463,-0.136212,0.979942>,
<5.232724,0.072498,5.178040>,
<0.145463,-0.136212,0.979942>,
<5.772814,0.053728,5.095260>,
<0.145463,-0.136212,0.979942>
}
smooth_triangle {
<5.788104,0.029938,4.549272>,
<0.979108,-0.200105,0.036131>,
<5.145182,-3.179177,4.198642>,
<0.979108,-0.200105,0.036131>,
<5.099281,-3.308201,4.727933>,
<0.979108,-0.200105,0.036131>
}
smooth_triangle {
<5.099281,-3.308201,4.727933>,
<0.979108,-0.200104,0.036139>,
<5.772814,0.053728,5.095260>,
<0.979108,-0.200104,0.036139>,
<5.788104,0.029938,4.549272>,
<0.979108,-0.200104,0.036139>
}
smooth_triangle {
<5.815929,0.419803,-3.872659>,
<-0.328088,0.272769,0.904409>,
<3.934777,2.549126,-5.197276>,
<-0.328088,0.272769,0.904409>,
<4.282502,2.971016,-5.198375>,
<-0.328088,0.272769,0.904409>
}
smooth_triangle {
<4.282502,2.971016,-5.198375>,
<-0.328084,0.272771,0.904410>,
<6.257706,0.735223,-3.807531>,
<-0.328084,0.272771,0.904410>,
<5.815929,0.419803,-3.872659>,
<-0.328084,0.272771,0.904410>
}
smooth_triangle {
<3.980536,2.382302,-5.715899>,
<-0.781346,-0.610920,0.127573>,
<3.934777,2.549126,-5.197276>,
<-0.781346,-0.610920,0.127573>,
<5.815929,0.419803,-3.872659>,
<-0.781346,-0.610920,0.127573>
}
smooth_triangle {
<5.815929,0.419803,-3.872659>,
<-0.781349,-0.610914,0.127583>,
<5.955740,0.146509,-4.325055>,
<-0.781349,-0.610914,0.127583>,
<3.980536,2.382302,-5.715899>,
<-0.781349,-0.610914,0.127583>
}
smooth_triangle {
<6.397519,0.461936,-4.259923>,
<0.328083,-0.272775,-0.904409>,
<4.328256,2.804192,-5.717005>,
<0.328083,-0.272775,-0.904409>,
<3.980536,2.382302,-5.715899>,
<0.328083,-0.272775,-0.904409>
}
smooth_triangle {
<3.980536,2.382302,-5.715899>,
<0.328090,-0.272766,-0.904409>,
<5.955740,0.146509,-4.325055>,
<0.328090,-0.272766,-0.904409>,
<6.397519,0.461936,-4.259923>,
<0.328090,-0.272766,-0.904409>
}
smooth_triangle {
<6.257706,0.735223,-3.807531>,
<0.781349,0.610916,-0.127578>,
<4.282502,2.971016,-5.198375>,
<0.781349,0.610916,-0.127578>,
<4.328256,2.804192,-5.717005>,
<0.781349,0.610916,-0.127578>
}
smooth_triangle {
<4.328256,2.804192,-5.717005>,
<0.781347,0.610919,-0.127574>,
<6.397519,0.461936,-4.259923>,
<0.781347,0.610919,-0.127574>,
<6.257706,0.735223,-3.807531>,
<0.781347,0.610919,-0.127574>
}
smooth_triangle {
<3.934777,2.549126,-5.197276>,
<0.086280,-0.619566,0.780188>,
<3.696462,4.984076,-3.237269>,
<0.086280,-0.619566,0.780188>,
<4.227986,5.106233,-3.199042>,
<0.086280,-0.619566,0.780188>
}
smooth_triangle {
<4.227986,5.106233,-3.199042>,
<0.086275,-0.619566,0.780189>,
<4.478222,2.549532,-5.257049>,
<0.086275,-0.619566,0.780189>,
<3.934777,2.549126,-5.197276>,
<0.086275,-0.619566,0.780189>
}
smooth_triangle {
<3.534580,5.360487,-3.599218>,
<-0.954555,-0.237916,0.179504>,
<3.696462,4.984076,-3.237269>,
<-0.954555,-0.237916,0.179504>,
<3.934777,2.549126,-5.197276>,
<-0.954555,-0.237916,0.179504>
}
smooth_triangle {
<3.934777,2.549126,-5.197276>,
<-0.954557,-0.237912,0.179497>,
<3.784816,2.803786,-5.657225>,
<-0.954557,-0.237912,0.179497>,
<3.534580,5.360487,-3.599218>,
<-0.954557,-0.237912,0.179497>
}
smooth_triangle {
<4.328256,2.804192,-5.717005>,
<-0.086280,0.619566,-0.780188>,
<4.066109,5.482637,-3.560997>,
<-0.086280,0.619566,-0.780188>,
<3.534580,5.360487,-3.599218>,
<-0.086280,0.619566,-0.780188>
}
smooth_triangle {
<3.534580,5.360487,-3.599218>,
<-0.086286,0.619565,-0.780189>,
<3.784816,2.803786,-5.657225>,
<-0.086286,0.619565,-0.780189>,
<4.328256,2.804192,-5.717005>,
<-0.086286,0.619565,-0.780189>
}
smooth_triangle {
<4.478222,2.549532,-5.257049>,
<0.954557,0.237912,-0.179497>,
<4.227986,5.106233,-3.199042>,
<0.954557,0.237912,-0.179497>,
<4.066109,5.482637,-3.560997>,
<0.954557,0.237912,-0.179497>
}
smooth_triangle {
<4.066109,5.482637,-3.560997>,
<0.954555,0.237915,-0.179503>,
<4.328256,2.804192,-5.717005>,
<0.954555,0.237915,-0.179503>,
<4.478222,2.549532,-5.257049>,
<0.954555,0.237915,-0.179503>
}
smooth_triangle {
<0.775096,5.509776,-4.245556>,
<-0.724918,-0.473590,0.500206>,
<1.013411,3.074826,-6.205563>,
<-0.724918,-0.473590,0.500206>,
<0.648935,3.238612,-6.578705>,
<-0.724918,-0.473590,0.500206>
}
smooth_triangle {
<0.648935,3.238612,-6.578705>,
<-0.724911,-0.473595,0.500211>,
<0.398699,5.795313,-4.520691>,
<-0.724911,-0.473595,0.500211>,
<0.775096,5.509776,-4.245556>,
<-0.724911,-0.473595,0.500211>
}
smooth_triangle {
<1.479233,3.218676,-6.452985>,
<0.521409,-0.503512,0.688919>,
<1.013411,3.074826,-6.205563>,
<0.521409,-0.503512,0.688919>,
<0.775096,5.509776,-4.245556>,
<0.521409,-0.503512,0.688919>
}
smooth_triangle {
<0.775096,5.509776,-4.245556>,
<0.521409,-0.503512,0.688919>,
<1.228997,5.775377,-4.394971>,
<0.521409,-0.503512,0.688919>,
<1.479233,3.218676,-6.452985>,
<0.521409,-0.503512,0.688919>
}
smooth_triangle {
<0.852606,6.060908,-4.670113>,
<0.724911,0.473594,-0.500212>,
<1.114753,3.382463,-6.826122>,
<0.724911,0.473594,-0.500212>,
<1.479233,3.218676,-6.452985>,
<0.724911,0.473594,-0.500212>
}
smooth_triangle {
<1.479233,3.218676,-6.452985>,
<0.724917,0.473592,-0.500206>,
<1.228997,5.775377,-4.394971>,
<0.724917,0.473592,-0.500206>,
<0.852606,6.060908,-4.670113>,
<0.724917,0.473592,-0.500206>
}
smooth_triangle {
<0.398699,5.795313,-4.520691>,
<-0.521408,0.503512,-0.688919>,
<0.648935,3.238612,-6.578705>,
<-0.521408,0.503512,-0.688919>,
<1.114753,3.382463,-6.826122>,
<-0.521408,0.503512,-0.688919>
}
smooth_triangle {
<1.114753,3.382463,-6.826122>,
<-0.521406,0.503513,-0.688920>,
<0.852606,6.060908,-4.670113>,
<-0.521406,0.503513,-0.688920>,
<0.398699,5.795313,-4.520691>,
<-0.521406,0.503513,-0.688920>
}
smooth_triangle {
<1.699404,6.628719,-1.466885>,
<0.176637,-0.920884,-0.347522>,
<3.433269,6.004277,1.069082>,
<0.176637,-0.920884,-0.347522>,
<3.917144,6.169981,0.875931>,
<0.176637,-0.920884,-0.347522>
}
smooth_triangle {
<3.917144,6.169981,0.875931>,
<0.176642,-0.920882,-0.347526>,
<2.096591,6.825650,-1.786834>,
<0.176642,-0.920882,-0.347526>,
<1.699404,6.628719,-1.466885>,
<0.176642,-0.920882,-0.347526>
}
smooth_triangle {
<3.292716,6.439145,1.369137>,
<-0.760638,-0.516864,0.392786>,
<3.433269,6.004277,1.069082>,
<-0.760638,-0.516864,0.392786>,
<1.699404,6.628719,-1.466885>,
<-0.760638,-0.516864,0.392786>
}
smooth_triangle {
<1.699404,6.628719,-1.466885>,
<-0.760643,-0.516854,0.392790>,
<1.472163,7.094814,-1.293628>,
<-0.760643,-0.516854,0.392790>,
<3.292716,6.439145,1.369137>,
<-0.760643,-0.516854,0.392790>
}
smooth_triangle {
<1.869345,7.291745,-1.613574>,
<-0.176645,0.920881,0.347528>,
<3.776594,6.604854,1.175990>,
<-0.176645,0.920881,0.347528>,
<3.292716,6.439145,1.369137>,
<-0.176645,0.920881,0.347528>
}
smooth_triangle {
<3.292716,6.439145,1.369137>,
<-0.176645,0.920881,0.347528>,
<1.472163,7.094814,-1.293628>,
<-0.176645,0.920881,0.347528>,
<1.869345,7.291745,-1.613574>,
<-0.176645,0.920881,0.347528>
}
smooth_triangle {
<2.096591,6.825650,-1.786834>,
<0.760642,0.516857,-0.392788>,
<3.917144,6.169981,0.875931>,
<0.760642,0.516857,-0.392788>,
<3.776594,6.604854,1.175990>,
<0.760642,0.516857,-0.392788>
}
smooth_triangle {
<3.776594,6.604854,1.175990>,
<0.760640,0.516861,-0.392786>,
<1.869345,7.291745,-1.613574>,
<0.760640,0.516861,-0.392786>,
<2.096591,6.825650,-1.786834>,
<0.760640,0.516861,-0.392786>
}
smooth_triangle {
<3.433269,6.004277,1.069082>,
<0.064877,-0.964449,0.256182>,
<0.894341,6.314902,2.881466>,
<0.064877,-0.964449,0.256182>,
<1.146292,6.455224,3.345930>,
<0.064877,-0.964449,0.256182>
}
smooth_triangle {
<1.146292,6.455224,3.345930>,
<0.064867,-0.964452,0.256173>,
<3.812165,6.129059,1.442924>,
<0.064867,-0.964452,0.256173>,
<3.433269,6.004277,1.069082>,
<0.064867,-0.964452,0.256173>
}
smooth_triangle {
<0.731822,6.806232,2.705150>,
<-0.557274,-0.437567,-0.705678>,
<0.894341,6.314902,2.881466>,
<-0.557274,-0.437567,-0.705678>,
<3.433269,6.004277,1.069082>,
<-0.557274,-0.437567,-0.705678>
}
smooth_triangle {
<3.433269,6.004277,1.069082>,
<-0.557273,-0.437578,-0.705672>,
<3.397695,6.480067,0.802144>,
<-0.557273,-0.437578,-0.705672>,
<0.731822,6.806232,2.705150>,
<-0.557273,-0.437578,-0.705672>
}
smooth_triangle {
<3.776594,6.604854,1.175990>,
<-0.064869,0.964452,-0.256173>,
<0.983775,6.946547,3.169614>,
<-0.064869,0.964452,-0.256173>,
<0.731822,6.806232,2.705150>,
<-0.064869,0.964452,-0.256173>
}
smooth_triangle {
<0.731822,6.806232,2.705150>,
<-0.064872,0.964450,-0.256179>,
<3.397695,6.480067,0.802144>,
<-0.064872,0.964450,-0.256179>,
<3.776594,6.604854,1.175990>,
<-0.064872,0.964450,-0.256179>
}
smooth_triangle {
<3.812165,6.129059,1.442924>,
<0.557275,0.437570,0.705675>,
<1.146292,6.455224,3.345930>,
<0.557275,0.437570,0.705675>,
<0.983775,6.946547,3.169614>,
<0.557275,0.437570,0.705675>
}
smooth_triangle {
<0.983775,6.946547,3.169614>,
<0.557275,0.437566,0.705677>,
<3.776594,6.604854,1.175990>,
<0.557275,0.437566,0.705677>,
<3.812165,6.129059,1.442924>,
<0.557275,0.437566,0.705677>
}
smooth_triangle {
<0.894341,6.314902,2.881466>,
<-0.528346,-0.834627,0.155720>,
<-0.839531,6.939351,0.345492>,
<-0.528346,-0.834627,0.155720>,
<-1.231419,7.232826,0.588812>,
<-0.528346,-0.834627,0.155720>
}
smooth_triangle {
<-1.231419,7.232826,0.588812>,
<-0.528349,-0.834624,0.155724>,
<0.589148,6.577157,3.251584>,
<-0.528349,-0.834624,0.155724>,
<0.894341,6.314902,2.881466>,
<-0.528349,-0.834624,0.155724>
}
smooth_triangle {
<-0.531601,7.339968,0.136724>,
<0.522107,-0.673794,-0.522882>,
<-0.839531,6.939351,0.345492>,
<0.522107,-0.673794,-0.522882>,
<0.894341,6.314902,2.881466>,
<0.522107,-0.673794,-0.522882>
}
smooth_triangle {
<0.894341,6.314902,2.881466>,
<0.522107,-0.673794,-0.522883>,
<1.288966,6.684299,2.799496>,
<0.522107,-0.673794,-0.522883>,
<-0.531601,7.339968,0.136724>,
<0.522107,-0.673794,-0.522883>
}
smooth_triangle {
<0.983775,6.946547,3.169614>,
<0.528348,0.834625,-0.155722>,
<-0.923484,7.633442,0.380041>,
<0.528348,0.834625,-0.155722>,
<-0.531601,7.339968,0.136724>,
<0.528348,0.834625,-0.155722>
}
smooth_triangle {
<-0.531601,7.339968,0.136724>,
<0.528343,0.834629,-0.155719>,
<1.288966,6.684299,2.799496>,
<0.528343,0.834629,-0.155719>,
<0.983775,6.946547,3.169614>,
<0.528343,0.834629,-0.155719>
}
smooth_triangle {
<0.589148,6.577157,3.251584>,
<-0.522101,0.673800,0.522880>,
<-1.231419,7.232826,0.588812>,
<-0.522101,0.673800,0.522880>,
<-0.923484,7.633442,0.380041>,
<-0.522101,0.673800,0.522880>
}
smooth_triangle {
<-0.923484,7.633442,0.380041>,
<-0.522100,0.673801,0.522880>,
<0.983775,6.946547,3.169614>,
<-0.522100,0.673801,0.522880>,
<0.589148,6.577157,3.251584>,
<-0.522100,0.673801,0.522880>
}
smooth_triangle {
<-0.839531,6.939351,0.345492>,
<-0.416574,-0.791057,-0.447990>,
<1.699404,6.628719,-1.466885>,
<-0.416574,-0.791057,-0.447990>,
<1.539447,6.947576,-1.881180>,
<-0.416574,-0.791057,-0.447990>
}
smooth_triangle {
<1.539447,6.947576,-1.881180>,
<-0.416574,-0.791056,-0.447990>,
<-1.126440,7.273741,0.021819>,
<-0.416574,-0.791056,-0.447990>,
<-0.839531,6.939351,0.345492>,
<-0.416574,-0.791056,-0.447990>
}
smooth_triangle {
<2.029307,6.972888,-1.199282>,
<0.318738,-0.753064,0.575587>,
<1.699404,6.628719,-1.466885>,
<0.318738,-0.753064,0.575587>,
<-0.839531,6.939351,0.345492>,
<0.318738,-0.753064,0.575587>
}
smooth_triangle {
<-0.839531,6.939351,0.345492>,
<0.318738,-0.753063,0.575588>,
<-0.636580,7.299053,0.703717>,
<0.318738,-0.753063,0.575588>,
<2.029307,6.972888,-1.199282>,
<0.318738,-0.753063,0.575588>
}
smooth_triangle {
<-0.923484,7.633442,0.380041>,
<0.416574,0.791057,0.447989>,
<1.869345,7.291745,-1.613574>,
<0.416574,0.791057,0.447989>,
<2.029307,6.972888,-1.199282>,
<0.416574,0.791057,0.447989>
}
smooth_triangle {
<2.029307,6.972888,-1.199282>,
<0.416574,0.791057,0.447990>,
<-0.636580,7.299053,0.703717>,
<0.416574,0.791057,0.447990>,
<-0.923484,7.633442,0.380041>,
<0.416574,0.791057,0.447990>
}
smooth_triangle {
<-1.126440,7.273741,0.021819>,
<-0.318738,0.753064,-0.575587>,
<1.539447,6.947576,-1.881180>,
<-0.318738,0.753064,-0.575587>,
<1.869345,7.291745,-1.613574>,
<-0.318738,0.753064,-0.575587>
}
smooth_triangle {
<1.869345,7.291745,-1.613574>,
<-0.318738,0.753064,-0.575587>,
<-0.923484,7.633442,0.380041>,
<-0.318738,0.753064,-0.575587>,
<-1.126440,7.273741,0.021819>,
<-0.318738,0.753064,-0.575587>
}
smooth_triangle {
<3.696462,4.984076,-3.237269>,
<-0.206118,-0.973527,-0.098793>,
<5.430334,4.359627,-0.701295>,
<-0.206118,-0.973527,-0.098793>,
<5.910443,4.283362,-0.951447>,
<-0.206118,-0.973527,-0.098793>
}
smooth_triangle {
<5.910443,4.283362,-0.951447>,
<-0.206113,-0.973528,-0.098798>,
<4.089876,4.939038,-3.614219>,
<-0.206113,-0.973528,-0.098798>,
<3.696462,4.984076,-3.237269>,
<-0.206113,-0.973528,-0.098798>
}
smooth_triangle {
<5.493257,4.872006,-0.521269>,
<-0.832334,-0.089949,0.546927>,
<5.430334,4.359627,-0.701295>,
<-0.832334,-0.089949,0.546927>,
<3.696462,4.984076,-3.237269>,
<-0.832334,-0.089949,0.546927>
}
smooth_triangle {
<3.696462,4.984076,-3.237269>,
<-0.832334,-0.089951,0.546927>,
<3.672690,5.527682,-3.184041>,
<-0.832334,-0.089951,0.546927>,
<5.493257,4.872006,-0.521269>,
<-0.832334,-0.089951,0.546927>
}
smooth_triangle {
<4.066109,5.482637,-3.560997>,
<0.206117,0.973527,0.098794>,
<5.973367,4.795742,-0.771424>,
<0.206117,0.973527,0.098794>,
<5.493257,4.872006,-0.521269>,
<0.206117,0.973527,0.098794>
}
smooth_triangle {
<5.493257,4.872006,-0.521269>,
<0.206122,0.973527,0.098792>,
<3.672690,5.527682,-3.184041>,
<0.206122,0.973527,0.098792>,
<4.066109,5.482637,-3.560997>,
<0.206122,0.973527,0.098792>
}
smooth_triangle {
<4.089876,4.939038,-3.614219>,
<0.832334,0.089944,-0.546928>,
<5.910443,4.283362,-0.951447>,
<0.832334,0.089944,-0.546928>,
<5.973367,4.795742,-0.771424>,
<0.832334,0.089944,-0.546928>
}
smooth_triangle {
<5.973367,4.795742,-0.771424>,
<0.832334,0.089939,-0.546929>,
<4.066109,5.482637,-3.560997>,
<0.832334,0.089939,-0.546929>,
<4.089876,4.939038,-3.614219>,
<0.832334,0.089939,-0.546929>
}
smooth_triangle {
<6.624324,1.054073,2.001013>,
<-0.534240,-0.657867,-0.530847>,
<5.248012,0.048705,4.632054>,
<-0.534240,-0.657867,-0.530847>,
<5.604466,-0.345136,4.761400>,
<-0.534240,-0.657867,-0.530847>
}
smooth_triangle {
<5.604466,-0.345136,4.761400>,
<-0.534240,-0.657867,-0.530847>,
<7.049595,0.710499,1.998808>,
<-0.534240,-0.657867,-0.530847>,
<6.624324,1.054073,2.001013>,
<-0.534240,-0.657867,-0.530847>
}
smooth_triangle {
<5.416362,0.447572,4.965912>,
<-0.816592,0.532036,-0.223863>,
<5.248012,0.048705,4.632054>,
<-0.816592,0.532036,-0.223863>,
<6.624324,1.054073,2.001013>,
<-0.816592,0.532036,-0.223863>
}
smooth_triangle {
<6.624324,1.054073,2.001013>,
<-0.816590,0.532040,-0.223862>,
<6.861491,1.503207,2.203320>,
<-0.816590,0.532040,-0.223862>,
<5.416362,0.447572,4.965912>,
<-0.816590,0.532040,-0.223862>
}
smooth_triangle {
<7.286755,1.159633,2.201114>,
<0.534243,0.657865,0.530847>,
<5.772814,0.053728,5.095260>,
<0.534243,0.657865,0.530847>,
<5.416362,0.447572,4.965912>,
<0.534243,0.657865,0.530847>
}
smooth_triangle {
<5.416362,0.447572,4.965912>,
<0.534245,0.657862,0.530848>,
<6.861491,1.503207,2.203320>,
<0.534245,0.657862,0.530848>,
<7.286755,1.159633,2.201114>,
<0.534245,0.657862,0.530848>
}
smooth_triangle {
<7.049595,0.710499,1.998808>,
<0.816592,-0.532037,0.223863>,
<5.604466,-0.345136,4.761400>,
<0.816592,-0.532037,0.223863>,
<5.772814,0.053728,5.095260>,
<0.816592,-0.532037,0.223863>
}
smooth_triangle {
<5.772814,0.053728,5.095260>,
<0.816595,-0.532031,0.223866>,
<7.286755,1.159633,2.201114>,
<0.816595,-0.532031,0.223866>,
<7.049595,0.710499,1.998808>,
<0.816595,-0.532031,0.223866>
}
smooth_triangle {
<3.938109,2.869586,5.024747>,
<-0.897969,0.125416,-0.421809>,
<5.314421,3.874954,2.393706>,
<-0.897969,0.125416,-0.421809>,
<5.332586,4.408067,2.513546>,
<-0.897969,0.125416,-0.421809>
}
smooth_triangle {
<5.332586,4.408067,2.513546>,
<-0.897969,0.125413,-0.421810>,
<3.887457,3.352432,5.276138>,
<-0.897969,0.125413,-0.421810>,
<3.938109,2.869586,5.024747>,
<-0.897969,0.125413,-0.421810>
}
smooth_triangle {
<5.827696,3.729487,2.513238>,
<-0.154792,-0.893158,-0.422265>,
<5.314421,3.874954,2.393706>,
<-0.154792,-0.893158,-0.422265>,
<3.938109,2.869586,5.024747>,
<-0.154792,-0.893158,-0.422265>
}
smooth_triangle {
<3.938109,2.869586,5.024747>,
<-0.154791,-0.893159,-0.422264>,
<4.382567,2.673852,5.275830>,
<-0.154791,-0.893159,-0.422264>,
<5.827696,3.729487,2.513238>,
<-0.154791,-0.893159,-0.422264>
}
smooth_triangle {
<4.331921,3.156698,5.527223>,
<0.897969,-0.125418,0.421808>,
<5.845863,4.262602,2.633076>,
<0.897969,-0.125418,0.421808>,
<5.827696,3.729487,2.513238>,
<0.897969,-0.125418,0.421808>
}
smooth_triangle {
<5.827696,3.729487,2.513238>,
<0.897969,-0.125423,0.421807>,
<4.382567,2.673852,5.275830>,
<0.897969,-0.125423,0.421807>,
<4.331921,3.156698,5.527223>,
<0.897969,-0.125423,0.421807>
}
smooth_triangle {
<3.887457,3.352432,5.276138>,
<0.154790,0.893159,0.422263>,
<5.332586,4.408067,2.513546>,
<0.154790,0.893159,0.422263>,
<5.845863,4.262602,2.633076>,
<0.154790,0.893159,0.422263>
}
smooth_triangle {
<5.845863,4.262602,2.633076>,
<0.154789,0.893160,0.422263>,
<4.331921,3.156698,5.527223>,
<0.154789,0.893160,0.422263>,
<3.887457,3.352432,5.276138>,
<0.154789,0.893160,0.422263>
}
smooth_triangle {
<2.709077,0.359337,6.444431>,
<-0.436090,-0.669872,-0.600914>,
<-0.022687,1.867305,6.745886>,
<-0.436090,-0.669872,-0.600914>,
<-0.212527,1.598988,7.182763>,
<-0.436090,-0.669872,-0.600914>
}
smooth_triangle {
<-0.212527,1.598988,7.182763>,
<-0.436090,-0.669876,-0.600909>,
<2.655828,0.015623,6.866237>,
<-0.436090,-0.669876,-0.600909>,
<2.709077,0.359337,6.444431>,
<-0.436090,-0.669876,-0.600909>
}
smooth_triangle {
<0.164885,2.322508,6.983599>,
<0.130434,0.416181,-0.899878>,
<-0.022687,1.867305,6.745886>,
<0.130434,0.416181,-0.899878>,
<2.709077,0.359337,6.444431>,
<0.130434,0.416181,-0.899878>
}
smooth_triangle {
<2.709077,0.359337,6.444431>,
<0.130435,0.416182,-0.899877>,
<3.033240,0.739143,6.667073>,
<0.130435,0.416182,-0.899877>,
<0.164885,2.322508,6.983599>,
<0.130435,0.416182,-0.899877>
}
smooth_triangle {
<2.979984,0.395423,7.088873>,
<0.436088,0.669867,0.600920>,
<-0.024956,2.054188,7.420473>,
<0.436088,0.669867,0.600920>,
<0.164885,2.322508,6.983599>,
<0.436088,0.669867,0.600920>
}
smooth_triangle {
<0.164885,2.322508,6.983599>,
<0.436086,0.669865,0.600924>,
<3.033240,0.739143,6.667073>,
<0.436086,0.669865,0.600924>,
<2.979984,0.395423,7.088873>,
<0.436086,0.669865,0.600924>
}
smooth_triangle {
<2.655828,0.015623,6.866237>,
<-0.130433,-0.416179,0.899879>,
<-0.212527,1.598988,7.182763>,
<-0.130433,-0.416179,0.899879>,
<-0.024956,2.054188,7.420473>,
<-0.130433,-0.416179,0.899879>
}
smooth_triangle {
<-0.024956,2.054188,7.420473>,
<-0.130433,-0.416179,0.899879>,
<2.979984,0.395423,7.088873>,
<-0.130433,-0.416179,0.899879>,
<2.655828,0.015623,6.866237>,
<-0.130433,-0.416179,0.899879>
}
smooth_triangle {
<-0.022687,1.867305,6.745886>,
<-0.644717,-0.112002,-0.756172>,
<1.206345,4.377554,5.326195>,
<-0.644717,-0.112002,-0.756172>,
<0.882007,4.758690,5.546275>,
<-0.644717,-0.112002,-0.756172>
}
smooth_triangle {
<0.882007,4.758690,5.546275>,
<-0.644719,-0.112001,-0.756171>,
<-0.408478,2.122931,7.036953>,
<-0.644719,-0.112001,-0.756171>,
<-0.022687,1.867305,6.745886>,
<-0.644719,-0.112001,-0.756171>
}
smooth_triangle {
<1.651321,4.434324,5.638731>,
<0.510045,-0.598895,-0.617397>,
<1.206345,4.377554,5.326195>,
<0.510045,-0.598895,-0.617397>,
<-0.022687,1.867305,6.745886>,
<0.510045,-0.598895,-0.617397>
}
smooth_triangle {
<-0.022687,1.867305,6.745886>,
<0.510050,-0.598896,-0.617392>,
<0.360836,1.798565,7.129409>,
<0.510050,-0.598896,-0.617392>,
<1.651321,4.434324,5.638731>,
<0.510050,-0.598896,-0.617392>
}
smooth_triangle {
<-0.024956,2.054188,7.420473>,
<0.644719,0.111999,0.756170>,
<1.326980,4.815463,5.858816>,
<0.644719,0.111999,0.756170>,
<1.651321,4.434324,5.638731>,
<0.644719,0.111999,0.756170>
}
smooth_triangle {
<1.651321,4.434324,5.638731>,
<0.644714,0.112004,0.756173>,
<0.360836,1.798565,7.129409>,
<0.644714,0.112004,0.756173>,
<-0.024956,2.054188,7.420473>,
<0.644714,0.112004,0.756173>
}
smooth_triangle {
<-0.408478,2.122931,7.036953>,
<-0.510055,0.598896,0.617388>,
<0.882007,4.758690,5.546275>,
<-0.510055,0.598896,0.617388>,
<1.326980,4.815463,5.858816>,
<-0.510055,0.598896,0.617388>
}
smooth_triangle {
<1.326980,4.815463,5.858816>,
<-0.510046,0.598894,0.617397>,
<-0.024956,2.054188,7.420473>,
<-0.510046,0.598894,0.617397>,
<-0.408478,2.122931,7.036953>,
<-0.510046,0.598894,0.617397>
}
smooth_triangle {
<1.206345,4.377554,5.326195>,
<-0.094821,0.027156,-0.995124>,
<3.938109,2.869586,5.024747>,
<-0.094821,0.027156,-0.995124>,
<4.266815,3.306015,5.005336>,
<-0.094821,0.027156,-0.995124>
}
smooth_triangle {
<4.266815,3.306015,5.005336>,
<-0.094821,0.027155,-0.995124>,
<1.398467,4.889380,5.321855>,
<-0.094821,0.027155,-0.995124>,
<1.206345,4.377554,5.326195>,
<-0.094821,0.027155,-0.995124>
}
smooth_triangle {
<4.003209,2.720269,5.546632>,
<-0.490513,-0.852087,-0.182605>,
<3.938109,2.869586,5.024747>,
<-0.490513,-0.852087,-0.182605>,
<1.206345,4.377554,5.326195>,
<-0.490513,-0.852087,-0.182605>
}
smooth_triangle {
<1.206345,4.377554,5.326195>,
<-0.490513,-0.852087,-0.182604>,
<1.134861,4.303634,5.863151>,
<-0.490513,-0.852087,-0.182604>,
<4.003209,2.720269,5.546632>,
<-0.490513,-0.852087,-0.182604>
}
smooth_triangle {
<1.326980,4.815463,5.858816>,
<0.094819,-0.027160,0.995124>,
<4.331921,3.156698,5.527223>,
<0.094819,-0.027160,0.995124>,
<4.003209,2.720269,5.546632>,
<0.094819,-0.027160,0.995124>
}
smooth_triangle {
<4.003209,2.720269,5.546632>,
<0.094817,-0.027162,0.995124>,
<1.134861,4.303634,5.863151>,
<0.094817,-0.027162,0.995124>,
<1.326980,4.815463,5.858816>,
<0.094817,-0.027162,0.995124>
}
smooth_triangle {
<1.398467,4.889380,5.321855>,
<0.490513,0.852088,0.182600>,
<4.266815,3.306015,5.005336>,
<0.490513,0.852088,0.182600>,
<4.331921,3.156698,5.527223>,
<0.490513,0.852088,0.182600>
}
smooth_triangle {
<4.331921,3.156698,5.527223>,
<0.490513,0.852088,0.182599>,
<1.326980,4.815463,5.858816>,
<0.490513,0.852088,0.182599>,
<1.398467,4.889380,5.321855>,
<0.490513,0.852088,0.182599>
}
smooth_triangle {
<0.775096,5.509776,-4.245556>,
<0.056523,-0.218347,0.974233>,
<-2.335088,5.128850,-4.150482>,
<0.056523,-0.218347,0.974233>,
<-2.473310,5.643238,-4.027177>,
<0.056523,-0.218347,0.974233>
}
smooth_triangle {
<-2.473310,5.643238,-4.027177>,
<0.056523,-0.218347,0.974233>,
<0.792379,6.043211,-4.127004>,
<0.056523,-0.218347,0.974233>,
<0.775096,5.509776,-4.245556>,
<0.056523,-0.218347,0.974233>
}
smooth_triangle {
<-2.430372,5.127506,-4.688831>,
<0.120977,-0.992475,-0.018934>,
<-2.335088,5.128850,-4.150482>,
<0.120977,-0.992475,-0.018934>,
<0.775096,5.509776,-4.245556>,
<0.120977,-0.992475,-0.018934>
}
smooth_triangle {
<0.775096,5.509776,-4.245556>,
<0.120977,-0.992475,-0.018936>,
<0.835317,5.527479,-4.788658>,
<0.120977,-0.992475,-0.018936>,
<-2.430372,5.127506,-4.688831>,
<0.120977,-0.992475,-0.018936>
}
smooth_triangle {
<0.852606,6.060908,-4.670113>,
<-0.056523,0.218341,-0.974234>,
<-2.568597,5.641888,-4.565530>,
<-0.056523,0.218341,-0.974234>,
<-2.430372,5.127506,-4.688831>,
<-0.056523,0.218341,-0.974234>
}
smooth_triangle {
<-2.430372,5.127506,-4.688831>,
<-0.056522,0.218339,-0.974235>,
<0.835317,5.527479,-4.788658>,
<-0.056522,0.218339,-0.974235>,
<0.852606,6.060908,-4.670113>,
<-0.056522,0.218339,-0.974235>
}
smooth_triangle {
<0.792379,6.043211,-4.127004>,
<-0.120977,0.992475,0.018924>,
<-2.473310,5.643238,-4.027177>,
<-0.120977,0.992475,0.018924>,
<-2.568597,5.641888,-4.565530>,
<-0.120977,0.992475,0.018924>
}
smooth_triangle {
<-2.568597,5.641888,-4.565530>,
<-0.120977,0.992475,0.018923>,
<0.852606,6.060908,-4.670113>,
<-0.120977,0.992475,0.018923>,
<0.792379,6.043211,-4.127004>,
<-0.120977,0.992475,0.018923>
}
smooth_triangle {
<-2.096773,2.693907,-6.110496>,
<0.122692,-0.894459,0.429988>,
<1.013411,3.074826,-6.205563>,
<0.122692,-0.894459,0.429988>,
<1.104761,2.851512,-6.696165>,
<0.122692,-0.894459,0.429988>
}
smooth_triangle {
<1.104761,2.851512,-6.696165>,
<0.122693,-0.894456,0.429994>,
<-2.160935,2.451546,-6.596338>,
<0.122693,-0.894456,0.429994>,
<-2.096773,2.693907,-6.110496>,
<0.122693,-0.894456,0.429994>
}
smooth_triangle {
<1.023407,3.605776,-6.335525>,
<0.000572,0.237744,0.971328>,
<1.013411,3.074826,-6.205563>,
<0.000572,0.237744,0.971328>,
<-2.096773,2.693907,-6.110496>,
<0.000572,0.237744,0.971328>
}
smooth_triangle {
<-2.096773,2.693907,-6.110496>,
<0.000576,0.237733,0.971330>,
<-2.242289,3.205810,-6.235698>,
<0.000576,0.237733,0.971330>,
<1.023407,3.605776,-6.335525>,
<0.000576,0.237733,0.971330>
}
smooth_triangle {
<-2.306451,2.963451,-6.721547>,
<-0.122692,0.894458,-0.429990>,
<1.114753,3.382463,-6.826122>,
<-0.122692,0.894458,-0.429990>,
<1.023407,3.605776,-6.335525>,
<-0.122692,0.894458,-0.429990>
}
smooth_triangle {
<1.023407,3.605776,-6.335525>,
<-0.122693,0.894460,-0.429986>,
<-2.242289,3.205810,-6.235698>,
<-0.122693,0.894460,-0.429986>,
<-2.306451,2.963451,-6.721547>,
<-0.122693,0.894460,-0.429986>
}
smooth_triangle {
<-2.160935,2.451546,-6.596338>,
<-0.000575,-0.237735,-0.971330>,
<1.104761,2.851512,-6.696165>,
<-0.000575,-0.237735,-0.971330>,
<1.114753,3.382463,-6.826122>,
<-0.000575,-0.237735,-0.971330>
}
smooth_triangle {
<1.114753,3.382463,-6.826122>,
<-0.000573,-0.237744,-0.971328>,
<-2.306451,2.963451,-6.721547>,
<-0.000573,-0.237744,-0.971328>,
<-2.160935,2.451546,-6.596338>,
<-0.000573,-0.237744,-0.971328>
}
smooth_triangle {
<-2.335088,5.128850,-4.150482>,
<0.859665,-0.316604,0.400921>,
<-3.332980,6.012376,-1.313060>,
<0.859665,-0.316604,0.400921>,
<-3.141740,6.524517,-1.318688>,
<0.859665,-0.316604,0.400921>
}
smooth_triangle {
<-3.141740,6.524517,-1.318688>,
<0.859665,-0.316604,0.400921>,
<-2.093952,5.596821,-4.297979>,
<0.859665,-0.316604,0.400921>,
<-2.335088,5.128850,-4.150482>,
<0.859665,-0.316604,0.400921>
}
smooth_triangle {
<-3.857518,6.101619,-1.438738>,
<-0.214753,-0.951400,0.220724>,
<-3.332980,6.012376,-1.313060>,
<-0.214753,-0.951400,0.220724>,
<-2.335088,5.128850,-4.150482>,
<-0.214753,-0.951400,0.220724>
}
smooth_triangle {
<-2.335088,5.128850,-4.150482>,
<-0.214762,-0.951399,0.220718>,
<-2.809730,5.173923,-4.418029>,
<-0.214762,-0.951399,0.220718>,
<-3.857518,6.101619,-1.438738>,
<-0.214762,-0.951399,0.220718>
}
smooth_triangle {
<-2.568597,5.641888,-4.565530>,
<-0.859667,0.316601,-0.400920>,
<-3.666278,6.613766,-1.444366>,
<-0.859667,0.316601,-0.400920>,
<-3.857518,6.101619,-1.438738>,
<-0.859667,0.316601,-0.400920>
}
smooth_triangle {
<-3.857518,6.101619,-1.438738>,
<-0.859667,0.316600,-0.400920>,
<-2.809730,5.173923,-4.418029>,
<-0.859667,0.316600,-0.400920>,
<-2.568597,5.641888,-4.565530>,
<-0.859667,0.316600,-0.400920>
}
smooth_triangle {
<-2.093952,5.596821,-4.297979>,
<0.214763,0.951399,-0.220718>,
<-3.141740,6.524517,-1.318688>,
<0.214763,0.951399,-0.220718>,
<-3.666278,6.613766,-1.444366>,
<0.214763,0.951399,-0.220718>
}
smooth_triangle {
<-3.666278,6.613766,-1.444366>,
<0.214754,0.951400,-0.220723>,
<-2.568597,5.641888,-4.565530>,
<0.214754,0.951400,-0.220723>,
<-2.093952,5.596821,-4.297979>,
<0.214754,0.951400,-0.220723>
}
smooth_triangle {
<-3.332980,6.012376,-1.313060>,
<0.401718,-0.488871,0.774356>,
<-5.633600,3.888058,-1.460690>,
<0.401718,-0.488871,0.774356>,
<-5.987492,4.132197,-1.122968>,
<0.401718,-0.488871,0.774356>
}
smooth_triangle {
<-5.987492,4.132197,-1.122968>,
<0.401717,-0.488871,0.774357>,
<-3.571841,6.362726,-0.967960>,
<0.401717,-0.488871,0.774357>,
<-3.332980,6.012376,-1.313060>,
<0.401717,-0.488871,0.774357>
}
smooth_triangle {
<-5.843068,4.032881,-1.944474>,
<0.618503,-0.637952,-0.458772>,
<-5.633600,3.888058,-1.460690>,
<0.618503,-0.637952,-0.458772>,
<-3.332980,6.012376,-1.313060>,
<0.618503,-0.637952,-0.458772>
}
smooth_triangle {
<-3.332980,6.012376,-1.313060>,
<0.618504,-0.637956,-0.458765>,
<-3.427417,6.263410,-1.789466>,
<0.618504,-0.637956,-0.458765>,
<-5.843068,4.032881,-1.944474>,
<0.618504,-0.637956,-0.458765>
}
smooth_triangle {
<-3.666278,6.613766,-1.444366>,
<-0.401716,0.488869,-0.774359>,
<-6.196958,4.277015,-1.606759>,
<-0.401716,0.488869,-0.774359>,
<-5.843068,4.032881,-1.944474>,
<-0.401716,0.488869,-0.774359>
}
smooth_triangle {
<-5.843068,4.032881,-1.944474>,
<-0.401714,0.488868,-0.774360>,
<-3.427417,6.263410,-1.789466>,
<-0.401714,0.488868,-0.774360>,
<-3.666278,6.613766,-1.444366>,
<-0.401714,0.488868,-0.774360>
}
smooth_triangle {
<-3.571841,6.362726,-0.967960>,
<-0.618506,0.637957,0.458761>,
<-5.987492,4.132197,-1.122968>,
<-0.618506,0.637957,0.458761>,
<-6.196958,4.277015,-1.606759>,
<-0.618506,0.637957,0.458761>
}
smooth_triangle {
<-6.196958,4.277015,-1.606759>,
<-0.618504,0.637952,0.458771>,
<-3.666278,6.613766,-1.444366>,
<-0.618504,0.637952,0.458771>,
<-3.571841,6.362726,-0.967960>,
<-0.618504,0.637952,0.458771>
}
smooth_triangle {
<-5.633600,3.888058,-1.460690>,
<0.220844,-0.906466,0.359927>,
<-4.635708,3.004532,-4.298112>,
<0.220844,-0.906466,0.359927>,
<-5.109573,2.812298,-4.491494>,
<0.220844,-0.906466,0.359927>
}
smooth_triangle {
<-5.109573,2.812298,-4.491494>,
<0.220845,-0.906466,0.359927>,
<-6.157361,3.740001,-1.512196>,
<0.220845,-0.906466,0.359927>,
<-5.633600,3.888058,-1.460690>,
<0.220845,-0.906466,0.359927>
}
smooth_triangle {
<-4.625411,3.497374,-4.534544>,
<0.947596,0.121872,0.295311>,
<-4.635708,3.004532,-4.298112>,
<0.947596,0.121872,0.295311>,
<-5.633600,3.888058,-1.460690>,
<0.947596,0.121872,0.295311>
}
smooth_triangle {
<-5.633600,3.888058,-1.460690>,
<0.947596,0.121871,0.295311>,
<-5.673199,4.425077,-1.555246>,
<0.947596,0.121871,0.295311>,
<-4.625411,3.497374,-4.534544>,
<0.947596,0.121871,0.295311>
}
smooth_triangle {
<-6.196958,4.277015,-1.606759>,
<-0.220851,0.906463,-0.359929>,
<-5.099277,3.305137,-4.727922>,
<-0.220851,0.906463,-0.359929>,
<-4.625411,3.497374,-4.534544>,
<-0.220851,0.906463,-0.359929>
}
smooth_triangle {
<-4.625411,3.497374,-4.534544>,
<-0.220849,0.906464,-0.359928>,
<-5.673199,4.425077,-1.555246>,
<-0.220849,0.906464,-0.359928>,
<-6.196958,4.277015,-1.606759>,
<-0.220849,0.906464,-0.359928>
}
smooth_triangle {
<-6.157361,3.740001,-1.512196>,
<-0.947596,-0.121872,-0.295311>,
<-5.109573,2.812298,-4.491494>,
<-0.947596,-0.121872,-0.295311>,
<-5.099277,3.305137,-4.727922>,
<-0.947596,-0.121872,-0.295311>
}
smooth_triangle {
<-5.099277,3.305137,-4.727922>,
<-0.947596,-0.121873,-0.295311>,
<-6.196958,4.277015,-1.606759>,
<-0.947596,-0.121873,-0.295311>,
<-6.157361,3.740001,-1.512196>,
<-0.947596,-0.121873,-0.295311>
}
smooth_triangle {
<-3.384248,5.850361,1.817193>,
<0.604270,-0.682941,0.410427>,
<-5.684868,3.726043,1.669570>,
<0.604270,-0.682941,0.410427>,
<-5.910268,3.820515,2.158625>,
<0.604270,-0.682941,0.410427>
}
smooth_triangle {
<-5.910268,3.820515,2.158625>,
<0.604270,-0.682942,0.410423>,
<-3.494617,6.051044,2.313626>,
<0.604270,-0.682942,0.410423>,
<-3.384248,5.850361,1.817193>,
<0.604270,-0.682942,0.410423>
}
smooth_triangle {
<-6.027952,4.004335,1.347479>,
<0.427613,-0.407011,-0.807148>,
<-5.684868,3.726043,1.669570>,
<0.427613,-0.407011,-0.807148>,
<-3.384248,5.850361,1.817193>,
<0.427613,-0.407011,-0.807148>
}
smooth_triangle {
<-3.384248,5.850361,1.817193>,
<0.427616,-0.407017,-0.807144>,
<-3.612301,6.234864,1.502480>,
<0.427616,-0.407017,-0.807144>,
<-6.027952,4.004335,1.347479>,
<0.427616,-0.407017,-0.807144>
}
smooth_triangle {
<-3.722673,6.435549,1.998912>,
<-0.604268,0.682940,-0.410429>,
<-6.253357,4.098801,1.836528>,
<-0.604268,0.682940,-0.410429>,
<-6.027952,4.004335,1.347479>,
<-0.604268,0.682940,-0.410429>
}
smooth_triangle {
<-6.027952,4.004335,1.347479>,
<-0.604268,0.682940,-0.410429>,
<-3.612301,6.234864,1.502480>,
<-0.604268,0.682940,-0.410429>,
<-3.722673,6.435549,1.998912>,
<-0.604268,0.682940,-0.410429>
}
smooth_triangle {
<-3.494617,6.051044,2.313626>,
<-0.427617,0.407018,0.807143>,
<-5.910268,3.820515,2.158625>,
<-0.427617,0.407018,0.807143>,
<-6.253357,4.098801,1.836528>,
<-0.427617,0.407018,0.807143>
}
smooth_triangle {
<-6.253357,4.098801,1.836528>,
<-0.427616,0.407015,0.807145>,
<-3.722673,6.435549,1.998912>,
<-0.427616,0.407015,0.807145>,
<-3.494617,6.051044,2.313626>,
<-0.427616,0.407015,0.807145>
}
smooth_triangle {
<-1.650376,5.225919,4.353167>,
<-0.184485,-0.976174,-0.114233>,
<-3.384248,5.850361,1.817193>,
<-0.184485,-0.976174,-0.114233>,
<-3.867178,5.912535,2.065812>,
<-0.184485,-0.976174,-0.114233>
}
smooth_triangle {
<-3.867178,5.912535,2.065812>,
<-0.184487,-0.976174,-0.114230>,
<-2.046611,5.256873,4.728584>,
<-0.184487,-0.976174,-0.114230>,
<-1.650376,5.225919,4.353167>,
<-0.184487,-0.976174,-0.114230>
}
smooth_triangle {
<-3.239740,6.373373,1.750294>,
<0.757329,-0.284440,-0.587832>,
<-3.384248,5.850361,1.817193>,
<0.757329,-0.284440,-0.587832>,
<-1.650376,5.225919,4.353167>,
<0.757329,-0.284440,-0.587832>
}
smooth_triangle {
<-1.650376,5.225919,4.353167>,
<0.757328,-0.284441,-0.587833>,
<-1.419173,5.717711,4.413066>,
<0.757328,-0.284441,-0.587833>,
<-3.239740,6.373373,1.750294>,
<0.757328,-0.284441,-0.587833>
}
smooth_triangle {
<-1.815414,5.748664,4.788484>,
<0.184487,0.976174,0.114231>,
<-3.722673,6.435549,1.998912>,
<0.184487,0.976174,0.114231>,
<-3.239740,6.373373,1.750294>,
<0.184487,0.976174,0.114231>
}
smooth_triangle {
<-3.239740,6.373373,1.750294>,
<0.184484,0.976174,0.114232>,
<-1.419173,5.717711,4.413066>,
<0.184484,0.976174,0.114232>,
<-1.815414,5.748664,4.788484>,
<0.184484,0.976174,0.114232>
}
smooth_triangle {
<-2.046611,5.256873,4.728584>,
<-0.757330,0.284436,0.587833>,
<-3.867178,5.912535,2.065812>,
<-0.757330,0.284436,0.587833>,
<-3.722673,6.435549,1.998912>,
<-0.757330,0.284436,0.587833>
}
smooth_triangle {
<-3.722673,6.435549,1.998912>,
<-0.757331,0.284434,0.587832>,
<-1.815414,5.748664,4.788484>,
<-0.757331,0.284434,0.587832>,
<-2.046611,5.256873,4.728584>,
<-0.757331,0.284434,0.587832>
}
smooth_triangle {
<-2.879408,2.715670,5.772858>,
<-0.283185,-0.363329,-0.887580>,
<-1.650376,5.225919,4.353167>,
<-0.283185,-0.363329,-0.887580>,
<-2.093231,5.546344,4.363296>,
<-0.283185,-0.363329,-0.887580>
}
smooth_triangle {
<-2.093231,5.546344,4.363296>,
<-0.283185,-0.363329,-0.887580>,
<-3.383716,2.910578,5.853974>,
<-0.283185,-0.363329,-0.887580>,
<-2.879408,2.715670,5.772858>,
<-0.283185,-0.363329,-0.887580>
}
smooth_triangle {
<-1.372553,5.428240,4.778354>,
<0.798587,-0.540617,-0.264560>,
<-1.650376,5.225919,4.353167>,
<0.798587,-0.540617,-0.264560>,
<-2.879408,2.715670,5.772858>,
<0.798587,-0.540617,-0.264560>
}
smooth_triangle {
<-2.879408,2.715670,5.772858>,
<0.798586,-0.540617,-0.264562>,
<-2.663038,2.792474,6.269032>,
<0.798586,-0.540617,-0.264562>,
<-1.372553,5.428240,4.778354>,
<0.798586,-0.540617,-0.264562>
}
smooth_triangle {
<-3.167348,2.987388,6.350141>,
<0.283183,0.363329,0.887581>,
<-1.815414,5.748664,4.788484>,
<0.283183,0.363329,0.887581>,
<-1.372553,5.428240,4.778354>,
<0.283183,0.363329,0.887581>
}
smooth_triangle {
<-1.372553,5.428240,4.778354>,
<0.283179,0.363332,0.887581>,
<-2.663038,2.792474,6.269032>,
<0.283179,0.363332,0.887581>,
<-3.167348,2.987388,6.350141>,
<0.283179,0.363332,0.887581>
}
smooth_triangle {
<-3.383716,2.910578,5.853974>,
<-0.798591,0.540615,0.264554>,
<-2.093231,5.546344,4.363296>,
<-0.798591,0.540615,0.264554>,
<-1.815414,5.748664,4.788484>,
<-0.798591,0.540615,0.264554>
}
smooth_triangle {
<-1.815414,5.748664,4.788484>,
<-0.798589,0.540615,0.264557>,
<-3.167348,2.987388,6.350141>,
<-0.798589,0.540615,0.264557>,
<-3.383716,2.910578,5.853974>,
<-0.798589,0.540615,0.264557>
}
smooth_triangle {
<-2.323307,-0.257013,6.598256>,
<0.598990,-0.516764,-0.611692>,
<-4.816756,-1.183988,4.939704>,
<0.598990,-0.516764,-0.611692>,
<-4.929155,-1.641879,5.216470>,
<0.598990,-0.516764,-0.611692>
}
smooth_triangle {
<-4.929155,-1.641879,5.216470>,
<0.598990,-0.516765,-0.611690>,
<-2.311036,-0.668557,6.957951>,
<0.598990,-0.516765,-0.611690>,
<-2.323307,-0.257013,6.598256>,
<0.598990,-0.516765,-0.611690>
}
smooth_triangle {
<-5.186027,-0.844341,5.156900>,
<0.213414,0.680369,-0.701107>,
<-4.816756,-1.183988,4.939704>,
<0.213414,0.680369,-0.701107>,
<-2.323307,-0.257013,6.598256>,
<0.213414,0.680369,-0.701107>
}
smooth_triangle {
<-2.323307,-0.257013,6.598256>,
<0.213412,0.680373,-0.701105>,
<-2.567908,0.128981,6.898381>,
<0.213412,0.680373,-0.701105>,
<-5.186027,-0.844341,5.156900>,
<0.213412,0.680373,-0.701105>
}
smooth_triangle {
<-2.555637,-0.282562,7.258081>,
<-0.598989,0.516772,0.611686>,
<-5.298430,-1.302234,5.433673>,
<-0.598989,0.516772,0.611686>,
<-5.186027,-0.844341,5.156900>,
<-0.598989,0.516772,0.611686>
}
smooth_triangle {
<-5.186027,-0.844341,5.156900>,
<-0.598989,0.516771,0.611686>,
<-2.567908,0.128981,6.898381>,
<-0.598989,0.516771,0.611686>,
<-2.555637,-0.282562,7.258081>,
<-0.598989,0.516771,0.611686>
}
smooth_triangle {
<-2.311036,-0.668557,6.957951>,
<-0.213408,-0.680378,0.701101>,
<-4.929155,-1.641879,5.216470>,
<-0.213408,-0.680378,0.701101>,
<-5.298430,-1.302234,5.433673>,
<-0.213408,-0.680378,0.701101>
}
smooth_triangle {
<-5.298430,-1.302234,5.433673>,
<-0.213409,-0.680376,0.701103>,
<-2.555637,-0.282562,7.258081>,
<-0.213409,-0.680376,0.701103>,
<-2.311036,-0.668557,6.957951>,
<-0.213409,-0.680376,0.701103>
}
smooth_triangle {
<-5.372864,1.788695,4.114299>,
<0.444574,0.308666,-0.840880>,
<-2.879408,2.715670,5.772858>,
<0.444574,0.308666,-0.840880>,
<-3.039967,3.227993,5.876031>,
<0.444574,0.308666,-0.840880>
}
smooth_triangle {
<-3.039967,3.227993,5.876031>,
<0.444573,0.308666,-0.840880>,
<-5.658100,2.254671,4.134543>,
<0.444573,0.308666,-0.840880>,
<-5.372864,1.788695,4.114299>,
<0.444573,0.308666,-0.840880>
}
smooth_triangle {
<-3.006787,2.475059,6.246975>,
<0.494376,-0.821514,-0.284091>,
<-2.879408,2.715670,5.772858>,
<0.494376,-0.821514,-0.284091>,
<-5.372864,1.788695,4.114299>,
<0.494376,-0.821514,-0.284091>
}
smooth_triangle {
<-5.372864,1.788695,4.114299>,
<0.494373,-0.821517,-0.284087>,
<-5.624920,1.501737,4.505487>,
<0.494373,-0.821517,-0.284087>,
<-3.006787,2.475059,6.246975>,
<0.494373,-0.821517,-0.284087>
}
smooth_triangle {
<-5.910149,1.967717,4.525728>,
<-0.444579,-0.308654,0.840882>,
<-3.167348,2.987388,6.350141>,
<-0.444579,-0.308654,0.840882>,
<-3.006787,2.475059,6.246975>,
<-0.444579,-0.308654,0.840882>
}
smooth_triangle {
<-3.006787,2.475059,6.246975>,
<-0.444578,-0.308655,0.840882>,
<-5.624920,1.501737,4.505487>,
<-0.444578,-0.308655,0.840882>,
<-5.910149,1.967717,4.525728>,
<-0.444578,-0.308655,0.840882>
}
smooth_triangle {
<-5.658100,2.254671,4.134543>,
<-0.494372,0.821518,0.284085>,
<-3.039967,3.227993,5.876031>,
<-0.494372,0.821518,0.284085>,
<-3.167348,2.987388,6.350141>,
<-0.494372,0.821518,0.284085>
}
smooth_triangle {
<-3.167348,2.987388,6.350141>,
<-0.494374,0.821516,0.284088>,
<-5.910149,1.967717,4.525728>,
<-0.494374,0.821516,0.284088>,
<-5.658100,2.254671,4.134543>,
<-0.494374,0.821516,0.284088>
}
smooth_triangle {
<-4.635708,3.004532,-4.298112>,
<0.145466,-0.136212,0.979942>,
<-5.248005,-0.051766,-4.632047>,
<0.145466,-0.136212,0.979942>,
<-5.788097,-0.032999,-4.549265>,
<0.145466,-0.136212,0.979942>
}
smooth_triangle {
<-5.788097,-0.032999,-4.549265>,
<0.145464,-0.136211,0.979942>,
<-5.145182,3.176116,-4.198635>,
<0.145464,-0.136211,0.979942>,
<-4.635708,3.004532,-4.298112>,
<0.145464,-0.136211,0.979942>
}
smooth_triangle {
<-5.232717,-0.075559,-5.178033>,
<0.979108,-0.200102,0.036136>,
<-5.248005,-0.051766,-4.632047>,
<0.979108,-0.200102,0.036136>,
<-4.635708,3.004532,-4.298112>,
<0.979108,-0.200102,0.036136>
}
smooth_triangle {
<-4.635708,3.004532,-4.298112>,
<0.979108,-0.200103,0.036140>,
<-4.589802,3.133556,-4.827403>,
<0.979108,-0.200103,0.036140>,
<-5.232717,-0.075559,-5.178033>,
<0.979108,-0.200103,0.036140>
}
smooth_triangle {
<-5.099277,3.305137,-4.727922>,
<-0.145469,0.136213,-0.979941>,
<-5.772804,-0.056790,-5.095250>,
<-0.145469,0.136213,-0.979941>,
<-5.232717,-0.075559,-5.178033>,
<-0.145469,0.136213,-0.979941>
}
smooth_triangle {
<-5.232717,-0.075559,-5.178033>,
<-0.145472,0.136213,-0.979941>,
<-4.589802,3.133556,-4.827403>,
<-0.145472,0.136213,-0.979941>,
<-5.099277,3.305137,-4.727922>,
<-0.145472,0.136213,-0.979941>
}
smooth_triangle {
<-5.145182,3.176116,-4.198635>,
<-0.979108,0.200104,-0.036144>,
<-5.788097,-0.032999,-4.549265>,
<-0.979108,0.200104,-0.036144>,
<-5.772804,-0.056790,-5.095250>,
<-0.979108,0.200104,-0.036144>
}
smooth_triangle {
<-5.772804,-0.056790,-5.095250>,
<-0.979108,0.200103,-0.036140>,
<-5.099277,3.305137,-4.727922>,
<-0.979108,0.200103,-0.036140>,
<-5.145182,3.176116,-4.198635>,
<-0.979108,0.200103,-0.036140>
}
smooth_triangle {
<-2.709077,-0.362398,-6.444424>,
<0.850451,-0.222464,0.476699>,
<-2.096773,2.693907,-6.110496>,
<0.850451,-0.222464,0.476699>,
<-1.817179,2.768954,-6.574281>,
<0.850451,-0.222464,0.476699>
}
smooth_triangle {
<-1.817179,2.768954,-6.574281>,
<0.850455,-0.222465,0.476692>,
<-2.460101,-0.440168,-6.924911>,
<0.850455,-0.222465,0.476692>,
<-2.709077,-0.362398,-6.444424>,
<0.850455,-0.222465,0.476692>
}
smooth_triangle {
<-2.586045,2.888402,-6.257755>,
<-0.303631,-0.043164,0.951812>,
<-2.096773,2.693907,-6.110496>,
<-0.303631,-0.043164,0.951812>,
<-2.709077,-0.362398,-6.444424>,
<-0.303631,-0.043164,0.951812>
}
smooth_triangle {
<-2.709077,-0.362398,-6.444424>,
<-0.303638,-0.043164,0.951809>,
<-3.228967,-0.320720,-6.608385>,
<-0.303638,-0.043164,0.951809>,
<-2.586045,2.888402,-6.257755>,
<-0.303638,-0.043164,0.951809>
}
smooth_triangle {
<-2.979984,-0.398485,-7.088865>,
<-0.850455,0.222464,-0.476694>,
<-2.306451,2.963451,-6.721547>,
<-0.850455,0.222464,-0.476694>,
<-2.586045,2.888402,-6.257755>,
<-0.850455,0.222464,-0.476694>
}
smooth_triangle {
<-2.586045,2.888402,-6.257755>,
<-0.850448,0.222465,-0.476704>,
<-3.228967,-0.320720,-6.608385>,
<-0.850448,0.222465,-0.476704>,
<-2.979984,-0.398485,-7.088865>,
<-0.850448,0.222465,-0.476704>
}
smooth_triangle {
<-2.460101,-0.440168,-6.924911>,
<0.303643,0.043163,-0.951808>,
<-1.817179,2.768954,-6.574281>,
<0.303643,0.043163,-0.951808>,
<-2.306451,2.963451,-6.721547>,
<0.303643,0.043163,-0.951808>
}
smooth_triangle {
<-2.306451,2.963451,-6.721547>,
<0.303631,0.043163,-0.951811>,
<-2.979984,-0.398485,-7.088865>,
<0.303631,0.043163,-0.951811>,
<-2.460101,-0.440168,-6.924911>,
<0.303631,0.043163,-0.951811>
}
smooth_triangle {
<-5.248005,-0.051766,-4.632047>,
<0.534239,0.657866,0.530849>,
<-6.624324,-1.057141,-2.001006>,
<0.534239,0.657866,0.530849>,
<-7.049595,-0.713567,-1.998801>,
<0.534239,0.657866,0.530849>
}
smooth_triangle {
<-7.049595,-0.713567,-1.998801>,
<0.534239,0.657866,0.530849>,
<-5.604459,0.342075,-4.761393>,
<0.534239,0.657866,0.530849>,
<-5.248005,-0.051766,-4.632047>,
<0.534239,0.657866,0.530849>
}
smooth_triangle {
<-6.861491,-1.506275,-2.203313>,
<0.816590,-0.532040,0.223862>,
<-6.624324,-1.057141,-2.001006>,
<0.816590,-0.532040,0.223862>,
<-5.248005,-0.051766,-4.632047>,
<0.816590,-0.532040,0.223862>
}
smooth_triangle {
<-5.248005,-0.051766,-4.632047>,
<0.816591,-0.532037,0.223864>,
<-5.416355,-0.450633,-4.965905>,
<0.816591,-0.532037,0.223864>,
<-6.861491,-1.506275,-2.203313>,
<0.816591,-0.532037,0.223864>
}
smooth_triangle {
<-5.772804,-0.056790,-5.095250>,
<-0.534244,-0.657862,-0.530850>,
<-7.286755,-1.162702,-2.201106>,
<-0.534244,-0.657862,-0.530850>,
<-6.861491,-1.506275,-2.203313>,
<-0.534244,-0.657862,-0.530850>
}
smooth_triangle {
<-6.861491,-1.506275,-2.203313>,
<-0.534245,-0.657861,-0.530850>,
<-5.416355,-0.450633,-4.965905>,
<-0.534245,-0.657861,-0.530850>,
<-5.772804,-0.056790,-5.095250>,
<-0.534245,-0.657861,-0.530850>
}
smooth_triangle {
<-5.604459,0.342075,-4.761393>,
<-0.816595,0.532030,-0.223868>,
<-7.049595,-0.713567,-1.998801>,
<-0.816595,0.532030,-0.223868>,
<-7.286755,-1.162702,-2.201106>,
<-0.816595,0.532030,-0.223868>
}
smooth_triangle {
<-7.286755,-1.162702,-2.201106>,
<-0.816594,0.532032,-0.223867>,
<-5.772804,-0.056790,-5.095250>,
<-0.816594,0.532032,-0.223867>,
<-5.604459,0.342075,-4.761393>,
<-0.816594,0.532032,-0.223867>
}
smooth_triangle {
<-5.314421,-3.878015,-2.393699>,
<0.897968,-0.125414,0.421811>,
<-3.938102,-2.872647,-5.024740>,
<0.897968,-0.125414,0.421811>,
<-3.887450,-3.355493,-5.276131>,
<0.897968,-0.125414,0.421811>
}
smooth_triangle {
<-3.887450,-3.355493,-5.276131>,
<0.897968,-0.125417,0.421811>,
<-5.332586,-4.411128,-2.513539>,
<0.897968,-0.125417,0.421811>,
<-5.314421,-3.878015,-2.393699>,
<0.897968,-0.125417,0.421811>
}
smooth_triangle {
<-4.382560,-2.676913,-5.275823>,
<0.154791,0.893159,0.422264>,
<-3.938102,-2.872647,-5.024740>,
<0.154791,0.893159,0.422264>,
<-5.314421,-3.878015,-2.393699>,
<0.154791,0.893159,0.422264>
}
smooth_triangle {
<-5.314421,-3.878015,-2.393699>,
<0.154792,0.893158,0.422265>,
<-5.827696,-3.732548,-2.513231>,
<0.154792,0.893158,0.422265>,
<-4.382560,-2.676913,-5.275823>,
<0.154792,0.893158,0.422265>
}
smooth_triangle {
<-5.845862,-4.265663,-2.633068>,
<-0.897968,0.125421,-0.421808>,
<-4.331913,-3.159759,-5.527215>,
<-0.897968,0.125421,-0.421808>,
<-4.382560,-2.676913,-5.275823>,
<-0.897968,0.125421,-0.421808>
}
smooth_triangle {
<-4.382560,-2.676913,-5.275823>,
<-0.897968,0.125416,-0.421811>,
<-5.827696,-3.732548,-2.513231>,
<-0.897968,0.125416,-0.421811>,
<-5.845862,-4.265663,-2.633068>,
<-0.897968,0.125416,-0.421811>
}
smooth_triangle {
<-5.332586,-4.411128,-2.513539>,
<-0.154789,-0.893160,-0.422263>,
<-3.887450,-3.355493,-5.276131>,
<-0.154789,-0.893160,-0.422263>,
<-4.331913,-3.159759,-5.527215>,
<-0.154789,-0.893160,-0.422263>
}
smooth_triangle {
<-4.331913,-3.159759,-5.527215>,
<-0.154791,-0.893159,-0.422264>,
<-5.845862,-4.265663,-2.633068>,
<-0.154791,-0.893159,-0.422264>,
<-5.332586,-4.411128,-2.513539>,
<-0.154791,-0.893159,-0.422264>
}
smooth_triangle {
<-6.312313,-2.994489,0.443723>,
<0.522177,0.732760,0.436342>,
<-4.431161,-5.123812,1.768347>,
<0.522177,0.732760,0.436342>,
<-4.712022,-5.199335,2.231285>,
<0.522177,0.732760,0.436342>
}
smooth_triangle {
<-4.712022,-5.199335,2.231285>,
<0.522178,0.732760,0.436341>,
<-6.687233,-2.963542,0.840427>,
<0.522178,0.732760,0.436341>,
<-6.312313,-2.994489,0.443723>,
<0.522178,0.732760,0.436341>
}
smooth_triangle {
<-4.593414,-5.560521,1.482243>,
<0.700213,0.190594,-0.688022>,
<-4.431161,-5.123812,1.768347>,
<0.700213,0.190594,-0.688022>,
<-6.312313,-2.994489,0.443723>,
<0.700213,0.190594,-0.688022>
}
smooth_triangle {
<-6.312313,-2.994489,0.443723>,
<0.700215,0.190596,-0.688020>,
<-6.568625,-3.324728,0.091385>,
<0.700215,0.190596,-0.688020>,
<-4.593414,-5.560521,1.482243>,
<0.700215,0.190596,-0.688020>
}
smooth_triangle {
<-6.943544,-3.293785,0.488095>,
<-0.522181,-0.732761,-0.436335>,
<-4.874275,-5.636038,1.945181>,
<-0.522181,-0.732761,-0.436335>,
<-4.593414,-5.560521,1.482243>,
<-0.522181,-0.732761,-0.436335>
}
smooth_triangle {
<-4.593414,-5.560521,1.482243>,
<-0.522178,-0.732760,-0.436340>,
<-6.568625,-3.324728,0.091385>,
<-0.522178,-0.732760,-0.436340>,
<-6.943544,-3.293785,0.488095>,
<-0.522178,-0.732760,-0.436340>
}
smooth_triangle {
<-6.687233,-2.963542,0.840427>,
<-0.700215,-0.190596,0.688021>,
<-4.712022,-5.199335,2.231285>,
<-0.700215,-0.190596,0.688021>,
<-4.874275,-5.636038,1.945181>,
<-0.700215,-0.190596,0.688021>
}
smooth_triangle {
<-4.874275,-5.636038,1.945181>,
<-0.700211,-0.190591,0.688025>,
<-6.943544,-3.293785,0.488095>,
<-0.700211,-0.190591,0.688025>,
<-6.687233,-2.963542,0.840427>,
<-0.700211,-0.190591,0.688025>
}
smooth_triangle {
<-3.433269,-6.007338,-1.069075>,
<0.799271,0.487429,-0.351539>,
<-5.314421,-3.878015,-2.393699>,
<0.799271,0.487429,-0.351539>,
<-5.379206,-4.121657,-2.878820>,
<0.799271,0.487429,-0.351539>
}
smooth_triangle {
<-5.379206,-4.121657,-2.878820>,
<0.799271,0.487427,-0.351541>,
<-3.403995,-6.357450,-1.487962>,
<0.799271,0.487427,-0.351541>,
<-3.433269,-6.007338,-1.069075>,
<0.799271,0.487427,-0.351541>
}
smooth_triangle {
<-5.781076,-4.022019,-2.147950>,
<0.196046,0.636983,0.745533>,
<-5.314421,-3.878015,-2.393699>,
<0.196046,0.636983,0.745533>,
<-3.433269,-6.007338,-1.069075>,
<0.196046,0.636983,0.745533>
}
smooth_triangle {
<-3.433269,-6.007338,-1.069075>,
<0.196046,0.636983,0.745533>,
<-3.805865,-6.257812,-0.757092>,
<0.196046,0.636983,0.745533>,
<-5.781076,-4.022019,-2.147950>,
<0.196046,0.636983,0.745533>
}
smooth_triangle {
<-3.776595,-6.607918,-1.175982>,
<-0.799271,-0.487426,0.351542>,
<-5.845862,-4.265663,-2.633068>,
<-0.799271,-0.487426,0.351542>,
<-5.781076,-4.022019,-2.147950>,
<-0.799271,-0.487426,0.351542>
}
smooth_triangle {
<-5.781076,-4.022019,-2.147950>,
<-0.799271,-0.487428,0.351540>,
<-3.805865,-6.257812,-0.757092>,
<-0.799271,-0.487428,0.351540>,
<-3.776595,-6.607918,-1.175982>,
<-0.799271,-0.487428,0.351540>
}
smooth_triangle {
<-3.403995,-6.357450,-1.487962>,
<-0.196047,-0.636983,-0.745532>,
<-5.379206,-4.121657,-2.878820>,
<-0.196047,-0.636983,-0.745532>,
<-5.845862,-4.265663,-2.633068>,
<-0.196047,-0.636983,-0.745532>
}
smooth_triangle {
<-5.845862,-4.265663,-2.633068>,
<-0.196047,-0.636983,-0.745532>,
<-3.776595,-6.607918,-1.175982>,
<-0.196047,-0.636983,-0.745532>,
<-3.403995,-6.357450,-1.487962>,
<-0.196047,-0.636983,-0.745532>
}
smooth_triangle {
<-6.862632,1.377809,-0.040999>,
<0.860140,0.447461,0.244821>,
<-6.550628,-0.559539,2.403730>,
<0.860140,0.447461,0.244821>,
<-6.813499,-0.258217,2.776557>,
<0.860140,0.447461,0.244821>
}
smooth_triangle {
<-6.813499,-0.258217,2.776557>,
<0.860138,0.447465,0.244823>,
<-7.141106,1.775997,0.209594>,
<0.860138,0.447465,0.244823>,
<-6.862632,1.377809,-0.040999>,
<0.860138,0.447465,0.244823>
}
smooth_triangle {
<-6.942817,-0.916665,2.271269>,
<0.666027,-0.540904,-0.513645>,
<-6.550628,-0.559539,2.403730>,
<0.666027,-0.540904,-0.513645>,
<-6.862632,1.377809,-0.040999>,
<0.666027,-0.540904,-0.513645>
}
smooth_triangle {
<-6.862632,1.377809,-0.040999>,
<0.666024,-0.540906,-0.513647>,
<-7.270424,1.117549,-0.295694>,
<0.666024,-0.540906,-0.513647>,
<-6.942817,-0.916665,2.271269>,
<0.666024,-0.540906,-0.513647>
}
smooth_triangle {
<-7.548898,1.515743,-0.045099>,
<-0.860142,-0.447460,-0.244818>,
<-7.205689,-0.615340,2.644102>,
<-0.860142,-0.447460,-0.244818>,
<-6.942817,-0.916665,2.271269>,
<-0.860142,-0.447460,-0.244818>
}
smooth_triangle {
<-6.942817,-0.916665,2.271269>,
<-0.860141,-0.447461,-0.244819>,
<-7.270424,1.117549,-0.295694>,
<-0.860141,-0.447461,-0.244819>,
<-7.548898,1.515743,-0.045099>,
<-0.860141,-0.447461,-0.244819>
}
smooth_triangle {
<-7.141106,1.775997,0.209594>,
<-0.666020,0.540909,0.513649>,
<-6.813499,-0.258217,2.776557>,
<-0.666020,0.540909,0.513649>,
<-7.205689,-0.615340,2.644102>,
<-0.666020,0.540909,0.513649>
}
smooth_triangle {
<-7.205689,-0.615340,2.644102>,
<-0.666018,0.540910,0.513650>,
<-7.548898,1.515743,-0.045099>,
<-0.666018,0.540910,0.513650>,
<-7.141106,1.775997,0.209594>,
<-0.666018,0.540910,0.513650>
}
smooth_triangle {
<-6.550628,-0.559539,2.403730>,
<0.936548,-0.159573,0.312114>,
<-6.312313,-2.994489,0.443723>,
<0.936548,-0.159573,0.312114>,
<-6.491506,-3.385026,0.781753>,
<0.936548,-0.159573,0.312114>
}
smooth_triangle {
<-6.491506,-3.385026,0.781753>,
<0.936549,-0.159571,0.312111>,
<-6.741735,-0.828332,2.839760>,
<0.936549,-0.159571,0.312111>,
<-6.550628,-0.559539,2.403730>,
<0.936549,-0.159571,0.312111>
}
smooth_triangle {
<-6.764352,-2.903244,0.150059>,
<0.527001,0.563604,-0.636098>,
<-6.312313,-2.994489,0.443723>,
<0.527001,0.563604,-0.636098>,
<-6.550628,-0.559539,2.403730>,
<0.527001,0.563604,-0.636098>
}
smooth_triangle {
<-6.550628,-0.559539,2.403730>,
<0.527000,0.563605,-0.636098>,
<-7.014581,-0.346550,2.208066>,
<0.527000,0.563605,-0.636098>,
<-6.764352,-2.903244,0.150059>,
<0.527000,0.563605,-0.636098>
}
smooth_triangle {
<-7.205689,-0.615340,2.644102>,
<-0.936550,0.159569,-0.312109>,
<-6.943544,-3.293785,0.488095>,
<-0.936550,0.159569,-0.312109>,
<-6.764352,-2.903244,0.150059>,
<-0.936550,0.159569,-0.312109>
}
smooth_triangle {
<-6.764352,-2.903244,0.150059>,
<-0.936549,0.159570,-0.312110>,
<-7.014581,-0.346550,2.208066>,
<-0.936549,0.159570,-0.312110>,
<-7.205689,-0.615340,2.644102>,
<-0.936549,0.159570,-0.312110>
}
smooth_triangle {
<-6.741735,-0.828332,2.839760>,
<-0.526992,-0.563607,0.636102>,
<-6.491506,-3.385026,0.781753>,
<-0.526992,-0.563607,0.636102>,
<-6.943544,-3.293785,0.488095>,
<-0.526992,-0.563607,0.636102>
}
smooth_triangle {
<-6.943544,-3.293785,0.488095>,
<-0.526995,-0.563606,0.636101>,
<-7.205689,-0.615340,2.644102>,
<-0.526995,-0.563606,0.636101>,
<-6.741735,-0.828332,2.839760>,
<-0.526995,-0.563606,0.636101>
}
smooth_triangle {
<-6.624324,-1.057141,-2.001006>,
<0.849913,0.378371,-0.366720>,
<-6.862632,1.377809,-0.040999>,
<0.849913,0.378371,-0.366720>,
<-7.150710,1.711114,-0.364756>,
<0.849913,0.378371,-0.366720>
}
smooth_triangle {
<-7.150710,1.711114,-0.364756>,
<0.849913,0.378371,-0.366720>,
<-6.900488,-0.845580,-2.422763>,
<0.849913,0.378371,-0.366720>,
<-6.624324,-1.057141,-2.001006>,
<0.849913,0.378371,-0.366720>
}
smooth_triangle {
<-7.260820,1.182432,0.278656>,
<0.684638,-0.415207,0.599061>,
<-6.862632,1.377809,-0.040999>,
<0.684638,-0.415207,0.599061>,
<-6.624324,-1.057141,-2.001006>,
<0.684638,-0.415207,0.599061>
}
smooth_triangle {
<-6.624324,-1.057141,-2.001006>,
<0.684635,-0.415209,0.599062>,
<-7.010598,-1.374262,-1.779351>,
<0.684635,-0.415209,0.599062>,
<-7.260820,1.182432,0.278656>,
<0.684635,-0.415209,0.599062>
}
smooth_triangle {
<-7.286755,-1.162702,-2.201106>,
<-0.849914,-0.378370,0.366717>,
<-7.548898,1.515743,-0.045099>,
<-0.849914,-0.378370,0.366717>,
<-7.260820,1.182432,0.278656>,
<-0.849914,-0.378370,0.366717>
}
smooth_triangle {
<-7.260820,1.182432,0.278656>,
<-0.849917,-0.378367,0.366714>,
<-7.010598,-1.374262,-1.779351>,
<-0.849917,-0.378367,0.366714>,
<-7.286755,-1.162702,-2.201106>,
<-0.849917,-0.378367,0.366714>
}
smooth_triangle {
<-6.900488,-0.845580,-2.422763>,
<-0.684637,0.415209,-0.599061>,
<-7.150710,1.711114,-0.364756>,
<-0.684637,0.415209,-0.599061>,
<-7.548898,1.515743,-0.045099>,
<-0.684637,0.415209,-0.599061>
}
smooth_triangle {
<-7.548898,1.515743,-0.045099>,
<-0.684643,0.415203,-0.599058>,
<-7.286755,-1.162702,-2.201106>,
<-0.684643,0.415203,-0.599058>,
<-6.900488,-0.845580,-2.422763>,
<-0.684643,0.415203,-0.599058>
}
smooth_triangle {
<-5.684868,3.726043,1.669570>,
<0.993053,0.111137,-0.038665>,
<-5.372864,1.788695,4.114299>,
<0.993053,0.111137,-0.038665>,
<-5.399030,2.161368,4.513460>,
<0.993053,0.111137,-0.038665>
}
smooth_triangle {
<-5.399030,2.161368,4.513460>,
<0.993053,0.111130,-0.038669>,
<-5.726630,4.195589,1.946497>,
<0.993053,0.111130,-0.038669>,
<-5.684868,3.726043,1.669570>,
<0.993053,0.111130,-0.038669>
}
smooth_triangle {
<-5.883990,1.595040,4.126570>,
<0.265101,-0.738947,-0.619418>,
<-5.372864,1.788695,4.114299>,
<0.265101,-0.738947,-0.619418>,
<-5.684868,3.726043,1.669570>,
<0.265101,-0.738947,-0.619418>
}
smooth_triangle {
<-5.684868,3.726043,1.669570>,
<0.265093,-0.738948,-0.619420>,
<-6.211590,3.629261,1.559607>,
<0.265093,-0.738948,-0.619420>,
<-5.883990,1.595040,4.126570>,
<0.265093,-0.738948,-0.619420>
}
smooth_triangle {
<-6.253357,4.098801,1.836528>,
<-0.993053,-0.111127,0.038674>,
<-5.910149,1.967717,4.525728>,
<-0.993053,-0.111127,0.038674>,
<-5.883990,1.595040,4.126570>,
<-0.993053,-0.111127,0.038674>
}
smooth_triangle {
<-5.883990,1.595040,4.126570>,
<-0.993053,-0.111137,0.038663>,
<-6.211590,3.629261,1.559607>,
<-0.993053,-0.111137,0.038663>,
<-6.253357,4.098801,1.836528>,
<-0.993053,-0.111137,0.038663>
}
smooth_triangle {
<-5.726630,4.195589,1.946497>,
<-0.265102,0.738946,0.619419>,
<-5.399030,2.161368,4.513460>,
<-0.265102,0.738946,0.619419>,
<-5.910149,1.967717,4.525728>,
<-0.265102,0.738946,0.619419>
}
smooth_triangle {
<-5.910149,1.967717,4.525728>,
<-0.265105,0.738945,0.619419>,
<-6.253357,4.098801,1.836528>,
<-0.265105,0.738945,0.619419>,
<-5.726630,4.195589,1.946497>,
<-0.265105,0.738945,0.619419>
}
smooth_triangle {
<-2.323307,-0.257013,6.598256>,
<0.741456,0.417435,-0.525348>,
<-1.013404,-3.077887,6.205570>,
<0.741456,0.417435,-0.525348>,
<-0.696584,-3.079889,6.651127>,
<0.741456,0.417435,-0.525348>
}
smooth_triangle {
<-0.696584,-3.079889,6.651127>,
<0.741452,0.417433,-0.525356>,
<-2.071979,-0.117972,7.063441>,
<0.741452,0.417433,-0.525356>,
<-2.323307,-0.257013,6.598256>,
<0.741452,0.417433,-0.525356>
}
smooth_triangle {
<-1.431570,-3.383521,6.380577>,
<-0.361805,-0.038341,-0.931465>,
<-1.013404,-3.077887,6.205570>,
<-0.361805,-0.038341,-0.931465>,
<-2.323307,-0.257013,6.598256>,
<-0.361805,-0.038341,-0.931465>
}
smooth_triangle {
<-2.323307,-0.257013,6.598256>,
<-0.361797,-0.038339,-0.931468>,
<-2.806965,-0.421604,6.792891>,
<-0.361797,-0.038339,-0.931468>,
<-1.431570,-3.383521,6.380577>,
<-0.361797,-0.038339,-0.931468>
}
smooth_triangle {
<-2.555637,-0.282562,7.258081>,
<-0.741449,-0.417433,0.525359>,
<-1.114745,-3.385523,6.826128>,
<-0.741449,-0.417433,0.525359>,
<-1.431570,-3.383521,6.380577>,
<-0.741449,-0.417433,0.525359>
}
smooth_triangle {
<-1.431570,-3.383521,6.380577>,
<-0.741454,-0.417433,0.525353>,
<-2.806965,-0.421604,6.792891>,
<-0.741454,-0.417433,0.525353>,
<-2.555637,-0.282562,7.258081>,
<-0.741454,-0.417433,0.525353>
}
smooth_triangle {
<-2.071979,-0.117972,7.063441>,
<0.361798,0.038339,0.931468>,
<-0.696584,-3.079889,6.651127>,
<0.361798,0.038339,0.931468>,
<-1.114745,-3.385523,6.826128>,
<0.361798,0.038339,0.931468>
}
smooth_triangle {
<-1.114745,-3.385523,6.826128>,
<0.361804,0.038341,0.931465>,
<-2.555637,-0.282562,7.258081>,
<0.361804,0.038341,0.931465>,
<-2.071979,-0.117972,7.063441>,
<0.361804,0.038341,0.931465>
}
smooth_triangle {
<-3.506853,-4.004862,4.547011>,
<0.049103,0.160047,-0.985887>,
<-4.816756,-1.183988,4.939704>,
<0.049103,0.160047,-0.985887>,
<-5.340356,-1.333032,4.889430>,
<0.049103,0.160047,-0.985887>
}
smooth_triangle {
<-5.340356,-1.333032,4.889430>,
<0.049093,0.160040,-0.985889>,
<-3.964961,-4.294949,4.477109>,
<0.049093,0.160040,-0.985889>,
<-3.506853,-4.004862,4.547011>,
<0.049093,0.160040,-0.985889>
}
smooth_triangle {
<-4.774826,-1.153188,5.483940>,
<0.897972,0.430001,-0.093518>,
<-4.816756,-1.183988,4.939704>,
<0.897972,0.430001,-0.093518>,
<-3.506853,-4.004862,4.547011>,
<0.897972,0.430001,-0.093518>
}
smooth_triangle {
<-3.506853,-4.004862,4.547011>,
<0.897973,0.430000,-0.093513>,
<-3.399431,-4.115105,5.071619>,
<0.897973,0.430000,-0.093513>,
<-4.774826,-1.153188,5.483940>,
<0.897973,0.430000,-0.093513>
}
smooth_triangle {
<-3.857538,-4.405195,5.001711>,
<-0.049091,-0.160041,0.985889>,
<-5.298430,-1.302234,5.433673>,
<-0.049091,-0.160041,0.985889>,
<-4.774826,-1.153188,5.483940>,
<-0.049091,-0.160041,0.985889>
}
smooth_triangle {
<-4.774826,-1.153188,5.483940>,
<-0.049102,-0.160044,0.985888>,
<-3.399431,-4.115105,5.071619>,
<-0.049102,-0.160044,0.985888>,
<-3.857538,-4.405195,5.001711>,
<-0.049102,-0.160044,0.985888>
}
smooth_triangle {
<-3.964961,-4.294949,4.477109>,
<-0.897973,-0.430000,0.093509>,
<-5.340356,-1.333032,4.889430>,
<-0.897973,-0.430000,0.093509>,
<-5.298430,-1.302234,5.433673>,
<-0.897973,-0.430000,0.093509>
}
smooth_triangle {
<-5.298430,-1.302234,5.433673>,
<-0.897972,-0.430001,0.093514>,
<-3.857538,-4.405195,5.001711>,
<-0.897972,-0.430001,0.093514>,
<-3.964961,-4.294949,4.477109>,
<-0.897972,-0.430001,0.093514>
}
texture { T_Chrome_4E }

translate < 4,0,50 >

}
matrix <1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0>
scale <1.2,1.2,1.2>
}