// 1.3
// -w320 -h240 +a0.3
// -w512 -h384 +a0.3
// -w800 -h600 +a0.3
// -w1024 -h768 +a0.3
// -w1600 -h1200 +a0.3
// -w2000 -h1500 +a0.3
// -w2400 -h1800 +a0.3
// -w2800 -h2100 +a0.3
// -w3200 -h2400 +a0.3
// 1.25
// -w630 -h504 +a0.3
// -w1280 -h1024 +a0.3
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"

#version 3.5;
#declare Radiosity=off;

global_settings {
  assumed_gamma 2.0
  max_trace_level 5
  
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 80                      // higher -> higher quality (1..1600) [35]
      nearest_count 10              // higher -> higher quality (1..10) [5]
      error_bound 1.0               // higher -> smoother, less accurate [1.8]
      recursion_limit 7             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .4           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1)[0]
      minimum_reuse 0.01            // reuse of old radiosity samples[0.015]
      brightness 1                  // brightness of radiosity effects(0..1) [1]
      adc_bailout 0.01/2
      normal on                     // take surface normals into account [off]
      media on                      // take media into account [off]

    }
  #end  
}

#declare sky_gray =
sky_sphere {
    pigment {
        gradient y
        color_map {
          // [0, 1  color Gray50 color Gray80]
          [0.0 rgb <0.7,0.7,0.7>]
          [1.0 rgb <0.3,0.3,0.3>]
        }
    }
}
#declare sky_white =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.99,0.99,0.99>]
          [1.0 rgb <0.6,0.6,0.6>]
        }
    }
}
#declare sky_peach =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.74902, 0.521569, 0.67451>]
          [1.0 rgb <0.627451, 0.486275, 0.647059>]
        }
    }
}
#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.6,0.7,1.0>]
          [0.7 rgb <0.0,0.1,0.8>]
// light blue           [0.7 rgb <0.4,0.5,0.8>]
        }
    }
}
#declare sky_red =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <1.0,0.6,0.6>]
          [1.0 rgb <0.5,0.0,0.0>]
        }
    }
}
#declare sky_yellow =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.9,0.9,0.4>]
          [1.0 rgb <0.0,0.0,0.0>]
        }
    }
}
#declare sky_green =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.6,0.9,0.6>]
          [0.7 rgb <0.2,0.5,0.2>]
        }
    }
}
#declare sky_indigo =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.6,0.1,0.9>]
          [1.0 rgb <0.2,0.0,0.5>]
        }
    }
}
#declare sky_violet =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.8,0.1,0.9>]
          [1.0 rgb <0.2,0.0,0.3>]
        }
    }
}
#declare bg_water =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "water" once } }
    //beach2 cliffs cliff2 water
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
    scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_beach2 =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "beach2" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_cliffs =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "cliffs" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_cliffs2 =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "cliff2" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_wave =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "wave" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_fire =
plane { < 0.0, 0.0, -1.0 >, -20.0
  texture {
    pigment { image_map { png "fire" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.5 >
    //larger n is bigger
     scale < 34.4, 25.83, 1.0 >
  }
}
// same as F_Glass3
#declare Finsh_Glass =
finish {
  ambient 0.1
  diffuse 0.1
  reflection 0.1
  specular 0.8
  roughness 0.003
  phong 1
  phong_size 400
}

#declare Finsh_Glass2 =
finish {
  roughness 0.001
  ambient 0.1
  diffuse 0.8
  specular 0.8
  reflection {
    0.0, 1.0
    fresnel on
  }
  conserve_energy
}
#declare Interior_Glass =
interior {
  ior 1.5
  // dark glass
  // fade_distance 2.0
  // fade_power 1001
}

#declare II_Glass =
interior {
  ior 1.5
}
#declare G_TextureA=
texture {
  pigment { color rgbf <0.9,0.4,0.4,1> }
  finish { Finsh_Glass }
}
#declare G_TextureB=
texture {
  pigment { color rgbf <0.8039,1.0,0.9275,1> } //69 185 200
//0.4039,0.6588,0.6275
// <0.270588,0.72549,0.784314,1>
  finish { Finsh_Glass }
}
#declare G_TextureC=
texture {
  pigment { color rgbf <0.5,0.9,0.4,0.9> } //96 188 157
  finish { Finsh_Glass }
}
#declare G_TextureC2=
texture {
  pigment { color rgbf <0.906275,1,0.925882,1> } //96 188 157
  // 0.686275,0.784314,0.705882
  finish { Finsh_Glass }
}
#declare G_TextureD=
texture {
  pigment { color rgbf <0.823529,0.823529,0.823529,0.9> }
  finish { Finsh_Glass }
}
#declare G_TextureE=
texture {
  pigment { color rgbf <0.8,1.0,0.8,0.9> }
  finish { Finsh_Glass }
}
#declare T_IM_Warp = 
texture {
  pigment {
   image_map {
     png "warp"
     map_type 0
     //interpolate 2
   }
 }
 finish { ambient 0.85 specular 0.1 diffuse 0.1 }
 //scale < 1, 1, 1 >
rotate < 0, 90, 0 >
}
#declare T_IM_Earth = 
texture {
  pigment {
   image_map {
     png "earth"
     map_type 1
     //interpolate 2
   }
 }
finish { ambient 0.3 specular 0.1 diffuse 0.7 }
}
#declare P_IM_Earth = pigment {
  image_map {
    png "earth"
    map_type 1
    interpolate 2
  }
}
#declare M_TextureA=
texture {
  pigment { color rgb <0.0,0.0,0.4> }
  finish { F_MetalA }
}
#declare M_TextureC=
texture {
  pigment { color rgb <0.9,0.8,0.9> }
  finish { F_MetalC }
}
camera {
location < 0.0,0.0,-60.0 >
look_at < 0.0,0.0,0.0 >
angle 24
}
light_source {
<0.0,15.0,0.0>
color White
spotlight
point_at <0,0,0>
radius 10
falloff 45
}
light_source {
<40,-2.5,-40>
color Gray60
fade_distance 80
fade_power 2
}
light_source {
<-50,25,-50>
color Gray50
fade_distance 80
fade_power 2
}
#declare bg_png_current =
plane { < 0.0,0.0,-1.0 >, -100
texture {
pigment { image_map { png "wave" once } }
finish { ambient 1 diffuse 0 }
translate < -0.5 , -0.5 , 0.0 >
scale < 68.698281 , 51.536595 , 1.0 >
}
}
object { bg_png_current }
sky_sphere { sky_green }
union {
mesh {
smooth_triangle {
<0.000000,0.000000,7.311283>,
<-0.178411,0.309017,0.934172>,
<4.874190,0.000000,5.449509>,
<0.755761,0.309017,0.577350>,
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>
}
smooth_triangle {
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>,
<0.930887,-6.830000,2.437095>,
<0.188492,-0.979432,-0.071997>,
<-2.437095,-4.221172,5.449509>,
<-0.609972,-0.652955,0.448981>
}
smooth_triangle {
<-2.437095,-4.221172,5.449509>,
<-0.609972,-0.652955,0.448981>,
<0.000000,0.000000,7.311283>,
<-0.178411,0.309017,0.934172>,
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>
}
smooth_triangle {
<0.000000,0.000000,7.311283>,
<-0.178411,0.309017,0.934172>,
<-2.437095,-4.221172,5.449509>,
<-0.609972,-0.652955,0.448981>,
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>
}
smooth_triangle {
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>,
<-6.380397,2.608828,2.437095>,
<-0.942459,0.326477,-0.071998>,
<-2.437095,4.221172,5.449509>,
<-0.260489,0.854729,0.448981>
}
smooth_triangle {
<-2.437095,4.221172,5.449509>,
<-0.260489,0.854729,0.448981>,
<0.000000,0.000000,7.311283>,
<-0.178411,0.309017,0.934172>,
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>
}
smooth_triangle {
<0.000000,0.000000,7.311283>,
<-0.178411,0.309017,0.934172>,
<-2.437095,4.221172,5.449509>,
<-0.260489,0.854729,0.448981>,
<0.930887,6.830000,2.437095>,
<-0.188492,0.979432,0.071997>
}
smooth_triangle {
<0.930887,6.830000,2.437095>,
<-0.188492,0.979432,0.071997>,
<5.449509,4.221172,2.437095>,
<0.753967,0.652955,-0.071997>,
<4.874190,0.000000,5.449509>,
<0.755761,0.309017,0.577350>
}
smooth_triangle {
<4.874190,0.000000,5.449509>,
<0.755761,0.309017,0.577350>,
<0.000000,0.000000,7.311283>,
<-0.178411,0.309017,0.934172>,
<0.930887,6.830000,2.437095>,
<-0.188492,0.979432,0.071997>
}
smooth_triangle {
<4.874190,0.000000,5.449509>,
<0.755761,0.309017,0.577350>,
<5.449509,4.221172,2.437095>,
<0.753967,0.652955,-0.071997>,
<6.380397,2.608828,-2.437095>,
<0.609972,0.652955,-0.448981>
}
smooth_triangle {
<6.380397,2.608828,-2.437095>,
<0.609972,0.652955,-0.448981>,
<6.380397,-2.608828,-2.437095>,
<0.654469,-0.326477,-0.681970>,
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>
}
smooth_triangle {
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>,
<4.874190,0.000000,5.449509>,
<0.755761,0.309017,0.577350>,
<6.380397,2.608828,-2.437095>,
<0.609972,0.652955,-0.448981>
}
smooth_triangle {
<-2.437095,-4.221172,5.449509>,
<-0.609972,-0.652955,0.448981>,
<0.930887,-6.830000,2.437095>,
<0.188492,-0.979432,-0.071997>,
<-0.930887,-6.830000,-2.437095>,
<0.110264,-0.809017,-0.577350>
}
smooth_triangle {
<-0.930887,-6.830000,-2.437095>,
<0.110264,-0.809017,-0.577350>,
<-5.449509,-4.221172,-2.437095>,
<-0.609972,-0.403548,-0.681970>,
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>
}
smooth_triangle {
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>,
<-2.437095,-4.221172,5.449509>,
<-0.609972,-0.652955,0.448981>,
<-0.930887,-6.830000,-2.437095>,
<0.110264,-0.809017,-0.577350>
}
smooth_triangle {
<-2.437095,4.221172,5.449509>,
<-0.260489,0.854729,0.448981>,
<-6.380397,2.608828,2.437095>,
<-0.942459,0.326477,-0.071998>,
<-5.449509,4.221172,-2.437095>,
<-0.755761,0.309017,-0.577350>
}
smooth_triangle {
<-5.449509,4.221172,-2.437095>,
<-0.755761,0.309017,-0.577350>,
<-0.930887,6.830000,-2.437095>,
<0.202143,0.840815,-0.502164>,
<0.930887,6.830000,2.437095>,
<-0.188492,0.979432,0.071997>
}
smooth_triangle {
<0.930887,6.830000,2.437095>,
<-0.188492,0.979432,0.071997>,
<-2.437095,4.221172,5.449509>,
<-0.260489,0.854729,0.448981>,
<-5.449509,4.221172,-2.437095>,
<-0.755761,0.309017,-0.577350>
}
smooth_triangle {
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>,
<6.380397,-2.608828,-2.437095>,
<0.654469,-0.326477,-0.681970>,
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>
}
smooth_triangle {
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>,
<-0.930887,-6.830000,-2.437095>,
<0.110264,-0.809017,-0.577350>,
<0.930887,-6.830000,2.437095>,
<0.188492,-0.979432,-0.071997>
}
smooth_triangle {
<0.930887,-6.830000,2.437095>,
<0.188492,-0.979432,-0.071997>,
<5.449509,-4.221172,2.437095>,
<0.866025,-0.500000,0.000000>,
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>
}
smooth_triangle {
<5.449509,4.221172,2.437095>,
<0.753967,0.652955,-0.071997>,
<0.930887,6.830000,2.437095>,
<-0.188492,0.979432,0.071997>,
<-0.930887,6.830000,-2.437095>,
<0.202143,0.840815,-0.502164>
}
smooth_triangle {
<-0.930887,6.830000,-2.437095>,
<0.202143,0.840815,-0.502164>,
<2.437095,4.221172,-5.449509>,
<0.283302,0.245346,-0.927117>,
<6.380397,2.608828,-2.437095>,
<0.609972,0.652955,-0.448981>
}
smooth_triangle {
<6.380397,2.608828,-2.437095>,
<0.609972,0.652955,-0.448981>,
<5.449509,4.221172,2.437095>,
<0.753967,0.652955,-0.071997>,
<-0.930887,6.830000,-2.437095>,
<0.202143,0.840815,-0.502164>
}
smooth_triangle {
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>,
<-5.449509,-4.221172,-2.437095>,
<-0.609972,-0.403548,-0.681970>,
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>
}
smooth_triangle {
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>,
<-5.449509,4.221172,-2.437095>,
<-0.755761,0.309017,-0.577350>,
<-6.380397,2.608828,2.437095>,
<-0.942459,0.326477,-0.071998>
}
smooth_triangle {
<-6.380397,2.608828,2.437095>,
<-0.942459,0.326477,-0.071998>,
<-6.380397,-2.608828,2.437095>,
<-0.866025,-0.500000,-0.000000>,
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>
}
smooth_triangle {
<6.380397,-2.608828,-2.437095>,
<0.654469,-0.326477,-0.681970>,
<6.380397,2.608828,-2.437095>,
<0.609972,0.652955,-0.448981>,
<2.437095,4.221172,-5.449509>,
<0.283302,0.245346,-0.927117>
}
smooth_triangle {
<2.437095,4.221172,-5.449509>,
<0.283302,0.245346,-0.927117>,
<0.000000,0.000000,-7.311283>,
<-0.356822,0.000000,-0.934172>,
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>
}
smooth_triangle {
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>,
<6.380397,-2.608828,-2.437095>,
<0.654469,-0.326477,-0.681970>,
<2.437095,4.221172,-5.449509>,
<0.283302,0.245346,-0.927117>
}
smooth_triangle {
<-5.449509,-4.221172,-2.437095>,
<-0.609972,-0.403548,-0.681970>,
<-0.930887,-6.830000,-2.437095>,
<0.110264,-0.809017,-0.577350>,
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>
}
smooth_triangle {
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>,
<0.000000,0.000000,-7.311283>,
<-0.356822,0.000000,-0.934172>,
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>
}
smooth_triangle {
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>,
<-5.449509,-4.221172,-2.437095>,
<-0.609972,-0.403548,-0.681970>,
<2.437095,-4.221172,-5.449509>,
<0.070825,-0.368020,-0.927117>
}
smooth_triangle {
<-0.930887,6.830000,-2.437095>,
<0.202143,0.840815,-0.502164>,
<-5.449509,4.221172,-2.437095>,
<-0.755761,0.309017,-0.577350>,
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>
}
smooth_triangle {
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>,
<0.000000,0.000000,-7.311283>,
<-0.356822,0.000000,-0.934172>,
<2.437095,4.221172,-5.449509>,
<0.283302,0.245346,-0.927117>
}
smooth_triangle {
<2.437095,4.221172,-5.449509>,
<0.283302,0.245346,-0.927117>,
<-0.930887,6.830000,-2.437095>,
<0.202143,0.840815,-0.502164>,
<-4.874190,0.000000,-5.449509>,
<-0.354127,0.122673,-0.927117>
}
texture { G_TextureD }
interior { Interior_Glass caustics 1 }
translate < 0,0,0 >
}
matrix <1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0>
}
