// -w320 -h240 +a0.3
// -w512 -h384 +a0.3
// -w800 -h600 +a0.3
// -w1024 -h768 +a0.3
// -w1280 -h1024 +a0.3
// -w1600 -h1200 +a0.3
// -w2000 -h1500 +a0.3
// -w2400 -h1800 +a0.3
// -w2800 -h2100 +a0.3
// -w3200 -h2400 +a0.3
// 1.3
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"

#version 3.5;
#declare Radiosity=off;

global_settings {
  assumed_gamma 2.0
  max_trace_level 5
  
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 80
      nearest_count 10
      error_bound 1.0
      recursion_limit 7
      low_error_factor .4
      gray_threshold 0.0
      minimum_reuse 0.01
      brightness 1
      adc_bailout 0.01/2
      normal on

    }
  #end  
}
#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
          // [0, 1  color Gray50 color Gray80]
          [0.0 rgb <0.6,0.7,1.0>]
          [0.7 rgb <0.0,0.1,0.8>]
        }
    }
}
camera {
  location <0, 9, -20>
  look_at <0,0,0>
  angle 67.38
}
  //location <0, 135, -300> 
  //e $angle2(0 9 -20,0 0 -1) = 24.227745317954245
#declare bg_water =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "water" once } }
    //beach2 cliffs cliff2 water
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
    scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_beach2 =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "beach2" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_cliffs =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "cliffs" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_cliffs2 =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "cliff2" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
/*
plane { < 0, 0.45, -1 >, -15
  //e $angle2(0 0.45 -1,0 0 -1) = 24.227745317954071 same as cam,
  //(0.450000000000001 = cam 15th dp)
  texture {
    pigment { image_map { png "water" once } }
    //beach2 cliffs cliff2 water
    finish { ambient 1 diffuse 0 }
    //translate < -0.5, -0.5 > scale < 50, 50 >

    //full 1 to 1 bg
    //more negative y = down
    translate < -0.5, -0.68 >
       
    //larger n is bigger
    scale < 49.2, 33.8, 1.0 >
    //at this angle, smaller sucks up the bottom

  }
} */

light_source { <0, 100, 0> color White
    spotlight
    point_at <0,0,0>
    radius 10
    falloff 110
}
light_source {<40,-2.5,-40> color Gray60
 fade_distance 80 fade_power 2
}

light_source {<-50, 25, -50> color Gray50
     fade_distance 80 fade_power 2
}

// same as F_Glass3
#declare Finsh_Glass =
finish {
  ambient 0.1
  diffuse 0.1
  reflection 0.1
  specular 0.8
  roughness 0.003
  phong 1
  phong_size 400
}

#declare Finsh_Glass2 =
finish {
  roughness 0.001
  ambient 0.1
  diffuse 0.8
  specular 0.8
  reflection {
    0.0, 1.0
    fresnel on
  }
  conserve_energy
}
#declare Interior_Glass =
interior {
  ior 1.5
  // dark glass
  // fade_distance 2.0
  // fade_power 1001
}

#declare II_Glass =
interior {
  ior 1.5
}
#declare G_TextureA=
texture {
  pigment { color rgbf <0.9,0.4,0.4,1> }
  finish { Finsh_Glass }
}
#declare G_TextureB=
texture {
  pigment { color rgbf <0.270588,0.72549,0.784314,1> } //69 185 200
  finish { Finsh_Glass }
}
#declare G_TextureC=
texture {
  pigment { color rgbf <0.5,0.9,0.4,0.9> } //96 188 157
  finish { Finsh_Glass }
}
#declare G_TextureC2=
texture {
  pigment { color rgbf <0.906275,1,0.925882,1> } //96 188 157
  // 0.686275,0.784314,0.705882
  finish { Finsh_Glass }
}
#declare G_TextureD=
texture {
  pigment { color rgbf <0.823529,0.823529,0.823529,0.9> }
  finish { Finsh_Glass }
}
// interior { Interior_Glass caustics 1 }
#declare P_IM_Earth = pigment {
  image_map {
    png "earth"
    map_type 1
    interpolate 2
  }
}

#declare M_TextureA=
texture {
  pigment { color rgb <0.0,0.0,0.4> }
  finish { F_MetalA }
}
#declare M_TextureC=
texture {
  pigment { color rgb <0.9,0.8,0.9> }
  finish { F_MetalC }
}
#declare Floorchkr =
plane { y,-300
  pigment {
    checker rgb 1, rgb .5
    scale 7
    rotate <0, 40, 0>
  }
  finish {
    ambient 0.5
    diffuse 0.3
  }
}
#declare Floor1 =
plane { z,8.0
    texture { T_Chrome_2C
    }
    finish {
      ambient 0.2
      diffuse 0.8
   }
}
#declare fl_blue =
plane {
  y, -20.0
  texture {
    pigment {
      bozo
      color_map {

        [ 0.0 color rgb<0.321, 0.274, 0.356> ]
        [ 0.1 color rgb<0.500, 0.500, 0.611> ]
        [ 0.4 color rgb<0.623, 0.623, 0.745> ]
        [ 1.0 color rgb<0.782, 0.745, 0.837> ]
      }
      warp { turbulence 0.6 }
    }
    finish {
      diffuse 0.6
      ambient 0.25
      specular 0.1
      conserve_energy
    }
  }
}
#declare fl_red =
plane {
  y, -20.0
  texture {
    pigment {
      bozo
      color_map {
        [ 0.0 color rgb<0.356, 0.321, 0.274> ]
        [ 0.1 color rgb<0.611, 0.500, 0.500> ]
        [ 0.4 color rgb<0.745, 0.623, 0.623> ]
        [ 1.0 color rgb<0.837, 0.782, 0.745> ]
      }
      warp { turbulence 0.6 }
    }
    finish {
      diffuse 0.6
      ambient 0.1
      specular 0.2
      reflection {
        0.2, 0.6
        fresnel on
      }
      conserve_energy
    }
  }
}
#declare fl_green =
plane {
  y, -20.0
  texture {
    pigment {
      bozo
      color_map {

 // greenish more detail
        [ 0.0 color rgb<0.321, 0.356, 0.274> ]
        [ 0.1 color rgb<0.500, 0.611, 0.500> ]
        [ 0.4 color rgb<0.623, 0.745, 0.623> ]
        [ 1.0 color rgb<0.782, 0.837, 0.745> ]
      }
      warp { turbulence 0.6 }
    }
    finish {
      diffuse 0.6
      ambient 0.25
      specular 0.1
      conserve_energy
    }
  }
}
#declare fl_chrome2c =
  plane { y,-12.8 texture { T_Chrome_2C }
}
// 5 blue
//object { Floor3 }
// 6 red
// 7 green
sky_sphere { sky_blue }
object { bg_water }
mesh {
smooth_triangle {
<-3.6877,8.0377,-3.8229>,
<-0.2008,0.7032,-0.682>,
<0.3611,9.504,1.537>,
<0.3881,0.9165,0.0975>,
<-2.1289,6.2215,7.0412>,
<0.0259,0.439,0.8981>
}
smooth_triangle {
<-2.1289,6.2215,7.0412>,
<0.0259,0.439,0.8981>,
<-7.7166,2.7265,5.0831>,
<-0.6518,-0.0248,0.758>,
<-8.68,3.849,-1.6312>,
<-0.9809,-0.0043,-0.1943>
}
smooth_triangle {
<-8.68,3.849,-1.6312>,
<-0.9809,-0.0043,-0.1943>,
<-3.6877,8.0377,-3.8229>,
<-0.2008,0.7032,-0.682>,
<-2.1289,6.2215,7.0412>,
<0.0259,0.439,0.8981>
}
smooth_triangle {
<-3.6877,8.0377,-3.8229>,
<-0.1848,0.9745,-0.127>,
<-8.68,3.849,-1.6312>,
<-0.9109,0.3653,0.1918>,
<-8.0047,-2.1576,-4.9078>,
<-0.8127,-0.5083,-0.2848>
}
smooth_triangle {
<-8.0047,-2.1576,-4.9078>,
<-0.8127,-0.5083,-0.2848>,
<-2.5952,-1.6812,-9.1245>,
<-0.1719,-0.5529,-0.8153>,
<0.0729,4.6198,-8.454>,
<0.3745,0.2913,-0.8803>
}
smooth_triangle {
<0.0729,4.6198,-8.454>,
<0.3745,0.2913,-0.8803>,
<-3.6877,8.0377,-3.8229>,
<-0.1848,0.9745,-0.127>,
<-8.0047,-2.1576,-4.9078>,
<-0.8127,-0.5083,-0.2848>
}
smooth_triangle {
<-3.6877,8.0377,-3.8229>,
<-0.6871,0.6604,-0.303>,
<0.0729,4.6198,-8.454>,
<-0.1401,0.1633,-0.9766>,
<6.4459,3.9738,-5.9563>,
<0.6518,0.0248,-0.758>
}
smooth_triangle {
<6.4459,3.9738,-5.9563>,
<0.6518,0.0248,-0.758>,
<6.624,6.9923,0.2185>,
<0.9064,0.3976,0.143>,
<0.3611,9.504,1.537>,
<0.0908,0.8367,0.5401>
}
smooth_triangle {
<0.3611,9.504,1.537>,
<0.0908,0.8367,0.5401>,
<-3.6877,8.0377,-3.8229>,
<-0.6871,0.6604,-0.303>,
<6.4459,3.9738,-5.9563>,
<0.6518,0.0248,-0.758>
}
smooth_triangle {
<0.3611,9.504,1.537>,
<-0.0223,0.9685,-0.2481>,
<6.624,6.9923,0.2185>,
<0.8498,0.4635,-0.2511>,
<8.0047,2.1576,4.9078>,
<0.9809,0.0043,0.1943>
}
smooth_triangle {
<8.0047,2.1576,4.9078>,
<0.9809,0.0043,0.1943>,
<2.5952,1.6812,9.1245>,
<0.321,-0.2336,0.9178>,
<-2.1289,6.2215,7.0412>,
<-0.5675,0.5796,0.5848>
}
smooth_triangle {
<-2.1289,6.2215,7.0412>,
<-0.5675,0.5796,0.5848>,
<0.3611,9.504,1.537>,
<-0.0223,0.9685,-0.2481>,
<8.0047,2.1576,4.9078>,
<0.9809,0.0043,0.1943>
}
smooth_triangle {
<-8.68,3.849,-1.6312>,
<-0.6677,0.7354,-0.1156>,
<-7.7166,2.7265,5.0831>,
<-0.4952,0.345,0.7973>,
<-6.4459,-3.9738,5.9563>,
<-0.3622,-0.4774,0.8006>
}
smooth_triangle {
<-6.4459,-3.9738,5.9563>,
<-0.3622,-0.4774,0.8006>,
<-6.624,-6.9923,-0.2185>,
<-0.3518,-0.9306,0.1015>,
<-8.0047,-2.1576,-4.9078>,
<-0.6071,-0.0921,-0.7893>
}
smooth_triangle {
<-8.0047,-2.1576,-4.9078>,
<-0.6071,-0.0921,-0.7893>,
<-8.68,3.849,-1.6312>,
<-0.6677,0.7354,-0.1156>,
<-6.4459,-3.9738,5.9563>,
<-0.3622,-0.4774,0.8006>
}
smooth_triangle {
<0.0729,4.6198,-8.454>,
<-0.3607,0.5862,-0.7255>,
<-2.5952,-1.6812,-9.1245>,
<-0.5395,-0.4055,-0.7379>,
<2.1289,-6.2215,-7.0412>,
<0.0982,-0.8736,-0.4766>
}
smooth_triangle {
<2.1289,-6.2215,-7.0412>,
<0.0982,-0.8736,-0.4766>,
<7.7166,-2.7265,-5.0831>,
<0.9516,-0.2501,-0.1784>,
<6.4459,3.9738,-5.9563>,
<0.4909,0.777,-0.394>
}
smooth_triangle {
<6.4459,3.9738,-5.9563>,
<0.4909,0.777,-0.394>,
<0.0729,4.6198,-8.454>,
<-0.3607,0.5862,-0.7255>,
<2.1289,-6.2215,-7.0412>,
<0.0982,-0.8736,-0.4766>
}
smooth_triangle {
<-2.1289,6.2215,7.0412>,
<-0.2112,0.8786,0.4284>,
<2.5952,1.6812,9.1245>,
<0.6141,0.0122,0.7892>,
<-0.0729,-4.6198,8.454>,
<0.0996,-0.7602,0.642>
}
smooth_triangle {
<-0.0729,-4.6198,8.454>,
<0.0996,-0.7602,0.642>,
<-6.4459,-3.9738,5.9563>,
<-0.8966,-0.3871,0.2151>,
<-7.7166,2.7265,5.0831>,
<-0.9109,0.3653,0.1918>
}
smooth_triangle {
<-7.7166,2.7265,5.0831>,
<-0.9109,0.3653,0.1918>,
<-2.1289,6.2215,7.0412>,
<-0.2112,0.8786,0.4284>,
<-0.0729,-4.6198,8.454>,
<0.0996,-0.7602,0.642>
}
smooth_triangle {
<6.624,6.9923,0.2185>,
<0.3881,0.9165,0.0975>,
<6.4459,3.9738,-5.9563>,
<0.3474,0.581,-0.7361>,
<7.7166,-2.7265,-5.0831>,
<0.5762,-0.6288,-0.5221>
}
smooth_triangle {
<7.7166,-2.7265,-5.0831>,
<0.5762,-0.6288,-0.5221>,
<8.68,-3.849,1.6312>,
<0.6851,-0.6015,0.4109>,
<8.0047,2.1576,4.9078>,
<0.5081,0.4915,0.7073>
}
smooth_triangle {
<8.0047,2.1576,4.9078>,
<0.5081,0.4915,0.7073>,
<6.624,6.9923,0.2185>,
<0.3881,0.9165,0.0975>,
<7.7166,-2.7265,-5.0831>,
<0.5762,-0.6288,-0.5221>
}
smooth_triangle {
<-8.0047,-2.1576,-4.9078>,
<-0.8755,0.1518,-0.4587>,
<-6.624,-6.9923,-0.2185>,
<-0.5725,-0.7299,0.3734>,
<-0.3611,-9.504,-1.537>,
<0.2799,-0.9587,0.0508>
}
smooth_triangle {
<-0.3611,-9.504,-1.537>,
<0.2799,-0.9587,0.0508>,
<2.1289,-6.2215,-7.0412>,
<0.4633,-0.2673,-0.8449>,
<-2.5952,-1.6812,-9.1245>,
<-0.1401,0.1633,-0.9766>
}
smooth_triangle {
<-2.5952,-1.6812,-9.1245>,
<-0.1401,0.1633,-0.9766>,
<-8.0047,-2.1576,-4.9078>,
<-0.8755,0.1518,-0.4587>,
<-0.3611,-9.504,-1.537>,
<0.2799,-0.9587,0.0508>
}
smooth_triangle {
<2.5952,1.6812,9.1245>,
<0.0259,0.439,0.8981>,
<8.0047,2.1576,4.9078>,
<0.7395,0.5655,0.3653>,
<8.68,-3.849,1.6312>,
<0.8139,-0.5427,-0.2075>
}
smooth_triangle {
<8.68,-3.849,1.6312>,
<0.8139,-0.5427,-0.2075>,
<3.6877,-8.0377,3.8229>,
<0.1848,-0.9745,0.127>,
<-0.0729,-4.6198,8.454>,
<-0.3622,-0.4774,0.8006>
}
smooth_triangle {
<-0.0729,-4.6198,8.454>,
<-0.3622,-0.4774,0.8006>,
<2.5952,1.6812,9.1245>,
<0.0259,0.439,0.8981>,
<8.68,-3.849,1.6312>,
<0.8139,-0.5427,-0.2075>
}
smooth_triangle {
<-6.624,-6.9923,-0.2185>,
<-0.8127,-0.5083,-0.2848>,
<-6.4459,-3.9738,5.9563>,
<-0.9256,-0.1292,0.3558>,
<-0.0729,-4.6198,8.454>,
<0.0273,-0.1172,0.9927>
}
smooth_triangle {
<-0.0729,-4.6198,8.454>,
<0.0273,-0.1172,0.9927>,
<3.6877,-8.0377,3.8229>,
<0.6871,-0.6604,0.303>,
<-0.3611,-9.504,-1.537>,
<0.0982,-0.8736,-0.4766>
}
smooth_triangle {
<-0.3611,-9.504,-1.537>,
<0.0982,-0.8736,-0.4766>,
<-6.624,-6.9923,-0.2185>,
<-0.8127,-0.5083,-0.2848>,
<-0.0729,-4.6198,8.454>,
<0.0273,-0.1172,0.9927>
}
smooth_triangle {
<7.7166,-2.7265,-5.0831>,
<0.9256,0.1292,-0.3558>,
<2.1289,-6.2215,-7.0412>,
<0.1896,-0.2396,-0.9522>,
<-0.3611,-9.504,-1.537>,
<-0.4023,-0.8895,-0.2166>
}
smooth_triangle {
<-0.3611,-9.504,-1.537>,
<-0.4023,-0.8895,-0.2166>,
<3.6877,-8.0377,3.8229>,
<0.2008,-0.7032,0.682>,
<8.68,-3.849,1.6312>,
<0.7787,-0.2307,0.5834>
}
smooth_triangle {
<8.68,-3.849,1.6312>,
<0.7787,-0.2307,0.5834>,
<7.7166,-2.7265,-5.0831>,
<0.9256,0.1292,-0.3558>,
<-0.3611,-9.504,-1.537>,
<-0.4023,-0.8895,-0.2166>
}
texture { G_TextureB }
interior { Interior_Glass caustics 1 }
}
