// -w320 -h240 +a0.3
// -w512 -h384 +a0.3
// -w800 -h600 +a0.3
// -w1024 -h768 +a0.3
// -w1280 -h1024 +a0.3
// -w1600 -h1200 +a0.3
// -w2000 -h1500 +a0.3
// -w2400 -h1800 +a0.3
// -w2800 -h2100 +a0.3
// -w3200 -h2400 +a0.3
// 1.3
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"

#version 3.5;
#declare Radiosity=off;

global_settings {
  assumed_gamma 2.0
  max_trace_level 5
  
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 80
      nearest_count 10
      error_bound 1.0
      recursion_limit 7
      low_error_factor .4
      gray_threshold 0.0
      minimum_reuse 0.01
      brightness 1
      adc_bailout 0.01/2
      normal on

    }
  #end  
}
#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
          // [0, 1  color Gray50 color Gray80]
          [0.0 rgb <0.6,0.7,1.0>]
          [0.7 rgb <0.0,0.1,0.8>]
        }
    }
}
camera {
  location <0, 9, -20>
  look_at <0,0,0>
  angle 67.38
}
  //location <0, 135, -300> 
  //e $angle2(0 9 -20,0 0 -1) = 24.227745317954245
#declare bg_water =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "water" once } }
    //beach2 cliffs cliff2 water
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
    scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_beach2 =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "beach2" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_cliffs =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "cliffs" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
#declare bg_cliffs2 =
plane { < 0, 0.45, -1 >, -15
  texture {
    pigment { image_map { png "cliff2" once } }
    finish { ambient 1 diffuse 0 }
    //more negative y = down
    translate < -0.5, -0.68 >
    //larger n is bigger
     scale < 49.3, 33.9, 1.0 >
  }
}
/*
plane { < 0, 0.45, -1 >, -15
  //e $angle2(0 0.45 -1,0 0 -1) = 24.227745317954071 same as cam,
  //(0.450000000000001 = cam 15th dp)
  texture {
    pigment { image_map { png "water" once } }
    //beach2 cliffs cliff2 water
    finish { ambient 1 diffuse 0 }
    //translate < -0.5, -0.5 > scale < 50, 50 >

    //full 1 to 1 bg
    //more negative y = down
    translate < -0.5, -0.68 >
       
    //larger n is bigger
    scale < 49.2, 33.8, 1.0 >
    //at this angle, smaller sucks up the bottom

  }
} */

light_source { <0, 100, 0> color White
    spotlight
    point_at <0,0,0>
    radius 10
    falloff 110
}
light_source {<40,-2.5,-40> color Gray60
 fade_distance 80 fade_power 2
}

light_source {<-50, 25, -50> color Gray50
     fade_distance 80 fade_power 2
}

// same as F_Glass3
#declare Finsh_Glass =
finish {
  ambient 0.1
  diffuse 0.1
  reflection 0.1
  specular 0.8
  roughness 0.003
  phong 1
  phong_size 400
}

#declare Finsh_Glass2 =
finish {
  roughness 0.001
  ambient 0.1
  diffuse 0.8
  specular 0.8
  reflection {
    0.0, 1.0
    fresnel on
  }
  conserve_energy
}
#declare Interior_Glass =
interior {
  ior 1.5
  // dark glass
  // fade_distance 2.0
  // fade_power 1001
}

#declare II_Glass =
interior {
  ior 1.5
}
#declare G_TextureA=
texture {
  pigment { color rgbf <0.9,0.4,0.4,1> }
  finish { Finsh_Glass }
}
#declare G_TextureB=
texture {
  pigment { color rgbf <0.270588,0.72549,0.784314,1> } //69 185 200
  finish { Finsh_Glass }
}
#declare G_TextureC=
texture {
  pigment { color rgbf <0.5,0.9,0.4,0.9> } //96 188 157
  finish { Finsh_Glass }
}
#declare G_TextureC2=
texture {
  pigment { color rgbf <0.906275,1,0.925882,1> } //96 188 157
  // 0.686275,0.784314,0.705882
  finish { Finsh_Glass }
}
#declare G_TextureD=
texture {
  pigment { color rgbf <0.823529,0.823529,0.823529,0.9> }
  finish { Finsh_Glass }
}
// interior { Interior_Glass caustics 1 }
#declare P_IM_Earth = pigment {
  image_map {
    png "earth"
    map_type 1
    interpolate 2
  }
}

#declare M_TextureA=
texture {
  pigment { color rgb <0.0,0.0,0.4> }
  finish { F_MetalA }
}
#declare M_TextureC=
texture {
  pigment { color rgb <0.9,0.8,0.9> }
  finish { F_MetalC }
}
#declare Floorchkr =
plane { y,-300
  pigment {
    checker rgb 1, rgb .5
    scale 7
    rotate <0, 40, 0>
  }
  finish {
    ambient 0.5
    diffuse 0.3
  }
}
#declare Floor1 =
plane { z,8.0
    texture { T_Chrome_2C
    }
    finish {
      ambient 0.2
      diffuse 0.8
   }
}
#declare Floor5 =
plane {
  y, -20.0
  texture {
    pigment {
      bozo
      color_map {

        [ 0.0 color rgb<0.321, 0.274, 0.356> ]
        [ 0.1 color rgb<0.500, 0.500, 0.611> ]
        [ 0.4 color rgb<0.623, 0.623, 0.745> ]
        [ 1.0 color rgb<0.782, 0.745, 0.837> ]
      }
      warp { turbulence 0.6 }
    }
    finish {
      diffuse 0.6
      ambient 0.25
      specular 0.1
      conserve_energy
    }
  }
}
#declare Floor6 =
plane {
  y, -6.0
  texture {
    pigment {
      bozo
      color_map {
        [ 0.0 color rgb<0.356, 0.321, 0.274> ]
        [ 0.1 color rgb<0.611, 0.500, 0.500> ]
        [ 0.4 color rgb<0.745, 0.623, 0.623> ]
        [ 1.0 color rgb<0.837, 0.782, 0.745> ]
      }
      warp { turbulence 0.6 }
    }
    finish {
      diffuse 0.6
      ambient 0.1
      specular 0.2
      reflection {
        0.2, 0.6
        fresnel on
      }
      conserve_energy
    }
  }
}
#declare Floor7 =
plane {
  y, -7.0
  texture {
    pigment {
      bozo
      color_map {

 // greenish more detail
        [ 0.0 color rgb<0.321, 0.356, 0.274> ]
        [ 0.1 color rgb<0.500, 0.611, 0.500> ]
        [ 0.4 color rgb<0.623, 0.745, 0.623> ]
        [ 1.0 color rgb<0.782, 0.837, 0.745> ]
      }
      warp { turbulence 0.6 }
    }
    finish {
      diffuse 0.6
      ambient 0.25
      specular 0.1
      conserve_energy
    }
  }
}
#declare Floor3 =
  plane { y,-12.8 texture { T_Chrome_2C }
}
// 5 blue
//object { Floor3 }
// 6 red
// 7 green
sky_sphere { sky_blue }
object { bg_beach2 }
mesh {
smooth_triangle {
<0.0,0,9.6342>,
<0.1784,-0.309,-0.9342>,
<6.4228,0,7.1809>,
<-0.7558,-0.309,-0.5774>,
<7.1809,5.5623,3.2114>,
<-0.866,0.5,0.0>
}
smooth_triangle {
<7.1809,5.5623,3.2114>,
<-0.866,0.5,0.0>,
<1.2266,9,3.2114>,
<-0.1885,0.9794,0.072>,
<-3.2114,5.5623,7.1809>,
<0.61,0.653,-0.449>
}
smooth_triangle {
<-3.2114,5.5623,7.1809>,
<0.61,0.653,-0.449>,
<0.0,0,9.6342>,
<0.1784,-0.309,-0.9342>,
<7.1809,5.5623,3.2114>,
<-0.866,0.5,0.0>
}
smooth_triangle {
<0.0,0,9.6342>,
<-0.3568,0,-0.9342>,
<-3.2114,5.5623,7.1809>,
<0.1103,0.809,-0.5774>,
<-8.4076,3.4377,3.2114>,
<0.866,0.5,0.0>
}
smooth_triangle {
<-8.4076,3.4377,3.2114>,
<0.866,0.5,0.0>,
<-8.4076,-3.4377,3.2114>,
<0.9425,-0.3265,0.072>,
<-3.2114,-5.5623,7.1809>,
<0.2605,-0.8547,-0.449>
}
smooth_triangle {
<-3.2114,-5.5623,7.1809>,
<0.2605,-0.8547,-0.449>,
<0.0,0,9.6342>,
<-0.3568,0,-0.9342>,
<-8.4076,3.4377,3.2114>,
<0.866,0.5,0.0>
}
smooth_triangle {
<0.0,0,9.6342>,
<0.1784,0.309,-0.9342>,
<-3.2114,-5.5623,7.1809>,
<0.6455,-0.5,-0.5774>,
<1.2266,-9,3.2114>,
<0.1885,-0.9794,-0.072>
}
smooth_triangle {
<1.2266,-9,3.2114>,
<0.1885,-0.9794,-0.072>,
<7.1809,-5.5623,3.2114>,
<-0.754,-0.653,0.072>,
<6.4228,0,7.1809>,
<-0.8705,0.2018,-0.449>
}
smooth_triangle {
<6.4228,0,7.1809>,
<-0.8705,0.2018,-0.449>,
<0.0,0,9.6342>,
<0.1784,0.309,-0.9342>,
<1.2266,-9,3.2114>,
<0.1885,-0.9794,-0.072>
}
smooth_triangle {
<6.4228,0,7.1809>,
<-0.3495,-0.2018,-0.915>,
<7.1809,-5.5623,3.2114>,
<-0.4935,-0.8547,-0.161>,
<8.4076,-3.4377,-3.2114>,
<-0.61,-0.653,0.449>
}
smooth_triangle {
<8.4076,-3.4377,-3.2114>,
<-0.61,-0.653,0.449>,
<8.4076,3.4377,-3.2114>,
<-0.6545,0.3265,0.682>,
<7.1809,5.5623,3.2114>,
<-0.4417,0.765,-0.4687>
}
smooth_triangle {
<7.1809,5.5623,3.2114>,
<-0.4417,0.765,-0.4687>,
<6.4228,0,7.1809>,
<-0.3495,-0.2018,-0.915>,
<8.4076,-3.4377,-3.2114>,
<-0.61,-0.653,0.449>
}
smooth_triangle {
<-3.2114,5.5623,7.1809>,
<0.0,0.4035,-0.915>,
<1.2266,9,3.2114>,
<-0.4935,0.8547,-0.161>,
<-1.2266,9,-3.2114>,
<-0.1103,0.809,0.5774>
}
smooth_triangle {
<-1.2266,9,-3.2114>,
<-0.1103,0.809,0.5774>,
<-7.1809,5.5623,-3.2114>,
<0.61,0.4035,0.682>,
<-8.4076,3.4377,3.2114>,
<0.8833,0,-0.4687>
}
smooth_triangle {
<-8.4076,3.4377,3.2114>,
<0.8833,0,-0.4687>,
<-3.2114,5.5623,7.1809>,
<0.0,0.4035,-0.915>,
<-1.2266,9,-3.2114>,
<-0.1103,0.809,0.5774>
}
smooth_triangle {
<-3.2114,-5.5623,7.1809>,
<0.3495,-0.2018,-0.915>,
<-8.4076,-3.4377,3.2114>,
<0.987,0,-0.161>,
<-7.1809,-5.5623,-3.2114>,
<0.7558,-0.309,0.5774>
}
smooth_triangle {
<-7.1809,-5.5623,-3.2114>,
<0.7558,-0.309,0.5774>,
<-1.2266,-9,-3.2114>,
<-0.2021,-0.8408,0.5022>,
<1.2266,-9,3.2114>,
<-0.3936,-0.6817,-0.6167>
}
smooth_triangle {
<1.2266,-9,3.2114>,
<-0.3936,-0.6817,-0.6167>,
<-3.2114,-5.5623,7.1809>,
<0.3495,-0.2018,-0.915>,
<-7.1809,-5.5623,-3.2114>,
<0.7558,-0.309,0.5774>
}
smooth_triangle {
<7.1809,5.5623,3.2114>,
<-0.6709,0.368,-0.6438>,
<8.4076,3.4377,-3.2114>,
<-0.843,0,0.538>,
<3.2114,5.5623,-7.1809>,
<-0.0708,0.368,0.9271>
}
smooth_triangle {
<3.2114,5.5623,-7.1809>,
<-0.0708,0.368,0.9271>,
<-1.2266,9,-3.2114>,
<0.4989,0.8642,0.0651>,
<1.2266,9,3.2114>,
<0.1103,0.809,-0.5774>
}
smooth_triangle {
<1.2266,9,3.2114>,
<0.1103,0.809,-0.5774>,
<7.1809,5.5623,3.2114>,
<-0.6709,0.368,-0.6438>,
<3.2114,5.5623,-7.1809>,
<-0.0708,0.368,0.9271>
}
smooth_triangle {
<7.1809,-5.5623,3.2114>,
<-0.7558,-0.309,-0.5774>,
<1.2266,-9,3.2114>,
<0.0167,-0.765,-0.6438>,
<-1.2266,-9,-3.2114>,
<0.4215,-0.73,0.538>
}
smooth_triangle {
<-1.2266,-9,-3.2114>,
<0.4215,-0.73,0.538>,
<3.2114,-5.5623,-7.1809>,
<-0.2833,-0.2453,0.9271>,
<8.4076,-3.4377,-3.2114>,
<-0.9979,0,0.0651>
}
smooth_triangle {
<8.4076,-3.4377,-3.2114>,
<-0.9979,0,0.0651>,
<7.1809,-5.5623,3.2114>,
<-0.7558,-0.309,-0.5774>,
<-1.2266,-9,-3.2114>,
<0.4215,-0.73,0.538>
}
smooth_triangle {
<-8.4076,3.4377,3.2114>,
<0.6541,0.397,-0.6438>,
<-7.1809,5.5623,-3.2114>,
<0.4215,0.73,0.538>,
<-6.4228,0,-7.1809>,
<0.3541,-0.1227,0.9271>
}
smooth_triangle {
<-6.4228,0,-7.1809>,
<0.3541,-0.1227,0.9271>,
<-7.1809,-5.5623,-3.2114>,
<0.4989,-0.8642,0.0651>,
<-8.4076,-3.4377,3.2114>,
<0.6455,-0.5,-0.5774>
}
smooth_triangle {
<-8.4076,-3.4377,3.2114>,
<0.6455,-0.5,-0.5774>,
<-8.4076,3.4377,3.2114>,
<0.6541,0.397,-0.6438>,
<-6.4228,0,-7.1809>,
<0.3541,-0.1227,0.9271>
}
smooth_triangle {
<8.4076,3.4377,-3.2114>,
<-0.866,0.5,0.0>,
<8.4076,-3.4377,-3.2114>,
<-0.9168,-0.397,-0.0438>,
<3.2114,-5.5623,-7.1809>,
<0.0445,-0.73,0.682>
}
smooth_triangle {
<3.2114,-5.5623,-7.1809>,
<0.0445,-0.73,0.682>,
<0.0,0,-9.6342>,
<0.3568,0,0.9342>,
<3.2114,5.5623,-7.1809>,
<-0.1103,0.809,0.5774>
}
smooth_triangle {
<3.2114,5.5623,-7.1809>,
<-0.1103,0.809,0.5774>,
<8.4076,3.4377,-3.2114>,
<-0.866,0.5,0.0>,
<3.2114,-5.5623,-7.1809>,
<0.0445,-0.73,0.682>
}
smooth_triangle {
<-7.1809,5.5623,-3.2114>,
<0.866,0.5,0.0>,
<-1.2266,9,-3.2114>,
<0.2758,0.9554,-0.1053>,
<3.2114,5.5623,-7.1809>,
<-0.6271,0.5955,0.5022>
}
smooth_triangle {
<3.2114,5.5623,-7.1809>,
<-0.6271,0.5955,0.5022>,
<0.0,0,-9.6342>,
<-0.1784,-0.309,0.9342>,
<-6.4228,0,-7.1809>,
<0.7558,-0.309,0.5774>
}
smooth_triangle {
<-6.4228,0,-7.1809>,
<0.7558,-0.309,0.5774>,
<-7.1809,5.5623,-3.2114>,
<0.866,0.5,0.0>,
<3.2114,5.5623,-7.1809>,
<-0.6271,0.5955,0.5022>
}
smooth_triangle {
<-1.2266,-9,-3.2114>,
<-0.2758,-0.9554,0.1053>,
<-7.1809,-5.5623,-3.2114>,
<0.6895,-0.7166,-0.1053>,
<-6.4228,0,-7.1809>,
<0.8292,0.2453,0.5022>
}
smooth_triangle {
<-6.4228,0,-7.1809>,
<0.8292,0.2453,0.5022>,
<0.0,0,-9.6342>,
<-0.1784,0.309,0.9342>,
<3.2114,-5.5623,-7.1809>,
<-0.6493,-0.2389,0.7221>
}
smooth_triangle {
<3.2114,-5.5623,-7.1809>,
<-0.6493,-0.2389,0.7221>,
<-1.2266,-9,-3.2114>,
<-0.2758,-0.9554,0.1053>,
<-6.4228,0,-7.1809>,
<0.8292,0.2453,0.5022>
}
texture { G_TextureB }
interior { Interior_Glass caustics 1 }
matrix <1.0,0.0,0.0,0.0,0.983844,0.17903,0.0,-0.17903,0.983844,0,0,0>
}
